{"vars":[{"name":"base","containerName":"","kind":2,"line":89},{"signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":92,"kind":13},{"kind":13,"line":92,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":95,"kind":13},{"kind":13,"line":96,"containerName":"new","name":"$self"},{"line":96,"kind":13,"name":"$class","containerName":"new"},{"line":97,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":98,"containerName":"new","name":"$self"}],"line":91,"kind":12,"range":{"end":{"character":9999,"line":99},"start":{"line":91,"character":0}},"name":"new"},{"containerName":"main::","definition":"sub","detail":"($fth,$locfac,$seqid,$source)","signature":{"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)","parameters":[{"label":"$fth"},{"label":"$locfac"},{"label":"$seqid"},{"label":"$source"}],"label":"_generic_seqfeature($fth,$locfac,$seqid,$source)"},"kind":12,"line":115,"children":[{"definition":"my","name":"$fth","containerName":"_generic_seqfeature","localvar":"my","kind":13,"line":116},{"name":"$locfac","containerName":"_generic_seqfeature","line":116,"kind":13},{"containerName":"_generic_seqfeature","name":"$seqid","line":116,"kind":13},{"name":"$source","containerName":"_generic_seqfeature","kind":13,"line":116},{"kind":13,"line":117,"definition":"my","name":"$sf","containerName":"_generic_seqfeature","localvar":"my"},{"line":120,"kind":13,"containerName":"_generic_seqfeature","name":"$source"},{"kind":13,"line":121,"containerName":"_generic_seqfeature","name":"$source"},{"line":125,"kind":13,"name":"$sf","containerName":"_generic_seqfeature"},{"name":"direct_new","containerName":"_generic_seqfeature","kind":12,"line":125},{"containerName":"_generic_seqfeature","name":"$loc","definition":"my","localvar":"my","kind":13,"line":131},{"kind":13,"line":133,"name":"$loc","containerName":"_generic_seqfeature"},{"containerName":"_generic_seqfeature","name":"$locfac","line":133,"kind":13},{"name":"from_string","containerName":"_generic_seqfeature","kind":12,"line":133},{"containerName":"_generic_seqfeature","name":"$fth","kind":13,"line":133},{"kind":12,"line":133,"name":"loc","containerName":"_generic_seqfeature"},{"name":"$loc","containerName":"_generic_seqfeature","kind":13,"line":136},{"kind":13,"line":137,"name":"$fth","containerName":"_generic_seqfeature"},{"name":"warn","containerName":"_generic_seqfeature","line":137,"kind":12},{"kind":13,"line":137,"name":"$fth","containerName":"_generic_seqfeature"},{"line":137,"kind":12,"name":"loc","containerName":"_generic_seqfeature"},{"name":"$fth","containerName":"_generic_seqfeature","kind":13,"line":139},{"name":"key","containerName":"_generic_seqfeature","line":139,"kind":12},{"kind":13,"line":139,"containerName":"_generic_seqfeature","name":"$seqid"},{"name":"$seqid","containerName":"_generic_seqfeature","kind":13,"line":144},{"kind":13,"line":144,"name":"$loc","containerName":"_generic_seqfeature"},{"name":"is_remote","containerName":"_generic_seqfeature","line":144,"kind":12},{"kind":13,"line":145,"name":"$loc","containerName":"_generic_seqfeature"},{"name":"seq_id","containerName":"_generic_seqfeature","kind":12,"line":145},{"containerName":"_generic_seqfeature","name":"$seqid","kind":13,"line":145},{"line":150,"kind":13,"name":"$sf","containerName":"_generic_seqfeature"},{"kind":12,"line":150,"containerName":"_generic_seqfeature","name":"location"},{"kind":13,"line":150,"containerName":"_generic_seqfeature","name":"$loc"},{"line":151,"kind":13,"containerName":"_generic_seqfeature","name":"$sf"},{"containerName":"_generic_seqfeature","name":"primary_tag","line":151,"kind":12},{"kind":13,"line":151,"containerName":"_generic_seqfeature","name":"$fth"},{"line":151,"kind":12,"containerName":"_generic_seqfeature","name":"key"},{"line":152,"kind":13,"name":"$sf","containerName":"_generic_seqfeature"},{"line":152,"kind":12,"containerName":"_generic_seqfeature","name":"source_tag"},{"line":152,"kind":13,"name":"$source","containerName":"_generic_seqfeature"},{"containerName":"_generic_seqfeature","name":"$sf","kind":13,"line":153},{"containerName":"_generic_seqfeature","name":"seq_id","kind":12,"line":153},{"kind":13,"line":153,"containerName":"_generic_seqfeature","name":"$seqid"},{"kind":13,"line":154,"definition":"my","name":"$key","containerName":"_generic_seqfeature","localvar":"my"},{"containerName":"_generic_seqfeature","name":"$fth","line":154,"kind":13},{"containerName":"_generic_seqfeature","name":"field","kind":12,"line":154}],"name":"_generic_seqfeature","range":{"end":{"character":9999,"line":154},"start":{"character":0,"line":115}}},{"line":125,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"containerName":null,"definition":"my","name":"$value","localvar":"my","kind":13,"line":155},{"line":155,"kind":13,"name":"$fth","containerName":null},{"name":"field","containerName":"main::","line":155,"kind":12},{"containerName":null,"name":"%key","line":155,"kind":13},{"name":"$sf","containerName":null,"line":156,"kind":13},{"line":156,"kind":12,"name":"add_tag_value","containerName":"main::"},{"kind":13,"line":156,"name":"$key","containerName":null},{"line":156,"kind":13,"containerName":null,"name":"$value"},{"kind":13,"line":159,"name":"$sf","containerName":null},{"containerName":"main::","definition":"sub","detail":"($sf,$context_annseq)","signature":{"label":"from_SeqFeature($sf,$context_annseq)","parameters":[{"label":"$sf"},{"label":"$context_annseq"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features"},"kind":12,"line":179,"children":[{"kind":13,"line":180,"definition":"my","name":"$sf","containerName":"from_SeqFeature","localvar":"my"},{"name":"$context_annseq","containerName":"from_SeqFeature","kind":13,"line":180},{"containerName":"from_SeqFeature","name":"@ret","definition":"my","localvar":"my","kind":13,"line":181},{"name":"$sf","containerName":"from_SeqFeature","kind":13,"line":189},{"kind":12,"line":189,"name":"can","containerName":"from_SeqFeature"},{"kind":13,"line":190,"containerName":"from_SeqFeature","name":"$sf"},{"kind":12,"line":190,"containerName":"from_SeqFeature","name":"to_FTHelper"},{"line":190,"kind":13,"name":"$context_annseq","containerName":"from_SeqFeature"},{"kind":13,"line":193,"containerName":"from_SeqFeature","name":"$fth","definition":"my","localvar":"my"},{"kind":12,"line":193,"containerName":"from_SeqFeature","name":"new"},{"containerName":"from_SeqFeature","name":"$key","definition":"my","localvar":"my","kind":13,"line":194},{"kind":13,"line":194,"containerName":"from_SeqFeature","name":"$sf"},{"name":"primary_tag","containerName":"from_SeqFeature","line":194,"kind":12},{"definition":"my","name":"$locstr","containerName":"from_SeqFeature","localvar":"my","kind":13,"line":195},{"line":195,"kind":13,"containerName":"from_SeqFeature","name":"$sf"},{"name":"location","containerName":"from_SeqFeature","line":195,"kind":12},{"line":195,"kind":12,"containerName":"from_SeqFeature","name":"to_FTstring"},{"containerName":"from_SeqFeature","name":"$fth","line":207,"kind":13},{"line":207,"kind":12,"name":"loc","containerName":"from_SeqFeature"},{"line":207,"kind":13,"name":"$locstr","containerName":"from_SeqFeature"},{"kind":13,"line":208,"name":"$fth","containerName":"from_SeqFeature"},{"kind":12,"line":208,"containerName":"from_SeqFeature","name":"key"},{"containerName":"from_SeqFeature","name":"$key","kind":13,"line":208},{"line":209,"kind":13,"name":"$fth","containerName":"from_SeqFeature"},{"line":209,"kind":12,"containerName":"from_SeqFeature","name":"field"},{"containerName":"from_SeqFeature","name":"$sf","kind":13,"line":212},{"containerName":"from_SeqFeature","name":"can","line":212,"kind":12},{"name":"$sf","containerName":"from_SeqFeature","kind":13,"line":212},{"kind":12,"line":212,"containerName":"from_SeqFeature","name":"score"},{"containerName":"from_SeqFeature","name":"$fth","kind":13,"line":212},{"kind":12,"line":212,"containerName":"from_SeqFeature","name":"field"},{"kind":13,"line":213,"name":"$sf","containerName":"from_SeqFeature"},{"line":213,"kind":12,"containerName":"from_SeqFeature","name":"score"}],"name":"from_SeqFeature","range":{"start":{"character":0,"line":179},"end":{"line":213,"character":9999}}},{"containerName":"SeqIO::FTHelper","name":"Bio","kind":12,"line":193},{"containerName":null,"name":"$sf","line":214,"kind":13},{"containerName":"main::","name":"can","line":214,"kind":12},{"kind":13,"line":214,"name":"$sf","containerName":null},{"kind":12,"line":214,"containerName":"main::","name":"frame"},{"line":214,"kind":13,"name":"$fth","containerName":null},{"name":"field","containerName":"main::","kind":12,"line":214},{"containerName":null,"name":"$sf","kind":13,"line":215},{"containerName":"main::","name":"frame","line":215,"kind":12},{"kind":13,"line":218,"containerName":null,"definition":"my","name":"$tag","localvar":"my"},{"line":218,"kind":13,"containerName":null,"name":"$sf"},{"name":"get_all_tags","containerName":"main::","line":218,"kind":12},{"kind":13,"line":221,"name":"$tag","containerName":null},{"name":"$fth","containerName":null,"line":222,"kind":13},{"line":222,"kind":12,"containerName":"main::","name":"field"},{"containerName":null,"name":"%tag","line":222,"kind":13},{"kind":13,"line":223,"containerName":null,"name":"$fth"},{"line":223,"kind":12,"containerName":"main::","name":"field"},{"line":223,"kind":13,"containerName":null,"name":"@tag"},{"line":225,"kind":13,"localvar":"my","definition":"my","name":"$val","containerName":null},{"containerName":null,"name":"$sf","line":225,"kind":13},{"kind":12,"line":225,"containerName":"main::","name":"get_tag_values"},{"name":"%tag","containerName":null,"line":225,"kind":13},{"kind":13,"line":226,"name":"$fth","containerName":null},{"containerName":"main::","name":"field","kind":12,"line":226},{"line":226,"kind":13,"name":"$tag","containerName":null},{"name":"$val","containerName":null,"line":226,"kind":13},{"kind":13,"line":229,"containerName":null,"name":"@ret"},{"name":"$fth","containerName":null,"line":229,"kind":13},{"containerName":null,"name":"@ret","kind":13,"line":231},{"kind":13,"line":232,"name":"$context_annseq","containerName":null},{"line":232,"kind":12,"name":"throw","containerName":"main::"},{"localvar":"my","containerName":null,"name":"$ft","definition":"my","line":234,"kind":13},{"name":"@ret","containerName":null,"line":234,"kind":13},{"name":"$ft","containerName":null,"kind":13,"line":235},{"kind":12,"line":235,"containerName":"main::","name":"isa"},{"containerName":null,"name":"$sf","line":236,"kind":13},{"kind":12,"line":236,"containerName":"main::","name":"throw"},{"name":"@ret","containerName":null,"kind":13,"line":240},{"name":"key","range":{"start":{"character":0,"line":256},"end":{"character":9999,"line":263}},"kind":12,"line":256,"children":[{"line":257,"kind":13,"localvar":"my","definition":"my","name":"$obj","containerName":"key"},{"name":"$value","containerName":"key","line":257,"kind":13},{"name":"$value","containerName":"key","kind":13,"line":258},{"containerName":"key","name":"$obj","line":259,"kind":13},{"line":259,"kind":13,"containerName":"key","name":"$value"},{"containerName":"key","name":"$obj","kind":13,"line":261}],"containerName":"main::","definition":"sub","detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)","label":"key($obj,$value)"}},{"range":{"start":{"character":0,"line":277},"end":{"line":283,"character":9999}},"name":"loc","line":277,"children":[{"line":278,"kind":13,"localvar":"my","containerName":"loc","name":"$obj","definition":"my"},{"name":"$value","containerName":"loc","kind":13,"line":278},{"containerName":"loc","name":"$value","line":279,"kind":13},{"name":"$obj","containerName":"loc","kind":13,"line":280},{"name":"$value","containerName":"loc","kind":13,"line":280},{"kind":13,"line":282,"containerName":"loc","name":"$obj"}],"kind":12,"detail":"($obj,$value)","signature":{"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"loc($obj,$value)"},"containerName":"main::","definition":"sub"},{"detail":"($self)","signature":{"label":"field($self)","documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)\n\n\n\nsub loc {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'loc'} = $value;\n    }\n    return $obj->{'loc'};\n}\n\n\n=head2 field\n\n Title   : field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":298,"children":[{"kind":13,"line":299,"containerName":"field","name":"$self","definition":"my","localvar":"my"},{"line":301,"kind":13,"containerName":"field","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":302},"start":{"character":0,"line":298}},"name":"field"},{"range":{"start":{"line":316,"character":0},"end":{"character":9999,"line":322}},"name":"add_field","line":316,"children":[{"line":317,"kind":13,"localvar":"my","containerName":"add_field","name":"$self","definition":"my"},{"kind":13,"line":317,"name":"$key","containerName":"add_field"},{"line":317,"kind":13,"containerName":"add_field","name":"$val"},{"kind":13,"line":319,"containerName":"add_field","name":"$self"},{"kind":12,"line":319,"name":"field","containerName":"add_field"},{"line":319,"kind":13,"containerName":"add_field","name":"$key"},{"containerName":"add_field","name":"$self","line":320,"kind":13},{"containerName":"add_field","name":"field","kind":12,"line":320},{"line":320,"kind":13,"name":"$key","containerName":"add_field"},{"name":"$self","containerName":"add_field","kind":13,"line":322},{"kind":12,"line":322,"containerName":"add_field","name":"field"},{"line":322,"kind":13,"containerName":"add_field","name":"$key"}],"kind":12,"detail":"($self,$key,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$val"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)\n\n\n\nsub loc {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'loc'} = $value;\n    }\n    return $obj->{'loc'};\n}\n\n\n=head2 field\n\n Title   : field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub field {\n   my ($self) = @_;\n\n   return $self->{'_field'};\n}\n\n=head2 add_field\n\n Title   : add_field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"add_field($self,$key,$val)"},"containerName":"main::","definition":"sub"},{"kind":13,"line":322,"name":"$val","containerName":null}],"version":5}