{"version":5,"vars":[{"kind":2,"line":93,"name":"base","containerName":""},{"kind":12,"children":[{"kind":13,"line":111,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","line":111,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":113},{"line":115,"kind":13,"localvar":"my","name":"$fact","definition":"my","containerName":"new"},{"name":"new","containerName":"new","kind":12,"line":115},{"name":"@args","containerName":"new","line":118,"kind":13},{"kind":13,"line":118,"name":"$fact","containerName":"new"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":120},{"name":"$class","containerName":"new","line":120,"kind":13},{"line":120,"kind":13,"name":"@args","containerName":"new"},{"line":122,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$primary"},{"name":"$hit","containerName":"new","line":122,"kind":13},{"name":"$query","containerName":"new","line":122,"kind":13},{"line":122,"kind":13,"containerName":"new","name":"$fea1"},{"name":"$source","containerName":"new","kind":13,"line":122},{"kind":13,"line":122,"containerName":"new","name":"$sbjct"},{"containerName":"new","name":"$self","kind":13,"line":123},{"name":"_rearrange","containerName":"new","kind":12,"line":123},{"kind":13,"line":129,"name":"@args","containerName":"new"},{"line":131,"kind":13,"containerName":"new","name":"$sbjct"},{"name":"$hit","containerName":"new","kind":13,"line":134},{"name":"$hit","containerName":"new","kind":13,"line":134},{"line":134,"kind":13,"containerName":"new","name":"$sbjct"},{"containerName":"new","name":"$self","kind":13,"line":136},{"line":136,"kind":12,"name":"warn","containerName":"new"},{"kind":13,"line":141,"containerName":"new","name":"$self"},{"line":141,"kind":12,"name":"query","containerName":"new"},{"containerName":"new","name":"$query","kind":13,"line":141},{"name":"$query","containerName":"new","kind":13,"line":141},{"containerName":"new","name":"$fea1","line":141,"kind":13},{"containerName":"new","name":"$hit","kind":13,"line":142},{"containerName":"new","name":"$self","line":142,"kind":13},{"containerName":"new","name":"hit","kind":12,"line":142},{"containerName":"new","name":"$hit","line":142,"kind":13},{"name":"$primary","containerName":"new","kind":13,"line":145},{"line":145,"kind":13,"name":"$self","containerName":"new"},{"line":145,"kind":12,"name":"primary_tag","containerName":"new"},{"line":146,"kind":13,"containerName":"new","name":"$primary"},{"kind":13,"line":146,"name":"$primary","containerName":"new"},{"name":"$self","containerName":"new","line":147,"kind":13},{"containerName":"new","name":"primary_tag","line":147,"kind":12},{"name":"$primary","containerName":"new","kind":13,"line":147},{"kind":13,"line":150,"name":"$source","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":150},{"kind":12,"line":150,"containerName":"new","name":"source_tag"},{"line":150,"kind":13,"containerName":"new","name":"$source"},{"name":"$self","containerName":"new","line":152,"kind":13}],"line":110,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","name":"new","range":{"end":{"line":153,"character":9999},"start":{"character":0,"line":110}}},{"line":115,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"containerName":"new","name":"SUPER","line":120,"kind":12},{"kind":12,"children":[{"containerName":"query","name":"feature1","line":173,"kind":12}],"line":172,"name":"query","definition":"sub","containerName":"main::","range":{"start":{"line":172,"character":0},"end":{"character":9999,"line":174}}},{"definition":"sub","name":"subject","containerName":"main::","range":{"start":{"line":191,"character":0},"end":{"line":195,"character":9999}},"kind":12,"children":[{"kind":13,"line":192,"containerName":"subject","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":194,"name":"$self","containerName":"subject"},{"containerName":"subject","name":"hit","kind":12,"line":194}],"line":191},{"kind":12,"children":[{"line":210,"kind":12,"name":"feature2","containerName":"hit"}],"line":209,"name":"hit","definition":"sub","containerName":"main::","range":{"start":{"line":209,"character":0},"end":{"line":211,"character":9999}}},{"name":"source_tag","range":{"start":{"character":0,"line":225},"end":{"character":9999,"line":232}},"kind":12,"children":[{"containerName":"source_tag","name":"$self","definition":"my","localvar":"my","kind":13,"line":226},{"kind":13,"line":226,"name":"@args","containerName":"source_tag"},{"line":228,"kind":13,"name":"@args","containerName":"source_tag"},{"line":229,"kind":13,"containerName":"source_tag","name":"$self"},{"containerName":"source_tag","name":"hit","line":229,"kind":12},{"kind":12,"line":229,"containerName":"source_tag","name":"source_tag"},{"name":"@args","containerName":"source_tag","line":229,"kind":13},{"containerName":"source_tag","name":"$self","line":231,"kind":13},{"name":"query","containerName":"source_tag","line":231,"kind":12},{"containerName":"source_tag","name":"source_tag","kind":12,"line":231},{"kind":13,"line":231,"containerName":"source_tag","name":"@args"}],"line":225,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string","parameters":[{"label":"$self"},{"label":"@args"}],"label":"source_tag($self,@args)"},"detail":"($self,@args)"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : ","label":"significance($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":247,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"significance"},{"name":"@args","containerName":"significance","kind":13,"line":247},{"kind":13,"line":249,"name":"@args","containerName":"significance"},{"kind":13,"line":250,"name":"$self","containerName":"significance"},{"containerName":"significance","name":"hit","kind":12,"line":250},{"containerName":"significance","name":"significance","line":250,"kind":12},{"line":250,"kind":13,"name":"@args","containerName":"significance"},{"kind":13,"line":252,"containerName":"significance","name":"$self"},{"name":"query","containerName":"significance","kind":12,"line":252},{"line":252,"kind":12,"name":"significance","containerName":"significance"},{"kind":13,"line":252,"containerName":"significance","name":"@args"}],"line":246,"kind":12,"range":{"start":{"character":0,"line":246},"end":{"character":9999,"line":253}},"name":"significance"},{"signature":{"label":"score($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : \n\n\n\nsub significance {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->significance(@args);\n    }\n    return $self->query()->significance(@args);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $obj->score();\n           $obj->score($value);\n Function: \n Returns : \n Args    : "},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"score","localvar":"my","kind":13,"line":268},{"containerName":"score","name":"@args","line":268,"kind":13},{"line":270,"kind":13,"name":"@args","containerName":"score"},{"kind":13,"line":271,"name":"$self","containerName":"score"},{"containerName":"score","name":"hit","line":271,"kind":12},{"name":"score","containerName":"score","kind":12,"line":271},{"containerName":"score","name":"@args","kind":13,"line":271},{"name":"$self","containerName":"score","kind":13,"line":276},{"containerName":"score","name":"query","kind":12,"line":276},{"containerName":"score","name":"score","kind":12,"line":276},{"kind":13,"line":276,"name":"@args","containerName":"score"}],"line":267,"kind":12,"range":{"end":{"character":9999,"line":277},"start":{"line":267,"character":0}},"name":"score"},{"range":{"start":{"line":291,"character":0},"end":{"line":298,"character":9999}},"name":"bits","line":291,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"bits","line":292,"kind":13},{"name":"@args","containerName":"bits","line":292,"kind":13},{"kind":13,"line":294,"name":"@args","containerName":"bits"},{"kind":13,"line":295,"name":"$self","containerName":"bits"},{"containerName":"bits","name":"hit","kind":12,"line":295},{"kind":12,"line":295,"containerName":"bits","name":"bits"},{"containerName":"bits","name":"@args","kind":13,"line":295},{"kind":13,"line":297,"containerName":"bits","name":"$self"},{"line":297,"kind":12,"name":"query","containerName":"bits"},{"name":"bits","containerName":"bits","kind":12,"line":297},{"name":"@args","containerName":"bits","line":297,"kind":13}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : \n\n\n\nsub significance {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->significance(@args);\n    }\n    return $self->query()->significance(@args);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $obj->score();\n           $obj->score($value);\n Function: \n Returns : \n Args    : \n\n\n\nsub score {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->score(@args);\n    }\n    # Note: You might think it's only getting set on the hit object.\n    # Actually, it's getting set on both hit and query.\n\n    return $self->query()->score(@args);\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : $bits = $obj->bits();\n           $obj->bits($value);\n Function: \n Returns : \n Args    : ","label":"bits($self,@args)"},"containerName":"main::","definition":"sub"}]}