{"vars":[{"kind":2,"line":92,"name":"base","containerName":""},{"kind":13,"line":94,"containerName":"main::","definition":"our","name":"@ARGNAMES"},{"children":[{"definition":"my","name":"$proto","containerName":"new","localvar":"my","kind":13,"line":123},{"kind":13,"line":123,"containerName":"new","name":"@args"},{"kind":13,"line":125,"containerName":"new","definition":"my","name":"$pkg","localvar":"my"},{"line":125,"kind":13,"containerName":"new","name":"$proto"},{"kind":13,"line":125,"containerName":"new","name":"$proto"},{"kind":13,"line":127,"containerName":"new","definition":"my","name":"%args","localvar":"my"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":129},{"name":"$pkg","containerName":"new","line":129,"kind":13},{"line":131,"kind":13,"name":"@args","containerName":"new"},{"name":"@ARGNAMES","containerName":"new","kind":13,"line":131},{"name":"$self","containerName":"new","line":131,"kind":13},{"containerName":"new","name":"_rearrange","line":131,"kind":12},{"line":131,"kind":13,"name":"@ARGNAMES","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":131},{"kind":13,"line":133,"name":"$args","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":135},{"kind":13,"line":135,"name":"$self","containerName":"new"},{"name":"primary_tag","containerName":"new","line":135,"kind":12},{"kind":13,"line":135,"name":"$args","containerName":"new"},{"kind":13,"line":136,"containerName":"new","name":"$args"},{"containerName":"new","name":"$self","kind":13,"line":136},{"name":"source_tag","containerName":"new","kind":12,"line":136},{"kind":13,"line":136,"containerName":"new","name":"$args"},{"containerName":"new","name":"$args","kind":13,"line":137},{"kind":13,"line":137,"name":"$self","containerName":"new"},{"line":137,"kind":12,"name":"seqname","containerName":"new"},{"containerName":"new","name":"$args","line":137,"kind":13},{"name":"$args","containerName":"new","line":138,"kind":13},{"line":138,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":138,"containerName":"new","name":"seq"},{"name":"$args","containerName":"new","line":138,"kind":13},{"containerName":"new","name":"$args","kind":13,"line":139},{"name":"$self","containerName":"new","kind":13,"line":139},{"line":139,"kind":12,"containerName":"new","name":"annotation"},{"line":139,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","name":"$args","line":140,"kind":13},{"line":140,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":140,"name":"location","containerName":"new"},{"line":140,"kind":13,"name":"$args","containerName":"new"},{"kind":13,"line":141,"containerName":"new","name":"$args"},{"name":"$self","containerName":"new","line":141,"kind":13},{"kind":12,"line":141,"containerName":"new","name":"start"},{"line":141,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","name":"$args","line":142,"kind":13},{"line":142,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":142,"containerName":"new","name":"end"},{"kind":13,"line":142,"containerName":"new","name":"$args"},{"kind":13,"line":143,"containerName":"new","name":"$args"},{"name":"$self","containerName":"new","kind":13,"line":143},{"name":"strand","containerName":"new","line":143,"kind":12},{"kind":13,"line":143,"containerName":"new","name":"$args"},{"containerName":"new","name":"$args","kind":13,"line":144},{"line":144,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"score","kind":12,"line":144},{"line":144,"kind":13,"name":"$args","containerName":"new"},{"containerName":"new","name":"$args","line":146,"kind":13},{"localvar":"my","containerName":"new","name":"$t","definition":"my","line":147,"kind":13},{"line":147,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","name":"$self","kind":13,"line":148},{"name":"add_tag_value","containerName":"new","line":148,"kind":12},{"name":"$t","containerName":"new","line":148,"kind":13},{"containerName":"new","name":"$args","kind":13,"line":148},{"line":148,"kind":13,"name":"$t","containerName":"new"}],"line":122,"kind":12,"signature":{"documentation":"1;\n# $Id: Oligo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Oligo - Perl object for small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Oligo;\n\n  my $oligo = Bio::SeqFeature::SiRNA::Oligo->\n      new( -seq\t\t=> 'AUGCCGAUUGCAAGUCAGATT',\n\t   -start \t=> 10,\n\t   -end\t\t=> 31,\n\t   -strand\t=> -1,\n\t   -primary\t=> 'SiRNA::Oligo',\n\t   -source_tag\t=> 'Bio::Tools::SiRNA',\n\t   -tag\t\t=> { note => 'A note' }, );\n\n  # normally two complementary Oligos are combined in an SiRNA::Pair\n  # object\n  $pair->antisense($oligo);\n\n\n=head1 DESCRIPTION\n\nObject methods for single SiRNA oligos - inherits\nL<Bio::SeqFeature::Generic>.  Does B<not> include methods for designing\nSiRNAs - see L<Bio::Tools::SiRNA> for that.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Oligo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\nour @ARGNAMES = qw(SEQ START END STRAND PRIMARY SOURCE_TAG SCORE TAG \n                   SEQ_ID ANNOTATION LOCATION);\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_oligo = Bio::SeqFeature::SiRNA::Oligo->new();\n  Function\t: Create a new SiRNA::Oligo object\n  Returns\t: Bio::Tools::SiRNA object\n  Args    \t: -seq\t\t  sequence of the RNAi oligo.  Should be in RNA alphabet\n                                  except for the final TT overhang.\n                  -start          start position\n \t \t  -end            end position\n \t \t  -strand         strand\n \t \t  -primary        primary tag - defaults to 'SiRNA::Oligo'\n \t \t  -source         source tag\n \t \t  -score          score value\n \t \t  -tag            a reference to a tag/value hash\n \t \t  -seq_id         the display name of the sequence\n \t \t  -annotation     the AnnotationCollectionI object\n \t \t  -location       the LocationI object\n\nCurrently passing arguments in gff_string or gff1_string is not\nsupported.  SiRNA::Oligo objects are typically created by a design\nalgorithm such as Bio::Tools::SiRNA","parameters":[{"label":"$proto"},{"label":"@args"}],"label":"new($proto,@args)"},"detail":"($proto,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":122,"character":0},"end":{"character":9999,"line":150}},"name":"new"},{"kind":12,"line":129,"containerName":"new","name":"SUPER"},{"name":"$self","containerName":null,"kind":13,"line":152},{"name":"seq","range":{"start":{"character":0,"line":170},"end":{"line":183,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"seq($self,$seq)","documentation":"1;\n# $Id: Oligo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Oligo - Perl object for small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Oligo;\n\n  my $oligo = Bio::SeqFeature::SiRNA::Oligo->\n      new( -seq\t\t=> 'AUGCCGAUUGCAAGUCAGATT',\n\t   -start \t=> 10,\n\t   -end\t\t=> 31,\n\t   -strand\t=> -1,\n\t   -primary\t=> 'SiRNA::Oligo',\n\t   -source_tag\t=> 'Bio::Tools::SiRNA',\n\t   -tag\t\t=> { note => 'A note' }, );\n\n  # normally two complementary Oligos are combined in an SiRNA::Pair\n  # object\n  $pair->antisense($oligo);\n\n\n=head1 DESCRIPTION\n\nObject methods for single SiRNA oligos - inherits\nL<Bio::SeqFeature::Generic>.  Does B<not> include methods for designing\nSiRNAs - see L<Bio::Tools::SiRNA> for that.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Oligo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\nour @ARGNAMES = qw(SEQ START END STRAND PRIMARY SOURCE_TAG SCORE TAG \n                   SEQ_ID ANNOTATION LOCATION);\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_oligo = Bio::SeqFeature::SiRNA::Oligo->new();\n  Function\t: Create a new SiRNA::Oligo object\n  Returns\t: Bio::Tools::SiRNA object\n  Args    \t: -seq\t\t  sequence of the RNAi oligo.  Should be in RNA alphabet\n                                  except for the final TT overhang.\n                  -start          start position\n \t \t  -end            end position\n \t \t  -strand         strand\n \t \t  -primary        primary tag - defaults to 'SiRNA::Oligo'\n \t \t  -source         source tag\n \t \t  -score          score value\n \t \t  -tag            a reference to a tag/value hash\n \t \t  -seq_id         the display name of the sequence\n \t \t  -annotation     the AnnotationCollectionI object\n \t \t  -location       the LocationI object\n\nCurrently passing arguments in gff_string or gff1_string is not\nsupported.  SiRNA::Oligo objects are typically created by a design\nalgorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my (%args);\n\n    my $self = $pkg->SUPER::new();\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Oligo';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'SEQ'}\t\t&& $self->seq($args{'SEQ'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t ( keys %{ $args{'TAG'} } ) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n    return $self;\n}\n\n=head2 seq\n\n  Title\t\t: Seq\n  Usage\t\t: my $oligo_sequence = $sirna_oligo->seq();\n  Purpose\t: Get/set the sequence of the RNAi oligo\n  Returns \t: Sequence for the RNAi oligo\n  Args\t\t: Sequence of the RNAi oligo (optional)\n  Note\t\t: Overloads Bio::SeqFeature::Generic seq method - the oligo and \n                  parent sequences are different. \n                  Note that all but the last 2 nucleotides are RNA (per Tuschl and colleagues).\n                  SiRNA::Pair objects are typically created by a design algorithm such as\n                  Bio::Tools::SiRNA.","parameters":[{"label":"$self"},{"label":"$seq"}]},"detail":"($self,$seq)","kind":12,"children":[{"line":171,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"seq"},{"kind":13,"line":171,"name":"$seq","containerName":"seq"},{"containerName":"seq","name":"$seq","line":172,"kind":13},{"containerName":"seq","name":"$seq","line":174,"kind":13},{"kind":13,"line":179,"name":"$self","containerName":"seq"},{"name":"$seq","containerName":"seq","kind":13,"line":179},{"containerName":"seq","name":"$self","line":182,"kind":13}],"line":170}],"version":5}