{"vars":[{"name":"base","containerName":"","line":96,"kind":2},{"name":"new","range":{"start":{"line":98,"character":0},"end":{"character":9999,"line":118}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"","label":"new($caller,@args)"},"detail":"($caller,@args)","kind":12,"children":[{"containerName":"new","name":"$caller","definition":"my","localvar":"my","kind":13,"line":99},{"name":"@args","containerName":"new","kind":13,"line":99},{"kind":13,"line":100,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$caller","kind":13,"line":100},{"line":100,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":102,"name":"$feature","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$location","kind":13,"line":102},{"kind":13,"line":102,"containerName":"new","name":"$self"},{"line":102,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":102},{"kind":13,"line":104,"containerName":"new","name":"$feature"},{"line":104,"kind":13,"containerName":"new","name":"$feature"},{"line":104,"kind":13,"name":"$feature","containerName":"new"},{"name":"isa","containerName":"new","kind":12,"line":104},{"containerName":"new","name":"$self","line":105,"kind":13},{"name":"throw","containerName":"new","line":105,"kind":12},{"name":"$feature","containerName":"new","kind":13,"line":108},{"name":"isa","containerName":"new","kind":12,"line":108},{"containerName":"new","name":"$feature","kind":13,"line":109},{"name":"$feature","containerName":"new","line":109,"kind":13},{"line":109,"kind":12,"containerName":"new","name":"parent"},{"kind":13,"line":112,"name":"$location","containerName":"new"},{"name":"$location","containerName":"new","line":112,"kind":13},{"containerName":"new","name":"$location","kind":13,"line":112},{"kind":12,"line":112,"name":"isa","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":113},{"kind":12,"line":113,"name":"throw","containerName":"new"},{"kind":13,"line":117,"containerName":"new","name":"$self"}],"line":98},{"name":"SUPER","containerName":"new","kind":12,"line":100},{"range":{"end":{"character":9999,"line":148},"start":{"line":133,"character":0}},"name":"location","line":133,"children":[{"containerName":"location","name":"$self","definition":"my","localvar":"my","kind":13,"line":134},{"name":"$value","containerName":"location","kind":13,"line":134},{"name":"$value","containerName":"location","line":136,"kind":13},{"kind":13,"line":137,"name":"$value","containerName":"location"},{"containerName":"location","name":"$value","line":137,"kind":13},{"name":"isa","containerName":"location","kind":12,"line":137},{"containerName":"location","name":"$self","kind":13,"line":138},{"line":138,"kind":12,"containerName":"location","name":"throw"},{"kind":13,"line":141,"name":"$self","containerName":"location"},{"containerName":"location","name":"$value","kind":13,"line":141},{"kind":13,"line":143,"containerName":"location","name":"$self"},{"line":145,"kind":13,"containerName":"location","name":"$self"},{"containerName":"location","name":"new","line":145,"kind":12},{"name":"$self","containerName":"location","kind":13,"line":147}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"location($self,$value)"},"containerName":"main::","definition":"sub"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":145},{"kind":12,"line":162,"children":[{"line":163,"kind":13,"localvar":"my","containerName":"parent","definition":"my","name":"$self"},{"containerName":"parent","name":"$value","line":163,"kind":13},{"name":"$value","containerName":"parent","kind":13,"line":165},{"containerName":"parent","name":"$value","line":166,"kind":13},{"containerName":"parent","name":"$value","kind":13,"line":166},{"name":"isa","containerName":"parent","line":166,"kind":12},{"line":167,"kind":13,"name":"$self","containerName":"parent"},{"containerName":"parent","name":"throw","line":167,"kind":12},{"line":170,"kind":13,"name":"$self","containerName":"parent"},{"line":170,"kind":13,"name":"$value","containerName":"parent"},{"kind":13,"line":173,"containerName":"parent","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"parent($self,$value)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"parent","range":{"start":{"line":162,"character":0},"end":{"character":9999,"line":174}}},{"name":"start","range":{"end":{"character":9999,"line":193},"start":{"line":190,"character":0}},"kind":12,"children":[{"containerName":"start","name":"$self","definition":"my","localvar":"my","kind":13,"line":191},{"containerName":"start","name":"$value","kind":13,"line":191},{"line":192,"kind":13,"containerName":"start","name":"$self"},{"name":"location","containerName":"start","line":192,"kind":12},{"containerName":"start","name":"start","line":192,"kind":12},{"line":192,"kind":13,"containerName":"start","name":"$value"}],"line":190,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"detail":"($self,$value)"},{"range":{"end":{"character":9999,"line":210},"start":{"line":207,"character":0}},"name":"end","line":207,"children":[{"containerName":"end","name":"$self","definition":"my","localvar":"my","kind":13,"line":208},{"containerName":"end","name":"$value","line":208,"kind":13},{"name":"$self","containerName":"end","line":209,"kind":13},{"kind":12,"line":209,"name":"location","containerName":"end"},{"kind":12,"line":209,"name":"end","containerName":"end"},{"name":"$value","containerName":"end","kind":13,"line":209}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none","label":"end($self,$value)"},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"length($self)"},"kind":12,"line":224,"children":[{"line":225,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"length"},{"line":226,"kind":13,"name":"$self","containerName":"length"},{"name":"end","containerName":"length","kind":12,"line":226},{"kind":13,"line":226,"name":"$self","containerName":"length"},{"name":"start","containerName":"length","line":226,"kind":12}],"name":"length","range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":224}}},{"detail":"($self,$value)","signature":{"label":"strand($self,$value)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":241,"children":[{"line":242,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"strand"},{"containerName":"strand","name":"$value","line":242,"kind":13},{"containerName":"strand","name":"$self","line":243,"kind":13},{"name":"location","containerName":"strand","line":243,"kind":12},{"kind":12,"line":243,"name":"strand","containerName":"strand"},{"kind":13,"line":243,"containerName":"strand","name":"$value"}],"kind":12,"range":{"start":{"line":241,"character":0},"end":{"character":9999,"line":244}},"name":"strand"},{"name":"attach_seq","range":{"end":{"character":9999,"line":278},"start":{"line":261,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"attach_seq","line":262,"kind":13},{"line":262,"kind":13,"name":"$seq","containerName":"attach_seq"},{"line":264,"kind":13,"containerName":"attach_seq","name":"$seq"},{"name":"$seq","containerName":"attach_seq","line":264,"kind":13},{"name":"$seq","containerName":"attach_seq","kind":13,"line":264},{"kind":12,"line":264,"name":"isa","containerName":"attach_seq"},{"kind":13,"line":265,"name":"$self","containerName":"attach_seq"},{"kind":12,"line":265,"containerName":"attach_seq","name":"throw"},{"name":"$self","containerName":"attach_seq","kind":13,"line":268},{"name":"$seq","containerName":"attach_seq","line":268,"kind":13},{"kind":13,"line":272,"containerName":"attach_seq","definition":"my","name":"$sf","localvar":"my"},{"name":"$self","containerName":"attach_seq","kind":13,"line":272},{"kind":12,"line":272,"containerName":"attach_seq","name":"sub_SeqFeature"},{"kind":13,"line":273,"name":"$sf","containerName":"attach_seq"},{"containerName":"attach_seq","name":"can","kind":12,"line":273},{"containerName":"attach_seq","name":"$sf","kind":13,"line":274},{"kind":12,"line":274,"name":"attach_seq","containerName":"attach_seq"},{"line":274,"kind":13,"name":"$seq","containerName":"attach_seq"}],"line":261,"definition":"sub","containerName":"main::","signature":{"label":"attach_seq($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :"},"detail":"($self,$seq)"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"seq($self,$arg)"},"detail":"($self,$arg)","kind":12,"children":[{"kind":13,"line":293,"containerName":"seq","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":293,"name":"$arg","containerName":"seq"},{"kind":13,"line":295,"name":"$arg","containerName":"seq"},{"name":"$self","containerName":"seq","line":296,"kind":13},{"name":"throw","containerName":"seq","kind":12,"line":296},{"containerName":"seq","name":"$self","line":299,"kind":13},{"line":306,"kind":13,"localvar":"my","definition":"my","name":"$seq","containerName":"seq"},{"kind":13,"line":306,"containerName":"seq","name":"$self"},{"name":"trunc","containerName":"seq","line":306,"kind":12},{"name":"$self","containerName":"seq","kind":13,"line":306},{"line":306,"kind":12,"name":"start","containerName":"seq"},{"name":"$self","containerName":"seq","line":306,"kind":13},{"line":306,"kind":12,"name":"end","containerName":"seq"},{"name":"$self","containerName":"seq","kind":13,"line":309},{"kind":12,"line":309,"containerName":"seq","name":"strand"},{"containerName":"seq","name":"$seq","line":310,"kind":13},{"containerName":"seq","name":"$seq","line":310,"kind":13},{"kind":12,"line":310,"containerName":"seq","name":"revcom"},{"line":313,"kind":13,"containerName":"seq","name":"$seq"}],"line":292,"name":"seq","range":{"end":{"line":314,"character":9999},"start":{"character":0,"line":292}}},{"range":{"start":{"character":0,"line":328},"end":{"line":333,"character":9999}},"name":"entire_seq","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :","label":"entire_seq($self)"},"containerName":"main::","definition":"sub","line":328,"children":[{"containerName":"entire_seq","definition":"my","name":"$self","localvar":"my","kind":13,"line":329},{"name":"$self","containerName":"entire_seq","kind":13,"line":331},{"kind":13,"line":332,"name":"$self","containerName":"entire_seq"}],"kind":12},{"range":{"end":{"character":9999,"line":360},"start":{"line":354,"character":0}},"name":"seqname","line":354,"children":[{"line":355,"kind":13,"localvar":"my","containerName":"seqname","name":"$obj","definition":"my"},{"kind":13,"line":355,"name":"$value","containerName":"seqname"},{"containerName":"seqname","name":"$value","line":356,"kind":13},{"kind":13,"line":357,"containerName":"seqname","name":"$obj"},{"containerName":"seqname","name":"$value","line":357,"kind":13},{"name":"$obj","containerName":"seqname","kind":13,"line":359}],"kind":12,"detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)","label":"seqname($obj,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"primary_tag($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"primary_tag","name":"$self","definition":"my","line":384,"kind":13},{"name":"@args","containerName":"primary_tag","kind":13,"line":384},{"name":"$self","containerName":"primary_tag","line":386,"kind":13},{"line":386,"kind":12,"containerName":"primary_tag","name":"parent"},{"name":"primary_tag","containerName":"primary_tag","kind":12,"line":386}],"line":383,"name":"primary_tag","range":{"start":{"line":383,"character":0},"end":{"character":9999,"line":387}}},{"line":401,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"source_tag","line":402,"kind":13},{"name":"$self","containerName":"source_tag","kind":13,"line":404},{"containerName":"source_tag","name":"parent","kind":12,"line":404},{"containerName":"source_tag","name":"source_tag","line":404,"kind":12}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none","label":"source_tag($self)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":405},"start":{"line":401,"character":0}},"name":"source_tag"},{"name":"has_tag","range":{"start":{"line":419,"character":0},"end":{"character":9999,"line":423}},"definition":"sub","containerName":"main::","signature":{"label":"has_tag($self,$tag)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :","parameters":[{"label":"$self"},{"label":"$tag"}]},"detail":"($self,$tag)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"has_tag","line":420,"kind":13},{"containerName":"has_tag","name":"$tag","line":420,"kind":13},{"name":"$self","containerName":"has_tag","line":422,"kind":13},{"kind":12,"line":422,"containerName":"has_tag","name":"parent"},{"name":"has_tag","containerName":"has_tag","kind":12,"line":422},{"kind":13,"line":422,"name":"$tag","containerName":"has_tag"}],"line":419},{"range":{"start":{"line":436,"character":0},"end":{"character":9999,"line":440}},"name":"each_tag_value","line":436,"children":[{"definition":"my","name":"$self","containerName":"each_tag_value","localvar":"my","kind":13,"line":437},{"containerName":"each_tag_value","name":"$tag","line":437,"kind":13},{"containerName":"each_tag_value","name":"$self","line":439,"kind":13},{"name":"parent","containerName":"each_tag_value","line":439,"kind":12},{"name":"each_tag_value","containerName":"each_tag_value","line":439,"kind":12},{"name":"$tag","containerName":"each_tag_value","line":439,"kind":13}],"kind":12,"detail":"($self,$tag)","signature":{"label":"each_tag_value($self,$tag)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\n\nsub has_tag{\n   my ($self,$tag) = @_;\n\n   return $self->parent->has_tag($tag);\n}\n\n=head2 each_tag_value\n\n Title   : each_tag_value\n Usage   : @values = $self->each_tag_value('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    :","parameters":[{"label":"$self"},{"label":"$tag"}]},"containerName":"main::","definition":"sub"},{"detail":"($self)","signature":{"label":"all_tags($self)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\n\nsub has_tag{\n   my ($self,$tag) = @_;\n\n   return $self->parent->has_tag($tag);\n}\n\n=head2 each_tag_value\n\n Title   : each_tag_value\n Usage   : @values = $self->each_tag_value('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    :\n\n\n\nsub each_tag_value {\n   my ($self,$tag) = @_;\n\n   return $self->parent->each_tag_value($tag);\n}\n\n=head2 all_tags\n\n Title   : all_tags\n Usage   : @tags = $feat->all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":453,"children":[{"line":454,"kind":13,"localvar":"my","containerName":"all_tags","definition":"my","name":"$self"},{"name":"$self","containerName":"all_tags","line":456,"kind":13},{"line":456,"kind":12,"containerName":"all_tags","name":"parent"},{"line":456,"kind":12,"name":"all_tags","containerName":"all_tags"}],"kind":12,"range":{"end":{"line":457,"character":9999},"start":{"line":453,"character":0}},"name":"all_tags"}],"version":5}