{"version":5,"vars":[{"containerName":"","name":"base","line":76,"kind":2},{"range":{"start":{"character":0,"line":78},"end":{"line":92,"character":9999}},"name":"new","detail":"($class,@args)","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":78,"children":[{"line":79,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"kind":13,"line":79,"name":"@args","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":82},{"kind":13,"line":83,"containerName":"new","name":"@args"},{"line":85,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","line":85,"kind":13},{"name":"@args","containerName":"new","line":85,"kind":13},{"kind":13,"line":87,"containerName":"new","name":"$primary","definition":"my","localvar":"my"},{"line":87,"kind":13,"containerName":"new","name":"$prim"},{"containerName":"new","name":"$self","kind":13,"line":88},{"kind":12,"line":88,"containerName":"new","name":"_rearrange"},{"kind":13,"line":88,"name":"@args","containerName":"new"},{"kind":13,"line":89,"name":"$self","containerName":"new"},{"line":89,"kind":12,"containerName":"new","name":"primary_tag"},{"containerName":"new","name":"$primary","kind":13,"line":89},{"kind":13,"line":89,"containerName":"new","name":"$prim"},{"line":91,"kind":13,"name":"$self","containerName":"new"}],"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":85},{"range":{"end":{"line":114,"character":9999},"start":{"character":0,"line":104}},"name":"upstream_Exon","signature":{"parameters":[{"label":"$self"},{"label":"$exon"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : ","label":"upstream_Exon($self,$exon)"},"detail":"($self,$exon)","definition":"sub","containerName":"main::","children":[{"line":105,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"upstream_Exon"},{"line":105,"kind":13,"name":"$exon","containerName":"upstream_Exon"},{"containerName":"upstream_Exon","name":"$exon","kind":13,"line":107},{"name":"$self","containerName":"upstream_Exon","kind":13,"line":108},{"line":109,"kind":13,"containerName":"upstream_Exon","name":"$self"},{"name":"throw","containerName":"upstream_Exon","line":109,"kind":12},{"kind":13,"line":110,"name":"$exon","containerName":"upstream_Exon"},{"containerName":"upstream_Exon","name":"isa","line":110,"kind":12},{"containerName":"upstream_Exon","name":"$self","kind":13,"line":111},{"containerName":"upstream_Exon","name":"$exon","line":111,"kind":13},{"line":113,"kind":13,"name":"$self","containerName":"upstream_Exon"}],"line":104,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"downstream_Exon($self,$exon)","documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : ","parameters":[{"label":"$self"},{"label":"$exon"}]},"detail":"($self,$exon)","kind":12,"children":[{"localvar":"my","containerName":"downstream_Exon","name":"$self","definition":"my","line":128,"kind":13},{"name":"$exon","containerName":"downstream_Exon","line":128,"kind":13},{"name":"$exon","containerName":"downstream_Exon","line":130,"kind":13},{"name":"$self","containerName":"downstream_Exon","kind":13,"line":131},{"line":132,"kind":13,"containerName":"downstream_Exon","name":"$self"},{"line":132,"kind":12,"containerName":"downstream_Exon","name":"throw"},{"name":"$exon","containerName":"downstream_Exon","kind":13,"line":133},{"containerName":"downstream_Exon","name":"isa","kind":12,"line":133},{"name":"$self","containerName":"downstream_Exon","line":134,"kind":13},{"line":134,"kind":13,"containerName":"downstream_Exon","name":"$exon"},{"name":"$self","containerName":"downstream_Exon","line":136,"kind":13}],"line":127,"name":"downstream_Exon","range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":127}}},{"line":149,"children":[{"kind":13,"line":150,"containerName":"phase","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":151,"name":"$self","containerName":"phase"},{"line":151,"kind":12,"containerName":"phase","name":"downstream_Exon"},{"name":"phase","containerName":"phase","kind":12,"line":151}],"kind":12,"detail":"($self)","signature":{"label":"phase($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : "},"containerName":"main::","definition":"sub","range":{"end":{"line":152,"character":9999},"start":{"line":149,"character":0}},"name":"phase"},{"name":"acceptor_splice_site","range":{"start":{"line":172,"character":0},"end":{"line":206,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$ss_start"},{"label":"$ss_end"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : \n\n\nsub phase {\n  my ($self) = @_;\n  return $self->downstream_Exon->phase;\n}\n\n\n=head2 acceptor_splice_site \n\n  Title   : acceptor_splice_site \n  Usage   : $intron->acceptor_splice_site(21,3)\n  Function: returns the sequence corresponding to the \n            consensus acceptor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical AG. Here 21 means\n            21 bp into intron and 3 means 3 bp into the exon.\n            --Intron--21----|AG|-3-----Exon\n            Defaults to 21,3\n\n  Returns : Bio::Seq\n  Args    : start and end","label":"acceptor_splice_site($self,$ss_start,$ss_end)"},"detail":"($self,$ss_start,$ss_end)","kind":12,"children":[{"kind":13,"line":173,"definition":"my","name":"$self","containerName":"acceptor_splice_site","localvar":"my"},{"containerName":"acceptor_splice_site","name":"$ss_start","kind":13,"line":173},{"containerName":"acceptor_splice_site","name":"$ss_end","kind":13,"line":173},{"kind":13,"line":174,"containerName":"acceptor_splice_site","name":"$ss_start"},{"containerName":"acceptor_splice_site","name":"$ss_start","kind":13,"line":174},{"containerName":"acceptor_splice_site","name":"$ss_end","kind":13,"line":175},{"line":175,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_end"},{"kind":13,"line":176,"containerName":"acceptor_splice_site","name":"$self"},{"name":"strand","containerName":"acceptor_splice_site","kind":12,"line":176},{"localvar":"my","containerName":"acceptor_splice_site","definition":"my","name":"$tmp","line":177,"kind":13},{"kind":13,"line":177,"containerName":"acceptor_splice_site","name":"$ss_start"},{"name":"$ss_start","containerName":"acceptor_splice_site","kind":13,"line":178},{"containerName":"acceptor_splice_site","name":"$ss_end","kind":13,"line":178},{"line":179,"kind":13,"name":"$ss_end","containerName":"acceptor_splice_site"},{"name":"$tmp","containerName":"acceptor_splice_site","line":179,"kind":13},{"line":181,"kind":13,"localvar":"my","containerName":"acceptor_splice_site","definition":"my","name":"$intron_end"},{"name":"$self","containerName":"acceptor_splice_site","line":181,"kind":13},{"line":181,"kind":12,"containerName":"acceptor_splice_site","name":"location"},{"containerName":"acceptor_splice_site","name":"end","kind":12,"line":181},{"containerName":"acceptor_splice_site","name":"$down_exon","definition":"my","localvar":"my","kind":13,"line":182},{"line":182,"kind":13,"containerName":"acceptor_splice_site","name":"$self"},{"name":"downstream_Exon","containerName":"acceptor_splice_site","kind":12,"line":182},{"kind":13,"line":183,"name":"$acceptor","definition":"my","containerName":"acceptor_splice_site","localvar":"my"},{"containerName":"acceptor_splice_site","name":"$self","line":184,"kind":13},{"line":184,"kind":12,"containerName":"acceptor_splice_site","name":"strand"},{"name":"$ss_start","containerName":"acceptor_splice_site","line":185,"kind":13},{"containerName":"acceptor_splice_site","name":"$ss_start","line":185,"kind":13},{"kind":13,"line":185,"name":"$down_exon","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"length","line":185,"kind":12},{"kind":13,"line":185,"name":"$down_exon","containerName":"acceptor_splice_site"},{"name":"length","containerName":"acceptor_splice_site","line":185,"kind":12},{"line":185,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_start"},{"line":186,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_end"},{"containerName":"acceptor_splice_site","name":"$ss_end","kind":13,"line":186},{"line":186,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"kind":12,"line":186,"name":"length","containerName":"acceptor_splice_site"},{"line":186,"kind":13,"containerName":"acceptor_splice_site","name":"$self"},{"line":186,"kind":12,"name":"length","containerName":"acceptor_splice_site"},{"kind":13,"line":186,"containerName":"acceptor_splice_site","name":"$ss_end"},{"name":"$acceptor","containerName":"acceptor_splice_site","kind":13,"line":187},{"name":"new","containerName":"acceptor_splice_site","line":187,"kind":12},{"line":187,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"line":187,"kind":12,"name":"start","containerName":"acceptor_splice_site"},{"line":187,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_start"},{"line":188,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"start","kind":12,"line":188},{"name":"$ss_end","containerName":"acceptor_splice_site","line":188,"kind":13},{"line":189,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"name":"strand","containerName":"acceptor_splice_site","kind":12,"line":189},{"kind":13,"line":193,"name":"$ss_start","containerName":"acceptor_splice_site"},{"kind":13,"line":193,"containerName":"acceptor_splice_site","name":"$ss_start"},{"containerName":"acceptor_splice_site","name":"$self","line":193,"kind":13},{"name":"length","containerName":"acceptor_splice_site","kind":12,"line":193},{"name":"$self","containerName":"acceptor_splice_site","kind":13,"line":193},{"kind":12,"line":193,"name":"length","containerName":"acceptor_splice_site"},{"kind":13,"line":193,"containerName":"acceptor_splice_site","name":"$ss_start"},{"name":"$ss_end","containerName":"acceptor_splice_site","line":194,"kind":13},{"kind":13,"line":194,"name":"$ss_end","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"$down_exon","line":194,"kind":13},{"name":"length","containerName":"acceptor_splice_site","kind":12,"line":194},{"line":194,"kind":13,"containerName":"acceptor_splice_site","name":"$down_exon"},{"kind":12,"line":194,"containerName":"acceptor_splice_site","name":"length"},{"line":194,"kind":13,"name":"$ss_end","containerName":"acceptor_splice_site"},{"name":"$acceptor","containerName":"acceptor_splice_site","line":197,"kind":13},{"containerName":"acceptor_splice_site","name":"new","line":197,"kind":12},{"name":"$self","containerName":"acceptor_splice_site","line":197,"kind":13},{"containerName":"acceptor_splice_site","name":"end","kind":12,"line":197},{"kind":13,"line":197,"name":"$ss_start","containerName":"acceptor_splice_site"},{"line":198,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"end","line":198,"kind":12},{"containerName":"acceptor_splice_site","name":"$ss_end","line":198,"kind":13},{"name":"$self","containerName":"acceptor_splice_site","line":199,"kind":13},{"name":"strand","containerName":"acceptor_splice_site","kind":12,"line":199},{"kind":13,"line":202,"name":"$acceptor","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"attach_seq","kind":12,"line":202},{"line":202,"kind":13,"name":"$self","containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","name":"entire_seq","line":202,"kind":12},{"line":204,"kind":13,"name":"$acceptor","containerName":"acceptor_splice_site"}],"line":172},{"containerName":"SeqFeature::Generic","name":"Bio","line":187,"kind":12},{"line":197,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"detail":"($self,$ss_start,$ss_end)","signature":{"parameters":[{"label":"$self"},{"label":"$ss_start"},{"label":"$ss_end"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : \n\n\nsub phase {\n  my ($self) = @_;\n  return $self->downstream_Exon->phase;\n}\n\n\n=head2 acceptor_splice_site \n\n  Title   : acceptor_splice_site \n  Usage   : $intron->acceptor_splice_site(21,3)\n  Function: returns the sequence corresponding to the \n            consensus acceptor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical AG. Here 21 means\n            21 bp into intron and 3 means 3 bp into the exon.\n            --Intron--21----|AG|-3-----Exon\n            Defaults to 21,3\n\n  Returns : Bio::Seq\n  Args    : start and end\n\n\nsub acceptor_splice_site {\n  my ($self,$ss_start,$ss_end) = @_;\n  $ss_start = 21 unless defined $ss_start;\n  $ss_end   = 3 unless defined $ss_end;\n  if($self->strand < 0){\n    my $tmp= $ss_start;\n    $ss_start = $ss_end;\n    $ss_end = $tmp;\n  }\n  my $intron_end= $self->location->end;\n  my $down_exon = $self->downstream_Exon;\n  my $acceptor;  \n  if($self->strand < 0){\n      $ss_start= $ss_start >  $down_exon->length ? $down_exon->length: $ss_start;\n      $ss_end= $ss_end > $self->length-2 ? $self->length-2 : $ss_end;\n      $acceptor = Bio::SeqFeature::Generic->new(-start=>$self->start - ($ss_start) ,  \n                                               -end=>$self->start + ($ss_end+1),\n                                               -strand=>$self->strand,    \n                                               -primary_tag=>\"donor splice site\");\n  } \n  else {\n    $ss_start = $ss_start > $self->length-2 ? $self->length-2 : $ss_start;\n    $ss_end = $ss_end > $down_exon->length ? $down_exon->length : $ss_end;\n \n\n    $acceptor = Bio::SeqFeature::Generic->new(-start=>$self->end - ($ss_start + 1),  \n                                               -end=>$self->end + $ss_end,\n                                               -strand=>$self->strand,    \n                                               -primary_tag=>\"donor splice site\");\n  }\n  $acceptor->attach_seq($self->entire_seq);\n\n  return $acceptor;\n\n}\n\n=head2 donor_splice_site \n\n  Title   : donor_splice_site \n  Usage   : $intron->donor_splice_site(3,6)\n  Function: returns the sequence corresponding to the \n            consensus donor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical GT. Here 3 means\n            3 bp into exon and 6 means 6 bp into the intron.\n            --Exon-3--|GT|-6----Intron-\n            Defaults to 3,6\n\n  Returns : Bio::Seq\n  Args    : start and end","label":"donor_splice_site($self,$ss_start,$ss_end)"},"containerName":"main::","definition":"sub","line":225,"children":[{"kind":13,"line":226,"name":"$self","definition":"my","containerName":"donor_splice_site","localvar":"my"},{"containerName":"donor_splice_site","name":"$ss_start","line":226,"kind":13},{"kind":13,"line":226,"name":"$ss_end","containerName":"donor_splice_site"},{"line":227,"kind":13,"containerName":"donor_splice_site","name":"$ss_start"},{"kind":13,"line":227,"containerName":"donor_splice_site","name":"$ss_start"},{"containerName":"donor_splice_site","name":"$ss_end","kind":13,"line":228},{"name":"$ss_end","containerName":"donor_splice_site","kind":13,"line":228},{"name":"$self","containerName":"donor_splice_site","line":229,"kind":13},{"line":229,"kind":12,"name":"strand","containerName":"donor_splice_site"},{"definition":"my","name":"$tmp","containerName":"donor_splice_site","localvar":"my","kind":13,"line":230},{"line":230,"kind":13,"name":"$ss_start","containerName":"donor_splice_site"},{"name":"$ss_start","containerName":"donor_splice_site","line":231,"kind":13},{"kind":13,"line":231,"name":"$ss_end","containerName":"donor_splice_site"},{"name":"$ss_end","containerName":"donor_splice_site","line":232,"kind":13},{"containerName":"donor_splice_site","name":"$tmp","line":232,"kind":13},{"kind":13,"line":234,"containerName":"donor_splice_site","definition":"my","name":"$up_exon","localvar":"my"},{"containerName":"donor_splice_site","name":"$self","kind":13,"line":234},{"line":234,"kind":12,"name":"upstream_Exon","containerName":"donor_splice_site"},{"definition":"my","name":"$donor","containerName":"donor_splice_site","localvar":"my","kind":13,"line":235},{"line":236,"kind":13,"name":"$self","containerName":"donor_splice_site"},{"containerName":"donor_splice_site","name":"strand","line":236,"kind":12},{"line":237,"kind":13,"containerName":"donor_splice_site","name":"$ss_end"},{"name":"$ss_end","containerName":"donor_splice_site","line":237,"kind":13},{"containerName":"donor_splice_site","name":"$up_exon","kind":13,"line":237},{"name":"length","containerName":"donor_splice_site","line":237,"kind":12},{"containerName":"donor_splice_site","name":"$up_exon","kind":13,"line":237},{"kind":12,"line":237,"containerName":"donor_splice_site","name":"length"},{"kind":13,"line":237,"containerName":"donor_splice_site","name":"$ss_end"},{"containerName":"donor_splice_site","name":"$ss_start","kind":13,"line":238},{"kind":13,"line":238,"containerName":"donor_splice_site","name":"$ss_start"},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":238},{"name":"length","containerName":"donor_splice_site","line":238,"kind":12},{"containerName":"donor_splice_site","name":"$self","line":238,"kind":13},{"line":238,"kind":12,"containerName":"donor_splice_site","name":"length"},{"kind":13,"line":238,"name":"$ss_start","containerName":"donor_splice_site"},{"name":"$donor","containerName":"donor_splice_site","line":239,"kind":13},{"line":239,"kind":12,"containerName":"donor_splice_site","name":"new"},{"line":239,"kind":13,"name":"$self","containerName":"donor_splice_site"},{"kind":12,"line":239,"name":"end","containerName":"donor_splice_site"},{"containerName":"donor_splice_site","name":"$ss_start","line":239,"kind":13},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":240},{"containerName":"donor_splice_site","name":"end","kind":12,"line":240},{"kind":13,"line":240,"containerName":"donor_splice_site","name":"$ss_end"},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":241},{"name":"strand","containerName":"donor_splice_site","line":241,"kind":12},{"containerName":"donor_splice_site","name":"$ss_start","kind":13,"line":245},{"kind":13,"line":245,"name":"$ss_start","containerName":"donor_splice_site"},{"line":245,"kind":13,"containerName":"donor_splice_site","name":"$up_exon"},{"line":245,"kind":12,"containerName":"donor_splice_site","name":"length"},{"containerName":"donor_splice_site","name":"$up_exon","line":245,"kind":13},{"kind":12,"line":245,"containerName":"donor_splice_site","name":"length"},{"containerName":"donor_splice_site","name":"$ss_start","kind":13,"line":245},{"kind":13,"line":246,"containerName":"donor_splice_site","name":"$ss_end"},{"containerName":"donor_splice_site","name":"$ss_end","line":246,"kind":13},{"kind":13,"line":246,"name":"$self","containerName":"donor_splice_site"},{"line":246,"kind":12,"containerName":"donor_splice_site","name":"length"},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":246},{"line":246,"kind":12,"containerName":"donor_splice_site","name":"length"},{"kind":13,"line":246,"name":"$ss_end","containerName":"donor_splice_site"},{"name":"$donor","containerName":"donor_splice_site","line":247,"kind":13},{"kind":12,"line":247,"containerName":"donor_splice_site","name":"new"},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":247},{"containerName":"donor_splice_site","name":"start","line":247,"kind":12},{"name":"$ss_start","containerName":"donor_splice_site","kind":13,"line":247},{"kind":13,"line":248,"name":"$self","containerName":"donor_splice_site"},{"kind":12,"line":248,"name":"start","containerName":"donor_splice_site"},{"line":248,"kind":13,"containerName":"donor_splice_site","name":"$ss_end"},{"kind":13,"line":249,"containerName":"donor_splice_site","name":"$self"},{"kind":12,"line":249,"containerName":"donor_splice_site","name":"strand"},{"line":252,"kind":13,"name":"$donor","containerName":"donor_splice_site"},{"kind":12,"line":252,"name":"attach_seq","containerName":"donor_splice_site"},{"name":"$self","containerName":"donor_splice_site","line":252,"kind":13},{"kind":12,"line":252,"containerName":"donor_splice_site","name":"entire_seq"},{"containerName":"donor_splice_site","name":"$donor","kind":13,"line":253}],"kind":12,"range":{"start":{"character":0,"line":225},"end":{"line":254,"character":9999}},"name":"donor_splice_site"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":239},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":247},{"name":"location","range":{"end":{"line":302,"character":9999},"start":{"character":0,"line":256}},"definition":"sub","containerName":"main::","signature":{"label":"location($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)","kind":12,"children":[{"line":257,"kind":13,"localvar":"my","containerName":"location","definition":"my","name":"$self"},{"line":259,"kind":13,"containerName":"location","name":"$self"},{"line":260,"kind":13,"localvar":"my","definition":"my","name":"$loc","containerName":"location"},{"containerName":"location","name":"new","kind":12,"line":260},{"localvar":"my","containerName":"location","definition":"my","name":"$up_exon","line":262,"kind":13},{"name":"$self","containerName":"location","kind":13,"line":262},{"line":262,"kind":12,"containerName":"location","name":"upstream_Exon"},{"definition":"my","name":"$down_exon","containerName":"location","localvar":"my","kind":13,"line":263},{"containerName":"location","name":"$self","kind":13,"line":263},{"name":"downstream_Exon","containerName":"location","line":263,"kind":12},{"kind":13,"line":266,"containerName":"location","name":"$up_seq","definition":"my","localvar":"my"},{"name":"$up_exon","containerName":"location","kind":13,"line":266},{"name":"entire_seq","containerName":"location","line":266,"kind":12},{"localvar":"my","containerName":"location","definition":"my","name":"$down_seq","line":267,"kind":13},{"containerName":"location","name":"$down_exon","line":267,"kind":13},{"kind":12,"line":267,"containerName":"location","name":"entire_seq"},{"line":268,"kind":13,"name":"$up_seq","containerName":"location"},{"name":"$down_seq","containerName":"location","kind":13,"line":268},{"name":"$self","containerName":"location","kind":13,"line":269},{"containerName":"location","name":"throw","kind":12,"line":269},{"containerName":"location","name":"$up_strand","definition":"my","localvar":"my","kind":13,"line":273},{"line":273,"kind":13,"name":"$up_exon","containerName":"location"},{"containerName":"location","name":"strand","kind":12,"line":273},{"localvar":"my","name":"$down_strand","definition":"my","containerName":"location","line":274,"kind":13},{"kind":13,"line":274,"name":"$down_exon","containerName":"location"},{"containerName":"location","name":"strand","kind":12,"line":274},{"containerName":"location","name":"$up_strand","line":275,"kind":13},{"line":275,"kind":13,"containerName":"location","name":"$down_strand"},{"name":"$self","containerName":"location","line":276,"kind":13},{"containerName":"location","name":"throw","kind":12,"line":276},{"kind":13,"line":279,"containerName":"location","name":"$loc"},{"kind":12,"line":279,"name":"strand","containerName":"location"},{"line":279,"kind":13,"name":"$up_strand","containerName":"location"},{"name":"$exon_end","definition":"my","containerName":"location","localvar":"my","kind":13,"line":283},{"kind":13,"line":283,"name":"$exon_start","containerName":"location"},{"line":284,"kind":13,"name":"$up_strand","containerName":"location"},{"containerName":"location","name":"$exon_end","kind":13,"line":285},{"line":285,"kind":13,"name":"$up_exon","containerName":"location"},{"containerName":"location","name":"end","kind":12,"line":285},{"name":"$exon_start","containerName":"location","kind":13,"line":286},{"kind":13,"line":286,"name":"$down_exon","containerName":"location"},{"line":286,"kind":12,"name":"start","containerName":"location"},{"containerName":"location","name":"$exon_end","line":288,"kind":13},{"kind":13,"line":288,"name":"$down_exon","containerName":"location"},{"containerName":"location","name":"end","line":288,"kind":12},{"containerName":"location","name":"$exon_start","kind":13,"line":289},{"line":289,"kind":13,"containerName":"location","name":"$up_exon"},{"kind":12,"line":289,"name":"start","containerName":"location"},{"name":"$exon_end","containerName":"location","kind":13,"line":291},{"line":291,"kind":13,"name":"$exon_start","containerName":"location"},{"kind":13,"line":292,"name":"$self","containerName":"location"},{"containerName":"location","name":"throw","kind":12,"line":292},{"line":294,"kind":13,"name":"$loc","containerName":"location"},{"line":294,"kind":12,"name":"start","containerName":"location"},{"kind":13,"line":294,"containerName":"location","name":"$exon_end"},{"containerName":"location","name":"$loc","kind":13,"line":295},{"name":"end","containerName":"location","kind":12,"line":295},{"containerName":"location","name":"$exon_start","line":295,"kind":13},{"containerName":"location","name":"$self","line":298,"kind":13},{"kind":13,"line":298,"name":"$loc","containerName":"location"},{"name":"$self","containerName":"location","line":301,"kind":13}],"line":256},{"line":260,"kind":12,"name":"Bio","containerName":"Location::Simple"}]}