{"version":5,"vars":[{"name":"base","containerName":"","line":77,"kind":2},{"range":{"start":{"line":95,"character":0},"end":{"line":98,"character":9999}},"name":"transcripts","signature":{"label":"transcripts($self)","documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : ","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":96,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"transcripts"},{"line":97,"kind":13,"containerName":"transcripts","name":"$self"},{"line":97,"kind":12,"name":"throw_not_implemented","containerName":"transcripts"}],"line":95,"kind":12},{"range":{"start":{"line":116,"character":0},"end":{"line":119,"character":9999}},"name":"promoters","children":[{"containerName":"promoters","definition":"my","name":"$self","localvar":"my","kind":13,"line":117},{"line":118,"kind":13,"name":"$self","containerName":"promoters"},{"line":118,"kind":12,"name":"throw_not_implemented","containerName":"promoters"}],"line":116,"kind":12,"signature":{"label":"promoters($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : "},"detail":"($self)","definition":"sub","containerName":"main::"},{"signature":{"label":"exons($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon."},"detail":"($self,$type)","definition":"sub","containerName":"main::","children":[{"line":142,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"exons"},{"kind":13,"line":142,"name":"$type","containerName":"exons"},{"kind":13,"line":143,"containerName":"exons","name":"$self"},{"containerName":"exons","name":"throw_not_implemented","kind":12,"line":143}],"line":141,"kind":12,"range":{"end":{"line":144,"character":9999},"start":{"character":0,"line":141}},"name":"exons"},{"kind":12,"children":[{"kind":13,"line":159,"containerName":"introns","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"introns","kind":13,"line":160},{"containerName":"introns","name":"throw_not_implemented","kind":12,"line":160}],"line":158,"definition":"sub","containerName":"main::","signature":{"label":"introns($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : "},"detail":"($self)","name":"introns","range":{"start":{"line":158,"character":0},"end":{"character":9999,"line":161}}},{"range":{"end":{"character":9999,"line":178},"start":{"character":0,"line":175}},"name":"poly_A_sites","children":[{"line":176,"kind":13,"localvar":"my","containerName":"poly_A_sites","definition":"my","name":"$self"},{"name":"$self","containerName":"poly_A_sites","kind":13,"line":177},{"containerName":"poly_A_sites","name":"throw_not_implemented","kind":12,"line":177}],"line":175,"kind":12,"signature":{"label":"poly_A_sites($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation features/sites of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           poly-adenylation regions or sites.\n Args    : "},"detail":"($self)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"utrs($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructureI - A feature representing an arbitrarily\n           complex structure of a gene\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructureI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 transcripts\n\n Title   : transcripts()\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcript features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::TranscriptI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects\n           representing the promoter regions or sites.\n Args    : \n\n\n\nsub transcripts {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features/sites of this gene structure.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this gene\n           structure.\n\n           Refer to the documentation of the class that produced this gene\n           structure object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the exon regions.\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation features/sites of this gene structure.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           poly-adenylation regions or sites.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs();\n Function: Get the UTR features/sites of this gene structure.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : "},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"utrs","localvar":"my","kind":13,"line":197},{"containerName":"utrs","name":"$self","line":198,"kind":13},{"containerName":"utrs","name":"throw_not_implemented","kind":12,"line":198}],"line":196,"name":"utrs","range":{"start":{"character":0,"line":196},"end":{"character":9999,"line":199}}}]}