{"version":5,"vars":[{"kind":2,"line":101,"name":"base","containerName":""},{"line":106,"kind":13,"containerName":"main::","name":"%tagclass","definition":"our"},{"line":107,"kind":12,"name":"comment"},{"name":"dblink","line":108,"kind":12},{"name":"description","kind":12,"line":109},{"name":"gene_name","kind":12,"line":110},{"kind":12,"line":111,"name":"ontology_term"},{"name":"reference","kind":12,"line":112},{"name":"__DEFAULT__","line":113,"kind":12},{"containerName":"main::","name":"%tag2text","definition":"our","kind":13,"line":116},{"name":"__DEFAULT__","line":123,"kind":12},{"name":"new","range":{"start":{"character":0,"line":218},"end":{"character":9999,"line":225}},"kind":12,"line":218,"children":[{"containerName":"new","name":"$caller","definition":"my","localvar":"my","kind":13,"line":219},{"kind":13,"line":219,"containerName":"new","name":"@args"},{"kind":13,"line":220,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$caller","kind":13,"line":220},{"line":220,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":222,"containerName":"new","name":"$self"},{"name":"_initialize","containerName":"new","line":222,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":222},{"name":"$self","containerName":"new","kind":13,"line":224}],"containerName":"main::","definition":"sub","detail":"($caller,@args)","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"}},{"name":"SUPER","containerName":"new","line":220,"kind":12},{"kind":12,"line":227,"children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":228},{"line":228,"kind":13,"name":"@args","containerName":"_initialize"},{"kind":13,"line":229,"definition":"my","name":"$start","containerName":"_initialize","localvar":"my"},{"name":"$end","containerName":"_initialize","line":229,"kind":13},{"name":"$strand","containerName":"_initialize","line":229,"kind":13},{"name":"$frame","containerName":"_initialize","line":229,"kind":13},{"line":229,"kind":13,"name":"$phase","containerName":"_initialize"},{"name":"$score","containerName":"_initialize","kind":13,"line":229},{"name":"$name","containerName":"_initialize","line":230,"kind":13},{"line":230,"kind":13,"name":"$annot","containerName":"_initialize"},{"containerName":"_initialize","name":"$location","line":230,"kind":13},{"name":"$display_name","containerName":"_initialize","kind":13,"line":231},{"containerName":"_initialize","name":"$seq_id","line":232,"kind":13},{"kind":13,"line":232,"name":"$type","containerName":"_initialize"},{"containerName":"_initialize","name":"$source","line":232,"kind":13},{"containerName":"_initialize","name":"$feature","line":233,"kind":13},{"name":"$self","containerName":"_initialize","line":234,"kind":13},{"line":234,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"containerName":"_initialize","name":"@args","line":248,"kind":13},{"containerName":"_initialize","name":"$start","kind":13,"line":249},{"line":249,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"start","kind":12,"line":249},{"kind":13,"line":249,"containerName":"_initialize","name":"$start"},{"line":250,"kind":13,"name":"$end","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":250,"kind":13},{"kind":12,"line":250,"name":"end","containerName":"_initialize"},{"line":250,"kind":13,"name":"$end","containerName":"_initialize"},{"name":"$strand","containerName":"_initialize","line":251,"kind":13},{"kind":13,"line":251,"containerName":"_initialize","name":"$self"},{"kind":12,"line":251,"name":"strand","containerName":"_initialize"},{"line":251,"kind":13,"containerName":"_initialize","name":"$strand"},{"kind":13,"line":252,"name":"$frame","containerName":"_initialize"},{"line":252,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":252,"name":"frame","containerName":"_initialize"},{"kind":13,"line":252,"containerName":"_initialize","name":"$frame"},{"line":253,"kind":13,"containerName":"_initialize","name":"$phase"},{"containerName":"_initialize","name":"$self","kind":13,"line":253},{"kind":12,"line":253,"name":"phase","containerName":"_initialize"},{"name":"$phase","containerName":"_initialize","kind":13,"line":253},{"line":254,"kind":13,"containerName":"_initialize","name":"$score"},{"name":"$self","containerName":"_initialize","line":254,"kind":13},{"line":254,"kind":12,"name":"score","containerName":"_initialize"},{"kind":13,"line":254,"name":"$score","containerName":"_initialize"},{"name":"$source","containerName":"_initialize","kind":13,"line":255},{"line":255,"kind":13,"containerName":"_initialize","name":"$source"},{"kind":13,"line":255,"containerName":"_initialize","name":"$self"},{"kind":12,"line":255,"name":"source","containerName":"_initialize"},{"line":255,"kind":13,"containerName":"_initialize","name":"$source"},{"line":255,"kind":13,"containerName":"_initialize","name":"$self"},{"line":255,"kind":12,"name":"source_tag","containerName":"_initialize"},{"name":"$source","containerName":"_initialize","kind":13,"line":255},{"kind":13,"line":256,"containerName":"_initialize","name":"$type"},{"name":"$type","containerName":"_initialize","line":256,"kind":13},{"line":256,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"type","line":256,"kind":12},{"name":"$type","containerName":"_initialize","kind":13,"line":256},{"line":256,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"primary_tag","line":256,"kind":12},{"name":"$type","containerName":"_initialize","kind":13,"line":256},{"line":257,"kind":13,"containerName":"_initialize","name":"$location"},{"line":257,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"location","kind":12,"line":257},{"line":257,"kind":13,"containerName":"_initialize","name":"$location"},{"name":"$annot","containerName":"_initialize","kind":13,"line":258},{"line":258,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"annotation","kind":12,"line":258},{"kind":13,"line":258,"containerName":"_initialize","name":"$annot"},{"containerName":"_initialize","name":"$feature","line":259,"kind":13},{"name":"$self","containerName":"_initialize","line":259,"kind":13},{"kind":12,"line":259,"name":"from_feature","containerName":"_initialize"},{"containerName":"_initialize","name":"$feature","kind":13,"line":259},{"name":"$display_name","containerName":"_initialize","line":261,"kind":13},{"line":261,"kind":13,"containerName":"_initialize","name":"$name"},{"line":262,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":262,"containerName":"_initialize","name":"throw"},{"kind":13,"line":264,"name":"$seq_id","containerName":"_initialize"},{"line":264,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":264,"containerName":"_initialize","name":"seq_id"},{"name":"$seq_id","containerName":"_initialize","kind":13,"line":264},{"containerName":"_initialize","name":"$name","kind":13,"line":265},{"containerName":"_initialize","name":"$display_name","kind":13,"line":265},{"line":265,"kind":13,"containerName":"_initialize","name":"$self"},{"line":265,"kind":12,"containerName":"_initialize","name":"name"},{"line":265,"kind":13,"containerName":"_initialize","name":"$name"},{"containerName":"_initialize","name":"$display_name","line":265,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"name":"_initialize","range":{"start":{"line":227,"character":0},"end":{"line":266,"character":9999}}},{"children":[{"line":286,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"from_feature"},{"name":"$feat","containerName":"from_feature","kind":13,"line":286},{"containerName":"from_feature","name":"%opts","kind":13,"line":286},{"containerName":"from_feature","name":"$feat","kind":13,"line":290},{"kind":13,"line":290,"containerName":"from_feature","name":"$feat"},{"line":290,"kind":12,"containerName":"from_feature","name":"isa"},{"name":"$self","containerName":"from_feature","kind":13,"line":291},{"containerName":"from_feature","name":"throw","kind":12,"line":291},{"kind":13,"line":297,"containerName":"from_feature","name":"$fieldname","definition":"my","localvar":"my"},{"name":"$self","containerName":"from_feature","line":299,"kind":13},{"kind":13,"line":299,"containerName":"from_feature","name":"$fieldname"},{"line":299,"kind":13,"name":"$feat","containerName":"from_feature"},{"containerName":"from_feature","name":"$fieldname","line":299,"kind":13},{"line":305,"kind":13,"localvar":"my","containerName":"from_feature","definition":"my","name":"%no_copy"},{"definition":"my","name":"$adaptor","containerName":"from_feature","localvar":"my","kind":13,"line":306},{"line":306,"kind":12,"name":"new","containerName":"from_feature"},{"line":306,"kind":13,"containerName":"from_feature","name":"$feat"},{"line":307,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":"from_feature"},{"name":"$adaptor","containerName":"from_feature","kind":13,"line":307},{"line":307,"kind":12,"containerName":"from_feature","name":"get_all_annotation_keys"},{"containerName":"from_feature","name":"$no_copy","kind":13,"line":308},{"name":"$key","containerName":"from_feature","line":308,"kind":13},{"line":309,"kind":13,"localvar":"my","definition":"my","name":"@values","containerName":"from_feature"},{"name":"$adaptor","containerName":"from_feature","line":309,"kind":13},{"kind":12,"line":309,"containerName":"from_feature","name":"get_Annotations"},{"containerName":"from_feature","name":"$key","kind":13,"line":309},{"kind":13,"line":310,"name":"@values","containerName":"from_feature"},{"name":"%opts","containerName":"from_feature","kind":13,"line":310},{"line":310,"kind":13,"containerName":"from_feature","name":"$key"},{"line":310,"kind":13,"containerName":"from_feature","name":"@values"},{"name":"$val","definition":"my","containerName":"from_feature","localvar":"my","kind":13,"line":311},{"line":311,"kind":13,"containerName":"from_feature","name":"@values"},{"containerName":"from_feature","name":"$self","kind":13,"line":312},{"line":312,"kind":12,"name":"add_Annotation","containerName":"from_feature"},{"kind":13,"line":312,"name":"$key","containerName":"from_feature"},{"containerName":"from_feature","name":"$val","kind":13,"line":312}],"line":285,"kind":12,"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"%opts"}],"label":"from_feature($self,$feat,%opts)"},"detail":"($self,$feat,%opts)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":315},"start":{"character":0,"line":285}},"name":"from_feature"},{"containerName":"SeqFeature::AnnotationAdaptor","name":"Bio","kind":12,"line":306},{"name":"_aggregate_scalar_annotations","line":310,"kind":12},{"range":{"end":{"line":369,"character":9999},"start":{"line":319,"character":0}},"name":"_aggregate_scalar_annotations","line":319,"children":[{"kind":13,"line":320,"name":"$opts","definition":"my","containerName":"_aggregate_scalar_annotations","localvar":"my"},{"line":320,"kind":13,"containerName":"_aggregate_scalar_annotations","name":"$key"},{"kind":13,"line":320,"containerName":"_aggregate_scalar_annotations","name":"@values"},{"kind":13,"line":323,"name":"@values","containerName":"_aggregate_scalar_annotations"},{"line":323,"kind":12,"containerName":"_aggregate_scalar_annotations","name":"new"},{"line":323,"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values"},{"containerName":"_aggregate_scalar_annotations","name":"$key","line":326,"kind":13},{"name":"@values","containerName":"_aggregate_scalar_annotations","kind":13,"line":326},{"containerName":"_aggregate_scalar_annotations","name":"@values","kind":13,"line":326},{"kind":13,"line":327,"name":"@values","containerName":"_aggregate_scalar_annotations"},{"kind":12,"line":327,"containerName":"_aggregate_scalar_annotations","name":"isa"},{"name":"@values","containerName":"_aggregate_scalar_annotations","line":328,"kind":13},{"name":"@values","containerName":"_aggregate_scalar_annotations","line":329,"kind":13},{"line":329,"kind":12,"containerName":"_aggregate_scalar_annotations","name":"value"},{"containerName":"_aggregate_scalar_annotations","name":"@values","kind":13,"line":329},{"containerName":"_aggregate_scalar_annotations","name":"@values","line":331,"kind":13},{"name":"$values","containerName":"_aggregate_scalar_annotations","kind":13,"line":332},{"kind":13,"line":332,"containerName":"_aggregate_scalar_annotations","name":"$values"},{"name":"$values","containerName":"_aggregate_scalar_annotations","line":333,"kind":13},{"name":"@values","containerName":"_aggregate_scalar_annotations","line":335,"kind":13},{"name":"@values","containerName":"_aggregate_scalar_annotations","kind":13,"line":335},{"name":"$values","containerName":"_aggregate_scalar_annotations","line":336,"kind":13},{"containerName":"_aggregate_scalar_annotations","name":"new","kind":12,"line":339},{"name":"$values","containerName":"_aggregate_scalar_annotations","kind":13,"line":339},{"kind":13,"line":340,"containerName":"_aggregate_scalar_annotations","name":"$values"},{"name":"$values","containerName":"_aggregate_scalar_annotations","line":341,"kind":13},{"line":342,"kind":13,"containerName":"_aggregate_scalar_annotations","name":"$values"},{"containerName":"_aggregate_scalar_annotations","name":"$key","line":347,"kind":13},{"kind":13,"line":347,"containerName":"_aggregate_scalar_annotations","name":"$key"},{"localvar":"my","name":"$db","definition":"my","containerName":"_aggregate_scalar_annotations","line":350,"kind":13},{"name":"$id","containerName":"_aggregate_scalar_annotations","line":350,"kind":13},{"kind":12,"line":350,"containerName":"_aggregate_scalar_annotations","name":"value"},{"containerName":"_aggregate_scalar_annotations","name":"new","line":351,"kind":12},{"kind":13,"line":351,"name":"$db","containerName":"_aggregate_scalar_annotations"},{"containerName":"_aggregate_scalar_annotations","name":"$id","kind":13,"line":352},{"line":357,"kind":13,"name":"@values","containerName":"_aggregate_scalar_annotations"},{"containerName":"_aggregate_scalar_annotations","name":"$key","line":360,"kind":13},{"name":"new","containerName":"_aggregate_scalar_annotations","line":361,"kind":12},{"containerName":"_aggregate_scalar_annotations","name":"value","line":361,"kind":12},{"kind":13,"line":362,"containerName":"_aggregate_scalar_annotations","name":"@values"},{"kind":13,"line":364,"name":"$key","containerName":"_aggregate_scalar_annotations"},{"kind":12,"line":365,"containerName":"_aggregate_scalar_annotations","name":"new"},{"kind":12,"line":365,"containerName":"_aggregate_scalar_annotations","name":"value"},{"kind":13,"line":365,"name":"@values","containerName":"_aggregate_scalar_annotations"},{"containerName":"_aggregate_scalar_annotations","name":"@values","kind":13,"line":368}],"kind":12,"detail":"($opts,$key,@values)","signature":{"label":"_aggregate_scalar_annotations($opts,$key,@values)","documentation":"given a key and its values, make the values into\nBio::Annotation::\\w+ objects","parameters":[{"label":"$opts"},{"label":"$key"},{"label":"@values"}]},"containerName":"main::","definition":"sub"},{"line":323,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"line":339,"kind":12,"containerName":"Annotation::Target","name":"Bio"},{"kind":12,"line":351,"name":"Bio","containerName":"Annotation::DBLink"},{"kind":12,"line":361,"containerName":"Annotation::OntologyTerm","name":"Bio"},{"name":"Bio","containerName":"Annotation::Comment","line":365,"kind":12},{"name":"seq_id","range":{"end":{"line":402,"character":9999},"start":{"line":383,"character":0}},"kind":12,"line":383,"children":[{"line":384,"kind":13,"localvar":"my","containerName":"seq_id","name":"$self","definition":"my"},{"name":"$val","containerName":"seq_id","line":384,"kind":13},{"containerName":"seq_id","name":"$val","kind":13,"line":385},{"localvar":"my","containerName":"seq_id","name":"$term","definition":"my","line":386,"kind":13},{"name":"$val","containerName":"seq_id","kind":13,"line":387},{"kind":13,"line":388,"name":"$term","containerName":"seq_id"},{"kind":12,"line":388,"name":"new","containerName":"seq_id"},{"containerName":"seq_id","name":"$val","kind":13,"line":388},{"containerName":"seq_id","name":"$val","kind":13,"line":389},{"kind":13,"line":389,"name":"$val","containerName":"seq_id"},{"containerName":"seq_id","name":"isa","kind":12,"line":389},{"kind":13,"line":390,"containerName":"seq_id","name":"$term"},{"containerName":"seq_id","name":"$val","kind":13,"line":390},{"line":392,"kind":13,"containerName":"seq_id","name":"$term"},{"containerName":"seq_id","name":"$term","line":392,"kind":13},{"line":392,"kind":12,"name":"value","containerName":"seq_id"},{"kind":13,"line":393,"name":"$self","containerName":"seq_id"},{"kind":12,"line":393,"name":"throw","containerName":"seq_id"},{"kind":13,"line":393,"containerName":"seq_id","name":"$val"},{"name":"$self","containerName":"seq_id","line":395,"kind":13},{"name":"remove_Annotations","containerName":"seq_id","kind":12,"line":395},{"containerName":"seq_id","name":"$self","line":396,"kind":13},{"line":396,"kind":12,"name":"add_Annotation","containerName":"seq_id"},{"line":396,"kind":13,"name":"$term","containerName":"seq_id"},{"name":"$self","containerName":"seq_id","line":399,"kind":13},{"line":399,"kind":12,"containerName":"seq_id","name":"seq_id"},{"line":399,"kind":13,"containerName":"seq_id","name":"$self"},{"name":"get_Annotations","containerName":"seq_id","kind":12,"line":399},{"containerName":"seq_id","name":"$self","line":401,"kind":13},{"kind":12,"line":401,"containerName":"seq_id","name":"get_Annotations"},{"containerName":"seq_id","name":"value","line":401,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.","parameters":[{"label":"$self"},{"label":"$val"}],"label":"seq_id($self,$val)"}},{"name":"Bio","containerName":"Annotation::SimpleValue","line":388,"kind":12},{"kind":12,"line":388,"name":"uri_unescape"},{"children":[{"line":414,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"name"},{"name":"$val","containerName":"name","line":414,"kind":13},{"kind":13,"line":415,"name":"$self","containerName":"name"},{"containerName":"name","name":"$val","line":415,"kind":13},{"name":"$val","containerName":"name","line":415,"kind":13},{"line":416,"kind":13,"name":"$self","containerName":"name"}],"line":413,"kind":12,"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}],"label":"name($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":417},"start":{"character":0,"line":413}},"name":"name"},{"containerName":"main::","name":"MAX_TYPE_CACHE_MEMBERS","definition":1,"line":430,"kind":14},{"name":"type","range":{"end":{"character":9999,"line":451},"start":{"character":0,"line":431}},"definition":"sub","containerName":"main::","signature":{"label":"type($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":""},"detail":"($self,$val)","kind":12,"children":[{"localvar":"my","containerName":"type","name":"$self","definition":"my","line":432,"kind":13},{"kind":13,"line":432,"containerName":"type","name":"$val"},{"kind":13,"line":433,"containerName":"type","name":"$val"},{"name":"$term","definition":"my","containerName":"type","localvar":"my","kind":13,"line":434},{"containerName":"type","name":"$val","kind":13,"line":436},{"name":"$self","containerName":"type","kind":13,"line":437},{"name":"throw","containerName":"type","line":437,"kind":12},{"kind":13,"line":439,"containerName":"type","name":"$val"},{"line":439,"kind":13,"containerName":"type","name":"$val"},{"line":439,"kind":12,"name":"isa","containerName":"type"},{"name":"$term","containerName":"type","kind":13,"line":440},{"kind":13,"line":440,"containerName":"type","name":"$val"},{"containerName":"type","name":"$self","kind":13,"line":444},{"containerName":"type","name":"throw","kind":12,"line":444},{"name":"$val","containerName":"type","kind":13,"line":444},{"kind":13,"line":446,"name":"$self","containerName":"type"},{"kind":12,"line":446,"name":"remove_Annotations","containerName":"type"},{"kind":13,"line":447,"name":"$self","containerName":"type"},{"line":447,"kind":12,"name":"add_Annotation","containerName":"type"},{"kind":13,"line":447,"name":"$term","containerName":"type"},{"kind":13,"line":450,"name":"$self","containerName":"type"},{"kind":12,"line":450,"name":"get_Annotations","containerName":"type"}],"line":431},{"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()","label":"source($self,$val)"},"kind":12,"line":464,"children":[{"line":465,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"source"},{"containerName":"source","name":"$val","line":465,"kind":13},{"kind":13,"line":467,"containerName":"source","name":"$val"},{"containerName":"source","name":"$term","definition":"my","localvar":"my","kind":13,"line":468},{"kind":13,"line":469,"containerName":"source","name":"$val"},{"name":"$self","containerName":"source","kind":13,"line":470},{"containerName":"source","name":"throw","line":470,"kind":12},{"line":472,"kind":13,"containerName":"source","name":"$val"},{"kind":13,"line":472,"containerName":"source","name":"$val"},{"line":472,"kind":12,"name":"isa","containerName":"source"},{"containerName":"source","name":"$term","line":473,"kind":13},{"containerName":"source","name":"$val","kind":13,"line":473},{"kind":13,"line":475,"containerName":"source","name":"$self"},{"name":"throw","containerName":"source","kind":12,"line":475},{"name":"$val","containerName":"source","kind":13,"line":475},{"containerName":"source","name":"$self","kind":13,"line":477},{"kind":12,"line":477,"containerName":"source","name":"remove_Annotations"},{"containerName":"source","name":"$self","kind":13,"line":478},{"line":478,"kind":12,"name":"add_Annotation","containerName":"source"},{"line":478,"kind":13,"containerName":"source","name":"$term"},{"line":481,"kind":13,"containerName":"source","name":"$self"},{"containerName":"source","name":"get_Annotations","kind":12,"line":481},{"line":482,"kind":13,"name":"$self","containerName":"source"},{"containerName":"source","name":"source","kind":12,"line":482},{"containerName":"source","name":"new","line":482,"kind":12},{"line":484,"kind":13,"containerName":"source","name":"$self"},{"kind":12,"line":484,"name":"get_Annotations","containerName":"source"}],"name":"source","range":{"start":{"character":0,"line":464},"end":{"line":485,"character":9999}}},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":482},{"range":{"end":{"line":520,"character":9999},"start":{"line":497,"character":0}},"name":"score","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"score","localvar":"my","kind":13,"line":498},{"line":499,"kind":13,"localvar":"my","name":"$val","definition":"my","containerName":"score"},{"containerName":"score","name":"$val","kind":13,"line":501},{"localvar":"my","containerName":"score","name":"$term","definition":"my","line":502,"kind":13},{"name":"$val","containerName":"score","kind":13,"line":503},{"line":504,"kind":13,"containerName":"score","name":"$term"},{"line":504,"kind":12,"containerName":"score","name":"new"},{"line":504,"kind":13,"containerName":"score","name":"$val"},{"name":"$val","containerName":"score","line":505,"kind":13},{"kind":13,"line":505,"containerName":"score","name":"$val"},{"containerName":"score","name":"isa","line":505,"kind":12},{"containerName":"score","name":"$term","line":506,"kind":13},{"containerName":"score","name":"$val","kind":13,"line":506},{"line":509,"kind":13,"name":"$term","containerName":"score"},{"line":509,"kind":12,"name":"value","containerName":"score"},{"containerName":"score","name":"$term","kind":13,"line":510},{"kind":13,"line":510,"containerName":"score","name":"$term"},{"line":510,"kind":12,"name":"value","containerName":"score"},{"containerName":"score","name":"$self","kind":13,"line":511},{"line":511,"kind":12,"containerName":"score","name":"throw"},{"kind":13,"line":513,"name":"$self","containerName":"score"},{"kind":12,"line":513,"containerName":"score","name":"remove_Annotations"},{"containerName":"score","name":"$self","kind":13,"line":514},{"containerName":"score","name":"add_Annotation","line":514,"kind":12},{"kind":13,"line":514,"containerName":"score","name":"$term"},{"name":"$self","containerName":"score","kind":13,"line":517},{"kind":12,"line":517,"containerName":"score","name":"score"},{"containerName":"score","name":"$self","kind":13,"line":517},{"name":"get_Annotations","containerName":"score","kind":12,"line":517},{"containerName":"score","name":"$self","kind":13,"line":519},{"kind":12,"line":519,"name":"get_Annotations","containerName":"score"},{"kind":12,"line":519,"name":"display_text","containerName":"score"}],"line":497,"kind":12},{"containerName":"Annotation::SimpleValue","name":"Bio","kind":12,"line":504},{"children":[{"line":534,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"phase"},{"line":535,"kind":13,"localvar":"my","containerName":"phase","name":"$val","definition":"my"},{"line":537,"kind":13,"name":"$val","containerName":"phase"},{"containerName":"phase","name":"$term","definition":"my","localvar":"my","kind":13,"line":538},{"name":"$val","containerName":"phase","line":539,"kind":13},{"line":540,"kind":13,"containerName":"phase","name":"$term"},{"name":"new","containerName":"phase","kind":12,"line":540},{"line":540,"kind":13,"containerName":"phase","name":"$val"},{"line":541,"kind":13,"name":"$val","containerName":"phase"},{"name":"$val","containerName":"phase","kind":13,"line":541},{"name":"isa","containerName":"phase","line":541,"kind":12},{"name":"$term","containerName":"phase","line":542,"kind":13},{"name":"$val","containerName":"phase","line":542,"kind":13},{"containerName":"phase","name":"$term","line":544,"kind":13},{"name":"$term","containerName":"phase","kind":13,"line":544},{"containerName":"phase","name":"value","kind":12,"line":544},{"containerName":"phase","name":"$self","kind":13,"line":545},{"line":545,"kind":12,"name":"throw","containerName":"phase"},{"kind":13,"line":547,"containerName":"phase","name":"$self"},{"containerName":"phase","name":"remove_Annotations","kind":12,"line":547},{"name":"$self","containerName":"phase","line":548,"kind":13},{"name":"add_Annotation","containerName":"phase","line":548,"kind":12},{"containerName":"phase","name":"$term","kind":13,"line":548},{"name":"$self","containerName":"phase","kind":13,"line":551},{"containerName":"phase","name":"phase","line":551,"kind":12},{"containerName":"phase","name":"$self","line":551,"kind":13},{"name":"get_Annotations","containerName":"phase","line":551,"kind":12},{"containerName":"phase","name":"$self","line":553,"kind":13},{"line":553,"kind":12,"containerName":"phase","name":"get_Annotations"},{"containerName":"phase","name":"value","line":553,"kind":12}],"line":533,"kind":12,"range":{"start":{"line":533,"character":0},"end":{"line":554,"character":9999}},"definition":"sub","name":"phase","containerName":"main::"},{"kind":12,"line":540,"name":"Bio","containerName":"Annotation::SimpleValue"},{"range":{"end":{"character":9999,"line":589},"start":{"character":0,"line":568}},"containerName":"main::","definition":"sub","name":"frame","line":568,"children":[{"localvar":"my","containerName":"frame","definition":"my","name":"$self","line":569,"kind":13},{"localvar":"my","containerName":"frame","name":"$val","definition":"my","line":570,"kind":13},{"line":572,"kind":13,"name":"$val","containerName":"frame"},{"kind":13,"line":573,"definition":"my","name":"$term","containerName":"frame","localvar":"my"},{"kind":13,"line":574,"name":"$val","containerName":"frame"},{"name":"$term","containerName":"frame","line":575,"kind":13},{"kind":12,"line":575,"name":"new","containerName":"frame"},{"kind":13,"line":575,"name":"$val","containerName":"frame"},{"containerName":"frame","name":"$val","line":576,"kind":13},{"kind":13,"line":576,"containerName":"frame","name":"$val"},{"containerName":"frame","name":"isa","kind":12,"line":576},{"line":577,"kind":13,"name":"$term","containerName":"frame"},{"containerName":"frame","name":"$val","kind":13,"line":577},{"line":579,"kind":13,"containerName":"frame","name":"$term"},{"line":579,"kind":13,"name":"$term","containerName":"frame"},{"containerName":"frame","name":"value","line":579,"kind":12},{"line":580,"kind":13,"containerName":"frame","name":"$self"},{"kind":12,"line":580,"name":"throw","containerName":"frame"},{"containerName":"frame","name":"$self","kind":13,"line":582},{"kind":12,"line":582,"name":"remove_Annotations","containerName":"frame"},{"line":583,"kind":13,"name":"$self","containerName":"frame"},{"name":"add_Annotation","containerName":"frame","kind":12,"line":583},{"containerName":"frame","name":"$term","kind":13,"line":583},{"line":586,"kind":13,"name":"$self","containerName":"frame"},{"containerName":"frame","name":"frame","kind":12,"line":586},{"line":586,"kind":13,"name":"$self","containerName":"frame"},{"line":586,"kind":12,"name":"get_Annotations","containerName":"frame"},{"kind":13,"line":588,"name":"$self","containerName":"frame"},{"containerName":"frame","name":"get_Annotations","line":588,"kind":12},{"kind":12,"line":588,"containerName":"frame","name":"value"}],"kind":12},{"name":"Bio","containerName":"Annotation::SimpleValue","line":575,"kind":12},{"range":{"start":{"line":606,"character":0},"end":{"character":9999,"line":609}},"name":"add_Annotation","children":[{"kind":13,"line":607,"containerName":"add_Annotation","name":"$self","definition":"my","localvar":"my"},{"line":607,"kind":13,"containerName":"add_Annotation","name":"@args"},{"containerName":"add_Annotation","name":"$self","line":608,"kind":13},{"name":"annotation","containerName":"add_Annotation","line":608,"kind":12},{"containerName":"add_Annotation","name":"add_Annotation","line":608,"kind":12},{"containerName":"add_Annotation","name":"@args","kind":13,"line":608}],"line":606,"kind":12,"signature":{"label":"add_Annotation($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":620,"children":[{"localvar":"my","containerName":"remove_Annotations","definition":"my","name":"$self","line":621,"kind":13},{"line":621,"kind":13,"containerName":"remove_Annotations","name":"@args"},{"name":"$self","containerName":"remove_Annotations","line":622,"kind":13},{"name":"annotation","containerName":"remove_Annotations","kind":12,"line":622},{"kind":12,"line":622,"containerName":"remove_Annotations","name":"remove_Annotations"},{"kind":13,"line":622,"name":"@args","containerName":"remove_Annotations"}],"kind":12,"detail":"($self,@args)","signature":{"label":"remove_Annotations($self,@args)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":620},"end":{"character":9999,"line":623}},"name":"remove_Annotations"},{"range":{"start":{"character":0,"line":638},"end":{"line":641,"character":9999}},"containerName":"main::","name":"display_name","definition":"sub","line":638,"children":[{"kind":13,"line":639,"containerName":"display_name","definition":"my","name":"$self","localvar":"my"},{"line":640,"kind":13,"containerName":"display_name","name":"$self"},{"containerName":"display_name","name":"name","line":640,"kind":12}],"kind":12},{"children":[{"kind":13,"line":648,"containerName":"primary_tag","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":650,"name":"$val","definition":"my","containerName":"primary_tag","localvar":"my"},{"line":651,"kind":13,"localvar":"my","containerName":"primary_tag","definition":"my","name":"$term"},{"name":"$val","containerName":"primary_tag","line":652,"kind":13},{"name":"$val","containerName":"primary_tag","kind":13,"line":652},{"kind":13,"line":658,"name":"%__type_cache","containerName":"primary_tag"},{"containerName":"primary_tag","name":"%__type_cache","kind":13,"line":659},{"localvar":"my","name":"$anntext","definition":"my","containerName":"primary_tag","line":664,"kind":13},{"name":"$val","containerName":"primary_tag","line":664,"kind":13},{"kind":13,"line":665,"containerName":"primary_tag","name":"$__type_cache"},{"containerName":"primary_tag","name":"$anntext","line":665,"kind":13},{"containerName":"primary_tag","name":"$term","line":666,"kind":13},{"name":"$__type_cache","containerName":"primary_tag","kind":13,"line":666},{"containerName":"primary_tag","name":"$anntext","kind":13,"line":666},{"kind":13,"line":668,"containerName":"primary_tag","name":"$sofa","definition":"my","localvar":"my"},{"line":668,"kind":12,"name":"get_instance","containerName":"primary_tag"},{"containerName":"primary_tag","name":"get_ontology","line":668,"kind":12},{"kind":13,"line":669,"name":"$soterm","definition":"my","containerName":"primary_tag","localvar":"my"},{"containerName":"primary_tag","name":"$anntext","kind":13,"line":669},{"line":670,"kind":13,"name":"$sofa","containerName":"primary_tag"},{"name":"find_terms","containerName":"primary_tag","line":670,"kind":12},{"containerName":"primary_tag","name":"$anntext","kind":13,"line":670},{"line":671,"kind":13,"containerName":"primary_tag","name":"$sofa"},{"containerName":"primary_tag","name":"find_terms","line":671,"kind":12},{"kind":13,"line":671,"containerName":"primary_tag","name":"$anntext"},{"kind":13,"line":673,"name":"$soterm","containerName":"primary_tag"},{"kind":13,"line":674,"containerName":"primary_tag","name":"$self"},{"name":"throw","containerName":"primary_tag","kind":12,"line":674},{"localvar":"my","containerName":"primary_tag","definition":"my","name":"$newterm","line":676,"kind":13},{"kind":12,"line":676,"containerName":"primary_tag","name":"new"},{"line":677,"kind":13,"name":"$newterm","containerName":"primary_tag"},{"containerName":"primary_tag","name":"term","kind":12,"line":677},{"kind":13,"line":677,"containerName":"primary_tag","name":"$soterm"},{"name":"$term","containerName":"primary_tag","line":678,"kind":13},{"name":"$newterm","containerName":"primary_tag","kind":13,"line":678},{"kind":13,"line":681,"containerName":"primary_tag","name":"$self"},{"name":"type","containerName":"primary_tag","line":681,"kind":12},{"name":"$term","containerName":"primary_tag","kind":13,"line":681},{"localvar":"my","containerName":"primary_tag","definition":"my","name":"$t","line":685,"kind":13},{"name":"$self","containerName":"primary_tag","kind":13,"line":685},{"name":"type","containerName":"primary_tag","kind":12,"line":685},{"containerName":"primary_tag","name":"$t","line":686,"kind":13},{"line":686,"kind":12,"name":"name","containerName":"primary_tag"}],"line":647,"kind":12,"range":{"end":{"character":9999,"line":687},"start":{"character":0,"line":647}},"definition":"sub","name":"primary_tag","containerName":"main::"},{"name":"%__type_cache","definition":"our","containerName":"main::","kind":13,"line":655},{"name":"MAX_TYPE_CACHE_MEMBERS","line":658,"kind":12},{"containerName":"Ontology::OntologyStore","name":"Bio","line":668,"kind":12},{"line":676,"kind":12,"name":"Bio","containerName":"Annotation::OntologyTerm"},{"range":{"end":{"character":9999,"line":704},"start":{"line":693,"character":0}},"definition":"sub","name":"source_tag","containerName":"main::","children":[{"localvar":"my","containerName":"source_tag","definition":"my","name":"$self","line":694,"kind":13},{"name":"$val","definition":"my","containerName":"source_tag","localvar":"my","kind":13,"line":696},{"kind":13,"line":697,"name":"$val","containerName":"source_tag"},{"name":"$val","containerName":"source_tag","kind":13,"line":697},{"line":698,"kind":13,"localvar":"my","name":"$term","definition":"my","containerName":"source_tag"},{"line":698,"kind":12,"containerName":"source_tag","name":"new"},{"kind":13,"line":698,"name":"$val","containerName":"source_tag"},{"containerName":"source_tag","name":"$self","line":699,"kind":13},{"name":"source","containerName":"source_tag","line":699,"kind":12},{"containerName":"source_tag","name":"$term","kind":13,"line":699},{"kind":13,"line":702,"name":"$t","definition":"my","containerName":"source_tag","localvar":"my"},{"kind":13,"line":702,"name":"$self","containerName":"source_tag"},{"line":702,"kind":12,"containerName":"source_tag","name":"source"},{"line":703,"kind":13,"name":"$t","containerName":"source_tag"},{"name":"display_text","containerName":"source_tag","kind":12,"line":703}],"line":693,"kind":12},{"line":698,"kind":12,"name":"Bio","containerName":"Annotation::SimpleValue"},{"name":"uri_unescape","kind":12,"line":698},{"children":[{"kind":13,"line":719,"containerName":"attach_seq","name":"$self","definition":"my","localvar":"my"},{"line":719,"kind":13,"name":"$seq","containerName":"attach_seq"},{"containerName":"attach_seq","name":"$seq","kind":13,"line":721},{"kind":13,"line":721,"containerName":"attach_seq","name":"$seq"},{"containerName":"attach_seq","name":"$seq","line":721,"kind":13},{"kind":12,"line":721,"name":"isa","containerName":"attach_seq"},{"containerName":"attach_seq","name":"$self","kind":13,"line":722},{"containerName":"attach_seq","name":"throw","line":722,"kind":12},{"kind":13,"line":725,"containerName":"attach_seq","name":"$self"},{"containerName":"attach_seq","name":"$seq","kind":13,"line":725},{"line":728,"kind":13,"containerName":"attach_seq","name":"$self"},{"containerName":"attach_seq","name":"get_SeqFeatures","line":728,"kind":12},{"kind":12,"line":729,"name":"attach_seq","containerName":"attach_seq"},{"name":"$seq","containerName":"attach_seq","kind":13,"line":729}],"line":718,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object","label":"attach_seq($self,$seq)"},"detail":"($self,$seq)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":732},"start":{"character":0,"line":718}},"name":"attach_seq"},{"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none","parameters":[{"label":"$self"}],"label":"seq($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":745,"containerName":"seq","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"seq","line":747,"kind":13},{"kind":12,"line":747,"name":"entire_seq","containerName":"seq"},{"kind":13,"line":749,"containerName":"seq","definition":"my","name":"$seq","localvar":"my"},{"kind":13,"line":749,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"entire_seq","kind":12,"line":749},{"name":"trunc","containerName":"seq","kind":12,"line":749},{"name":"$self","containerName":"seq","kind":13,"line":749},{"containerName":"seq","name":"start","kind":12,"line":749},{"name":"$self","containerName":"seq","line":749,"kind":13},{"containerName":"seq","name":"end","line":749,"kind":12},{"kind":13,"line":751,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"strand","kind":12,"line":751},{"line":751,"kind":13,"containerName":"seq","name":"$self"},{"kind":12,"line":751,"containerName":"seq","name":"strand"},{"kind":13,"line":752,"name":"$seq","containerName":"seq"},{"containerName":"seq","name":"$seq","kind":13,"line":752},{"line":752,"kind":12,"name":"revcom","containerName":"seq"},{"line":755,"kind":13,"containerName":"seq","name":"$seq"}],"line":744,"kind":12,"range":{"end":{"character":9999,"line":756},"start":{"character":0,"line":744}},"name":"seq"},{"kind":12,"children":[],"line":768,"name":"entire_seq","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":770},"start":{"character":0,"line":768}}},{"containerName":"main::","name":"length","definition":"sub","range":{"start":{"character":0,"line":789},"end":{"character":9999,"line":792}},"kind":12,"line":789,"children":[{"line":790,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"length"},{"containerName":"length","name":"$self","line":791,"kind":13},{"name":"end","containerName":"length","line":791,"kind":12},{"line":791,"kind":13,"containerName":"length","name":"$self"},{"kind":12,"line":791,"name":"start","containerName":"length"}]},{"name":"start","range":{"end":{"line":806,"character":9999},"start":{"character":0,"line":803}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"start($self,$value)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":803,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start","line":804,"kind":13},{"kind":13,"line":804,"name":"$value","containerName":"start"},{"line":805,"kind":13,"containerName":"start","name":"$self"},{"name":"location","containerName":"start","kind":12,"line":805},{"name":"start","containerName":"start","kind":12,"line":805},{"kind":13,"line":805,"containerName":"start","name":"$value"}]},{"name":"end","range":{"start":{"line":817,"character":0},"end":{"line":820,"character":9999}},"kind":12,"line":817,"children":[{"name":"$self","definition":"my","containerName":"end","localvar":"my","kind":13,"line":818},{"name":"$value","containerName":"end","kind":13,"line":818},{"containerName":"end","name":"$self","kind":13,"line":819},{"line":819,"kind":12,"name":"location","containerName":"end"},{"containerName":"end","name":"end","line":819,"kind":12},{"containerName":"end","name":"$value","kind":13,"line":819}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"}},{"definition":"sub","name":"strand","containerName":"main::","range":{"end":{"character":9999,"line":834},"start":{"character":0,"line":831}},"kind":12,"children":[{"kind":13,"line":832,"name":"$self","definition":"my","containerName":"strand","localvar":"my"},{"kind":13,"line":833,"name":"$self","containerName":"strand"},{"containerName":"strand","name":"location","line":833,"kind":12},{"containerName":"strand","name":"strand","line":833,"kind":12}],"line":831},{"kind":12,"children":[],"line":856,"name":"get_SeqFeatures","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":857},"start":{"character":0,"line":856}}},{"name":"shift","line":857,"kind":12},{"detail":"($self,$val,$expand)","signature":{"parameters":[{"label":"$self"},{"label":"$val"},{"label":"$expand"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object","label":"add_SeqFeature($self,$val,$expand)"},"containerName":"main::","definition":"sub","line":878,"children":[{"kind":13,"line":879,"containerName":"add_SeqFeature","name":"$self","definition":"my","localvar":"my"},{"line":879,"kind":13,"containerName":"add_SeqFeature","name":"$val"},{"kind":13,"line":879,"containerName":"add_SeqFeature","name":"$expand"},{"name":"$val","containerName":"add_SeqFeature","line":881,"kind":13},{"kind":13,"line":883,"containerName":"add_SeqFeature","name":"$val"},{"kind":13,"line":883,"containerName":"add_SeqFeature","name":"$val"},{"name":"isa","containerName":"add_SeqFeature","line":883,"kind":12},{"kind":13,"line":884,"containerName":"add_SeqFeature","name":"$self"},{"kind":12,"line":884,"containerName":"add_SeqFeature","name":"throw"},{"name":"$val","containerName":"add_SeqFeature","line":884,"kind":13},{"name":"$val","containerName":"add_SeqFeature","kind":13,"line":884},{"containerName":"add_SeqFeature","name":"$val","kind":13,"line":884},{"name":"$expand","containerName":"add_SeqFeature","line":888,"kind":13},{"containerName":"add_SeqFeature","name":"$expand","kind":13,"line":888},{"kind":13,"line":889,"containerName":"add_SeqFeature","name":"$self"},{"name":"_expand_region","containerName":"add_SeqFeature","kind":12,"line":889},{"name":"$val","containerName":"add_SeqFeature","line":889,"kind":13},{"name":"$self","containerName":"add_SeqFeature","kind":13,"line":891},{"name":"contains","containerName":"add_SeqFeature","kind":12,"line":891},{"kind":13,"line":891,"name":"$val","containerName":"add_SeqFeature"},{"line":892,"kind":13,"containerName":"add_SeqFeature","name":"$self"},{"kind":12,"line":892,"name":"warn","containerName":"add_SeqFeature"},{"containerName":"add_SeqFeature","name":"$self","kind":13,"line":897}],"kind":12,"range":{"end":{"line":897,"character":9999},"start":{"character":0,"line":878}},"name":"add_SeqFeature"},{"containerName":null,"name":"$val","line":897,"kind":13},{"range":{"start":{"character":0,"line":911},"end":{"character":9999,"line":914}},"name":"remove_SeqFeatures","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none","parameters":[{"label":"$self"}],"label":"remove_SeqFeatures($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"remove_SeqFeatures","definition":"my","name":"$self","localvar":"my","kind":13,"line":912},{"localvar":"my","containerName":"remove_SeqFeatures","name":"@subfeats","definition":"my","line":914,"kind":13},{"containerName":"remove_SeqFeatures","name":"$self","line":914,"kind":13}],"line":911,"kind":12},{"name":"%self","containerName":null,"line":915,"kind":13},{"containerName":null,"name":"@subfeats","line":916,"kind":13},{"children":[{"localvar":"my","containerName":"annotation","definition":"my","name":"$obj","line":936,"kind":13},{"line":936,"kind":13,"name":"$value","containerName":"annotation"},{"kind":13,"line":940,"containerName":"annotation","name":"$value"},{"kind":13,"line":940,"name":"$obj","containerName":"annotation"},{"name":"$value","containerName":"annotation","line":941,"kind":13},{"containerName":"annotation","name":"new","line":941,"kind":12},{"line":941,"kind":13,"name":"$value","containerName":"annotation"},{"line":942,"kind":13,"name":"$obj","containerName":"annotation"},{"kind":13,"line":942,"name":"$value","containerName":"annotation"},{"kind":13,"line":944,"containerName":"annotation","name":"$obj"}],"line":935,"kind":12,"signature":{"label":"annotation($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)"},"detail":"($obj,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":935},"end":{"line":945,"character":9999}},"name":"annotation"},{"name":"Bio","containerName":"Annotation::Collection","line":941,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"location($self,$value)"},"kind":12,"line":959,"children":[{"name":"$self","definition":"my","containerName":"location","localvar":"my","kind":13,"line":960},{"name":"$value","containerName":"location","kind":13,"line":960},{"name":"$value","containerName":"location","kind":13,"line":962},{"kind":13,"line":963,"name":"$value","containerName":"location"},{"containerName":"location","name":"$value","kind":13,"line":963},{"kind":12,"line":963,"name":"isa","containerName":"location"},{"name":"$self","containerName":"location","line":964,"kind":13},{"name":"throw","containerName":"location","line":964,"kind":12},{"kind":13,"line":967,"name":"$self","containerName":"location"},{"name":"$value","containerName":"location","kind":13,"line":967},{"kind":13,"line":969,"containerName":"location","name":"$self"},{"name":"$self","containerName":"location","kind":13,"line":971},{"name":"new","containerName":"location","line":971,"kind":12},{"name":"$self","containerName":"location","line":973,"kind":13}],"name":"location","range":{"end":{"character":9999,"line":974},"start":{"line":959,"character":0}}},{"containerName":"Location::Simple","name":"Bio","line":971,"kind":12},{"range":{"end":{"line":988,"character":9999},"start":{"character":0,"line":985}},"name":"add_target","children":[{"line":986,"kind":13,"localvar":"my","containerName":"add_target","definition":"my","name":"$self"},{"name":"$seq","containerName":"add_target","line":986,"kind":13},{"kind":13,"line":987,"name":"$self","containerName":"add_target"},{"containerName":"add_target","name":"throw","kind":12,"line":987},{"containerName":"add_target","name":"$seq","kind":13,"line":987},{"line":987,"kind":12,"containerName":"add_target","name":"isa"},{"name":"$self","containerName":"add_target","kind":13,"line":988}],"line":985,"kind":12,"signature":{"label":"add_target($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object"},"detail":"($self,$seq)","definition":"sub","containerName":"main::"},{"kind":13,"line":988,"name":"$seq","containerName":null},{"containerName":null,"name":"$seq","kind":13,"line":989},{"children":[{"localvar":"my","containerName":"each_target","definition":"my","name":"$self","line":1003,"kind":13},{"name":"$self","containerName":"each_target","line":1004,"kind":13},{"kind":13,"line":1004,"containerName":"each_target","name":"$self"}],"line":1002,"kind":12,"signature":{"label":"each_target($self)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1004},"start":{"character":0,"line":1002}},"name":"each_target"},{"range":{"start":{"line":1021,"character":0},"end":{"line":1038,"character":9999}},"name":"_expand_region","signature":{"label":"_expand_region($self,$feat)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.","parameters":[{"label":"$self"},{"label":"$feat"}]},"detail":"($self,$feat)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1022,"containerName":"_expand_region","name":"$self","definition":"my","localvar":"my"},{"name":"$feat","containerName":"_expand_region","kind":13,"line":1022},{"line":1023,"kind":13,"name":"$feat","containerName":"_expand_region"},{"kind":12,"line":1023,"containerName":"_expand_region","name":"isa"},{"line":1024,"kind":13,"name":"$self","containerName":"_expand_region"},{"containerName":"_expand_region","name":"warn","line":1024,"kind":12},{"name":"$self","containerName":"_expand_region","kind":13,"line":1027},{"name":"start","containerName":"_expand_region","line":1027,"kind":12},{"name":"$self","containerName":"_expand_region","kind":13,"line":1027},{"containerName":"_expand_region","name":"end","line":1027,"kind":12},{"name":"$self","containerName":"_expand_region","line":1028,"kind":13},{"name":"start","containerName":"_expand_region","kind":12,"line":1028},{"name":"$feat","containerName":"_expand_region","kind":13,"line":1028},{"kind":12,"line":1028,"containerName":"_expand_region","name":"start"},{"kind":13,"line":1029,"name":"$self","containerName":"_expand_region"},{"kind":12,"line":1029,"containerName":"_expand_region","name":"end"},{"containerName":"_expand_region","name":"$feat","kind":13,"line":1029},{"line":1029,"kind":12,"containerName":"_expand_region","name":"end"},{"line":1030,"kind":13,"containerName":"_expand_region","name":"$self"},{"name":"strand","containerName":"_expand_region","line":1030,"kind":12},{"name":"$feat","containerName":"_expand_region","kind":13,"line":1030},{"name":"strand","containerName":"_expand_region","kind":12,"line":1030},{"line":1030,"kind":13,"name":"$self","containerName":"_expand_region"},{"containerName":"_expand_region","name":"strand","line":1030,"kind":12},{"localvar":"my","containerName":"_expand_region","name":"$range","definition":"my","line":1033,"kind":13},{"containerName":"_expand_region","name":"$self","line":1033,"kind":13},{"name":"union","containerName":"_expand_region","kind":12,"line":1033},{"line":1033,"kind":13,"containerName":"_expand_region","name":"$feat"},{"line":1034,"kind":13,"name":"$self","containerName":"_expand_region"},{"line":1034,"kind":12,"containerName":"_expand_region","name":"start"},{"kind":13,"line":1034,"name":"$range","containerName":"_expand_region"},{"containerName":"_expand_region","name":"start","line":1034,"kind":12},{"name":"$self","containerName":"_expand_region","line":1035,"kind":13},{"line":1035,"kind":12,"name":"end","containerName":"_expand_region"},{"containerName":"_expand_region","name":"$range","line":1035,"kind":13},{"kind":12,"line":1035,"containerName":"_expand_region","name":"end"},{"kind":13,"line":1036,"name":"$self","containerName":"_expand_region"},{"name":"strand","containerName":"_expand_region","line":1036,"kind":12},{"line":1036,"kind":13,"name":"$range","containerName":"_expand_region"},{"kind":12,"line":1036,"name":"strand","containerName":"_expand_region"}],"line":1021,"kind":12},{"kind":12,"children":[{"kind":13,"line":1065,"containerName":"get_Annotations","name":"$self","definition":"my","localvar":"my"},{"definition":"my","name":"@annotations","containerName":"get_Annotations","localvar":"my","kind":13,"line":1067},{"containerName":"get_Annotations","name":"$self","kind":13,"line":1067},{"containerName":"get_Annotations","name":"annotation","line":1067,"kind":12},{"containerName":"get_Annotations","name":"get_Annotations","line":1067,"kind":12},{"line":1070,"kind":13,"name":"@annotations","containerName":"get_Annotations"},{"line":1071,"kind":13,"containerName":"get_Annotations","name":"@annotations"},{"containerName":"get_Annotations","name":"$annotations","line":1072,"kind":13},{"name":"@annotations","containerName":"get_Annotations","line":1074,"kind":13}],"line":1064,"definition":"sub","name":"get_Annotations","containerName":"main::","range":{"start":{"character":0,"line":1064},"end":{"line":1076,"character":9999}}},{"signature":{"label":"has_tag($self,$tag)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag","parameters":[{"label":"$self"},{"label":"$tag"}]},"detail":"($self,$tag)","definition":"sub","containerName":"main::","children":[{"line":1102,"kind":13,"localvar":"my","containerName":"has_tag","definition":"my","name":"$self"},{"line":1102,"kind":13,"name":"$tag","containerName":"has_tag"},{"containerName":"has_tag","name":"$self","kind":13,"line":1103},{"line":1103,"kind":12,"name":"annotation","containerName":"has_tag"},{"name":"get_Annotations","containerName":"has_tag","kind":12,"line":1103},{"name":"$tag","containerName":"has_tag","line":1103,"kind":13}],"line":1101,"kind":12,"range":{"end":{"line":1104,"character":9999},"start":{"line":1101,"character":0}},"name":"has_tag"},{"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"@vals"}],"label":"add_tag_value($self,$tag,@vals)"},"detail":"($self,$tag,@vals)","definition":"sub","containerName":"main::","children":[{"line":1111,"kind":13,"localvar":"my","containerName":"add_tag_value","name":"$self","definition":"my"},{"line":1111,"kind":13,"containerName":"add_tag_value","name":"$tag"},{"containerName":"add_tag_value","name":"@vals","line":1111,"kind":13},{"name":"$val","definition":"my","containerName":"add_tag_value","localvar":"my","kind":13,"line":1113},{"containerName":"add_tag_value","name":"@vals","kind":13,"line":1113},{"line":1114,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"add_tag_value"},{"line":1114,"kind":13,"containerName":"add_tag_value","name":"$tagclass"},{"name":"$tag","containerName":"add_tag_value","line":1114,"kind":13},{"name":"$tagclass","containerName":"add_tag_value","line":1114,"kind":13},{"localvar":"my","containerName":"add_tag_value","definition":"my","name":"$slot","line":1115,"kind":13},{"containerName":"add_tag_value","name":"$tag2text","line":1115,"kind":13},{"name":"$class","containerName":"add_tag_value","line":1115,"kind":13},{"definition":"my","name":"$a","containerName":"add_tag_value","localvar":"my","kind":13,"line":1117},{"kind":13,"line":1117,"name":"$class","containerName":"add_tag_value"},{"name":"new","containerName":"add_tag_value","line":1117,"kind":12},{"containerName":"add_tag_value","name":"$a","line":1118,"kind":13},{"line":1118,"kind":13,"containerName":"add_tag_value","name":"$slot"},{"name":"$val","containerName":"add_tag_value","line":1118,"kind":13},{"line":1120,"kind":13,"containerName":"add_tag_value","name":"$self"},{"kind":12,"line":1120,"containerName":"add_tag_value","name":"annotation"},{"line":1120,"kind":12,"name":"add_Annotation","containerName":"add_tag_value"},{"containerName":"add_tag_value","name":"$tag","line":1120,"kind":13},{"containerName":"add_tag_value","name":"$a","kind":13,"line":1120}],"line":1110,"kind":12,"range":{"start":{"character":0,"line":1110},"end":{"line":1124,"character":9999}},"name":"add_tag_value"},{"line":1114,"kind":12,"name":"__DEFAULT__"},{"range":{"end":{"character":9999,"line":1149},"start":{"line":1135,"character":0}},"name":"get_tag_values","signature":{"label":"get_tag_values($self,$tag)","parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name"},"detail":"($self,$tag)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1136,"name":"$self","definition":"my","containerName":"get_tag_values","localvar":"my"},{"name":"$tag","containerName":"get_tag_values","line":1136,"kind":13},{"name":"$tagclass","containerName":"get_tag_values","kind":13,"line":1137},{"kind":13,"line":1137,"containerName":"get_tag_values","name":"$tag"},{"kind":13,"line":1137,"name":"$self","containerName":"get_tag_values"},{"name":"annotation","containerName":"get_tag_values","kind":12,"line":1137},{"line":1137,"kind":12,"name":"get_Annotations","containerName":"get_tag_values"},{"line":1137,"kind":13,"containerName":"get_tag_values","name":"$tag"},{"line":1139,"kind":13,"localvar":"my","containerName":"get_tag_values","definition":"my","name":"$proto"},{"containerName":"get_tag_values","name":"$self","kind":13,"line":1139},{"containerName":"get_tag_values","name":"annotation","line":1139,"kind":12},{"name":"get_Annotations","containerName":"get_tag_values","line":1139,"kind":12},{"line":1139,"kind":13,"name":"$tag","containerName":"get_tag_values"},{"line":1141,"kind":13,"containerName":"get_tag_values","name":"$tag2text"},{"kind":13,"line":1141,"name":"$proto","containerName":"get_tag_values"},{"line":1142,"kind":13,"name":"$tagclass","containerName":"get_tag_values"},{"containerName":"get_tag_values","name":"$tag","kind":13,"line":1142},{"name":"$proto","containerName":"get_tag_values","kind":13,"line":1142},{"kind":13,"line":1146,"definition":"my","name":"$slot","containerName":"get_tag_values","localvar":"my"},{"name":"$tag2text","containerName":"get_tag_values","line":1146,"kind":13},{"containerName":"get_tag_values","name":"$tagclass","kind":13,"line":1146},{"line":1146,"kind":13,"containerName":"get_tag_values","name":"$tag"},{"name":"$tagclass","containerName":"get_tag_values","kind":13,"line":1146},{"name":"$slot","containerName":"get_tag_values","line":1148,"kind":13},{"kind":13,"line":1148,"name":"$self","containerName":"get_tag_values"},{"name":"annotation","containerName":"get_tag_values","kind":12,"line":1148},{"line":1148,"kind":12,"containerName":"get_tag_values","name":"get_Annotations"},{"line":1148,"kind":13,"containerName":"get_tag_values","name":"$tag"}],"line":1135,"kind":12},{"line":1146,"kind":12,"name":"__DEFAULT__"},{"name":"get_tagset_values","range":{"end":{"character":9999,"line":1170},"start":{"character":0,"line":1162}},"kind":12,"line":1162,"children":[{"line":1163,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_tagset_values"},{"name":"@tags","containerName":"get_tagset_values","line":1163,"kind":13},{"localvar":"my","containerName":"get_tagset_values","definition":"my","name":"@r","line":1164,"kind":13},{"localvar":"my","name":"$tag","definition":"my","containerName":"get_tagset_values","line":1165,"kind":13},{"line":1165,"kind":13,"containerName":"get_tagset_values","name":"@tags"},{"line":1166,"kind":13,"localvar":"my","containerName":"get_tagset_values","definition":"my","name":"$slot"},{"kind":13,"line":1166,"containerName":"get_tagset_values","name":"$tag2text"},{"containerName":"get_tagset_values","name":"$tagclass","line":1166,"kind":13},{"line":1166,"kind":13,"containerName":"get_tagset_values","name":"$tag"},{"line":1166,"kind":13,"containerName":"get_tagset_values","name":"$tagclass"},{"name":"@r","containerName":"get_tagset_values","kind":13,"line":1167},{"containerName":"get_tagset_values","name":"$slot","kind":13,"line":1167},{"containerName":"get_tagset_values","name":"$self","line":1167,"kind":13},{"name":"annotation","containerName":"get_tagset_values","line":1167,"kind":12},{"containerName":"get_tagset_values","name":"get_Annotations","kind":12,"line":1167},{"containerName":"get_tagset_values","name":"$tag","line":1167,"kind":13},{"kind":13,"line":1169,"name":"@r","containerName":"get_tagset_values"}],"containerName":"main::","definition":"sub","detail":"($self,@tags)","signature":{"label":"get_tagset_values($self,@tags)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names","parameters":[{"label":"$self"},{"label":"@tags"}]}},{"name":"__DEFAULT__","line":1166,"kind":12},{"name":"get_all_tags","range":{"start":{"line":1181,"character":0},"end":{"character":9999,"line":1184}},"kind":12,"line":1181,"children":[{"line":1182,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_all_tags"},{"line":1182,"kind":13,"containerName":"get_all_tags","name":"@args"},{"line":1183,"kind":13,"name":"$self","containerName":"get_all_tags"},{"line":1183,"kind":12,"name":"annotation","containerName":"get_all_tags"},{"line":1183,"kind":12,"name":"get_all_annotation_keys","containerName":"get_all_tags"},{"containerName":"get_all_tags","name":"@args","kind":13,"line":1183}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names\n\n\nsub get_tagset_values {\n  my ($self,@tags) = @_;\n  my @r = ();\n  foreach my $tag (@tags){\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    push @r, map { $_->$slot } $self->annotation->get_Annotations($tag);\n  }\n  return @r;\n}\n\n=head2 get_all_tags\n\n Usage   : @tags = $obj->get_all_tags()\n Function: returns a list of annotation tag names.\n Returns : a list of tag names\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_all_tags($self,@args)"}},{"detail":"($self,@args)","signature":{"label":"remove_tag($self,@args)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names\n\n\nsub get_tagset_values {\n  my ($self,@tags) = @_;\n  my @r = ();\n  foreach my $tag (@tags){\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    push @r, map { $_->$slot } $self->annotation->get_Annotations($tag);\n  }\n  return @r;\n}\n\n=head2 get_all_tags\n\n Usage   : @tags = $obj->get_all_tags()\n Function: returns a list of annotation tag names.\n Returns : a list of tag names\n Args    : none\n\n\nsub get_all_tags {\n  my ($self,@args) = @_;\n  return $self->annotation->get_all_annotation_keys(@args);\n}\n\n=head2 remove_tag\n\n Usage   : See remove_Annotations().\n Function:\n Returns : \n Args    : \n Note    : Contrary to what the name suggests, this method removes\n           all annotations corresponding to $tag, not just a\n           single anntoation.","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":1198,"children":[{"localvar":"my","containerName":"remove_tag","definition":"my","name":"$self","line":1199,"kind":13},{"line":1199,"kind":13,"name":"@args","containerName":"remove_tag"},{"name":"$self","containerName":"remove_tag","line":1200,"kind":13},{"line":1200,"kind":12,"name":"annotation","containerName":"remove_tag"},{"kind":12,"line":1200,"name":"remove_Annotations","containerName":"remove_tag"},{"kind":13,"line":1200,"containerName":"remove_tag","name":"@args"}],"kind":12,"range":{"start":{"character":0,"line":1198},"end":{"character":9999,"line":1201}},"name":"remove_tag"}]}