{"version":5,"vars":[{"range":{"start":{"line":120,"character":0},"end":{"character":9999,"line":127}},"name":"trace","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base","label":"trace($self)"},"containerName":"main::","definition":"sub","line":120,"children":[{"line":121,"kind":13,"localvar":"my","containerName":"trace","name":"$self","definition":"my"},{"kind":13,"line":122,"containerName":"trace","name":"$self"},{"containerName":"trace","name":"can","kind":12,"line":122},{"kind":13,"line":123,"name":"$self","containerName":"trace"},{"containerName":"trace","name":"throw","kind":12,"line":123}],"kind":12},{"name":"RootI","containerName":"Dumpvalue::Bio::Root","line":121,"kind":2},{"line":125,"kind":12,"name":"confess"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base\n\n\nsub trace {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   }\n}\n\n=head2 subtrace($base,$start,$end)\n\n Title   : subtrace($base,$start,$end)\n Usage   : @subset_of_traces = @{$obj->subtrace(\"A\",10,40)};\n Function: returns the trace values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo trace values of this base. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : $base: \"A\",\"T\",\"G\" or \"C\"\n          $start: a start position\n          $end  : an end position","label":"subtrace($self)"},"kind":12,"line":144,"children":[{"kind":13,"line":145,"containerName":"subtrace","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"subtrace","line":147,"kind":13},{"containerName":"subtrace","name":"can","line":147,"kind":12},{"name":"$self","containerName":"subtrace","line":148,"kind":13},{"name":"throw","containerName":"subtrace","line":148,"kind":12}],"name":"subtrace","range":{"start":{"character":0,"line":144},"end":{"line":153,"character":9999}}},{"name":"confess","line":150,"kind":12},{"children":[{"line":177,"kind":13,"localvar":"my","containerName":"can_call_new","name":"$self","definition":"my"},{"name":"@args","containerName":"can_call_new","kind":13,"line":177}],"line":176,"kind":12,"signature":{"label":"can_call_new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base\n\n\nsub trace {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   }\n}\n\n=head2 subtrace($base,$start,$end)\n\n Title   : subtrace($base,$start,$end)\n Usage   : @subset_of_traces = @{$obj->subtrace(\"A\",10,40)};\n Function: returns the trace values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo trace values of this base. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : $base: \"A\",\"T\",\"G\" or \"C\"\n          $start: a start position\n          $end  : an end position\n\n\nsub subtrace {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":176,"character":0},"end":{"character":9999,"line":180}},"name":"can_call_new"},{"signature":{"label":"traceat($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base\n\n\nsub trace {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   }\n}\n\n=head2 subtrace($base,$start,$end)\n\n Title   : subtrace($base,$start,$end)\n Usage   : @subset_of_traces = @{$obj->subtrace(\"A\",10,40)};\n Function: returns the trace values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo trace values of this base. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : $base: \"A\",\"T\",\"G\" or \"C\"\n          $start: a start position\n          $end  : an end position\n\n\nsub subtrace {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 traceat($channel,$position)\n\n Title   : qualat($channel,$position)\n Usage   : $trace = $obj->traceat(500);\n Function: Return the trace value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A base and a position."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"containerName":"traceat","definition":"my","name":"$self","localvar":"my","kind":13,"line":196},{"name":"$value","containerName":"traceat","kind":13,"line":196},{"line":197,"kind":13,"name":"$self","containerName":"traceat"},{"kind":12,"line":197,"name":"can","containerName":"traceat"},{"kind":13,"line":198,"name":"$self","containerName":"traceat"},{"name":"warn","containerName":"traceat","kind":12,"line":198}],"line":195,"kind":12,"range":{"end":{"line":203,"character":9999},"start":{"character":0,"line":195}},"name":"traceat"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base\n\n\nsub trace {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   }\n}\n\n=head2 subtrace($base,$start,$end)\n\n Title   : subtrace($base,$start,$end)\n Usage   : @subset_of_traces = @{$obj->subtrace(\"A\",10,40)};\n Function: returns the trace values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo trace values of this base. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : $base: \"A\",\"T\",\"G\" or \"C\"\n          $start: a start position\n          $end  : an end position\n\n\nsub subtrace {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 traceat($channel,$position)\n\n Title   : qualat($channel,$position)\n Usage   : $trace = $obj->traceat(500);\n Function: Return the trace value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A base and a position.\n\n\nsub traceat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::TraceI definition of traceat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::TraceI definition of traceat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $obj->length(\"A\");\n Function: Return the length of the array holding the trace values for the \"A\"\n     channel. A check should be done to make sure that this Trace object\n     is_complete() before doing this to prevent hazardous results.\n Returns : A scalar (the number of elements in the quality array).\n Args    : If used, get the traces from that channel. Default to \"A\"","parameters":[{"label":"$self"}],"label":"length($self)"},"kind":12,"line":217,"children":[{"line":218,"kind":13,"localvar":"my","containerName":"length","definition":"my","name":"$self"},{"line":219,"kind":13,"containerName":"length","name":"$self"},{"name":"can","containerName":"length","line":219,"kind":12},{"containerName":"length","name":"$self","kind":13,"line":220},{"name":"throw","containerName":"length","kind":12,"line":220}],"name":"length","range":{"start":{"line":217,"character":0},"end":{"line":224,"character":9999}}},{"kind":12,"line":222,"name":"confess"},{"children":[{"line":237,"kind":13,"localvar":"my","containerName":"trace_indices","name":"$self","definition":"my"},{"name":"$self","containerName":"trace_indices","kind":13,"line":238},{"kind":12,"line":238,"name":"can","containerName":"trace_indices"},{"line":239,"kind":13,"containerName":"trace_indices","name":"$self"},{"line":239,"kind":12,"name":"throw","containerName":"trace_indices"}],"line":236,"kind":12,"signature":{"label":"trace_indices($self)","documentation":"1;\n# BioPerl module for Bio::Seq::TraceI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::TraceI - Interface definition for a Bio::Seq::Trace\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n          $st = &get_object_somehow();\n\n    # to test this is a seq object\n          $st->isa(\"Bio::Seq::TraceI\") \n               || $obj->throw(\"$obj does not implement the Bio::Seq::TraceI interface\");\n\n          # set the trace for T to be @trace_points\n     my $arrayref = $st->trace(\"T\",\\@trace_points);\n          # get the trace points for \"C\"\n     my $arrayref = $st->trace(\"C\");\n          # get a subtrace for \"G\" from 10 to 100 \n     $arrayref = $st->subtrace(\"G\",10,100);\n          # what is the trace value for \"A\" at position 355?\n     my $trace_calue = $st->traceat(\"A\",355);\n          # create a false trace for \"A\" with $accuracy\n     $arrayref = $st->false_trace(\"A\",Bio::Seq::Quality, $accuracy);\n          # does this trace have entries for each base?\n     $bool = $st->is_complete();\n          # how many entries are there in this trace?\n     $length = $st->length();\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic trace information. This\ninformation may have come from an ABI- or scf- formatted file or may have been\nmade up.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::TraceI;\nuse strict;\nuse Carp;\nuse Dumpvalue;\nuse Bio::Root::RootI;\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 trace($base,\\@new_values)\n\n Title   : trace($base,\\@new_values)\n Usage   : @trace_Values  = @{$obj->trace($base,\\@new_values)};\n Function: Returns the trace values as a reference to an array containing the\n     trace values. The individual elements of the trace array are not validated\n     and can be any numeric value.\n Returns : A reference to an array.\n Status  : \nArguments: $base : which color channel would you like the trace values for?\n               - $base must be one of \"A\",\"T\",\"G\",\"C\"\n          \\@new_values : a reference to an array of values containing trace\n               data for this base\n\n\nsub trace {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of trace - implementing class did not provide this method\");\n   }\n}\n\n=head2 subtrace($base,$start,$end)\n\n Title   : subtrace($base,$start,$end)\n Usage   : @subset_of_traces = @{$obj->subtrace(\"A\",10,40)};\n Function: returns the trace values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo trace values of this base. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : $base: \"A\",\"T\",\"G\" or \"C\"\n          $start: a start position\n          $end  : an end position\n\n\nsub subtrace {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of subtrace - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 traceat($channel,$position)\n\n Title   : qualat($channel,$position)\n Usage   : $trace = $obj->traceat(500);\n Function: Return the trace value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A base and a position.\n\n\nsub traceat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::TraceI definition of traceat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::TraceI definition of traceat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $obj->length(\"A\");\n Function: Return the length of the array holding the trace values for the \"A\"\n     channel. A check should be done to make sure that this Trace object\n     is_complete() before doing this to prevent hazardous results.\n Returns : A scalar (the number of elements in the quality array).\n Args    : If used, get the traces from that channel. Default to \"A\"\n\n\nsub length {\n   my ($self)= @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::TraceI definition of length - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::TraceI definition of length - implementing class did not provide this method\");\n   }\n}\n\n=head2 trace_indices($new_indices)\n\n Title   : trace_indices($new_indices)\n Usage   : $indices = $obj->trace_indices($new_indices);\n Function: Return the trace iindex points for this object.\n Returns : A scalar\n Args    : If used, the trace indices will be set to the provided value.","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":243}},"name":"trace_indices"},{"kind":12,"line":241,"name":"confess"}]}