{"version":5,"vars":[{"line":133,"kind":2,"name":"base","containerName":""},{"line":135,"kind":13,"localvar":"my","name":"%slot_param_map","definition":"my","containerName":null},{"definition":"my","name":"%param_slot_map","containerName":null,"localvar":"my","kind":13,"line":137},{"name":"new","range":{"end":{"line":162,"character":9999},"start":{"character":0,"line":150}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":150,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":151,"kind":13},{"name":"@args","containerName":"new","line":151,"kind":13},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":153},{"line":153,"kind":13,"name":"$class","containerName":"new"},{"line":153,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":155},{"line":156,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":157,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","line":158,"kind":13},{"line":159,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":159,"containerName":"new","name":"want_all"},{"line":161,"kind":13,"containerName":"new","name":"$self"}]},{"containerName":"new","name":"SUPER","line":153,"kind":12},{"kind":12,"line":192,"children":[{"line":193,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"want_slot"},{"name":"$slot","containerName":"want_slot","line":193,"kind":13},{"line":194,"kind":13,"localvar":"my","definition":"my","name":"$ok","containerName":"want_slot"},{"containerName":"want_slot","name":"$slot","kind":13,"line":196},{"line":196,"kind":13,"name":"$slot","containerName":"want_slot"},{"name":"$slot","containerName":"want_slot","kind":13,"line":196},{"containerName":"want_slot","name":"$self","line":197,"kind":13},{"kind":12,"line":197,"containerName":"want_slot","name":"want_all"},{"kind":13,"line":198,"containerName":"want_slot","name":"$self"},{"kind":12,"line":198,"containerName":"want_slot","name":"get_unwanted_slots"},{"kind":13,"line":200,"name":"$slot","containerName":"want_slot"},{"kind":13,"line":202,"name":"$self","containerName":"want_slot"},{"containerName":"want_slot","name":"$self","line":203,"kind":13},{"kind":13,"line":203,"name":"$self","containerName":"want_slot"},{"containerName":"want_slot","name":"sequence_factory","kind":12,"line":203},{"line":203,"kind":12,"name":"create_object","containerName":"want_slot"},{"line":205,"kind":13,"containerName":"want_slot","name":"$param_slot_map"},{"line":205,"kind":13,"name":"$slot","containerName":"want_slot"},{"name":"$ok","containerName":"want_slot","kind":13,"line":206},{"kind":13,"line":206,"containerName":"want_slot","name":"$self"},{"containerName":"want_slot","name":"can","line":206,"kind":12},{"containerName":"want_slot","name":"$param_slot_map","line":206,"kind":13},{"line":206,"kind":13,"containerName":"want_slot","name":"$slot"},{"containerName":"want_slot","name":"$ok","kind":13,"line":208},{"name":"$self","containerName":"want_slot","line":208,"kind":13},{"name":"can","containerName":"want_slot","kind":12,"line":208},{"line":208,"kind":13,"containerName":"want_slot","name":"$slot"},{"containerName":"want_slot","name":"$ok","line":210,"kind":13},{"containerName":"want_slot","name":"$ok","line":210,"kind":13},{"kind":13,"line":214,"name":"$self","containerName":"want_slot"},{"name":"get_wanted_slots","containerName":"want_slot","line":214,"kind":12},{"containerName":"want_slot","name":"$slot","kind":13,"line":215},{"containerName":"want_slot","name":"$ok","kind":13,"line":216},{"kind":13,"line":220,"containerName":"want_slot","name":"$ok"}],"containerName":"main::","definition":"sub","detail":"($self,$slot)","signature":{"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)","parameters":[{"label":"$self"},{"label":"$slot"}],"label":"want_slot($self,$slot)"},"name":"want_slot","range":{"end":{"character":9999,"line":221},"start":{"line":192,"character":0}}},{"kind":12,"line":264,"children":[{"localvar":"my","containerName":"add_slot_value","name":"$self","definition":"my","line":265,"kind":13},{"containerName":"add_slot_value","name":"$slot","kind":13,"line":265},{"line":265,"kind":13,"containerName":"add_slot_value","name":"@args"},{"line":267,"kind":13,"localvar":"my","containerName":"add_slot_value","definition":"my","name":"$h"},{"containerName":"add_slot_value","name":"$self","kind":13,"line":267},{"kind":13,"line":268,"name":"$h","containerName":"add_slot_value"},{"containerName":"add_slot_value","name":"@args","kind":13,"line":270},{"line":270,"kind":13,"name":"@args","containerName":"add_slot_value"},{"name":"$slot","containerName":"add_slot_value","kind":13,"line":270},{"name":"@args","containerName":"add_slot_value","kind":13,"line":271},{"name":"$slot","containerName":"add_slot_value","line":271,"kind":13},{"kind":13,"line":272,"containerName":"add_slot_value","name":"@args"},{"localvar":"my","containerName":"add_slot_value","definition":"my","name":"$key","line":273,"kind":13},{"kind":13,"line":273,"containerName":"add_slot_value","name":"@args"},{"kind":13,"line":274,"name":"$h","containerName":"add_slot_value"},{"kind":13,"line":274,"containerName":"add_slot_value","name":"$key"},{"line":274,"kind":13,"containerName":"add_slot_value","name":"@args"},{"line":277,"kind":13,"containerName":"add_slot_value","name":"$slot"},{"kind":13,"line":278,"name":"$slot","containerName":"add_slot_value"},{"line":278,"kind":13,"name":"$slot_param_map","containerName":"add_slot_value"},{"containerName":"add_slot_value","name":"$slot","kind":13,"line":278},{"name":"$h","containerName":"add_slot_value","kind":13,"line":279},{"containerName":"add_slot_value","name":"$slot","line":279,"kind":13},{"line":279,"kind":13,"name":"$h","containerName":"add_slot_value"},{"kind":13,"line":279,"name":"$slot","containerName":"add_slot_value"},{"name":"$h","containerName":"add_slot_value","kind":13,"line":280},{"containerName":"add_slot_value","name":"$slot","line":280,"kind":13},{"name":"@args","containerName":"add_slot_value","kind":13,"line":280},{"containerName":"add_slot_value","name":"$slot","kind":13,"line":282},{"kind":13,"line":282,"name":"$slot","containerName":"add_slot_value"},{"line":282,"kind":13,"name":"$slot","containerName":"add_slot_value"},{"containerName":"add_slot_value","name":"$h","kind":13,"line":283},{"kind":13,"line":283,"name":"$slot","containerName":"add_slot_value"},{"kind":13,"line":283,"containerName":"add_slot_value","name":"$args"}],"containerName":"main::","definition":"sub","detail":"($self,$slot,@args)","signature":{"label":"add_slot_value($self,$slot,@args)","documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.","parameters":[{"label":"$self"},{"label":"$slot"},{"label":"@args"}]},"name":"add_slot_value","range":{"end":{"character":9999,"line":285},"start":{"character":0,"line":264}}},{"name":"want_object","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":321},"start":{"character":0,"line":311}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"want_object","localvar":"my","kind":13,"line":312},{"line":314,"kind":13,"localvar":"my","definition":"my","name":"$ok","containerName":"want_object"},{"line":315,"kind":13,"localvar":"my","definition":"my","name":"$cond","containerName":"want_object"},{"line":315,"kind":13,"name":"$self","containerName":"want_object"},{"name":"get_object_conditions","containerName":"want_object","kind":12,"line":315},{"name":"$ok","containerName":"want_object","kind":13,"line":316},{"line":316,"kind":13,"name":"$self","containerName":"want_object"},{"kind":13,"line":317,"name":"$ok","containerName":"want_object"},{"name":"$self","containerName":"want_object","line":319,"kind":13},{"line":319,"kind":13,"name":"$ok","containerName":"want_object"},{"containerName":"want_object","name":"$ok","kind":13,"line":320}],"line":311},{"name":"cond","line":316,"kind":12},{"kind":12,"children":[{"kind":13,"line":346,"definition":"my","name":"$self","containerName":"make_object","localvar":"my"},{"localvar":"my","containerName":"make_object","definition":"my","name":"$obj","line":348,"kind":13},{"name":"$self","containerName":"make_object","line":349,"kind":13},{"line":349,"kind":13,"containerName":"make_object","name":"$self"}],"line":345,"definition":"sub","name":"make_object","containerName":"main::","range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":349}}},{"containerName":null,"name":"$obj","kind":13,"line":350},{"line":350,"kind":13,"name":"$self","containerName":null},{"line":350,"kind":12,"containerName":"main::","name":"sequence_factory"},{"containerName":"main::","name":"create_object","line":350,"kind":12},{"line":350,"kind":13,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":352,"kind":13},{"kind":13,"line":353,"name":"$obj","containerName":null},{"kind":12,"children":[{"localvar":"my","containerName":"get_wanted_slots","definition":"my","name":"$self","line":397,"kind":13},{"line":399,"kind":13,"name":"$self","containerName":"get_wanted_slots"}],"line":396,"name":"get_wanted_slots","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":396},"end":{"character":9999,"line":399}}},{"detail":"($self,@slots)","signature":{"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)","parameters":[{"label":"$self"},{"label":"@slots"}],"label":"add_wanted_slot($self,@slots)"},"containerName":"main::","definition":"sub","line":413,"children":[{"line":414,"kind":13,"localvar":"my","containerName":"add_wanted_slot","name":"$self","definition":"my"},{"name":"@slots","containerName":"add_wanted_slot","kind":13,"line":414},{"kind":13,"line":416,"definition":"my","name":"$myslots","containerName":"add_wanted_slot","localvar":"my"},{"kind":13,"line":416,"name":"$self","containerName":"add_wanted_slot"},{"kind":13,"line":417,"containerName":"add_wanted_slot","name":"$slot","definition":"my","localvar":"my"},{"containerName":"add_wanted_slot","name":"@slots","line":417,"kind":13},{"containerName":"add_wanted_slot","name":"$slot","kind":13,"line":418},{"line":418,"kind":13,"containerName":"add_wanted_slot","name":"$myslots"},{"name":"$myslots","containerName":"add_wanted_slot","line":419,"kind":13},{"line":419,"kind":13,"name":"$slot","containerName":"add_wanted_slot"}],"kind":12,"range":{"start":{"character":0,"line":413},"end":{"line":423,"character":9999}},"name":"add_wanted_slot"},{"range":{"end":{"line":442,"character":9999},"start":{"line":437,"character":0}},"definition":"sub","name":"remove_wanted_slots","containerName":"main::","children":[{"localvar":"my","containerName":"remove_wanted_slots","definition":"my","name":"$self","line":438,"kind":13},{"localvar":"my","containerName":"remove_wanted_slots","definition":"my","name":"@slots","line":439,"kind":13},{"name":"$self","containerName":"remove_wanted_slots","line":439,"kind":13},{"containerName":"remove_wanted_slots","name":"get_wanted_slots","line":439,"kind":12},{"line":440,"kind":13,"containerName":"remove_wanted_slots","name":"$self"},{"line":441,"kind":13,"containerName":"remove_wanted_slots","name":"@slots"}],"line":437,"kind":12},{"line":455,"children":[{"kind":13,"line":456,"definition":"my","name":"$self","containerName":"get_unwanted_slots","localvar":"my"},{"line":458,"kind":13,"containerName":"get_unwanted_slots","name":"$self"}],"kind":12,"range":{"end":{"line":458,"character":9999},"start":{"line":455,"character":0}},"containerName":"main::","definition":"sub","name":"get_unwanted_slots"},{"signature":{"label":"add_unwanted_slot($self,@slots)","parameters":[{"label":"$self"},{"label":"@slots"}],"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_wanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'wanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_wanted_slots\n\n Title   : remove_wanted_slots\n Usage   :\n Function: Removes all wanted slots added previously through\n           add_wanted_slots().\n Example :\n Returns : the previous list of wanted slot names\n Args    : none\n\n\nsub remove_wanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_wanted_slots();\n\t$self->{'wanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 get_unwanted_slots\n\n Title   : get_unwanted_slots\n Usage   : $obj->get_unwanted_slots($newval)\n Function: Get the list of unwanted slots.\n Example : \n Returns : a list of strings\n Args    : none\n\n\nsub get_unwanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'unwanted_slots'}};\n}\n\n=head2 add_unwanted_slot\n\n Title   : add_unwanted_slot\n Usage   :\n Function: Adds the specified slots to the list of unwanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)"},"detail":"($self,@slots)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"add_unwanted_slot","localvar":"my","kind":13,"line":473},{"containerName":"add_unwanted_slot","name":"@slots","line":473,"kind":13},{"containerName":"add_unwanted_slot","definition":"my","name":"$myslots","localvar":"my","kind":13,"line":475},{"containerName":"add_unwanted_slot","name":"$self","kind":13,"line":475},{"localvar":"my","name":"$slot","definition":"my","containerName":"add_unwanted_slot","line":476,"kind":13},{"containerName":"add_unwanted_slot","name":"@slots","line":476,"kind":13},{"name":"$slot","containerName":"add_unwanted_slot","kind":13,"line":477},{"name":"$myslots","containerName":"add_unwanted_slot","line":477,"kind":13},{"line":478,"kind":13,"name":"$myslots","containerName":"add_unwanted_slot"},{"kind":13,"line":478,"containerName":"add_unwanted_slot","name":"$slot"}],"line":472,"kind":12,"range":{"start":{"character":0,"line":472},"end":{"character":9999,"line":482}},"name":"add_unwanted_slot"},{"name":"remove_unwanted_slots","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":501},"start":{"line":496,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"remove_unwanted_slots","line":497,"kind":13},{"localvar":"my","containerName":"remove_unwanted_slots","definition":"my","name":"@slots","line":498,"kind":13},{"kind":13,"line":498,"containerName":"remove_unwanted_slots","name":"$self"},{"containerName":"remove_unwanted_slots","name":"get_unwanted_slots","kind":12,"line":498},{"line":499,"kind":13,"name":"$self","containerName":"remove_unwanted_slots"},{"line":500,"kind":13,"containerName":"remove_unwanted_slots","name":"@slots"}],"line":496},{"containerName":"main::","name":"want_none","definition":"sub","range":{"start":{"line":521,"character":0},"end":{"line":528,"character":9999}},"kind":12,"line":521,"children":[{"containerName":"want_none","definition":"my","name":"$self","localvar":"my","kind":13,"line":522},{"name":"$self","containerName":"want_none","line":524,"kind":13},{"line":524,"kind":12,"name":"want_all","containerName":"want_none"},{"name":"$self","containerName":"want_none","kind":13,"line":525},{"line":525,"kind":12,"name":"remove_wanted_slots","containerName":"want_none"},{"kind":13,"line":526,"containerName":"want_none","name":"$self"},{"kind":12,"line":526,"containerName":"want_none","name":"remove_unwanted_slots"}]},{"containerName":"main::","name":"want_all","definition":"sub","range":{"start":{"line":550,"character":0},"end":{"line":555,"character":9999}},"kind":12,"line":550,"children":[{"name":"$self","definition":"my","containerName":"want_all","localvar":"my","kind":13,"line":551},{"kind":13,"line":553,"name":"$self","containerName":"want_all"},{"line":554,"kind":13,"name":"$self","containerName":"want_all"}]},{"children":[{"line":579,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_object_conditions"},{"containerName":"get_object_conditions","name":"$self","kind":13,"line":581}],"line":578,"kind":12,"range":{"start":{"line":578,"character":0},"end":{"line":581,"character":9999}},"name":"get_object_conditions","definition":"sub","containerName":"main::"},{"kind":12,"line":606,"children":[{"kind":13,"line":607,"definition":"my","name":"$self","containerName":"add_object_condition","localvar":"my"},{"containerName":"add_object_condition","name":"@conds","line":607,"kind":13},{"containerName":"add_object_condition","name":"@conds","kind":13,"line":609},{"name":"$self","containerName":"add_object_condition","kind":13,"line":610},{"kind":12,"line":610,"containerName":"add_object_condition","name":"throw"},{"name":"$self","containerName":"add_object_condition","line":613,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@conds)","signature":{"parameters":[{"label":"$self"},{"label":"@conds"}],"documentation":"1;\n# $Id: SeqBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::SeqBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::SeqBuilder - Configurable object builder for sequence stream parsers\n\n=head1 SYNOPSIS\n\n   use Bio::SeqIO;\n\n   # usually you won't instantiate this yourself - a SeqIO object -\n   # you will have one already\n   my $seqin = Bio::SeqIO->new(-fh => \\*STDIN, -format => \"genbank\");\n   my $builder = $seqin->sequence_builder();\n\n   # if you need only sequence, id, and description (e.g. for \n   # conversion to FASTA format):\n   $builder->want_none();\n   $builder->add_wanted_slot('display_id','desc','seq');\n\n   # if you want everything except the sequence and features\n   $builder->want_all(1); # this is the default if it's untouched\n   $builder->add_unwanted_slot('seq','features');\n\n   # if you want only human sequences shorter than 5kb and skip all\n   # others\n   $builder->add_object_condition(sub {\n       my $h = shift;\n       return 0 if $h->{'-length'} > 5000;\n       return 0 if exists($h->{'-species'}) &&\n                   ($h->{'-species'}->binomial() ne \"Homo sapiens\");\n       return 1;\n   });\n\n   # when you are finished with configuring the builder, just use\n   # the SeqIO API as you would normally\n   while(my $seq = $seqin->next_seq()) {\n       # do something\n   }\n\n=head1 DESCRIPTION\n\nThis is an implementation of L<Bio::Factory::ObjectBuilderI> used by\nparsers of rich sequence streams. It provides for a relatively\neasy-to-use configurator of the parsing flow.\n\nConfiguring the parsing process may be for you if you need much less\ninformation, or much less sequence, than the stream actually\ncontains. Configuration can in both cases speed up the parsing time\nconsiderably, because unwanted sections or the rest of unwanted\nsequences are skipped over by the parser. This configuration could\nalso conserve memory if you're running out of available RAM.\n\nSee the methods of the class-specific implementation section for\nfurther documentation of what can be configured.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::SeqBuilder;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectBuilderI);\n\nmy %slot_param_map = (\"add_SeqFeature\" => \"features\",\n\t\t      );\nmy %param_slot_map = (\"features\"       => \"add_SeqFeature\",\n\t\t      );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::SeqBuilder->new();\n Function: Builds a new Bio::Seq::SeqBuilder object \n Returns : an instance of Bio::Seq::SeqBuilder\n Args    :\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'wanted_slots'} = [];\n    $self->{'unwanted_slots'} = [];\n    $self->{'object_conds'} = [];\n    $self->{'_objhash'} = {};\n    $self->want_all(1);\n\n    return $self;\n}\n\n=head1 Methods for implementing L<Bio::Factory::ObjectBuilderI>\n\n\n=head2 want_slot\n\n Title   : want_slot\n Usage   :\n Function: Whether or not the object builder wants to populate the\n           specified slot of the object to be built.\n\n           The slot can be specified either as the name of the\n           respective method, or the initialization parameter that\n           would be otherwise passed to new() of the object to be\n           built.\n\n           Note that usually only the parser will call this\n           method. Use add_wanted_slots and add_unwanted_slots for\n           configuration.\n\n Example :\n Returns : TRUE if the object builder wants to populate the slot, and\n           FALSE otherwise.\n Args    : the name of the slot (a string)\n\n\n\nsub want_slot{\n\tmy ($self,$slot) = @_;\n\tmy $ok = 0;\n\n\t$slot = substr($slot,1) if substr($slot,0,1) eq '-';\n\tif($self->want_all()) {\n\tforeach ($self->get_unwanted_slots()) {\n\t\t# this always overrides in want-all mode\n\t\treturn 0 if($slot eq $_);\n\t}\n\tif(! exists($self->{'_objskel'})) {\n\t\t$self->{'_objskel'} = $self->sequence_factory->create_object();\n\t}\n\tif(exists($param_slot_map{$slot})) {\n\t\t$ok = $self->{'_objskel'}->can($param_slot_map{$slot});\n\t} else {\n\t\t$ok = $self->{'_objskel'}->can($slot);\n\t}\n\treturn $ok if $ok;\n\t# even if the object 'cannot' do this slot, it might have been\n\t# added to the list of wanted slot, so carry on\n}\n\tforeach ($self->get_wanted_slots()) {\n\t\tif($slot eq $_) {\n\t\t\t$ok = 1;\n\t\t\tlast;\n\t\t}\n\t}\n\treturn $ok;\n}\n\n=head2 add_slot_value\n\n Title   : add_slot_value\n Usage   :\n Function: Adds one or more values to the specified slot of the object\n           to be built.\n\n           Naming the slot is the same as for want_slot().\n\n           The object builder may further filter the content to be\n           set, or even completely ignore the request.\n\n           If this method reports failure, the caller should not add\n           more values to the same slot. In addition, the caller may\n           find it appropriate to abandon the object being built\n           altogether.\n\n           This implementation will allow the caller to overwrite the\n           return value from want_slot(), because the slot is not\n           checked against want_slot().\n\n           Note that usually only the parser will call this method,\n           but you may call it from anywhere if you know what you are\n           doing. A derived class may be used to further manipulate\n           the value to be added.\n\n Example :\n Returns : TRUE on success, and FALSE otherwise\n Args    : the name of the slot (a string)\n           parameters determining the value to be set\n\n                 OR\n\n           alternatively, a list of slotname/value pairs in the style\n           of named parameters as they would be passed to new(), where\n           each element at an even index is the parameter (slot) name\n           starting with a dash, and each element at an odd index is\n           the value of the preceding name.\n\n\nsub add_slot_value{\n\tmy ($self,$slot,@args) = @_;\n\n\tmy $h = $self->{'_objhash'};\n\treturn unless $h;\n\t# multiple named parameter variant of calling?\n\tif((@args > 1) && (@args % 2) && (substr($slot,0,1) eq '-')) {\n\t\tunshift(@args, $slot);\n\t\twhile(@args) {\n\t\t\tmy $key = shift(@args);\n\t\t\t$h->{$key} = shift(@args);\n\t\t}\n\t} else {\n\t\tif($slot eq 'add_SeqFeature') {\n\t\t\t$slot = '-'.$slot_param_map{$slot};\n\t\t\t$h->{$slot} = [] unless $h->{$slot};\n\t\t\tpush(@{$h->{$slot}}, @args);\n\t\t} else {\n\t\t\t$slot = '-'.$slot unless substr($slot,0,1) eq '-';\n\t\t\t$h->{$slot} = $args[0];\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 want_object\n\n Title   : want_object\n Usage   :\n Function: Whether or not the object builder is still interested in\n           continuing with the object being built.\n\n           If this method returns FALSE, the caller should not add any\n           more values to slots, or otherwise risks that the builder\n           throws an exception. In addition, make_object() is likely\n           to return undef after this method returned FALSE.\n\n           Note that usually only the parser will call this\n           method. Use add_object_condition for configuration.\n\n Example :\n Returns : TRUE if the object builder wants to continue building\n           the present object, and FALSE otherwise.\n Args    : none\n\n\nsub want_object{\n\tmy $self = shift;\n\n\tmy $ok = 1;\n\tforeach my $cond ($self->get_object_conditions()) {\n\t\t$ok = &$cond($self->{'_objhash'});\n\t\tlast unless $ok;\n\t}\n\tdelete $self->{'_objhash'} unless $ok;\n\treturn $ok;\n}\n\n=head2 make_object\n\n Title   : make_object\n Usage   :\n Function: Get the built object.\n\n           This method is allowed to return undef if no value has ever\n           been added since the last call to make_object(), or if\n           want_object() returned FALSE (or would have returned FALSE)\n           before calling this method.\n\n           For an implementation that allows consecutive building of\n           objects, a caller must call this method once, and only\n           once, between subsequent objects to be built. I.e., a call\n           to make_object implies 'end_object.'\n\n Example :\n Returns : the object that was built\n Args    : none\n\n\nsub make_object{\n\tmy $self = shift;\n\n\tmy $obj;\n\tif(exists($self->{'_objhash'}) && %{$self->{'_objhash'}}) {\n\t\t$obj = $self->sequence_factory->create_object(%{$self->{'_objhash'}});\n\t}\n\t$self->{'_objhash'} = {}; # reset\n\treturn $obj;\n}\n\n=head1 Implementation specific methods\n\nThese methods allow to conveniently configure this sequence object\nbuilder as to which slots are desired, and under which circumstances a\nsequence object should be abandoned altogether. The default mode is\nwant_all(1), which means the builder will report all slots as wanted\nthat the object created by the sequence factory supports.\n\nYou can add specific slots you want through add_wanted_slots(). In\nmost cases, you will want to call want_none() before in order to relax\nzero acceptance through a list of wanted slots.\n\nAlternatively, you can add specific unwanted slots through\nadd_unwanted_slots(). In this case, you will usually want to call\nwant_all(1) before (which is the default if you never touched the\nbuilder) to restrict unrestricted acceptance.\n\nI.e., want_all(1) means want all slots except for the unwanted, and\nwant_none() means only those explicitly wanted.\n\nIf a slot is in both the unwanted and the wanted list, the following\nrules hold. In want-all mode, the unwanted list overrules. In\nwant-none mode, the wanted list overrides the unwanted list. If this\nis confusing to you, just try to avoid having slots at the same time\nin the wanted and the unwanted lists.\n\n\n=head2 get_wanted_slots\n\n Title   : get_wanted_slots\n Usage   : $obj->get_wanted_slots($newval)\n Function: Get the list of wanted slots\n Example : \n Returns : a list of strings\n Args    : \n\n\n\nsub get_wanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'wanted_slots'}};\n}\n\n=head2 add_wanted_slot\n\n Title   : add_wanted_slot\n Usage   :\n Function: Adds the specified slots to the list of wanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_wanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'wanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_wanted_slots\n\n Title   : remove_wanted_slots\n Usage   :\n Function: Removes all wanted slots added previously through\n           add_wanted_slots().\n Example :\n Returns : the previous list of wanted slot names\n Args    : none\n\n\nsub remove_wanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_wanted_slots();\n\t$self->{'wanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 get_unwanted_slots\n\n Title   : get_unwanted_slots\n Usage   : $obj->get_unwanted_slots($newval)\n Function: Get the list of unwanted slots.\n Example : \n Returns : a list of strings\n Args    : none\n\n\nsub get_unwanted_slots{\n\tmy $self = shift;\n\n\treturn @{$self->{'unwanted_slots'}};\n}\n\n=head2 add_unwanted_slot\n\n Title   : add_unwanted_slot\n Usage   :\n Function: Adds the specified slots to the list of unwanted slots.\n Example :\n Returns : TRUE\n Args    : an array of slot names (strings)\n\n\nsub add_unwanted_slot{\n\tmy ($self,@slots) = @_;\n\n\tmy $myslots = $self->{'unwanted_slots'};\n\tforeach my $slot (@slots) {\n\t\tif(! grep { $slot eq $_; } @$myslots) {\n\t\t\tpush(@$myslots, $slot);\n\t\t}\n\t}\n\treturn 1;\n}\n\n=head2 remove_unwanted_slots\n\n Title   : remove_unwanted_slots\n Usage   :\n Function: Removes the list of unwanted slots added previously through\n           add_unwanted_slots().\n Example :\n Returns : the previous list of unwanted slot names\n Args    : none\n\n\nsub remove_unwanted_slots{\n\tmy $self = shift;\n\tmy @slots = $self->get_unwanted_slots();\n\t$self->{'unwanted_slots'} = [];\n\treturn @slots;\n}\n\n=head2 want_none\n\n Title   : want_none\n Usage   :\n Function: Disables all slots. After calling this method, want_slot()\n           will return FALSE regardless of slot name.\n\n           This is different from removed_wanted_slots() in that it\n           also sets want_all() to FALSE. Note that it also resets the\n           list of unwanted slots in order to avoid slots being in\n           both lists.\n\n Example :\n Returns : TRUE\n Args    : none\n\n\nsub want_none{\n\tmy $self = shift;\n\n\t$self->want_all(0);\n\t$self->remove_wanted_slots();\n\t$self->remove_unwanted_slots();\n\treturn 1;\n}\n\n=head2 want_all\n\n Title   : want_all\n Usage   : $obj->want_all($newval)\n Function: Whether or not this sequence object builder wants to\n           populate all slots that the object has. Whether an object\n           supports a slot is generally determined by what can()\n           returns. You can add additional 'virtual' slots by calling\n           add_wanted_slot.\n\n           This will be ON by default. Call $obj->want_none() to\n           disable all slots.\n\n Example : \n Returns : TRUE if this builder wants to populate all slots, and\n           FALSE otherwise.\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub want_all{\n\tmy $self = shift;\n\n\treturn $self->{'want_all'} = shift if @_;\n\treturn $self->{'want_all'};\n}\n\n=head2 get_object_conditions\n\n Title   : get_object_conditions\n Usage   :\n Function: Get the list of conditions an object must meet in order to\n           be 'wanted.' See want_object() for where this is used.\n\n           Conditions in this implementation are closures (anonymous\n           functions) which are passed one parameter, a hash reference\n           the keys of which are equal to initialization\n           paramaters. The closure must return TRUE to make the object\n           'wanted.'\n\n           Conditions will be implicitly ANDed.\n\n Example :\n Returns : a list of closures\n Args    : none\n\n\nsub get_object_conditions{\n\tmy $self = shift;\n\n\treturn @{$self->{'object_conds'}};\n}\n\n=head2 add_object_condition\n\n Title   : add_object_condition\n Usage   :\n Function: Adds a condition an object must meet in order to be 'wanted.'\n           See want_object() for where this is used.\n\n           Conditions in this implementation must be closures\n           (anonymous functions). These will be passed one parameter,\n           which is a hash reference with the sequence object\n           initialization paramters being the keys.\n\n           Conditions are implicitly ANDed. If you want other\n           operators, perform those tests inside of one closure\n           instead of multiple.  This will also be more efficient.\n\n Example :\n Returns : TRUE\n Args    : the list of conditions","label":"add_object_condition($self,@conds)"},"name":"add_object_condition","range":{"end":{"character":9999,"line":613},"start":{"line":606,"character":0}}},{"name":"@conds","containerName":null,"kind":13,"line":613},{"range":{"end":{"character":9999,"line":634},"start":{"line":629,"character":0}},"containerName":"main::","definition":"sub","name":"remove_object_conditions","line":629,"children":[{"definition":"my","name":"$self","containerName":"remove_object_conditions","localvar":"my","kind":13,"line":630},{"kind":13,"line":631,"containerName":"remove_object_conditions","definition":"my","name":"@conds","localvar":"my"},{"name":"$self","containerName":"remove_object_conditions","kind":13,"line":631},{"containerName":"remove_object_conditions","name":"get_object_conditions","kind":12,"line":631},{"name":"$self","containerName":"remove_object_conditions","kind":13,"line":632},{"name":"@conds","containerName":"remove_object_conditions","line":633,"kind":13}],"kind":12},{"line":653,"children":[{"line":654,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"sequence_factory"},{"name":"$self","containerName":"sequence_factory","kind":13,"line":657},{"kind":13,"line":658,"name":"$self","containerName":"sequence_factory"},{"name":"$self","containerName":"sequence_factory","line":660,"kind":13}],"kind":12,"range":{"end":{"line":661,"character":9999},"start":{"line":653,"character":0}},"containerName":"main::","name":"sequence_factory","definition":"sub"}]}