{"vars":[{"kind":2,"line":102,"containerName":"","name":"vars"},{"name":"base","containerName":"","kind":2,"line":106},{"line":129,"children":[{"line":130,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"line":130,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":131,"kind":13},{"kind":13,"line":131,"containerName":"new","name":"$class"},{"kind":13,"line":131,"name":"@args","containerName":"new"},{"line":134,"kind":13,"localvar":"my","name":"$qual","definition":"my","containerName":"new"},{"containerName":"new","name":"$id","kind":13,"line":134},{"containerName":"new","name":"$acc","line":134,"kind":13},{"containerName":"new","name":"$pid","line":134,"kind":13},{"name":"$desc","containerName":"new","line":134,"kind":13},{"kind":13,"line":134,"name":"$given_id","containerName":"new"},{"line":134,"kind":13,"containerName":"new","name":"$header"},{"line":135,"kind":13,"containerName":"new","name":"$self"},{"line":135,"kind":12,"name":"_rearrange","containerName":"new"},{"line":143,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":144,"containerName":"new","name":"$id"},{"containerName":"new","name":"$given_id","kind":13,"line":144},{"name":"$id","containerName":"new","kind":13,"line":145},{"kind":13,"line":145,"name":"$given_id","containerName":"new"},{"line":146,"kind":13,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","line":146,"kind":12},{"kind":13,"line":149,"containerName":"new","name":"$given_id"},{"line":149,"kind":13,"name":"$id","containerName":"new"},{"kind":13,"line":149,"containerName":"new","name":"$given_id"},{"containerName":"new","name":"$self","kind":13,"line":152},{"name":"qual","containerName":"new","kind":12,"line":152},{"name":"$qual","containerName":"new","line":152,"kind":13},{"line":152,"kind":13,"containerName":"new","name":"$qual"},{"name":"$header","containerName":"new","line":153,"kind":13},{"name":"$self","containerName":"new","line":153,"kind":13},{"containerName":"new","name":"header","line":153,"kind":12},{"name":"$header","containerName":"new","kind":13,"line":153},{"line":154,"kind":13,"name":"$id","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":154},{"name":"display_id","containerName":"new","line":154,"kind":12},{"kind":13,"line":154,"name":"$id","containerName":"new"},{"name":"$acc","containerName":"new","kind":13,"line":155},{"name":"$self","containerName":"new","line":155,"kind":13},{"containerName":"new","name":"accession_number","kind":12,"line":155},{"kind":13,"line":155,"name":"$acc","containerName":"new"},{"kind":13,"line":156,"name":"$pid","containerName":"new"},{"line":156,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":156,"name":"primary_id","containerName":"new"},{"kind":13,"line":156,"name":"$pid","containerName":"new"},{"kind":13,"line":157,"name":"$desc","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":157},{"containerName":"new","name":"desc","kind":12,"line":157},{"line":157,"kind":13,"containerName":"new","name":"$desc"},{"line":159,"kind":13,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":129},"end":{"character":9999,"line":160}},"name":"new"},{"name":"SUPER","containerName":"new","line":131,"kind":12},{"kind":12,"children":[{"kind":13,"line":174,"definition":"my","name":"$self","containerName":"qual","localvar":"my"},{"line":174,"kind":13,"name":"$value","containerName":"qual"},{"name":"$value","containerName":"qual","line":176,"kind":13},{"containerName":"qual","name":"$value","kind":13,"line":176},{"name":"$self","containerName":"qual","kind":13,"line":177},{"name":"$value","containerName":"qual","line":178,"kind":13},{"line":180,"kind":13,"name":"$self","containerName":"qual"},{"name":"$value","containerName":"qual","line":180,"kind":13},{"kind":13,"line":181,"name":"$self","containerName":"qual"},{"name":"validate_qual","containerName":"qual","kind":12,"line":181},{"line":181,"kind":13,"containerName":"qual","name":"$value"},{"name":"$self","containerName":"qual","line":182,"kind":13},{"kind":12,"line":182,"name":"throw","containerName":"qual"},{"name":"$value","containerName":"qual","line":184,"kind":13},{"name":"$self","containerName":"qual","line":185,"kind":13},{"kind":13,"line":185,"name":"$value","containerName":"qual"},{"kind":13,"line":188,"containerName":"qual","name":"$self"}],"line":173,"definition":"sub","containerName":"main::","signature":{"label":"qual($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array."},"detail":"($self,$value)","name":"qual","range":{"end":{"character":9999,"line":189},"start":{"character":0,"line":173}}},{"children":[{"line":208,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"validate_qual"},{"line":208,"kind":13,"name":"$qualstr","containerName":"validate_qual"},{"name":"$qualstr","containerName":"validate_qual","kind":13,"line":212},{"name":"$qualstr","containerName":"validate_qual","kind":13,"line":212},{"kind":13,"line":213,"name":"$qualstr","containerName":"validate_qual"}],"line":205,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$qualstr"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.","label":"validate_qual($self,$qualstr)"},"detail":"($self,$qualstr)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":205},"end":{"character":9999,"line":216}},"name":"validate_qual"},{"containerName":"length","name":"CORE","line":212,"kind":12},{"name":"subqual","range":{"start":{"character":0,"line":232},"end":{"line":247,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"subqual($self,$start,$end)","documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]},"detail":"($self,$start,$end)","kind":12,"children":[{"kind":13,"line":233,"containerName":"subqual","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":233,"containerName":"subqual","name":"$start"},{"name":"$end","containerName":"subqual","line":233,"kind":13},{"line":235,"kind":13,"containerName":"subqual","name":"$start"},{"line":235,"kind":13,"name":"$end","containerName":"subqual"},{"name":"$self","containerName":"subqual","line":236,"kind":13},{"kind":12,"line":236,"name":"throw","containerName":"subqual"},{"kind":13,"line":239,"name":"$start","containerName":"subqual"},{"containerName":"subqual","name":"$end","kind":13,"line":239},{"kind":13,"line":239,"name":"$self","containerName":"subqual"},{"containerName":"subqual","name":"length","kind":12,"line":239},{"containerName":"subqual","name":"$self","line":240,"kind":13},{"name":"throw","containerName":"subqual","kind":12,"line":240},{"kind":13,"line":240,"containerName":"subqual","name":"$self"},{"name":"length","containerName":"subqual","line":240,"kind":12},{"name":"$start","containerName":"subqual","kind":13,"line":245},{"kind":13,"line":246,"name":"$end","containerName":"subqual"},{"definition":"my","name":"@sub_qual_array","containerName":"subqual","localvar":"my","kind":13,"line":247},{"name":"$self","containerName":"subqual","line":247,"kind":13}],"line":232},{"line":247,"kind":12,"name":"qual"},{"kind":13,"line":247,"containerName":null,"name":"$start"},{"name":"$end","containerName":null,"line":247,"kind":13},{"name":"@sub_qual_array","containerName":null,"kind":13,"line":250},{"kind":12,"children":[{"kind":13,"line":277,"definition":"my","name":"$obj","containerName":"display_id","localvar":"my"},{"line":277,"kind":13,"containerName":"display_id","name":"$value"},{"line":278,"kind":13,"containerName":"display_id","name":"$value"},{"kind":13,"line":279,"name":"$obj","containerName":"display_id"},{"line":279,"kind":13,"containerName":"display_id","name":"$value"},{"line":281,"kind":13,"containerName":"display_id","name":"$obj"}],"line":276,"definition":"sub","containerName":"main::","signature":{"label":"display_id($obj,$value)","documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None","parameters":[{"label":"$obj"},{"label":"$value"}]},"detail":"($obj,$value)","name":"display_id","range":{"start":{"line":276,"character":0},"end":{"line":283,"character":9999}}},{"kind":12,"children":[{"kind":13,"line":297,"containerName":"header","definition":"my","name":"$obj","localvar":"my"},{"line":297,"kind":13,"name":"$value","containerName":"header"},{"kind":13,"line":298,"name":"$value","containerName":"header"},{"line":299,"kind":13,"name":"$obj","containerName":"header"},{"line":299,"kind":13,"containerName":"header","name":"$value"},{"line":301,"kind":13,"name":"$obj","containerName":"header"}],"line":296,"definition":"sub","containerName":"main::","signature":{"label":"header($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None"},"detail":"($obj,$value)","name":"header","range":{"start":{"line":296,"character":0},"end":{"line":303,"character":9999}}},{"signature":{"parameters":[{"label":"$obj"},{"label":"$acc"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None","label":"accession_number($obj,$acc)"},"detail":"($obj,$acc)","definition":"sub","containerName":"main::","children":[{"line":322,"kind":13,"localvar":"my","definition":"my","name":"$obj","containerName":"accession_number"},{"containerName":"accession_number","name":"$acc","kind":13,"line":322},{"containerName":"accession_number","name":"$acc","line":324,"kind":13},{"containerName":"accession_number","name":"$obj","kind":13,"line":325},{"containerName":"accession_number","name":"$acc","kind":13,"line":325},{"line":327,"kind":13,"name":"$acc","containerName":"accession_number"},{"line":327,"kind":13,"name":"$obj","containerName":"accession_number"},{"line":328,"kind":13,"name":"$acc","containerName":"accession_number"},{"name":"$acc","containerName":"accession_number","line":328,"kind":13},{"name":"$acc","containerName":"accession_number","kind":13,"line":330}],"line":321,"kind":12,"range":{"start":{"line":321,"character":0},"end":{"line":331,"character":9999}},"name":"accession_number"},{"range":{"start":{"line":347,"character":0},"end":{"line":354,"character":9999}},"name":"primary_id","signature":{"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"primary_id($obj,$value)"},"detail":"($obj,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"primary_id","name":"$obj","definition":"my","line":348,"kind":13},{"containerName":"primary_id","name":"$value","kind":13,"line":348},{"name":"$value","containerName":"primary_id","kind":13,"line":349},{"containerName":"primary_id","name":"$obj","kind":13,"line":350},{"name":"$value","containerName":"primary_id","line":350,"kind":13},{"line":352,"kind":13,"containerName":"primary_id","name":"$obj"}],"line":347,"kind":12},{"range":{"start":{"line":368,"character":0},"end":{"character":9999,"line":375}},"name":"desc","detail":"($obj,$value)","signature":{"label":"desc($obj,$value)","documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":368,"children":[{"line":369,"kind":13,"localvar":"my","containerName":"desc","name":"$obj","definition":"my"},{"name":"$value","containerName":"desc","kind":13,"line":369},{"name":"$value","containerName":"desc","line":370,"kind":13},{"containerName":"desc","name":"$obj","line":371,"kind":13},{"kind":13,"line":371,"name":"$value","containerName":"desc"},{"containerName":"desc","name":"$obj","kind":13,"line":373}],"kind":12},{"signature":{"label":"id($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n    }\n    return $obj->{'desc'};\n\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n\tactually is in the implementation provided here) just a synonym\n\tfor display_id().\n Returns : A string.\n Args    : None."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":390,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"id"},{"containerName":"id","name":"$value","kind":13,"line":390},{"name":"$value","containerName":"id","line":391,"kind":13},{"kind":13,"line":392,"containerName":"id","name":"$self"},{"kind":12,"line":392,"containerName":"id","name":"display_id"},{"name":"$value","containerName":"id","line":392,"kind":13},{"line":394,"kind":13,"containerName":"id","name":"$self"},{"line":394,"kind":12,"containerName":"id","name":"display_id"}],"line":389,"kind":12,"range":{"end":{"line":395,"character":9999},"start":{"character":0,"line":389}},"name":"id"},{"kind":12,"line":411,"children":[{"definition":"my","name":"$self","containerName":"length","localvar":"my","kind":13,"line":412},{"line":413,"kind":13,"name":"$self","containerName":"length"},{"containerName":"length","name":"$self","kind":13,"line":414},{"containerName":"length","name":"warn","kind":12,"line":414},{"containerName":"length","name":"$self","line":414,"kind":13},{"kind":13,"line":414,"name":"$self","containerName":"length"},{"kind":13,"line":416,"containerName":"length","name":"$self"}],"containerName":"main::","definition":"sub","name":"length","range":{"end":{"line":416,"character":9999},"start":{"character":0,"line":411}}},{"name":"qual","kind":12,"line":413},{"name":"qual","line":414,"kind":12},{"kind":12,"line":414,"name":"qual"},{"kind":12,"line":416,"name":"qual"},{"kind":12,"line":432,"children":[{"kind":13,"line":433,"name":"$self","definition":"my","containerName":"qualat","localvar":"my"},{"containerName":"qualat","name":"$val","kind":13,"line":433},{"kind":13,"line":434,"containerName":"qualat","definition":"my","name":"@qualat","localvar":"my"},{"line":434,"kind":13,"name":"$self","containerName":"qualat"},{"line":434,"kind":12,"name":"subqual","containerName":"qualat"},{"kind":13,"line":434,"name":"$val","containerName":"qualat"},{"containerName":"qualat","name":"$val","line":434,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"label":"qualat($self,$val)","documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n    }\n    return $obj->{'desc'};\n\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n\tactually is in the implementation provided here) just a synonym\n\tfor display_id().\n Returns : A string.\n Args    : None.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n        return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title\t : length()\n Usage\t : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n\tUnder most circumstances, this should match the number of quality\n\tvalues but no validation is done when the PrimaryQual object is\n\tconstructed and non-digits could be put into this array. Is this\n\ta bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None.\n\n\nsub length {\n    my $self = shift;\n    if (ref($self->{qual}) ne \"ARRAY\") {\n\t$self->warn(\"{qual} is not an array here. Why? It appears to be \".ref($self->{qual}).\"(\".$self->{qual}.\"). Good thing this can _never_ happen.\");\n    }\n    return scalar(@{$self->{qual}});\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.","parameters":[{"label":"$self"},{"label":"$val"}]},"name":"qualat","range":{"start":{"line":432,"character":0},"end":{"character":9999,"line":434}}},{"name":"@qualat","containerName":null,"kind":13,"line":435},{"line":436,"kind":13,"name":"@qualat","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":439},{"name":"throw","containerName":"main::","line":439,"kind":12},{"kind":12,"children":[{"containerName":"to_string","name":"$self","definition":"my","localvar":"my","kind":13,"line":462},{"containerName":"to_string","name":"$out","line":462,"kind":13},{"line":462,"kind":13,"name":"$result","containerName":"to_string"},{"name":"$out","containerName":"to_string","kind":13,"line":463},{"kind":13,"line":463,"containerName":"to_string","name":"$self"},{"line":463,"kind":12,"containerName":"to_string","name":"qual"}],"line":461,"name":"to_string","definition":"sub","containerName":"main::","range":{"end":{"line":463,"character":9999},"start":{"character":0,"line":461}}},{"name":"$result","containerName":null,"line":465,"kind":13},{"line":465,"kind":13,"name":"$self","containerName":null},{"kind":13,"line":466,"name":"%result","containerName":null},{"line":466,"kind":13,"containerName":null,"name":"$result"},{"line":467,"kind":13,"containerName":null,"name":"$out"},{"line":469,"kind":13,"containerName":null,"name":"$out"},{"containerName":"main::","definition":"sub","name":"to_string_automatic","range":{"end":{"character":9999,"line":489},"start":{"line":473,"character":0}},"kind":12,"line":473,"children":[{"localvar":"my","containerName":"to_string_automatic","definition":"my","name":"$self","line":474,"kind":13},{"containerName":"to_string_automatic","name":"$sub_result","line":474,"kind":13},{"name":"$out","containerName":"to_string_automatic","line":474,"kind":13},{"line":475,"kind":13,"name":"$self","containerName":"to_string_automatic"},{"containerName":"to_string_automatic","name":"$self","kind":13,"line":477},{"line":478,"kind":13,"containerName":"to_string_automatic","name":"$sub_result"},{"name":"$sub_result","containerName":"to_string_automatic","kind":13,"line":479},{"containerName":"to_string_automatic","name":"$self","kind":13,"line":479},{"kind":13,"line":480,"name":"$sub_result","containerName":"to_string_automatic"},{"containerName":"to_string_automatic","name":"$sub_result","line":482,"kind":13},{"kind":13,"line":484,"containerName":"to_string_automatic","name":"$sub_result"},{"name":"$sub_result","containerName":"to_string_automatic","kind":13,"line":484},{"line":486,"kind":13,"name":"$out","containerName":"to_string_automatic"},{"kind":13,"line":486,"containerName":"to_string_automatic","name":"$sub_result"},{"containerName":"to_string_automatic","name":"$out","line":488,"kind":13}]}],"version":5}