{"version":5,"vars":[{"line":137,"kind":2,"name":"vars","containerName":""},{"kind":2,"line":142,"name":"base","containerName":""},{"line":146,"kind":13,"name":"$DEFAULT_NAME","containerName":null},{"containerName":null,"name":"$GAP","kind":13,"line":147},{"line":148,"kind":13,"name":"$META_GAP","containerName":null},{"line":166,"children":[{"line":167,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"containerName":"new","name":"%args","line":167,"kind":13},{"name":"$args","containerName":"new","kind":13,"line":170},{"kind":13,"line":171,"name":"@ISA","containerName":"new"},{"name":"$args","containerName":"new","kind":13,"line":171},{"kind":13,"line":174,"name":"@ISA","containerName":"new"},{"line":177,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":177,"kind":13,"name":"$class","containerName":"new"},{"line":177,"kind":13,"name":"%args","containerName":"new"},{"kind":13,"line":179,"name":"$meta","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$forceflush","kind":13,"line":179},{"line":180,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":180,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"%args","kind":13,"line":183},{"kind":13,"line":185,"name":"$self","containerName":"new"},{"containerName":"new","name":"$DEFAULT_NAME","kind":13,"line":185},{"name":"$meta","containerName":"new","line":187,"kind":13},{"name":"$self","containerName":"new","line":187,"kind":13},{"containerName":"new","name":"meta","line":187,"kind":12},{"containerName":"new","name":"$meta","line":187,"kind":13},{"kind":13,"line":188,"name":"$forceflush","containerName":"new"},{"name":"$self","containerName":"new","line":188,"kind":13},{"kind":12,"line":188,"name":"force_flush","containerName":"new"},{"containerName":"new","name":"$forceflush","line":188,"kind":13},{"name":"$self","containerName":"new","line":190,"kind":13}],"kind":12,"detail":"($class,%args)","signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object","parameters":[{"label":"$class"},{"label":"%args"}],"label":"new($class,%args)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":191},"start":{"line":166,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":177},{"containerName":"main::","name":"meta","definition":"sub","range":{"start":{"character":0,"line":212},"end":{"line":214,"character":9999}},"kind":12,"line":212,"children":[{"name":"named_meta","containerName":"meta","line":213,"kind":12},{"containerName":"meta","name":"$DEFAULT_NAME","line":213,"kind":13}]},{"range":{"end":{"character":9999,"line":228},"start":{"character":0,"line":227}},"name":"meta_text","definition":"sub","containerName":"main::","children":[{"kind":12,"line":228,"name":"meta","containerName":"meta_text"}],"line":227,"kind":12},{"kind":12,"line":228,"name":"shift"},{"name":"named_meta","range":{"start":{"character":0,"line":243},"end":{"character":9999,"line":264}},"kind":12,"line":243,"children":[{"containerName":"named_meta","name":"$self","definition":"my","localvar":"my","kind":13,"line":244},{"containerName":"named_meta","name":"$name","kind":13,"line":244},{"kind":13,"line":244,"containerName":"named_meta","name":"$value"},{"kind":13,"line":246,"containerName":"named_meta","name":"$name"},{"kind":13,"line":246,"containerName":"named_meta","name":"$DEFAULT_NAME"},{"containerName":"named_meta","name":"$value","kind":13,"line":248},{"line":249,"kind":13,"localvar":"my","definition":"my","name":"$arrayref","containerName":"named_meta"},{"containerName":"named_meta","name":"$value","line":251,"kind":13},{"name":"$arrayref","containerName":"named_meta","kind":13,"line":252},{"name":"$value","containerName":"named_meta","kind":13,"line":252},{"line":254,"kind":13,"name":"$value","containerName":"named_meta"},{"name":"$arrayref","containerName":"named_meta","kind":13,"line":255},{"line":255,"kind":13,"name":"$value","containerName":"named_meta"},{"containerName":"named_meta","name":"$self","kind":13,"line":257},{"name":"throw","containerName":"named_meta","line":257,"kind":12},{"name":"$value","containerName":"named_meta","line":257,"kind":13},{"line":261,"kind":13,"localvar":"my","name":"$diff","definition":"my","containerName":"named_meta"},{"containerName":"named_meta","name":"$self","kind":13,"line":261},{"kind":12,"line":261,"containerName":"named_meta","name":"length"},{"containerName":"named_meta","name":"$arrayref","line":261,"kind":13},{"containerName":"named_meta","name":"$diff","line":262,"kind":13},{"name":"$diff","containerName":"named_meta","line":263,"kind":13},{"containerName":"named_meta","name":"$arrayref","line":263,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$name,$value)","signature":{"label":"named_meta($self,$name,$value)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}]}},{"line":266,"kind":13,"containerName":null,"name":"%self"},{"line":266,"kind":13,"name":"$name","containerName":null},{"line":266,"kind":13,"containerName":null,"name":"$arrayref"},{"line":271,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_do_flush","kind":12,"line":271},{"containerName":null,"name":"$self","line":271,"kind":13},{"kind":12,"line":271,"containerName":"main::","name":"force_flush"},{"line":273,"kind":13,"name":"%self","containerName":null},{"name":"$name","containerName":null,"line":273,"kind":13},{"containerName":null,"name":"$self","line":273,"kind":13},{"line":273,"kind":12,"name":"length","containerName":"main::"},{"line":295,"children":[{"kind":13,"line":296,"definition":"my","name":"$self","containerName":"_test_gap_positions","localvar":"my"},{"containerName":"_test_gap_positions","definition":"my","name":"$name","localvar":"my","kind":13,"line":297},{"line":298,"kind":13,"localvar":"my","containerName":"_test_gap_positions","definition":"my","name":"$success"},{"containerName":"_test_gap_positions","name":"$self","kind":13,"line":300},{"containerName":"_test_gap_positions","name":"seq","kind":12,"line":300},{"name":"$success","containerName":"_test_gap_positions","line":300,"kind":13},{"line":301,"kind":13,"localvar":"my","name":"$len","definition":"my","containerName":"_test_gap_positions"},{"containerName":"_test_gap_positions","name":"$self","line":301,"kind":13},{"name":"seq","containerName":"_test_gap_positions","kind":12,"line":301},{"localvar":"my","name":"$i","definition":"my","containerName":"_test_gap_positions","line":302,"kind":13},{"kind":13,"line":302,"containerName":"_test_gap_positions","name":"$i"},{"containerName":"_test_gap_positions","name":"$len","line":302,"kind":13},{"line":302,"kind":13,"containerName":"_test_gap_positions","name":"$i"},{"kind":13,"line":303,"containerName":"_test_gap_positions","definition":"my","name":"$s","localvar":"my"},{"kind":13,"line":303,"name":"$self","containerName":"_test_gap_positions"},{"line":303,"kind":13,"containerName":"_test_gap_positions","name":"$i"},{"line":304,"kind":13,"localvar":"my","definition":"my","name":"$m","containerName":"_test_gap_positions"},{"kind":13,"line":304,"name":"$self","containerName":"_test_gap_positions"},{"line":304,"kind":13,"name":"$name","containerName":"_test_gap_positions"},{"name":"$i","containerName":"_test_gap_positions","kind":13,"line":304},{"kind":13,"line":305,"containerName":"_test_gap_positions","name":"$self"},{"line":305,"kind":12,"containerName":"_test_gap_positions","name":"warn"},{"name":"$i","containerName":"_test_gap_positions","line":305,"kind":13},{"kind":13,"line":305,"name":"$self","containerName":"_test_gap_positions"},{"name":"id","containerName":"_test_gap_positions","line":305,"kind":12},{"name":"$success","containerName":"_test_gap_positions","line":306,"kind":13},{"name":"$m","containerName":"_test_gap_positions","kind":13,"line":307},{"kind":13,"line":307,"name":"$s","containerName":"_test_gap_positions"},{"kind":13,"line":307,"name":"$m","containerName":"_test_gap_positions"},{"kind":13,"line":309,"name":"$success","containerName":"_test_gap_positions"}],"kind":12,"range":{"end":{"line":310,"character":9999},"start":{"line":295,"character":0}},"containerName":"main::","definition":"sub","name":"_test_gap_positions"},{"name":"CORE","containerName":"length","line":301,"kind":12},{"line":303,"kind":12,"name":"seq"},{"kind":12,"line":304,"name":"_meta"},{"definition":"sub","name":"named_meta_text","containerName":"main::","range":{"start":{"character":0,"line":325},"end":{"line":326,"character":9999}},"kind":12,"children":[{"kind":12,"line":326,"name":"named_meta","containerName":"named_meta_text"}],"line":325},{"kind":12,"line":326,"name":"shift"},{"line":358,"children":[{"name":"named_submeta","containerName":"submeta","line":359,"kind":12},{"kind":13,"line":359,"containerName":"submeta","name":"$DEFAULT_NAME"}],"kind":12,"range":{"start":{"character":0,"line":358},"end":{"character":9999,"line":360}},"containerName":"main::","name":"submeta","definition":"sub"},{"children":[{"kind":12,"line":375,"containerName":"submeta_text","name":"named_submeta"},{"containerName":"submeta_text","name":"$DEFAULT_NAME","line":375,"kind":13}],"line":374,"kind":12,"range":{"start":{"line":374,"character":0},"end":{"line":375,"character":9999}},"name":"submeta_text","definition":"sub","containerName":"main::"},{"name":"shift","kind":12,"line":375},{"containerName":"main::","definition":"sub","detail":"($self,$name,$start,$end,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$start"},{"label":"$end"},{"label":"$value"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional","label":"named_submeta($self,$name,$start,$end,$value)"},"kind":12,"line":394,"children":[{"definition":"my","name":"$self","containerName":"named_submeta","localvar":"my","kind":13,"line":395},{"kind":13,"line":395,"name":"$name","containerName":"named_submeta"},{"containerName":"named_submeta","name":"$start","line":395,"kind":13},{"kind":13,"line":395,"name":"$end","containerName":"named_submeta"},{"name":"$value","containerName":"named_submeta","kind":13,"line":395},{"containerName":"named_submeta","name":"$name","kind":13,"line":397},{"name":"$DEFAULT_NAME","containerName":"named_submeta","line":397,"kind":13},{"line":398,"kind":13,"name":"$start","containerName":"named_submeta"},{"containerName":"named_submeta","name":"$start","line":399,"kind":13},{"line":399,"kind":13,"name":"$start","containerName":"named_submeta"},{"line":400,"kind":13,"name":"$self","containerName":"named_submeta"},{"line":400,"kind":12,"containerName":"named_submeta","name":"throw"},{"name":"$start","containerName":"named_submeta","kind":13,"line":401},{"containerName":"named_submeta","definition":"my","name":"$meta_len","localvar":"my","kind":13,"line":402},{"containerName":"named_submeta","name":"$self","line":402,"kind":13},{"containerName":"named_submeta","name":"$name","line":402,"kind":13}],"name":"named_submeta","range":{"end":{"character":9999,"line":402},"start":{"line":394,"character":0}}},{"kind":12,"line":402,"name":"_meta"},{"line":403,"kind":13,"containerName":null,"name":"%value"},{"localvar":"my","definition":"my","name":"$arrayref","containerName":null,"line":404,"kind":13},{"name":"%value","containerName":null,"line":406,"kind":13},{"containerName":null,"name":"$arrayref","kind":13,"line":407},{"containerName":null,"name":"$value","line":407,"kind":13},{"line":409,"kind":13,"name":"%value","containerName":null},{"name":"@arrayref","containerName":null,"line":410,"kind":13},{"name":"%value","containerName":null,"line":410,"kind":13},{"containerName":null,"name":"$self","line":412,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":412},{"containerName":null,"name":"$value","kind":13,"line":412},{"name":"$self","containerName":null,"line":415,"kind":13},{"name":"warn","containerName":"main::","line":415,"kind":12},{"kind":13,"line":416,"containerName":null,"name":"$self"},{"line":416,"kind":12,"name":"seq","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":416},{"line":416,"kind":12,"containerName":"main::","name":"id"},{"line":417,"kind":13,"containerName":null,"name":"$start"},{"kind":13,"line":417,"name":"$arrayref","containerName":null},{"line":417,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":417,"containerName":"main::","name":"length"},{"kind":13,"line":420,"name":"$end","containerName":null},{"containerName":null,"name":"$end","line":420,"kind":13},{"name":"$arrayref","containerName":null,"kind":13,"line":420},{"kind":13,"line":420,"containerName":null,"name":"$start"},{"name":"$end","containerName":null,"kind":13,"line":421},{"kind":13,"line":424,"containerName":null,"definition":"my","name":"$diff","localvar":"my"},{"containerName":null,"name":"$end","line":424,"kind":13},{"containerName":null,"name":"$start","kind":13,"line":424},{"kind":13,"line":424,"containerName":null,"name":"$arrayref"},{"line":425,"kind":13,"containerName":null,"name":"%diff"},{"containerName":null,"name":"%diff","line":426,"kind":13},{"line":426,"kind":13,"containerName":null,"name":"$arrayref"},{"line":426,"kind":13,"containerName":null,"name":"$META_GAP"},{"line":429,"kind":13,"name":"%self","containerName":null},{"name":"_meta","kind":12,"line":429},{"line":429,"kind":13,"name":"@name","containerName":null},{"line":429,"kind":13,"containerName":null,"name":"$start"},{"kind":13,"line":429,"name":"$end","containerName":null},{"kind":13,"line":429,"name":"$arrayref","containerName":null},{"line":431,"kind":13,"name":"$self","containerName":null},{"name":"_do_flush","containerName":"main::","kind":12,"line":431},{"kind":13,"line":431,"name":"$self","containerName":null},{"kind":12,"line":431,"name":"force_flush","containerName":"main::"},{"line":433,"kind":13,"name":"%arrayref","containerName":null},{"name":"$end","containerName":null,"kind":13,"line":437},{"name":"$meta_len","containerName":null,"line":437,"kind":13},{"containerName":null,"name":"$end","kind":13,"line":438},{"name":"%meta_len","containerName":null,"kind":13,"line":438},{"containerName":null,"name":"$self","line":439,"kind":13},{"containerName":"main::","name":"warn","line":439,"kind":12},{"name":"$end","containerName":null,"line":440,"kind":13},{"line":440,"kind":13,"name":"$meta_len","containerName":null},{"kind":13,"line":443,"containerName":null,"name":"$self"},{"kind":12,"line":443,"name":"warn","containerName":"main::"},{"kind":13,"line":444,"containerName":null,"name":"$end"},{"kind":13,"line":444,"name":"$self","containerName":null},{"containerName":"main::","name":"length","kind":12,"line":444},{"containerName":null,"name":"@end","kind":13,"line":445},{"name":"%self","containerName":null,"kind":13,"line":446},{"name":"_meta","line":446,"kind":12},{"kind":13,"line":446,"containerName":null,"name":"@name"},{"containerName":null,"name":"$start","line":446,"kind":13},{"kind":13,"line":446,"name":"$end","containerName":null},{"containerName":"main::","name":"named_submeta_text","definition":"sub","range":{"end":{"line":466,"character":9999},"start":{"line":465,"character":0}},"kind":12,"line":465,"children":[{"line":466,"kind":12,"containerName":"named_submeta_text","name":"named_submeta"}]},{"kind":12,"line":466,"name":"shift"},{"name":"meta_names","range":{"start":{"line":481,"character":0},"end":{"character":9999,"line":485}},"definition":"sub","containerName":"main::","signature":{"label":"meta_names($self)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":482,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"meta_names"},{"localvar":"my","definition":"my","name":"@r","containerName":"meta_names","line":484,"kind":13},{"containerName":"meta_names","name":"$self","line":485,"kind":13}],"line":481},{"name":"@r","containerName":null,"line":486,"kind":13},{"name":"$DEFAULT_NAME","containerName":null,"kind":13,"line":486},{"kind":13,"line":488,"name":"@r","containerName":null},{"line":488,"kind":13,"name":"$DEFAULT_NAME","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":488},{"line":488,"kind":13,"name":"$DEFAULT_NAME","containerName":null},{"kind":13,"line":489,"name":"@r","containerName":null},{"range":{"end":{"character":9999,"line":506},"start":{"character":0,"line":503}},"name":"meta_length","children":[{"definition":"my","name":"$self","containerName":"meta_length","localvar":"my","kind":13,"line":504},{"containerName":"meta_length","name":"$self","kind":13,"line":505},{"kind":12,"line":505,"containerName":"meta_length","name":"named_meta_length"},{"name":"$DEFAULT_NAME","containerName":"meta_length","kind":13,"line":505}],"line":503,"kind":12,"signature":{"label":"meta_length($self)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"named_meta_length","range":{"start":{"line":519,"character":0},"end":{"character":9999,"line":522}},"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -","parameters":[{"label":"$self"},{"label":"$name"}],"label":"named_meta_length($self,$name)"},"kind":12,"line":519,"children":[{"line":520,"kind":13,"localvar":"my","containerName":"named_meta_length","name":"$self","definition":"my"},{"name":"$name","containerName":"named_meta_length","kind":13,"line":520},{"kind":13,"line":521,"containerName":"named_meta_length","name":"$name"},{"containerName":"named_meta_length","name":"$DEFAULT_NAME","line":521,"kind":13},{"kind":13,"line":522,"name":"$self","containerName":"named_meta_length"},{"name":"$name","containerName":"named_meta_length","line":522,"kind":13}]},{"name":"force_flush","range":{"end":{"character":9999,"line":553},"start":{"line":541,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.","label":"force_flush($self,$value)"},"kind":12,"line":541,"children":[{"kind":13,"line":542,"containerName":"force_flush","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":542,"name":"$value","containerName":"force_flush"},{"containerName":"force_flush","name":"$value","line":544,"kind":13},{"kind":13,"line":545,"name":"$value","containerName":"force_flush"},{"containerName":"force_flush","name":"$self","kind":13,"line":546},{"line":547,"kind":13,"name":"$self","containerName":"force_flush"},{"containerName":"force_flush","name":"_do_flush","line":547,"kind":12},{"kind":13,"line":549,"name":"$self","containerName":"force_flush"},{"containerName":"force_flush","name":"$self","line":552,"kind":13}]},{"kind":12,"line":546,"name":"force_flush"},{"line":549,"kind":12,"name":"force_flush"},{"name":"force_flush","kind":12,"line":552},{"range":{"start":{"character":0,"line":568},"end":{"line":582,"character":9999}},"name":"_do_flush","line":568,"children":[{"localvar":"my","containerName":"_do_flush","definition":"my","name":"$self","line":569,"kind":13},{"kind":13,"line":571,"containerName":"_do_flush","definition":"my","name":"$name","localvar":"my"},{"line":571,"kind":13,"containerName":"_do_flush","name":"$self"},{"line":571,"kind":12,"containerName":"_do_flush","name":"meta_names"},{"kind":13,"line":575,"name":"$self","containerName":"_do_flush"},{"kind":12,"line":575,"name":"length","containerName":"_do_flush"},{"kind":13,"line":575,"name":"$self","containerName":"_do_flush"},{"containerName":"_do_flush","name":"named_meta_length","kind":12,"line":575},{"kind":13,"line":575,"name":"$name","containerName":"_do_flush"},{"line":576,"kind":13,"localvar":"my","name":"$diff","definition":"my","containerName":"_do_flush"},{"kind":13,"line":576,"name":"$self","containerName":"_do_flush"},{"line":576,"kind":12,"containerName":"_do_flush","name":"length"},{"line":576,"kind":13,"containerName":"_do_flush","name":"$self"},{"kind":12,"line":576,"containerName":"_do_flush","name":"named_meta_length"},{"line":576,"kind":13,"name":"$name","containerName":"_do_flush"},{"line":577,"kind":13,"name":"$diff","containerName":"_do_flush"},{"name":"$self","containerName":"_do_flush","line":577,"kind":13},{"line":577,"kind":13,"containerName":"_do_flush","name":"$name"},{"line":577,"kind":13,"containerName":"_do_flush","name":"$META_GAP"},{"line":580,"kind":13,"containerName":"_do_flush","name":"$self"},{"containerName":"_do_flush","name":"length","line":580,"kind":12},{"name":"$self","containerName":"_do_flush","line":580,"kind":13},{"name":"named_meta_length","containerName":"_do_flush","line":580,"kind":12},{"containerName":"_do_flush","name":"$name","kind":13,"line":580},{"kind":13,"line":581,"name":"$self","containerName":"_do_flush"},{"name":"$name","containerName":"_do_flush","line":581,"kind":13},{"line":581,"kind":13,"containerName":"_do_flush","name":"$self"},{"line":581,"kind":13,"containerName":"_do_flush","name":"$name"},{"line":581,"kind":13,"name":"$self","containerName":"_do_flush"},{"line":581,"kind":12,"containerName":"_do_flush","name":"length"}],"kind":12,"detail":"($self)","signature":{"label":"_do_flush($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same\n           length as sequence . Called from L<force_flush>\n Returns : \n Args    : "},"containerName":"main::","definition":"sub"},{"line":581,"kind":12,"name":"_meta"},{"kind":12,"line":581,"name":"_meta"},{"range":{"start":{"character":0,"line":602},"end":{"line":625,"character":9999}},"containerName":"main::","name":"is_flush","definition":"sub","line":602,"children":[{"containerName":"is_flush","definition":"my","name":"$self","localvar":"my","kind":13,"line":604},{"name":"$name","containerName":"is_flush","kind":13,"line":604},{"name":"$self","containerName":"is_flush","kind":13,"line":606},{"kind":12,"line":606,"name":"force_flush","containerName":"is_flush"},{"localvar":"my","containerName":"is_flush","definition":"my","name":"$sticky","line":608,"kind":13},{"name":"$name","containerName":"is_flush","line":611,"kind":13},{"containerName":"is_flush","name":"$sticky","line":612,"kind":13},{"name":"$self","containerName":"is_flush","line":612,"kind":13},{"name":"length","containerName":"is_flush","line":612,"kind":12},{"line":612,"kind":13,"containerName":"is_flush","name":"$self"},{"line":612,"kind":12,"name":"named_meta_length","containerName":"is_flush"},{"line":612,"kind":13,"containerName":"is_flush","name":"$name"},{"line":614,"kind":13,"localvar":"my","definition":"my","name":"$m","containerName":"is_flush"},{"name":"$self","containerName":"is_flush","kind":13,"line":614},{"line":614,"kind":12,"name":"meta_names","containerName":"is_flush"},{"name":"$sticky","containerName":"is_flush","line":615,"kind":13},{"kind":13,"line":615,"containerName":"is_flush","name":"$self"},{"name":"length","containerName":"is_flush","kind":12,"line":615},{"name":"$self","containerName":"is_flush","line":615,"kind":13},{"name":"named_meta_length","containerName":"is_flush","kind":12,"line":615},{"containerName":"is_flush","name":"$m","line":615,"kind":13},{"name":"$sticky","containerName":"is_flush","kind":13,"line":619},{"name":"$self","containerName":"is_flush","line":620,"kind":13},{"containerName":"is_flush","name":"verbose","line":620,"kind":12}],"kind":12},{"containerName":"main::","definition":"sub","name":"revcom","range":{"start":{"line":644,"character":0},"end":{"character":9999,"line":654}},"kind":12,"line":644,"children":[{"name":"$self","definition":"my","containerName":"revcom","localvar":"my","kind":13,"line":645},{"line":647,"kind":13,"name":"$self","containerName":"revcom"},{"containerName":"revcom","name":"throw","line":647,"kind":12},{"kind":13,"line":648,"containerName":"revcom","name":"$self"},{"containerName":"revcom","name":"is_flush","line":648,"kind":12},{"kind":13,"line":650,"containerName":"revcom","definition":"my","name":"$new","localvar":"my"},{"line":650,"kind":13,"containerName":"revcom","name":"$self"},{"line":651,"kind":13,"localvar":"my","containerName":"revcom","name":"$end","definition":"my"},{"kind":13,"line":651,"containerName":"revcom","name":"$self"},{"line":651,"kind":12,"name":"length","containerName":"revcom"},{"containerName":"revcom","name":"$new","kind":13,"line":653},{"line":653,"kind":13,"containerName":"revcom","name":"$self"},{"line":653,"kind":13,"containerName":"revcom","name":"$end"}]},{"name":"SUPER","containerName":"revcom","kind":12,"line":651},{"name":"_meta","line":653,"kind":12},{"kind":12,"line":653,"name":"_meta"},{"containerName":null,"name":"%self","line":654,"kind":13},{"name":"_meta","kind":12,"line":654},{"line":656,"kind":13,"name":"$new","containerName":null},{"line":669,"children":[{"line":670,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"trunc"},{"kind":13,"line":670,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$end","line":670,"kind":13},{"line":673,"kind":13,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$start","kind":13,"line":673},{"containerName":"trunc","name":"$self","line":674,"kind":13},{"line":674,"kind":12,"containerName":"trunc","name":"throw"},{"kind":13,"line":675,"containerName":"trunc","name":"$end"},{"name":"$end","containerName":"trunc","kind":13,"line":675},{"name":"$self","containerName":"trunc","line":676,"kind":13},{"name":"throw","containerName":"trunc","kind":12,"line":676},{"line":677,"kind":13,"name":"$end","containerName":"trunc"},{"line":677,"kind":13,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$self","line":678,"kind":13},{"name":"throw","containerName":"trunc","kind":12,"line":678},{"name":"$end","containerName":"trunc","kind":13,"line":679},{"line":679,"kind":13,"name":"$self","containerName":"trunc"},{"kind":12,"line":679,"name":"length","containerName":"trunc"},{"containerName":"trunc","name":"$self","kind":13,"line":680},{"kind":12,"line":680,"containerName":"trunc","name":"throw"},{"definition":"my","name":"$new","containerName":"trunc","localvar":"my","kind":13,"line":682},{"kind":13,"line":682,"containerName":"trunc","name":"$self"},{"containerName":"trunc","name":"$start","line":682,"kind":13},{"containerName":"trunc","name":"$end","kind":13,"line":682},{"name":"$start","containerName":"trunc","kind":13,"line":683},{"name":"$end","containerName":"trunc","kind":13,"line":684},{"line":686,"kind":13,"name":"$new","containerName":"trunc"},{"containerName":"trunc","name":"$self","kind":13,"line":686},{"containerName":"trunc","name":"$start","line":686,"kind":13},{"name":"$end","containerName":"trunc","line":686,"kind":13}],"kind":12,"detail":"($self,$start,$end)","signature":{"label":"trunc($self,$start,$end)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same\n           length as sequence . Called from L<force_flush>\n Returns : \n Args    : \n\n\n\nsub _do_flush {\n    my ($self) = @_;\n\n    foreach my $name ($self->meta_names) {\n        #print \"seq: \", $self->length , \"  \", $name, \": \", $self->named_meta_length($name), \"======\\n\";\n        \n        # elongnation\n        if ($self->length > $self->named_meta_length($name)) {\n            my $diff = $self->length - $self->named_meta_length($name);\n            foreach (1..$diff) { push @{$self->{'_meta'}->{$name}}, $META_GAP}\n        }\n        # truncation\n        elsif ( $self->length < $self->named_meta_length($name) ) {\n            $self->{_meta}->{$name} = [@{$self->{_meta}->{$name}}[0..($self->length-1)]]\n        }\n    }\n}\n\n\n\n=head2 is_flush\n\n Title   : is_flush\n Usage   : $is_flush  = $obj->is_flush()\n           or  $is_flush = $obj->is_flush($my_meta_name)\n Function: Boolean to tell if all meta values are in\n           flush with the sequence length.\n           Returns true if force_flush() is set\n           Set verbosity to a positive value to see failed meta sets\n Returns : boolean 1 or 0\n Args    : optional name of the meta set\n\n\nsub is_flush {\n\n    my ($self, $name) = shift;\n\n    return 1 if $self->force_flush;\n\n    my $sticky = '';\n\n\n    if ($name) {\n        $sticky .= \"$name \" if $self->length != $self->named_meta_length($name);\n    } else {\n        foreach my $m ($self->meta_names) {\n            $sticky .= \"$m \" if $self->length != $self->named_meta_length($m);\n        }\n    }\n\n    if ($sticky) {\n        print \"These meta set are not flush: $sticky\\n\" if $self->verbose; \n        return 0;\n    }\n\n    return 1;\n}\n\n\n=head1 Bio::PrimarySeqI methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $newseq = $seq->revcom();\n Function: Produces a new Bio::Seq::MetaI implementing object where\n           the order of residues and their meta information is reversed.\n Returns : A new (fresh) Bio::Seq::Meta object\n Args    : none\n Throws  : if the object returns false on is_flush()\n\nNote: The method does nothing to meta values, it reorders them, only.\n\n\nsub revcom {\n    my $self = shift;\n\n    $self->throw(\"Can not get a reverse complement. The object is not flush.\")\n        unless $self->is_flush;\n\n    my $new = $self->SUPER::revcom;\n    my $end = $self->length - 1;\n    map {\n        $new->{_meta}->{$_} = [ reverse @{$self->{_meta}->{$_}}[0..$end]]\n    } keys %{$self->{_meta}};\n\n    return $new;\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $seq->trunc(10,100);\n Function: Provides a truncation of a sequence together with meta data\n Returns : a fresh Bio::Seq::Meta implementing object\n Args    : Two integers denoting first and last residue of the sub-sequence.","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":669,"character":0},"end":{"character":9999,"line":687}},"name":"trunc"},{"name":"SUPER","containerName":"trunc","line":682,"kind":12},{"kind":12,"line":686,"name":"_meta"},{"name":"_meta","kind":12,"line":686},{"containerName":null,"name":"%self","kind":13,"line":687},{"name":"_meta","kind":12,"line":687},{"containerName":null,"name":"$new","line":688,"kind":13}]}