{"version":5,"vars":[{"line":85,"kind":2,"containerName":"","name":"vars"},{"line":89,"kind":2,"name":"base","containerName":""},{"range":{"end":{"character":9999,"line":113},"start":{"character":0,"line":91}},"name":"new","line":91,"children":[{"kind":13,"line":92,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"line":92,"kind":13,"containerName":"new","name":"%params"},{"localvar":"my","containerName":"new","definition":"my","name":"$seq","line":97,"kind":13},{"containerName":"new","name":"$params","kind":13,"line":97},{"name":"$params","containerName":"new","kind":13,"line":97},{"kind":13,"line":98,"containerName":"new","name":"$seq"},{"containerName":"new","name":"$params","line":99,"kind":13},{"containerName":"new","name":"$params","kind":13,"line":100},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":102,"kind":13},{"name":"$class","containerName":"new","line":102,"kind":13},{"kind":13,"line":102,"name":"%params","containerName":"new"},{"line":103,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":103,"name":"_initialize_io","containerName":"new"},{"name":"%params","containerName":"new","kind":13,"line":103},{"localvar":"my","containerName":"new","name":"$tempdir","definition":"my","line":104,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":104},{"containerName":"new","name":"tempdir","line":104,"kind":12},{"localvar":"my","definition":"my","name":"$tfh","containerName":"new","line":105,"kind":13},{"kind":13,"line":105,"containerName":"new","name":"$file"},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":105,"name":"tempfile","containerName":"new"},{"containerName":"new","name":"$tempdir","kind":13,"line":105},{"name":"$self","containerName":"new","line":106,"kind":13},{"kind":13,"line":106,"name":"$tempdir","containerName":"new"},{"containerName":"new","name":"$tfh","line":107,"kind":13},{"kind":13,"line":107,"name":"$self","containerName":"new"},{"containerName":"new","name":"_fh","kind":12,"line":107},{"kind":13,"line":107,"containerName":"new","name":"$tfh"},{"name":"$file","containerName":"new","kind":13,"line":108},{"name":"$self","containerName":"new","line":108,"kind":13},{"name":"_filename","containerName":"new","line":108,"kind":12},{"kind":13,"line":108,"name":"$file","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":109},{"containerName":"new","name":"length","line":109,"kind":12},{"containerName":"new","name":"$seq","line":110,"kind":13},{"containerName":"new","name":"$self","line":110,"kind":13},{"name":"seq","containerName":"new","line":110,"kind":12},{"kind":13,"line":110,"name":"$seq","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":112}],"kind":12,"detail":"($class,%params)","signature":{"parameters":[{"label":"$class"},{"label":"%params"}],"documentation":"","label":"new($class,%params)"},"containerName":"main::","definition":"sub"},{"containerName":"new","name":"SUPER","kind":12,"line":102},{"kind":12,"line":104,"name":"CLEANUP"},{"name":"DIR","line":105,"kind":12},{"name":"tempdir","line":106,"kind":12},{"name":"length","range":{"start":{"character":0,"line":128},"end":{"line":134,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"length($obj,$value)"},"detail":"($obj,$value)","kind":12,"children":[{"localvar":"my","containerName":"length","definition":"my","name":"$obj","line":129,"kind":13},{"kind":13,"line":129,"name":"$value","containerName":"length"},{"kind":13,"line":130,"containerName":"length","name":"$value"},{"line":131,"kind":13,"containerName":"length","name":"$obj"},{"containerName":"length","name":"$value","kind":13,"line":131},{"line":133,"kind":13,"containerName":"length","name":"$obj"},{"kind":13,"line":133,"name":"$obj","containerName":"length"}],"line":128},{"range":{"end":{"line":158,"character":9999},"start":{"line":148,"character":0}},"name":"seq","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"seq($self,$data)"},"containerName":"main::","definition":"sub","line":148,"children":[{"line":149,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"seq"},{"line":149,"kind":13,"name":"$data","containerName":"seq"},{"line":150,"kind":13,"containerName":"seq","name":"$data"},{"name":"$self","containerName":"seq","line":151,"kind":13},{"kind":12,"line":151,"containerName":"seq","name":"length"},{"containerName":"seq","name":"$self","line":152,"kind":13},{"kind":12,"line":152,"name":"add_sequence_as_string","containerName":"seq"},{"containerName":"seq","name":"$data","line":152,"kind":13},{"line":154,"kind":13,"containerName":"seq","name":"$self"},{"line":154,"kind":12,"name":"warn","containerName":"seq"},{"name":"$self","containerName":"seq","line":157,"kind":13},{"kind":12,"line":157,"name":"subseq","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":157},{"kind":12,"line":157,"name":"length","containerName":"seq"}],"kind":12},{"range":{"end":{"line":235,"character":9999},"start":{"line":172,"character":0}},"name":"subseq","children":[{"localvar":"my","containerName":"subseq","name":"$self","definition":"my","line":173,"kind":13},{"name":"$start","containerName":"subseq","line":173,"kind":13},{"name":"$end","containerName":"subseq","line":173,"kind":13},{"localvar":"my","name":"$string","definition":"my","containerName":"subseq","line":174,"kind":13},{"definition":"my","name":"$fh","containerName":"subseq","localvar":"my","kind":13,"line":175},{"kind":13,"line":175,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"_fh","kind":12,"line":175},{"name":"$start","containerName":"subseq","line":177,"kind":13},{"containerName":"subseq","name":"$start","line":177,"kind":13},{"kind":12,"line":177,"name":"isa","containerName":"subseq"},{"name":"$loc","definition":"my","containerName":"subseq","localvar":"my","kind":13,"line":178},{"line":178,"kind":13,"containerName":"subseq","name":"$start"},{"name":"$loc","containerName":"subseq","line":179,"kind":13},{"kind":12,"line":179,"containerName":"subseq","name":"length"},{"line":180,"kind":13,"containerName":"subseq","name":"$self"},{"name":"warn","containerName":"subseq","line":180,"kind":12},{"containerName":"subseq","name":"$loc","kind":13,"line":182},{"line":182,"kind":12,"containerName":"subseq","name":"end"},{"line":182,"kind":13,"name":"$loc","containerName":"subseq"},{"line":182,"kind":12,"containerName":"subseq","name":"start"},{"line":184,"kind":13,"name":"$self","containerName":"subseq"},{"name":"warn","containerName":"subseq","line":184,"kind":12},{"kind":13,"line":186,"definition":"my","name":"$seq","containerName":"subseq","localvar":"my"},{"line":187,"kind":13,"containerName":"subseq","name":"$loc"},{"line":187,"kind":12,"containerName":"subseq","name":"isa"},{"kind":13,"line":188,"containerName":"subseq","name":"$subloc","definition":"my","localvar":"my"},{"containerName":"subseq","name":"$loc","line":188,"kind":13},{"containerName":"subseq","name":"sub_Location","kind":12,"line":188},{"kind":13,"line":189,"containerName":"subseq","name":"$fh"},{"kind":13,"line":189,"name":"$subloc","containerName":"subseq"},{"kind":12,"line":189,"name":"start","containerName":"subseq"},{"line":190,"kind":13,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"throw","kind":12,"line":190},{"line":192,"kind":13,"localvar":"my","definition":"my","name":"$ret","containerName":"subseq"},{"line":192,"kind":13,"name":"$fh","containerName":"subseq"},{"line":192,"kind":13,"name":"$string","containerName":"subseq"},{"kind":13,"line":192,"containerName":"subseq","name":"$subloc"},{"name":"length","containerName":"subseq","kind":12,"line":192},{"kind":13,"line":193,"containerName":"subseq","name":"$ret"},{"kind":13,"line":194,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"throw","kind":12,"line":194},{"kind":13,"line":196,"name":"$subloc","containerName":"subseq"},{"line":196,"kind":12,"containerName":"subseq","name":"strand"},{"containerName":"subseq","name":"$string","line":197,"kind":13},{"kind":12,"line":197,"containerName":"subseq","name":"new"},{"name":"$string","containerName":"subseq","line":197,"kind":13},{"name":"revcom","containerName":"subseq","kind":12,"line":197},{"line":197,"kind":12,"name":"seq","containerName":"subseq"},{"containerName":"subseq","name":"$seq","line":199,"kind":13},{"line":199,"kind":13,"containerName":"subseq","name":"$string"},{"line":202,"kind":13,"containerName":"subseq","name":"$fh"},{"kind":13,"line":202,"name":"$loc","containerName":"subseq"},{"line":202,"kind":12,"containerName":"subseq","name":"start"},{"kind":13,"line":203,"containerName":"subseq","name":"$self"},{"name":"throw","containerName":"subseq","line":203,"kind":12},{"name":"$loc","containerName":"subseq","kind":13,"line":203},{"line":203,"kind":12,"containerName":"subseq","name":"start"},{"line":204,"kind":13,"containerName":"subseq","name":"$loc"},{"line":204,"kind":12,"containerName":"subseq","name":"end"},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"$ret","containerName":"subseq"},{"line":206,"kind":13,"name":"$fh","containerName":"subseq"},{"name":"$string","containerName":"subseq","kind":13,"line":206},{"name":"$loc","containerName":"subseq","kind":13,"line":206},{"kind":12,"line":206,"containerName":"subseq","name":"length"},{"kind":13,"line":207,"name":"$ret","containerName":"subseq"},{"containerName":"subseq","name":"$self","kind":13,"line":208},{"kind":12,"line":208,"name":"throw","containerName":"subseq"},{"name":"$loc","containerName":"subseq","line":208,"kind":13},{"containerName":"subseq","name":"start","line":208,"kind":12},{"kind":13,"line":209,"name":"$loc","containerName":"subseq"},{"line":209,"kind":12,"name":"end","containerName":"subseq"},{"kind":13,"line":211,"containerName":"subseq","name":"$seq"},{"name":"$string","containerName":"subseq","line":211,"kind":13},{"kind":13,"line":213,"name":"$loc","containerName":"subseq"},{"name":"strand","containerName":"subseq","line":213,"kind":12},{"line":214,"kind":13,"containerName":"subseq","name":"$loc"},{"containerName":"subseq","name":"strand","kind":12,"line":214},{"containerName":"subseq","name":"$seq","kind":13,"line":215},{"name":"new","containerName":"subseq","line":215,"kind":12},{"line":215,"kind":13,"containerName":"subseq","name":"$seq"},{"line":215,"kind":12,"name":"revcom","containerName":"subseq"},{"kind":12,"line":215,"containerName":"subseq","name":"seq"},{"name":"$seq","containerName":"subseq","kind":13,"line":217},{"kind":13,"line":219,"name":"$start","containerName":"subseq"},{"line":219,"kind":13,"name":"$end","containerName":"subseq"},{"name":"$self","containerName":"subseq","kind":13,"line":219},{"line":219,"kind":12,"containerName":"subseq","name":"length"},{"name":"$self","containerName":"subseq","kind":13,"line":220},{"name":"throw","containerName":"subseq","line":220,"kind":12},{"containerName":"subseq","name":"$self","kind":13,"line":221},{"kind":12,"line":221,"containerName":"subseq","name":"length"},{"line":223,"kind":13,"name":"$end","containerName":"subseq"},{"kind":13,"line":223,"containerName":"subseq","name":"$start"},{"containerName":"subseq","name":"$self","kind":13,"line":224},{"containerName":"subseq","name":"throw","kind":12,"line":224},{"line":227,"kind":13,"name":"$fh","containerName":"subseq"},{"kind":13,"line":227,"name":"$start","containerName":"subseq"},{"line":228,"kind":13,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"throw","kind":12,"line":228},{"kind":13,"line":230,"definition":"my","name":"$ret","containerName":"subseq","localvar":"my"},{"line":230,"kind":13,"name":"$fh","containerName":"subseq"},{"kind":13,"line":230,"name":"$string","containerName":"subseq"},{"line":230,"kind":13,"containerName":"subseq","name":"$end"},{"containerName":"subseq","name":"$start","line":230,"kind":13},{"kind":13,"line":231,"containerName":"subseq","name":"$ret"},{"name":"$self","containerName":"subseq","line":232,"kind":13},{"name":"throw","containerName":"subseq","line":232,"kind":12},{"line":234,"kind":13,"containerName":"subseq","name":"$string"}],"line":172,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"subseq($self,$start,$end)"},"detail":"($self,$start,$end)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":197},{"containerName":"PrimarySeq","name":"Bio","kind":12,"line":215},{"definition":"sub","containerName":"main::","signature":{"label":"add_sequence_as_string($self,$str)","documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append","parameters":[{"label":"$self"},{"label":"$str"}]},"detail":"($self,$str)","kind":12,"children":[{"kind":13,"line":250,"definition":"my","name":"$self","containerName":"add_sequence_as_string","localvar":"my"},{"line":250,"kind":13,"containerName":"add_sequence_as_string","name":"$str"},{"name":"$len","definition":"my","containerName":"add_sequence_as_string","localvar":"my","kind":13,"line":251},{"name":"$self","containerName":"add_sequence_as_string","line":251,"kind":13},{"line":251,"kind":12,"name":"length","containerName":"add_sequence_as_string"},{"containerName":"add_sequence_as_string","name":"$str","line":251,"kind":13},{"line":252,"kind":13,"localvar":"my","containerName":"add_sequence_as_string","definition":"my","name":"$fh"},{"containerName":"add_sequence_as_string","name":"$self","line":252,"kind":13},{"name":"_fh","containerName":"add_sequence_as_string","kind":12,"line":252},{"containerName":"add_sequence_as_string","name":"$fh","line":253,"kind":13},{"kind":13,"line":254,"name":"$self","containerName":"add_sequence_as_string"},{"name":"throw","containerName":"add_sequence_as_string","line":254,"kind":12},{"line":256,"kind":13,"containerName":"add_sequence_as_string","name":"$self"},{"line":256,"kind":12,"containerName":"add_sequence_as_string","name":"_print"},{"name":"$str","containerName":"add_sequence_as_string","line":256,"kind":13},{"containerName":"add_sequence_as_string","name":"$self","line":257,"kind":13},{"kind":12,"line":257,"name":"length","containerName":"add_sequence_as_string"},{"name":"$len","containerName":"add_sequence_as_string","kind":13,"line":257}],"line":249,"name":"add_sequence_as_string","range":{"start":{"character":0,"line":249},"end":{"character":9999,"line":258}}},{"line":251,"kind":12,"containerName":"length","name":"CORE"},{"line":273,"children":[{"localvar":"my","definition":"my","name":"$obj","containerName":"_filename","line":274,"kind":13},{"line":274,"kind":13,"containerName":"_filename","name":"$value"},{"kind":13,"line":275,"name":"$value","containerName":"_filename"},{"containerName":"_filename","name":"$obj","line":276,"kind":13},{"containerName":"_filename","name":"$value","kind":13,"line":276},{"name":"$obj","containerName":"_filename","kind":13,"line":278}],"kind":12,"detail":"($obj,$value)","signature":{"label":"_filename($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function: \n Example : \n Returns : value of _filename\n Args    : newvalue (optional)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":280},"start":{"character":0,"line":273}},"name":"_filename"},{"range":{"start":{"line":295,"character":0},"end":{"line":302,"character":9999}},"name":"alphabet","children":[{"line":296,"kind":13,"localvar":"my","containerName":"alphabet","definition":"my","name":"$self"},{"line":296,"kind":13,"containerName":"alphabet","name":"$value"},{"name":"$value","containerName":"alphabet","kind":13,"line":297},{"name":"$self","containerName":"alphabet","kind":13,"line":298},{"kind":13,"line":298,"containerName":"alphabet","name":"$value"},{"kind":13,"line":300,"containerName":"alphabet","name":"$self"}],"line":295,"kind":12,"signature":{"label":"alphabet($self,$value)","documentation":"1;\n# $Id: LargePrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargePrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n#\n# updated to utilize File::Temp - jason 2000-12-12\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargePrimarySeq - PrimarySeq object that stores sequence as\nfiles in the tempdir (as found by File::Temp) or the default method in\nBio::Root::Root\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Jason Stajich\n\nEmail birney@ebi.ac.uk\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargePrimarySeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::PrimarySeq Bio::Root::IO Bio::Seq::LargeSeqI);\n\nsub new {\n    my ($class, %params) = @_;\n    \n    # don't let PrimarySeq set seq until we have \n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n    delete $params{'-seq'};\n    delete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n    $self->{tempdir} = $tempdir;\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);    \n    $self->length(0);\n    $seq && $self->seq($seq); \n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;   \n   if( defined $data ) {\n       if( $self->length() == 0) {\n       $self->add_sequence_as_string($data);\n       } else { \n       $self->warn(\"Trying to reset the seq string, cannot do this with a LargePrimarySeq - must allocate a new object\");\n       }\n   } \n   return $self->subseq(1,$self->length);\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) { \n       $self->warn(\"Expect location lengths to be > 0\");\n       return '';\n       } elsif( $loc->end < $loc->start ) { \n       # what about circular seqs\n       $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n       foreach my $subloc ( $loc->sub_Location ) {\n           if(! seek($fh,$subloc->start() - 1,0)) {\n           $self->throw(\"Unable to seek on file $start:$end $!\");\n           }\n           my $ret = read($fh, $string, $subloc->length());\n           if( !defined $ret ) {\n           $self->throw(\"Unable to read $start:$end $!\");\n           }\n           if( $subloc->strand < 0 ) { \n           $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n           }\n           $seq .= $string;\n       }\n       } else { \n       if(! seek($fh,$loc->start()-1,0)) {\n           $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       my $ret = read($fh, $string, $loc->length());\n       if( !defined $ret ) {\n           $self->throw(\"Unable to read \".$loc->start.\":\".\n                $loc->end .\" $!\");\n       }\n       $seq = $string;\n       }\n       if( defined $loc->strand && \n       $loc->strand < 0 ) { \n       $seq = Bio::PrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n            $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function: \n Example : \n Returns : value of _filename\n Args    : newvalue (optional)\n\n\n\nsub _filename{\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'_filename'} = $value;\n    }\n    return $obj->{'_filename'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet($newval)\n Function: \n Example : \n Returns : value of alphabet\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"line":298,"name":"SUPER","containerName":"alphabet"},{"name":"SUPER","containerName":"alphabet","kind":12,"line":300},{"range":{"start":{"line":304,"character":0},"end":{"line":313,"character":9999}},"containerName":"main::","definition":"sub","name":"DESTROY","line":304,"children":[{"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my","kind":13,"line":305},{"name":"$fh","definition":"my","containerName":"DESTROY","localvar":"my","kind":13,"line":306},{"line":306,"kind":13,"containerName":"DESTROY","name":"$self"},{"name":"_fh","containerName":"DESTROY","line":306,"kind":12},{"name":"$fh","containerName":"DESTROY","kind":13,"line":307},{"kind":13,"line":307,"containerName":"DESTROY","name":"$fh"},{"line":309,"kind":13,"name":"$self","containerName":"DESTROY"},{"line":309,"kind":12,"containerName":"DESTROY","name":"_filename"},{"line":309,"kind":13,"containerName":"DESTROY","name":"$self"},{"containerName":"DESTROY","name":"_filename","line":309,"kind":12},{"line":309,"kind":13,"name":"$self","containerName":"DESTROY"},{"name":"_filename","containerName":"DESTROY","kind":12,"line":309},{"kind":13,"line":311,"name":"$self","containerName":"DESTROY"},{"kind":13,"line":311,"containerName":"DESTROY","name":"$self"},{"kind":13,"line":311,"name":"$self","containerName":"DESTROY"},{"kind":13,"line":312,"name":"$self","containerName":"DESTROY"}],"kind":12},{"name":"tempdir","line":311,"kind":12},{"name":"tempdir","line":311,"kind":12},{"name":"tempdir","kind":12,"line":311},{"line":312,"kind":12,"containerName":"DESTROY","name":"SUPER"}]}