{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":85},{"name":"base","containerName":"","line":90,"kind":2},{"line":96,"kind":13,"name":"%MODEMAP","containerName":null},{"line":96,"kind":2,"name":"POSIX","containerName":""},{"name":"$GAPCHAR","containerName":null,"line":100,"kind":13},{"containerName":null,"name":"%MAPPING","line":101,"kind":13},{"name":"new","range":{"start":{"line":134,"character":0},"end":{"character":9999,"line":138}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :","label":"new($class,@args)"},"kind":12,"line":134,"children":[{"kind":13,"line":135,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"kind":13,"line":135,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":136},{"line":136,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":136,"kind":13},{"containerName":"new","name":"$self","line":137,"kind":13}]},{"kind":12,"line":136,"name":"SUPER","containerName":"new"},{"range":{"start":{"character":0,"line":150},"end":{"line":250,"character":9999}},"name":"next_result","children":[{"line":151,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_result"},{"containerName":"next_result","definition":"my","name":"$curquery","localvar":"my","kind":13,"line":155},{"name":"$curhit","containerName":"next_result","line":155,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":156},{"kind":12,"line":156,"name":"start_document","containerName":"next_result"},{"line":157,"kind":13,"localvar":"my","name":"@hit_signifs","definition":"my","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":158},{"name":"_readline","containerName":"next_result","kind":12,"line":158},{"kind":13,"line":168,"definition":"my","name":"$alnnum","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$qname","kind":13,"line":168},{"name":"$qstart","containerName":"next_result","line":168,"kind":13},{"name":"$qend","containerName":"next_result","kind":13,"line":168},{"kind":13,"line":168,"name":"$hname","containerName":"next_result"},{"containerName":"next_result","name":"$hstart","line":169,"kind":13},{"name":"$hend","containerName":"next_result","kind":13,"line":169},{"kind":13,"line":169,"containerName":"next_result","name":"$hstrand"},{"name":"$score","containerName":"next_result","kind":13,"line":169},{"line":171,"kind":13,"name":"$self","containerName":"next_result"},{"line":173,"kind":13,"name":"$qstart","containerName":"next_result"},{"kind":13,"line":173,"name":"$qend","containerName":"next_result"},{"containerName":"next_result","name":"$hstart","kind":13,"line":173},{"containerName":"next_result","name":"$hend","line":173,"kind":13},{"name":"$curquery","containerName":"next_result","kind":13,"line":174},{"name":"$curquery","containerName":"next_result","line":175,"kind":13},{"name":"$qname","containerName":"next_result","kind":13,"line":175},{"kind":13,"line":176,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","line":176,"kind":12},{"line":177,"kind":13,"name":"$self","containerName":"next_result"},{"line":177,"kind":12,"name":"_pushback","containerName":"next_result"},{"line":178,"kind":13,"containerName":"next_result","name":"$self"},{"line":178,"kind":12,"name":"end_element","containerName":"next_result"},{"kind":13,"line":179,"name":"$self","containerName":"next_result"},{"kind":12,"line":179,"name":"end_document","containerName":"next_result"},{"kind":13,"line":182,"containerName":"next_result","name":"$curhit"},{"kind":13,"line":183,"containerName":"next_result","name":"$curhit"},{"kind":13,"line":183,"containerName":"next_result","name":"$hname"},{"line":185,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":185,"name":"end_element","containerName":"next_result"},{"line":186,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"start_element","line":186,"kind":12},{"kind":13,"line":187,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":187,"kind":12},{"containerName":"next_result","name":"$hname","kind":13,"line":188},{"name":"$curquery","containerName":"next_result","kind":13,"line":189},{"kind":13,"line":190,"name":"$self","containerName":"next_result"},{"line":190,"kind":12,"containerName":"next_result","name":"start_element"},{"kind":13,"line":191,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"$self","line":192,"kind":13},{"kind":12,"line":192,"containerName":"next_result","name":"element"},{"kind":13,"line":193,"containerName":"next_result","name":"$qname"},{"containerName":"next_result","name":"$self","line":195,"kind":13},{"name":"start_element","containerName":"next_result","kind":12,"line":195},{"line":196,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":196},{"line":197,"kind":13,"containerName":"next_result","name":"$hname"},{"containerName":"next_result","name":"$self","line":199,"kind":13},{"name":"start_element","containerName":"next_result","kind":12,"line":199},{"kind":13,"line":200,"definition":"my","name":"$queryalign","containerName":"next_result","localvar":"my"},{"kind":13,"line":200,"name":"$self","containerName":"next_result"},{"name":"_readline","containerName":"next_result","line":200,"kind":12},{"kind":13,"line":201,"name":"$hitalign","definition":"my","containerName":"next_result","localvar":"my"},{"line":201,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":201,"containerName":"next_result","name":"_readline"},{"name":"$queryalign","containerName":"next_result","kind":13,"line":202},{"line":203,"kind":13,"name":"$hitalign","containerName":"next_result"},{"kind":13,"line":204,"containerName":"next_result","definition":"my","name":"$alnlen","localvar":"my"},{"containerName":"next_result","name":"$queryalign","kind":13,"line":204},{"localvar":"my","definition":"my","name":"$qgapnum","containerName":"next_result","line":205,"kind":13},{"name":"$queryalign","containerName":"next_result","kind":13,"line":205},{"localvar":"my","containerName":"next_result","name":"$hgapnum","definition":"my","line":206,"kind":13},{"name":"$hitalign","containerName":"next_result","line":206,"kind":13},{"kind":13,"line":207,"name":"$totalgaps","definition":"my","containerName":"next_result","localvar":"my"},{"line":207,"kind":13,"containerName":"next_result","name":"$qgapnum"},{"kind":13,"line":207,"name":"$hgapnum","containerName":"next_result"},{"containerName":"next_result","name":"$hstrand","kind":13,"line":209},{"name":"$hstart","containerName":"next_result","kind":13,"line":210},{"kind":13,"line":210,"name":"$hend","containerName":"next_result"},{"containerName":"next_result","name":"$hend","kind":13,"line":210},{"name":"$hstart","containerName":"next_result","kind":13,"line":210},{"containerName":"next_result","name":"$self","kind":13,"line":212},{"name":"element","containerName":"next_result","kind":12,"line":212},{"line":213,"kind":13,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":214,"kind":13},{"kind":12,"line":214,"name":"element","containerName":"next_result"},{"kind":13,"line":215,"name":"$qstart","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":216,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":216},{"kind":13,"line":217,"name":"$qend","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":218,"kind":13},{"line":218,"kind":12,"containerName":"next_result","name":"element"},{"line":219,"kind":13,"name":"$hstart","containerName":"next_result"},{"line":220,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":220},{"kind":13,"line":221,"containerName":"next_result","name":"$hend"},{"line":222,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":222,"containerName":"next_result","name":"element"},{"name":"$qgapnum","containerName":"next_result","kind":13,"line":223},{"containerName":"next_result","name":"$hgapnum","kind":13,"line":223},{"containerName":"next_result","name":"$self","kind":13,"line":224},{"containerName":"next_result","name":"element","line":224,"kind":12},{"containerName":"next_result","name":"$qgapnum","kind":13,"line":225},{"name":"$self","containerName":"next_result","line":226,"kind":13},{"kind":12,"line":226,"name":"element","containerName":"next_result"},{"kind":13,"line":227,"name":"$hgapnum","containerName":"next_result"},{"line":229,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":229,"kind":12},{"kind":13,"line":230,"containerName":"next_result","name":"$alnlen"},{"kind":13,"line":230,"containerName":"next_result","name":"$totalgaps"},{"name":"$self","containerName":"next_result","kind":13,"line":231},{"kind":12,"line":231,"name":"element","containerName":"next_result"},{"kind":13,"line":232,"containerName":"next_result","name":"$alnlen"},{"name":"$totalgaps","containerName":"next_result","kind":13,"line":232},{"name":"$self","containerName":"next_result","line":233,"kind":13},{"line":233,"kind":12,"containerName":"next_result","name":"element"},{"line":234,"kind":13,"containerName":"next_result","name":"$queryalign"},{"containerName":"next_result","name":"$self","line":235,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":235},{"kind":13,"line":236,"name":"$hitalign","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":238,"kind":13},{"line":238,"kind":12,"name":"end_element","containerName":"next_result"},{"containerName":"next_result","name":"$curquery","line":239,"kind":13},{"line":239,"kind":13,"name":"$qname","containerName":"next_result"},{"kind":13,"line":240,"containerName":"next_result","name":"$curhit"},{"line":240,"kind":13,"containerName":"next_result","name":"$hname"},{"line":244,"kind":13,"containerName":"next_result","name":"$curquery"},{"name":"$self","containerName":"next_result","kind":13,"line":245},{"line":245,"kind":12,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","kind":13,"line":246},{"kind":12,"line":246,"name":"end_element","containerName":"next_result"},{"line":247,"kind":13,"name":"$self","containerName":"next_result"},{"name":"end_document","containerName":"next_result","line":247,"kind":12}],"line":150,"kind":12,"signature":{"label":"next_result($self)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"_initialize","range":{"end":{"character":9999,"line":258},"start":{"character":0,"line":252}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":252,"children":[{"line":253,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","kind":13,"line":253},{"containerName":"_initialize","name":"$self","line":254,"kind":13},{"line":254,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":255},{"line":255,"kind":12,"name":"_eventHandler","containerName":"_initialize"},{"kind":12,"line":255,"containerName":"_initialize","name":"register_factory"},{"containerName":"_initialize","name":"new","line":255,"kind":12},{"containerName":"_initialize","name":"$self","line":257,"kind":13},{"name":"_eventHandler","containerName":"_initialize","kind":12,"line":257},{"line":257,"kind":12,"name":"register_factory","containerName":"_initialize"},{"containerName":"_initialize","name":"new","kind":12,"line":257}]},{"kind":12,"line":254,"containerName":"_initialize","name":"SUPER"},{"name":"Bio","containerName":"Search::Result::ResultFactory","line":255,"kind":12},{"containerName":"Search::HSP::HSPFactory","name":"Bio","line":257,"kind":12},{"signature":{"label":"start_element($self,$data)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":273,"name":"$self","definition":"my","containerName":"start_element","localvar":"my"},{"line":273,"kind":13,"containerName":"start_element","name":"$data"},{"localvar":"my","definition":"my","name":"$nm","containerName":"start_element","line":275,"kind":13},{"kind":13,"line":275,"name":"$data","containerName":"start_element"},{"name":"$type","definition":"my","containerName":"start_element","localvar":"my","kind":13,"line":276},{"line":276,"kind":13,"name":"$MODEMAP","containerName":"start_element"},{"kind":13,"line":276,"containerName":"start_element","name":"$nm"},{"line":277,"kind":13,"containerName":"start_element","name":"$self"},{"kind":12,"line":277,"name":"_mode","containerName":"start_element"},{"name":"$type","containerName":"start_element","line":277,"kind":13},{"kind":13,"line":278,"name":"$self","containerName":"start_element"},{"kind":12,"line":278,"containerName":"start_element","name":"_eventHandler"},{"line":278,"kind":12,"containerName":"start_element","name":"will_handle"},{"containerName":"start_element","name":"$type","line":278,"kind":13},{"localvar":"my","name":"$func","definition":"my","containerName":"start_element","line":279,"kind":13},{"line":279,"kind":13,"containerName":"start_element","name":"$type"},{"kind":13,"line":280,"containerName":"start_element","name":"$self"},{"kind":12,"line":280,"containerName":"start_element","name":"_eventHandler"},{"containerName":"start_element","name":"$func","line":280,"kind":13},{"line":280,"kind":13,"containerName":"start_element","name":"$data"},{"containerName":"start_element","name":"$self","line":282,"kind":13},{"kind":13,"line":282,"containerName":"start_element","name":"$type"}],"line":272,"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":272}},"name":"start_element"},{"containerName":null,"name":"%nm","kind":13,"line":284},{"name":"%self","containerName":null,"kind":13,"line":285},{"containerName":null,"name":"%self","line":286,"kind":13},{"containerName":null,"name":"%self","line":287,"kind":13},{"range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":303}},"name":"end_element","signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"line":304,"kind":13,"localvar":"my","containerName":"end_element","definition":"my","name":"$self"},{"containerName":"end_element","name":"$data","kind":13,"line":304},{"containerName":"end_element","name":"$nm","definition":"my","localvar":"my","kind":13,"line":305},{"containerName":"end_element","name":"$data","kind":13,"line":305},{"kind":13,"line":306,"containerName":"end_element","definition":"my","name":"$rc","localvar":"my"},{"localvar":"my","definition":"my","name":"$type","containerName":"end_element","line":310,"kind":13},{"name":"$MODEMAP","containerName":"end_element","kind":13,"line":310},{"line":310,"kind":13,"name":"$nm","containerName":"end_element"},{"name":"$self","containerName":"end_element","line":311,"kind":13},{"name":"_eventHandler","containerName":"end_element","line":311,"kind":12},{"name":"will_handle","containerName":"end_element","kind":12,"line":311},{"containerName":"end_element","name":"$type","line":311,"kind":13},{"line":312,"kind":13,"localvar":"my","containerName":"end_element","name":"$func","definition":"my"},{"line":312,"kind":13,"name":"$type","containerName":"end_element"},{"kind":13,"line":313,"name":"$rc","containerName":"end_element"},{"line":313,"kind":13,"containerName":"end_element","name":"$self"},{"name":"_eventHandler","containerName":"end_element","line":313,"kind":12},{"kind":13,"line":313,"containerName":"end_element","name":"$func"},{"name":"$self","containerName":"end_element","kind":13,"line":313},{"line":314,"kind":13,"name":"$self","containerName":"end_element"},{"kind":13,"line":316,"containerName":"end_element","name":"$self"}],"line":303,"kind":12},{"name":"%MAPPING","containerName":null,"line":318,"kind":13},{"name":"%nm","containerName":null,"line":318,"kind":13},{"kind":13,"line":319,"name":"%MAPPING","containerName":null},{"kind":13,"line":319,"name":"%nm","containerName":null},{"localvar":"my","containerName":null,"name":"$key","definition":"my","line":320,"kind":13},{"containerName":null,"name":"%MAPPING","line":320,"kind":13},{"line":320,"kind":13,"name":"@nm","containerName":null},{"kind":13,"line":321,"containerName":null,"name":"%self"},{"kind":13,"line":321,"containerName":null,"name":"%key"},{"containerName":null,"name":"%MAPPING","kind":13,"line":321},{"name":"%nm","containerName":null,"line":321,"kind":13},{"containerName":null,"name":"$key","kind":13,"line":321},{"name":"%self","containerName":null,"line":321,"kind":13},{"line":323,"kind":13,"containerName":null,"name":"%self"},{"name":"%MAPPING","containerName":null,"kind":13,"line":323},{"kind":13,"line":323,"containerName":null,"name":"$nm"},{"containerName":null,"name":"%self","kind":13,"line":323},{"line":326,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"warn","kind":12,"line":326},{"containerName":null,"name":"%self","kind":13,"line":328},{"containerName":null,"name":"%self","line":330,"kind":13},{"name":"$rc","containerName":null,"kind":13,"line":330},{"containerName":null,"name":"$nm","kind":13,"line":330},{"name":"$rc","containerName":null,"kind":13,"line":331},{"kind":12,"line":346,"children":[{"kind":13,"line":347,"name":"$self","definition":"my","containerName":"element","localvar":"my"},{"name":"$data","containerName":"element","kind":13,"line":347},{"kind":13,"line":348,"name":"$self","containerName":"element"},{"line":348,"kind":12,"name":"start_element","containerName":"element"},{"line":348,"kind":13,"containerName":"element","name":"$data"},{"name":"$self","containerName":"element","line":349,"kind":13},{"kind":12,"line":349,"containerName":"element","name":"characters"},{"kind":13,"line":349,"name":"$data","containerName":"element"},{"line":350,"kind":13,"containerName":"element","name":"$self"},{"name":"end_element","containerName":"element","kind":12,"line":350},{"line":350,"kind":13,"name":"$data","containerName":"element"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"},"name":"element","range":{"start":{"character":0,"line":346},"end":{"character":9999,"line":351}}},{"range":{"start":{"character":0,"line":365},"end":{"line":380,"character":9999}},"name":"characters","line":365,"children":[{"kind":13,"line":366,"definition":"my","name":"$self","containerName":"characters","localvar":"my"},{"name":"$data","containerName":"characters","line":366,"kind":13},{"containerName":"characters","name":"$data","kind":13,"line":368},{"kind":13,"line":369,"name":"$data","containerName":"characters"},{"containerName":"characters","name":"$data","kind":13,"line":370},{"containerName":"characters","name":"$self","line":373,"kind":13},{"line":373,"kind":12,"containerName":"characters","name":"in_element"},{"containerName":"characters","name":"$data","line":374,"kind":13},{"kind":13,"line":376,"containerName":"characters","name":"$self"},{"containerName":"characters","name":"$data","kind":13,"line":376},{"kind":13,"line":376,"containerName":"characters","name":"$data"},{"containerName":"characters","name":"$self","line":379,"kind":13},{"name":"$data","containerName":"characters","line":379,"kind":13}],"kind":12,"detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","label":"characters($self,$data)"},"containerName":"main::","definition":"sub"},{"line":394,"children":[{"definition":"my","name":"$self","containerName":"_mode","localvar":"my","kind":13,"line":395},{"containerName":"_mode","name":"$value","line":395,"kind":13},{"containerName":"_mode","name":"$value","kind":13,"line":396},{"name":"$self","containerName":"_mode","kind":13,"line":397},{"containerName":"_mode","name":"$value","kind":13,"line":397},{"name":"$self","containerName":"_mode","line":399,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"label":"_mode($self,$value)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":394,"character":0},"end":{"character":9999,"line":400}},"name":"_mode"},{"children":[{"line":416,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"within_element"},{"containerName":"within_element","name":"$name","line":416,"kind":13},{"containerName":"within_element","name":"$name","line":417,"kind":13},{"containerName":"within_element","name":"$self","kind":13,"line":418},{"kind":13,"line":419,"name":"$self","containerName":"within_element"}],"line":415,"kind":12,"signature":{"label":"within_element($self,$name)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"detail":"($self,$name)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":415},"end":{"line":419,"character":9999}},"name":"within_element"},{"name":"%self","containerName":null,"line":420,"kind":13},{"name":"%name","containerName":null,"kind":13,"line":421},{"name":"in_element","range":{"end":{"character":9999,"line":445},"start":{"line":441,"character":0}},"kind":12,"children":[{"kind":13,"line":442,"containerName":"in_element","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":442,"containerName":"in_element","name":"$name"},{"name":"$self","containerName":"in_element","line":443,"kind":13},{"line":444,"kind":13,"containerName":"in_element","name":"$self"},{"name":"$name","containerName":"in_element","kind":13,"line":444}],"line":441,"definition":"sub","containerName":"main::","signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"detail":"($self,$name)"},{"definition":"sub","containerName":"main::","signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":460,"containerName":"start_document","definition":"my","name":"$self","localvar":"my"},{"line":461,"kind":13,"name":"$self","containerName":"start_document"},{"kind":13,"line":462,"name":"$self","containerName":"start_document"},{"containerName":"start_document","name":"$self","line":463,"kind":13},{"kind":13,"line":464,"containerName":"start_document","name":"$self"},{"containerName":"start_document","name":"$self","kind":13,"line":465}],"line":459,"name":"start_document","range":{"start":{"character":0,"line":459},"end":{"line":466,"character":9999}}},{"kind":12,"children":[{"kind":13,"line":481,"containerName":"end_document","name":"$self","definition":"my","localvar":"my"},{"containerName":"end_document","name":"@args","kind":13,"line":481},{"line":482,"kind":13,"containerName":"end_document","name":"$self"}],"line":480,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"end_document($self,@args)"},"detail":"($self,@args)","name":"end_document","range":{"end":{"character":9999,"line":483},"start":{"line":480,"character":0}}},{"kind":12,"children":[{"containerName":"result_count","definition":"my","name":"$self","localvar":"my","kind":13,"line":497},{"kind":13,"line":498,"containerName":"result_count","name":"$self"}],"line":496,"name":"result_count","definition":"sub","containerName":"main::","range":{"start":{"line":496,"character":0},"end":{"character":9999,"line":499}}},{"range":{"start":{"line":501,"character":0},"end":{"character":9999,"line":501}},"containerName":"main::","definition":"sub","name":"report_count","line":501,"children":[{"kind":12,"line":501,"containerName":"report_count","name":"result_count"}],"kind":12}]}