{"version":5,"vars":[{"line":128,"kind":2,"containerName":"","name":"vars"},{"name":"$MaxDescLen","containerName":null,"line":134,"kind":13},{"name":"strict","containerName":"","kind":2,"line":134},{"kind":13,"line":135,"containerName":null,"name":"%AlignmentLineWidth"},{"kind":13,"line":136,"name":"$TextWrapLoaded","containerName":null},{"name":"Text","containerName":"Wrap","line":136,"kind":12},{"containerName":null,"name":"$TextWrapLoaded","kind":13,"line":138},{"name":"base","containerName":"","kind":2,"line":144},{"line":161,"children":[{"kind":13,"line":162,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":162},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":164,"kind":13},{"line":164,"kind":13,"containerName":"new","name":"$class"},{"line":164,"kind":13,"name":"@args","containerName":"new"},{"line":165,"kind":13,"localvar":"my","definition":"my","name":"$filters","containerName":"new"},{"kind":13,"line":165,"containerName":"new","name":"$nowublastlinks"},{"containerName":"new","name":"$self","kind":13,"line":165},{"name":"_rearrange","containerName":"new","kind":12,"line":165},{"name":"@args","containerName":"new","kind":13,"line":167},{"line":168,"kind":13,"name":"$filters","containerName":"new"},{"name":"$filters","containerName":"new","kind":13,"line":169},{"line":170,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":170,"containerName":"new","name":"warn"},{"localvar":"my","definition":"my","name":"$type","containerName":"new","line":172,"kind":13},{"name":"$code","containerName":"new","line":172,"kind":13},{"name":"$filters","containerName":"new","kind":13,"line":172},{"containerName":"new","name":"$self","kind":13,"line":173},{"line":173,"kind":12,"containerName":"new","name":"filter"},{"name":"$type","containerName":"new","kind":13,"line":173},{"kind":13,"line":173,"name":"$code","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: TextResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::TextResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::TextResultWriter - Object to implement writing\na Bio::Search::ResultI in Text.\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::TextResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of Text for a specific Bio::Search::Report::ReportI interface.\n\nYou can also provide the argument -filters =E<gt> \\%hash to filter the at\nthe hsp, hit, or result level.  %hash is an associative array which\ncontains any or all of the keys (HSP, HIT, RESULT).  The values\npointed to by these keys would be references to a subroutine which\nexpects to be passed an object - one of Bio::Search::HSP::HSPI,\nBio::Search::Hit::HitI, and Bio::Search::Result::ResultI respectively.\nEach function needs to return a boolean value as to whether or not the\npassed element should be included in the output report - true if it is\nto be included, false if it to be omitted.\n\nFor example to filter on sequences in the database which are too short\nfor your criteria you would do the following.\n\nDefine a hit filter method \n\n  sub hit_filter { \n      my $hit = shift;\n      return $hit->length E<gt> 100; # test if length of the hit sequence\n                                     # long enough    \n  }\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HIT' =E<gt> \\&hit_filter }  \n      );\n\nAnother example would be to filter HSPs on percent identity, let's\nonly include HSPs which are 75% identical or better.\n\n   sub hsp_filter {\n       my $hsp = shift;\n       return $hsp->percent_identity E<gt> 75;\n   }\n   my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HSP' =E<gt> \\&hsp_filter }  \n      );\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n\nThis module will use the module Text::Wrap if it is installed to wrap\nthe Query description line.  If you do not have Text::Wrap installed\nthis module will work fine but you won't have the Query line wrapped.\nYou will see a warning about this when you first instantiate a\nTextResultWriter - to avoid these warnings from showing up, simply set\nthe verbosity upon initialization to -1 like this: my $writer = new\nBio::SearchIO::Writer::TextResultWriter(-verbose =E<gt> -1);\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::TextResultWriter;\nuse vars qw($MaxNameLen $MaxDescLen $AlignmentLineWidth \t    $DescLineLen $TextWrapLoaded);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $MaxDescLen = 65;\n    $AlignmentLineWidth = 60;    \n    eval { require Text::Wrap; $TextWrapLoaded = 1;};\n    if( $@ ) {\n\t$TextWrapLoaded = 0;\n    }\n}\n\nuse POSIX;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::TextResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::TextResultWriter object \n Returns : Bio::SearchIO::Writer::TextResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a Hit,HSP, Result object respectively\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines even if \n                               they are parsed out\n                               Links = (1) ","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":176},"start":{"line":161,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","line":164,"kind":12},{"line":177,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":177,"containerName":"main::","name":"no_wublastlinks"},{"kind":13,"line":177,"name":"$nowublastlinks","containerName":null},{"name":"%TextWrapLoaded","containerName":null,"kind":13,"line":178},{"name":"$self","containerName":null,"line":179,"kind":13},{"name":"warn","containerName":"main::","line":179,"kind":12},{"name":"$Text","containerName":null,"line":181,"kind":13},{"containerName":"columns","name":"Wrap","kind":12,"line":181},{"name":"$MaxDescLen","containerName":null,"kind":13,"line":181},{"line":183,"kind":13,"containerName":null,"name":"$self"},{"range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":202}},"name":"to_string","detail":"($self,$result,$num)","signature":{"label":"to_string($self,$result,$num)","documentation":"1;\n# $Id: TextResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::TextResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::TextResultWriter - Object to implement writing\na Bio::Search::ResultI in Text.\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::TextResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of Text for a specific Bio::Search::Report::ReportI interface.\n\nYou can also provide the argument -filters =E<gt> \\%hash to filter the at\nthe hsp, hit, or result level.  %hash is an associative array which\ncontains any or all of the keys (HSP, HIT, RESULT).  The values\npointed to by these keys would be references to a subroutine which\nexpects to be passed an object - one of Bio::Search::HSP::HSPI,\nBio::Search::Hit::HitI, and Bio::Search::Result::ResultI respectively.\nEach function needs to return a boolean value as to whether or not the\npassed element should be included in the output report - true if it is\nto be included, false if it to be omitted.\n\nFor example to filter on sequences in the database which are too short\nfor your criteria you would do the following.\n\nDefine a hit filter method \n\n  sub hit_filter { \n      my $hit = shift;\n      return $hit->length E<gt> 100; # test if length of the hit sequence\n                                     # long enough    \n  }\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HIT' =E<gt> \\&hit_filter }  \n      );\n\nAnother example would be to filter HSPs on percent identity, let's\nonly include HSPs which are 75% identical or better.\n\n   sub hsp_filter {\n       my $hsp = shift;\n       return $hsp->percent_identity E<gt> 75;\n   }\n   my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HSP' =E<gt> \\&hsp_filter }  \n      );\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n\nThis module will use the module Text::Wrap if it is installed to wrap\nthe Query description line.  If you do not have Text::Wrap installed\nthis module will work fine but you won't have the Query line wrapped.\nYou will see a warning about this when you first instantiate a\nTextResultWriter - to avoid these warnings from showing up, simply set\nthe verbosity upon initialization to -1 like this: my $writer = new\nBio::SearchIO::Writer::TextResultWriter(-verbose =E<gt> -1);\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::TextResultWriter;\nuse vars qw($MaxNameLen $MaxDescLen $AlignmentLineWidth \t    $DescLineLen $TextWrapLoaded);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $MaxDescLen = 65;\n    $AlignmentLineWidth = 60;    \n    eval { require Text::Wrap; $TextWrapLoaded = 1;};\n    if( $@ ) {\n\t$TextWrapLoaded = 0;\n    }\n}\n\nuse POSIX;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::TextResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::TextResultWriter object \n Returns : Bio::SearchIO::Writer::TextResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a Hit,HSP, Result object respectively\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines even if \n                               they are parsed out\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($filters,$nowublastlinks) = $self->_rearrange([qw(FILTERS \n\t\t\t\t\t\t\tNO_WUBLASTLINKS)],\n\t\t\t\t\t\t    @args);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n  $self->no_wublastlinks(! $nowublastlinks);\n  unless( $TextWrapLoaded ) {\n      $self->warn(\"Could not load Text::Wrap - the Query Description will not be line wrapped\\n\");\n  } else { \n      $Text::Wrap::columns =  $MaxDescLen;\n  }\n  return $self;\n}\n\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}]},"containerName":"main::","definition":"sub","line":202,"children":[{"localvar":"my","containerName":"to_string","name":"$self","definition":"my","line":203,"kind":13},{"line":203,"kind":13,"containerName":"to_string","name":"$result"},{"containerName":"to_string","name":"$num","kind":13,"line":203},{"name":"$num","containerName":"to_string","line":204,"kind":13},{"kind":13,"line":205,"containerName":"to_string","name":"$result"},{"kind":13,"line":206,"definition":"my","name":"$links","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"$self","line":206,"kind":13},{"kind":12,"line":206,"name":"no_wublastlinks","containerName":"to_string"},{"line":207,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$resultfilter"},{"kind":13,"line":207,"containerName":"to_string","name":"$hitfilter"},{"kind":13,"line":207,"containerName":"to_string","name":"$hspfilter"},{"containerName":"to_string","name":"$self","kind":13,"line":207},{"kind":12,"line":207,"name":"filter","containerName":"to_string"},{"line":208,"kind":13,"name":"$self","containerName":"to_string"},{"line":208,"kind":12,"containerName":"to_string","name":"filter"},{"name":"$self","containerName":"to_string","kind":13,"line":209},{"kind":12,"line":209,"containerName":"to_string","name":"filter"},{"name":"$resultfilter","containerName":"to_string","line":210,"kind":13},{"containerName":"to_string","name":"$resultfilter","kind":13,"line":210}],"kind":12},{"containerName":null,"name":"$result","line":210,"kind":13},{"name":"$qtype","definition":"my","containerName":null,"localvar":"my","kind":13,"line":212},{"kind":13,"line":212,"containerName":null,"name":"$dbtype"},{"kind":13,"line":212,"containerName":null,"name":"$dbseqtype"},{"name":"$type","containerName":null,"kind":13,"line":212},{"line":213,"kind":13,"localvar":"my","definition":"my","name":"$alg","containerName":null},{"kind":13,"line":213,"containerName":null,"name":"$result"},{"line":213,"kind":12,"name":"algorithm","containerName":"main::"},{"name":"$wublast","definition":"my","containerName":null,"localvar":"my","kind":13,"line":215},{"kind":13,"line":215,"containerName":null,"name":"$result"},{"line":215,"kind":12,"containerName":"main::","name":"algorithm_version"},{"containerName":null,"name":"%alg","line":218,"kind":13},{"containerName":null,"name":"$qtype","line":219,"kind":13},{"line":219,"kind":13,"name":"$dbtype","containerName":null},{"containerName":null,"name":"$dbseqtype","line":220,"kind":13},{"line":220,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"line":221,"name":"%alg","containerName":null},{"line":222,"kind":13,"containerName":null,"name":"$qtype"},{"name":"$dbtype","containerName":null,"line":223,"kind":13},{"containerName":null,"name":"$type","kind":13,"line":224},{"name":"$dbseqtype","containerName":null,"line":225,"kind":13},{"kind":13,"line":226,"name":"$alg","containerName":null},{"kind":13,"line":227,"name":"%alg","containerName":null},{"containerName":null,"name":"$qtype","kind":13,"line":228},{"line":228,"kind":13,"name":"$dbtype","containerName":null},{"line":229,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"name":"$dbseqtype","line":229,"kind":13},{"line":230,"kind":13,"containerName":null,"name":"$alg"},{"kind":13,"line":231,"containerName":null,"name":"%alg"},{"kind":13,"line":232,"name":"$qtype","containerName":null},{"name":"$dbtype","containerName":null,"kind":13,"line":232},{"line":233,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"name":"$dbseqtype","kind":13,"line":233},{"containerName":null,"name":"%alg","line":234,"kind":13},{"name":"$qtype","containerName":null,"kind":13,"line":235},{"line":236,"kind":13,"name":"$dbtype","containerName":null},{"name":"$dbseqtype","containerName":null,"line":237,"kind":13},{"name":"%type","containerName":null,"line":237,"kind":13},{"containerName":null,"name":"$result","kind":13,"line":239},{"line":239,"kind":12,"name":"algorithm","containerName":"main::"},{"line":243,"kind":13,"localvar":"my","definition":"my","name":"%baselens","containerName":null},{"containerName":null,"name":"$dbtype","kind":13,"line":243},{"name":"$qtype","containerName":null,"line":244,"kind":13},{"kind":13,"line":246,"containerName":null,"definition":"my","name":"$str","localvar":"my"},{"kind":13,"line":247,"containerName":null,"name":"$num"},{"name":"%num","containerName":null,"kind":13,"line":247},{"line":248,"kind":13,"name":"$str","containerName":null},{"kind":13,"line":248,"name":"$self","containerName":null},{"name":"start_report","containerName":"main::","kind":12,"line":248},{"kind":13,"line":248,"name":"$result","containerName":null},{"name":"$str","containerName":null,"kind":13,"line":251},{"containerName":null,"name":"$self","kind":13,"line":251},{"kind":12,"line":251,"containerName":"main::","name":"title"},{"kind":13,"line":251,"containerName":null,"name":"$result"},{"line":253,"kind":13,"name":"$str","containerName":null},{"line":253,"kind":13,"name":"$result","containerName":null},{"containerName":"main::","name":"algorithm_reference","kind":12,"line":253},{"name":"$self","containerName":null,"line":253,"kind":13},{"line":253,"kind":12,"name":"algorithm_reference","containerName":"main::"},{"line":253,"kind":13,"name":"$result","containerName":null},{"name":"$str","containerName":null,"kind":13,"line":254},{"kind":13,"line":254,"name":"$self","containerName":null},{"line":254,"kind":12,"name":"introduction","containerName":"main::"},{"name":"$result","containerName":null,"kind":13,"line":254},{"line":257,"kind":13,"name":"$str","containerName":null},{"kind":13,"line":262,"name":"$hspstr","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$result","kind":13,"line":263},{"line":263,"kind":12,"containerName":"main::","name":"can"},{"containerName":null,"name":"$result","kind":13,"line":264},{"name":"rewind","containerName":"main::","kind":12,"line":264},{"kind":13,"line":266,"containerName":null,"name":"$hit","definition":"my","localvar":"my"},{"name":"$result","containerName":null,"line":266,"kind":13},{"line":266,"kind":12,"name":"next_hit","containerName":"main::"},{"name":"$hitfilter","containerName":null,"line":267,"kind":13},{"containerName":null,"name":"$hitfilter","line":267,"kind":13},{"line":267,"kind":13,"name":"$hit","containerName":null},{"localvar":"my","containerName":null,"name":"$nm","definition":"my","line":268,"kind":13},{"line":268,"kind":13,"name":"$hit","containerName":null},{"containerName":"main::","name":"name","line":268,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":269},{"line":269,"kind":12,"name":"debug","containerName":"main::"},{"line":269,"kind":13,"name":"$hit","containerName":null},{"containerName":"main::","name":"description","line":269,"kind":12},{"containerName":null,"name":"$nm","kind":13,"line":270},{"kind":13,"line":271,"containerName":null,"definition":"my","name":"$gi","localvar":"my"},{"kind":13,"line":271,"name":"$acc","containerName":null},{"line":271,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"id_parser","kind":12,"line":271},{"name":"$nm","containerName":null,"line":271,"kind":13},{"containerName":null,"name":"$p","definition":"my","localvar":"my","kind":13,"line":272},{"localvar":"my","containerName":null,"definition":"my","name":"$descsub","line":273,"kind":13},{"kind":13,"line":274,"definition":"my","name":"$desc","containerName":null,"localvar":"my"},{"name":"$nm","containerName":null,"kind":13,"line":274},{"containerName":null,"name":"$hit","kind":13,"line":274},{"line":274,"kind":12,"name":"description","containerName":"main::"},{"name":"$desc","containerName":null,"line":275,"kind":13},{"containerName":null,"name":"%MaxDescLen","kind":13,"line":275},{"kind":13,"line":276,"containerName":null,"name":"$descsub"},{"kind":13,"line":276,"name":"$p","containerName":null},{"kind":13,"line":277,"name":"$desc","containerName":null},{"name":"%MaxDescLen","containerName":null,"kind":13,"line":277},{"containerName":null,"name":"$descsub","kind":13,"line":280},{"kind":13,"line":280,"containerName":null,"name":"$p"},{"kind":13,"line":280,"containerName":null,"name":"$desc"},{"line":282,"kind":13,"containerName":null,"name":"$str"},{"line":282,"kind":13,"name":"$wublast","containerName":null},{"containerName":null,"name":"$descsub","kind":13,"line":283},{"line":284,"kind":13,"name":"$hit","containerName":null},{"line":284,"kind":12,"name":"raw_score","containerName":"main::"},{"kind":13,"line":284,"name":"$hit","containerName":null},{"line":284,"kind":12,"name":"raw_score","containerName":"main::"},{"containerName":null,"name":"$hit","line":285,"kind":13},{"name":"significance","containerName":"main::","kind":12,"line":285},{"kind":13,"line":285,"name":"$hit","containerName":null},{"containerName":"main::","name":"significance","line":285,"kind":12},{"containerName":null,"name":"$descsub","kind":13,"line":287},{"kind":13,"line":288,"name":"$hit","containerName":null},{"name":"bits","containerName":"main::","kind":12,"line":288},{"containerName":null,"name":"$hit","kind":13,"line":288},{"line":288,"kind":12,"containerName":"main::","name":"bits"},{"containerName":null,"name":"$hit","line":289,"kind":13},{"name":"significance","containerName":"main::","line":289,"kind":12},{"kind":13,"line":289,"name":"$hit","containerName":null},{"line":289,"kind":12,"name":"significance","containerName":"main::"},{"definition":"my","name":"@hsps","containerName":null,"localvar":"my","kind":13,"line":290},{"kind":13,"line":290,"containerName":null,"name":"$hit"},{"containerName":"main::","name":"hsps","kind":12,"line":290},{"name":"@hsps","containerName":null,"line":291,"kind":13},{"containerName":null,"name":"$hspstr","kind":13,"line":292},{"line":293,"kind":13,"name":"$hit","containerName":null},{"name":"name","containerName":"main::","kind":12,"line":293},{"name":"$hit","containerName":null,"kind":13,"line":294},{"line":294,"kind":12,"name":"description","containerName":"main::"},{"containerName":null,"name":"$hit","kind":13,"line":294},{"kind":12,"line":294,"name":"description","containerName":"main::"},{"containerName":null,"name":"$hit","line":296,"kind":13},{"containerName":"main::","name":"length","kind":12,"line":296},{"containerName":null,"name":"$hsp","definition":"my","localvar":"my","kind":13,"line":298},{"kind":13,"line":298,"name":"@hsps","containerName":null},{"containerName":null,"name":"$hspfilter","kind":13,"line":299},{"name":"$hspfilter","containerName":null,"line":299,"kind":13},{"kind":13,"line":299,"name":"$hsp","containerName":null},{"containerName":null,"name":"$hspstr","line":300,"kind":13},{"name":"$hsp","containerName":null,"kind":13,"line":301},{"kind":12,"line":301,"name":"bits","containerName":"main::"},{"line":301,"kind":13,"containerName":null,"name":"$hsp"},{"name":"score","containerName":"main::","kind":12,"line":301},{"containerName":null,"name":"$hsp","line":301,"kind":13},{"name":"evalue","containerName":"main::","kind":12,"line":301},{"line":302,"kind":13,"containerName":null,"name":"$hsp"},{"line":302,"kind":12,"name":"pvalue","containerName":"main::"},{"kind":13,"line":303,"containerName":null,"name":"$hspstr"},{"containerName":null,"name":"$hsp","kind":13,"line":303},{"name":"pvalue","containerName":"main::","kind":12,"line":303},{"containerName":null,"name":"$hspstr","line":305,"kind":13},{"kind":13,"line":306,"containerName":null,"name":"$hspstr"},{"name":"$hsp","containerName":null,"kind":13,"line":307},{"containerName":"main::","name":"frac_identical","line":307,"kind":12},{"kind":13,"line":308,"containerName":null,"name":"$hsp"},{"name":"length","containerName":"main::","kind":12,"line":308},{"containerName":null,"name":"$hsp","line":309,"kind":13},{"kind":12,"line":309,"name":"length","containerName":"main::"},{"containerName":"floor","name":"POSIX","kind":12,"line":310},{"line":310,"kind":13,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"frac_identical","line":310,"kind":12},{"kind":13,"line":313,"containerName":null,"name":"%type"},{"name":"$hspstr","containerName":null,"line":314,"kind":13},{"name":"$hsp","containerName":null,"line":315,"kind":13},{"line":315,"kind":12,"containerName":"main::","name":"frac_conserved"},{"name":"$hsp","containerName":null,"kind":13,"line":316},{"line":316,"kind":12,"name":"length","containerName":"main::"},{"name":"$hsp","containerName":null,"kind":13,"line":317},{"containerName":"main::","name":"length","line":317,"kind":12},{"line":318,"kind":12,"containerName":"floor","name":"POSIX"},{"containerName":null,"name":"$hsp","kind":13,"line":318},{"kind":12,"line":318,"name":"frac_conserved","containerName":"main::"},{"line":321,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":321,"containerName":"main::","name":"gaps"},{"kind":13,"line":322,"name":"$hspstr","containerName":null},{"line":323,"kind":13,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"gaps","kind":12,"line":323},{"kind":13,"line":324,"name":"$hsp","containerName":null},{"line":324,"kind":12,"containerName":"main::","name":"length"},{"name":"POSIX","containerName":"floor","kind":12,"line":325},{"kind":13,"line":325,"name":"$hsp","containerName":null},{"name":"gaps","containerName":"main::","kind":12,"line":325},{"containerName":null,"name":"$hsp","line":326,"kind":13},{"kind":12,"line":326,"name":"length","containerName":"main::"},{"kind":13,"line":328,"name":"$hspstr","containerName":null},{"kind":13,"line":329,"containerName":null,"name":"$hframe","definition":"my","localvar":"my"},{"line":329,"kind":13,"containerName":null,"name":"$qframe"},{"name":"$hsp","containerName":null,"kind":13,"line":329},{"line":329,"kind":12,"name":"hit","containerName":"main::"},{"line":329,"kind":12,"containerName":"main::","name":"frame"},{"containerName":null,"name":"$hsp","kind":13,"line":330},{"containerName":"main::","name":"query","kind":12,"line":330},{"name":"frame","containerName":"main::","line":330,"kind":12},{"kind":13,"line":331,"containerName":null,"name":"$hstrand","definition":"my","localvar":"my"},{"name":"$qstrand","containerName":null,"kind":13,"line":331},{"containerName":null,"name":"$hsp","line":331,"kind":13},{"name":"hit","containerName":"main::","kind":12,"line":331},{"containerName":"main::","name":"strand","kind":12,"line":331},{"containerName":null,"name":"$hsp","kind":13,"line":331},{"containerName":"main::","name":"query","kind":12,"line":331},{"containerName":"main::","name":"strand","kind":12,"line":331},{"kind":13,"line":335,"containerName":null,"name":"$hstrand"},{"kind":13,"line":335,"name":"%qstrand","containerName":null},{"name":"$hspstr","containerName":null,"kind":13,"line":336},{"line":337,"kind":13,"localvar":"my","name":"$signq","definition":"my","containerName":null},{"kind":13,"line":337,"containerName":null,"name":"$signh"},{"kind":13,"line":338,"name":"%hstrand","containerName":null},{"line":339,"kind":13,"name":"%hframe","containerName":null},{"name":"$signh","containerName":null,"line":343,"kind":13},{"line":343,"kind":13,"name":"$hstrand","containerName":null},{"containerName":null,"name":"%qstrand","line":345,"kind":13},{"kind":13,"line":346,"containerName":null,"name":"%qframe"},{"line":349,"kind":13,"containerName":null,"name":"$signq"},{"containerName":null,"name":"$qstrand","line":349,"kind":13},{"name":"$hframe","containerName":null,"line":354,"kind":13},{"containerName":null,"name":"%qframe","line":354,"kind":13},{"line":355,"kind":13,"containerName":null,"name":"$hspstr"},{"containerName":null,"name":"$hframe","kind":13,"line":355},{"line":356,"kind":13,"name":"$qframe","containerName":null},{"line":356,"kind":13,"containerName":null,"name":"%hframe"},{"kind":13,"line":357,"name":"$hspstr","containerName":null},{"containerName":null,"name":"%qframe","kind":13,"line":357},{"kind":13,"line":359,"containerName":null,"name":"$hspstr"},{"kind":13,"line":360,"name":"$signq","containerName":null},{"kind":13,"line":360,"name":"$qframe","containerName":null},{"kind":13,"line":361,"containerName":null,"name":"$signh"},{"kind":13,"line":361,"containerName":null,"name":"$hframe"},{"line":365,"kind":13,"name":"$links","containerName":null},{"kind":13,"line":366,"containerName":null,"name":"$hsp"},{"kind":12,"line":366,"containerName":"main::","name":"can"},{"containerName":null,"name":"$lnks","definition":"my","localvar":"my","kind":13,"line":366},{"name":"$hsp","containerName":null,"kind":13,"line":366},{"name":"links","containerName":"main::","line":366,"kind":12},{"kind":13,"line":367,"containerName":null,"name":"$hspstr"},{"name":"$lnks","containerName":null,"kind":13,"line":367},{"containerName":null,"name":"$hspstr","kind":13,"line":369},{"containerName":null,"definition":"my","name":"@hspvals","localvar":"my","kind":13,"line":371},{"line":372,"kind":13,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"query_string","line":372,"kind":12},{"line":373,"kind":13,"containerName":null,"name":"$qstrand"},{"kind":13,"line":374,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","kind":12,"line":374},{"kind":12,"line":374,"containerName":"main::","name":"start"},{"name":"$hsp","containerName":null,"line":375,"kind":13},{"name":"query","containerName":"main::","line":375,"kind":12},{"containerName":"main::","name":"end","kind":12,"line":375},{"name":"$qstrand","containerName":null,"line":376,"kind":13},{"kind":13,"line":377,"containerName":null,"name":"$hsp"},{"kind":12,"line":377,"containerName":"main::","name":"query"},{"line":377,"kind":12,"name":"end","containerName":"main::"},{"line":378,"kind":13,"name":"$hsp","containerName":null},{"kind":12,"line":378,"name":"query","containerName":"main::"},{"containerName":"main::","name":"start","kind":12,"line":378},{"kind":13,"line":380,"containerName":null,"name":"%qstrand"},{"line":382,"kind":12,"name":"x6"},{"line":383,"kind":13,"name":"$hsp","containerName":null},{"containerName":"main::","name":"homology_string","kind":12,"line":383},{"containerName":null,"name":"$hsp","line":390,"kind":13},{"containerName":"main::","name":"hit_string","kind":12,"line":390},{"containerName":null,"name":"$hstrand","line":391,"kind":13},{"line":392,"kind":13,"containerName":null,"name":"$hsp"},{"line":392,"kind":12,"name":"hit","containerName":"main::"},{"name":"start","containerName":"main::","kind":12,"line":392},{"kind":13,"line":392,"containerName":null,"name":"$hsp"},{"line":392,"kind":12,"containerName":"main::","name":"hit"},{"containerName":"main::","name":"end","kind":12,"line":392},{"line":393,"kind":13,"containerName":null,"name":"$hstrand"},{"name":"$hsp","containerName":null,"kind":13,"line":394},{"name":"hit","containerName":"main::","line":394,"kind":12},{"kind":12,"line":394,"containerName":"main::","name":"end"},{"containerName":null,"name":"$hsp","kind":13,"line":394},{"name":"hit","containerName":"main::","kind":12,"line":394},{"containerName":"main::","name":"start","line":394,"kind":12},{"containerName":null,"name":"$hstrand","kind":13,"line":396},{"definition":"my","name":"%numwidth","containerName":null,"localvar":"my","kind":13,"line":405},{"line":405,"kind":13,"name":"$b","containerName":null},{"name":"$a","containerName":null,"line":405,"kind":13},{"kind":13,"line":405,"containerName":null,"name":"@hspvals"},{"name":"@hspvals","containerName":null,"line":406,"kind":13},{"name":"@hspvals","containerName":null,"kind":13,"line":407},{"line":408,"kind":13,"name":"@hspvals","containerName":null},{"kind":13,"line":409,"name":"$count","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":410,"name":"$count","containerName":null},{"name":"$hsp","containerName":null,"kind":13,"line":410},{"name":"length","containerName":"main::","line":410,"kind":12},{"kind":13,"line":411,"name":"$v","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":411,"containerName":null,"name":"@hspvals"},{"kind":13,"line":412,"name":"$piece","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%v","line":412,"kind":13},{"name":"%v","containerName":null,"kind":13,"line":412},{"name":"$count","containerName":null,"kind":13,"line":412},{"containerName":null,"name":"$AlignmentLineWidth","kind":13,"line":413},{"containerName":null,"name":"$cp","definition":"my","localvar":"my","kind":13,"line":414},{"kind":13,"line":414,"containerName":null,"name":"$piece"},{"localvar":"my","name":"$plen","definition":"my","containerName":null,"line":415,"kind":13},{"line":415,"kind":13,"name":"$cp","containerName":null},{"line":416,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$start"},{"kind":13,"line":416,"containerName":null,"name":"$end"},{"kind":13,"line":417,"containerName":null,"name":"%v"},{"name":"$start","containerName":null,"line":418,"kind":13},{"line":418,"kind":13,"containerName":null,"name":"%v"},{"kind":13,"line":421,"definition":"my","name":"$d","containerName":null,"localvar":"my"},{"kind":13,"line":421,"name":"%v","containerName":null},{"containerName":null,"name":"$AlignmentLineWidth","kind":13,"line":421},{"containerName":null,"name":"$plen","line":421,"kind":13},{"kind":13,"line":422,"containerName":null,"name":"%baselens"},{"name":"%v","containerName":null,"kind":13,"line":422},{"containerName":null,"name":"$piece","line":423,"kind":13},{"name":"%AlignmentLineWidth","containerName":null,"line":423,"kind":13},{"name":"$d","containerName":null,"kind":13,"line":424},{"name":"$piece","containerName":null,"line":424,"kind":13},{"name":"$plen","containerName":null,"kind":13,"line":424},{"line":424,"kind":13,"name":"%v","containerName":null},{"line":425,"kind":13,"name":"%baselens","containerName":null},{"containerName":null,"name":"%v","kind":13,"line":425},{"containerName":null,"name":"$end","kind":13,"line":427},{"kind":13,"line":427,"containerName":null,"name":"%v"},{"name":"$d","containerName":null,"line":427,"kind":13},{"name":"%v","containerName":null,"line":427,"kind":13},{"line":428,"kind":13,"containerName":null,"name":"%v"},{"line":428,"kind":13,"name":"$d","containerName":null},{"containerName":null,"name":"$hspstr","line":430,"kind":13},{"line":430,"kind":13,"name":"$numwidth","containerName":null},{"kind":13,"line":431,"name":"%v","containerName":null},{"kind":13,"line":432,"name":"$start","containerName":null},{"kind":13,"line":433,"name":"$piece","containerName":null},{"containerName":null,"name":"$end","line":435,"kind":13},{"name":"$count","containerName":null,"line":437,"kind":13},{"kind":13,"line":437,"containerName":null,"name":"$AlignmentLineWidth"},{"containerName":null,"name":"$hspstr","line":438,"kind":13},{"name":"$hspstr","containerName":null,"line":441,"kind":13},{"name":"$str","containerName":null,"kind":13,"line":444},{"line":444,"kind":13,"containerName":null,"name":"$hspstr"},{"kind":13,"line":446,"containerName":null,"name":"$str"},{"containerName":null,"name":"$result","line":453,"kind":13},{"containerName":"main::","name":"database_name","line":453,"kind":12},{"line":454,"kind":13,"containerName":null,"name":"$result"},{"containerName":"main::","name":"get_statistic","line":454,"kind":12},{"containerName":"strftime","name":"POSIX","kind":12,"line":455},{"kind":12,"line":456,"name":"_numwithcommas"},{"containerName":null,"name":"$result","line":456,"kind":13},{"kind":12,"line":456,"containerName":"main::","name":"database_letters"},{"kind":12,"line":457,"name":"_numwithcommas"},{"kind":13,"line":457,"name":"$result","containerName":null},{"containerName":"main::","name":"database_entries","kind":12,"line":457},{"kind":13,"line":458,"name":"$result","containerName":null},{"kind":12,"line":458,"name":"get_parameter","containerName":"main::"},{"line":460,"kind":13,"localvar":"my","name":"$open","definition":"my","containerName":null},{"name":"$result","containerName":null,"line":460,"kind":13},{"line":460,"kind":12,"containerName":"main::","name":"get_parameter"},{"line":461,"kind":13,"containerName":null,"name":"$str"},{"name":"$open","containerName":null,"kind":13,"line":462},{"containerName":null,"name":"$result","kind":13,"line":462},{"kind":12,"line":462,"containerName":"main::","name":"get_parameter"},{"localvar":"my","containerName":null,"definition":"my","name":"%param","line":466,"kind":13},{"name":"$result","containerName":null,"line":467,"kind":13},{"containerName":"main::","name":"available_parameters","line":467,"kind":12},{"name":"$str","containerName":null,"kind":13,"line":468},{"containerName":null,"name":"$result","kind":13,"line":468},{"name":"get_parameter","containerName":"main::","line":468,"kind":12},{"kind":13,"line":468,"name":"$param","containerName":null},{"containerName":null,"name":"$str","line":471,"kind":13},{"line":473,"kind":13,"localvar":"my","name":"%stat","definition":"my","containerName":null},{"containerName":null,"name":"$result","line":474,"kind":13},{"kind":12,"line":474,"containerName":"main::","name":"available_statistics"},{"kind":13,"line":475,"name":"$expect","definition":"my","containerName":null,"localvar":"my"},{"line":475,"kind":13,"name":"$result","containerName":null},{"containerName":"main::","name":"get_parameter","kind":12,"line":475},{"kind":13,"line":476,"name":"$v","definition":"my","containerName":null,"localvar":"my"},{"name":"$result","containerName":null,"kind":13,"line":476},{"kind":12,"line":476,"name":"get_statistic","containerName":"main::"},{"kind":13,"line":476,"name":"$stat","containerName":null},{"name":"%v","containerName":null,"line":477,"kind":13},{"name":"$v","containerName":null,"line":478,"kind":13},{"name":"_numwithcommas","line":478,"kind":12},{"line":478,"kind":13,"containerName":null,"name":"$v"},{"name":"$expect","containerName":null,"kind":13,"line":480},{"containerName":null,"name":"%stat","kind":13,"line":481},{"kind":13,"line":482,"name":"%str","containerName":null},{"line":484,"kind":13,"localvar":"my","definition":"my","name":"$v","containerName":null},{"containerName":null,"name":"$str","kind":13,"line":485},{"kind":13,"line":488,"containerName":null,"name":"$str"},{"containerName":null,"name":"$str","line":489,"kind":13},{"name":"start_report","range":{"end":{"line":518,"character":9999},"start":{"character":0,"line":512}},"kind":12,"line":512,"children":[{"kind":13,"line":513,"containerName":"start_report","name":"$self","definition":"my","localvar":"my"},{"name":"$code","containerName":"start_report","kind":13,"line":513},{"containerName":"start_report","name":"$code","kind":13,"line":514},{"name":"$self","containerName":"start_report","kind":13,"line":515},{"kind":13,"line":515,"name":"$code","containerName":"start_report"},{"line":517,"kind":13,"name":"$self","containerName":"start_report"}],"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"label":"start_report($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":""}},{"name":"default_start_report","kind":12,"line":517},{"signature":{"parameters":[{"label":"$result"}],"documentation":"","label":"default_start_report($result)"},"detail":"($result)","definition":"sub","containerName":"main::","children":[{"line":531,"kind":13,"localvar":"my","definition":"my","name":"$result","containerName":"default_start_report"}],"line":530,"kind":12,"range":{"start":{"character":0,"line":530},"end":{"character":9999,"line":533}},"name":"default_start_report"},{"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"","label":"title($self,$code)"},"kind":12,"line":552,"children":[{"kind":13,"line":553,"containerName":"title","name":"$self","definition":"my","localvar":"my"},{"name":"$code","containerName":"title","line":553,"kind":13},{"line":554,"kind":13,"containerName":"title","name":"$code"},{"line":555,"kind":13,"containerName":"title","name":"$self"},{"containerName":"title","name":"$code","line":555,"kind":13},{"kind":13,"line":557,"containerName":"title","name":"$self"}],"name":"title","range":{"end":{"character":9999,"line":558},"start":{"line":552,"character":0}}},{"kind":12,"line":557,"name":"default_title"},{"name":"default_title","range":{"end":{"character":9999,"line":579},"start":{"character":0,"line":571}},"definition":"sub","containerName":"main::","signature":{"label":"default_title($result)","documentation":"","parameters":[{"label":"$result"}]},"detail":"($result)","kind":12,"children":[{"containerName":"default_title","name":"$result","definition":"my","localvar":"my","kind":13,"line":572}],"line":571},{"name":"introduction","range":{"end":{"character":9999,"line":606},"start":{"character":0,"line":600}},"kind":12,"children":[{"kind":13,"line":601,"containerName":"introduction","name":"$self","definition":"my","localvar":"my"},{"containerName":"introduction","name":"$code","line":601,"kind":13},{"name":"$code","containerName":"introduction","line":602,"kind":13},{"line":603,"kind":13,"name":"$self","containerName":"introduction"},{"containerName":"introduction","name":"$code","kind":13,"line":603},{"name":"$self","containerName":"introduction","kind":13,"line":605}],"line":600,"definition":"sub","containerName":"main::","signature":{"label":"introduction($self,$code)","documentation":"","parameters":[{"label":"$self"},{"label":"$code"}]},"detail":"($self,$code)"},{"name":"default_introduction","line":605,"kind":12},{"detail":"($result)","signature":{"documentation":"","parameters":[{"label":"$result"}],"label":"default_introduction($result)"},"containerName":"main::","definition":"sub","line":620,"children":[{"name":"$result","definition":"my","containerName":"default_introduction","localvar":"my","kind":13,"line":621},{"containerName":"default_introduction","name":"$result","line":632,"kind":13},{"kind":12,"line":632,"name":"query_name","containerName":"default_introduction"},{"line":633,"kind":13,"containerName":"default_introduction","name":"$result"},{"kind":12,"line":633,"containerName":"default_introduction","name":"query_description"},{"kind":13,"line":634,"name":"$result","containerName":"default_introduction"},{"line":634,"kind":12,"containerName":"default_introduction","name":"query_length"},{"containerName":"default_introduction","name":"$result","kind":13,"line":635},{"containerName":"default_introduction","name":"database_name","kind":12,"line":635},{"name":"$result","containerName":"default_introduction","kind":13,"line":636},{"kind":12,"line":636,"containerName":"default_introduction","name":"database_entries"},{"containerName":"default_introduction","name":"$result","line":637,"kind":13},{"containerName":"default_introduction","name":"database_letters","kind":12,"line":637}],"kind":12,"range":{"start":{"character":0,"line":620},"end":{"character":9999,"line":639}},"name":"default_introduction"},{"kind":12,"line":632,"name":"_linewrap"},{"kind":12,"line":634,"name":"_numwithcommas"},{"line":636,"kind":12,"name":"_numwithcommas"},{"kind":12,"line":637,"name":"_numwithcommas"},{"line":654,"children":[],"kind":12,"range":{"start":{"line":654,"character":0},"end":{"line":656,"character":9999}},"containerName":"main::","definition":"sub","name":"end_report"},{"name":"id_parser","range":{"start":{"character":0,"line":681},"end":{"line":688,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"},"detail":"($self,$code)","kind":12,"children":[{"line":682,"kind":13,"localvar":"my","containerName":"id_parser","name":"$self","definition":"my"},{"name":"$code","containerName":"id_parser","line":682,"kind":13},{"containerName":"id_parser","name":"$code","kind":13,"line":684},{"containerName":"id_parser","name":"$self","kind":13,"line":685},{"containerName":"id_parser","name":"$code","kind":13,"line":685},{"name":"$self","containerName":"id_parser","line":687,"kind":13}],"line":681},{"kind":12,"line":687,"name":"default_id_parser"},{"name":"default_id_parser","range":{"end":{"line":718,"character":9999},"start":{"character":0,"line":704}},"containerName":"main::","definition":"sub","detail":"($string)","signature":{"documentation":"","parameters":[{"label":"$string"}],"label":"default_id_parser($string)"},"kind":12,"line":704,"children":[{"kind":13,"line":705,"definition":"my","name":"$string","containerName":"default_id_parser","localvar":"my"},{"containerName":"default_id_parser","definition":"my","name":"$gi","localvar":"my","kind":13,"line":706},{"line":706,"kind":13,"containerName":"default_id_parser","name":"$acc"},{"line":707,"kind":13,"name":"$string","containerName":"default_id_parser"},{"kind":13,"line":708,"name":"$gi","containerName":"default_id_parser"},{"name":"$acc","containerName":"default_id_parser","line":708,"kind":13},{"containerName":"default_id_parser","name":"$string","line":710,"kind":13},{"line":711,"kind":13,"name":"$acc","containerName":"default_id_parser"},{"name":"$acc","containerName":"default_id_parser","kind":13,"line":713},{"name":"$string","containerName":"default_id_parser","kind":13,"line":713},{"kind":13,"line":714,"containerName":"default_id_parser","name":"$acc"},{"line":715,"kind":13,"name":"$acc","containerName":"default_id_parser"},{"containerName":"default_id_parser","name":"$gi","kind":13,"line":717},{"kind":13,"line":717,"name":"$acc","containerName":"default_id_parser"}]},{"children":[{"containerName":"MIN","name":"$a","kind":13,"line":720},{"line":720,"kind":13,"name":"$b","containerName":"MIN"},{"line":720,"kind":13,"containerName":"MIN","name":"$a"},{"name":"$b","containerName":"MIN","kind":13,"line":720}],"line":720,"kind":12,"range":{"end":{"line":720,"character":9999},"start":{"character":0,"line":720}},"name":"MIN","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"MAX","definition":"sub","range":{"start":{"character":0,"line":721},"end":{"line":721,"character":9999}},"kind":12,"line":721,"children":[{"name":"$a","containerName":"MAX","kind":13,"line":721},{"containerName":"MAX","name":"$b","kind":13,"line":721},{"line":721,"kind":13,"containerName":"MAX","name":"$b"},{"containerName":"MAX","name":"$a","kind":13,"line":721}]},{"range":{"end":{"line":765,"character":9999},"start":{"character":0,"line":736}},"name":"algorithm_reference","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$result"}],"label":"algorithm_reference($self,$result)"},"detail":"($self,$result)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":737,"definition":"my","name":"$self","containerName":"algorithm_reference","localvar":"my"},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":737},{"containerName":"algorithm_reference","name":"$result","kind":13,"line":738},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":738},{"containerName":"algorithm_reference","name":"$result","kind":13,"line":739},{"kind":12,"line":739,"containerName":"algorithm_reference","name":"isa"},{"line":740,"kind":13,"name":"$result","containerName":"algorithm_reference"},{"containerName":"algorithm_reference","name":"algorithm","line":740,"kind":12},{"line":741,"kind":13,"localvar":"my","containerName":"algorithm_reference","definition":"my","name":"$res"},{"name":"$result","containerName":"algorithm_reference","line":741,"kind":13},{"name":"algorithm","containerName":"algorithm_reference","line":741,"kind":12},{"line":741,"kind":13,"containerName":"algorithm_reference","name":"$result"},{"containerName":"algorithm_reference","name":"algorithm_version","kind":12,"line":741},{"containerName":"algorithm_reference","name":"$result","kind":13,"line":742},{"containerName":"algorithm_reference","name":"algorithm_version","kind":12,"line":742},{"line":743,"kind":13,"name":"$res","containerName":"algorithm_reference"},{"containerName":"algorithm_reference","name":"$res","kind":13,"line":751},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":759},{"kind":12,"line":759,"name":"algorithm","containerName":"algorithm_reference"},{"name":"$result","containerName":"algorithm_reference","line":760,"kind":13},{"line":760,"kind":12,"containerName":"algorithm_reference","name":"algorithm"},{"containerName":"algorithm_reference","name":"$result","line":760,"kind":13},{"containerName":"algorithm_reference","name":"algorithm_version","kind":12,"line":760}],"line":736,"kind":12},{"range":{"end":{"character":9999,"line":772},"start":{"character":0,"line":768}},"containerName":"main::","name":"_numwithcommas","definition":"sub","line":768,"children":[{"line":769,"kind":13,"localvar":"my","containerName":"_numwithcommas","definition":"my","name":"$num"},{"kind":13,"line":770,"name":"$num","containerName":"_numwithcommas"},{"kind":13,"line":771,"name":"$num","containerName":"_numwithcommas"}],"kind":12},{"children":[{"kind":13,"line":775,"definition":"my","name":"$str","containerName":"_linewrap","localvar":"my"},{"line":776,"kind":13,"name":"$TextWrapLoaded","containerName":"_linewrap"},{"containerName":"_linewrap","name":"$str","line":777,"kind":13},{"line":778,"kind":13,"name":"$str","containerName":"_linewrap"}],"line":774,"kind":12,"signature":{"label":"_linewrap($str)","documentation":"","parameters":[{"label":"$str"}]},"detail":"($str)","definition":"sub","containerName":"main::","range":{"start":{"line":774,"character":0},"end":{"line":779,"character":9999}},"name":"_linewrap"},{"containerName":"Wrap::wrap","name":"Text","line":777,"kind":12},{"children":[{"kind":13,"line":810,"containerName":"no_wublastlinks","definition":"my","name":"$self","localvar":"my"},{"line":812,"kind":13,"name":"$self","containerName":"no_wublastlinks"},{"containerName":"no_wublastlinks","name":"$self","kind":13,"line":813}],"line":809,"kind":12,"range":{"end":{"character":9999,"line":814},"start":{"character":0,"line":809}},"name":"no_wublastlinks","definition":"sub","containerName":"main::"}]}