{"version":5,"vars":[{"kind":2,"line":190,"containerName":"","name":"base"},{"localvar":"my","definition":"my","name":"%column_map","containerName":null,"line":202,"kind":13},{"line":237,"children":[{"line":237,"kind":13,"name":"%column_map","containerName":"column_map"}],"kind":12,"range":{"start":{"character":0,"line":237},"end":{"line":237,"character":9999}},"containerName":"main::","definition":"sub","name":"column_map"},{"name":"to_string","range":{"start":{"character":0,"line":262},"end":{"line":273,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":264},{"line":264,"kind":13,"containerName":"to_string","name":"$result"},{"name":"$include_labels","containerName":"to_string","line":264,"kind":13},{"line":266,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$str"},{"line":266,"kind":13,"name":"$include_labels","containerName":"to_string"},{"kind":13,"line":266,"containerName":"to_string","name":"$self"},{"line":266,"kind":12,"containerName":"to_string","name":"column_labels"},{"containerName":"to_string","definition":"my","name":"$func_ref","localvar":"my","kind":13,"line":267},{"containerName":"to_string","name":"$self","line":267,"kind":13},{"line":267,"kind":12,"name":"row_data_func","containerName":"to_string"},{"kind":13,"line":268,"definition":"my","name":"$printf_fmt","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"$self","kind":13,"line":268},{"line":268,"kind":12,"name":"printf_fmt","containerName":"to_string"},{"line":270,"kind":13,"localvar":"my","name":"$resultfilter","definition":"my","containerName":"to_string"},{"containerName":"to_string","name":"$hitfilter","line":270,"kind":13},{"kind":13,"line":270,"containerName":"to_string","name":"$self"},{"name":"filter","containerName":"to_string","line":270,"kind":12},{"name":"$self","containerName":"to_string","kind":13,"line":271},{"name":"filter","containerName":"to_string","kind":12,"line":271},{"line":272,"kind":13,"name":"$resultfilter","containerName":"to_string"},{"name":"$resultfilter","containerName":"to_string","kind":13,"line":273}],"line":262,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"$include_labels"}],"documentation":"1;\n# $Id: HitTableWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::SearchIO::Writer::HitTableWriter - Tab-delimited data for Bio::Search::Hit::HitI objects\n\n=head1 SYNOPSIS\n\n=head2 Example 1: Using the default columns\n\n    use Bio::SearchIO;\n    use Bio::SearchIO::Writer::HitTableWriter;\n\n    my $in = Bio::SearchIO->new();\n\n    my $writer = Bio::SearchIO::Writer::HitTableWriter->new();\n\n    my $out = Bio::SearchIO->new( -writer => $writer );\n\n    while ( my $result = $in->next_result() ) {\n        $out->write_result($result, ($in->report_count - 1 ? 0 : 1) );\n    }\n\n=head2 Example 2: Specifying a subset of columns \n\n    use Bio::SearchIO;\n    use Bio::SearchIO::Writer::HitTableWriter;\n\n    my $in = Bio::SearchIO->new();\n\n    my $writer = Bio::SearchIO::Writer::HitTableWriter->new( \n                                  -columns => [qw(\n                                                  query_name\n                                                  query_length\n                                                  hit_name\n                                                  hit_length\n                                                  frac_identical_query\n                                                  expect\n                                                  )]  );\n\n    my $out = Bio::SearchIO->new( -writer => $writer,\n\t\t\t\t  -file   => \">searchio.out\" );\n\n    while ( my $result = $in->next_result() ) {\n        $out->write_result($result, ($in->report_count - 1 ? 0 : 1) );\n    }\n\n=head2 Custom Labels\n\nYou can also specify different column labels if you don't want to use\nthe defaults.  Do this by specifying a C<-labels> hash reference\nparameter when creating the HitTableWriter object. The keys of the\nhash should be the column number (left-most column = 1) for the label(s)\nyou want to specify. Here's an example:\n\n    my $writer = Bio::SearchIO::Writer::HitTableWriter->new( \n                               -columns => [qw( query_name \n                                                query_length\n                                                hit_name\n                                                hit_length  )],\n                               -labels  => { 1 => 'QUERY_GI',\n  \t                                     3 => 'HIT_IDENTIFIER' } );\n\n\n=head1 DESCRIPTION\n\nBio::SearchIO::Writer::HitTableWriter outputs summary data \nfor each Hit within a search result. Output is in tab-delimited format,\none row per Hit. \n\nThe reason why this is considered summary data is that if a hit\ncontains multiple HSPs, the HSPs will be tiled and \nthe data represents a summary across all HSPs.\nSee below for which columns are affected.\nSee the docs in L<Bio::Search::Hit::BlastHit|Bio::Search::Hit::BlastHit>\n for more details on HSP tiling.\n\n=head2 Available Columns\n\nHere are the columns that can be specified in the C<-columns>\nparameter when creating a HitTableWriter object.  If a C<-columns> parameter\nis not specified, this list, in this order, will be used as the default.\n\n    query_name             # Sequence identifier of the query.\n    query_length           # Full length of the query sequence\n    hit_name               # Sequence identifier of the hit\n    hit_length             # Full length of the hit sequence\n    round                  # Round number for hit (PSI-BLAST)\n    expect                 # Expect value for the alignment\n    score                  # Score for the alignment (e.g., BLAST score)\n    bits                   # Bit score for the alignment\n    num_hsps               # Number of HSPs (not the \"N\" value)\n    frac_identical_query*  # fraction of identical substitutions in query\n    frac_identical_hit*    # fraction of identical substitutions in hit\n    frac_conserved_query*  # fraction of conserved substitutions in query\n    frac_conserved_hit*    # fraction of conserved substitutions in hit\n    frac_aligned_query*    # fraction of the query sequence that is aligned\n    frac_aligned_hit*      # fraction of the hit sequence that is aligned\n    length_aln_query*      # Length of the aligned portion of the query sequence\n    length_aln_hit*        # Length of the aligned portion of the hit sequence\n    gaps_query*            # Number of gap characters in the aligned query sequence\n    gaps_hit*              # Number of gap characters in the aligned hit sequence\n    gaps_total*            # Number of gap characters in the aligned query and hit sequences\n    start_query*           # Starting coordinate of the aligned portion of the query sequence\n    end_query*             # Ending coordinate of the aligned portion of the query sequence\n    start_hit*             # Starting coordinate of the aligned portion of the hit sequence\n    end_hit*               # Ending coordinate of the aligned portion of the hit sequence\n    strand_query           # Strand of the aligned query sequence\n    strand_hit             # Strand of the aligned hit sequence\n    frame                  # Frame of the alignment (0,1,2)\n    ambiguous_aln          # Ambiguous alignment indicator ('qs', 'q', 's')\n    hit_description        # Full description of the hit sequence\n    query_description      # Full description of the query sequence\n    rank                   # The rank order of the hit\n    num_hits               # Number of hits for the query finding this hit\n\nItems marked with a C<*> report data summed across all HSPs\nafter tiling them to avoid counting data from overlapping regions\nmultiple times.\n\nFor more details about these columns, see the documentation for the\ncorresponding method in Bio::Search::Result::BlastHit.\n\n=head1 TODO\n\nFigure out the best way to incorporate algorithm-specific score columns.\nThe best route is probably to have algorithm-specific subclasses \n(e.g., BlastHitTableWriter, FastaHitTableWriter).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports\nand comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001, 2002 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\nL<Bio::SearchIO::Writer::HitTableWriter>, \nL<Bio::SearchIO::Writer::ResultTableWriter>\n\n=head1 METHODS\n\n\npackage Bio::SearchIO::Writer::HitTableWriter;\n\nuse strict;\n\nuse base qw(Bio::SearchIO::Writer::ResultTableWriter);\n\n\n# Array fields: column, object, method[/argument], printf format,\n# column label Methods for result object are defined in\n# Bio::Search::Result::ResultI.  Methods for hit object are defined in\n# Bio::Search::Hit::HitI.  Tech note: If a bogus method is supplied,\n# it will result in all values to be zero.  Don't know why this is.\n\n# TODO (maybe): Allow specification of separate mantissa/exponent for\n# significance data.\n\nmy %column_map = (\n                  'query_name'            => ['1', 'result', 'query_name', 's', 'QUERY' ],\n                  'query_length'          => ['2', 'result', 'query_length', 'd', 'LEN_Q'],\n                  'hit_name'              => ['3', 'hit', 'name', 's', 'HIT'],\n                  'hit_length'            => ['4', 'hit', 'length', 'd', 'LEN_H'],\n                  'round'                 => ['5', 'hit', 'iteration', 'd', 'ROUND'],\n                  'expect'                => ['6', 'hit', 'significance', '.1e', 'EXPCT'],\n                  'score'                 => ['7', 'hit', 'raw_score', 'd', 'SCORE'],\n                  'bits'                  => ['8', 'hit', 'bits', 'd', 'BITS'],\n                  'num_hsps'              => ['9', 'hit', 'num_hsps', 'd', 'HSPS'],\n                  'frac_identical_query'  => ['10', 'hit', 'frac_identical/query', '.2f', 'FR_IDQ'],\n                  'frac_identical_hit'    => ['11', 'hit', 'frac_identical/hit', '.2f', 'FR_IDH'],\n                  'frac_conserved_query'  => ['12', 'hit', 'frac_conserved/query', '.2f', 'FR_CNQ'],\n                  'frac_conserved_hit'    => ['13', 'hit', 'frac_conserved/hit', '.2f', 'FR_CNH'],\n                  'frac_aligned_query'    => ['14', 'hit', 'frac_aligned_query', '.2f', 'FR_ALQ'],\n                  'frac_aligned_hit'      => ['15', 'hit', 'frac_aligned_hit', '.2f', 'FR_ALH'],\n                  'length_aln_query'      => ['16', 'hit', 'length_aln/query', 'd', 'LN_ALQ'],\n                  'length_aln_hit'        => ['17', 'hit', 'length_aln/hit', 'd', 'LN_ALH'],\n                  'gaps_query'            => ['18', 'hit', 'gaps/query', 'd', 'GAPS_Q'],\n                  'gaps_hit'              => ['19', 'hit', 'gaps/hit', 'd', 'GAPS_H'],\n                  'gaps_total'            => ['20', 'hit', 'gaps/total', 'd', 'GAPS_QH'],\n                  'start_query'           => ['21', 'hit', 'start/query', 'd', 'START_Q'],\n                  'end_query'             => ['22', 'hit', 'end/query', 'd', 'END_Q'],\n                  'start_hit'             => ['23', 'hit', 'start/hit', 'd', 'START_H'],\n                  'end_hit'               => ['24', 'hit', 'end/hit', 'd', 'END_H'],\n                  'strand_query'          => ['25', 'hit', 'strand/query', 's', 'STRND_Q'],\n                  'strand_hit'            => ['26', 'hit', 'strand/hit', 's', 'STRND_H'],\n                  'frame'                 => ['27', 'hit', 'frame', 'd', 'FRAME'],\n                  'ambiguous_aln'         => ['28', 'hit', 'ambiguous_aln', 's', 'AMBIG'],\n                  'hit_description'       => ['29', 'hit', 'description', 's', 'DESC_H'],\n                  'query_description'     => ['30', 'result', 'query_description', 's', 'DESC_Q'],\n                  'rank'                  => ['31', 'hit', 'rank', 's', 'RANK'],\n                  'num_hits'              => ['32', 'result', 'num_hits', 's', 'NUM_HITS'],\n                 );\n\nsub column_map { return %column_map }\n\n\n=head2 to_string()\n\nNote: this method is not intended for direct use. The\nSearchIO::write_result() method calls it automatically if the writer\nis hooked up to a SearchIO object as illustrated in \nL<the SYNOPSIS section | SYNOPSIS>.\n\n Title     : to_string()\n           :\n Usage     : print $writer->to_string( $result_obj, [$include_labels] );\n           :\n Argument  : $result_obj = A Bio::Search::Result::BlastResult object\n           : $include_labels = boolean, if true column labels are included (default: false)\n           :\n Returns   : String containing tab-delimited set of data for each hit \n           : in a BlastResult object. Some data is summed across multiple HSPs.\n           :\n Throws    : n/a","label":"to_string($self,$result,$include_labels)"},"detail":"($self,$result,$include_labels)"},{"name":"%result","containerName":null,"kind":13,"line":273},{"containerName":null,"name":"$result","kind":13,"line":274},{"line":274,"kind":12,"name":"can","containerName":"main::"},{"name":"$result","containerName":null,"line":275,"kind":13},{"kind":12,"line":275,"name":"rewind","containerName":"main::"},{"line":276,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$hit"},{"line":276,"kind":13,"containerName":null,"name":"$result"},{"kind":12,"line":276,"name":"hits","containerName":"main::"},{"line":277,"kind":13,"name":"$hitfilter","containerName":null},{"line":277,"kind":13,"containerName":null,"name":"$hitfilter"},{"name":"$hit","containerName":null,"line":277,"kind":13},{"kind":13,"line":278,"definition":"my","name":"@row_data","containerName":null,"localvar":"my"},{"kind":13,"line":278,"name":"$func_ref","containerName":null},{"name":"$result","containerName":null,"kind":13,"line":278},{"name":"$hit","containerName":null,"line":278,"kind":13},{"containerName":null,"name":"$str","line":279,"kind":13},{"containerName":null,"name":"@row_data","kind":13,"line":279},{"containerName":null,"name":"$str","kind":13,"line":282},{"kind":13,"line":283,"containerName":null,"name":"$str"},{"definition":"sub","name":"end_report","containerName":"main::","range":{"end":{"character":9999,"line":301},"start":{"character":0,"line":299}},"kind":12,"children":[],"line":299}]}