{"vars":[{"containerName":"","name":"vars","kind":2,"line":81},{"kind":13,"line":84,"containerName":null,"name":"%Defaults"},{"line":84,"kind":2,"containerName":"","name":"strict"},{"line":85,"kind":13,"containerName":null,"name":"%Defaults"},{"name":"%Defaults","containerName":null,"line":86,"kind":13},{"line":88,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"line":102,"character":0},"end":{"line":116,"character":9999}},"name":"new","line":102,"children":[{"kind":13,"line":103,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"kind":13,"line":103,"containerName":"new","name":"@args"},{"line":105,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"kind":13,"line":105,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","line":105,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":106},{"name":"$self","containerName":"new","line":107,"kind":13},{"kind":13,"line":108,"name":"$self","containerName":"new"},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":109,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":109,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":110},{"kind":13,"line":111,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","kind":13,"line":112},{"kind":13,"line":113,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":114,"kind":13},{"containerName":"new","name":"$Defaults","kind":13,"line":114},{"name":"$self","containerName":"new","line":115,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: GbrowseGFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::SearchIO::Writer::GbrowseGFF.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Wilkinson <markw@illuminae.com>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::Writer::GbrowseGFF - Interface for outputting parsed search results in Gbrowse GFF format\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',      \n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'GbrowseGFF',\n                              -output_cigar   => 1,\n                              -output_signif  => 1,\n                              -file           => \">result.gff\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis writer produces Gbrowse flavour GFF from a Search::Result object.\n\n=head1 AUTHOR  Mark Wilkinson\n\nEmail markw-at-illuminae-dot-com\n\n=head1 CONTRIBUTORS\n\nSusan Miller sjmiller at email-DOT-arizon-DOT-edu\nJason Stajich jason at bioperl-dot-org\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::GbrowseGFF;\nuse vars qw(%Defaults);\nuse strict;\n\n$Defaults{'Prefix'}   = 'EST';\n$Defaults{'HSPTag'}   = 'HSP';\n$Defaults{'MatchTag'} = 'match';\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::GbrowseGFF->new(@args);\n Function: Builds a new Bio::SearchIO::Writer::GbrowseGFF object \n Returns : an instance of Bio::SearchIO::Writer::GbrowseGFF\n Args    :  -e_value => 10   : set e_value parsing cutoff (default undef)\n            (note the -e_value flag is deprecated.)"},"containerName":"main::","definition":"sub"},{"line":105,"kind":12,"name":"SUPER","containerName":"new"},{"line":112,"kind":12,"name":"Gbrowse_HSPID"},{"name":"Gbrowse_HITID","line":113,"kind":12},{"line":118,"children":[{"kind":13,"line":119,"name":"$self","definition":"my","containerName":"_incrementHSP","localvar":"my"},{"kind":13,"line":120,"containerName":"_incrementHSP","name":"$self"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_incrementHSP($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":118},"end":{"line":121,"character":9999}},"name":"_incrementHSP"},{"line":120,"kind":12,"name":"Gbrowse_HSPID"},{"range":{"start":{"line":123,"character":0},"end":{"character":9999,"line":126}},"name":"_incrementHIT","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_incrementHIT($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":124,"kind":13,"localvar":"my","containerName":"_incrementHIT","name":"$self","definition":"my"},{"kind":13,"line":125,"containerName":"_incrementHIT","name":"$self"}],"line":123,"kind":12},{"kind":12,"line":125,"name":"Gbrowse_HITID"},{"detail":"($self,$result,@args)","signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: GbrowseGFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::SearchIO::Writer::GbrowseGFF.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Wilkinson <markw@illuminae.com>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::Writer::GbrowseGFF - Interface for outputting parsed search results in Gbrowse GFF format\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',      \n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'GbrowseGFF',\n                              -output_cigar   => 1,\n                              -output_signif  => 1,\n                              -file           => \">result.gff\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis writer produces Gbrowse flavour GFF from a Search::Result object.\n\n=head1 AUTHOR  Mark Wilkinson\n\nEmail markw-at-illuminae-dot-com\n\n=head1 CONTRIBUTORS\n\nSusan Miller sjmiller at email-DOT-arizon-DOT-edu\nJason Stajich jason at bioperl-dot-org\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::SearchIO::Writer::GbrowseGFF;\nuse vars qw(%Defaults);\nuse strict;\n\n$Defaults{'Prefix'}   = 'EST';\n$Defaults{'HSPTag'}   = 'HSP';\n$Defaults{'MatchTag'} = 'match';\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::GbrowseGFF->new(@args);\n Function: Builds a new Bio::SearchIO::Writer::GbrowseGFF object \n Returns : an instance of Bio::SearchIO::Writer::GbrowseGFF\n Args    :  -e_value => 10   : set e_value parsing cutoff (default undef)\n            (note the -e_value flag is deprecated.)\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    ($self->{'_evalue'},\n     $self->{'_cigar'},\n     $self->{'_prefix'},\n     $self->{'_signif'} ) = $self->_rearrange([qw(E_VALUE OUTPUT_CIGAR PREFIX\n\t\t\t\t\t\t OUTPUT_SIGNIF)], @args);\n    $self->{'_evalue'} && warn( \"Use of the -e_value argument is deprecated.\\nIn future, use \\$writer->filter(\\\"type\\\", \\&code) instead.\\n\\tparsing will proceed correctly with this e_value\\n\");\n    $self->{Gbrowse_HSPID} = 0;\n    $self->{Gbrowse_HITID} = 0;\n    $self->{'_prefix'} ||= $Defaults{'Prefix'};\n    return $self;\n}\n\nsub _incrementHSP {\n    my ($self) = @_;\n    return ++$self->{Gbrowse_HSPID};\n}\n\nsub _incrementHIT {\n    my ($self) = @_;\n    return ++$self->{Gbrowse_HITID}\n}\n# according to the GFF3 spec:\n#\"match\".  In addition to the generic \"match\"\n#type, there are the subclasses \"cDNA_match,\" \"EST_match,\"\n#\"translated_nucleotide_match,\" \"nucleotide_to_protein_match,\" and\n#\"nucleotide_motif.\"\n\n=head2 to_string\n\n Purpose   : Produce the Gbrowse format GFF lines for a Result\n Usage     : print $writer->to_string( $result_obj, @args);\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n             -version => 1|2|2.5|3  ; the GFF format you want to output (default 3)\n             -match_tag => match|cDNA_match|EST_match|translated_nucleotide_match\n                           nucleotide_to_protein_match|nucleotide_motif\n                           This is the SO term to be placed in GFF column 3.\n             -prefix => String to prefix the group by, default is EST \n                        (see %Defaults class variable) A default can also\n                        be set on object init\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n-reference => 'hit'|'query' ; whether the hit sequence name or the\n                              query sequence name is used as the\n                              'reference' sequence (GFF column 1)","label":"to_string($self,$result,@args)"},"containerName":"main::","definition":"sub","line":155,"children":[{"line":156,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$self"},{"name":"$result","containerName":"to_string","line":156,"kind":13},{"containerName":"to_string","name":"@args","kind":13,"line":156},{"localvar":"my","containerName":"to_string","name":"$format","definition":"my","line":157,"kind":13},{"line":157,"kind":13,"containerName":"to_string","name":"$reference"},{"kind":13,"line":158,"name":"$match_tag","containerName":"to_string"},{"line":158,"kind":13,"name":"$hsp_tag","containerName":"to_string"},{"name":"$prefix","containerName":"to_string","line":159,"kind":13},{"containerName":"to_string","name":"$self","line":159,"kind":13},{"containerName":"to_string","name":"_rearrange","line":159,"kind":12},{"line":163,"kind":13,"name":"@args","containerName":"to_string"},{"containerName":"to_string","name":"$self","line":164,"kind":13},{"kind":12,"line":164,"name":"warn","containerName":"to_string"},{"name":"$reference","containerName":"to_string","kind":13,"line":164},{"containerName":"to_string","name":"$reference","kind":13,"line":164},{"line":165,"kind":13,"containerName":"to_string","name":"$reference"},{"kind":13,"line":166,"name":"$match_tag","containerName":"to_string"},{"containerName":"to_string","name":"$Defaults","kind":13,"line":166},{"containerName":"to_string","name":"$hsp_tag","kind":13,"line":167},{"containerName":"to_string","name":"$Defaults","kind":13,"line":167},{"kind":13,"line":168,"containerName":"to_string","name":"$prefix"},{"line":168,"kind":13,"containerName":"to_string","name":"$self"},{"line":169,"kind":13,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"throw","line":169,"kind":12},{"name":"$reference","containerName":"to_string","line":169,"kind":13},{"line":175,"kind":13,"name":"$format","containerName":"to_string"},{"name":"$gffio","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":176},{"containerName":"to_string","name":"new","line":176,"kind":12},{"line":176,"kind":13,"containerName":"to_string","name":"$format"},{"containerName":"to_string","name":"$gffio","kind":13,"line":179},{"line":182,"kind":13,"localvar":"my","containerName":"to_string","name":"$GFF","definition":"my"},{"line":182,"kind":13,"name":"$cigar","containerName":"to_string"},{"containerName":"to_string","name":"$score","kind":13,"line":182},{"kind":13,"line":183,"containerName":"to_string","definition":"my","name":"$resultfilter","localvar":"my"},{"containerName":"to_string","name":"$hitfilter","line":183,"kind":13},{"kind":13,"line":183,"name":"$hspfilter","containerName":"to_string"},{"line":184,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"filter","kind":12,"line":184},{"line":185,"kind":13,"name":"$self","containerName":"to_string"},{"line":185,"kind":12,"name":"filter","containerName":"to_string"},{"line":186,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":186,"containerName":"to_string","name":"filter"},{"kind":13,"line":187,"containerName":"to_string","name":"$result"},{"containerName":"to_string","name":"can","kind":12,"line":187},{"kind":13,"line":187,"name":"$result","containerName":"to_string"},{"kind":12,"line":187,"containerName":"to_string","name":"rewind"},{"kind":13,"line":188,"containerName":"to_string","name":"$resultfilter"},{"line":188,"kind":13,"containerName":"to_string","name":"$resultfilter"}],"kind":12,"range":{"start":{"line":155,"character":0},"end":{"line":188,"character":9999}},"name":"to_string"},{"name":"Bio","containerName":"Tools::GFF","kind":12,"line":176},{"containerName":null,"name":"$result","line":188,"kind":13},{"kind":13,"line":190,"containerName":null,"definition":"my","name":"$hit","localvar":"my"},{"containerName":null,"name":"$result","kind":13,"line":190},{"name":"next_hit","containerName":"main::","kind":12,"line":190},{"line":192,"kind":13,"containerName":null,"name":"%self"},{"line":192,"kind":12,"name":"_evalue"},{"kind":13,"line":193,"name":"$hit","containerName":null},{"name":"significance","containerName":"main::","line":193,"kind":12},{"line":193,"kind":13,"containerName":null,"name":"%self"},{"name":"_evalue","line":193,"kind":12},{"kind":13,"line":195,"name":"$hitfilter","containerName":null},{"line":195,"kind":13,"name":"$hitfilter","containerName":null},{"containerName":null,"name":"$hit","kind":13,"line":195},{"localvar":"my","containerName":null,"name":"$refseq","definition":"my","line":197,"kind":13},{"line":197,"kind":13,"containerName":null,"name":"$reference"},{"line":197,"kind":13,"containerName":null,"name":"$hit"},{"name":"name","containerName":"main::","kind":12,"line":197},{"containerName":null,"name":"$result","kind":13,"line":197},{"line":197,"kind":12,"containerName":"main::","name":"query_name"},{"localvar":"my","containerName":null,"name":"$seqname","definition":"my","line":198,"kind":13},{"name":"$reference","containerName":null,"line":198,"kind":13},{"containerName":null,"name":"$result","kind":13,"line":198},{"kind":12,"line":198,"name":"query_name","containerName":"main::"},{"containerName":null,"name":"$hit","line":198,"kind":13},{"kind":12,"line":198,"name":"name","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":199},{"name":"_signif","kind":12,"line":199},{"kind":13,"line":200,"containerName":null,"name":"$score"},{"name":"$hit","containerName":null,"kind":13,"line":200},{"kind":12,"line":200,"containerName":"main::","name":"significance"},{"name":"$score","containerName":null,"line":202,"kind":13},{"name":"$hit","containerName":null,"kind":13,"line":202},{"name":"raw_score","containerName":"main::","line":202,"kind":12},{"name":"$self","containerName":null,"line":204,"kind":13},{"name":"throw","containerName":"main::","line":204,"kind":12},{"line":204,"kind":13,"containerName":null,"name":"$refseq"},{"line":205,"kind":13,"localvar":"my","containerName":null,"name":"$source","definition":"my"},{"line":205,"kind":13,"name":"$hit","containerName":null},{"kind":12,"line":205,"containerName":"main::","name":"algorithm"},{"containerName":null,"name":"$self","kind":13,"line":206},{"containerName":"main::","name":"throw","line":206,"kind":12},{"containerName":null,"name":"$refseq","kind":13,"line":206},{"name":"$self","containerName":null,"line":207,"kind":13},{"kind":12,"line":207,"name":"throw","containerName":"main::"},{"line":207,"kind":13,"containerName":null,"name":"$source"},{"line":209,"kind":13,"localvar":"my","containerName":null,"name":"@plus_hsps","definition":"my"},{"kind":13,"line":210,"name":"@minus_hsps","definition":"my","containerName":null,"localvar":"my"},{"line":215,"kind":13,"localvar":"my","name":"$qpmin","definition":"my","containerName":null},{"line":215,"kind":13,"containerName":null,"name":"$qpmax"},{"containerName":null,"name":"$qmmin","kind":13,"line":215},{"containerName":null,"name":"$qmmax","line":215,"kind":13},{"line":215,"kind":13,"containerName":null,"name":"$spmin"},{"line":215,"kind":13,"containerName":null,"name":"$spmax"},{"line":215,"kind":13,"containerName":null,"name":"$smmin"},{"line":215,"kind":13,"name":"$smmax","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$hsp","line":216,"kind":13},{"line":216,"kind":13,"name":"$hit","containerName":null},{"line":216,"kind":12,"containerName":"main::","name":"next_hsp"},{"name":"%self","containerName":null,"line":217,"kind":13},{"name":"_evalue","kind":12,"line":217},{"line":219,"kind":13,"name":"$hsp","containerName":null},{"name":"significance","containerName":"main::","kind":12,"line":219},{"name":"%self","containerName":null,"kind":13,"line":219},{"name":"_evalue","line":219,"kind":12},{"kind":13,"line":221,"name":"$hspfilter","containerName":null},{"containerName":null,"name":"$hspfilter","line":221,"kind":13},{"name":"$hsp","containerName":null,"line":221,"kind":13},{"kind":13,"line":222,"name":"$hsp","containerName":null},{"containerName":"main::","name":"hit","line":222,"kind":12},{"containerName":"main::","name":"strand","line":222,"kind":12},{"kind":13,"line":223,"containerName":null,"name":"@plus_hsps"},{"kind":13,"line":223,"containerName":null,"name":"$hsp"},{"name":"%qpmin","containerName":null,"line":224,"kind":13},{"name":"$qpmin","containerName":null,"kind":13,"line":225},{"containerName":null,"name":"$hsp","kind":13,"line":225},{"containerName":"main::","name":"query","kind":12,"line":225},{"line":225,"kind":12,"containerName":"main::","name":"start"},{"line":225,"kind":13,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","kind":12,"line":225},{"line":225,"kind":12,"containerName":"main::","name":"start"},{"name":"$qpmin","containerName":null,"kind":13,"line":225},{"kind":13,"line":226,"name":"$qpmax","containerName":null},{"kind":13,"line":226,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"query","kind":12,"line":226},{"containerName":"main::","name":"end","line":226,"kind":12},{"line":226,"kind":13,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"query","line":226,"kind":12},{"name":"end","containerName":"main::","kind":12,"line":226},{"line":226,"kind":13,"name":"$qpmax","containerName":null},{"kind":13,"line":227,"name":"$spmin","containerName":null},{"name":"$hsp","containerName":null,"line":227,"kind":13},{"containerName":"main::","name":"hit","line":227,"kind":12},{"name":"start","containerName":"main::","line":227,"kind":12},{"line":227,"kind":13,"containerName":null,"name":"$hsp"},{"name":"hit","containerName":"main::","kind":12,"line":227},{"name":"start","containerName":"main::","line":227,"kind":12},{"kind":13,"line":227,"name":"$spmin","containerName":null},{"name":"$spmax","containerName":null,"line":228,"kind":13},{"containerName":null,"name":"$hsp","line":228,"kind":13},{"containerName":"main::","name":"hit","line":228,"kind":12},{"containerName":"main::","name":"end","kind":12,"line":228},{"name":"$hsp","containerName":null,"line":228,"kind":13},{"name":"hit","containerName":"main::","line":228,"kind":12},{"line":228,"kind":12,"name":"end","containerName":"main::"},{"containerName":null,"name":"%spmax","line":228,"kind":13},{"kind":13,"line":230,"name":"$qpmin","containerName":null},{"containerName":null,"name":"$hsp","kind":13,"line":230},{"line":230,"kind":12,"name":"query","containerName":"main::"},{"kind":12,"line":230,"containerName":"main::","name":"start"},{"kind":13,"line":231,"name":"$qpmax","containerName":null},{"containerName":null,"name":"$hsp","line":231,"kind":13},{"kind":12,"line":231,"containerName":"main::","name":"query"},{"kind":12,"line":231,"containerName":"main::","name":"end"},{"line":232,"kind":13,"name":"$spmin","containerName":null},{"name":"$hsp","containerName":null,"kind":13,"line":232},{"line":232,"kind":12,"name":"hit","containerName":"main::"},{"containerName":"main::","name":"start","kind":12,"line":232},{"name":"$spmax","containerName":null,"kind":13,"line":233},{"containerName":null,"name":"$hsp","kind":13,"line":233},{"containerName":"main::","name":"hit","kind":12,"line":233},{"line":233,"kind":12,"containerName":"main::","name":"end"},{"name":"$hsp","containerName":null,"kind":13,"line":236},{"name":"hit","containerName":"main::","kind":12,"line":236},{"name":"strand","containerName":"main::","line":236,"kind":12},{"line":237,"kind":13,"name":"@minus_hsps","containerName":null},{"containerName":null,"name":"$hsp","line":237,"kind":13},{"kind":13,"line":238,"name":"%qmmin","containerName":null},{"kind":13,"line":239,"name":"$qmmin","containerName":null},{"line":239,"kind":13,"containerName":null,"name":"$hsp"},{"name":"query","containerName":"main::","line":239,"kind":12},{"line":239,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"name":"$hsp","kind":13,"line":239},{"containerName":"main::","name":"query","kind":12,"line":239},{"line":239,"kind":12,"containerName":"main::","name":"start"},{"name":"$qmmin","containerName":null,"line":239,"kind":13},{"name":"$qmmax","containerName":null,"line":240,"kind":13},{"kind":13,"line":240,"name":"$hsp","containerName":null},{"line":240,"kind":12,"containerName":"main::","name":"query"},{"kind":12,"line":240,"containerName":"main::","name":"end"},{"name":"$hsp","containerName":null,"line":240,"kind":13},{"name":"query","containerName":"main::","kind":12,"line":240},{"kind":12,"line":240,"name":"end","containerName":"main::"},{"containerName":null,"name":"$qmmax","line":240,"kind":13},{"line":241,"kind":13,"name":"$smmin","containerName":null},{"containerName":null,"name":"$hsp","line":241,"kind":13},{"containerName":"main::","name":"hit","line":241,"kind":12},{"kind":12,"line":241,"containerName":"main::","name":"start"},{"line":241,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"line":241,"name":"hit","containerName":"main::"},{"kind":12,"line":241,"containerName":"main::","name":"start"},{"name":"$smmin","containerName":null,"line":241,"kind":13},{"kind":13,"line":242,"name":"$smmax","containerName":null},{"name":"$hsp","containerName":null,"kind":13,"line":242},{"name":"hit","containerName":"main::","line":242,"kind":12},{"line":242,"kind":12,"name":"end","containerName":"main::"},{"line":242,"kind":13,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"hit","line":242,"kind":12},{"kind":12,"line":242,"name":"end","containerName":"main::"},{"kind":13,"line":242,"containerName":null,"name":"%smmax"},{"name":"$qmmin","containerName":null,"kind":13,"line":244},{"name":"$hsp","containerName":null,"line":244,"kind":13},{"containerName":"main::","name":"query","line":244,"kind":12},{"name":"start","containerName":"main::","kind":12,"line":244},{"line":245,"kind":13,"name":"$qmmax","containerName":null},{"containerName":null,"name":"$hsp","line":245,"kind":13},{"name":"query","containerName":"main::","kind":12,"line":245},{"kind":12,"line":245,"containerName":"main::","name":"end"},{"name":"$smmin","containerName":null,"line":246,"kind":13},{"line":246,"kind":13,"name":"$hsp","containerName":null},{"kind":12,"line":246,"containerName":"main::","name":"hit"},{"containerName":"main::","name":"start","kind":12,"line":246},{"kind":13,"line":247,"containerName":null,"name":"$smmax"},{"kind":13,"line":247,"containerName":null,"name":"$hsp"},{"kind":12,"line":247,"name":"hit","containerName":"main::"},{"kind":12,"line":247,"name":"end","containerName":"main::"},{"kind":13,"line":252,"name":"@plus_hsps","containerName":null},{"line":252,"kind":13,"containerName":null,"name":"@minus_hsps"},{"containerName":null,"definition":"my","name":"$ID","localvar":"my","kind":13,"line":253},{"kind":13,"line":253,"name":"$self","containerName":null},{"name":"_incrementHIT","containerName":"main::","kind":12,"line":253},{"line":261,"kind":13,"name":"@plus_hsps","containerName":null},{"name":"%tags","definition":"my","containerName":null,"localvar":"my","kind":13,"line":262},{"line":264,"kind":13,"containerName":null,"name":"%format"},{"line":265,"kind":13,"name":"%tags","containerName":null},{"name":"%tags","containerName":null,"kind":13,"line":266},{"kind":13,"line":266,"containerName":null,"name":"$qmmin"},{"containerName":null,"name":"%tags","kind":13,"line":267},{"name":"%qmmax","containerName":null,"kind":13,"line":267},{"name":"%tags","containerName":null,"kind":13,"line":269},{"line":271,"kind":13,"containerName":null,"name":"%self"},{"name":"%tags","containerName":null,"kind":13,"line":272},{"containerName":null,"name":"$cigar","kind":13,"line":272},{"containerName":null,"name":"$feat","definition":"my","localvar":"my","kind":13,"line":274},{"line":274,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":274},{"containerName":null,"name":"$refseq","kind":13,"line":275},{"kind":13,"line":276,"name":"$source","containerName":null},{"line":277,"kind":13,"name":"$match_tag","containerName":null},{"name":"$spmin","containerName":null,"kind":13,"line":278},{"name":"$spmax","containerName":null,"kind":13,"line":279},{"containerName":null,"name":"$score","line":280,"kind":13},{"name":"%tags","containerName":null,"line":283,"kind":13},{"kind":13,"line":287,"definition":"my","name":"$formatter","containerName":null,"localvar":"my"},{"kind":12,"line":287,"name":"Bio","containerName":"Tools::GFF"},{"line":287,"kind":12,"name":"new","containerName":"main::"},{"name":"$format","containerName":null,"kind":13,"line":287},{"kind":13,"line":288,"name":"$GFF","containerName":null},{"containerName":null,"name":"$feat","line":288,"kind":13},{"containerName":"main::","name":"gff_string","kind":12,"line":288},{"line":288,"kind":13,"name":"$formatter","containerName":null},{"line":290,"kind":13,"name":"@minus_hsps","containerName":null},{"containerName":null,"name":"%tags","definition":"my","localvar":"my","kind":13,"line":291},{"name":"%format","containerName":null,"kind":13,"line":293},{"containerName":null,"name":"%tags","line":294,"kind":13},{"kind":13,"line":295,"name":"%tags","containerName":null},{"containerName":null,"name":"$qpmax","kind":13,"line":295},{"name":"%tags","containerName":null,"line":296,"kind":13},{"kind":13,"line":296,"name":"%qpmin","containerName":null},{"containerName":null,"name":"%tags","line":299,"kind":13},{"localvar":"my","definition":"my","name":"$feat","containerName":null,"line":301,"kind":13},{"name":"Bio","containerName":"SeqFeature::Generic","line":301,"kind":12},{"containerName":"main::","name":"new","line":301,"kind":12},{"containerName":null,"name":"$refseq","kind":13,"line":302},{"line":303,"kind":13,"containerName":null,"name":"$source"},{"kind":13,"line":304,"containerName":null,"name":"$match_tag"},{"kind":13,"line":305,"containerName":null,"name":"$smmin"},{"containerName":null,"name":"$smmax","line":306,"kind":13},{"line":307,"kind":13,"name":"$score","containerName":null},{"containerName":null,"name":"%tags","line":310,"kind":13},{"kind":13,"line":313,"definition":"my","name":"$formatter","containerName":null,"localvar":"my"},{"line":313,"kind":12,"containerName":"Tools::GFF","name":"Bio"},{"containerName":"main::","name":"new","line":313,"kind":12},{"name":"$format","containerName":null,"line":313,"kind":13},{"kind":13,"line":314,"containerName":null,"name":"$GFF"},{"name":"$feat","containerName":null,"kind":13,"line":314},{"containerName":"main::","name":"gff_string","kind":12,"line":314},{"containerName":null,"name":"$formatter","kind":13,"line":314},{"line":318,"kind":13,"localvar":"my","definition":"my","name":"$hsp","containerName":null},{"containerName":null,"name":"@plus_hsps","line":318,"kind":13},{"line":319,"kind":13,"localvar":"my","containerName":null,"name":"$hspID","definition":"my"},{"containerName":null,"name":"$self","kind":13,"line":319},{"line":319,"kind":12,"containerName":"main::","name":"_incrementHSP"},{"definition":"my","name":"$qstart","containerName":null,"localvar":"my","kind":13,"line":320},{"line":320,"kind":13,"name":"$hsp","containerName":null},{"name":"query","containerName":"main::","kind":12,"line":320},{"line":320,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"definition":"my","name":"$qend","localvar":"my","kind":13,"line":321},{"kind":13,"line":321,"containerName":null,"name":"$hsp"},{"containerName":"main::","name":"query","line":321,"kind":12},{"kind":12,"line":321,"containerName":"main::","name":"end"},{"name":"$sstart","definition":"my","containerName":null,"localvar":"my","kind":13,"line":322},{"containerName":null,"name":"$hsp","kind":13,"line":322},{"containerName":"main::","name":"hit","kind":12,"line":322},{"name":"start","containerName":"main::","line":322,"kind":12},{"line":323,"kind":13,"localvar":"my","name":"$send","definition":"my","containerName":null},{"containerName":null,"name":"$hsp","kind":13,"line":323},{"containerName":"main::","name":"hit","line":323,"kind":12},{"containerName":"main::","name":"end","kind":12,"line":323},{"kind":13,"line":324,"containerName":null,"name":"$score","definition":"my","localvar":"my"},{"kind":13,"line":324,"name":"$hsp","containerName":null},{"name":"score","containerName":"main::","line":324,"kind":12},{"localvar":"my","definition":"my","name":"%tags","containerName":null,"line":326,"kind":13},{"kind":13,"line":329,"containerName":null,"name":"%format"},{"kind":13,"line":330,"name":"%tags","containerName":null},{"kind":13,"line":331,"containerName":null,"name":"%tags"},{"kind":13,"line":331,"containerName":null,"name":"$qstart"},{"line":332,"kind":13,"name":"%tags","containerName":null},{"kind":13,"line":332,"name":"%qend","containerName":null},{"line":335,"kind":13,"containerName":null,"name":"%tags"},{"containerName":null,"name":"%self","line":337,"kind":13},{"containerName":null,"name":"%tags","line":338,"kind":13},{"kind":13,"line":338,"name":"$hsp","containerName":null},{"line":338,"kind":12,"containerName":"main::","name":"cigar_string"},{"line":341,"kind":13,"localvar":"my","name":"$feat","definition":"my","containerName":null},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":341},{"line":341,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"line":342,"name":"$refseq","containerName":null},{"line":343,"kind":13,"containerName":null,"name":"$source"},{"line":344,"kind":13,"name":"$hsp_tag","containerName":null},{"line":345,"kind":13,"name":"$sstart","containerName":null},{"name":"$send","containerName":null,"kind":13,"line":346},{"name":"$score","containerName":null,"kind":13,"line":347},{"kind":13,"line":350,"containerName":null,"name":"%tags"},{"localvar":"my","name":"$formatter","definition":"my","containerName":null,"line":353,"kind":13},{"name":"Bio","containerName":"Tools::GFF","kind":12,"line":353},{"name":"new","containerName":"main::","line":353,"kind":12},{"name":"$format","containerName":null,"kind":13,"line":353},{"containerName":null,"name":"$GFF","line":354,"kind":13},{"kind":13,"line":354,"containerName":null,"name":"$feat"},{"line":354,"kind":12,"name":"gff_string","containerName":"main::"},{"line":354,"kind":13,"name":"$formatter","containerName":null},{"kind":13,"line":357,"definition":"my","name":"$hsp","containerName":null,"localvar":"my"},{"name":"@minus_hsps","containerName":null,"kind":13,"line":357},{"name":"$hspID","definition":"my","containerName":null,"localvar":"my","kind":13,"line":358},{"containerName":null,"name":"$self","line":358,"kind":13},{"name":"_incrementHSP","containerName":"main::","line":358,"kind":12},{"kind":13,"line":359,"containerName":null,"name":"$qstart","definition":"my","localvar":"my"},{"line":359,"kind":13,"containerName":null,"name":"$hsp"},{"line":359,"kind":12,"containerName":"main::","name":"query"},{"line":359,"kind":12,"name":"start","containerName":"main::"},{"kind":13,"line":360,"containerName":null,"definition":"my","name":"$qend","localvar":"my"},{"kind":13,"line":360,"name":"$hsp","containerName":null},{"line":360,"kind":12,"name":"query","containerName":"main::"},{"containerName":"main::","name":"end","kind":12,"line":360},{"line":361,"kind":13,"localvar":"my","definition":"my","name":"$sstart","containerName":null},{"line":361,"kind":13,"name":"$hsp","containerName":null},{"kind":12,"line":361,"containerName":"main::","name":"hit"},{"kind":12,"line":361,"containerName":"main::","name":"start"},{"containerName":null,"definition":"my","name":"$send","localvar":"my","kind":13,"line":362},{"kind":13,"line":362,"containerName":null,"name":"$hsp"},{"line":362,"kind":12,"containerName":"main::","name":"hit"},{"kind":12,"line":362,"name":"end","containerName":"main::"},{"containerName":null,"name":"$score","definition":"my","localvar":"my","kind":13,"line":363},{"kind":13,"line":363,"name":"$hsp","containerName":null},{"name":"score","containerName":"main::","kind":12,"line":363},{"localvar":"my","definition":"my","name":"%tags","containerName":null,"line":365,"kind":13},{"kind":13,"line":368,"name":"%format","containerName":null},{"containerName":null,"name":"%tags","kind":13,"line":369},{"containerName":null,"name":"%tags","kind":13,"line":370},{"containerName":null,"name":"$qend","line":370,"kind":13},{"line":371,"kind":13,"name":"%tags","containerName":null},{"line":371,"kind":13,"containerName":null,"name":"%qstart"},{"kind":13,"line":374,"containerName":null,"name":"%tags"},{"name":"%self","containerName":null,"line":376,"kind":13},{"line":377,"kind":13,"name":"%tags","containerName":null},{"kind":13,"line":377,"containerName":null,"name":"$hsp"},{"name":"cigar_string","containerName":"main::","line":377,"kind":12},{"localvar":"my","containerName":null,"name":"$feat","definition":"my","line":380,"kind":13},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":380},{"containerName":"main::","name":"new","kind":12,"line":380},{"kind":13,"line":381,"containerName":null,"name":"$refseq"},{"kind":13,"line":382,"name":"$source","containerName":null},{"name":"$hsp_tag","containerName":null,"line":383,"kind":13},{"name":"$sstart","containerName":null,"line":384,"kind":13},{"name":"$send","containerName":null,"kind":13,"line":385},{"name":"$score","containerName":null,"kind":13,"line":386},{"containerName":null,"name":"%tags","line":389,"kind":13},{"line":392,"kind":13,"localvar":"my","name":"$formatter","definition":"my","containerName":null},{"name":"Bio","containerName":"Tools::GFF","line":392,"kind":12},{"name":"new","containerName":"main::","line":392,"kind":12},{"kind":13,"line":392,"containerName":null,"name":"$format"},{"containerName":null,"name":"$GFF","kind":13,"line":393},{"kind":13,"line":393,"name":"$feat","containerName":null},{"line":393,"kind":12,"containerName":"main::","name":"gff_string"},{"name":"$formatter","containerName":null,"line":393,"kind":13},{"line":396,"kind":13,"name":"$GFF","containerName":null},{"kind":12,"line":399,"children":[{"kind":13,"line":400,"containerName":"significance_filter","definition":"my","name":"$self","localvar":"my"},{"name":"$method","containerName":"significance_filter","kind":13,"line":400},{"containerName":"significance_filter","name":"$code","kind":13,"line":400},{"line":401,"kind":13,"name":"$method","containerName":"significance_filter"},{"name":"$method","containerName":"significance_filter","kind":13,"line":402},{"name":"$method","containerName":"significance_filter","line":402,"kind":13},{"line":403,"kind":13,"name":"$method","containerName":"significance_filter"},{"containerName":"significance_filter","name":"$method","kind":13,"line":404},{"name":"$method","containerName":"significance_filter","line":405,"kind":13},{"name":"$self","containerName":"significance_filter","line":406,"kind":13},{"kind":12,"line":406,"containerName":"significance_filter","name":"warn"},{"kind":13,"line":409,"name":"$code","containerName":"significance_filter"},{"kind":13,"line":410,"containerName":"significance_filter","name":"$self"},{"line":410,"kind":12,"name":"throw","containerName":"significance_filter"},{"kind":13,"line":410,"containerName":"significance_filter","name":"$code"},{"line":411,"kind":13,"name":"$self","containerName":"significance_filter"},{"name":"$method","containerName":"significance_filter","line":411,"kind":13},{"line":411,"kind":13,"name":"$code","containerName":"significance_filter"},{"containerName":"significance_filter","name":"$self","kind":13,"line":413},{"containerName":"significance_filter","name":"$method","line":413,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$method,$code)","signature":{"parameters":[{"label":"$self"},{"label":"$method"},{"label":"$code"}],"documentation":"","label":"significance_filter($self,$method,$code)"},"name":"significance_filter","range":{"end":{"line":414,"character":9999},"start":{"line":399,"character":0}}},{"range":{"start":{"character":0,"line":426},"end":{"character":9999,"line":426}},"containerName":"main::","definition":"sub","name":"start_report","line":426,"children":[],"kind":12},{"kind":12,"children":[],"line":439,"name":"end_report","definition":"sub","containerName":"main::","range":{"end":{"line":439,"character":9999},"start":{"character":0,"line":439}}}],"version":5}