{"vars":[{"kind":2,"line":84,"containerName":"","name":"vars"},{"containerName":"","name":"base","line":92,"kind":2},{"kind":13,"line":97,"name":"$DEFAULT_INCLUSION_THRESHOLD","containerName":null},{"containerName":null,"name":"$MAX_HSP_OVERLAP","kind":13,"line":100},{"range":{"start":{"line":128,"character":0},"end":{"character":9999,"line":165}},"name":"new","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#------------------------------------------------------------------\n# $Id: IteratedSearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::IteratedSearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org> and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n#------------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::IteratedSearchResultEventBuilder - Event Handler for\nSearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nParts of code based on SearchResultEventBuilder by Jason Stajich\njason@bioperl.org\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS             $DEFAULT_INCLUSION_THRESHOLD\n            $MAX_HSP_OVERLAP\n);\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SearchIO::SearchResultEventBuilder);\n\n# e-value threshold for inclusion in the PSI-BLAST score matrix model (blastpgp)\n# NOTE: Executing `blastpgp -` incorrectly reports that the default is 0.005.\n#       (version 2.2.2 [Jan-08-2002])\n$DEFAULT_INCLUSION_THRESHOLD = 0.001;\n\n\n$MAX_HSP_OVERLAP  = 2;  # Used when tiling multiple HSPs.\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::IteratedSearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::IteratedSearchResultEventBuilder object \n Returns : Bio::SearchIO::IteratedSearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n           -iteration_factory => Bio::Factory::ObjectFactoryI\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n\n\nSee L<Bio::SearchIO::SearchResultEventBuilder> for more information","label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":128,"children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":129},{"name":"@args","containerName":"new","line":129,"kind":13},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":130},{"kind":13,"line":130,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":130},{"line":131,"kind":13,"localvar":"my","containerName":"new","name":"$hitF","definition":"my"},{"name":"$resultF","containerName":"new","kind":13,"line":131},{"name":"$hspF","containerName":"new","line":131,"kind":13},{"name":"$iterationF","containerName":"new","kind":13,"line":131},{"kind":13,"line":132,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":132},{"kind":13,"line":138,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":140},{"line":140,"kind":12,"name":"_init_parse_params","containerName":"new"},{"kind":13,"line":140,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":144},{"line":144,"kind":12,"containerName":"new","name":"register_factory"},{"name":"$resultF","containerName":"new","line":144,"kind":13},{"name":"new","containerName":"new","line":145,"kind":12},{"kind":13,"line":149,"name":"$self","containerName":"new"},{"containerName":"new","name":"register_factory","line":149,"kind":12},{"containerName":"new","name":"$hitF","kind":13,"line":149},{"containerName":"new","name":"new","line":150,"kind":12},{"line":154,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"register_factory","line":154,"kind":12},{"line":154,"kind":13,"containerName":"new","name":"$hspF"},{"kind":12,"line":155,"name":"new","containerName":"new"},{"kind":13,"line":160,"name":"$self","containerName":"new"},{"kind":12,"line":160,"containerName":"new","name":"register_factory"},{"line":160,"kind":13,"name":"$iterationF","containerName":"new"},{"name":"new","containerName":"new","kind":12,"line":161},{"kind":13,"line":164,"name":"$self","containerName":"new"}],"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":130},{"name":"Bio","containerName":"Factory::ObjectFactory","line":145,"kind":12},{"kind":12,"line":150,"containerName":"Factory::ObjectFactory","name":"Bio"},{"containerName":"Factory::ObjectFactory","name":"Bio","kind":12,"line":155},{"kind":12,"line":161,"containerName":"Factory::ObjectFactory","name":"Bio"},{"definition":"sub","containerName":"main::","signature":{"label":"_init_parse_params($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","kind":12,"children":[{"containerName":"_init_parse_params","definition":"my","name":"$self","localvar":"my","kind":13,"line":171},{"line":171,"kind":13,"containerName":"_init_parse_params","name":"@args"},{"definition":"my","name":"$ithresh","containerName":"_init_parse_params","localvar":"my","kind":13,"line":174},{"line":174,"kind":13,"containerName":"_init_parse_params","name":"$signif"},{"kind":13,"line":174,"containerName":"_init_parse_params","name":"$score"},{"containerName":"_init_parse_params","name":"$bits","line":174,"kind":13},{"name":"$hit_filter","containerName":"_init_parse_params","kind":13,"line":174},{"line":174,"kind":13,"name":"$filt_func","containerName":"_init_parse_params"},{"line":175,"kind":13,"containerName":"_init_parse_params","name":"$self"},{"line":175,"kind":12,"containerName":"_init_parse_params","name":"_rearrange"},{"containerName":"_init_parse_params","name":"@args","line":177,"kind":13},{"kind":13,"line":179,"containerName":"_init_parse_params","name":"$self"},{"kind":12,"line":179,"containerName":"_init_parse_params","name":"inclusion_threshold"},{"name":"$ithresh","containerName":"_init_parse_params","line":179,"kind":13},{"kind":13,"line":179,"name":"$ithresh","containerName":"_init_parse_params"},{"line":179,"kind":13,"name":"$DEFAULT_INCLUSION_THRESHOLD","containerName":"_init_parse_params"},{"line":180,"kind":13,"localvar":"my","containerName":"_init_parse_params","definition":"my","name":"$hit_filt"},{"line":180,"kind":13,"name":"$hit_filter","containerName":"_init_parse_params"},{"containerName":"_init_parse_params","name":"$filt_func","line":180,"kind":13},{"kind":13,"line":181,"containerName":"_init_parse_params","name":"$hit_filter"},{"name":"$self","containerName":"_init_parse_params","kind":13,"line":181},{"kind":12,"line":181,"name":"hit_filter","containerName":"_init_parse_params"},{"name":"$hit_filt","containerName":"_init_parse_params","kind":13,"line":181},{"name":"$signif","containerName":"_init_parse_params","kind":13,"line":182},{"kind":13,"line":182,"containerName":"_init_parse_params","name":"$self"},{"kind":12,"line":182,"name":"max_significance","containerName":"_init_parse_params"},{"kind":13,"line":182,"name":"$signif","containerName":"_init_parse_params"},{"containerName":"_init_parse_params","name":"$score","line":183,"kind":13},{"name":"$self","containerName":"_init_parse_params","kind":13,"line":183},{"kind":12,"line":183,"name":"min_score","containerName":"_init_parse_params"},{"containerName":"_init_parse_params","name":"$score","kind":13,"line":183},{"kind":13,"line":184,"name":"$bits","containerName":"_init_parse_params"},{"kind":13,"line":184,"name":"$self","containerName":"_init_parse_params"},{"line":184,"kind":12,"name":"min_bits","containerName":"_init_parse_params"},{"name":"$bits","containerName":"_init_parse_params","kind":13,"line":184}],"line":169,"name":"_init_parse_params","range":{"end":{"character":9999,"line":185},"start":{"character":0,"line":169}}},{"line":198,"children":[{"localvar":"my","containerName":"will_handle","name":"$self","definition":"my","line":199,"kind":13},{"kind":13,"line":199,"name":"$type","containerName":"will_handle"},{"kind":13,"line":201,"name":"$type","containerName":"will_handle"},{"kind":13,"line":201,"name":"$type","containerName":"will_handle"},{"containerName":"will_handle","name":"$type","line":201,"kind":13},{"line":201,"kind":13,"name":"$type","containerName":"will_handle"},{"containerName":"will_handle","name":"$type","kind":13,"line":202},{"name":"$type","containerName":"will_handle","line":202,"kind":13}],"kind":12,"detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"","label":"will_handle($self,$type)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":198},"end":{"character":9999,"line":203}},"name":"will_handle"},{"range":{"start":{"character":0,"line":219},"end":{"character":9999,"line":228}},"definition":"sub","name":"start_result","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_result","line":220,"kind":13},{"containerName":"start_result","name":"$self","kind":13,"line":222},{"kind":13,"line":223,"name":"$self","containerName":"start_result"},{"line":224,"kind":13,"name":"$self","containerName":"start_result"},{"line":225,"kind":13,"containerName":"start_result","name":"$self"},{"line":226,"kind":13,"name":"$self","containerName":"start_result"}],"line":219,"kind":12},{"name":"SUPER","containerName":"start_result","kind":12,"line":222},{"name":"end_result","range":{"start":{"character":0,"line":240},"end":{"character":9999,"line":263}},"definition":"sub","containerName":"main::","signature":{"label":"end_result($self,$type,$data)","documentation":"","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"detail":"($self,$type,$data)","kind":12,"children":[{"containerName":"end_result","definition":"my","name":"$self","localvar":"my","kind":13,"line":241},{"line":241,"kind":13,"containerName":"end_result","name":"$type"},{"name":"$data","containerName":"end_result","line":241,"kind":13},{"containerName":"end_result","name":"$data","kind":13,"line":244},{"containerName":"end_result","name":"$data","line":245,"kind":13},{"name":"$data","containerName":"end_result","line":247,"kind":13},{"kind":13,"line":248,"containerName":"end_result","name":"$data"},{"kind":13,"line":248,"containerName":"end_result","name":"$data"},{"containerName":"end_result","name":"$data","line":250,"kind":13},{"line":250,"kind":13,"name":"$data","containerName":"end_result"},{"line":251,"kind":13,"containerName":"end_result","name":"$data"},{"name":"@a","definition":"my","containerName":"end_result","localvar":"my","kind":13,"line":254},{"containerName":"end_result","name":"$data","line":254,"kind":13},{"kind":13,"line":255,"definition":"my","name":"$acc","containerName":"end_result","localvar":"my"},{"line":255,"kind":13,"name":"@a","containerName":"end_result"},{"kind":13,"line":257,"name":"$acc","containerName":"end_result"},{"containerName":"end_result","name":"@a","kind":13,"line":257},{"containerName":"end_result","name":"$acc","line":257,"kind":13},{"containerName":"end_result","name":"$acc","line":257,"kind":13},{"line":258,"kind":13,"containerName":"end_result","name":"$data"},{"line":258,"kind":13,"containerName":"end_result","name":"$acc"},{"containerName":"end_result","name":"$data","kind":13,"line":260},{"localvar":"my","name":"%args","definition":"my","containerName":"end_result","line":262,"kind":13},{"line":262,"kind":13,"localvar":"my","name":"$v","definition":"my","containerName":"end_result"},{"line":262,"kind":13,"containerName":"end_result","name":"$data"},{"line":262,"kind":13,"name":"$v","containerName":"end_result"},{"kind":13,"line":263,"name":"$data","containerName":"end_result"}],"line":240},{"containerName":null,"name":"%args","line":265,"kind":13},{"kind":13,"line":265,"name":"%args","containerName":null},{"name":"%data","containerName":null,"kind":13,"line":266},{"line":266,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"line":268,"containerName":null,"name":"%args"},{"containerName":null,"name":"%self","kind":13,"line":268},{"line":270,"kind":13,"localvar":"my","name":"$result","definition":"my","containerName":null},{"kind":13,"line":270,"containerName":null,"name":"$self"},{"containerName":"main::","name":"factory","line":270,"kind":12},{"kind":12,"line":270,"name":"create_object","containerName":"main::"},{"containerName":null,"name":"%args","kind":13,"line":270},{"kind":13,"line":271,"name":"$result","containerName":null},{"line":271,"kind":12,"name":"hit_factory","containerName":"main::"},{"name":"$self","containerName":null,"line":271,"kind":13},{"containerName":"main::","name":"factory","kind":12,"line":271},{"line":272,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":273,"containerName":null,"name":"$result"},{"children":[{"localvar":"my","containerName":"_add_hit","name":"$self","definition":"my","line":282,"kind":13},{"containerName":"_add_hit","name":"$hit","line":282,"kind":13},{"localvar":"my","containerName":"_add_hit","name":"$hit_name","definition":"my","line":284,"kind":13},{"name":"$hit","containerName":"_add_hit","kind":13,"line":284},{"containerName":"_add_hit","definition":"my","name":"$hit_signif","localvar":"my","kind":13,"line":285},{"line":285,"kind":13,"containerName":"_add_hit","name":"$hit"},{"line":286,"kind":13,"localvar":"my","containerName":"_add_hit","name":"$ithresh","definition":"my"},{"line":286,"kind":13,"containerName":"_add_hit","name":"$self"},{"kind":13,"line":289,"name":"$add_hit","definition":"my","containerName":"_add_hit","localvar":"my"},{"containerName":"_add_hit","definition":"my","name":"$hit_filter","localvar":"my","kind":13,"line":291},{"name":"$self","containerName":"_add_hit","line":291,"kind":13},{"name":"$hit_filter","containerName":"_add_hit","line":293,"kind":13},{"kind":13,"line":296,"name":"$hit","containerName":"_add_hit"},{"name":"$self","containerName":"_add_hit","line":296,"kind":13},{"name":"factory","containerName":"_add_hit","line":296,"kind":12},{"name":"create_object","containerName":"_add_hit","line":296,"kind":12},{"kind":13,"line":296,"containerName":"_add_hit","name":"$hit"},{"name":"$add_hit","containerName":"_add_hit","kind":13,"line":297},{"kind":13,"line":297,"containerName":"_add_hit","name":"$hit"}],"line":281,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$hit"}],"label":"_add_hit($self,$hit)"},"detail":"($self,$hit)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":281},"end":{"line":298,"character":9999}},"name":"_add_hit"},{"name":"hit_filter","line":297,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":299},{"kind":13,"line":300,"containerName":null,"name":"$add_hit"},{"name":"$hit_signif","containerName":null,"line":300,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":300},{"containerName":null,"name":"%self","kind":13,"line":302},{"kind":13,"line":303,"definition":"my","name":"$hit_score","containerName":null,"localvar":"my"},{"line":303,"kind":13,"name":"%hit","containerName":null},{"name":"%hit","containerName":null,"kind":13,"line":303},{"kind":13,"line":304,"containerName":null,"name":"$add_hit"},{"name":"$hit_score","containerName":null,"line":304,"kind":13},{"kind":13,"line":304,"name":"%self","containerName":null},{"line":306,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$hit_bits","definition":"my","localvar":"my","kind":13,"line":307},{"name":"%hit","containerName":null,"kind":13,"line":307},{"kind":13,"line":307,"name":"%hit","containerName":null},{"line":308,"kind":13,"name":"$add_hit","containerName":null},{"kind":13,"line":308,"containerName":null,"name":"$hit_bits"},{"kind":13,"line":308,"name":"%self","containerName":null},{"kind":13,"line":312,"containerName":null,"name":"$add_hit"},{"containerName":null,"name":"$self","line":312,"kind":13},{"line":312,"kind":12,"name":"_store_hit","containerName":"main::"},{"kind":13,"line":312,"name":"$hit","containerName":null},{"kind":13,"line":312,"name":"$hit_name","containerName":null},{"name":"$hit_signif","containerName":null,"line":312,"kind":13},{"line":315,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":315,"containerName":null,"name":"$hit_name"},{"containerName":null,"name":"%self","kind":13,"line":316},{"kind":13,"line":316,"containerName":null,"name":"$hit_name"},{"name":"$hit_signif","containerName":null,"kind":13,"line":316},{"kind":13,"line":316,"containerName":null,"name":"$ithresh"},{"name":"_store_hit","range":{"start":{"character":0,"line":347},"end":{"character":9999,"line":359}},"kind":12,"line":347,"children":[{"line":348,"kind":13,"localvar":"my","containerName":"_store_hit","definition":"my","name":"$self"},{"kind":13,"line":348,"containerName":"_store_hit","name":"$hit"},{"name":"$hit_name","containerName":"_store_hit","line":348,"kind":13},{"name":"$hit_signif","containerName":"_store_hit","line":348,"kind":13},{"localvar":"my","definition":"my","name":"$ithresh","containerName":"_store_hit","line":350,"kind":13},{"line":350,"kind":13,"containerName":"_store_hit","name":"$self"},{"name":"$self","containerName":"_store_hit","line":358,"kind":13},{"line":358,"kind":13,"name":"$hit_name","containerName":"_store_hit"},{"kind":13,"line":359,"name":"$self","containerName":"_store_hit"}],"containerName":"main::","definition":"sub","detail":"($self,$hit,$hit_name,$hit_signif)","signature":{"parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$hit_name"},{"label":"$hit_signif"}],"documentation":"","label":"_store_hit($self,$hit,$hit_name,$hit_signif)"}},{"name":"_iterations","line":359,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":360},{"containerName":null,"name":"%hit_name","line":360,"kind":13},{"containerName":null,"name":"%self","line":361,"kind":13},{"containerName":null,"name":"$hit","kind":13,"line":361},{"kind":13,"line":362,"name":"$hit_signif","containerName":null},{"containerName":null,"name":"%ithresh","line":362,"kind":13},{"containerName":null,"name":"%self","line":363,"kind":13},{"name":"%hit","containerName":null,"line":363,"kind":13},{"name":"%self","containerName":null,"line":365,"kind":13},{"line":365,"kind":13,"containerName":null,"name":"%hit"},{"name":"$hit_signif","containerName":null,"kind":13,"line":368},{"name":"%ithresh","containerName":null,"kind":13,"line":368},{"name":"%self","containerName":null,"kind":13,"line":369},{"kind":13,"line":369,"name":"%hit","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":371},{"containerName":null,"name":"$hit","line":371,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":374},{"name":"start_iteration","range":{"end":{"line":402,"character":9999},"start":{"line":387,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"start_iteration($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":""},"detail":"($self,$type)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"start_iteration","localvar":"my","kind":13,"line":388},{"containerName":"start_iteration","name":"$type","line":388,"kind":13},{"containerName":"start_iteration","name":"$self","line":391,"kind":13},{"name":"$self","containerName":"start_iteration","kind":13,"line":395},{"containerName":"start_iteration","name":"$self","line":396,"kind":13},{"name":"$self","containerName":"start_iteration","kind":13,"line":397},{"line":398,"kind":13,"name":"$self","containerName":"start_iteration"},{"name":"$self","containerName":"start_iteration","line":399,"kind":13},{"line":400,"kind":13,"name":"$self","containerName":"start_iteration"}],"line":387},{"range":{"start":{"character":0,"line":416},"end":{"line":422,"character":9999}},"name":"end_iteration","line":416,"children":[{"line":417,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"end_iteration"},{"line":417,"kind":13,"name":"$type","containerName":"end_iteration"},{"kind":13,"line":417,"name":"$data","containerName":"end_iteration"},{"line":421,"kind":13,"localvar":"my","definition":"my","name":"%args","containerName":"end_iteration"},{"kind":13,"line":421,"containerName":"end_iteration","name":"$v","definition":"my","localvar":"my"},{"containerName":"end_iteration","name":"$data","kind":13,"line":421},{"name":"$v","containerName":"end_iteration","line":421,"kind":13},{"name":"$data","containerName":"end_iteration","kind":13,"line":422}],"kind":12,"detail":"($self,$type,$data)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"label":"end_iteration($self,$type,$data)"},"containerName":"main::","definition":"sub"},{"name":"%args","containerName":null,"kind":13,"line":424},{"name":"%self","containerName":null,"line":424,"kind":13},{"containerName":null,"name":"%args","line":425,"kind":13},{"containerName":null,"name":"%self","line":425,"kind":13},{"line":426,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"line":426,"name":"%self","containerName":null},{"kind":13,"line":427,"name":"%args","containerName":null},{"line":427,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":428,"name":"%args","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":428},{"containerName":null,"name":"%args","line":429,"kind":13},{"containerName":null,"name":"%self","line":429,"kind":13},{"line":430,"kind":13,"containerName":null,"name":"%args"},{"name":"$self","containerName":null,"line":430,"kind":13},{"line":430,"kind":12,"containerName":"main::","name":"factory"},{"localvar":"my","containerName":null,"definition":"my","name":"$it","line":432,"kind":13},{"line":432,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"factory","line":432,"kind":12},{"containerName":"main::","name":"create_object","kind":12,"line":432},{"line":432,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"line":433,"name":"%self","containerName":null},{"name":"$it","containerName":null,"kind":13,"line":433},{"containerName":null,"name":"$it","kind":13,"line":434},{"containerName":"main::","definition":"sub","name":"max_significance","range":{"start":{"character":0,"line":453},"end":{"character":9999,"line":467}},"kind":12,"line":453,"children":[{"definition":"my","name":"$self","containerName":"max_significance","localvar":"my","kind":13,"line":454},{"kind":13,"line":456,"containerName":"max_significance","name":"$sig","definition":"my","localvar":"my"},{"line":457,"kind":13,"containerName":"max_significance","name":"$sig"},{"kind":13,"line":457,"name":"$sig","containerName":"max_significance"},{"kind":13,"line":458,"name":"$self","containerName":"max_significance"},{"containerName":"max_significance","name":"throw","kind":12,"line":458},{"containerName":"max_significance","name":"$sig","line":461,"kind":13},{"line":463,"kind":13,"name":"$self","containerName":"max_significance"},{"containerName":"max_significance","name":"$self","kind":13,"line":464},{"containerName":"max_significance","name":"$sig","line":464,"kind":13},{"line":466,"kind":13,"containerName":"max_significance","name":"$self"}]},{"kind":12,"line":476,"children":[{"containerName":"signif","name":"max_significance","line":476,"kind":12}],"containerName":"main::","definition":"sub","name":"signif","range":{"start":{"character":0,"line":476},"end":{"character":9999,"line":476}}},{"containerName":"main::","definition":"sub","name":"min_score","range":{"start":{"character":0,"line":493},"end":{"line":507,"character":9999}},"kind":12,"line":493,"children":[{"kind":13,"line":494,"containerName":"min_score","definition":"my","name":"$self","localvar":"my"},{"name":"$score","definition":"my","containerName":"min_score","localvar":"my","kind":13,"line":496},{"line":497,"kind":13,"containerName":"min_score","name":"$score"},{"line":497,"kind":13,"containerName":"min_score","name":"$score"},{"containerName":"min_score","name":"$self","kind":13,"line":498},{"kind":12,"line":498,"name":"throw","containerName":"min_score"},{"kind":13,"line":501,"containerName":"min_score","name":"$score"},{"kind":13,"line":503,"name":"$self","containerName":"min_score"},{"name":"$self","containerName":"min_score","line":504,"kind":13},{"name":"$score","containerName":"min_score","kind":13,"line":504},{"name":"$self","containerName":"min_score","kind":13,"line":506}]},{"containerName":"main::","name":"min_bits","definition":"sub","range":{"end":{"line":539,"character":9999},"start":{"line":525,"character":0}},"kind":12,"line":525,"children":[{"kind":13,"line":526,"definition":"my","name":"$self","containerName":"min_bits","localvar":"my"},{"line":528,"kind":13,"localvar":"my","name":"$bits","definition":"my","containerName":"min_bits"},{"kind":13,"line":529,"name":"$bits","containerName":"min_bits"},{"containerName":"min_bits","name":"$bits","kind":13,"line":529},{"line":530,"kind":13,"containerName":"min_bits","name":"$self"},{"name":"throw","containerName":"min_bits","line":530,"kind":12},{"name":"$bits","containerName":"min_bits","kind":13,"line":533},{"kind":13,"line":535,"name":"$self","containerName":"min_bits"},{"name":"$self","containerName":"min_bits","line":536,"kind":13},{"name":"$bits","containerName":"min_bits","kind":13,"line":536},{"kind":13,"line":538,"containerName":"min_bits","name":"$self"}]},{"name":"hit_filter","definition":"sub","containerName":"main::","range":{"start":{"line":555,"character":0},"end":{"character":9999,"line":568}},"kind":12,"children":[{"localvar":"my","containerName":"hit_filter","definition":"my","name":"$self","line":556,"kind":13},{"name":"$func","definition":"my","containerName":"hit_filter","localvar":"my","kind":13,"line":558},{"line":559,"kind":13,"name":"$func","containerName":"hit_filter"},{"line":560,"kind":13,"containerName":"hit_filter","name":"$self"},{"name":"throw","containerName":"hit_filter","kind":12,"line":560},{"line":563,"kind":13,"name":"$func","containerName":"hit_filter"},{"containerName":"hit_filter","name":"$self","line":565,"kind":13},{"line":565,"kind":13,"containerName":"hit_filter","name":"$func"},{"kind":13,"line":567,"containerName":"hit_filter","name":"$self"}],"line":555},{"containerName":"main::","name":"inclusion_threshold","definition":"sub","range":{"start":{"line":576,"character":0},"end":{"line":580,"character":9999}},"kind":12,"line":576,"children":[{"containerName":"inclusion_threshold","definition":"my","name":"$self","localvar":"my","kind":13,"line":577},{"containerName":"inclusion_threshold","name":"$self","line":578,"kind":13},{"containerName":"inclusion_threshold","name":"$self","kind":13,"line":579}]}],"version":5}