{"version":5,"vars":[{"containerName":"","name":"vars","kind":2,"line":93},{"containerName":"","name":"base","line":100,"kind":2},{"range":{"start":{"line":115,"character":0},"end":{"line":131,"character":9999}},"name":"new","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":116,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"@args","containerName":"new","line":116,"kind":13},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":117,"kind":13},{"containerName":"new","name":"$class","line":117,"kind":13},{"line":117,"kind":13,"name":"@args","containerName":"new"},{"line":118,"kind":13,"localvar":"my","definition":"my","name":"$hitF","containerName":"new"},{"line":118,"kind":13,"containerName":"new","name":"$resultF"},{"kind":13,"line":118,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":118},{"line":119,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":120},{"name":"register_factory","containerName":"new","line":120,"kind":12},{"containerName":"new","name":"$hitF","line":120,"kind":13},{"containerName":"new","name":"new","kind":12,"line":121},{"kind":13,"line":125,"containerName":"new","name":"$self"},{"kind":12,"line":125,"containerName":"new","name":"register_factory"},{"name":"$resultF","containerName":"new","kind":13,"line":125},{"kind":12,"line":126,"containerName":"new","name":"new"},{"name":"$self","containerName":"new","line":130,"kind":13}],"line":115,"kind":12},{"kind":12,"line":117,"containerName":"new","name":"SUPER"},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":121},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":126},{"range":{"end":{"character":9999,"line":150},"start":{"character":0,"line":146}},"name":"will_handle","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"will_handle","line":147,"kind":13},{"kind":13,"line":147,"name":"$type","containerName":"will_handle"},{"name":"$type","containerName":"will_handle","line":149,"kind":13},{"line":149,"kind":13,"name":"$type","containerName":"will_handle"}],"line":146,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name","label":"will_handle($self,$type)"},"detail":"($self,$type)","definition":"sub","containerName":"main::"},{"children":[{"name":"$self","definition":"my","containerName":"start_result","localvar":"my","kind":13,"line":167},{"line":167,"kind":13,"containerName":"start_result","name":"$type"},{"line":168,"kind":13,"name":"$self","containerName":"start_result"},{"line":168,"kind":13,"name":"$type","containerName":"start_result"},{"kind":13,"line":169,"name":"$self","containerName":"start_result"}],"line":166,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report","label":"start_result($self,$type)"},"detail":"($self,$type)","definition":"sub","containerName":"main::","range":{"end":{"line":171,"character":9999},"start":{"line":166,"character":0}},"name":"start_result"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"end_result","line":183,"kind":13},{"name":"$type","containerName":"end_result","line":183,"kind":13},{"line":183,"kind":13,"name":"$data","containerName":"end_result"},{"kind":13,"line":184,"name":"$data","containerName":"end_result"},{"name":"$data","containerName":"end_result","kind":13,"line":185},{"containerName":"end_result","name":"$data","kind":13,"line":187},{"containerName":"end_result","name":"$data","line":188,"kind":13},{"containerName":"end_result","name":"$data","line":188,"kind":13},{"kind":13,"line":190,"name":"$data","containerName":"end_result"},{"kind":13,"line":190,"name":"$data","containerName":"end_result"},{"containerName":"end_result","name":"$data","kind":13,"line":190},{"localvar":"my","containerName":"end_result","name":"@a","definition":"my","line":193,"kind":13},{"name":"$data","containerName":"end_result","line":193,"kind":13},{"name":"$acc","definition":"my","containerName":"end_result","localvar":"my","kind":13,"line":194},{"line":194,"kind":13,"name":"@a","containerName":"end_result"},{"kind":13,"line":196,"name":"$acc","containerName":"end_result"},{"containerName":"end_result","name":"@a","kind":13,"line":196},{"containerName":"end_result","name":"$acc","line":196,"kind":13},{"name":"$acc","containerName":"end_result","line":196,"kind":13},{"kind":13,"line":197,"containerName":"end_result","name":"$data"},{"line":197,"kind":13,"name":"$acc","containerName":"end_result"},{"line":199,"kind":13,"containerName":"end_result","name":"$data"},{"line":201,"kind":13,"localvar":"my","name":"%args","definition":"my","containerName":"end_result"},{"kind":13,"line":201,"containerName":"end_result","definition":"my","name":"$v","localvar":"my"},{"containerName":"end_result","name":"$data","line":201,"kind":13},{"kind":13,"line":201,"name":"$v","containerName":"end_result"},{"name":"$data","containerName":"end_result","line":202,"kind":13}],"line":182,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none","label":"end_result($self,$type,$data)"},"detail":"($self,$type,$data)","name":"end_result","range":{"end":{"character":9999,"line":202},"start":{"line":182,"character":0}}},{"kind":13,"line":204,"name":"%args","containerName":null},{"line":204,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"line":204,"name":"$type","containerName":null},{"kind":13,"line":205,"name":"%args","containerName":null},{"line":205,"kind":13,"name":"%self","containerName":null},{"name":"$result","definition":"my","containerName":null,"localvar":"my","kind":13,"line":206},{"kind":13,"line":206,"name":"$self","containerName":null},{"kind":12,"line":206,"name":"factory","containerName":"main::"},{"containerName":"main::","name":"create","kind":12,"line":206},{"containerName":null,"name":"%args","kind":13,"line":206},{"containerName":null,"name":"%self","kind":13,"line":207},{"name":"$result","containerName":null,"kind":13,"line":208},{"range":{"end":{"character":9999,"line":225},"start":{"character":0,"line":222}},"name":"start_hit","detail":"($self,$type)","signature":{"label":"start_hit($self,$type)","documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"}]},"containerName":"main::","definition":"sub","line":222,"children":[{"containerName":"start_hit","name":"$self","definition":"my","localvar":"my","kind":13,"line":223},{"name":"$type","containerName":"start_hit","kind":13,"line":223}],"kind":12},{"range":{"start":{"character":0,"line":239},"end":{"character":9999,"line":241}},"name":"end_hit","children":[{"line":240,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"end_hit"},{"containerName":"end_hit","name":"$type","kind":13,"line":240},{"kind":13,"line":240,"containerName":"end_hit","name":"$data"},{"kind":13,"line":241,"definition":"my","name":"%args","containerName":"end_hit","localvar":"my"},{"line":241,"kind":13,"localvar":"my","definition":"my","name":"$v","containerName":"end_hit"},{"name":"$data","containerName":"end_hit","line":241,"kind":13},{"kind":13,"line":241,"name":"$v","containerName":"end_hit"},{"line":241,"kind":13,"name":"$data","containerName":"end_hit"}],"line":239,"kind":12,"signature":{"label":"end_hit($self,$type,$data)","documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"detail":"($self,$type,$data)","definition":"sub","containerName":"main::"},{"name":"%args","containerName":null,"line":242,"kind":13},{"kind":13,"line":242,"containerName":null,"name":"%args"},{"name":"$type","containerName":null,"line":242,"kind":13},{"kind":13,"line":243,"name":"%args","containerName":null},{"name":"%data","containerName":null,"line":243,"kind":13},{"containerName":null,"definition":"my","name":"$hitrank","localvar":"my","kind":13,"line":244},{"line":244,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":245,"containerName":null,"name":"%args"},{"name":"$hitrank","containerName":null,"kind":13,"line":245},{"localvar":"my","name":"$hit","definition":"my","containerName":null,"line":246,"kind":13},{"line":246,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"factory","line":246,"kind":12},{"kind":12,"line":246,"containerName":"main::","name":"create"},{"kind":13,"line":246,"containerName":null,"name":"%args"},{"containerName":null,"name":"%self","kind":13,"line":247},{"line":247,"kind":13,"name":"$hit","containerName":null},{"line":248,"kind":13,"name":"%self","containerName":null},{"line":249,"kind":13,"containerName":null,"name":"$hit"},{"name":"register_factory","range":{"end":{"line":276,"character":9999},"start":{"line":269,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$f"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    my ($hitrank) = scalar @{$self->{'_hits'}} + 1;\n    $args{'-rank'} = $hitrank;\n    my $hit = $self->factory('hit')->create(%args);\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","label":"register_factory($self,$type,$f)"},"detail":"($self,$type,$f)","kind":12,"children":[{"line":270,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"register_factory"},{"line":270,"kind":13,"name":"$type","containerName":"register_factory"},{"line":270,"kind":13,"containerName":"register_factory","name":"$f"},{"line":271,"kind":13,"containerName":"register_factory","name":"$f"},{"name":"$f","containerName":"register_factory","line":271,"kind":13},{"name":"$f","containerName":"register_factory","line":272,"kind":13},{"kind":12,"line":272,"name":"isa","containerName":"register_factory"},{"line":273,"kind":13,"name":"$self","containerName":"register_factory"},{"name":"throw","containerName":"register_factory","kind":12,"line":273},{"containerName":"register_factory","name":"$f","line":273,"kind":13},{"name":"$self","containerName":"register_factory","kind":13,"line":275},{"kind":13,"line":275,"name":"$type","containerName":"register_factory"},{"line":275,"kind":13,"name":"$f","containerName":"register_factory"}],"line":269},{"kind":12,"line":291,"children":[{"line":292,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"factory"},{"kind":13,"line":292,"name":"$type","containerName":"factory"},{"line":293,"kind":13,"name":"$self","containerName":"factory"},{"line":293,"kind":13,"containerName":"factory","name":"$type"},{"line":293,"kind":13,"name":"$self","containerName":"factory"},{"name":"throw","containerName":"factory","line":293,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"factory($self,$type)","documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    my ($hitrank) = scalar @{$self->{'_hits'}} + 1;\n    $args{'-rank'} = $hitrank;\n    my $hit = $self->factory('hit')->create(%args);\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub register_factory{\n   my ($self, $type,$f) = @_;\n   if( ! defined $f || ! ref($f) || \n       ! $f->isa('Bio::Factory::ObjectFactoryI') ) { \n       $self->throw(\"Cannot set factory to value $f\".ref($f).\"\\n\");\n   }\n   $self->{'_factories'}->{lc($type)} = $f;\n}\n\n\n=head2 factory\n\n Title   : factory\n Usage   : my $f = $handler->factory('TYPE');\n Function: Retrieves the associated factory for requested 'TYPE'\n Returns : a Bio::Factory::ObjectFactoryI or undef if none registered\n Args    : name of factory class to retrieve\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$self"},{"label":"$type"}]},"name":"factory","range":{"end":{"character":9999,"line":294},"start":{"line":291,"character":0}}},{"range":{"start":{"character":0,"line":302},"end":{"character":9999,"line":306}},"containerName":"main::","definition":"sub","name":"inclusion_threshold","line":302,"children":[{"kind":13,"line":303,"containerName":"inclusion_threshold","name":"$self","definition":"my","localvar":"my"},{"line":304,"kind":13,"name":"$self","containerName":"inclusion_threshold"},{"line":305,"kind":13,"containerName":"inclusion_threshold","name":"$self"}],"kind":12}]}