{"vars":[{"containerName":"","name":"base","kind":2,"line":81},{"range":{"end":{"character":9999,"line":96},"start":{"line":93,"character":0}},"name":"start_result","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result","label":"start_result($self)"},"containerName":"main::","definition":"sub","line":93,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start_result","line":94,"kind":13},{"kind":13,"line":95,"name":"$self","containerName":"start_result"},{"name":"throw_not_implemented","containerName":"start_result","line":95,"kind":12}],"kind":12},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"end_result($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"containerName":"end_result","definition":"my","name":"$self","localvar":"my","kind":13,"line":110},{"line":110,"kind":13,"containerName":"end_result","name":"@args"},{"containerName":"end_result","name":"$self","kind":13,"line":111},{"containerName":"end_result","name":"throw_not_implemented","kind":12,"line":111}],"line":109,"name":"end_result","range":{"start":{"line":109,"character":0},"end":{"line":112,"character":9999}}},{"range":{"end":{"character":9999,"line":128},"start":{"character":0,"line":125}},"name":"start_hsp","signature":{"label":"start_hsp($self,@args)","documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_hsp","line":126,"kind":13},{"kind":13,"line":126,"containerName":"start_hsp","name":"@args"},{"kind":13,"line":127,"name":"$self","containerName":"start_hsp"},{"containerName":"start_hsp","name":"throw_not_implemented","kind":12,"line":127}],"line":125,"kind":12},{"kind":12,"children":[{"localvar":"my","containerName":"end_hsp","name":"$self","definition":"my","line":141,"kind":13},{"containerName":"end_hsp","name":"@args","kind":13,"line":141},{"containerName":"end_hsp","name":"$self","kind":13,"line":142},{"kind":12,"line":142,"name":"throw_not_implemented","containerName":"end_hsp"}],"line":140,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref","label":"end_hsp($self,@args)"},"detail":"($self,@args)","name":"end_hsp","range":{"start":{"line":140,"character":0},"end":{"line":143,"character":9999}}},{"range":{"start":{"line":156,"character":0},"end":{"character":9999,"line":159}},"name":"start_hit","line":156,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_hit","line":157,"kind":13},{"line":157,"kind":13,"containerName":"start_hit","name":"@args"},{"kind":13,"line":158,"containerName":"start_hit","name":"$self"},{"containerName":"start_hit","name":"throw_not_implemented","kind":12,"line":159}],"kind":12,"detail":"($self,@args)","signature":{"label":"start_hit($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref"},"containerName":"main::","definition":"sub"},{"children":[{"line":173,"kind":13,"localvar":"my","containerName":"end_hit","definition":"my","name":"$self"},{"line":173,"kind":13,"name":"@args","containerName":"end_hit"},{"name":"$self","containerName":"end_hit","line":174,"kind":13},{"containerName":"end_hit","name":"throw_not_implemented","line":174,"kind":12}],"line":172,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref","label":"end_hit($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":172},"end":{"line":175,"character":9999}},"name":"end_hit"},{"range":{"end":{"line":191,"character":9999},"start":{"line":188,"character":0}},"name":"start_iteration","children":[{"kind":13,"line":189,"definition":"my","name":"$self","containerName":"start_iteration","localvar":"my"},{"kind":13,"line":189,"name":"@args","containerName":"start_iteration"},{"name":"$self","containerName":"start_iteration","line":190,"kind":13},{"line":191,"kind":12,"containerName":"start_iteration","name":"throw_not_implemented"}],"line":188,"kind":12,"signature":{"label":"start_iteration($self,@args)","documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_iteration\n\n Title   : start_iteration\n Usage   : $handler->start_iteration()\n Function: Starts an Iteration event cycle\n Returns : none\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_iteration\n\n Title   : start_iteration\n Usage   : $handler->start_iteration()\n Function: Starts an Iteration event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_iteration {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_iteration\n\n Title   : end_iteration\n Usage   : $handler->end_iteration()\n Function: Ends an Iterationevent cycle\n Returns : Bio::Search::Iteration::IterationI object\n Args    : type of event and associated hashref","label":"end_iteration($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"end_iteration","name":"$self","definition":"my","localvar":"my","kind":13,"line":205},{"kind":13,"line":205,"name":"@args","containerName":"end_iteration"},{"name":"$self","containerName":"end_iteration","line":206,"kind":13},{"line":206,"kind":12,"containerName":"end_iteration","name":"throw_not_implemented"}],"line":204,"kind":12,"range":{"start":{"line":204,"character":0},"end":{"character":9999,"line":207}},"name":"end_iteration"},{"name":"register_factory","range":{"end":{"character":9999,"line":225},"start":{"line":222,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"register_factory($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_iteration\n\n Title   : start_iteration\n Usage   : $handler->start_iteration()\n Function: Starts an Iteration event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_iteration {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_iteration\n\n Title   : end_iteration\n Usage   : $handler->end_iteration()\n Function: Ends an Iterationevent cycle\n Returns : Bio::Search::Iteration::IterationI object\n Args    : type of event and associated hashref\n\n\n\nsub end_iteration {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information"},"kind":12,"line":222,"children":[{"containerName":"register_factory","name":"$self","definition":"my","localvar":"my","kind":13,"line":223},{"name":"@args","containerName":"register_factory","kind":13,"line":223},{"line":224,"kind":13,"name":"$self","containerName":"register_factory"},{"line":224,"kind":12,"containerName":"register_factory","name":"throw_not_implemented"}]},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EventHandlerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::EventHandlerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::EventHandlerI - An abstract Event Handler for Search Result parsing\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is an interface\n# See Bio::SearchIO::SearchResultEventBuilder for an implementation\n\n    use Bio::SearchIO::SearchResultEventBuilder;\n    my $handler = Bio::SearchIO::SearchResultEventBuilder->new();\n\n=head1 DESCRIPTION\n\nThis interface describes the basic methods needed to handle Events\nthrown from parsing a Search Result such as FASTA, BLAST, or HMMer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::EventHandlerI;\nuse strict;\nuse Carp;\n\n\nuse base qw(Bio::Event::EventHandlerI);\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($data)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Result\n\n\nsub start_result {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : $handler->end_result($data)\n Function: Ends a result event cycle\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_result{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($data)\n Function: Start a HSP event cycle\n Returns : none\n Args    : type of element\n           associated hashref\n\n\nsub start_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Ends a HSP event cycle\n Returns : Bio::Search::HSP::HSPI object\n Args    : type of event and associated hashref\n\n\nsub end_hsp{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 start_iteration\n\n Title   : start_iteration\n Usage   : $handler->start_iteration()\n Function: Starts an Iteration event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_iteration {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented\n}\n\n=head2 end_iteration\n\n Title   : end_iteration\n Usage   : $handler->end_iteration()\n Function: Ends an Iterationevent cycle\n Returns : Bio::Search::Iteration::IterationI object\n Args    : type of event and associated hashref\n\n\n\nsub end_iteration {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub register_factory{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 factory\n\n Title   : factory\n Usage   : my $f = $handler->factory('TYPE');\n Function: Retrieves the associated factory for requested 'TYPE'\n Returns : a Bio::Factory::ObjectFactoryI\n Throws  : Bio::Root::BadParameter if none registered for the supplied type\n Args    : name of factory class to retrieve\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","label":"factory($self,@args)"},"kind":12,"line":241,"children":[{"line":242,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"factory"},{"name":"@args","containerName":"factory","line":242,"kind":13},{"containerName":"factory","name":"$self","line":243,"kind":13},{"containerName":"factory","name":"throw_not_implemented","line":243,"kind":12}],"name":"factory","range":{"end":{"character":9999,"line":244},"start":{"line":241,"character":0}}}],"version":5}