{"vars":[{"kind":2,"line":148,"name":"base","containerName":""},{"range":{"end":{"line":229,"character":9999},"start":{"character":0,"line":174}},"name":"new","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":175,"kind":13},{"line":175,"kind":13,"containerName":"new","name":"@args"},{"line":177,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"line":177,"kind":13,"name":"$class","containerName":"new"},{"line":177,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":179},{"name":"$self","containerName":"new","line":180,"kind":13},{"kind":13,"line":181,"name":"$self","containerName":"new"},{"line":181,"kind":12,"name":"new","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":182},{"containerName":"new","name":"new","line":182,"kind":12},{"kind":13,"line":184,"containerName":"new","name":"$qname","definition":"my","localvar":"my"},{"kind":13,"line":184,"containerName":"new","name":"$qacc"},{"name":"$qdesc","containerName":"new","kind":13,"line":184},{"line":184,"kind":13,"name":"$qlen","containerName":"new"},{"containerName":"new","name":"$qgi","line":184,"kind":13},{"name":"$dbname","containerName":"new","kind":13,"line":185},{"kind":13,"line":185,"containerName":"new","name":"$dblet"},{"line":185,"kind":13,"name":"$dbent","containerName":"new"},{"line":185,"kind":13,"containerName":"new","name":"$params"},{"name":"$stats","containerName":"new","kind":13,"line":186},{"name":"$hits","containerName":"new","line":186,"kind":13},{"name":"$algo","containerName":"new","kind":13,"line":186},{"name":"$algo_v","containerName":"new","kind":13,"line":186},{"kind":13,"line":187,"name":"$prog_ref","containerName":"new"},{"line":187,"kind":13,"name":"$algo_r","containerName":"new"},{"kind":13,"line":187,"name":"$hit_factory","containerName":"new"},{"line":187,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":187,"kind":12},{"line":203,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":205,"containerName":"new","name":"$algo_r"},{"line":205,"kind":13,"name":"$prog_ref","containerName":"new"},{"line":206,"kind":13,"name":"$algo","containerName":"new"},{"line":206,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"algorithm","kind":12,"line":206},{"kind":13,"line":206,"containerName":"new","name":"$algo"},{"containerName":"new","name":"$algo_v","kind":13,"line":207},{"kind":13,"line":207,"containerName":"new","name":"$self"},{"containerName":"new","name":"algorithm_version","line":207,"kind":12},{"containerName":"new","name":"$algo_v","line":207,"kind":13},{"line":208,"kind":13,"containerName":"new","name":"$algo_r"},{"kind":13,"line":208,"containerName":"new","name":"$self"},{"line":208,"kind":12,"name":"algorithm_reference","containerName":"new"},{"containerName":"new","name":"$algo_r","line":208,"kind":13},{"name":"$qname","containerName":"new","kind":13,"line":210},{"kind":13,"line":210,"containerName":"new","name":"$self"},{"name":"query_name","containerName":"new","kind":12,"line":210},{"name":"$qname","containerName":"new","kind":13,"line":210},{"name":"$qacc","containerName":"new","kind":13,"line":211},{"line":211,"kind":13,"containerName":"new","name":"$self"},{"line":211,"kind":12,"name":"query_accession","containerName":"new"},{"name":"$qacc","containerName":"new","kind":13,"line":211},{"kind":13,"line":212,"name":"$qdesc","containerName":"new"},{"kind":13,"line":212,"containerName":"new","name":"$self"},{"containerName":"new","name":"query_description","kind":12,"line":212},{"kind":13,"line":212,"containerName":"new","name":"$qdesc"},{"kind":13,"line":213,"containerName":"new","name":"$qlen"},{"line":213,"kind":13,"containerName":"new","name":"$self"},{"line":213,"kind":12,"containerName":"new","name":"query_length"},{"containerName":"new","name":"$qlen","kind":13,"line":213},{"kind":13,"line":214,"name":"$qgi","containerName":"new"},{"kind":13,"line":214,"containerName":"new","name":"$self"},{"kind":12,"line":214,"containerName":"new","name":"query_gi"},{"line":214,"kind":13,"name":"$qgi","containerName":"new"},{"kind":13,"line":215,"containerName":"new","name":"$dbname"},{"name":"$self","containerName":"new","kind":13,"line":215},{"containerName":"new","name":"database_name","kind":12,"line":215},{"containerName":"new","name":"$dbname","kind":13,"line":215},{"containerName":"new","name":"$dblet","kind":13,"line":216},{"name":"$self","containerName":"new","kind":13,"line":216},{"line":216,"kind":12,"containerName":"new","name":"database_letters"},{"kind":13,"line":216,"containerName":"new","name":"$dblet"},{"containerName":"new","name":"$dbent","line":217,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":217},{"containerName":"new","name":"database_entries","line":217,"kind":12},{"kind":13,"line":217,"containerName":"new","name":"$dbent"},{"containerName":"new","name":"$hit_factory","line":219,"kind":13},{"line":219,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":219,"name":"hit_factory","containerName":"new"},{"name":"$hit_factory","containerName":"new","line":219,"kind":13},{"kind":13,"line":221,"name":"$params","containerName":"new"},{"name":"$params","containerName":"new","line":222,"kind":13},{"containerName":"new","name":"$self","line":223,"kind":13},{"containerName":"new","name":"throw","kind":12,"line":223},{"localvar":"my","containerName":"new","name":"$key","definition":"my","line":225,"kind":13},{"containerName":"new","name":"$value","kind":13,"line":225},{"name":"$params","containerName":"new","line":225,"kind":13},{"line":226,"kind":13,"name":"$self","containerName":"new"},{"line":226,"kind":12,"containerName":"new","name":"set_parameter"},{"kind":13,"line":226,"name":"$key","containerName":"new"},{"name":"$value","containerName":"new","kind":13,"line":226}],"line":174,"kind":12},{"line":177,"kind":12,"name":"SUPER","containerName":"new"},{"kind":12,"line":181,"name":"Bio","containerName":"Search::GenericStatistics"},{"name":"Bio","containerName":"Tools::Run::GenericParameters","line":182,"kind":12},{"kind":13,"line":230,"containerName":null,"name":"%stats"},{"name":"%stats","containerName":null,"line":231,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":232},{"line":232,"kind":12,"containerName":"main::","name":"throw"},{"localvar":"my","containerName":null,"definition":"my","name":"$key","line":234,"kind":13},{"kind":13,"line":234,"name":"$value","containerName":null},{"name":"%stats","containerName":null,"line":234,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":235},{"line":235,"kind":12,"containerName":"main::","name":"set_statistic"},{"kind":13,"line":235,"name":"$key","containerName":null},{"containerName":null,"name":"$value","kind":13,"line":235},{"name":"%hits","containerName":null,"kind":13,"line":240},{"containerName":null,"name":"$self","line":241,"kind":13},{"line":241,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$hits","kind":13,"line":241},{"line":243,"kind":13,"localvar":"my","name":"$s","definition":"my","containerName":null},{"name":"%hits","containerName":null,"kind":13,"line":243},{"containerName":null,"name":"$self","kind":13,"line":244},{"kind":12,"line":244,"name":"add_hit","containerName":"main::"},{"kind":13,"line":244,"name":"$s","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":247},{"range":{"end":{"character":9999,"line":268},"start":{"character":0,"line":260}},"name":"algorithm","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value","label":"algorithm($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"algorithm","localvar":"my","kind":13,"line":261},{"containerName":"algorithm","name":"$value","line":261,"kind":13},{"definition":"my","name":"$previous","containerName":"algorithm","localvar":"my","kind":13,"line":262},{"name":"$self","containerName":"algorithm","kind":13,"line":262},{"name":"$value","containerName":"algorithm","kind":13,"line":263},{"containerName":"algorithm","name":"$previous","line":263,"kind":13},{"name":"$value","containerName":"algorithm","line":264,"kind":13},{"line":264,"kind":13,"name":"$previous","containerName":"algorithm"},{"containerName":"algorithm","name":"$value","kind":13,"line":264},{"line":265,"kind":13,"containerName":"algorithm","name":"$self"},{"line":265,"kind":13,"containerName":"algorithm","name":"$value"},{"line":267,"kind":13,"name":"$previous","containerName":"algorithm"}],"line":260,"kind":12},{"name":"algorithm_version","range":{"start":{"line":280,"character":0},"end":{"character":9999,"line":289}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value","parameters":[{"label":"$self"},{"label":"$value"}],"label":"algorithm_version($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"algorithm_version","localvar":"my","kind":13,"line":281},{"kind":13,"line":281,"name":"$value","containerName":"algorithm_version"},{"line":282,"kind":13,"localvar":"my","containerName":"algorithm_version","name":"$previous","definition":"my"},{"name":"$self","containerName":"algorithm_version","kind":13,"line":282},{"kind":13,"line":283,"name":"$value","containerName":"algorithm_version"},{"line":283,"kind":13,"containerName":"algorithm_version","name":"$previous"},{"kind":13,"line":284,"containerName":"algorithm_version","name":"$value"},{"containerName":"algorithm_version","name":"$previous","kind":13,"line":284},{"kind":13,"line":284,"containerName":"algorithm_version","name":"$value"},{"containerName":"algorithm_version","name":"$self","line":285,"kind":13},{"containerName":"algorithm_version","name":"$value","line":285,"kind":13},{"kind":13,"line":288,"containerName":"algorithm_version","name":"$previous"}],"line":280},{"range":{"end":{"character":9999,"line":310},"start":{"character":0,"line":307}},"name":"next_hit","children":[{"definition":"my","name":"$self","containerName":"next_hit","localvar":"my","kind":13,"line":308},{"containerName":"next_hit","name":"@args","line":308,"kind":13},{"kind":13,"line":309,"definition":"my","name":"$index","containerName":"next_hit","localvar":"my"},{"line":309,"kind":13,"containerName":"next_hit","name":"$self"},{"name":"_nexthitindex","containerName":"next_hit","kind":12,"line":309},{"line":310,"kind":13,"containerName":"next_hit","name":"$index"},{"name":"$self","containerName":"next_hit","kind":13,"line":310}],"line":307,"kind":12,"signature":{"label":"next_hit($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"kind":13,"line":312,"name":"$hit","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%self","kind":13,"line":312},{"line":312,"kind":13,"name":"$index","containerName":null},{"containerName":null,"name":"%hit","line":313,"kind":13},{"line":314,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$factory"},{"line":314,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":314,"containerName":"main::","name":"hit_factory"},{"containerName":null,"name":"$self","line":314,"kind":13},{"line":314,"kind":12,"containerName":"main::","name":"throw"},{"kind":13,"line":315,"containerName":null,"name":"$hit"},{"name":"$factory","containerName":null,"line":315,"kind":13},{"name":"create_object","containerName":"main::","kind":12,"line":315},{"line":315,"kind":13,"name":"$hit","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":316},{"kind":13,"line":316,"containerName":null,"name":"$index"},{"line":316,"kind":13,"name":"$hit","containerName":null},{"containerName":null,"name":"%self","line":317,"kind":13},{"kind":12,"line":317,"name":"_hashes"},{"line":317,"kind":13,"name":"$index","containerName":null},{"kind":13,"line":319,"name":"$hit","containerName":null},{"range":{"end":{"line":341,"character":9999},"start":{"character":0,"line":333}},"name":"query_name","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name","label":"query_name($self,$value)"},"containerName":"main::","definition":"sub","line":333,"children":[{"containerName":"query_name","name":"$self","definition":"my","localvar":"my","kind":13,"line":334},{"containerName":"query_name","name":"$value","line":334,"kind":13},{"name":"$previous","definition":"my","containerName":"query_name","localvar":"my","kind":13,"line":335},{"containerName":"query_name","name":"$self","kind":13,"line":335},{"name":"$value","containerName":"query_name","line":336,"kind":13},{"name":"$previous","containerName":"query_name","line":336,"kind":13},{"containerName":"query_name","name":"$value","kind":13,"line":337},{"containerName":"query_name","name":"$previous","kind":13,"line":337},{"name":"$value","containerName":"query_name","line":337,"kind":13},{"kind":13,"line":338,"name":"$self","containerName":"query_name"},{"line":338,"kind":13,"containerName":"query_name","name":"$value"},{"line":340,"kind":13,"containerName":"query_name","name":"$previous"}],"kind":12},{"range":{"start":{"character":0,"line":353},"end":{"character":9999,"line":361}},"name":"query_accession","children":[{"kind":13,"line":354,"containerName":"query_accession","definition":"my","name":"$self","localvar":"my"},{"containerName":"query_accession","name":"$value","line":354,"kind":13},{"localvar":"my","name":"$previous","definition":"my","containerName":"query_accession","line":355,"kind":13},{"name":"$self","containerName":"query_accession","kind":13,"line":355},{"name":"$value","containerName":"query_accession","kind":13,"line":356},{"name":"$previous","containerName":"query_accession","kind":13,"line":356},{"kind":13,"line":357,"name":"$value","containerName":"query_accession"},{"name":"$previous","containerName":"query_accession","line":357,"kind":13},{"name":"$value","containerName":"query_accession","kind":13,"line":357},{"name":"$self","containerName":"query_accession","line":358,"kind":13},{"name":"$value","containerName":"query_accession","kind":13,"line":358},{"line":360,"kind":13,"containerName":"query_accession","name":"$previous"}],"line":353,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession","label":"query_accession($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":374,"character":0},"end":{"line":382,"character":9999}},"name":"query_gi","signature":{"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"query_gi($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"query_gi","line":375,"kind":13},{"containerName":"query_gi","name":"$value","line":375,"kind":13},{"name":"$value","containerName":"query_gi","line":376,"kind":13},{"name":"$self","containerName":"query_gi","line":377,"kind":13},{"name":"$value","containerName":"query_gi","line":377,"kind":13},{"kind":13,"line":379,"containerName":"query_gi","name":"$self"},{"containerName":"query_gi","name":"$self","line":379,"kind":13},{"name":"query_name","containerName":"query_gi","kind":12,"line":379},{"line":381,"kind":13,"name":"$self","containerName":"query_gi"}],"line":374,"kind":12},{"range":{"start":{"character":0,"line":395},"end":{"character":9999,"line":403}},"name":"query_length","line":395,"children":[{"kind":13,"line":396,"containerName":"query_length","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":396,"name":"$value","containerName":"query_length"},{"kind":13,"line":397,"containerName":"query_length","name":"$previous","definition":"my","localvar":"my"},{"name":"$self","containerName":"query_length","line":397,"kind":13},{"name":"$value","containerName":"query_length","kind":13,"line":398},{"kind":13,"line":398,"name":"$previous","containerName":"query_length"},{"line":399,"kind":13,"containerName":"query_length","name":"$value"},{"containerName":"query_length","name":"$previous","kind":13,"line":399},{"containerName":"query_length","name":"$value","line":399,"kind":13},{"kind":13,"line":400,"name":"$self","containerName":"query_length"},{"containerName":"query_length","name":"$value","kind":13,"line":400},{"kind":13,"line":402,"name":"$previous","containerName":"query_length"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length","label":"query_length($self,$value)"},"containerName":"main::","definition":"sub"},{"signature":{"label":"query_description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":417,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"query_description"},{"line":417,"kind":13,"containerName":"query_description","name":"$value"},{"line":418,"kind":13,"localvar":"my","containerName":"query_description","name":"$previous","definition":"my"},{"line":418,"kind":13,"name":"$self","containerName":"query_description"},{"kind":13,"line":419,"containerName":"query_description","name":"$value"},{"containerName":"query_description","name":"$previous","kind":13,"line":419},{"line":420,"kind":13,"name":"$value","containerName":"query_description"},{"name":"$previous","containerName":"query_description","line":420,"kind":13},{"name":"$value","containerName":"query_description","line":420,"kind":13},{"containerName":"query_description","name":"$self","kind":13,"line":421},{"containerName":"query_description","name":"$value","kind":13,"line":421},{"containerName":"query_description","name":"$previous","kind":13,"line":423}],"line":416,"kind":12,"range":{"start":{"line":416,"character":0},"end":{"line":424,"character":9999}},"name":"query_description"},{"line":438,"children":[{"kind":13,"line":439,"definition":"my","name":"$self","containerName":"database_name","localvar":"my"},{"containerName":"database_name","name":"$value","line":439,"kind":13},{"localvar":"my","definition":"my","name":"$previous","containerName":"database_name","line":440,"kind":13},{"line":440,"kind":13,"name":"$self","containerName":"database_name"},{"line":441,"kind":13,"name":"$value","containerName":"database_name"},{"kind":13,"line":441,"containerName":"database_name","name":"$previous"},{"name":"$value","containerName":"database_name","kind":13,"line":442},{"line":442,"kind":13,"containerName":"database_name","name":"$previous"},{"name":"$value","containerName":"database_name","kind":13,"line":442},{"containerName":"database_name","name":"$self","line":443,"kind":13},{"kind":13,"line":443,"containerName":"database_name","name":"$value"},{"line":445,"kind":13,"containerName":"database_name","name":"$previous"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name","label":"database_name($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":446,"character":9999},"start":{"character":0,"line":438}},"name":"database_name"},{"range":{"start":{"character":0,"line":461},"end":{"character":9999,"line":469}},"name":"database_letters","detail":"($self,$value)","signature":{"label":"database_letters($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db "},"containerName":"main::","definition":"sub","line":461,"children":[{"definition":"my","name":"$self","containerName":"database_letters","localvar":"my","kind":13,"line":462},{"name":"$value","containerName":"database_letters","kind":13,"line":462},{"kind":13,"line":463,"definition":"my","name":"$previous","containerName":"database_letters","localvar":"my"},{"containerName":"database_letters","name":"$self","kind":13,"line":463},{"name":"$value","containerName":"database_letters","kind":13,"line":464},{"name":"$previous","containerName":"database_letters","line":464,"kind":13},{"kind":13,"line":465,"containerName":"database_letters","name":"$value"},{"containerName":"database_letters","name":"$previous","kind":13,"line":465},{"name":"$value","containerName":"database_letters","kind":13,"line":465},{"kind":13,"line":466,"name":"$self","containerName":"database_letters"},{"line":466,"kind":13,"containerName":"database_letters","name":"$value"},{"kind":13,"line":468,"containerName":"database_letters","name":"$previous"}],"kind":12},{"range":{"start":{"character":0,"line":483},"end":{"line":491,"character":9999}},"name":"database_entries","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db","label":"database_entries($self,$value)"},"containerName":"main::","definition":"sub","line":483,"children":[{"line":484,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"database_entries"},{"kind":13,"line":484,"name":"$value","containerName":"database_entries"},{"localvar":"my","definition":"my","name":"$previous","containerName":"database_entries","line":485,"kind":13},{"line":485,"kind":13,"containerName":"database_entries","name":"$self"},{"line":486,"kind":13,"name":"$value","containerName":"database_entries"},{"name":"$previous","containerName":"database_entries","line":486,"kind":13},{"line":487,"kind":13,"containerName":"database_entries","name":"$value"},{"kind":13,"line":487,"containerName":"database_entries","name":"$previous"},{"line":487,"kind":13,"containerName":"database_entries","name":"$value"},{"kind":13,"line":488,"name":"$self","containerName":"database_entries"},{"containerName":"database_entries","name":"$value","kind":13,"line":488},{"name":"$previous","containerName":"database_entries","kind":13,"line":490}],"kind":12},{"line":504,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_parameter","line":505,"kind":13},{"name":"$name","containerName":"get_parameter","line":505,"kind":13},{"line":506,"kind":13,"name":"$self","containerName":"get_parameter"},{"containerName":"get_parameter","name":"get_parameter","kind":12,"line":506},{"kind":13,"line":506,"name":"$name","containerName":"get_parameter"}],"kind":12,"detail":"($self,$name)","signature":{"label":"get_parameter($self,$name)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)","parameters":[{"label":"$self"},{"label":"$name"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":504,"character":0},"end":{"character":9999,"line":507}},"name":"get_parameter"},{"range":{"start":{"line":519,"character":0},"end":{"character":9999,"line":522}},"name":"available_parameters","signature":{"label":"available_parameters($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"available_parameters","localvar":"my","kind":13,"line":520},{"name":"$self","containerName":"available_parameters","kind":13,"line":521},{"line":521,"kind":12,"containerName":"available_parameters","name":"available_parameters"}],"line":519,"kind":12},{"children":[{"kind":13,"line":537,"containerName":"get_statistic","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":537,"name":"$key","containerName":"get_statistic"},{"kind":13,"line":538,"name":"$self","containerName":"get_statistic"},{"line":538,"kind":12,"name":"get_statistic","containerName":"get_statistic"},{"line":538,"kind":13,"containerName":"get_statistic","name":"$key"}],"line":536,"kind":12,"signature":{"label":"get_statistic($self,$key)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)","parameters":[{"label":"$self"},{"label":"$key"}]},"detail":"($self,$key)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":536},"end":{"character":9999,"line":539}},"name":"get_statistic"},{"range":{"start":{"character":0,"line":551},"end":{"line":554,"character":9999}},"name":"available_statistics","line":551,"children":[{"line":552,"kind":13,"localvar":"my","containerName":"available_statistics","name":"$self","definition":"my"},{"line":553,"kind":13,"containerName":"available_statistics","name":"$self"},{"line":553,"kind":12,"name":"available_statistics","containerName":"available_statistics"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none","label":"available_statistics($self)"},"containerName":"main::","definition":"sub"},{"name":"add_hit","range":{"start":{"character":0,"line":570},"end":{"character":9999,"line":574}},"kind":12,"line":570,"children":[{"kind":13,"line":571,"containerName":"add_hit","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":571,"name":"$s","containerName":"add_hit"},{"kind":13,"line":572,"name":"$s","containerName":"add_hit"},{"name":"$s","containerName":"add_hit","kind":13,"line":572},{"containerName":"add_hit","name":"isa","line":572,"kind":12},{"containerName":"add_hit","name":"$self","kind":13,"line":573},{"containerName":"add_hit","name":"$s","kind":13,"line":573}],"containerName":"main::","definition":"sub","detail":"($self,$s)","signature":{"label":"add_hit($self,$s)","parameters":[{"label":"$self"},{"label":"$s"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI"}},{"line":576,"kind":13,"name":"$self","containerName":null},{"line":576,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$s","kind":13,"line":576},{"kind":13,"line":579,"name":"%s","containerName":null},{"kind":13,"line":580,"name":"%self","containerName":null},{"line":580,"kind":12,"name":"_hashes"},{"name":"%self","containerName":null,"kind":13,"line":580},{"line":582,"kind":13,"containerName":null,"name":"%self"},{"name":"hit_factory","definition":"sub","containerName":"main::","range":{"start":{"line":595,"character":0},"end":{"character":9999,"line":599}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"hit_factory","localvar":"my","kind":13,"line":596},{"kind":13,"line":597,"containerName":"hit_factory","name":"$self"},{"containerName":"hit_factory","name":"$self","kind":13,"line":598}],"line":595},{"name":"_hit_factory","kind":12,"line":597},{"line":598,"kind":12,"name":"_hit_factory"},{"children":[{"line":613,"kind":13,"localvar":"my","containerName":"rewind","definition":"my","name":"$self"},{"name":"$self","containerName":"rewind","kind":13,"line":614}],"line":612,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none","label":"rewind($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":615},"start":{"character":0,"line":612}},"name":"rewind"},{"range":{"start":{"line":625,"character":0},"end":{"character":9999,"line":628}},"name":"_nexthitindex","signature":{"label":"_nexthitindex($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_nexthitindex","localvar":"my","kind":13,"line":626},{"name":"@args","containerName":"_nexthitindex","line":626,"kind":13},{"name":"$self","containerName":"_nexthitindex","kind":13,"line":627}],"line":625,"kind":12},{"line":642,"children":[{"kind":13,"line":643,"definition":"my","name":"$self","containerName":"add_parameter","localvar":"my"},{"kind":13,"line":643,"name":"$key","containerName":"add_parameter"},{"line":643,"kind":13,"name":"$value","containerName":"add_parameter"},{"containerName":"add_parameter","name":"$self","kind":13,"line":644},{"containerName":"add_parameter","name":"set_parameter","kind":12,"line":644},{"line":644,"kind":13,"name":"$key","containerName":"add_parameter"},{"line":644,"kind":13,"containerName":"add_parameter","name":"$value"}],"kind":12,"detail":"($self,$key,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter","label":"add_parameter($self,$key,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":642},"end":{"line":645,"character":9999}},"name":"add_parameter"},{"children":[{"kind":13,"line":660,"name":"$self","definition":"my","containerName":"add_statistic","localvar":"my"},{"line":660,"kind":13,"name":"$key","containerName":"add_statistic"},{"line":660,"kind":13,"containerName":"add_statistic","name":"$value"},{"name":"$self","containerName":"add_statistic","kind":13,"line":661},{"line":661,"kind":12,"name":"set_statistic","containerName":"add_statistic"},{"kind":13,"line":661,"containerName":"add_statistic","name":"$key"},{"containerName":"add_statistic","name":"$value","kind":13,"line":661}],"line":659,"kind":12,"signature":{"label":"add_statistic($self,$key,$value)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n   my ($self,$key,$value) = @_;\n   $self->{'_parameters'}->set_parameter($key => $value);\n}\n\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $report->add_statistic('lambda', 2.3);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter"},"detail":"($self,$key,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":659},"end":{"line":663,"character":9999}},"name":"add_statistic"},{"line":676,"children":[{"kind":13,"line":677,"definition":"my","name":"$self","containerName":"num_hits","localvar":"my"},{"line":678,"kind":13,"name":"$self","containerName":"num_hits"},{"kind":13,"line":679,"containerName":"num_hits","name":"$self"},{"name":"throw","containerName":"num_hits","line":679,"kind":12},{"kind":13,"line":681,"containerName":"num_hits","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":681},"start":{"character":0,"line":676}},"containerName":"main::","definition":"sub","name":"num_hits"},{"range":{"end":{"character":9999,"line":699},"start":{"line":696,"character":0}},"containerName":"main::","name":"hits","definition":"sub","line":696,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hits","line":697,"kind":13},{"containerName":"hits","name":"$i","definition":"my","localvar":"my","kind":13,"line":699},{"line":699,"kind":13,"name":"$self","containerName":"hits"}],"kind":12},{"line":699,"kind":12,"name":"_hashes"},{"line":700,"kind":13,"localvar":"my","containerName":null,"name":"$factory","definition":"my"},{"kind":13,"line":700,"name":"$self","containerName":null},{"name":"hit_factory","containerName":"main::","kind":12,"line":700},{"name":"$self","containerName":null,"line":700,"kind":13},{"kind":12,"line":700,"name":"throw","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":701},{"containerName":null,"name":"$i","kind":13,"line":701},{"name":"$factory","containerName":null,"line":701,"kind":13},{"containerName":"main::","name":"create_object","kind":12,"line":701},{"line":701,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":701,"containerName":null,"name":"$i"},{"name":"%self","containerName":null,"line":702,"kind":13},{"line":702,"kind":12,"name":"_hashes"},{"kind":13,"line":702,"name":"$i","containerName":null},{"localvar":"my","containerName":null,"name":"@hits","definition":"my","line":705,"kind":13},{"containerName":null,"name":"%self","line":706,"kind":13},{"containerName":null,"name":"@hits","line":707,"kind":13},{"kind":13,"line":707,"containerName":null,"name":"%self"},{"name":"@hits","containerName":null,"line":709,"kind":13},{"name":"algorithm_reference","range":{"start":{"line":724,"character":0},"end":{"character":9999,"line":730}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"algorithm_reference($self,$value)","documentation":"1;\n# $Id: GenericResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::GenericResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::GenericResult - Generic Implementation of\nBio::Search::Result::ResultI interface applicable to most search\nresults.\n\n=head1 SYNOPSIS\n\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'blast',\n                                -file   => 't/data/HUMBETGLOA.tblastx');\n    while( my $result = $io->next_result ) {\n        # process all search results within the input stream\n        while( my $hit = $result->next_hit ) {  \n            # insert code here for hit processing\n        }\n    }\n\n    use Bio::Search::Result::GenericResult;\n    my @hits = (); # would be a list of Bio::Search::Hit::HitI objects\n    # typically these are created from a Bio::SearchIO stream\n    my $result = Bio::Search::Result::GenericResult->new\n        ( -query_name        => 'HUMBETGLOA',\n          -query_accession   => ''\n          -query_description => 'Human haplotype C4 beta-globin gene, complete cds.'\n          -query_length      => 3002\n          -database_name     => 'ecoli.aa'\n          -database_letters  => 4662239,\n          -database_entries  => 400,\n          -parameters        => { 'e' => '0.001' },\n          -statistics        => { 'kappa' => 0.731 },\n          -algorithm         => 'blastp',\n          -algorithm_version => '2.1.2',\n          );\n\n    my $id = $result->query_name();\n\n    my $desc = $result->query_description();\n\n    my $name = $result->database_name();\n\n    my $size = $result->database_letters();\n\n    my $num_entries = $result->database_entries();\n\n    my $gap_ext = $result->get_parameter('e');\n\n    my @params = $result->available_parameters;\n\n    my $kappa = $result->get_statistic('kappa');\n\n    my @statnames = $result->available_statistics;\n\n# TODO: Show how to configure a SearchIO stream so that it generates\n#       GenericResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the Bio::Search::Result::ResultI\ninterface and provides a generic place to store results from a\nsequence database search.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericResult or any other ResultI-implementing object. If you use\nthe SearchIO system, ResultI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects.\n\nFor documentation on what you can do with GenericResult (and other ResultI\nobjects), please see the API documentation in\nL<Bio::Search::Result::ResultI|Bio::Search::Result::ResultI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason@bioperl.org\nEmail sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::GenericResult;\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\n# bug #1420\n#use overload \n#    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::ResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::GenericResult->new();\n Function: Builds a new Bio::Search::Result::GenericResult object \n Returns : Bio::Search::Result::GenericResult\n Args    : -query_name        => Name of query Sequence\n           -query_accession   => Query accession number (if available)\n           -query_description => Description of query sequence\n           -query_length      => Length of query sequence\n           -database_name     => Name of database\n           -database_letters  => Number of residues in database\n           -database_entries  => Number of entries in database\n           -hits              => array ref of Bio::Search::Hit::HitI objects\n           -parameters        => hash ref of search parameters (key => value)\n           -statistics        => hash ref of search statistics (key => value)\n           -algorithm         => program name (blastx)\n           -algorithm_version   => version of the algorithm (2.1.2)\n           -algorithm_reference => literature reference string for this algorithm\n           -hit_factory       => Bio::Factory::ObjectFactoryI capable of making\n                                 Bio::Search::Hit::HitI objects\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_hits'} = [];\n  $self->{'_hitindex'} = 0;\n  $self->{'_statistics'} = Bio::Search::GenericStatistics->new();\n  $self->{'_parameters'} = Bio::Tools::Run::GenericParameters->new();\n\n  my ($qname,$qacc,$qdesc,$qlen, $qgi,\n      $dbname,$dblet,$dbent,$params,   \n      $stats, $hits, $algo, $algo_v,\n      $prog_ref, $algo_r, $hit_factory) = $self->_rearrange([qw(QUERY_NAME\n                                                  QUERY_ACCESSION\n                                                  QUERY_DESCRIPTION\n                                                  QUERY_LENGTH\n                                                  QUERY_GI\n                                                  DATABASE_NAME\n                                                  DATABASE_LETTERS\n                                                  DATABASE_ENTRIES\n                                                  PARAMETERS\n                                                  STATISTICS\n                                                  HITS\n                                                  ALGORITHM\n                                                  ALGORITHM_VERSION\n                                                  PROGRAM_REFERENCE\n                                                  ALGORITHM_REFERENCE\n                                                  HIT_FACTORY\n                                                 )],@args);\n\n  $algo_r ||= $prog_ref;         \n  defined $algo   && $self->algorithm($algo);\n  defined $algo_v && $self->algorithm_version($algo_v);\n  defined $algo_r && $self->algorithm_reference($algo_r);\n\n  defined $qname && $self->query_name($qname);\n  defined $qacc  && $self->query_accession($qacc);\n  defined $qdesc && $self->query_description($qdesc);\n  defined $qlen  && $self->query_length($qlen);\n  defined $qgi   && $self->query_gi($qgi);\n  defined $dbname && $self->database_name($dbname);\n  defined $dblet  && $self->database_letters($dblet);\n  defined $dbent  && $self->database_entries($dbent);\n\n  defined $hit_factory && $self->hit_factory($hit_factory);\n  \n  if( defined $params ) {\n      if( ref($params) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-parameters\");\n      }\n      while( my ($key,$value) = each %{$params} ) {\n          $self->{'_parameters'}->set_parameter($key   =>   $value);\n               # $self->add_parameter($key,$value);\n      }\n  }\n  if( defined $stats ) {\n      if( ref($stats) !~ /hash/i ) {\n          $self->throw(\"Must specify a hash reference with the parameter '-statistics\");\n      }\n      while( my ($key,$value) = each %{$stats} ) {\n          $self->{'_statistics'}->set_statistic($key   =>   $value); \n          # $self->add_statistic($key,$value);\n      }\n  }\n\n  if( defined $hits  ) { \n      $self->throw(\"Must define arrayref of Hits when initializing a $class\\n\") unless ref($hits) =~ /array/i;\n\n      foreach my $s ( @$hits ) {\n          $self->add_hit($s);\n      }\n  }\n  return $self;\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;   \n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $hsp->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version{\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm_version'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm_version'} = $value;\n    } \n\n    return $previous;   \n}\n\n=head2 Bio::Search::Result::ResultI interface methods\n\nBio::Search::Result::ResultI implementation\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    my $index = $self->_nexthitindex;\n    return if $index > scalar @{$self->{'_hits'}};\n    \n    my $hit = $self->{'_hits'}->[$index];\n    if (ref($hit) eq 'HASH') {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $hit = $factory->create_object(%{$hit});\n        $self->{'_hits'}->[$index] = $hit;\n        delete $self->{_hashes}->{$index};\n    }\n    return $hit;    \n}\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : [optional] new string value for query name\n\n\nsub query_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : [optional] new string value for accession\n\n\nsub query_accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_queryacc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_queryacc'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_gi\n\n Title   : query_gi\n Usage   : $acc = $hit->query_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the query\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub query_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_query_gi'} = $value;\n    } else {\n        $self->{'_query_gi'} = $self->query_name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_query_gi'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence\n           used in the search.\n Returns : a number\n Args    :  [optional] new integer value for query length\n\n\nsub query_length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querylength'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = 0 unless defined $value;\n        $self->{'_querylength'} = $value;\n    } \n    return $previous;\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : [optional] new string for the query description\n\n\nsub query_description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_querydesc'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_querydesc'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : [optional] new string for the db name\n\n\nsub database_name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbname'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbname'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : [optional] new scalar integer for number of letters in db \n\n\n\nsub database_letters {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbletters'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbletters'} = $value;\n    } \n    return $previous;\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : [optional] new integer for the number of sequence entries in the db\n\n\n\nsub database_entries {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_dbentries'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_dbentries'} = $value;\n    } \n    return $previous;\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $report->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this report\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n   my ($self,$name) = @_;\n   return $self->{'_parameters'}->get_parameter($name);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $report->available_paramters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this report\n Args    : none\n\n\nsub available_parameters{\n   my ($self) = @_;\n   return $self->{'_parameters'}->available_parameters;\n}\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $report->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this report\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic{\n   my ($self,$key) = @_;\n   return $self->{'_statistics'}->get_statistic($key);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $report->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this report\n Args    : none\n\n\nsub available_statistics{\n   my ($self) = @_;\n   return $self->{'_statistics'}->available_statistics;\n}\n\n=head2 Bio::Search::Report \n\nBio::Search::Result::GenericResult specific methods\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$s) = @_;\n    if (ref($s) eq 'HASH' || $s->isa('Bio::Search::Hit::HitI') ) {\n        push @{$self->{'_hits'}}, $s;\n    }\n    else { \n        $self->throw(\"Passed in \" .ref($s).\" as a Hit which is not a Bio::Search::HitI.\");\n    }\n    \n    if (ref($s) eq 'HASH') {\n        $self->{_hashes}->{$#{$self->{'_hits'}}} = 1;\n    }\n    return scalar @{$self->{'_hits'}};\n}\n\n=head2 hit_factory\n\n Title   : hit_factory\n Usage   : $hit->hit_factory($hit_factory)\n Function: Get/set the factory used to build HitI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hit_factory {\n    my $self = shift;\n    if (@_) { $self->{_hit_factory} = shift }\n    return $self->{_hit_factory} || return;\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_hitindex'} = 0;\n}\n\n\n=head2 _nexthitindex\n\n Title   : _nexthitindex\n Usage   : private\n\n\nsub _nexthitindex{\n   my ($self,@args) = @_;\n   return $self->{'_hitindex'}++;\n}\n\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $report->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n   my ($self,$key,$value) = @_;\n   $self->{'_parameters'}->set_parameter($key => $value);\n}\n\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $report->add_statistic('lambda', 2.3);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_statistic {\n   my ($self,$key,$value) = @_;\n   $self->{'_statistics'}->set_statistic($key => $value);\n   return;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits{\n   my ($self) = shift;\n   if (not defined $self->{'_hits'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar(@{$self->{'_hits'}});\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n\n\n\nsub hits {\n    my ($self) = shift;\n    \n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hit_factory || $self->throw(\"Tried to get a Hit, but it was a hash ref and we have no hit factory\");\n        $self->{'_hits'}->[$i] = $factory->create_object(%{$self->{'_hits'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    my @hits = ();\n    if (ref $self->{'_hits'}) {\n        @hits = @{$self->{'_hits'}};\n    }\n    return @hits;   \n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : string containing literature reference for the algorithm\n Args    : newvalue string (optional)\n Comments: Formerly named program_reference(), which is still supported\n           for backwards compatibility.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":724,"children":[{"line":725,"kind":13,"localvar":"my","containerName":"algorithm_reference","name":"$self","definition":"my"},{"line":725,"kind":13,"name":"$value","containerName":"algorithm_reference"},{"line":726,"kind":13,"containerName":"algorithm_reference","name":"$value"},{"kind":13,"line":727,"containerName":"algorithm_reference","name":"$self"},{"name":"$value","containerName":"algorithm_reference","line":727,"kind":13},{"line":729,"kind":13,"containerName":"algorithm_reference","name":"$self"}]},{"kind":12,"line":743,"children":[{"line":743,"kind":12,"containerName":"program_reference","name":"algorithm_reference"}],"containerName":"main::","name":"program_reference","definition":"sub","range":{"end":{"line":743,"character":9999},"start":{"line":743,"character":0}}},{"containerName":"main::","name":"no_hits_found","definition":"sub","range":{"start":{"character":0,"line":752},"end":{"line":760,"character":9999}},"kind":12,"line":752,"children":[{"name":"$self","definition":"my","containerName":"no_hits_found","localvar":"my","kind":13,"line":753},{"name":"$self","containerName":"no_hits_found","line":759,"kind":13}]},{"kind":12,"line":769,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"set_no_hits_found","line":770,"kind":13},{"kind":13,"line":771,"containerName":"set_no_hits_found","name":"$self"}],"containerName":"main::","definition":"sub","name":"set_no_hits_found","range":{"end":{"line":772,"character":9999},"start":{"line":769,"character":0}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"to_string","line":791,"kind":13},{"localvar":"my","containerName":"to_string","definition":"my","name":"$str","line":792,"kind":13},{"line":792,"kind":13,"name":"$self","containerName":"to_string"},{"line":792,"kind":13,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"algorithm","line":792,"kind":12},{"kind":13,"line":792,"containerName":"to_string","name":"$self"},{"line":792,"kind":12,"containerName":"to_string","name":"query_name"},{"kind":13,"line":792,"name":"$self","containerName":"to_string"},{"line":792,"kind":12,"containerName":"to_string","name":"query_description"},{"line":792,"kind":13,"containerName":"to_string","name":"$self"},{"name":"database_name","containerName":"to_string","kind":12,"line":792},{"line":793,"kind":13,"containerName":"to_string","name":"$str"}],"line":790,"name":"to_string","definition":"sub","containerName":"main::","range":{"start":{"line":790,"character":0},"end":{"line":794,"character":9999}}}],"version":5}