{"version":5,"vars":[{"line":87,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":108}},"kind":12,"line":108,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":109},{"containerName":"new","name":"@args","kind":13,"line":109},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":110,"kind":13},{"kind":13,"line":110,"name":"$class","containerName":"new"},{"line":110,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":112,"kind":13},{"line":112,"kind":12,"containerName":"new","name":"_setup"},{"kind":13,"line":112,"name":"@args","containerName":"new"},{"name":"$field","definition":"my","containerName":"new","localvar":"my","kind":13,"line":114},{"kind":13,"line":115,"containerName":"new","name":"$self"},{"containerName":"new","name":"_fields","line":115,"kind":12},{"containerName":"new","name":"$field","line":115,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":118},{"containerName":"new","name":"_dependencies","kind":12,"line":118},{"containerName":"new","name":"$self","kind":13,"line":126}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: BlastPullResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastPullResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastPullResult - A parser and result object for BLASTN\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for NCBI BLASTN result output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::BlastPullResult;\n\nuse strict;\n\nuse Bio::Search::Hit::BlastPullHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"kind":12,"line":110,"name":"SUPER","containerName":"new"},{"line":118,"kind":12,"name":"query_name"},{"name":"query_accession","kind":12,"line":119},{"line":120,"kind":12,"name":"query_description"},{"name":"query_length","line":121,"kind":12},{"kind":12,"line":122,"name":"hit_table"},{"name":"num_hits","kind":12,"line":123},{"name":"no_hits_found","kind":12,"line":124},{"containerName":"main::","name":"_discover_header","definition":"sub","range":{"start":{"character":0,"line":133},"end":{"line":157,"character":9999}},"kind":12,"line":133,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_discover_header","line":134,"kind":13},{"containerName":"_discover_header","name":"$self","kind":13,"line":135},{"line":135,"kind":12,"name":"_chunk_seek","containerName":"_discover_header"},{"localvar":"my","containerName":"_discover_header","name":"$header","definition":"my","line":136,"kind":13},{"kind":13,"line":136,"name":"$self","containerName":"_discover_header"},{"name":"_get_chunk_by_end","containerName":"_discover_header","line":136,"kind":12},{"containerName":"_discover_header","name":"$self","kind":13,"line":137},{"containerName":"_discover_header","name":"$self","kind":13,"line":137},{"name":"_chunk_tell","containerName":"_discover_header","line":137,"kind":12},{"kind":13,"line":139,"containerName":"_discover_header","name":"$self"},{"line":139,"kind":12,"name":"_fields","containerName":"_discover_header"},{"line":139,"kind":13,"containerName":"_discover_header","name":"$header"},{"containerName":"_discover_header","name":"$self","kind":13,"line":140},{"name":"_fields","containerName":"_discover_header","kind":12,"line":140},{"containerName":"_discover_header","name":"$self","line":141,"kind":13},{"line":141,"kind":12,"name":"_fields","containerName":"_discover_header"},{"line":143,"kind":13,"containerName":"_discover_header","name":"$header"},{"name":"$self","containerName":"_discover_header","kind":13,"line":144},{"kind":12,"line":144,"name":"_fields","containerName":"_discover_header"},{"containerName":"_discover_header","name":"$header","kind":13,"line":146},{"name":"$self","containerName":"_discover_header","line":148,"kind":13},{"line":148,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":150,"name":"$header","containerName":"_discover_header"},{"kind":13,"line":152,"name":"$self","containerName":"_discover_header"},{"kind":12,"line":152,"containerName":"_discover_header","name":"_fields"},{"containerName":"_discover_header","name":"$self","kind":13,"line":156},{"containerName":"_discover_header","name":"_fields","line":156,"kind":12}]},{"name":"_after_header","kind":12,"line":137},{"kind":12,"line":139,"name":"query_name"},{"name":"query_accession","line":140,"kind":12},{"name":"query_description","kind":12,"line":141},{"name":"query_length","kind":12,"line":144},{"line":148,"kind":12,"name":"query_length"},{"kind":12,"line":152,"name":"query_name"},{"name":"header","line":156,"kind":12},{"kind":12,"children":[{"kind":13,"line":160,"definition":"my","name":"$self","containerName":"_discover_hit_table","localvar":"my"},{"line":162,"kind":13,"name":"$self","containerName":"_discover_hit_table"},{"line":162,"kind":12,"name":"_chunk_seek","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$self","line":162,"kind":13},{"line":163,"kind":13,"localvar":"my","containerName":"_discover_hit_table","definition":"my","name":"$table"},{"name":"$self","containerName":"_discover_hit_table","line":163,"kind":13},{"containerName":"_discover_hit_table","name":"_get_chunk_by_end","line":163,"kind":12},{"kind":13,"line":165,"name":"$table","containerName":"_discover_hit_table"},{"definition":"my","name":"$line","containerName":"_discover_hit_table","localvar":"my","kind":13,"line":168},{"line":168,"kind":13,"containerName":"_discover_hit_table","name":"$self"},{"name":"_get_chunk_by_nol","containerName":"_discover_hit_table","kind":12,"line":168},{"line":169,"kind":13,"containerName":"_discover_hit_table","name":"$table"},{"containerName":"_discover_hit_table","name":"$line","line":169,"kind":13},{"kind":13,"line":173,"name":"$table","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$self","kind":13,"line":175},{"line":175,"kind":13,"containerName":"_discover_hit_table","name":"$self"},{"containerName":"_discover_hit_table","name":"_chunk_tell","kind":12,"line":175},{"kind":13,"line":177,"definition":"my","name":"$evalue_cutoff","containerName":"_discover_hit_table","localvar":"my"},{"containerName":"_discover_hit_table","name":"$self","line":177,"kind":13},{"name":"get_field","containerName":"_discover_hit_table","line":177,"kind":12},{"kind":13,"line":178,"containerName":"_discover_hit_table","name":"$evalue_cutoff"},{"containerName":"_discover_hit_table","name":"$evalue_cutoff","kind":13,"line":178},{"kind":13,"line":179,"containerName":"_discover_hit_table","name":"$score_cutoff","definition":"my","localvar":"my"},{"containerName":"_discover_hit_table","name":"$self","kind":13,"line":179},{"containerName":"_discover_hit_table","name":"get_field","line":179,"kind":12},{"name":"$score_cutoff","containerName":"_discover_hit_table","kind":13,"line":180},{"kind":13,"line":180,"name":"$score_cutoff","containerName":"_discover_hit_table"},{"localvar":"my","definition":"my","name":"@table","containerName":"_discover_hit_table","line":182,"kind":13},{"localvar":"my","definition":"my","name":"$no_hit","containerName":"_discover_hit_table","line":183,"kind":13},{"name":"$table","containerName":"_discover_hit_table","kind":13,"line":184},{"line":185,"kind":13,"containerName":"_discover_hit_table","name":"$no_hit"},{"line":186,"kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"$name","definition":"my"},{"line":186,"kind":13,"containerName":"_discover_hit_table","name":"$desc"},{"name":"$score","containerName":"_discover_hit_table","kind":13,"line":186},{"line":186,"kind":13,"name":"$evalue","containerName":"_discover_hit_table"},{"line":187,"kind":13,"containerName":"_discover_hit_table","name":"$desc"},{"containerName":"_discover_hit_table","name":"$evalue","line":188,"kind":13},{"line":189,"kind":13,"name":"$evalue","containerName":"_discover_hit_table"},{"line":189,"kind":13,"containerName":"_discover_hit_table","name":"$evalue"},{"containerName":"_discover_hit_table","name":"$evalue_cutoff","line":191,"kind":13},{"containerName":"_discover_hit_table","name":"$evalue","line":191,"kind":13},{"line":191,"kind":13,"name":"$evalue_cutoff","containerName":"_discover_hit_table"},{"kind":13,"line":192,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"line":192,"kind":13,"name":"$score","containerName":"_discover_hit_table"},{"name":"$score_cutoff","containerName":"_discover_hit_table","kind":13,"line":192},{"line":193,"kind":13,"containerName":"_discover_hit_table","name":"@table"},{"line":193,"kind":13,"containerName":"_discover_hit_table","name":"$name"},{"name":"$desc","containerName":"_discover_hit_table","kind":13,"line":193},{"containerName":"_discover_hit_table","name":"$score","line":193,"kind":13},{"kind":13,"line":193,"name":"$evalue","containerName":"_discover_hit_table"},{"line":195,"kind":13,"name":"$self","containerName":"_discover_hit_table"},{"line":195,"kind":12,"containerName":"_discover_hit_table","name":"_fields"},{"kind":13,"line":195,"name":"@table","containerName":"_discover_hit_table"},{"kind":13,"line":196,"name":"$self","containerName":"_discover_hit_table"},{"name":"@table","containerName":"_discover_hit_table","kind":13,"line":196},{"name":"$self","containerName":"_discover_hit_table","line":198,"kind":13},{"name":"_fields","containerName":"_discover_hit_table","kind":12,"line":198},{"kind":13,"line":198,"name":"$no_hit","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$self","line":199,"kind":13},{"name":"_fields","containerName":"_discover_hit_table","kind":12,"line":199},{"kind":13,"line":199,"name":"@table","containerName":"_discover_hit_table"}],"line":159,"definition":"sub","name":"_discover_hit_table","containerName":"main::","range":{"end":{"line":200,"character":9999},"start":{"character":0,"line":159}}},{"name":"_after_header","kind":12,"line":162},{"name":"_after_hit_table","kind":12,"line":175},{"kind":12,"line":195,"name":"hit_table"},{"line":196,"kind":12,"name":"_next_hit_index"},{"line":198,"kind":12,"name":"no_hits_found"},{"line":199,"kind":12,"name":"num_hits"},{"kind":12,"line":202,"children":[{"containerName":"_discover_next_hit","definition":"my","name":"$self","localvar":"my","kind":13,"line":203},{"line":204,"kind":13,"localvar":"my","name":"$hit_table","definition":"my","containerName":"_discover_next_hit"},{"line":204,"kind":13,"containerName":"_discover_next_hit","name":"$self"},{"containerName":"_discover_next_hit","name":"get_field","line":204,"kind":12},{"containerName":"_discover_next_hit","name":"$self","kind":13,"line":205},{"localvar":"my","containerName":"_discover_next_hit","name":"$hit_row","definition":"my","line":206,"kind":13},{"kind":13,"line":206,"containerName":"_discover_next_hit","name":"$hit_table"}],"containerName":"main::","name":"_discover_next_hit","definition":"sub","range":{"end":{"line":206,"character":9999},"start":{"line":202,"character":0}}},{"name":"_next_hit_index","line":205,"kind":12},{"containerName":null,"name":"%self","line":206,"kind":13},{"name":"_next_hit_index","line":206,"kind":12},{"kind":13,"line":208,"name":"$self","containerName":null},{"containerName":"main::","name":"_chunk_seek","kind":12,"line":208},{"name":"%self","containerName":null,"line":208,"kind":13},{"name":"_end_of_previous_hit","kind":12,"line":208},{"kind":13,"line":208,"name":"%self","containerName":null},{"name":"_after_hit_table","kind":12,"line":208},{"kind":13,"line":210,"containerName":null,"name":"$start","definition":"my","localvar":"my"},{"name":"$end","containerName":null,"line":210,"kind":13},{"kind":13,"line":210,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_find_chunk_by_end","kind":12,"line":210},{"containerName":null,"name":"%end","kind":13,"line":211},{"name":"$start","containerName":null,"line":212,"kind":13},{"kind":13,"line":212,"name":"%self","containerName":null},{"kind":12,"line":212,"name":"_end_of_previous_hit"},{"name":"%self","containerName":null,"kind":13,"line":212},{"name":"_after_hit_table","line":212,"kind":12},{"containerName":null,"name":"$end","line":213,"kind":13},{"line":213,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":213,"name":"_chunk_true_end","containerName":"main::"},{"kind":13,"line":216,"containerName":null,"name":"$end"},{"kind":13,"line":216,"name":"$self","containerName":null},{"line":216,"kind":12,"containerName":"main::","name":"_chunk_true_start"},{"containerName":null,"name":"$start","line":218,"kind":13},{"line":218,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":218,"containerName":"main::","name":"_chunk_true_start"},{"line":220,"kind":13,"containerName":null,"name":"%self"},{"line":220,"kind":12,"name":"_end_of_previous_hit"},{"line":220,"kind":13,"containerName":null,"name":"$end"},{"name":"$self","containerName":null,"kind":13,"line":220},{"kind":12,"line":220,"containerName":"main::","name":"_chunk_true_start"},{"containerName":null,"name":"$self","line":224,"kind":13},{"name":"_fields","containerName":"main::","kind":12,"line":224},{"line":224,"kind":12,"name":"next_hit"},{"kind":12,"line":224,"containerName":"Search::Hit::BlastPullHit","name":"Bio"},{"line":224,"kind":12,"name":"new","containerName":"main::"},{"name":"@self","containerName":null,"line":224,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":225},{"line":225,"kind":12,"name":"chunk","containerName":"main::"},{"line":225,"kind":13,"name":"$start","containerName":null},{"line":225,"kind":13,"containerName":null,"name":"$end"},{"name":"$hit_row","containerName":null,"kind":13,"line":226},{"name":"%self","containerName":null,"kind":13,"line":228},{"name":"_next_hit_index","line":228,"kind":12},{"line":230,"kind":13,"containerName":null,"name":"%self"},{"line":230,"kind":12,"name":"_next_hit_index"},{"line":230,"kind":13,"name":"%hit_table","containerName":null},{"line":231,"kind":13,"name":"%self","containerName":null},{"name":"_next_hit_index","kind":12,"line":231},{"name":"_discover_stats_and_params","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":235},"end":{"line":302,"character":9999}},"kind":12,"children":[{"kind":13,"line":236,"containerName":"_discover_stats_and_params","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":237},{"containerName":"_discover_stats_and_params","name":"_chunk_seek","kind":12,"line":237},{"containerName":"_discover_stats_and_params","name":"$start","definition":"my","localvar":"my","kind":13,"line":238},{"containerName":"_discover_stats_and_params","name":"$end","line":238,"kind":13},{"containerName":"_discover_stats_and_params","name":"$self","kind":13,"line":238},{"line":238,"kind":12,"containerName":"_discover_stats_and_params","name":"_find_chunk_by_end"},{"line":239,"kind":13,"name":"$self","containerName":"_discover_stats_and_params"},{"containerName":"_discover_stats_and_params","name":"_chunk_seek","line":239,"kind":12},{"name":"$end","containerName":"_discover_stats_and_params","line":239,"kind":13},{"kind":13,"line":241,"containerName":"_discover_stats_and_params","definition":"my","name":"$gapped","localvar":"my"},{"line":242,"kind":13,"name":"$self","containerName":"_discover_stats_and_params"},{"line":242,"kind":12,"containerName":"_discover_stats_and_params","name":"_get_chunk_by_nol"},{"name":"$stat","definition":"my","containerName":"_discover_stats_and_params","localvar":"my","kind":13,"line":244},{"kind":13,"line":245,"name":"$stat","containerName":"_discover_stats_and_params"},{"containerName":"_discover_stats_and_params","name":"$self","kind":13,"line":246},{"kind":12,"line":246,"name":"add_statistic","containerName":"_discover_stats_and_params"},{"name":"$stat","containerName":"_discover_stats_and_params","line":246,"kind":13},{"localvar":"my","containerName":"_discover_stats_and_params","name":"$stat","definition":"my","line":249,"kind":13},{"containerName":"_discover_stats_and_params","name":"$stat","line":250,"kind":13},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":251},{"containerName":"_discover_stats_and_params","name":"add_statistic","kind":12,"line":251},{"name":"$stat","containerName":"_discover_stats_and_params","kind":13,"line":251},{"kind":13,"line":254,"name":"$line","definition":"my","containerName":"_discover_stats_and_params","localvar":"my"},{"containerName":"_discover_stats_and_params","name":"$self","kind":13,"line":254},{"line":254,"kind":12,"containerName":"_discover_stats_and_params","name":"_get_chunk_by_nol"},{"line":255,"kind":13,"name":"$line","containerName":"_discover_stats_and_params"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":256},{"line":256,"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"name":"$gapped","containerName":"_discover_stats_and_params","line":256,"kind":13},{"kind":13,"line":257,"containerName":"_discover_stats_and_params","name":"$self"},{"line":257,"kind":12,"name":"add_statistic","containerName":"_discover_stats_and_params"},{"line":257,"kind":13,"name":"$gapped","containerName":"_discover_stats_and_params"},{"name":"$self","containerName":"_discover_stats_and_params","line":258,"kind":13},{"name":"add_statistic","containerName":"_discover_stats_and_params","line":258,"kind":12},{"name":"$gapped","containerName":"_discover_stats_and_params","kind":13,"line":258},{"kind":13,"line":259,"containerName":"_discover_stats_and_params","name":"$gapped"},{"containerName":"_discover_stats_and_params","name":"$self","kind":13,"line":262},{"kind":12,"line":262,"containerName":"_discover_stats_and_params","name":"add_parameter"},{"kind":13,"line":265,"name":"$self","containerName":"_discover_stats_and_params"},{"name":"add_parameter","containerName":"_discover_stats_and_params","line":265,"kind":12},{"line":266,"kind":13,"name":"$self","containerName":"_discover_stats_and_params"},{"containerName":"_discover_stats_and_params","name":"add_parameter","line":266,"kind":12},{"name":"$self","containerName":"_discover_stats_and_params","line":269,"kind":13},{"line":269,"kind":12,"name":"add_statistic","containerName":"_discover_stats_and_params"},{"line":272,"kind":13,"name":"$self","containerName":"_discover_stats_and_params"},{"containerName":"_discover_stats_and_params","name":"add_statistic","line":272,"kind":12},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":275},{"containerName":"_discover_stats_and_params","name":"add_statistic","line":275,"kind":12},{"line":278,"kind":13,"name":"$self","containerName":"_discover_stats_and_params"},{"containerName":"_discover_stats_and_params","name":"add_parameter","line":278,"kind":12},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":281},{"kind":12,"line":281,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":284},{"containerName":"_discover_stats_and_params","name":"add_statistic","kind":12,"line":284},{"containerName":"_discover_stats_and_params","name":"$self","kind":13,"line":287},{"containerName":"_discover_stats_and_params","name":"add_statistic","kind":12,"line":287},{"kind":13,"line":290,"name":"$self","containerName":"_discover_stats_and_params"},{"name":"add_statistic","containerName":"_discover_stats_and_params","line":290,"kind":12},{"containerName":"_discover_stats_and_params","name":"$self","line":293,"kind":13},{"name":"add_statistic","containerName":"_discover_stats_and_params","kind":12,"line":293},{"line":296,"kind":13,"containerName":"_discover_stats_and_params","name":"$self"},{"name":"add_statistic","containerName":"_discover_stats_and_params","kind":12,"line":296},{"containerName":"_discover_stats_and_params","name":"$self","line":297,"kind":13},{"line":297,"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"line":301,"kind":13,"containerName":"_discover_stats_and_params","name":"$self"},{"containerName":"_discover_stats_and_params","name":"_fields","line":301,"kind":12}],"line":235},{"line":301,"kind":12,"name":"stats_and_params"},{"kind":12,"children":[{"line":316,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_hit"},{"line":317,"kind":13,"localvar":"my","containerName":"next_hit","definition":"my","name":"$hit"},{"containerName":"next_hit","name":"$self","line":317,"kind":13},{"line":317,"kind":12,"containerName":"next_hit","name":"get_field"},{"containerName":"next_hit","name":"$self","line":318,"kind":13},{"name":"_fields","containerName":"next_hit","line":318,"kind":12},{"name":"$hit","containerName":"next_hit","line":319,"kind":13}],"line":315,"name":"next_hit","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":320},"start":{"character":0,"line":315}}},{"name":"next_hit","kind":12,"line":318},{"range":{"end":{"line":344,"character":9999},"start":{"line":334,"character":0}},"name":"hits","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"hits","name":"$self","definition":"my","line":335,"kind":13},{"definition":"my","name":"$old","containerName":"hits","localvar":"my","kind":13,"line":336},{"line":336,"kind":13,"containerName":"hits","name":"$self"},{"kind":13,"line":337,"containerName":"hits","name":"$self"},{"containerName":"hits","name":"rewind","kind":12,"line":337},{"definition":"my","name":"@hits","containerName":"hits","localvar":"my","kind":13,"line":338},{"localvar":"my","containerName":"hits","definition":"my","name":"$hit","line":339,"kind":13},{"name":"$self","containerName":"hits","line":339,"kind":13},{"name":"next_hit","containerName":"hits","kind":12,"line":339},{"line":340,"kind":13,"name":"@hits","containerName":"hits"},{"kind":13,"line":340,"name":"$hit","containerName":"hits"},{"name":"$self","containerName":"hits","kind":13,"line":342},{"name":"@hits","containerName":"hits","line":342,"kind":13},{"name":"$old","containerName":"hits","kind":13,"line":342},{"containerName":"hits","name":"@hits","line":343,"kind":13}],"line":334,"kind":12},{"name":"_next_hit_index","kind":12,"line":336},{"name":"_next_hit_index","kind":12,"line":342},{"range":{"end":{"character":9999,"line":364},"start":{"line":361,"character":0}},"name":"sort_hits","detail":"($self,$code_ref)","signature":{"documentation":"1;\n# $Id: BlastPullResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastPullResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastPullResult - A parser and result object for BLASTN\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for NCBI BLASTN result output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::BlastPullResult;\n\nuse strict;\n\nuse Bio::Search::Hit::BlastPullHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tforeach my $field (qw( header hit_table hsp_table alignments next_model models query_length stats_and_params)) {\n\t\t$self->_fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( query_name => 'header',\n                              query_accession => 'header',\n                              query_description => 'header',\n\t\t\t\t\t\t\t  query_length => 'header',\n                              hit_table => 'header',\n\t\t\t\t\t\t\t  num_hits => 'hit_table',\n\t\t\t\t\t\t\t  no_hits_found => 'hit_table' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all ResultI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"Value\\n\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t($self->_fields->{query_name}) = $header =~ /^\\s*(\\S+)/;\n\t$self->_fields->{query_accession} = '';\n\t$self->_fields->{query_description} = '';\n\t\n\tif ($header =~ /^Length=(\\d+)/m) {\n\t\t$self->_fields->{query_length} = $1;\n\t}\n\telsif ($header =~ /\\((\\d+) letters\\)/) {\n\t\t# older form?\n\t\t$self->_fields->{query_length} = $1;\n\t\t\n\t\tif ($header =~ /^\\s*\\(\\d+ letters/) {\n\t\t\t# there wasn't a query sequence name\n\t\t\t$self->_fields->{query_name} = '';\n\t\t}\n\t}\n\t\n\t$self->_fields->{header} = 1;\n}\n\nsub _discover_hit_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_header});\n\tmy $table = $self->_get_chunk_by_end(\"\\n>\");\n\t\n\tunless ($table) {\n\t\t# no alignments, presumably; hit table comprises the remainder of this\n\t\t# result\n\t\twhile (my $line = $self->_get_chunk_by_nol(1)) {\n\t\t\t$table .= $line;\n\t\t}\n\t}\n    \n    $table ||= '';\n    \n\t$self->{_after_hit_table} = $self->_chunk_tell;\n\t\n\tmy $evalue_cutoff = $self->get_field('evalue_cutoff');\n\tundef $evalue_cutoff if $evalue_cutoff eq '[unset]';\n\tmy $score_cutoff = $self->get_field('score_cutoff');\n\tundef $score_cutoff if $score_cutoff eq '[unset]';\n\t\n\tmy @table;\n\tmy $no_hit = 1;\n\twhile ($table =~ /^(\\S+)\\s+(\\S.*?)?\\s+(\\S+)\\s+([\\de]\\S*)\\s*\\n/gm) {\n\t\t$no_hit = 0;\n\t\tmy ($name, $desc, $score, $evalue) = ($1, $2, $3, $4);\n\t\t$desc ||= '';\n        if ($evalue =~ /^e/) {\n            $evalue = '1'.$evalue;\n        }\n\t\tnext if ($evalue_cutoff && $evalue > $evalue_cutoff);\n\t\tnext if ($score_cutoff && $score < $score_cutoff);\n\t\tpush(@table, [$name, $desc, $score, $evalue]);\n\t}\n\t$self->_fields->{hit_table} = \\@table;\n\t$self->{_next_hit_index} = @table > 0 ? 0 : -1;\n\t\n\t$self->_fields->{no_hits_found} = $no_hit;\n\t$self->_fields->{num_hits} = @table;\n}\n\nsub _discover_next_hit {\n\tmy $self = shift;\n\tmy $hit_table = $self->get_field('hit_table');\n\treturn if $self->{_next_hit_index} == -1;\n\tmy $hit_row = ${$hit_table}[$self->{_next_hit_index}];\n\t\n\t$self->_chunk_seek($self->{_end_of_previous_hit} || $self->{_after_hit_table});\n\t\n\tmy ($start, $end) = $self->_find_chunk_by_end(\"\\n>\");\n\tunless ($end) {\n\t\t$start = $self->{_end_of_previous_hit} || $self->{_after_hit_table};\n\t\t$end = $self->_chunk_true_end;\n\t}\n\telse {\n\t\t$end += $self->_chunk_true_start;\n\t}\n\t$start += $self->_chunk_true_start;\n\t\n\t$self->{_end_of_previous_hit} = $end - $self->_chunk_true_start;\n\t\n\t#*** needs to inherit piped_behaviour, and we need to deal with _sequential\n\t#    ourselves\n\t$self->_fields->{next_hit} = Bio::Search::Hit::BlastPullHit->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-chunk => [$self->chunk, $start, $end],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-hit_data => $hit_row);\n\t\n\t$self->{_next_hit_index}++;\n\t\n\tif ($self->{_next_hit_index} > $#{$hit_table}) {\n\t\t$self->{_next_hit_index} = -1;\n\t}\n}\n\nsub _discover_stats_and_params {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy ($start, $end) = $self->_find_chunk_by_end(\"\\n  Database: \");\n\t$self->_chunk_seek($end);\n\t\n\tmy $gapped = 0;\n\twhile ($self->_get_chunk_by_nol(1)) {\n\t\tif (/Number of letters in database:\\s+(\\S+)/) {\n\t\t\tmy $stat = $1;\n\t\t\t$stat =~ s/,//g;\n\t\t\t$self->add_statistic('dbletters', $stat);\n\t\t}\n\t\telsif (/Number of sequences in database:\\s+(\\S+)/) {\n\t\t\tmy $stat = $1;\n\t\t\t$stat =~ s/,//g;\n\t\t\t$self->add_statistic('dbentries', $stat);\n\t\t}\n\t\telsif (/^Lambda/) {\n\t\t\tmy $line = $self->_get_chunk_by_nol(1);\n\t\t\t$line =~ /\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)/;\n\t\t\t$self->add_statistic($gapped ? 'lambda_gapped' : 'lambda', $1);\n\t\t\t$self->add_statistic($gapped ? 'kappa_gapped' : 'kappa', $2);\n\t\t\t$self->add_statistic($gapped ? 'entropy_gapped' : 'entropy', $3);\n\t\t\t$gapped = 1;\n\t\t}\n\t\telsif (/^Matrix: (.+)\\n/) {\n\t\t\t$self->add_parameter('matrix', $1);\n\t\t}\n\t\telsif (/^Gap Penalties: Existence: (\\d+), Extension: (\\d+)/) {\n\t\t\t$self->add_parameter('gapopen', $1);\n\t\t\t$self->add_parameter('gapext', $2);\n\t\t}\n\t\telsif (/^Number of Hits to DB: (\\d+)/) {\n\t\t\t$self->add_statistic('Hits_to_DB', $1);\n\t\t}\n\t\telsif (/^Number of extensions: (\\d+)/) {\n\t\t\t$self->add_statistic('num_extensions', $1);\n\t\t}\n\t\telsif (/^Number of successful extensions: (\\d+)/) {\n\t\t\t$self->add_statistic('num_successful_extensions', $1);\n\t\t}\n\t\telsif (/^Number of sequences better than (\\S+):/) {\n\t\t\t$self->add_parameter('expect', $1);\n\t\t}\n\t\telsif (/^[Ll]ength of query: (\\d+)/) {\n\t\t\t$self->add_statistic('querylength', $1);\n\t\t}\n        elsif (/^[Ee]ffective HSP length: (\\d+)/) {\n\t\t\t$self->add_statistic('effective_hsplength', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective length of database: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivedblength', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective search space: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivespace', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective search space used: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivespaceused', $1);\n\t\t}\n\t\telsif (/^([TAXS]\\d?): (\\d+)(?: \\((\\S+))?/) {\n\t\t\t$self->add_statistic($1, $2);\n\t\t\t$self->add_statistic($1.'_bits', $3) if $3;\n\t\t}\n\t}\n\t\n\t$self->_fields->{stats_and_params} = 1;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n\tmy $self = shift;\n    my $hit = $self->get_field('next_hit');\n\tundef $self->_fields->{next_hit};\n\treturn $hit;\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n\tmy $self = shift;\n\tmy $old = $self->{_next_hit_index} || 0;\n\t$self->rewind;\n\tmy @hits;\n\twhile (defined(my $hit = $self->next_hit)) {\n\t\tpush(@hits, $hit);\n\t}\n\t$self->{_next_hit_index} = @hits > 0 ? $old : -1;\n\treturn @hits;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits('<score')\n Function\t: Sorts the hits so that they come out in the desired order when\n              hits() or next_hit() is called.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.\n\t\t\t  By default the sort order is ascending significance value (ie.\n\t\t\t  most significant hits first).\n\t\t\t  *** example","parameters":[{"label":"$self"},{"label":"$code_ref"}],"label":"sort_hits($self,$code_ref)"},"containerName":"main::","definition":"sub","line":361,"children":[{"localvar":"my","containerName":"sort_hits","name":"$self","definition":"my","line":362,"kind":13},{"containerName":"sort_hits","name":"$code_ref","kind":13,"line":362},{"line":363,"kind":13,"containerName":"sort_hits","name":"$self"},{"containerName":"sort_hits","name":"throw","kind":12,"line":363}],"kind":12},{"range":{"end":{"character":9999,"line":382},"start":{"character":0,"line":377}},"name":"rewind","definition":"sub","containerName":"main::","children":[{"kind":13,"line":378,"containerName":"rewind","definition":"my","name":"$self","localvar":"my"},{"line":379,"kind":13,"containerName":"rewind","name":"$self"},{"line":379,"kind":12,"containerName":"rewind","name":"_fields"},{"containerName":"rewind","name":"$self","kind":13,"line":380},{"kind":12,"line":380,"containerName":"rewind","name":"get_field"},{"line":382,"kind":13,"name":"$self","containerName":"rewind"},{"containerName":"rewind","name":"$self","line":382,"kind":13},{"kind":12,"line":382,"name":"_fields","containerName":"rewind"}],"line":377,"kind":12},{"name":"hit_table","kind":12,"line":379},{"line":382,"kind":12,"name":"_next_hit_index"},{"line":382,"kind":12,"name":"hit_table"},{"definition":"sub","name":"get_statistic","containerName":"main::","range":{"end":{"character":9999,"line":400},"start":{"line":396,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_statistic","line":397,"kind":13},{"name":"$self","containerName":"get_statistic","kind":13,"line":398},{"containerName":"get_statistic","name":"get_field","kind":12,"line":398},{"kind":13,"line":399,"containerName":"get_statistic","name":"$self"}],"line":396},{"name":"SUPER","containerName":"get_statistic","kind":12,"line":399},{"range":{"start":{"character":0,"line":413},"end":{"line":417,"character":9999}},"name":"get_parameter","definition":"sub","containerName":"main::","children":[{"kind":13,"line":414,"containerName":"get_parameter","name":"$self","definition":"my","localvar":"my"},{"line":415,"kind":13,"containerName":"get_parameter","name":"$self"},{"name":"get_field","containerName":"get_parameter","kind":12,"line":415},{"name":"$self","containerName":"get_parameter","kind":13,"line":416}],"line":413,"kind":12},{"name":"SUPER","containerName":"get_parameter","kind":12,"line":416}]}