{"vars":[{"kind":2,"line":252,"name":"base","containerName":""},{"range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":268}},"name":"number","children":[{"line":266,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"number"},{"line":266,"kind":13,"name":"@args","containerName":"number"},{"name":"$self","containerName":"number","line":267,"kind":13},{"name":"throw_not_implemented","containerName":"number","kind":12,"line":267}],"line":265,"kind":12,"signature":{"label":"number($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"detail":"($self,@args)","signature":{"label":"converged($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration"},"containerName":"main::","definition":"sub","line":280,"children":[{"kind":13,"line":281,"containerName":"converged","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"converged","kind":13,"line":281},{"name":"$self","containerName":"converged","line":282,"kind":13},{"kind":12,"line":282,"name":"throw_not_implemented","containerName":"converged"}],"kind":12,"range":{"start":{"line":280,"character":0},"end":{"character":9999,"line":283}},"name":"converged"},{"range":{"start":{"line":311,"character":0},"end":{"character":9999,"line":314}},"name":"next_hit","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_hit","line":312,"kind":13},{"line":312,"kind":13,"name":"@args","containerName":"next_hit"},{"name":"$self","containerName":"next_hit","line":313,"kind":13},{"kind":12,"line":313,"name":"throw_not_implemented","containerName":"next_hit"}],"line":311,"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_hit($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":333},"end":{"character":9999,"line":336}},"name":"next_hit_new","line":333,"children":[{"containerName":"next_hit_new","definition":"my","name":"$self","localvar":"my","kind":13,"line":334},{"line":334,"kind":13,"name":"@args","containerName":"next_hit_new"},{"line":335,"kind":13,"name":"$self","containerName":"next_hit_new"},{"line":335,"kind":12,"containerName":"next_hit_new","name":"throw_not_implemented"}],"kind":12,"detail":"($self,@args)","signature":{"label":"next_hit_new($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"children":[{"localvar":"my","containerName":"next_hit_old","name":"$self","definition":"my","line":357,"kind":13},{"line":357,"kind":13,"containerName":"next_hit_old","name":"@args"},{"containerName":"next_hit_old","name":"$self","kind":13,"line":358},{"name":"throw_not_implemented","containerName":"next_hit_old","kind":12,"line":358}],"line":356,"kind":12,"signature":{"label":"next_hit_old($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":359,"character":9999},"start":{"character":0,"line":356}},"name":"next_hit_old"},{"range":{"start":{"character":0,"line":374},"end":{"line":377,"character":9999}},"name":"num_hits","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"num_hits","line":375,"kind":13},{"kind":13,"line":375,"name":"@args","containerName":"num_hits"},{"kind":13,"line":376,"containerName":"num_hits","name":"$self"},{"kind":12,"line":376,"containerName":"num_hits","name":"throw_not_implemented"}],"line":374,"kind":12,"signature":{"label":"num_hits($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"num_hits_new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_new\n\n Title   : num_hits_new\n Usage   : my $hitcount_new = $result->num_hits_new;\n         : my $hitcount_new_below_thresh = $result->num_hits_new( 1 );\n Purpose : Returns the number of new hits in this iteration that were not\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the new hits\n           that are below the inclusion threshold.\n\n\nSee Also: L<num_hits>, L<num_hits_old>, L<Classification of Hits>"},"detail":"($self,@args)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"num_hits_new","localvar":"my","kind":13,"line":399},{"kind":13,"line":399,"containerName":"num_hits_new","name":"@args"},{"name":"$self","containerName":"num_hits_new","kind":13,"line":400},{"line":400,"kind":12,"containerName":"num_hits_new","name":"throw_not_implemented"}],"line":398,"name":"num_hits_new","range":{"end":{"character":9999,"line":401},"start":{"line":398,"character":0}}},{"detail":"($self,@args)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_new\n\n Title   : num_hits_new\n Usage   : my $hitcount_new = $result->num_hits_new;\n         : my $hitcount_new_below_thresh = $result->num_hits_new( 1 );\n Purpose : Returns the number of new hits in this iteration that were not\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the new hits\n           that are below the inclusion threshold.\n\n\nSee Also: L<num_hits>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits_new {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_old\n\n Title   : num_hits_old\n Usage   : my $hitcount_old = $result->num_hits_old;\n         : my $hitcount_old_below_thresh = $result->num_hits_old( 1 );\n Purpose : Returns the number of new hits in this iteration that were\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the old hits\n           that are below the inclusion threshold.\n\nSee Also: L<num_hits>, L<num_hits_new>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"num_hits_old($self,@args)"},"containerName":"main::","definition":"sub","line":421,"children":[{"name":"$self","definition":"my","containerName":"num_hits_old","localvar":"my","kind":13,"line":422},{"name":"@args","containerName":"num_hits_old","line":422,"kind":13},{"containerName":"num_hits_old","name":"$self","line":423,"kind":13},{"name":"throw_not_implemented","containerName":"num_hits_old","line":423,"kind":12}],"kind":12,"range":{"start":{"character":0,"line":421},"end":{"character":9999,"line":424}},"name":"num_hits_old"},{"containerName":"main::","definition":"sub","name":"hits","range":{"end":{"character":9999,"line":443},"start":{"character":0,"line":443}},"kind":12,"line":443,"children":[{"line":443,"kind":12,"name":"throw_not_implemented","containerName":"hits"}]},{"name":"newhits","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":462},"start":{"character":0,"line":462}},"kind":12,"children":[{"name":"throw_not_implemented","containerName":"newhits","kind":12,"line":462}],"line":462},{"containerName":"main::","definition":"sub","name":"oldhits","range":{"start":{"line":481,"character":0},"end":{"character":9999,"line":481}},"kind":12,"line":481,"children":[{"line":481,"kind":12,"containerName":"oldhits","name":"throw_not_implemented"}]},{"kind":12,"children":[{"containerName":"newhits_below_threshold","name":"throw_not_implemented","kind":12,"line":500}],"line":500,"name":"newhits_below_threshold","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":500},"start":{"character":0,"line":500}}},{"range":{"end":{"line":519,"character":9999},"start":{"character":0,"line":519}},"definition":"sub","name":"oldhits_below_threshold","containerName":"main::","children":[{"line":519,"kind":12,"name":"throw_not_implemented","containerName":"oldhits_below_threshold"}],"line":519,"kind":12},{"containerName":"main::","name":"oldhits_newly_below_threshold","definition":"sub","range":{"start":{"line":539,"character":0},"end":{"line":539,"character":9999}},"kind":12,"line":539,"children":[{"line":539,"kind":12,"containerName":"oldhits_newly_below_threshold","name":"throw_not_implemented"}]},{"kind":12,"children":[{"kind":12,"line":558,"containerName":"oldhits_not_below_threshold","name":"throw_not_implemented"}],"line":558,"definition":"sub","name":"oldhits_not_below_threshold","containerName":"main::","range":{"end":{"character":9999,"line":558},"start":{"line":558,"character":0}}},{"kind":12,"line":578,"children":[{"kind":12,"line":578,"name":"throw_not_implemented","containerName":"newhits_not_below_threshold"}],"containerName":"main::","definition":"sub","name":"newhits_not_below_threshold","range":{"start":{"line":578,"character":0},"end":{"character":9999,"line":578}}},{"kind":12,"line":596,"children":[{"containerName":"hits_below_threshold","name":"throw_not_implemented","line":596,"kind":12}],"containerName":"main::","definition":"sub","name":"hits_below_threshold","range":{"end":{"line":596,"character":9999},"start":{"line":596,"character":0}}},{"kind":12,"children":[{"containerName":"add_hit","name":"throw_not_implemented","kind":12,"line":625}],"line":625,"name":"add_hit","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":625},"end":{"character":9999,"line":625}}},{"children":[{"containerName":"get_hit","name":"throw_not_implemented","line":646,"kind":12}],"line":646,"kind":12,"range":{"start":{"character":0,"line":646},"end":{"character":9999,"line":646}},"name":"get_hit","definition":"sub","containerName":"main::"}],"version":5}