{"version":5,"vars":[{"containerName":"","name":"base","line":94,"kind":2},{"name":"new","range":{"start":{"line":114,"character":0},"end":{"character":9999,"line":130}},"kind":12,"line":114,"children":[{"kind":13,"line":115,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":115},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":116,"kind":13},{"name":"$class","containerName":"new","line":116,"kind":13},{"kind":13,"line":116,"name":"@args","containerName":"new"},{"line":118,"kind":13,"name":"$self","containerName":"new"},{"line":118,"kind":12,"containerName":"new","name":"_setup"},{"name":"@args","containerName":"new","kind":13,"line":118},{"kind":13,"line":120,"containerName":"new","definition":"my","name":"$fields","localvar":"my"},{"name":"$self","containerName":"new","line":120,"kind":13},{"kind":12,"line":120,"name":"_fields","containerName":"new"},{"line":121,"kind":13,"localvar":"my","name":"$field","definition":"my","containerName":"new"},{"name":"$fields","containerName":"new","line":122,"kind":13},{"containerName":"new","name":"$field","line":122,"kind":13},{"name":"$hit_data","definition":"my","containerName":"new","localvar":"my","kind":13,"line":125},{"name":"$self","containerName":"new","line":125,"kind":13},{"line":125,"kind":12,"name":"_raw_hit_data","containerName":"new"},{"name":"$hit_data","containerName":"new","line":126,"kind":13},{"line":126,"kind":13,"name":"$hit_data","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$field","line":127,"kind":13},{"containerName":"new","name":"$fields","kind":13,"line":128},{"containerName":"new","name":"$field","line":128,"kind":13},{"line":128,"kind":13,"containerName":"new","name":"$hit_data"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastPullHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::BlastPullHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastPullHit - A parser and hit object for BLASTN hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BLASTN hit output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::BlastPullHit;\n\nuse strict;\n\nuse Bio::Search::HSP::BlastPullHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::BlastNHit->new();\n Function: Builds a new Bio::Search::Hit::BlastNHit object.\n Returns : Bio::Search::Hit::BlastNHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)"}},{"containerName":"new","name":"SUPER","kind":12,"line":116},{"line":132,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_dependencies","kind":12,"line":132},{"kind":12,"line":132,"name":"name"},{"name":"length","kind":12,"line":133},{"kind":12,"line":134,"name":"description"},{"name":"accession","kind":12,"line":135},{"kind":12,"line":136,"name":"next_hsp"},{"name":"query_start","kind":12,"line":137},{"line":138,"kind":12,"name":"query_end"},{"line":139,"kind":12,"name":"hit_start"},{"name":"hit_end","kind":12,"line":140},{"containerName":null,"name":"$self","kind":13,"line":142},{"range":{"start":{"character":0,"line":149},"end":{"character":9999,"line":176}},"containerName":"main::","name":"_discover_header","definition":"sub","line":149,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_discover_header","line":150,"kind":13},{"name":"$self","containerName":"_discover_header","kind":13,"line":151},{"name":"_chunk_seek","containerName":"_discover_header","line":151,"kind":12},{"kind":13,"line":152,"containerName":"_discover_header","name":"$header","definition":"my","localvar":"my"},{"containerName":"_discover_header","name":"$self","kind":13,"line":152},{"name":"_get_chunk_by_end","containerName":"_discover_header","line":152,"kind":12},{"name":"$header","containerName":"_discover_header","kind":13,"line":154},{"containerName":"_discover_header","name":"$self","line":157,"kind":13},{"containerName":"_discover_header","name":"_calculate_accession_from_name","kind":12,"line":157},{"name":"$self","containerName":"_discover_header","kind":13,"line":159},{"kind":12,"line":159,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":163,"name":"$self","containerName":"_discover_header"},{"line":163,"kind":13,"name":"$self","containerName":"_discover_header"},{"name":"_chunk_tell","containerName":"_discover_header","line":163,"kind":12},{"name":"$self","containerName":"_discover_header","line":165,"kind":13},{"line":165,"kind":12,"name":"_fields","containerName":"_discover_header"},{"name":"$self","containerName":"_discover_header","kind":13,"line":165},{"kind":12,"line":165,"name":"_fields","containerName":"_discover_header"},{"line":165,"kind":13,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","kind":12,"line":165},{"name":"$header","containerName":"_discover_header","kind":13,"line":165},{"kind":13,"line":166,"name":"$self","containerName":"_discover_header"},{"line":166,"kind":12,"name":"_fields","containerName":"_discover_header"},{"line":167,"kind":13,"name":"$self","containerName":"_discover_header"},{"kind":12,"line":167,"containerName":"_discover_header","name":"_fields"},{"name":"$self","containerName":"_discover_header","kind":13,"line":170},{"kind":12,"line":170,"name":"_fields","containerName":"_discover_header"},{"name":"$self","containerName":"_discover_header","line":173,"kind":13},{"kind":12,"line":173,"name":"_calculate_accession_from_name","containerName":"_discover_header"},{"containerName":"_discover_header","name":"$self","kind":13,"line":175},{"line":175,"kind":12,"containerName":"_discover_header","name":"_fields"}],"kind":12},{"name":"header","line":159,"kind":12},{"kind":12,"line":163,"name":"_after_header"},{"kind":12,"line":165,"name":"name"},{"line":165,"kind":12,"name":"description"},{"line":165,"kind":12,"name":"length"},{"line":166,"kind":12,"name":"description"},{"kind":12,"line":167,"name":"description"},{"name":"description","kind":12,"line":170},{"name":"header","line":175,"kind":12},{"children":[{"line":179,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_calculate_accession_from_name"},{"definition":"my","name":"$name","containerName":"_calculate_accession_from_name","localvar":"my","kind":13,"line":180},{"line":180,"kind":13,"name":"$self","containerName":"_calculate_accession_from_name"},{"name":"get_field","containerName":"_calculate_accession_from_name","line":180,"kind":12},{"containerName":"_calculate_accession_from_name","name":"$name","line":181,"kind":13},{"kind":13,"line":182,"name":"$self","containerName":"_calculate_accession_from_name"},{"kind":12,"line":182,"containerName":"_calculate_accession_from_name","name":"_fields"},{"containerName":"_calculate_accession_from_name","name":"$self","line":184,"kind":13},{"kind":12,"line":184,"name":"_fields","containerName":"_calculate_accession_from_name"},{"line":186,"kind":13,"name":"$self","containerName":"_calculate_accession_from_name"},{"kind":12,"line":186,"name":"_fields","containerName":"_calculate_accession_from_name"},{"containerName":"_calculate_accession_from_name","name":"$self","kind":13,"line":189},{"kind":12,"line":189,"name":"_fields","containerName":"_calculate_accession_from_name"},{"name":"$name","containerName":"_calculate_accession_from_name","kind":13,"line":189}],"line":178,"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"line":178,"character":0}},"name":"_calculate_accession_from_name","definition":"sub","containerName":"main::"},{"kind":12,"line":182,"name":"accession"},{"name":"name","line":184,"kind":12},{"name":"accession","line":186,"kind":12},{"name":"accession","kind":12,"line":189},{"range":{"end":{"character":9999,"line":220},"start":{"line":193,"character":0}},"definition":"sub","name":"_discover_start_end","containerName":"main::","children":[{"line":194,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_discover_start_end"},{"localvar":"my","definition":"my","name":"$q_start","containerName":"_discover_start_end","line":196,"kind":13},{"line":196,"kind":13,"name":"$q_end","containerName":"_discover_start_end"},{"kind":13,"line":196,"containerName":"_discover_start_end","name":"$h_start"},{"kind":13,"line":196,"name":"$h_end","containerName":"_discover_start_end"},{"name":"$hsp","definition":"my","containerName":"_discover_start_end","localvar":"my","kind":13,"line":197},{"kind":13,"line":197,"containerName":"_discover_start_end","name":"$self"},{"name":"hsps","containerName":"_discover_start_end","kind":12,"line":197},{"kind":13,"line":198,"definition":"my","name":"$this_q_start","containerName":"_discover_start_end","localvar":"my"},{"name":"$this_h_start","containerName":"_discover_start_end","kind":13,"line":198},{"line":198,"kind":13,"containerName":"_discover_start_end","name":"$hsp"},{"containerName":"_discover_start_end","name":"start","kind":12,"line":198},{"containerName":"_discover_start_end","name":"$this_q_end","definition":"my","localvar":"my","kind":13,"line":199},{"name":"$this_h_end","containerName":"_discover_start_end","line":199,"kind":13},{"kind":13,"line":199,"containerName":"_discover_start_end","name":"$hsp"},{"line":199,"kind":12,"containerName":"_discover_start_end","name":"end"},{"containerName":"_discover_start_end","name":"$q_start","kind":13,"line":201},{"line":201,"kind":13,"containerName":"_discover_start_end","name":"$this_q_start"},{"line":201,"kind":13,"name":"$q_start","containerName":"_discover_start_end"},{"containerName":"_discover_start_end","name":"$q_start","kind":13,"line":202},{"name":"$this_q_start","containerName":"_discover_start_end","line":202,"kind":13},{"line":204,"kind":13,"name":"$h_start","containerName":"_discover_start_end"},{"containerName":"_discover_start_end","name":"$this_h_start","line":204,"kind":13},{"line":204,"kind":13,"name":"$h_start","containerName":"_discover_start_end"},{"name":"$h_start","containerName":"_discover_start_end","line":205,"kind":13},{"name":"$this_h_start","containerName":"_discover_start_end","line":205,"kind":13},{"line":208,"kind":13,"containerName":"_discover_start_end","name":"$q_end"},{"kind":13,"line":208,"containerName":"_discover_start_end","name":"$this_q_end"},{"line":208,"kind":13,"name":"$q_end","containerName":"_discover_start_end"},{"name":"$q_end","containerName":"_discover_start_end","kind":13,"line":209},{"kind":13,"line":209,"containerName":"_discover_start_end","name":"$this_q_end"},{"name":"$h_end","containerName":"_discover_start_end","line":211,"kind":13},{"name":"$this_h_end","containerName":"_discover_start_end","line":211,"kind":13},{"name":"$h_end","containerName":"_discover_start_end","line":211,"kind":13},{"containerName":"_discover_start_end","name":"$h_end","line":212,"kind":13},{"containerName":"_discover_start_end","name":"$this_h_end","kind":13,"line":212},{"containerName":"_discover_start_end","name":"$self","line":216,"kind":13},{"containerName":"_discover_start_end","name":"_fields","kind":12,"line":216},{"line":216,"kind":13,"containerName":"_discover_start_end","name":"$q_start"},{"name":"$self","containerName":"_discover_start_end","kind":13,"line":217},{"containerName":"_discover_start_end","name":"_fields","line":217,"kind":12},{"name":"$q_end","containerName":"_discover_start_end","line":217,"kind":13},{"kind":13,"line":218,"containerName":"_discover_start_end","name":"$self"},{"name":"_fields","containerName":"_discover_start_end","line":218,"kind":12},{"kind":13,"line":218,"name":"$h_start","containerName":"_discover_start_end"},{"kind":13,"line":219,"containerName":"_discover_start_end","name":"$self"},{"containerName":"_discover_start_end","name":"_fields","kind":12,"line":219},{"kind":13,"line":219,"name":"$h_end","containerName":"_discover_start_end"}],"line":193,"kind":12},{"name":"query_start","line":216,"kind":12},{"name":"query_end","kind":12,"line":217},{"line":218,"kind":12,"name":"hit_start"},{"name":"hit_end","kind":12,"line":219},{"range":{"start":{"line":222,"character":0},"end":{"character":9999,"line":244}},"definition":"sub","name":"_discover_next_hsp","containerName":"main::","children":[{"localvar":"my","containerName":"_discover_next_hsp","definition":"my","name":"$self","line":223,"kind":13},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":224},{"containerName":"_discover_next_hsp","name":"_chunk_seek","line":224,"kind":12},{"kind":13,"line":224,"containerName":"_discover_next_hsp","name":"$self"},{"line":224,"kind":13,"name":"$self","containerName":"_discover_next_hsp"},{"definition":"my","name":"$start","containerName":"_discover_next_hsp","localvar":"my","kind":13,"line":226},{"line":226,"kind":13,"containerName":"_discover_next_hsp","name":"$end"},{"kind":13,"line":226,"containerName":"_discover_next_hsp","name":"$self"},{"kind":12,"line":226,"containerName":"_discover_next_hsp","name":"_find_chunk_by_end"},{"name":"$end","containerName":"_discover_next_hsp","kind":13,"line":227},{"name":"$end","containerName":"_discover_next_hsp","kind":13,"line":227},{"kind":13,"line":227,"name":"$self","containerName":"_discover_next_hsp"},{"kind":12,"line":227,"name":"_chunk_true_start","containerName":"_discover_next_hsp"},{"kind":13,"line":227,"containerName":"_discover_next_hsp","name":"$self"},{"name":"_chunk_true_end","containerName":"_discover_next_hsp","kind":12,"line":227},{"kind":13,"line":227,"containerName":"_discover_next_hsp","name":"$end"},{"kind":13,"line":228,"containerName":"_discover_next_hsp","name":"$start"},{"containerName":"_discover_next_hsp","name":"$self","kind":13,"line":228},{"line":228,"kind":13,"name":"$self","containerName":"_discover_next_hsp"},{"line":229,"kind":13,"containerName":"_discover_next_hsp","name":"$end"},{"line":229,"kind":13,"containerName":"_discover_next_hsp","name":"$self"},{"containerName":"_discover_next_hsp","name":"_chunk_true_end","kind":12,"line":229},{"name":"$end","containerName":"_discover_next_hsp","line":232,"kind":13},{"line":232,"kind":13,"name":"$self","containerName":"_discover_next_hsp"},{"line":232,"kind":12,"name":"_chunk_true_start","containerName":"_discover_next_hsp"},{"kind":13,"line":234,"containerName":"_discover_next_hsp","name":"$start"},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":234},{"name":"_chunk_true_start","containerName":"_discover_next_hsp","line":234,"kind":12},{"line":236,"kind":13,"containerName":"_discover_next_hsp","name":"$start"},{"containerName":"_discover_next_hsp","name":"$self","kind":13,"line":236},{"name":"_chunk_true_end","containerName":"_discover_next_hsp","kind":12,"line":236},{"containerName":"_discover_next_hsp","name":"$self","line":238,"kind":13},{"line":238,"kind":13,"containerName":"_discover_next_hsp","name":"$end"},{"name":"$self","containerName":"_discover_next_hsp","line":238,"kind":13},{"containerName":"_discover_next_hsp","name":"_chunk_true_start","line":238,"kind":12},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":242},{"containerName":"_discover_next_hsp","name":"_fields","line":242,"kind":12},{"line":242,"kind":12,"containerName":"_discover_next_hsp","name":"new"},{"containerName":"_discover_next_hsp","name":"$self","line":242,"kind":13},{"kind":13,"line":243,"containerName":"_discover_next_hsp","name":"$self"},{"kind":12,"line":243,"containerName":"_discover_next_hsp","name":"chunk"},{"kind":13,"line":243,"containerName":"_discover_next_hsp","name":"$start"},{"line":243,"kind":13,"containerName":"_discover_next_hsp","name":"$end"}],"line":222,"kind":12},{"name":"_end_of_previous_hsp","line":224,"kind":12},{"kind":12,"line":224,"name":"_after_header"},{"name":"_end_of_previous_hsp","line":228,"kind":12},{"line":228,"kind":12,"name":"_after_header"},{"name":"_end_of_previous_hsp","line":238,"kind":12},{"name":"next_hsp","kind":12,"line":242},{"line":242,"kind":12,"name":"Bio","containerName":"Search::HSP::BlastPullHSP"},{"containerName":"main::","name":"_discover_num_hsps","definition":"sub","range":{"start":{"character":0,"line":246},"end":{"character":9999,"line":249}},"kind":12,"line":246,"children":[{"localvar":"my","containerName":"_discover_num_hsps","definition":"my","name":"$self","line":247,"kind":13},{"containerName":"_discover_num_hsps","name":"$self","kind":13,"line":248},{"name":"_fields","containerName":"_discover_num_hsps","kind":12,"line":248},{"kind":13,"line":248,"name":"$self","containerName":"_discover_num_hsps"},{"containerName":"_discover_num_hsps","name":"hsps","line":248,"kind":12}]},{"name":"num_hsps","line":248,"kind":12},{"range":{"start":{"character":0,"line":262},"end":{"line":267,"character":9999}},"definition":"sub","name":"next_hsp","containerName":"main::","children":[{"kind":13,"line":263,"containerName":"next_hsp","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":264,"containerName":"next_hsp","definition":"my","name":"$hsp","localvar":"my"},{"line":264,"kind":13,"name":"$self","containerName":"next_hsp"},{"containerName":"next_hsp","name":"get_field","line":264,"kind":12},{"containerName":"next_hsp","name":"$self","kind":13,"line":265},{"kind":12,"line":265,"containerName":"next_hsp","name":"_fields"},{"name":"$hsp","containerName":"next_hsp","line":266,"kind":13}],"line":262,"kind":12},{"name":"next_hsp","line":265,"kind":12},{"line":279,"children":[{"definition":"my","name":"$self","containerName":"hsps","localvar":"my","kind":13,"line":280},{"line":281,"kind":13,"localvar":"my","containerName":"hsps","name":"$old","definition":"my"},{"containerName":"hsps","name":"$self","kind":13,"line":281},{"kind":13,"line":282,"containerName":"hsps","name":"$self"},{"kind":12,"line":282,"name":"rewind","containerName":"hsps"},{"localvar":"my","containerName":"hsps","name":"@hsps","definition":"my","line":283,"kind":13},{"kind":13,"line":284,"containerName":"hsps","definition":"my","name":"$hsp","localvar":"my"},{"name":"$self","containerName":"hsps","line":284,"kind":13},{"line":284,"kind":12,"name":"next_hsp","containerName":"hsps"},{"kind":13,"line":285,"containerName":"hsps","name":"@hsps"},{"line":285,"kind":13,"name":"$hsp","containerName":"hsps"},{"containerName":"hsps","name":"$self","line":287,"kind":13},{"name":"$old","containerName":"hsps","kind":13,"line":287},{"name":"@hsps","containerName":"hsps","kind":13,"line":288}],"kind":12,"range":{"start":{"character":0,"line":279},"end":{"line":289,"character":9999}},"containerName":"main::","definition":"sub","name":"hsps"},{"name":"_end_of_previous_hsp","kind":12,"line":281},{"kind":12,"line":287,"name":"_end_of_previous_hsp"},{"name":"hsp","range":{"start":{"line":309,"character":0},"end":{"character":9999,"line":313}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: BlastPullHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::BlastPullHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastPullHit - A parser and hit object for BLASTN hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BLASTN hit output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::BlastPullHit;\n\nuse strict;\n\nuse Bio::Search::HSP::BlastPullHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::BlastNHit->new();\n Function: Builds a new Bio::Search::Hit::BlastNHit object.\n Returns : Bio::Search::Hit::BlastNHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( header start_end )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n    my $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n    \n\t$self->_dependencies( { ( name => 'header',\n\t\t\t\t\t\t\t  length => 'header',\n\t\t\t\t\t\t\t  description => 'header',\n\t\t\t\t\t\t\t  accession => 'header',\n                              next_hsp => 'header',\n                              query_start => 'start_end',\n                              query_end => 'start_end',\n                              hit_start => 'start_end',\n                              hit_end => 'start_end' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"\\n Score = \");\n    \n    unless ($header) {\n        # no alignment or other data; all information was in the hit table of\n        # the result\n        $self->_calculate_accession_from_name;\n        \n        $self->_fields->{header} = 1;\n        return;\n    }\n    \n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n    ($self->_fields->{name}, $self->_fields->{description}, $self->_fields->{length}) = $header =~ /^(\\S+)\\s+(\\S.+?)?\\s+Length\\s*=\\s*(\\d+)/sm;\n    if ($self->_fields->{description}) {\n        $self->_fields->{description} =~ s/\\n//g;\n    }\n    else {\n        $self->_fields->{description} = '';\n    }\n\t\n    $self->_calculate_accession_from_name;\n\t\n\t$self->_fields->{header} = 1;\n}\n\nsub _calculate_accession_from_name {\n    my $self = shift;\n    my $name = $self->get_field('name');\n    if ($name =~ /.+?\\|.+?\\|.+?\\|(\\w+)/) {\n        $self->_fields->{accession} = $1;\n    }\n    elsif ($self->_fields->{name} =~ /.+?\\|(\\w+)?\\./) {\n        # old form?\n        $self->_fields->{accession} = $1;\n    }\n    else {\n        $self->_fields->{accession} = $name;\n    }\n}\n\nsub _discover_start_end {\n    my $self = shift;\n    \n    my ($q_start, $q_end, $h_start, $h_end);\n    foreach my $hsp ($self->hsps) {\n        my ($this_q_start, $this_h_start) = $hsp->start;\n        my ($this_q_end, $this_h_end) = $hsp->end;\n        \n        if (! defined $q_start || $this_q_start < $q_start) {\n            $q_start = $this_q_start;\n        }\n        if (! defined $h_start || $this_h_start < $h_start) {\n            $h_start = $this_h_start;\n        }\n        \n        if (! defined $q_end || $this_q_end > $q_end) {\n            $q_end = $this_q_end;\n        }\n        if (! defined $h_end || $this_h_end > $h_end) {\n            $h_end = $this_h_end;\n        }\n    }\n    \n    $self->_fields->{query_start} = $q_start;\n    $self->_fields->{query_end} = $q_end;\n    $self->_fields->{hit_start} = $h_start;\n    $self->_fields->{hit_end} = $h_end;\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n    $self->_chunk_seek($self->{_end_of_previous_hsp} || $self->{_after_header});\n    \n    my ($start, $end) = $self->_find_chunk_by_end(\"\\n Score = \");\n    if ((defined $end && ($end + $self->_chunk_true_start) > $self->_chunk_true_end) || ! $end) {\n\t\t$start = $self->{_end_of_previous_hsp} || $self->{_after_header};\n\t\t$end = $self->_chunk_true_end;\n\t}\n\telse {\n\t\t$end += $self->_chunk_true_start;\n\t}\n\t$start += $self->_chunk_true_start;\n    \n    return if $start >= $self->_chunk_true_end;\n    \n    $self->{_end_of_previous_hsp} = $end - $self->_chunk_true_start;\n    \n    #*** needs to inherit piped_behaviour, and we need to deal with _sequential\n\t#    ourselves\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::BlastPullHSP->new(-parent => $self,\n                                                                    -chunk => [$self->chunk, $start, $end]);\n}\n\nsub _discover_num_hsps {\n    my $self = shift;\n    $self->_fields->{num_hsps} = $self->hsps;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_end_of_previous_hsp};\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_end_of_previous_hsp} = $old;\n\treturn @hsps;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","parameters":[{"label":"$self"},{"label":"$type"}],"label":"hsp($self,$type)"},"detail":"($self,$type)","kind":12,"children":[{"line":310,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"hsp"},{"containerName":"hsp","name":"$type","line":310,"kind":13},{"containerName":"hsp","name":"$type","line":311,"kind":13},{"containerName":"hsp","name":"$self","kind":13,"line":312},{"line":312,"kind":12,"name":"throw_not_implemented","containerName":"hsp"}],"line":309},{"range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":326}},"containerName":"main::","name":"rewind","definition":"sub","line":326,"children":[{"line":327,"kind":13,"localvar":"my","containerName":"rewind","definition":"my","name":"$self"},{"line":328,"kind":13,"containerName":"rewind","name":"$self"}],"kind":12},{"name":"_end_of_previous_hsp","line":328,"kind":12},{"line":332,"children":[{"line":333,"kind":12,"name":"significance","containerName":"p"}],"kind":12,"range":{"start":{"character":0,"line":332},"end":{"character":9999,"line":334}},"containerName":"main::","name":"p","definition":"sub"}]}