{"version":5,"vars":[{"containerName":"","name":"vars","kind":2,"line":165},{"line":168,"kind":2,"containerName":"","name":"overload"},{"name":"to_string","line":168,"kind":12},{"name":"base","containerName":"","line":170,"kind":2},{"kind":13,"line":172,"name":"$GAP_SYMBOL","containerName":null},{"name":"%STRAND_SYMBOL","containerName":null,"kind":13,"line":173},{"kind":12,"children":[{"line":212,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","name":"@args","kind":13,"line":212},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":214,"kind":13},{"containerName":"new","name":"$class","line":214,"kind":13},{"line":214,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":216},{"line":216,"kind":13,"containerName":"new","name":"$self"},{"line":217,"kind":13,"localvar":"my","name":"$raw_data","definition":"my","containerName":"new"},{"name":"$qname","containerName":"new","kind":13,"line":217},{"kind":13,"line":217,"containerName":"new","name":"$hname"},{"containerName":"new","name":"$qlen","kind":13,"line":217},{"name":"$hlen","containerName":"new","kind":13,"line":217},{"name":"$self","containerName":"new","line":219,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":219},{"kind":13,"line":219,"containerName":"new","name":"$raw_data"},{"kind":13,"line":220,"name":"$qname","containerName":"new"},{"containerName":"new","name":"$hname","kind":13,"line":220},{"line":221,"kind":13,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":221},{"kind":13,"line":226,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":230},{"name":"_set_data","containerName":"new","kind":12,"line":230},{"kind":13,"line":230,"name":"$raw_data","containerName":"new"}],"line":210,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>"},"detail":"($class,@args)","name":"new","range":{"end":{"character":9999,"line":230},"start":{"line":210,"character":0}}},{"line":214,"kind":12,"name":"SUPER","containerName":"new"},{"name":"$qb","definition":"my","containerName":null,"localvar":"my","kind":13,"line":232},{"containerName":null,"name":"$hb","line":232,"kind":13},{"line":232,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":232,"name":"start","containerName":"main::"},{"line":233,"kind":13,"localvar":"my","definition":"my","name":"$qe","containerName":null},{"name":"$he","containerName":null,"line":233,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":233},{"line":233,"kind":12,"containerName":"main::","name":"end"},{"line":234,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$qs"},{"kind":13,"line":234,"containerName":null,"name":"$hs"},{"containerName":null,"name":"$self","line":234,"kind":13},{"name":"strand","containerName":"main::","line":234,"kind":12},{"localvar":"my","name":"$qf","definition":"my","containerName":null,"line":235,"kind":13},{"containerName":null,"name":"$hf","kind":13,"line":235},{"containerName":null,"name":"$self","line":235,"kind":13},{"line":235,"kind":12,"containerName":"main::","name":"query"},{"containerName":"main::","name":"frame","kind":12,"line":235},{"kind":13,"line":236,"name":"$self","containerName":null},{"kind":12,"line":236,"containerName":"main::","name":"hit"},{"containerName":"main::","name":"frame","line":236,"kind":12},{"name":"$self","containerName":null,"line":238,"kind":13},{"containerName":"main::","name":"query","line":238,"kind":12},{"name":"Bio","containerName":"SeqFeature::Similarity","kind":12,"line":238},{"name":"new","containerName":"main::","line":238,"kind":12},{"containerName":null,"name":"$qb","line":238,"kind":13},{"name":"$qe","containerName":null,"kind":13,"line":239},{"kind":13,"line":240,"containerName":null,"name":"$qs"},{"kind":13,"line":241,"containerName":null,"name":"$self"},{"containerName":"main::","name":"bits","kind":12,"line":241},{"kind":13,"line":242,"name":"$self","containerName":null},{"kind":12,"line":242,"name":"score","containerName":"main::"},{"name":"$qf","containerName":null,"kind":13,"line":243},{"kind":13,"line":244,"containerName":null,"name":"$qname"},{"kind":13,"line":245,"containerName":null,"name":"%self"},{"line":247,"kind":13,"containerName":null,"name":"$self"},{"line":247,"kind":12,"name":"hit","containerName":"main::"},{"kind":12,"line":247,"containerName":"SeqFeature::Similarity","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":247},{"containerName":null,"name":"$hb","kind":13,"line":247},{"line":248,"kind":13,"name":"$he","containerName":null},{"kind":13,"line":249,"name":"$hs","containerName":null},{"kind":13,"line":250,"name":"$self","containerName":null},{"name":"bits","containerName":"main::","kind":12,"line":250},{"name":"$self","containerName":null,"kind":13,"line":251},{"name":"score","containerName":"main::","kind":12,"line":251},{"containerName":null,"name":"$hf","line":252,"kind":13},{"containerName":null,"name":"$hname","kind":13,"line":253},{"kind":13,"line":254,"name":"%self","containerName":null},{"line":257,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"query","kind":12,"line":257},{"line":257,"kind":12,"containerName":"main::","name":"seqlength"},{"containerName":null,"name":"$qlen","line":257,"kind":13},{"line":258,"kind":13,"name":"$self","containerName":null},{"line":258,"kind":12,"containerName":"main::","name":"hit"},{"kind":12,"line":258,"name":"seqlength","containerName":"main::"},{"line":258,"kind":13,"containerName":null,"name":"$hlen"},{"name":"$self","containerName":null,"kind":13,"line":260},{"line":260,"kind":12,"name":"query","containerName":"main::"},{"containerName":"main::","name":"frac_identical","line":260,"kind":12},{"line":260,"kind":13,"containerName":null,"name":"$self"},{"line":260,"kind":12,"name":"frac_identical","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":261},{"containerName":"main::","name":"hit","line":261,"kind":12},{"line":261,"kind":12,"containerName":"main::","name":"frac_identical"},{"containerName":null,"name":"$self","kind":13,"line":261},{"name":"frac_identical","containerName":"main::","kind":12,"line":261},{"line":262,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":276,"children":[{"kind":13,"line":277,"containerName":"_id_str","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":278,"containerName":"_id_str","name":"$self"},{"kind":13,"line":279,"containerName":"_id_str","definition":"my","name":"$qname","localvar":"my"},{"name":"$self","containerName":"_id_str","kind":13,"line":279},{"kind":12,"line":279,"containerName":"_id_str","name":"query"},{"kind":12,"line":279,"containerName":"_id_str","name":"seqname"},{"kind":13,"line":280,"containerName":"_id_str","name":"$hname","definition":"my","localvar":"my"},{"name":"$self","containerName":"_id_str","line":280,"kind":13},{"kind":12,"line":280,"containerName":"_id_str","name":"hit"},{"kind":12,"line":280,"name":"seqname","containerName":"_id_str"},{"containerName":"_id_str","name":"$self","kind":13,"line":281},{"containerName":"_id_str","name":"$self","line":283,"kind":13}],"containerName":"main::","name":"_id_str","definition":"sub","range":{"start":{"line":276,"character":0},"end":{"line":284,"character":9999}}},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"algorithm($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":307,"kind":13,"localvar":"my","containerName":"algorithm","name":"$self","definition":"my"},{"containerName":"algorithm","name":"@args","line":307,"kind":13},{"kind":13,"line":308,"containerName":"algorithm","name":"$self"}],"line":305,"kind":12,"range":{"end":{"line":309,"character":9999},"start":{"line":305,"character":0}},"name":"algorithm"},{"range":{"start":{"character":0,"line":332},"end":{"character":9999,"line":337}},"containerName":"main::","definition":"sub","name":"signif","line":332,"children":[{"definition":"my","name":"$self","containerName":"signif","localvar":"my","kind":13,"line":334},{"kind":13,"line":335,"name":"$val","definition":"my","containerName":"signif","localvar":"my"},{"kind":13,"line":335,"containerName":"signif","name":"$self"},{"kind":13,"line":335,"name":"$self","containerName":"signif"},{"kind":13,"line":335,"name":"$self","containerName":"signif"},{"line":336,"kind":13,"name":"$val","containerName":"signif"}],"kind":12},{"kind":12,"children":[],"line":357,"definition":"sub","name":"evalue","containerName":"main::","range":{"end":{"line":357,"character":9999},"start":{"line":357,"character":0}}},{"children":[{"definition":"my","name":"$self","containerName":"p","localvar":"my","kind":13,"line":378},{"kind":13,"line":378,"containerName":"p","name":"$self"}],"line":378,"kind":12,"range":{"end":{"character":9999,"line":378},"start":{"line":378,"character":0}},"name":"p","definition":"sub","containerName":"main::"},{"range":{"end":{"line":382,"character":9999},"start":{"character":0,"line":382}},"definition":"sub","name":"pvalue","containerName":"main::","children":[{"kind":12,"line":382,"name":"p","containerName":"pvalue"}],"line":382,"kind":12},{"line":402,"children":[{"line":406,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"length"},{"containerName":"length","name":"$seqType","line":406,"kind":13},{"containerName":"length","name":"$seqType","line":407,"kind":13},{"containerName":"length","name":"$seqType","kind":13,"line":408},{"name":"$seqType","containerName":"length","kind":13,"line":408},{"kind":13,"line":410,"containerName":"length","name":"$seqType"},{"kind":13,"line":410,"containerName":"length","name":"$self"},{"name":"_set_seq_data","containerName":"length","line":410,"kind":12},{"kind":13,"line":410,"name":"$self","containerName":"length"},{"line":413,"kind":13,"containerName":"length","name":"$seqType"},{"containerName":"length","name":"$self","line":414,"kind":13},{"line":414,"kind":13,"containerName":"length","name":"$seqType"}],"kind":12,"detail":"($self,$seqType)","signature":{"label":"length($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":402},"end":{"line":415,"character":9999}},"name":"length"},{"name":"gaps","range":{"start":{"line":441,"character":0},"end":{"line":461,"character":9999}},"kind":12,"line":441,"children":[{"localvar":"my","containerName":"gaps","name":"$self","definition":"my","line":443,"kind":13},{"kind":13,"line":443,"containerName":"gaps","name":"$seqType"},{"containerName":"gaps","name":"$self","kind":13,"line":445},{"line":445,"kind":12,"containerName":"gaps","name":"_set_seq_data"},{"kind":13,"line":445,"containerName":"gaps","name":"$self"},{"name":"$seqType","containerName":"gaps","line":447,"kind":13},{"name":"$seqType","containerName":"gaps","line":448,"kind":13},{"name":"$seqType","containerName":"gaps","line":448,"kind":13},{"containerName":"gaps","name":"$seqType","line":450,"kind":13},{"containerName":"gaps","name":"$self","kind":13,"line":451},{"line":451,"kind":13,"containerName":"gaps","name":"$self"},{"containerName":"gaps","name":"$seqType","line":454,"kind":13},{"name":"$self","containerName":"gaps","line":455,"kind":13},{"kind":13,"line":455,"containerName":"gaps","name":"$self"},{"line":458,"kind":13,"name":"$seqType","containerName":"gaps"},{"name":"$self","containerName":"gaps","kind":13,"line":459},{"name":"$seqType","containerName":"gaps","line":459,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"gaps($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>"}},{"children":[{"line":499,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"frac_identical"},{"name":"$seqType","containerName":"frac_identical","line":499,"kind":13},{"line":500,"kind":13,"name":"$seqType","containerName":"frac_identical"},{"name":"$seqType","containerName":"frac_identical","kind":13,"line":501},{"name":"$seqType","containerName":"frac_identical","line":501,"kind":13},{"line":503,"kind":13,"name":"$seqType","containerName":"frac_identical"},{"line":504,"kind":13,"containerName":"frac_identical","name":"$self"},{"name":"_set_seq_data","containerName":"frac_identical","line":504,"kind":12},{"name":"$self","containerName":"frac_identical","kind":13,"line":504},{"kind":13,"line":507,"name":"$seqType","containerName":"frac_identical"},{"kind":13,"line":509,"name":"$self","containerName":"frac_identical"},{"line":509,"kind":13,"name":"$self","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$seqType","line":509,"kind":13}],"line":493,"kind":12,"signature":{"label":"frac_identical($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>"},"detail":"($self,$seqType)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":493},"end":{"character":9999,"line":510}},"name":"frac_identical"},{"kind":12,"line":544,"children":[{"kind":13,"line":550,"name":"$self","definition":"my","containerName":"frac_conserved","localvar":"my"},{"containerName":"frac_conserved","name":"$seqType","line":550,"kind":13},{"containerName":"frac_conserved","name":"$seqType","line":551,"kind":13},{"kind":13,"line":552,"name":"$seqType","containerName":"frac_conserved"},{"name":"$seqType","containerName":"frac_conserved","line":552,"kind":13},{"name":"$seqType","containerName":"frac_conserved","line":554,"kind":13},{"containerName":"frac_conserved","name":"$self","line":555,"kind":13},{"containerName":"frac_conserved","name":"_set_seq_data","line":555,"kind":12},{"line":555,"kind":13,"name":"$self","containerName":"frac_conserved"},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":559},{"kind":13,"line":561,"containerName":"frac_conserved","name":"$self"},{"kind":13,"line":561,"name":"$self","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$seqType","kind":13,"line":561}],"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"frac_conserved($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>"},"name":"frac_conserved","range":{"end":{"line":562,"character":9999},"start":{"line":544,"character":0}}},{"name":"query_string","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":576},"end":{"line":576,"character":9999}},"kind":12,"children":[{"kind":12,"line":576,"name":"seq_str","containerName":"query_string"}],"line":576},{"name":"hit_string","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":591},"end":{"character":9999,"line":591}},"kind":12,"children":[{"kind":12,"line":591,"name":"seq_str","containerName":"hit_string"}],"line":591},{"children":[{"line":609,"kind":12,"name":"seq_str","containerName":"homology_string"}],"line":609,"kind":12,"range":{"start":{"character":0,"line":609},"end":{"line":609,"character":9999}},"definition":"sub","name":"homology_string","containerName":"main::"},{"line":625,"children":[{"containerName":"expect","name":"evalue","kind":12,"line":625}],"kind":12,"range":{"end":{"line":625,"character":9999},"start":{"line":625,"character":0}},"containerName":"main::","name":"expect","definition":"sub"},{"definition":"sub","name":"rank","containerName":"main::","range":{"start":{"line":642,"character":0},"end":{"character":9999,"line":642}},"kind":12,"children":[],"line":642},{"line":647,"children":[{"name":"rank","containerName":"name","kind":12,"line":647}],"kind":12,"range":{"start":{"character":0,"line":647},"end":{"line":647,"character":9999}},"containerName":"main::","name":"name","definition":"sub"},{"name":"to_string","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":666},"end":{"line":670,"character":9999}},"kind":12,"children":[{"kind":13,"line":668,"containerName":"to_string","name":"$self","definition":"my","localvar":"my"},{"line":669,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"rank","line":669,"kind":12}],"line":666},{"containerName":"main::","name":"_set_data","definition":"sub","range":{"start":{"character":0,"line":689},"end":{"character":9999,"line":758}},"kind":12,"line":689,"children":[{"line":691,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_set_data"},{"name":"@data","definition":"my","containerName":"_set_data","localvar":"my","kind":13,"line":692},{"containerName":"_set_data","name":"@queryList","definition":"my","localvar":"my","kind":13,"line":693},{"kind":13,"line":694,"name":"@sbjctList","definition":"my","containerName":"_set_data","localvar":"my"},{"name":"@matchList","definition":"my","containerName":"_set_data","localvar":"my","kind":13,"line":695},{"containerName":"_set_data","name":"$matchLine","definition":"my","localvar":"my","kind":13,"line":696},{"line":697,"kind":13,"localvar":"my","definition":"my","name":"@linedat","containerName":"_set_data"},{"line":701,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_set_data"},{"name":"$aln_row_len","containerName":"_set_data","kind":13,"line":701},{"kind":13,"line":701,"containerName":"_set_data","name":"$length_diff"},{"containerName":"_set_data","name":"$length_diff","line":702,"kind":13},{"kind":13,"line":713,"containerName":"_set_data","name":"$line"},{"containerName":"_set_data","name":"@data","kind":13,"line":713},{"line":714,"kind":13,"containerName":"_set_data","name":"$line"},{"name":"$line","containerName":"_set_data","line":716,"kind":13},{"kind":13,"line":717,"name":"$self","containerName":"_set_data"},{"name":"_set_score_stats","containerName":"_set_data","line":717,"kind":12},{"name":"$line","containerName":"_set_data","kind":13,"line":717},{"kind":13,"line":718,"containerName":"_set_data","name":"$line"},{"containerName":"_set_data","name":"$self","kind":13,"line":719},{"containerName":"_set_data","name":"_set_match_stats","kind":12,"line":719},{"name":"$line","containerName":"_set_data","line":719,"kind":13},{"containerName":"_set_data","name":"$line","line":720,"kind":13},{"localvar":"my","definition":"my","name":"$frame","containerName":"_set_data","line":724,"kind":13},{"kind":13,"line":725,"containerName":"_set_data","name":"$self"},{"line":725,"kind":12,"name":"frame","containerName":"_set_data"},{"containerName":"_set_data","name":"$frame","line":725,"kind":13},{"kind":13,"line":726,"containerName":"_set_data","name":"$line"},{"line":727,"kind":13,"containerName":"_set_data","name":"@queryList"},{"line":727,"kind":13,"name":"$line","containerName":"_set_data"},{"containerName":"_set_data","name":"$self","line":728,"kind":13},{"line":729,"kind":13,"name":"$aln_row_len","containerName":"_set_data"},{"name":"$matchLine","containerName":"_set_data","kind":13,"line":730},{"name":"$matchLine","containerName":"_set_data","kind":13,"line":731},{"containerName":"_set_data","name":"$length_diff","kind":13,"line":733},{"containerName":"_set_data","name":"$aln_row_len","line":733,"kind":13},{"containerName":"_set_data","name":"$line","line":733,"kind":13},{"line":734,"kind":13,"containerName":"_set_data","name":"$length_diff"},{"kind":13,"line":734,"containerName":"_set_data","name":"$line"},{"kind":13,"line":734,"containerName":"_set_data","name":"$length_diff"},{"name":"@matchList","containerName":"_set_data","kind":13,"line":735},{"line":735,"kind":13,"name":"$line","containerName":"_set_data"},{"name":"$matchLine","containerName":"_set_data","line":736,"kind":13},{"kind":13,"line":737,"containerName":"_set_data","name":"$line"},{"line":738,"kind":13,"name":"@sbjctList","containerName":"_set_data"},{"line":738,"kind":13,"name":"$line","containerName":"_set_data"},{"kind":13,"line":743,"name":"$self","containerName":"_set_data"},{"containerName":"_set_data","name":"@queryList","kind":13,"line":743},{"containerName":"_set_data","name":"$self","line":744,"kind":13},{"name":"@sbjctList","containerName":"_set_data","line":744,"kind":13},{"kind":13,"line":747,"name":"$self","containerName":"_set_data"},{"line":747,"kind":13,"name":"@matchList","containerName":"_set_data"},{"name":"$self","containerName":"_set_data","kind":13,"line":749},{"name":"$id_str","definition":"my","containerName":"_set_data","localvar":"my","kind":13,"line":750},{"name":"$self","containerName":"_set_data","kind":13,"line":750},{"containerName":"_set_data","name":"_id_str","line":750,"kind":12},{"line":751,"kind":13,"name":"$self","containerName":"_set_data"},{"kind":12,"line":751,"containerName":"_set_data","name":"throw"},{"line":754,"kind":13,"containerName":"_set_data","name":"@queryList"},{"name":"@sbjctList","containerName":"_set_data","kind":13,"line":754},{"localvar":"my","name":"$id_str","definition":"my","containerName":"_set_data","line":755,"kind":13},{"name":"$self","containerName":"_set_data","line":755,"kind":13},{"line":755,"kind":12,"name":"_id_str","containerName":"_set_data"},{"name":"$self","containerName":"_set_data","line":756,"kind":13},{"name":"throw","containerName":"_set_data","kind":12,"line":756}]},{"name":"CORE","containerName":"length","line":728,"kind":12},{"containerName":"length","name":"CORE","kind":12,"line":729},{"containerName":"length","name":"CORE","kind":12,"line":729},{"line":734,"kind":12,"name":"CORE","containerName":"length"},{"kind":12,"line":778,"children":[{"name":"$self","definition":"my","containerName":"_set_score_stats","localvar":"my","kind":13,"line":780},{"kind":13,"line":780,"containerName":"_set_score_stats","name":"$data"},{"localvar":"my","name":"$expect","definition":"my","containerName":"_set_score_stats","line":782,"kind":13},{"name":"$p","containerName":"_set_score_stats","kind":13,"line":782},{"kind":13,"line":784,"name":"$data","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"$self","kind":13,"line":786},{"name":"bits","containerName":"_set_score_stats","line":786,"kind":12},{"kind":13,"line":787,"name":"$self","containerName":"_set_score_stats"},{"kind":12,"line":787,"name":"score","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"$expect","line":788,"kind":13},{"line":789,"kind":13,"containerName":"_set_score_stats","name":"$data"},{"name":"$self","containerName":"_set_score_stats","line":791,"kind":13},{"kind":12,"line":791,"name":"bits","containerName":"_set_score_stats"},{"kind":13,"line":792,"name":"$self","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"score","line":792,"kind":12},{"kind":13,"line":793,"containerName":"_set_score_stats","name":"$self"},{"containerName":"_set_score_stats","name":"$expect","kind":13,"line":794},{"line":796,"kind":13,"name":"$data","containerName":"_set_score_stats"},{"name":"$self","containerName":"_set_score_stats","line":798,"kind":13},{"containerName":"_set_score_stats","name":"score","kind":12,"line":798},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":799},{"containerName":"_set_score_stats","name":"bits","line":799,"kind":12},{"name":"$expect","containerName":"_set_score_stats","kind":13,"line":800},{"line":801,"kind":13,"containerName":"_set_score_stats","name":"$p"},{"name":"$data","containerName":"_set_score_stats","line":803,"kind":13},{"containerName":"_set_score_stats","name":"$self","line":805,"kind":13},{"containerName":"_set_score_stats","name":"score","line":805,"kind":12},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":806},{"kind":12,"line":806,"containerName":"_set_score_stats","name":"bits"},{"kind":13,"line":807,"containerName":"_set_score_stats","name":"$expect"},{"line":808,"kind":13,"name":"$self","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"$p","line":809,"kind":13},{"containerName":"_set_score_stats","definition":"my","name":"$id_str","localvar":"my","kind":13,"line":812},{"kind":13,"line":812,"name":"$self","containerName":"_set_score_stats"},{"kind":12,"line":812,"name":"_id_str","containerName":"_set_score_stats"},{"kind":13,"line":813,"name":"$self","containerName":"_set_score_stats"},{"kind":12,"line":813,"name":"throw","containerName":"_set_score_stats"},{"name":"$data","containerName":"_set_score_stats","line":815,"kind":13},{"containerName":"_set_score_stats","name":"$expect","line":817,"kind":13},{"line":817,"kind":13,"name":"$expect","containerName":"_set_score_stats"},{"name":"$p","containerName":"_set_score_stats","line":818,"kind":13},{"containerName":"_set_score_stats","name":"$p","kind":13,"line":818},{"containerName":"_set_score_stats","name":"$p","line":818,"kind":13},{"name":"$self","containerName":"_set_score_stats","line":820,"kind":13},{"containerName":"_set_score_stats","name":"$expect","kind":13,"line":820},{"kind":13,"line":821,"name":"$self","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"$p","kind":13,"line":821},{"line":822,"kind":13,"containerName":"_set_score_stats","name":"$self"},{"line":822,"kind":12,"name":"significance","containerName":"_set_score_stats"},{"containerName":"_set_score_stats","name":"$p","kind":13,"line":822},{"line":822,"kind":13,"name":"$expect","containerName":"_set_score_stats"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>","parameters":[{"label":"$self"},{"label":"$data"}],"label":"_set_score_stats($self,$data)"},"name":"_set_score_stats","range":{"end":{"line":823,"character":9999},"start":{"line":778,"character":0}}},{"detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>","label":"_set_match_stats($self,$data)"},"containerName":"main::","definition":"sub","line":849,"children":[{"kind":13,"line":851,"definition":"my","name":"$self","containerName":"_set_match_stats","localvar":"my"},{"line":851,"kind":13,"containerName":"_set_match_stats","name":"$data"},{"kind":13,"line":853,"containerName":"_set_match_stats","name":"$data"},{"line":855,"kind":13,"containerName":"_set_match_stats","name":"$self"},{"line":856,"kind":13,"containerName":"_set_match_stats","name":"$self"},{"containerName":"_set_match_stats","name":"$data","line":859,"kind":13},{"line":861,"kind":13,"name":"$self","containerName":"_set_match_stats"},{"kind":13,"line":862,"containerName":"_set_match_stats","name":"$self"},{"line":865,"kind":13,"containerName":"_set_match_stats","name":"$data"},{"name":"$self","containerName":"_set_match_stats","line":866,"kind":13},{"kind":12,"line":866,"name":"frame","containerName":"_set_match_stats"},{"name":"$data","containerName":"_set_match_stats","line":871,"kind":13},{"kind":13,"line":872,"containerName":"_set_match_stats","name":"$self"},{"name":"$self","containerName":"_set_match_stats","kind":13,"line":873}],"kind":12,"range":{"start":{"line":849,"character":0},"end":{"line":881,"character":9999}},"name":"_set_match_stats"},{"range":{"end":{"line":906,"character":9999},"start":{"line":902,"character":0}},"containerName":"main::","definition":"sub","name":"_set_seq_data","line":902,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_set_seq_data","line":904,"kind":13},{"containerName":"_set_seq_data","name":"$self","line":906,"kind":13},{"kind":12,"line":906,"containerName":"_set_seq_data","name":"_set_seq"},{"name":"$self","containerName":"_set_seq_data","kind":13,"line":906}],"kind":12},{"kind":13,"line":907,"name":"$self","containerName":null},{"name":"_set_seq","containerName":"main::","line":907,"kind":12},{"name":"%self","containerName":null,"line":907,"kind":13},{"line":910,"kind":13,"containerName":null,"name":"%self"},{"line":910,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":911},{"line":912,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":914,"containerName":null,"name":"%self"},{"name":"_set_seq","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1005},"start":{"line":942,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"_set_seq","definition":"my","name":"$self","line":944,"kind":13},{"localvar":"my","containerName":"_set_seq","name":"$seqType","definition":"my","line":945,"kind":13},{"localvar":"my","definition":"my","name":"@data","containerName":"_set_seq","line":946,"kind":13},{"containerName":"_set_seq","name":"@ranges","definition":"my","localvar":"my","kind":13,"line":947},{"localvar":"my","containerName":"_set_seq","name":"@sequence","definition":"my","line":948,"kind":13},{"definition":"my","name":"$numGaps","containerName":"_set_seq","localvar":"my","kind":13,"line":949},{"line":951,"kind":13,"containerName":"_set_seq","name":"@data"},{"containerName":"_set_seq","name":"@ranges","kind":13,"line":953},{"kind":13,"line":954,"name":"@sequence","containerName":"_set_seq"},{"containerName":"_set_seq","name":"$self","kind":13,"line":957},{"containerName":"_set_seq","name":"warn","kind":12,"line":957},{"containerName":"_set_seq","name":"@sequence","line":961,"kind":13},{"line":961,"kind":13,"name":"@ranges","containerName":"_set_seq"},{"kind":13,"line":962,"definition":"my","name":"$id_str","containerName":"_set_seq","localvar":"my"},{"kind":13,"line":962,"containerName":"_set_seq","name":"$self"},{"kind":12,"line":962,"containerName":"_set_seq","name":"_id_str"},{"containerName":"_set_seq","name":"$self","line":963,"kind":13},{"kind":12,"line":963,"name":"throw","containerName":"_set_seq"},{"line":967,"kind":13,"containerName":"_set_seq","name":"$seqType"},{"name":"$self","containerName":"_set_seq","kind":13,"line":968},{"line":968,"kind":13,"name":"$seqType","containerName":"_set_seq"},{"line":968,"kind":13,"name":"$ranges","containerName":"_set_seq"},{"name":"$self","containerName":"_set_seq","line":969,"kind":13},{"kind":13,"line":969,"containerName":"_set_seq","name":"$seqType"},{"line":969,"kind":13,"name":"$ranges","containerName":"_set_seq"},{"containerName":"_set_seq","name":"$self","line":970,"kind":13},{"name":"$seqType","containerName":"_set_seq","kind":13,"line":970},{"containerName":"_set_seq","name":"@sequence","line":970,"kind":13},{"kind":13,"line":972,"name":"$self","containerName":"_set_seq"},{"name":"$seqType","containerName":"_set_seq","kind":13,"line":972},{"kind":13,"line":972,"name":"$ranges","containerName":"_set_seq"},{"name":"$ranges","containerName":"_set_seq","kind":13,"line":972},{"kind":13,"line":977,"containerName":"_set_seq","definition":"my","name":"$prog","localvar":"my"},{"name":"$self","containerName":"_set_seq","line":977,"kind":13},{"kind":12,"line":977,"containerName":"_set_seq","name":"algorithm"},{"kind":13,"line":978,"containerName":"_set_seq","name":"$prog"},{"kind":13,"line":978,"containerName":"_set_seq","name":"$seqType"},{"containerName":"_set_seq","name":"$self","kind":13,"line":979},{"containerName":"_set_seq","name":"$seqType","line":979,"kind":13},{"line":980,"kind":13,"name":"$prog","containerName":"_set_seq"},{"name":"$seqType","containerName":"_set_seq","line":980,"kind":13},{"kind":13,"line":981,"name":"$self","containerName":"_set_seq"},{"name":"$seqType","containerName":"_set_seq","line":981,"kind":13},{"name":"$prog","containerName":"_set_seq","line":982,"kind":13},{"name":"$self","containerName":"_set_seq","kind":13,"line":983},{"line":983,"kind":13,"name":"$seqType","containerName":"_set_seq"},{"kind":13,"line":986,"name":"$prog","containerName":"_set_seq"},{"name":"$self","containerName":"_set_seq","kind":13,"line":987},{"name":"$seqType","containerName":"_set_seq","line":987,"kind":13},{"name":"$prog","containerName":"_set_seq","line":987,"kind":13},{"name":"$self","containerName":"_set_seq","kind":13,"line":988},{"kind":13,"line":988,"name":"$seqType","containerName":"_set_seq"},{"name":"$prog","containerName":"_set_seq","line":988,"kind":13},{"line":988,"kind":13,"containerName":"_set_seq","name":"$seqType"},{"containerName":"_set_seq","name":"$self","kind":13,"line":991},{"kind":13,"line":991,"name":"$seqType","containerName":"_set_seq"},{"line":991,"kind":13,"containerName":"_set_seq","name":"$self"},{"name":"$seqType","containerName":"_set_seq","kind":13,"line":991},{"containerName":"_set_seq","name":"$self","line":992,"kind":13},{"kind":13,"line":992,"name":"$seqType","containerName":"_set_seq"},{"containerName":"_set_seq","name":"$self","line":992,"kind":13},{"name":"$seqType","containerName":"_set_seq","line":992,"kind":13},{"kind":13,"line":993,"name":"$self","containerName":"_set_seq"},{"containerName":"_set_seq","name":"$seqType","line":993,"kind":13},{"line":993,"kind":13,"name":"$self","containerName":"_set_seq"},{"containerName":"_set_seq","name":"$seqType","line":993,"kind":13},{"line":994,"kind":13,"name":"$self","containerName":"_set_seq"},{"kind":13,"line":994,"name":"$seqType","containerName":"_set_seq"},{"localvar":"my","containerName":"_set_seq","name":"$seqstr","definition":"my","line":1000,"kind":13},{"kind":13,"line":1000,"name":"@sequence","containerName":"_set_seq"},{"line":1001,"kind":13,"containerName":"_set_seq","name":"$seqstr"},{"definition":"my","name":"$num_gaps","containerName":"_set_seq","localvar":"my","kind":13,"line":1002},{"containerName":"_set_seq","name":"$seqstr","kind":13,"line":1002},{"name":"$self","containerName":"_set_seq","line":1002,"kind":13},{"containerName":"_set_seq","name":"$seqType","kind":13,"line":1002},{"name":"$self","containerName":"_set_seq","kind":13,"line":1003},{"containerName":"_set_seq","name":"$seqType","line":1003,"kind":13},{"line":1003,"kind":13,"name":"$num_gaps","containerName":"_set_seq"},{"kind":13,"line":1003,"name":"$num_gaps","containerName":"_set_seq"}],"line":942},{"name":"ranges","line":969,"kind":12},{"line":972,"kind":12,"name":"ranges"},{"containerName":"length","name":"CORE","kind":12,"line":1002},{"containerName":"main::","definition":"sub","name":"_set_residues","range":{"start":{"line":1025,"character":0},"end":{"character":9999,"line":1042}},"kind":12,"line":1025,"children":[{"containerName":"_set_residues","name":"$self","definition":"my","localvar":"my","kind":13,"line":1027},{"line":1028,"kind":13,"localvar":"my","definition":"my","name":"@sequence","containerName":"_set_residues"},{"containerName":"_set_residues","name":"$self","kind":13,"line":1030},{"name":"_set_seq_data","containerName":"_set_residues","kind":12,"line":1030},{"name":"$self","containerName":"_set_residues","line":1030,"kind":13},{"line":1033,"kind":13,"localvar":"my","name":"%identicalList_query","definition":"my","containerName":"_set_residues"},{"localvar":"my","definition":"my","name":"%identicalList_sbjct","containerName":"_set_residues","line":1034,"kind":13},{"localvar":"my","containerName":"_set_residues","name":"%conservedList_query","definition":"my","line":1035,"kind":13},{"localvar":"my","definition":"my","name":"%conservedList_sbjct","containerName":"_set_residues","line":1036,"kind":13},{"line":1038,"kind":13,"localvar":"my","name":"$aref","definition":"my","containerName":"_set_residues"},{"containerName":"_set_residues","name":"$self","line":1038,"kind":13},{"kind":12,"line":1038,"name":"_set_match_seq","containerName":"_set_residues"},{"name":"$self","containerName":"_set_residues","line":1038,"kind":13},{"containerName":"_set_residues","name":"$aref","kind":13,"line":1039},{"kind":13,"line":1039,"containerName":"_set_residues","name":"$self"},{"line":1040,"kind":13,"localvar":"my","definition":"my","name":"$seqString","containerName":"_set_residues"},{"kind":13,"line":1040,"name":"$aref","containerName":"_set_residues"},{"localvar":"my","name":"$qseq","definition":"my","containerName":"_set_residues","line":1042,"kind":13},{"name":"$self","containerName":"_set_residues","kind":13,"line":1042}]},{"definition":"my","name":"$sseq","containerName":null,"localvar":"my","kind":13,"line":1043},{"kind":13,"line":1043,"containerName":null,"name":"%self"},{"localvar":"my","definition":"my","name":"$resCount_query","containerName":null,"line":1044,"kind":13},{"kind":13,"line":1044,"containerName":null,"name":"%self"},{"line":1045,"kind":13,"localvar":"my","containerName":null,"name":"$resCount_sbjct","definition":"my"},{"containerName":null,"name":"%self","line":1045,"kind":13},{"kind":13,"line":1047,"containerName":null,"definition":"my","name":"$prog","localvar":"my"},{"kind":13,"line":1047,"name":"$self","containerName":null},{"containerName":"main::","name":"algorithm","line":1047,"kind":12},{"kind":13,"line":1048,"name":"%prog","containerName":null},{"containerName":null,"name":"%prog","line":1049,"kind":13},{"containerName":null,"name":"$resCount_sbjct","line":1050,"kind":13},{"name":"%prog","containerName":null,"kind":13,"line":1051},{"line":1052,"kind":13,"containerName":null,"name":"$resCount_query"},{"containerName":null,"name":"%prog","kind":13,"line":1053},{"line":1054,"kind":13,"name":"$resCount_query","containerName":null},{"name":"$resCount_sbjct","containerName":null,"kind":13,"line":1055},{"localvar":"my","definition":"my","name":"$mchar","containerName":null,"line":1059,"kind":13},{"line":1059,"kind":13,"name":"$schar","containerName":null},{"name":"$qchar","containerName":null,"kind":13,"line":1059},{"kind":13,"line":1060,"containerName":null,"name":"$mchar"},{"containerName":null,"name":"%seqString","kind":13,"line":1060},{"line":1061,"kind":13,"name":"$qchar","containerName":null},{"line":1061,"kind":13,"name":"$schar","containerName":null},{"name":"$qseq","containerName":null,"line":1061,"kind":13},{"kind":13,"line":1061,"containerName":null,"name":"$sseq"},{"kind":13,"line":1062,"name":"%mchar","containerName":null},{"kind":13,"line":1063,"containerName":null,"name":"%conservedList_query"},{"line":1063,"kind":13,"name":"$resCount_query","containerName":null},{"kind":13,"line":1064,"name":"%conservedList_sbjct","containerName":null},{"name":"$resCount_sbjct","containerName":null,"line":1064,"kind":13},{"line":1065,"kind":13,"containerName":null,"name":"%mchar"},{"containerName":null,"name":"%identicalList_query","kind":13,"line":1066},{"name":"$resCount_query","containerName":null,"kind":13,"line":1066},{"line":1067,"kind":13,"name":"%identicalList_sbjct","containerName":null},{"line":1067,"kind":13,"containerName":null,"name":"$resCount_sbjct"},{"containerName":null,"name":"$resCount_query","line":1069,"kind":13},{"kind":13,"line":1069,"name":"$qchar","containerName":null},{"containerName":null,"name":"$GAP_SYMBOL","line":1069,"kind":13},{"name":"$resCount_sbjct","containerName":null,"kind":13,"line":1070},{"name":"$schar","containerName":null,"line":1070,"kind":13},{"line":1070,"kind":13,"name":"$GAP_SYMBOL","containerName":null},{"kind":13,"line":1072,"name":"%self","containerName":null},{"line":1072,"kind":13,"name":"%identicalList_query","containerName":null},{"line":1073,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":1073,"name":"%conservedList_query","containerName":null},{"containerName":null,"name":"%self","line":1074,"kind":13},{"name":"%identicalList_sbjct","containerName":null,"kind":13,"line":1074},{"containerName":null,"name":"%self","line":1075,"kind":13},{"kind":13,"line":1075,"name":"%conservedList_sbjct","containerName":null},{"definition":"sub","name":"_set_match_seq","containerName":"main::","range":{"start":{"character":0,"line":1099},"end":{"character":9999,"line":1108}},"kind":12,"children":[{"line":1101,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_set_match_seq"},{"containerName":"_set_match_seq","name":"$self","kind":13,"line":1103},{"kind":13,"line":1104,"definition":"my","name":"$id_str","containerName":"_set_match_seq","localvar":"my"},{"kind":13,"line":1104,"containerName":"_set_match_seq","name":"$self"},{"containerName":"_set_match_seq","name":"_id_str","line":1104,"kind":12},{"containerName":"_set_match_seq","name":"$self","line":1105,"kind":13},{"line":1105,"kind":12,"name":"throw","containerName":"_set_match_seq"},{"localvar":"my","name":"@data","definition":"my","containerName":"_set_match_seq","line":1108,"kind":13},{"kind":13,"line":1108,"name":"$self","containerName":"_set_match_seq"}],"line":1099},{"definition":"my","name":"@sequence","containerName":null,"localvar":"my","kind":13,"line":1110},{"name":"@data","containerName":null,"kind":13,"line":1111},{"kind":13,"line":1116,"name":"@sequence","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1119},{"line":1120,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","line":1122,"kind":13},{"name":"@sequence","containerName":null,"line":1122,"kind":13},{"containerName":null,"name":"%self","line":1124,"kind":13},{"line":1147,"children":[{"line":1147,"kind":13,"localvar":"my","containerName":"n","name":"$self","definition":"my"},{"kind":13,"line":1147,"name":"$self","containerName":"n"}],"kind":12,"range":{"end":{"character":9999,"line":1147},"start":{"line":1147,"character":0}},"containerName":"main::","name":"n","definition":"sub"},{"range":{"end":{"line":1253,"character":9999},"start":{"character":0,"line":1176}},"name":"matches","line":1176,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"matches","line":1178,"kind":13},{"containerName":"matches","name":"%param","kind":13,"line":1178},{"definition":"my","name":"@data","containerName":"matches","localvar":"my","kind":13,"line":1179},{"localvar":"my","containerName":"matches","name":"$seqType","definition":"my","line":1180,"kind":13},{"kind":13,"line":1180,"containerName":"matches","name":"$beg"},{"kind":13,"line":1180,"name":"$end","containerName":"matches"},{"name":"$param","containerName":"matches","kind":13,"line":1180},{"name":"$param","containerName":"matches","kind":13,"line":1180},{"name":"$param","containerName":"matches","line":1180,"kind":13},{"line":1181,"kind":13,"containerName":"matches","name":"$seqType"},{"containerName":"matches","name":"$seqType","line":1182,"kind":13},{"containerName":"matches","name":"$seqType","kind":13,"line":1182},{"name":"$start","definition":"my","containerName":"matches","localvar":"my","kind":13,"line":1184},{"kind":13,"line":1184,"containerName":"matches","name":"$stop"},{"name":"$beg","containerName":"matches","kind":13,"line":1186},{"line":1186,"kind":13,"containerName":"matches","name":"$end"},{"kind":13,"line":1188,"name":"@data","containerName":"matches"},{"line":1188,"kind":13,"name":"$self","containerName":"matches"},{"name":"$self","containerName":"matches","kind":13,"line":1188},{"containerName":"matches","name":"$beg","line":1191,"kind":13},{"name":"$end","containerName":"matches","kind":13,"line":1192},{"name":"$start","containerName":"matches","line":1193,"kind":13},{"kind":13,"line":1193,"containerName":"matches","name":"$stop"},{"line":1193,"kind":13,"containerName":"matches","name":"$self"},{"line":1193,"kind":12,"containerName":"matches","name":"range"},{"line":1193,"kind":13,"name":"$seqType","containerName":"matches"},{"name":"$beg","containerName":"matches","kind":13,"line":1194},{"name":"$beg","containerName":"matches","kind":13,"line":1194},{"kind":13,"line":1194,"name":"$start","containerName":"matches"},{"containerName":"matches","name":"$end","kind":13,"line":1194},{"containerName":"matches","name":"$beg","line":1194,"kind":13},{"containerName":"matches","name":"$end","kind":13,"line":1194},{"line":1195,"kind":13,"containerName":"matches","name":"$end"},{"line":1195,"kind":13,"containerName":"matches","name":"$end"},{"containerName":"matches","name":"$stop","line":1195,"kind":13},{"line":1195,"kind":13,"name":"$beg","containerName":"matches"},{"containerName":"matches","name":"$end","kind":13,"line":1195},{"line":1195,"kind":13,"name":"$beg","containerName":"matches"},{"kind":13,"line":1197,"containerName":"matches","name":"$end"},{"name":"$stop","containerName":"matches","kind":13,"line":1197},{"containerName":"matches","name":"$end","line":1197,"kind":13},{"kind":13,"line":1197,"containerName":"matches","name":"$stop"},{"name":"$end","containerName":"matches","kind":13,"line":1198},{"kind":13,"line":1201,"containerName":"matches","name":"$beg"},{"kind":13,"line":1201,"name":"$start","containerName":"matches"},{"kind":13,"line":1201,"containerName":"matches","name":"$beg"},{"containerName":"matches","name":"$start","kind":13,"line":1201},{"localvar":"my","containerName":"matches","name":"$seq","definition":"my","line":1207,"kind":13},{"name":"$prog","definition":"my","containerName":"matches","localvar":"my","kind":13,"line":1208},{"containerName":"matches","name":"$self","kind":13,"line":1208},{"name":"algorithm","containerName":"matches","line":1208,"kind":12},{"name":"$prog","containerName":"matches","line":1209,"kind":13},{"containerName":"matches","name":"$seqType","line":1209,"kind":13},{"line":1211,"kind":13,"containerName":"matches","name":"$seq"},{"name":"$self","containerName":"matches","kind":13,"line":1211},{"kind":12,"line":1211,"containerName":"matches","name":"seq_str"},{"name":"$beg","containerName":"matches","line":1212,"kind":13},{"name":"$start","containerName":"matches","kind":13,"line":1212},{"name":"$end","containerName":"matches","kind":13,"line":1212},{"line":1212,"kind":13,"containerName":"matches","name":"$beg"},{"containerName":"matches","name":"$prog","kind":13,"line":1214},{"name":"$seqType","containerName":"matches","line":1214,"kind":13},{"kind":13,"line":1216,"name":"$seq","containerName":"matches"},{"line":1216,"kind":13,"name":"$self","containerName":"matches"},{"name":"seq_str","containerName":"matches","line":1216,"kind":12},{"kind":13,"line":1217,"name":"$beg","containerName":"matches"},{"containerName":"matches","name":"$start","kind":13,"line":1217},{"line":1217,"kind":13,"containerName":"matches","name":"$end"},{"name":"$beg","containerName":"matches","kind":13,"line":1217},{"containerName":"matches","name":"$seq","kind":13,"line":1219},{"containerName":"matches","name":"$self","line":1219,"kind":13},{"line":1219,"kind":12,"containerName":"matches","name":"seq_str"},{"kind":13,"line":1220,"containerName":"matches","name":"$beg"},{"line":1220,"kind":13,"name":"$start","containerName":"matches"},{"kind":13,"line":1220,"containerName":"matches","name":"$end"},{"kind":13,"line":1220,"name":"$beg","containerName":"matches"},{"containerName":"matches","name":"$seq","kind":13,"line":1238},{"localvar":"my","definition":"my","name":"$id_str","containerName":"matches","line":1239,"kind":13},{"line":1239,"kind":13,"containerName":"matches","name":"$self"},{"containerName":"matches","name":"_id_str","line":1239,"kind":12},{"line":1240,"kind":13,"containerName":"matches","name":"$self"},{"kind":12,"line":1240,"containerName":"matches","name":"throw"},{"kind":13,"line":1245,"name":"$seq","containerName":"matches"},{"definition":"my","name":"$len_cons","containerName":"matches","localvar":"my","kind":13,"line":1246},{"line":1246,"kind":13,"name":"$seq","containerName":"matches"},{"containerName":"matches","name":"$seq","line":1247,"kind":13},{"kind":13,"line":1248,"containerName":"matches","definition":"my","name":"$len_id","localvar":"my"},{"kind":13,"line":1248,"name":"$seq","containerName":"matches"},{"name":"@data","containerName":"matches","kind":13,"line":1249},{"kind":13,"line":1249,"name":"$len_id","containerName":"matches"},{"line":1249,"kind":13,"name":"$len_cons","containerName":"matches"},{"kind":13,"line":1252,"containerName":"matches","name":"@data"}],"kind":12,"detail":"($self,%param)","signature":{"label":"matches($self,%param)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>","parameters":[{"label":"$self"},{"label":"%param"}]},"containerName":"main::","definition":"sub"},{"name":"CORE","containerName":"length","kind":12,"line":1238},{"name":"CORE","containerName":"length","kind":12,"line":1247},{"name":"CORE","containerName":"length","line":1249,"kind":12},{"definition":"sub","name":"num_identical","containerName":"main::","range":{"end":{"line":1275,"character":9999},"start":{"character":0,"line":1270}},"kind":12,"children":[{"line":1272,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"num_identical"},{"name":"$self","containerName":"num_identical","line":1274,"kind":13}],"line":1270},{"range":{"start":{"character":0,"line":1292},"end":{"line":1297,"character":9999}},"definition":"sub","name":"num_conserved","containerName":"main::","children":[{"containerName":"num_conserved","definition":"my","name":"$self","localvar":"my","kind":13,"line":1294},{"line":1296,"kind":13,"containerName":"num_conserved","name":"$self"}],"line":1292,"kind":12},{"detail":"($self,$seqType)","signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>","label":"range($self,$seqType)"},"containerName":"main::","definition":"sub","line":1318,"children":[{"kind":13,"line":1320,"name":"$self","definition":"my","containerName":"range","localvar":"my"},{"line":1320,"kind":13,"containerName":"range","name":"$seqType"},{"kind":13,"line":1322,"containerName":"range","name":"$self"},{"name":"_set_seq_data","containerName":"range","line":1322,"kind":12},{"name":"$self","containerName":"range","line":1322,"kind":13},{"name":"$seqType","containerName":"range","line":1324,"kind":13},{"kind":13,"line":1325,"containerName":"range","name":"$seqType"},{"kind":13,"line":1325,"name":"$seqType","containerName":"range"},{"name":"$seqType","containerName":"range","line":1328,"kind":13},{"containerName":"range","name":"$self","line":1330,"kind":13},{"line":1330,"kind":13,"name":"$seqType","containerName":"range"},{"name":"$self","containerName":"range","line":1330,"kind":13},{"containerName":"range","name":"$seqType","kind":13,"line":1330}],"kind":12,"range":{"end":{"character":9999,"line":1331},"start":{"line":1318,"character":0}},"name":"range"},{"name":"start","range":{"start":{"character":0,"line":1355},"end":{"character":9999,"line":1371}},"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"start($self,$seqType)"},"kind":12,"line":1355,"children":[{"localvar":"my","containerName":"start","name":"$self","definition":"my","line":1357,"kind":13},{"line":1357,"kind":13,"containerName":"start","name":"$seqType"},{"kind":13,"line":1359,"containerName":"start","name":"$seqType"},{"kind":13,"line":1360,"containerName":"start","name":"$seqType"},{"kind":13,"line":1360,"name":"$seqType","containerName":"start"},{"line":1362,"kind":13,"name":"$self","containerName":"start"},{"kind":12,"line":1362,"containerName":"start","name":"_set_seq_data"},{"name":"$self","containerName":"start","kind":13,"line":1362},{"kind":13,"line":1364,"name":"$seqType","containerName":"start"},{"kind":13,"line":1365,"name":"$self","containerName":"start"},{"kind":13,"line":1365,"containerName":"start","name":"$self"},{"containerName":"start","name":"$seqType","kind":13,"line":1368},{"line":1369,"kind":13,"containerName":"start","name":"$self"},{"kind":13,"line":1369,"name":"$seqType","containerName":"start"}]},{"kind":12,"children":[{"line":1397,"kind":13,"localvar":"my","containerName":"end","name":"$self","definition":"my"},{"line":1397,"kind":13,"name":"$seqType","containerName":"end"},{"name":"$seqType","containerName":"end","kind":13,"line":1399},{"containerName":"end","name":"$seqType","kind":13,"line":1400},{"line":1400,"kind":13,"name":"$seqType","containerName":"end"},{"name":"$self","containerName":"end","line":1402,"kind":13},{"line":1402,"kind":12,"containerName":"end","name":"_set_seq_data"},{"line":1402,"kind":13,"containerName":"end","name":"$self"},{"line":1404,"kind":13,"containerName":"end","name":"$seqType"},{"containerName":"end","name":"$self","kind":13,"line":1405},{"line":1405,"kind":13,"name":"$self","containerName":"end"},{"kind":13,"line":1408,"name":"$seqType","containerName":"end"},{"containerName":"end","name":"$self","kind":13,"line":1409},{"line":1409,"kind":13,"containerName":"end","name":"$seqType"}],"line":1395,"definition":"sub","containerName":"main::","signature":{"label":"end($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>"},"detail":"($self,$seqType)","name":"end","range":{"start":{"character":0,"line":1395},"end":{"character":9999,"line":1411}}},{"name":"strand","range":{"end":{"character":9999,"line":1478},"start":{"line":1439,"character":0}},"kind":12,"children":[{"kind":13,"line":1441,"definition":"my","name":"$self","containerName":"strand","localvar":"my"},{"kind":13,"line":1441,"containerName":"strand","name":"$seqType"},{"kind":13,"line":1443,"name":"$seqType","containerName":"strand"},{"containerName":"strand","name":"$seqType","line":1444,"kind":13},{"containerName":"strand","name":"$seqType","kind":13,"line":1444},{"line":1447,"kind":13,"name":"$seqType","containerName":"strand"},{"line":1450,"kind":13,"name":"$self","containerName":"strand"},{"kind":13,"line":1450,"containerName":"strand","name":"$self"},{"containerName":"strand","name":"_set_seq_data","line":1450,"kind":12},{"line":1450,"kind":13,"name":"$self","containerName":"strand"},{"kind":13,"line":1452,"containerName":"strand","definition":"my","name":"$prog","localvar":"my"},{"kind":13,"line":1452,"name":"$self","containerName":"strand"},{"kind":12,"line":1452,"name":"algorithm","containerName":"strand"},{"kind":13,"line":1454,"name":"$seqType","containerName":"strand"},{"line":1455,"kind":13,"localvar":"my","definition":"my","name":"$qstr","containerName":"strand"},{"kind":13,"line":1455,"containerName":"strand","name":"$hstr"},{"line":1456,"kind":13,"name":"$prog","containerName":"strand"},{"line":1457,"kind":13,"containerName":"strand","name":"$qstr"},{"line":1458,"kind":13,"name":"$hstr","containerName":"strand"},{"containerName":"strand","name":"$prog","kind":13,"line":1460},{"name":"$qstr","containerName":"strand","line":1461,"kind":13},{"line":1462,"kind":13,"containerName":"strand","name":"$hstr"},{"line":1462,"kind":13,"name":"$STRAND_SYMBOL","containerName":"strand"},{"containerName":"strand","name":"$self","line":1462,"kind":13},{"name":"$prog","containerName":"strand","kind":13,"line":1464},{"kind":13,"line":1465,"containerName":"strand","name":"$qstr"},{"kind":13,"line":1465,"name":"$STRAND_SYMBOL","containerName":"strand"},{"name":"$self","containerName":"strand","line":1465,"kind":13},{"line":1466,"kind":13,"containerName":"strand","name":"$hstr"},{"name":"$qstr","containerName":"strand","line":1469,"kind":13},{"name":"$STRAND_SYMBOL","containerName":"strand","line":1469,"kind":13},{"kind":13,"line":1469,"name":"$self","containerName":"strand"},{"line":1469,"kind":13,"containerName":"strand","name":"$self"},{"line":1470,"kind":13,"containerName":"strand","name":"$hstr"},{"containerName":"strand","name":"$STRAND_SYMBOL","kind":13,"line":1470},{"kind":13,"line":1470,"name":"$self","containerName":"strand"},{"kind":13,"line":1470,"name":"$self","containerName":"strand"},{"name":"$qstr","containerName":"strand","kind":13,"line":1472},{"containerName":"strand","name":"$hstr","line":1473,"kind":13},{"containerName":"strand","name":"$qstr","line":1474,"kind":13},{"kind":13,"line":1474,"containerName":"strand","name":"$hstr"},{"containerName":"strand","name":"$STRAND_SYMBOL","kind":13,"line":1477},{"line":1477,"kind":13,"name":"$self","containerName":"strand"},{"line":1477,"kind":13,"name":"$seqType","containerName":"strand"}],"line":1439,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>","label":"strand($self,$seqType)"},"detail":"($self,$seqType)"},{"range":{"start":{"character":0,"line":1500},"end":{"line":1513,"character":9999}},"name":"seq","children":[{"line":1502,"kind":13,"localvar":"my","containerName":"seq","definition":"my","name":"$self"},{"name":"$seqType","containerName":"seq","kind":13,"line":1502},{"kind":13,"line":1503,"name":"$seqType","containerName":"seq"},{"kind":13,"line":1504,"containerName":"seq","name":"$seqType"},{"kind":13,"line":1504,"name":"$seqType","containerName":"seq"},{"line":1505,"kind":13,"localvar":"my","containerName":"seq","definition":"my","name":"$str"},{"kind":13,"line":1505,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"seq_str","kind":12,"line":1505},{"kind":13,"line":1505,"name":"$seqType","containerName":"seq"},{"name":"new","containerName":"seq","line":1509,"kind":12},{"line":1509,"kind":13,"containerName":"seq","name":"$self"},{"line":1509,"kind":12,"name":"to_string","containerName":"seq"},{"containerName":"seq","name":"$str","kind":13,"line":1510}],"line":1500,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>","label":"seq($self,$seqType)"},"detail":"($self,$seqType)","definition":"sub","containerName":"main::"},{"line":1509,"kind":12,"name":"Bio","containerName":"Seq::Bio::Seq"},{"name":"seq_str","range":{"end":{"character":9999,"line":1550},"start":{"character":0,"line":1534}},"kind":12,"line":1534,"children":[{"line":1536,"kind":13,"localvar":"my","containerName":"seq_str","name":"$self","definition":"my"},{"containerName":"seq_str","name":"$seqType","line":1536,"kind":13},{"line":1538,"kind":13,"name":"$seqType","containerName":"seq_str"},{"name":"$seqType","containerName":"seq_str","kind":13,"line":1539},{"kind":13,"line":1539,"name":"$seqType","containerName":"seq_str"},{"name":"$seqType","containerName":"seq_str","kind":13,"line":1541},{"containerName":"seq_str","name":"$self","kind":13,"line":1543},{"name":"_set_seq_data","containerName":"seq_str","kind":12,"line":1543},{"name":"$self","containerName":"seq_str","line":1543,"kind":13},{"kind":13,"line":1545,"containerName":"seq_str","name":"$seqType"},{"kind":13,"line":1546,"containerName":"seq_str","definition":"my","name":"$seq","localvar":"my"},{"line":1546,"kind":13,"containerName":"seq_str","name":"$self"},{"containerName":"seq_str","name":"$seqType","line":1546,"kind":13},{"containerName":"seq_str","name":"$seq","kind":13,"line":1547},{"name":"$seq","containerName":"seq_str","kind":13,"line":1548}],"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"seq_str($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n\n    require Bio::Seq;\n\n    Bio::Seq->new(-ID   => $self->to_string,\n                  -SEQ  => $str,\n                  -DESC => \"$seqType sequence\",\n                  );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the\n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : Calls _set_seq_data() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</seq_inds>, L</_set_match_seq>","parameters":[{"label":"$self"},{"label":"$seqType"}]}},{"containerName":null,"name":"%seqType","kind":13,"line":1550},{"localvar":"my","containerName":null,"name":"$aref","definition":"my","line":1552,"kind":13},{"kind":13,"line":1552,"name":"$self","containerName":null},{"line":1552,"kind":12,"containerName":"main::","name":"_set_match_seq"},{"name":"%self","containerName":null,"line":1552,"kind":13},{"kind":13,"line":1553,"containerName":null,"name":"$aref"},{"kind":13,"line":1553,"containerName":null,"name":"%self"},{"name":"%aref","containerName":null,"kind":13,"line":1555},{"line":1558,"kind":13,"localvar":"my","definition":"my","name":"$id_str","containerName":null},{"name":"$self","containerName":null,"line":1558,"kind":13},{"kind":12,"line":1558,"name":"_id_str","containerName":"main::"},{"containerName":null,"name":"$self","line":1559,"kind":13},{"name":"throw","containerName":"main::","line":1559,"kind":12},{"containerName":null,"name":"$seqType","line":1562,"kind":13},{"range":{"end":{"character":9999,"line":1612},"start":{"character":0,"line":1594}},"name":"seq_inds","children":[{"localvar":"my","containerName":"seq_inds","name":"$self","definition":"my","line":1596,"kind":13},{"line":1596,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"name":"$class","containerName":"seq_inds","line":1596,"kind":13},{"containerName":"seq_inds","name":"$collapse","kind":13,"line":1596},{"name":"$seqType","containerName":"seq_inds","line":1598,"kind":13},{"kind":13,"line":1599,"name":"$class","containerName":"seq_inds"},{"name":"$collapse","containerName":"seq_inds","line":1600,"kind":13},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":1601},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":1601},{"line":1603,"kind":13,"name":"$self","containerName":"seq_inds"},{"name":"_set_residues","containerName":"seq_inds","line":1603,"kind":12},{"line":1603,"kind":13,"name":"$self","containerName":"seq_inds"},{"kind":13,"line":1605,"name":"$seqType","containerName":"seq_inds"},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":1605},{"line":1606,"kind":13,"containerName":"seq_inds","name":"$class"},{"kind":13,"line":1606,"name":"$class","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$seqType","line":1609,"kind":13},{"name":"$class","containerName":"seq_inds","kind":13,"line":1610},{"containerName":"seq_inds","name":"@ary","definition":"my","localvar":"my","kind":13,"line":1612},{"name":"$a","containerName":"seq_inds","line":1612,"kind":13},{"containerName":"seq_inds","name":"$b","line":1612,"kind":13},{"line":1612,"kind":13,"containerName":"seq_inds","name":"$self"}],"line":1594,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n\n    require Bio::Seq;\n\n    Bio::Seq->new(-ID   => $self->to_string,\n                  -SEQ  => $str,\n                  -DESC => \"$seqType sequence\",\n                  );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the\n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : Calls _set_seq_data() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</seq_inds>, L</_set_match_seq>\n\n\n#------------\nsub seq_str {\n#------------\n    my($self,$seqType) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /sbjct|query/) {\n        my $seq = join('',@{$self->{$seqType.'Seq'}});\n        $seq =~ s/\\s+//g;\n        return $seq;\n\n    } elsif( $seqType =~ /match/i) {\n        # Only need to call _set_match_seq() if the match seq is requested.\n        my $aref = $self->_set_match_seq() unless ref $self->{'_matchSeq'};\n        $aref =  $self->{'_matchSeq'};\n\n        return join('',@$aref);\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::BadParameter',\n                     -text => \"Invalid or undefined sequence type: $seqType ($id_str)\\n\" .\n                               \"Valid types: query, sbjct, match\",\n                     -value => $seqType);\n    }\n}\n\n=head2 seq_inds\n\n Usage     : $hsp->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) for all identical\n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers\n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : class     = 'identical' or 'conserved' (default = identical)\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : collapse  = boolean, if true, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : Calls _set_residues() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</_set_residues>, L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::BlastHit::seq_inds()|Bio::Search::Hit::BlastHit>","label":"seq_inds($self,$seqType,$class,$collapse)"},"detail":"($self,$seqType,$class,$collapse)","definition":"sub","containerName":"main::"},{"kind":13,"line":1614,"containerName":null,"name":"$collapse"},{"name":"$collapse","containerName":null,"line":1616,"kind":13},{"name":"Bio","containerName":"Search::BlastUtils","line":1616,"kind":12},{"name":"Bio","containerName":"Search::BlastUtils::collapse_nums","line":1616,"kind":12},{"name":"@ary","containerName":null,"kind":13,"line":1616},{"name":"@ary","containerName":null,"kind":13,"line":1616},{"containerName":"main::","name":"get_aln","definition":"sub","range":{"start":{"character":0,"line":1640},"end":{"character":9999,"line":1662}},"kind":12,"line":1640,"children":[{"line":1642,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_aln"},{"localvar":"my","containerName":"get_aln","definition":"my","name":"$qseq","line":1646,"kind":13},{"kind":13,"line":1646,"name":"$self","containerName":"get_aln"},{"containerName":"get_aln","name":"seq","kind":12,"line":1646},{"kind":13,"line":1647,"containerName":"get_aln","name":"$sseq","definition":"my","localvar":"my"},{"name":"$self","containerName":"get_aln","line":1647,"kind":13},{"line":1647,"kind":12,"containerName":"get_aln","name":"seq"},{"localvar":"my","containerName":"get_aln","name":"$type","definition":"my","line":1649,"kind":13},{"kind":13,"line":1649,"name":"$self","containerName":"get_aln"},{"kind":12,"line":1649,"name":"algorithm","containerName":"get_aln"},{"kind":13,"line":1650,"containerName":"get_aln","name":"$aln","definition":"my","localvar":"my"},{"kind":12,"line":1650,"containerName":"get_aln","name":"new"},{"name":"$aln","containerName":"get_aln","kind":13,"line":1651},{"line":1651,"kind":12,"name":"add_seq","containerName":"get_aln"},{"kind":12,"line":1651,"containerName":"get_aln","name":"new"},{"containerName":"get_aln","name":"$qseq","kind":13,"line":1651},{"containerName":"get_aln","name":"seq","kind":12,"line":1651},{"name":"$qseq","containerName":"get_aln","kind":13,"line":1652},{"line":1652,"kind":12,"containerName":"get_aln","name":"display_id"},{"name":"$qseq","containerName":"get_aln","kind":13,"line":1654},{"containerName":"get_aln","name":"$aln","line":1656,"kind":13},{"name":"add_seq","containerName":"get_aln","kind":12,"line":1656},{"line":1656,"kind":12,"name":"new","containerName":"get_aln"},{"containerName":"get_aln","name":"$sseq","kind":13,"line":1656},{"line":1656,"kind":12,"containerName":"get_aln","name":"seq"},{"name":"$sseq","containerName":"get_aln","kind":13,"line":1657},{"line":1657,"kind":12,"containerName":"get_aln","name":"display_id"},{"containerName":"get_aln","name":"$sseq","line":1659,"kind":13},{"name":"$aln","containerName":"get_aln","line":1661,"kind":13}]},{"name":"Bio","containerName":"SimpleAlign::Bio::LocatableSeq","kind":12,"line":1646},{"line":1650,"kind":12,"containerName":"SimpleAlign","name":"Bio"},{"kind":12,"line":1651,"containerName":"LocatableSeq","name":"Bio"},{"name":"CORE","containerName":"length","line":1654,"kind":12},{"name":"Bio","containerName":"LocatableSeq","line":1656,"kind":12},{"kind":12,"line":1659,"containerName":"length","name":"CORE"}]}