{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":77},{"kind":12,"line":91,"children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":92},{"name":"@args","containerName":"new","line":92,"kind":13},{"kind":13,"line":93,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":93,"name":"$class","containerName":"new"},{"line":93,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":94,"name":"$qgaplocs","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$hgaplocs","line":95,"kind":13},{"name":"$mismatches","containerName":"new","line":96,"kind":13},{"kind":13,"line":96,"name":"$self","containerName":"new"},{"kind":12,"line":96,"name":"_rearrange","containerName":"new"},{"line":99,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":100,"name":"$self","containerName":"new"},{"name":"gap_blocks","containerName":"new","line":100,"kind":12},{"name":"$qgaplocs","containerName":"new","kind":13,"line":100},{"containerName":"new","name":"$qgaplocs","line":100,"kind":13},{"kind":13,"line":101,"name":"$self","containerName":"new"},{"containerName":"new","name":"gap_blocks","line":101,"kind":12},{"line":101,"kind":13,"name":"$hgaplocs","containerName":"new"},{"kind":13,"line":101,"name":"$hgaplocs","containerName":"new"},{"containerName":"new","name":"$self","line":102,"kind":13},{"line":102,"kind":12,"containerName":"new","name":"mismatches"},{"kind":13,"line":102,"containerName":"new","name":"$mismatches"},{"kind":13,"line":102,"name":"$mismatches","containerName":"new"},{"containerName":"new","name":"$self","line":103,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: PSLHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PSLHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PSLHSP - A HSP for PSL output\n\n=head1 SYNOPSIS\n\n  # get a PSLHSP somehow (SearchIO::psl)\n\n=head1 DESCRIPTION\n\nThis is a HSP for PSL output so we can handle seq_inds differently.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::PSLHSP;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::PSLHSP->new();\n Function: Builds a new Bio::Search::HSP::PSLHSP object \n Returns : an instance of Bio::Search::HSP::PSLHSP\n Args    : -gapblocks => arrayref of gap locations which are [start,length]\n                         of gaps","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","range":{"end":{"line":104,"character":9999},"start":{"line":91,"character":0}}},{"name":"SUPER","containerName":"new","kind":12,"line":93},{"range":{"end":{"line":132,"character":9999},"start":{"line":118,"character":0}},"name":"gap_blocks","signature":{"parameters":[{"label":"$self"},{"label":"$seqtype"},{"label":"$blocks"}],"documentation":"1;\n# $Id: PSLHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PSLHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PSLHSP - A HSP for PSL output\n\n=head1 SYNOPSIS\n\n  # get a PSLHSP somehow (SearchIO::psl)\n\n=head1 DESCRIPTION\n\nThis is a HSP for PSL output so we can handle seq_inds differently.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::PSLHSP;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::PSLHSP->new();\n Function: Builds a new Bio::Search::HSP::PSLHSP object \n Returns : an instance of Bio::Search::HSP::PSLHSP\n Args    : -gapblocks => arrayref of gap locations which are [start,length]\n                         of gaps\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($qgaplocs,\n\t$hgaplocs,\n\t$mismatches) = $self->_rearrange([qw(QUERY_GAPBLOCKS\n\t\t\t\t\t     HIT_GAPBLOCKS\n\t\t\t\t\t     MISMATCHES)],\n\t\t\t\t       @args);\n    $self->gap_blocks('query',$qgaplocs) if defined $qgaplocs;\n    $self->gap_blocks('hit',  $hgaplocs) if defined $hgaplocs;\n    $self->mismatches($mismatches) if defined $mismatches;\n    return $self;\n}\n\n=head2 gap_blocks\n\n Title   : gap_blocks\n Usage   : $obj->gap_blocks($seqtype,$blocks)\n Function: Get/Set the gap blocks\n Returns : value of gap_blocks (a scalar)\n Args    : sequence type - 'query' or 'hit'\n           blocks - arrayref of block start,length","label":"gap_blocks($self,$seqtype,$blocks)"},"detail":"($self,$seqtype,$blocks)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"gap_blocks","line":119,"kind":13},{"line":119,"kind":13,"containerName":"gap_blocks","name":"$seqtype"},{"name":"$blocks","containerName":"gap_blocks","line":119,"kind":13},{"name":"$seqtype","containerName":"gap_blocks","kind":13,"line":120},{"line":120,"kind":13,"name":"$seqtype","containerName":"gap_blocks"},{"containerName":"gap_blocks","name":"$seqtype","line":121,"kind":13},{"kind":13,"line":121,"containerName":"gap_blocks","name":"$seqtype"},{"kind":13,"line":122,"name":"$seqtype","containerName":"gap_blocks"},{"containerName":"gap_blocks","name":"$seqtype","kind":13,"line":122},{"containerName":"gap_blocks","name":"$seqtype","line":123,"kind":13},{"name":"$self","containerName":"gap_blocks","kind":13,"line":124},{"kind":12,"line":124,"containerName":"gap_blocks","name":"warn"},{"line":127,"kind":13,"containerName":"gap_blocks","name":"$blocks"},{"line":128,"kind":13,"name":"$self","containerName":"gap_blocks"},{"line":128,"kind":13,"name":"$seqtype","containerName":"gap_blocks"},{"containerName":"gap_blocks","name":"$self","kind":13,"line":130},{"line":130,"kind":13,"name":"$seqtype","containerName":"gap_blocks"},{"containerName":"gap_blocks","name":"$blocks","line":130,"kind":13}],"line":118,"kind":12},{"line":145,"children":[{"line":146,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"mismatches"},{"kind":13,"line":147,"containerName":"mismatches","name":"$self"},{"containerName":"mismatches","name":"$self","kind":13,"line":148}],"kind":12,"range":{"start":{"character":0,"line":145},"end":{"character":9999,"line":149}},"containerName":"main::","name":"mismatches","definition":"sub"}]}