{"version":5,"vars":[{"name":"base","containerName":"","line":79,"kind":2},{"range":{"end":{"line":142,"character":9999},"start":{"character":0,"line":135}},"name":"meta","children":[{"containerName":"meta","name":"$self","definition":"my","localvar":"my","kind":13,"line":136},{"kind":13,"line":136,"name":"$value","containerName":"meta"},{"kind":13,"line":137,"containerName":"meta","name":"$previous","definition":"my","localvar":"my"},{"name":"$self","containerName":"meta","line":137,"kind":13},{"name":"$value","containerName":"meta","kind":13,"line":138},{"kind":13,"line":139,"containerName":"meta","name":"$self"},{"kind":13,"line":139,"containerName":"meta","name":"$value"},{"line":141,"kind":13,"name":"$previous","containerName":"meta"}],"line":135,"kind":12,"signature":{"documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!","parameters":[{"label":"$self"},{"label":"$value"}],"label":"meta($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"custom_score($self,$value)"},"containerName":"main::","definition":"sub","line":158,"children":[{"line":159,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"custom_score"},{"containerName":"custom_score","name":"$value","kind":13,"line":159},{"containerName":"custom_score","definition":"my","name":"$previous","localvar":"my","kind":13,"line":160},{"line":160,"kind":13,"name":"$self","containerName":"custom_score"},{"line":161,"kind":13,"name":"$value","containerName":"custom_score"},{"name":"$self","containerName":"custom_score","line":162,"kind":13},{"name":"$value","containerName":"custom_score","line":162,"kind":13},{"containerName":"custom_score","name":"$previous","line":164,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":165},"start":{"character":0,"line":158}},"name":"custom_score"},{"definition":"sub","containerName":"main::","signature":{"label":"seq($self,$seqType)","documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.\n\n\nsub custom_score {\n    my ($self,$value) = @_;\n    my $previous = $self->{'CUSTOMSCORE'};\n    if( defined $value  ) {\n        $self->{'CUSTOMSCORE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 Bio::Search::HSP::HSPI methods\n\nImplementation of Bio::Search::HSP::HSPI methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('hit')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject.\n           There is no strand available for 'query', as the query is a model\n           and not a true sequence.\n\n\n# overrides HSPI::seq()\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('sbjct');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'sbjct').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'sbjct'\n           : Note: if there is no sequence available (eg for a model-based\n           : search), this returns a LocatableSeq object w/o a sequence\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L<seq_str()|seq_str>, L<Bio::Seq>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"detail":"($self,$seqType)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"seq","line":219,"kind":13},{"name":"$seqType","containerName":"seq","line":219,"kind":13},{"containerName":"seq","name":"$seqType","line":220,"kind":13},{"containerName":"seq","name":"$seqType","line":221,"kind":13},{"name":"$seqType","containerName":"seq","line":221,"kind":13},{"line":222,"kind":13,"localvar":"my","containerName":"seq","name":"$str","definition":"my"},{"line":222,"kind":13,"name":"$self","containerName":"seq"},{"line":222,"kind":12,"containerName":"seq","name":"seq_str"},{"line":222,"kind":13,"name":"$seqType","containerName":"seq"},{"line":223,"kind":13,"name":"$seqType","containerName":"seq"},{"kind":13,"line":224,"containerName":"seq","name":"$self"},{"line":224,"kind":12,"containerName":"seq","name":"throw"},{"kind":13,"line":227,"containerName":"seq","name":"$id","definition":"my","localvar":"my"},{"name":"$seqType","containerName":"seq","kind":13,"line":227},{"kind":13,"line":227,"name":"$self","containerName":"seq"},{"kind":12,"line":227,"name":"query","containerName":"seq"},{"line":227,"kind":12,"containerName":"seq","name":"seq_id"},{"containerName":"seq","name":"$self","line":227,"kind":13},{"kind":12,"line":227,"containerName":"seq","name":"hit"},{"kind":12,"line":227,"containerName":"seq","name":"seq_id"},{"containerName":"seq","name":"$str","line":228,"kind":13},{"kind":13,"line":229,"containerName":"seq","name":"$str"},{"line":230,"kind":13,"localvar":"my","containerName":"seq","name":"$seq","definition":"my"},{"kind":12,"line":230,"name":"new","containerName":"seq"},{"kind":13,"line":230,"containerName":"seq","name":"$id"},{"name":"$self","containerName":"seq","kind":13,"line":231},{"line":231,"kind":12,"containerName":"seq","name":"start"},{"containerName":"seq","name":"$seqType","kind":13,"line":231},{"line":232,"kind":13,"containerName":"seq","name":"$self"},{"kind":12,"line":232,"name":"end","containerName":"seq"},{"kind":13,"line":232,"containerName":"seq","name":"$seqType"},{"kind":13,"line":233,"containerName":"seq","name":"$self"},{"name":"strand","containerName":"seq","kind":12,"line":233},{"line":233,"kind":13,"containerName":"seq","name":"$seqType"},{"name":"$seq","containerName":"seq","kind":13,"line":236},{"containerName":"seq","name":"seq","line":236,"kind":12},{"line":236,"kind":13,"containerName":"seq","name":"$str"},{"line":236,"kind":13,"name":"$str","containerName":"seq"},{"name":"$seq","containerName":"seq","kind":13,"line":237}],"line":217,"name":"seq","range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":238}}},{"name":"Bio","containerName":"LocatableSeq","line":227,"kind":12},{"containerName":"LocatableSeq","name":"Bio","kind":12,"line":230},{"line":354,"children":[{"localvar":"my","containerName":"get_aln","name":"$self","definition":"my","line":355,"kind":13},{"localvar":"my","containerName":"get_aln","definition":"my","name":"$aln","line":358,"kind":13},{"containerName":"get_aln","name":"new","line":358,"kind":12},{"containerName":"get_aln","name":"%hsp","definition":"my","localvar":"my","kind":13,"line":359},{"kind":13,"line":359,"name":"$self","containerName":"get_aln"},{"name":"hit_string","containerName":"get_aln","kind":12,"line":359},{"kind":13,"line":360,"name":"$self","containerName":"get_aln"},{"line":360,"kind":12,"containerName":"get_aln","name":"homology_string"},{"kind":13,"line":361,"name":"$self","containerName":"get_aln"},{"kind":12,"line":361,"containerName":"get_aln","name":"query_string"},{"containerName":"get_aln","name":"$self","kind":13,"line":362},{"line":362,"kind":12,"name":"meta","containerName":"get_aln"},{"kind":13,"line":365,"name":"$hsp","containerName":"get_aln"},{"line":365,"kind":13,"containerName":"get_aln","name":"$hsp"},{"containerName":"get_aln","name":"$self","line":366,"kind":13},{"kind":12,"line":366,"name":"_postprocess_hsp","containerName":"get_aln"},{"name":"%hsp","containerName":"get_aln","kind":13,"line":366},{"line":369,"kind":13,"name":"$hsp","containerName":"get_aln"},{"line":370,"kind":13,"name":"$self","containerName":"get_aln"},{"line":370,"kind":12,"name":"warn","containerName":"get_aln"},{"line":374,"kind":13,"localvar":"my","containerName":"get_aln","name":"$seqonly","definition":"my"},{"line":374,"kind":13,"containerName":"get_aln","name":"$hsp"},{"line":375,"kind":13,"name":"$seqonly","containerName":"get_aln"},{"kind":13,"line":376,"definition":"my","name":"$q_nm","containerName":"get_aln","localvar":"my"},{"kind":13,"line":376,"name":"$s_nm","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","line":376,"kind":13},{"name":"query","containerName":"get_aln","kind":12,"line":376},{"containerName":"get_aln","name":"seq_id","line":376,"kind":12},{"line":377,"kind":13,"containerName":"get_aln","name":"$self"},{"line":377,"kind":12,"name":"hit","containerName":"get_aln"},{"line":377,"kind":12,"name":"seq_id","containerName":"get_aln"},{"line":378,"kind":13,"name":"$q_nm","containerName":"get_aln"},{"name":"$q_nm","containerName":"get_aln","line":378,"kind":13},{"containerName":"get_aln","name":"$q_nm","kind":13,"line":379},{"name":"$s_nm","containerName":"get_aln","line":381,"kind":13},{"containerName":"get_aln","name":"$s_nm","kind":13,"line":381},{"line":382,"kind":13,"name":"$s_nm","containerName":"get_aln"},{"kind":13,"line":384,"name":"$query","definition":"my","containerName":"get_aln","localvar":"my"},{"kind":12,"line":384,"name":"new","containerName":"get_aln"},{"containerName":"get_aln","name":"$hsp","kind":13,"line":384},{"containerName":"get_aln","name":"$q_nm","kind":13,"line":385},{"kind":13,"line":386,"containerName":"get_aln","name":"$self"},{"kind":12,"line":386,"name":"query","containerName":"get_aln"},{"containerName":"get_aln","name":"start","line":386,"kind":12},{"containerName":"get_aln","name":"$self","kind":13,"line":387},{"kind":12,"line":387,"containerName":"get_aln","name":"query"},{"name":"end","containerName":"get_aln","kind":12,"line":387},{"containerName":"get_aln","name":"$seqonly","kind":13,"line":389},{"line":389,"kind":13,"containerName":"get_aln","name":"$hsp"},{"name":"$seqonly","containerName":"get_aln","line":390,"kind":13},{"localvar":"my","containerName":"get_aln","name":"$hit","definition":"my","line":391,"kind":13},{"name":"new","containerName":"get_aln","kind":12,"line":391},{"name":"$hsp","containerName":"get_aln","kind":13,"line":391},{"containerName":"get_aln","name":"$s_nm","kind":13,"line":392},{"name":"$self","containerName":"get_aln","line":393,"kind":13},{"containerName":"get_aln","name":"hit","line":393,"kind":12},{"containerName":"get_aln","name":"start","kind":12,"line":393},{"line":394,"kind":13,"name":"$self","containerName":"get_aln"},{"name":"hit","containerName":"get_aln","kind":12,"line":394},{"kind":12,"line":394,"name":"end","containerName":"get_aln"},{"name":"$aln","containerName":"get_aln","kind":13,"line":396},{"name":"add_seq","containerName":"get_aln","kind":12,"line":396},{"kind":13,"line":396,"containerName":"get_aln","name":"$query"},{"containerName":"get_aln","name":"$aln","line":397,"kind":13},{"containerName":"get_aln","name":"add_seq","line":397,"kind":12},{"containerName":"get_aln","name":"$hit","line":397,"kind":13},{"line":398,"kind":13,"name":"$hsp","containerName":"get_aln"},{"line":399,"kind":13,"localvar":"my","definition":"my","name":"$meta_obj","containerName":"get_aln"},{"containerName":"get_aln","name":"new","kind":12,"line":399},{"kind":13,"line":400,"name":"$meta_obj","containerName":"get_aln"},{"name":"named_meta","containerName":"get_aln","line":400,"kind":12},{"line":400,"kind":13,"containerName":"get_aln","name":"$hsp"},{"kind":13,"line":401,"name":"$aln","containerName":"get_aln"},{"containerName":"get_aln","name":"consensus_meta","kind":12,"line":401},{"line":401,"kind":13,"name":"$meta_obj","containerName":"get_aln"},{"containerName":"get_aln","name":"$aln","line":403,"kind":13}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: ModelHSP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::ModelHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::ModelHSP - A HSP object for model-based searches\n\n=head1 SYNOPSIS\n\n    use Bio::Search::HSP::ModelHSP;\n    # us it just like a Bio::Search::HSP::ModelHSP object\n\n=head1 DESCRIPTION\n\nThis object is a specialization of L<Bio::Search::HSP::ModelHSP> and is used\nfor searches which involve a query model, such as a Hidden Markov Model (HMM),\ncovariance model (CM), descriptor, or anything else besides a sequence. Note\nthat results from any HSPI class methods which rely on the query being a\nsequence are unreliable and have thus been overridden with warnings indicating\nthey have not been implemented at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::ModelHSP;\nuse strict;\nuse Bio::Seq::Meta;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::ModelHSP->new();\n Function: Builds a new Bio::Search::HSP::ModelHSP object \n Returns : Bio::Search::HSP::ModelHSP\n Args    :\n\nPlus Bio::Seach::HSP::ModelHSP methods\n\n           -algorithm => algorithm used (Infernal, RNAMotif, ERPIN, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n\t\t\t\t\t      analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -conserved => # of residues that matched conservatively \n                           (only protein comparisions; \n\t\t\t    conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment    \n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -hit_seq     => hit sequence portion of the HSP\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -meta        => optional meta data (sec structure, markup, etc)\n           -custom_score=> custom score data\n\n\n=head2 meta\n\n Title   : meta\n Usage   : my $meta = $hsp->meta();\n Function: Returns meta data for this HSP or undef\n Returns : string of meta data or undef\n Args    : [optional] string to set value\n Note    : At some point very soon this will likely be a Bio::AnnotationI.\n           Don't get used to a simple string!\n\n\nsub meta {\n    my ($self,$value) = @_;\n    my $previous = $self->{'META'};\n    if( defined $value  ) {\n        $self->{'META'} = $value;\n    }\n    return $previous;\n}\n\n=head2 custom_score\n\n Title   : custom_score\n Usage   : my $data = $hsp->custom_score();\n Function: Returns custom_score data for this HSP, or undef\n Returns : custom_score data or undef\n Args    : [optional] custom_score\n Note    : This is a Get/Set used to deal with odd score-like data generated\n           from RNAMotif (and other programs) where the score section\n           can be customized to include non-standard data, including sequence\n           data, user-based scores, and other values.\n\n\nsub custom_score {\n    my ($self,$value) = @_;\n    my $previous = $self->{'CUSTOMSCORE'};\n    if( defined $value  ) {\n        $self->{'CUSTOMSCORE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 Bio::Search::HSP::HSPI methods\n\nImplementation of Bio::Search::HSP::HSPI methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('hit')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject.\n           There is no strand available for 'query', as the query is a model\n           and not a true sequence.\n\n\n# overrides HSPI::seq()\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('sbjct');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'sbjct').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'sbjct'\n           : Note: if there is no sequence available (eg for a model-based\n           : search), this returns a LocatableSeq object w/o a sequence\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L<seq_str()|seq_str>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_; \n    $seqType ||= 'sbjct';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n    if( $seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n    require Bio::LocatableSeq;\n    my $id = $seqType =~ /^q/i ? $self->query->seq_id : $self->hit->seq_id;\n    $str =~ s{\\*\\[\\s*(\\d+)\\s*\\]\\*}{'N' x $1}ge;\n    $str =~ s{\\s+}{}g;\n    my $seq = Bio::LocatableSeq->new (-ID    => $id,\n                           -START => $self->start($seqType),\n                           -END   => $self->end($seqType),\n                           -STRAND=> $self->strand($seqType),\n                           -DESC  => \"$seqType sequence \",\n                           );\n    $seq->seq($str) if $str;\n    $seq;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gaps in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gaps in query seq\n                   'hit'   = num gaps in hit seq\n                   'total' = num gaps in whole alignment \n                   default = 'total' \n            arg 2: [optional] integer gap value to set for the type requested\n\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment \n            (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps)\n                   'total' = length of alignment (with gaps)\n                   default = 'total' \n            arg 2: [optional] integer length value to set for specific type\n\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none","parameters":[{"label":"$self"}],"label":"get_aln($self)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":404},"start":{"character":0,"line":354}},"name":"get_aln"},{"kind":12,"line":358,"containerName":"LocatableSeq::Bio::SimpleAlign","name":"Bio"},{"containerName":"SimpleAlign","name":"Bio","line":358,"kind":12},{"line":359,"kind":12,"name":"hit"},{"kind":12,"line":360,"name":"midline"},{"kind":12,"line":361,"name":"query"},{"line":362,"kind":12,"name":"meta"},{"kind":12,"line":365,"name":"meta"},{"line":365,"kind":12,"name":"meta"},{"kind":12,"line":369,"name":"query"},{"name":"query","line":374,"kind":12},{"name":"CORE","containerName":"length","line":378,"kind":12},{"name":"CORE","containerName":"length","line":381,"kind":12},{"name":"Bio","containerName":"LocatableSeq","line":384,"kind":12},{"name":"query","line":384,"kind":12},{"kind":12,"line":389,"name":"hit"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":391},{"line":391,"kind":12,"name":"hit"},{"name":"meta","kind":12,"line":398},{"name":"Bio","containerName":"Seq::Meta","kind":12,"line":399},{"name":"meta","line":400,"kind":12},{"kind":12,"line":468,"children":[{"kind":13,"line":469,"definition":"my","name":"$self","containerName":"seq_inds","localvar":"my"},{"containerName":"seq_inds","name":"$self","line":470,"kind":13},{"containerName":"seq_inds","name":"warn","line":470,"kind":12}],"containerName":"main::","definition":"sub","name":"seq_inds","range":{"end":{"line":472,"character":9999},"start":{"character":0,"line":468}}},{"range":{"start":{"character":0,"line":478},"end":{"line":482,"character":9999}},"containerName":"main::","name":"frac_identical","definition":"sub","line":478,"children":[{"line":479,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$self","kind":13,"line":480},{"name":"warn","containerName":"frac_identical","kind":12,"line":480}],"kind":12},{"range":{"end":{"character":9999,"line":492},"start":{"line":488,"character":0}},"definition":"sub","name":"frac_conserved","containerName":"main::","children":[{"containerName":"frac_conserved","name":"$self","definition":"my","localvar":"my","kind":13,"line":489},{"kind":13,"line":490,"name":"$self","containerName":"frac_conserved"},{"name":"warn","containerName":"frac_conserved","line":490,"kind":12}],"line":488,"kind":12},{"line":498,"children":[{"name":"$self","definition":"my","containerName":"matches","localvar":"my","kind":13,"line":499},{"containerName":"matches","name":"$self","line":500,"kind":13},{"name":"warn","containerName":"matches","kind":12,"line":500}],"kind":12,"range":{"start":{"character":0,"line":498},"end":{"line":502,"character":9999}},"containerName":"main::","definition":"sub","name":"matches"},{"kind":12,"line":508,"children":[{"definition":"my","name":"$self","containerName":"num_conserved","localvar":"my","kind":13,"line":509},{"containerName":"num_conserved","name":"$self","line":510,"kind":13},{"kind":12,"line":510,"name":"warn","containerName":"num_conserved"}],"containerName":"main::","definition":"sub","name":"num_conserved","range":{"start":{"character":0,"line":508},"end":{"line":512,"character":9999}}},{"line":518,"children":[{"name":"$self","definition":"my","containerName":"num_identical","localvar":"my","kind":13,"line":519},{"containerName":"num_identical","name":"$self","line":520,"kind":13},{"line":520,"kind":12,"name":"warn","containerName":"num_identical"}],"kind":12,"range":{"start":{"character":0,"line":518},"end":{"line":522,"character":9999}},"containerName":"main::","definition":"sub","name":"num_identical"},{"children":[{"line":530,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"cigar_string"},{"containerName":"cigar_string","name":"$self","line":531,"kind":13},{"line":531,"kind":12,"containerName":"cigar_string","name":"warn"}],"line":529,"kind":12,"range":{"end":{"character":9999,"line":533},"start":{"character":0,"line":529}},"definition":"sub","name":"cigar_string","containerName":"main::"},{"range":{"end":{"character":9999,"line":543},"start":{"character":0,"line":539}},"definition":"sub","name":"generate_cigar_string","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"generate_cigar_string","localvar":"my","kind":13,"line":540},{"kind":13,"line":541,"name":"$self","containerName":"generate_cigar_string"},{"line":541,"kind":12,"name":"warn","containerName":"generate_cigar_string"}],"line":539,"kind":12},{"name":"percent_identity","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":549},"end":{"character":9999,"line":553}},"kind":12,"children":[{"line":550,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"percent_identity"},{"line":551,"kind":13,"name":"$self","containerName":"percent_identity"},{"kind":12,"line":551,"containerName":"percent_identity","name":"warn"}],"line":549},{"kind":13,"line":561,"definition":"my","name":"$SEQ_REGEX","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"definition":"my","name":"$META_REGEX","line":562,"kind":13},{"name":"_postprocess_hsp","range":{"start":{"character":0,"line":564},"end":{"line":591,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_postprocess_hsp($self,$hsp)","documentation":"","parameters":[{"label":"$self"},{"label":"$hsp"}]},"detail":"($self,$hsp)","kind":12,"children":[{"line":565,"kind":13,"localvar":"my","containerName":"_postprocess_hsp","definition":"my","name":"$self"},{"line":565,"kind":13,"containerName":"_postprocess_hsp","name":"$hsp"},{"containerName":"_postprocess_hsp","name":"$self","kind":13,"line":566},{"kind":12,"line":566,"name":"throw","containerName":"_postprocess_hsp"},{"line":566,"kind":13,"name":"$hsp","containerName":"_postprocess_hsp"},{"containerName":"_postprocess_hsp","definition":"my","name":"@ins","localvar":"my","kind":13,"line":567},{"localvar":"my","containerName":"_postprocess_hsp","definition":"my","name":"$type","line":568,"kind":13},{"name":"$hsp","containerName":"_postprocess_hsp","line":569,"kind":13},{"name":"$type","containerName":"_postprocess_hsp","line":569,"kind":13},{"kind":13,"line":570,"name":"$str","definition":"my","containerName":"_postprocess_hsp","localvar":"my"},{"containerName":"_postprocess_hsp","name":"$hsp","kind":13,"line":570},{"containerName":"_postprocess_hsp","name":"$type","line":570,"kind":13},{"definition":"my","name":"$regex","containerName":"_postprocess_hsp","localvar":"my","kind":13,"line":571},{"name":"$type","containerName":"_postprocess_hsp","line":571,"kind":13},{"containerName":"_postprocess_hsp","name":"$META_REGEX","kind":13,"line":571},{"containerName":"_postprocess_hsp","name":"$SEQ_REGEX","line":571,"kind":13},{"line":572,"kind":13,"localvar":"my","containerName":"_postprocess_hsp","definition":"my","name":"$ind"},{"kind":13,"line":573,"name":"$str","containerName":"_postprocess_hsp"},{"line":574,"kind":13,"name":"$ins","containerName":"_postprocess_hsp"},{"line":574,"kind":13,"name":"$ind","containerName":"_postprocess_hsp"},{"line":574,"kind":13,"containerName":"_postprocess_hsp","name":"$type"},{"line":574,"kind":13,"containerName":"_postprocess_hsp","name":"$str"},{"kind":13,"line":575,"containerName":"_postprocess_hsp","name":"$ind"},{"containerName":"_postprocess_hsp","name":"$chunk","definition":"my","localvar":"my","kind":13,"line":578},{"containerName":"_postprocess_hsp","name":"@ins","kind":13,"line":578},{"definition":"my","name":"$max","containerName":"_postprocess_hsp","localvar":"my","kind":13,"line":579},{"line":579,"kind":13,"name":"$min","containerName":"_postprocess_hsp"},{"containerName":"_postprocess_hsp","name":"$chunk","kind":13,"line":579},{"line":579,"kind":13,"containerName":"_postprocess_hsp","name":"$chunk"},{"name":"%rep","definition":"my","containerName":"_postprocess_hsp","localvar":"my","kind":13,"line":581},{"line":582,"kind":13,"containerName":"_postprocess_hsp","name":"$rep"},{"kind":13,"line":582,"containerName":"_postprocess_hsp","name":"$max"},{"kind":13,"line":582,"containerName":"_postprocess_hsp","name":"$chunk"},{"kind":13,"line":582,"containerName":"_postprocess_hsp","name":"$max"},{"line":583,"kind":13,"containerName":"_postprocess_hsp","name":"$rep"},{"kind":13,"line":583,"containerName":"_postprocess_hsp","name":"$min"},{"kind":13,"line":583,"containerName":"_postprocess_hsp","name":"$chunk"},{"line":583,"kind":13,"name":"$min","containerName":"_postprocess_hsp"},{"name":"$chunk","containerName":"_postprocess_hsp","line":584,"kind":13},{"kind":13,"line":584,"name":"$max","containerName":"_postprocess_hsp"},{"line":584,"kind":13,"containerName":"_postprocess_hsp","name":"$chunk"},{"containerName":"_postprocess_hsp","name":"$min","kind":13,"line":584},{"containerName":"_postprocess_hsp","name":"$rep","kind":13,"line":585},{"kind":13,"line":585,"containerName":"_postprocess_hsp","name":"$chunk"},{"line":585,"kind":13,"containerName":"_postprocess_hsp","name":"$max"},{"kind":13,"line":586,"name":"$rep","containerName":"_postprocess_hsp"},{"kind":13,"line":586,"name":"$chunk","containerName":"_postprocess_hsp"},{"kind":13,"line":586,"name":"$max","containerName":"_postprocess_hsp"},{"localvar":"my","name":"$t","definition":"my","containerName":"_postprocess_hsp","line":587,"kind":13},{"line":588,"kind":13,"name":"$hsp","containerName":"_postprocess_hsp"},{"kind":13,"line":588,"name":"$t","containerName":"_postprocess_hsp"},{"name":"$chunk","containerName":"_postprocess_hsp","line":588,"kind":13},{"line":588,"kind":13,"containerName":"_postprocess_hsp","name":"$chunk"},{"kind":13,"line":588,"name":"$rep","containerName":"_postprocess_hsp"},{"name":"$t","containerName":"_postprocess_hsp","line":588,"kind":13}],"line":564},{"name":"pos","kind":12,"line":574},{"name":"str","line":574,"kind":12},{"name":"hit","kind":12,"line":579},{"name":"str","line":579,"kind":12},{"name":"query","kind":12,"line":579},{"line":579,"kind":12,"name":"str"},{"line":582,"kind":12,"name":"str"},{"line":583,"kind":12,"name":"str"},{"name":"str","kind":12,"line":584},{"line":584,"kind":12,"name":"str"},{"name":"str","line":585,"kind":12},{"kind":12,"line":586,"name":"str"},{"kind":12,"line":588,"name":"meta"},{"name":"pos","line":588,"kind":12},{"line":588,"kind":12,"name":"meta"},{"name":"str","line":588,"kind":12}]}