{"version":5,"vars":[{"containerName":"","name":"base","line":128,"kind":2},{"name":"algorithm","range":{"start":{"line":141,"character":0},"end":{"character":9999,"line":144}},"kind":12,"children":[{"containerName":"algorithm","name":"$self","definition":"my","localvar":"my","kind":13,"line":142},{"name":"@args","containerName":"algorithm","line":142,"kind":13},{"kind":13,"line":143,"containerName":"algorithm","name":"$self"},{"containerName":"algorithm","name":"throw_not_implemented","line":143,"kind":12}],"line":141,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"algorithm($self,@args)"},"detail":"($self,@args)"},{"range":{"end":{"character":9999,"line":160},"start":{"character":0,"line":157}},"name":"pvalue","children":[{"name":"$self","definition":"my","containerName":"pvalue","localvar":"my","kind":13,"line":158},{"containerName":"pvalue","name":"$self","kind":13,"line":159},{"containerName":"pvalue","name":"throw_not_implemented","line":159,"kind":12}],"line":157,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none","label":"pvalue($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":172,"character":0},"end":{"line":175,"character":9999}},"name":"evalue","signature":{"label":"evalue($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":173,"containerName":"evalue","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":174,"containerName":"evalue","name":"$self"},{"line":174,"kind":12,"containerName":"evalue","name":"throw_not_implemented"}],"line":172,"kind":12},{"line":191,"children":[{"line":192,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$type","line":192,"kind":13},{"kind":13,"line":193,"containerName":"frac_identical","name":"$self"},{"name":"throw_not_implemented","containerName":"frac_identical","line":193,"kind":12}],"kind":12,"detail":"($self,$type)","signature":{"label":"frac_identical($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' "},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":194},"start":{"character":0,"line":191}},"name":"frac_identical"},{"name":"frac_conserved","range":{"start":{"character":0,"line":211},"end":{"line":214,"character":9999}},"kind":12,"line":211,"children":[{"kind":13,"line":212,"name":"$self","definition":"my","containerName":"frac_conserved","localvar":"my"},{"containerName":"frac_conserved","name":"$type","kind":13,"line":212},{"line":213,"kind":13,"containerName":"frac_conserved","name":"$self"},{"name":"throw_not_implemented","containerName":"frac_conserved","line":213,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"frac_conserved($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' "}},{"range":{"end":{"character":9999,"line":229},"start":{"line":227,"character":0}},"name":"num_identical","definition":"sub","containerName":"main::","children":[{"containerName":"num_identical","name":"throw_not_implemented","kind":12,"line":228}],"line":227,"kind":12},{"kind":12,"line":242,"children":[{"name":"throw_not_implemented","containerName":"num_conserved","line":243,"kind":12}],"containerName":"main::","definition":"sub","name":"num_conserved","range":{"end":{"character":9999,"line":244},"start":{"line":242,"character":0}}},{"kind":12,"line":259,"children":[{"name":"$self","definition":"my","containerName":"gaps","localvar":"my","kind":13,"line":260},{"containerName":"gaps","name":"$type","kind":13,"line":260},{"line":261,"kind":13,"containerName":"gaps","name":"$self"},{"containerName":"gaps","name":"throw_not_implemented","kind":12,"line":261}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"gaps($self,$type)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}]},"name":"gaps","range":{"end":{"character":9999,"line":262},"start":{"character":0,"line":259}}},{"range":{"start":{"line":275,"character":0},"end":{"character":9999,"line":278}},"name":"query_string","line":275,"children":[{"kind":13,"line":276,"containerName":"query_string","name":"$self","definition":"my","localvar":"my"},{"containerName":"query_string","name":"$self","kind":13,"line":277},{"name":"throw_not_implemented","containerName":"query_string","kind":12,"line":277}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none","parameters":[{"label":"$self"}],"label":"query_string($self)"},"containerName":"main::","definition":"sub"},{"name":"hit_string","range":{"end":{"line":294,"character":9999},"start":{"character":0,"line":291}},"kind":12,"line":291,"children":[{"line":292,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"hit_string"},{"line":293,"kind":13,"name":"$self","containerName":"hit_string"},{"line":293,"kind":12,"name":"throw_not_implemented","containerName":"hit_string"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"hit_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none"}},{"line":309,"children":[{"definition":"my","name":"$self","containerName":"homology_string","localvar":"my","kind":13,"line":310},{"containerName":"homology_string","name":"$self","line":311,"kind":13},{"name":"throw_not_implemented","containerName":"homology_string","kind":12,"line":311}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none","parameters":[{"label":"$self"}],"label":"homology_string($self)"},"containerName":"main::","definition":"sub","range":{"end":{"line":312,"character":9999},"start":{"character":0,"line":309}},"name":"homology_string"},{"line":330,"children":[{"line":331,"kind":12,"containerName":"length","name":"throw_not_implemented"}],"kind":12,"range":{"start":{"line":330,"character":0},"end":{"character":9999,"line":332}},"containerName":"main::","definition":"sub","name":"length"},{"name":"percent_identity","range":{"end":{"character":9999,"line":348},"start":{"line":345,"character":0}},"kind":12,"children":[{"kind":13,"line":346,"name":"$self","definition":"my","containerName":"percent_identity","localvar":"my"},{"line":347,"kind":13,"containerName":"percent_identity","name":"$self"},{"name":"frac_identical","containerName":"percent_identity","line":347,"kind":12}],"line":345,"definition":"sub","containerName":"main::","signature":{"label":"percent_identity($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none"},"detail":"($self)"},{"range":{"end":{"character":9999,"line":363},"start":{"character":0,"line":360}},"name":"get_aln","detail":"($self)","signature":{"label":"get_aln($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":360,"children":[{"containerName":"get_aln","name":"$self","definition":"my","localvar":"my","kind":13,"line":361},{"containerName":"get_aln","name":"$self","line":362,"kind":13},{"line":362,"kind":12,"containerName":"get_aln","name":"throw_not_implemented"}],"kind":12},{"range":{"end":{"line":395,"character":9999},"start":{"line":393,"character":0}},"name":"seq_inds","definition":"sub","containerName":"main::","children":[{"containerName":"seq_inds","name":"throw_not_implemented","kind":12,"line":394}],"line":393,"kind":12},{"containerName":"main::","definition":"sub","name":"strand","range":{"start":{"character":0,"line":461},"end":{"character":9999,"line":481}},"kind":12,"line":461,"children":[{"kind":13,"line":462,"definition":"my","name":"$self","containerName":"strand","localvar":"my"},{"kind":13,"line":463,"name":"$val","definition":"my","containerName":"strand","localvar":"my"},{"name":"$val","containerName":"strand","kind":13,"line":464},{"line":464,"kind":13,"containerName":"strand","name":"$val"},{"name":"$val","containerName":"strand","kind":13,"line":465},{"name":"$val","containerName":"strand","kind":13,"line":467},{"line":468,"kind":13,"containerName":"strand","name":"$self"},{"kind":12,"line":468,"containerName":"strand","name":"query"},{"kind":12,"line":468,"name":"strand","containerName":"strand"},{"kind":13,"line":469,"containerName":"strand","name":"$val"},{"line":470,"kind":13,"containerName":"strand","name":"$self"},{"name":"hit","containerName":"strand","kind":12,"line":470},{"kind":12,"line":470,"name":"strand","containerName":"strand"},{"line":471,"kind":13,"containerName":"strand","name":"$val"},{"containerName":"strand","name":"$self","kind":13,"line":475},{"name":"query","containerName":"strand","kind":12,"line":475},{"line":475,"kind":12,"name":"strand","containerName":"strand"},{"kind":13,"line":476,"name":"$self","containerName":"strand"},{"containerName":"strand","name":"hit","kind":12,"line":476},{"name":"strand","containerName":"strand","kind":12,"line":476},{"containerName":"strand","name":"$self","kind":13,"line":478},{"line":478,"kind":12,"containerName":"strand","name":"warn"}]},{"range":{"start":{"character":0,"line":494},"end":{"line":514,"character":9999}},"containerName":"main::","definition":"sub","name":"start","line":494,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start","line":495,"kind":13},{"definition":"my","name":"$val","containerName":"start","localvar":"my","kind":13,"line":496},{"kind":13,"line":497,"containerName":"start","name":"$val"},{"kind":13,"line":497,"containerName":"start","name":"$val"},{"name":"$val","containerName":"start","line":498,"kind":13},{"name":"$val","containerName":"start","kind":13,"line":500},{"name":"$self","containerName":"start","line":501,"kind":13},{"name":"query","containerName":"start","kind":12,"line":501},{"containerName":"start","name":"start","line":501,"kind":12},{"name":"$val","containerName":"start","line":502,"kind":13},{"name":"$self","containerName":"start","kind":13,"line":503},{"containerName":"start","name":"hit","kind":12,"line":503},{"line":503,"kind":12,"containerName":"start","name":"start"},{"name":"$val","containerName":"start","kind":13,"line":504},{"kind":13,"line":508,"name":"$self","containerName":"start"},{"kind":12,"line":508,"containerName":"start","name":"query"},{"containerName":"start","name":"start","kind":12,"line":508},{"kind":13,"line":509,"name":"$self","containerName":"start"},{"name":"hit","containerName":"start","kind":12,"line":509},{"kind":12,"line":509,"containerName":"start","name":"start"},{"kind":13,"line":511,"containerName":"start","name":"$self"},{"kind":12,"line":511,"name":"warn","containerName":"start"}],"kind":12},{"containerName":"main::","name":"end","definition":"sub","range":{"start":{"character":0,"line":527},"end":{"line":547,"character":9999}},"kind":12,"line":527,"children":[{"name":"$self","definition":"my","containerName":"end","localvar":"my","kind":13,"line":528},{"localvar":"my","name":"$val","definition":"my","containerName":"end","line":529,"kind":13},{"name":"$val","containerName":"end","line":530,"kind":13},{"name":"$val","containerName":"end","kind":13,"line":530},{"line":531,"kind":13,"containerName":"end","name":"$val"},{"containerName":"end","name":"$val","line":533,"kind":13},{"line":534,"kind":13,"containerName":"end","name":"$self"},{"containerName":"end","name":"query","line":534,"kind":12},{"containerName":"end","name":"end","line":534,"kind":12},{"containerName":"end","name":"$val","kind":13,"line":535},{"line":536,"kind":13,"containerName":"end","name":"$self"},{"name":"hit","containerName":"end","line":536,"kind":12},{"containerName":"end","name":"end","kind":12,"line":536},{"name":"$val","containerName":"end","line":537,"kind":13},{"name":"$self","containerName":"end","kind":13,"line":541},{"kind":12,"line":541,"name":"query","containerName":"end"},{"containerName":"end","name":"end","line":541,"kind":12},{"name":"$self","containerName":"end","kind":13,"line":542},{"kind":12,"line":542,"name":"hit","containerName":"end"},{"line":542,"kind":12,"containerName":"end","name":"end"},{"name":"$self","containerName":"end","kind":13,"line":544},{"containerName":"end","name":"warn","line":544,"kind":12}]},{"name":"seq","range":{"end":{"character":9999,"line":585},"start":{"line":568,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    shift->throw_not_implemented();\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n\treturn $self->query->strand(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n\treturn $self->hit->strand(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->strand(@_), \n\t\t$self->hit->strand(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->start(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->start(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->start(@_), \n\t\t$self->hit->start(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->end(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->end(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->end(@_), \n\t\t$self->hit->end(@_) );\n    } else {\n\t$self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"seq($self,$seqType)"},"kind":12,"line":568,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"seq","line":569,"kind":13},{"kind":13,"line":569,"containerName":"seq","name":"$seqType"},{"kind":13,"line":570,"containerName":"seq","name":"$seqType"},{"kind":13,"line":571,"name":"$seqType","containerName":"seq"},{"line":571,"kind":13,"name":"$seqType","containerName":"seq"},{"kind":13,"line":572,"name":"$str","definition":"my","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$self","line":572,"kind":13},{"line":572,"kind":12,"name":"seq_str","containerName":"seq"},{"name":"$seqType","containerName":"seq","kind":13,"line":572},{"line":573,"kind":13,"containerName":"seq","name":"$seqType"},{"containerName":"seq","name":"$self","line":574,"kind":13},{"kind":12,"line":574,"containerName":"seq","name":"throw"},{"localvar":"my","containerName":"seq","definition":"my","name":"$id","line":577,"kind":13},{"kind":13,"line":577,"name":"$seqType","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":577},{"line":577,"kind":12,"containerName":"seq","name":"query"},{"name":"seq_id","containerName":"seq","kind":12,"line":577},{"containerName":"seq","name":"$self","kind":13,"line":577},{"line":577,"kind":12,"name":"hit","containerName":"seq"},{"name":"seq_id","containerName":"seq","line":577,"kind":12},{"line":578,"kind":12,"name":"new","containerName":"seq"},{"kind":13,"line":578,"containerName":"seq","name":"$id"},{"containerName":"seq","name":"$str","line":579,"kind":13},{"kind":13,"line":580,"containerName":"seq","name":"$self"},{"line":580,"kind":12,"containerName":"seq","name":"start"},{"kind":13,"line":580,"name":"$seqType","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":581},{"name":"end","containerName":"seq","line":581,"kind":12},{"name":"$seqType","containerName":"seq","kind":13,"line":581},{"containerName":"seq","name":"$self","line":582,"kind":13},{"kind":12,"line":582,"name":"strand","containerName":"seq"},{"name":"$seqType","containerName":"seq","kind":13,"line":582},{"name":"$id","containerName":"seq","kind":13,"line":583}]},{"kind":12,"line":577,"name":"Bio","containerName":"LocatableSeq"},{"line":578,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"name":"seq_str","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":605},"end":{"character":9999,"line":616}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"seq_str","localvar":"my","kind":13,"line":606},{"kind":13,"line":607,"definition":"my","name":"$type","containerName":"seq_str","localvar":"my"},{"name":"$type","containerName":"seq_str","line":609,"kind":13},{"line":609,"kind":13,"containerName":"seq_str","name":"$self"},{"line":609,"kind":12,"containerName":"seq_str","name":"query_string"},{"line":610,"kind":13,"containerName":"seq_str","name":"$type"},{"name":"$self","containerName":"seq_str","line":610,"kind":13},{"name":"hit_string","containerName":"seq_str","line":610,"kind":12},{"containerName":"seq_str","name":"$type","line":611,"kind":13},{"kind":13,"line":611,"containerName":"seq_str","name":"$self"},{"line":611,"kind":12,"name":"homology_string","containerName":"seq_str"},{"kind":13,"line":613,"name":"$self","containerName":"seq_str"},{"kind":12,"line":613,"name":"warn","containerName":"seq_str"}],"line":605},{"line":629,"children":[{"name":"throw_not_implemented","containerName":"rank","line":629,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":629},"start":{"character":0,"line":629}},"containerName":"main::","name":"rank","definition":"sub"},{"name":"matches","range":{"end":{"line":727,"character":9999},"start":{"line":660,"character":0}},"kind":12,"line":660,"children":[{"name":"$self","definition":"my","containerName":"matches","localvar":"my","kind":13,"line":662},{"line":662,"kind":13,"containerName":"matches","name":"%param"},{"kind":13,"line":663,"definition":"my","name":"@data","containerName":"matches","localvar":"my"},{"containerName":"matches","definition":"my","name":"$seqType","localvar":"my","kind":13,"line":664},{"line":664,"kind":13,"containerName":"matches","name":"$beg"},{"line":664,"kind":13,"containerName":"matches","name":"$end"},{"line":664,"kind":13,"containerName":"matches","name":"$param"},{"kind":13,"line":665,"name":"$param","containerName":"matches"},{"line":666,"kind":13,"name":"$param","containerName":"matches"},{"name":"$seqType","containerName":"matches","kind":13,"line":667},{"kind":13,"line":668,"containerName":"matches","name":"$seqType"},{"kind":13,"line":668,"name":"$seqType","containerName":"matches"},{"name":"$beg","containerName":"matches","line":670,"kind":13},{"line":670,"kind":13,"name":"$end","containerName":"matches"},{"name":"$self","containerName":"matches","line":670,"kind":13},{"name":"seq_str","containerName":"matches","kind":12,"line":670},{"line":672,"kind":13,"containerName":"matches","name":"@data"},{"kind":13,"line":672,"name":"$self","containerName":"matches"},{"name":"num_identical","containerName":"matches","kind":12,"line":672},{"line":672,"kind":13,"containerName":"matches","name":"$self"},{"name":"num_conserved","containerName":"matches","kind":12,"line":672},{"containerName":"matches","name":"$beg","kind":13,"line":676},{"containerName":"matches","name":"$end","line":677,"kind":13},{"containerName":"matches","name":"$start","definition":"my","localvar":"my","kind":13,"line":678},{"name":"$stop","containerName":"matches","line":678,"kind":13},{"name":"$self","containerName":"matches","kind":13,"line":678},{"name":"range","containerName":"matches","kind":12,"line":678},{"containerName":"matches","name":"$seqType","kind":13,"line":678},{"kind":13,"line":679,"name":"$beg","containerName":"matches"},{"name":"$beg","containerName":"matches","kind":13,"line":679},{"line":679,"kind":13,"name":"$start","containerName":"matches"},{"containerName":"matches","name":"$end","line":679,"kind":13},{"name":"$beg","containerName":"matches","line":679,"kind":13},{"name":"$end","containerName":"matches","kind":13,"line":679},{"line":680,"kind":13,"containerName":"matches","name":"$end"},{"line":680,"kind":13,"containerName":"matches","name":"$end"},{"kind":13,"line":680,"containerName":"matches","name":"$stop"},{"name":"$beg","containerName":"matches","kind":13,"line":680},{"name":"$end","containerName":"matches","line":680,"kind":13},{"kind":13,"line":680,"containerName":"matches","name":"$beg"},{"line":682,"kind":13,"containerName":"matches","name":"$end"},{"containerName":"matches","name":"$stop","kind":13,"line":682},{"containerName":"matches","name":"$end","line":682,"kind":13},{"line":682,"kind":13,"name":"$stop","containerName":"matches"},{"containerName":"matches","name":"$beg","line":683,"kind":13},{"line":683,"kind":13,"containerName":"matches","name":"$start"},{"containerName":"matches","name":"$beg","line":683,"kind":13},{"containerName":"matches","name":"$start","line":683,"kind":13},{"name":"$match_str","definition":"my","containerName":"matches","localvar":"my","kind":13,"line":686},{"line":686,"kind":13,"containerName":"matches","name":"$self"},{"line":686,"kind":12,"name":"seq_str","containerName":"matches"},{"name":"$self","containerName":"matches","line":687,"kind":13},{"line":687,"kind":12,"name":"gaps","containerName":"matches"},{"line":690,"kind":13,"name":"$match_str","containerName":"matches"},{"kind":13,"line":690,"name":"$self","containerName":"matches"},{"kind":12,"line":690,"name":"seq_str","containerName":"matches"},{"kind":13,"line":691,"definition":"my","name":"$tgt","containerName":"matches","localvar":"my"},{"containerName":"matches","name":"$self","line":691,"kind":13},{"name":"seq_str","containerName":"matches","kind":12,"line":691},{"kind":13,"line":691,"containerName":"matches","name":"$seqType"},{"kind":13,"line":692,"containerName":"matches","definition":"my","name":"$encode","localvar":"my"},{"name":"$match_str","containerName":"matches","line":692,"kind":13},{"name":"$tgt","containerName":"matches","kind":13,"line":692},{"kind":13,"line":693,"definition":"my","name":"$zap","containerName":"matches","localvar":"my"},{"containerName":"matches","name":"$encode","line":694,"kind":13},{"containerName":"matches","name":"$tgt","line":695,"kind":13},{"name":"$match_str","containerName":"matches","kind":13,"line":696},{"kind":13,"line":696,"containerName":"matches","name":"$tgt"},{"line":696,"kind":13,"containerName":"matches","name":"$encode"},{"localvar":"my","definition":"my","name":"$seq","containerName":"matches","line":700,"kind":13},{"name":"$self","containerName":"matches","kind":13,"line":701},{"name":"algorithm","containerName":"matches","kind":12,"line":701},{"kind":13,"line":701,"containerName":"matches","name":"$seqType"},{"containerName":"matches","name":"$seq","kind":13,"line":703},{"line":703,"kind":13,"containerName":"matches","name":"$match_str"},{"kind":13,"line":704,"name":"$beg","containerName":"matches"},{"name":"$start","containerName":"matches","kind":13,"line":704},{"containerName":"matches","name":"$end","line":705,"kind":13},{"kind":13,"line":705,"name":"$beg","containerName":"matches"},{"name":"$self","containerName":"matches","kind":13,"line":707},{"line":707,"kind":12,"containerName":"matches","name":"algorithm"},{"name":"$seqType","containerName":"matches","line":707,"kind":13},{"line":708,"kind":13,"containerName":"matches","name":"$seq"},{"name":"$match_str","containerName":"matches","line":708,"kind":13},{"line":709,"kind":13,"containerName":"matches","name":"$beg"},{"containerName":"matches","name":"$start","kind":13,"line":709},{"name":"$end","containerName":"matches","kind":13,"line":709},{"name":"$beg","containerName":"matches","line":709,"kind":13},{"name":"$seq","containerName":"matches","line":711,"kind":13},{"kind":13,"line":711,"containerName":"matches","name":"$match_str"},{"name":"$beg","containerName":"matches","line":712,"kind":13},{"kind":13,"line":712,"containerName":"matches","name":"$start"},{"kind":13,"line":712,"name":"$end","containerName":"matches"},{"line":712,"kind":13,"name":"$beg","containerName":"matches"},{"containerName":"matches","name":"$seq","line":716,"kind":13},{"containerName":"matches","name":"$self","kind":13,"line":717},{"kind":12,"line":717,"name":"throw","containerName":"matches"},{"containerName":"matches","name":"$seq","kind":13,"line":720},{"kind":13,"line":721,"definition":"my","name":"$len_cons","containerName":"matches","localvar":"my"},{"line":721,"kind":13,"containerName":"matches","name":"$seq"},{"containerName":"matches","name":"$seq","kind":13,"line":722},{"localvar":"my","containerName":"matches","definition":"my","name":"$len_id","line":723,"kind":13},{"containerName":"matches","name":"$seq","kind":13,"line":723},{"name":"@data","containerName":"matches","line":724,"kind":13},{"name":"$len_id","containerName":"matches","line":724,"kind":13},{"containerName":"matches","name":"$len_cons","kind":13,"line":724},{"containerName":"matches","name":"@data","line":726,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,%param)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::HSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n# and Jason Stajich <jason@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::HSPI - Interface for a High Scoring Pair in a similarity search result\n\n=head1 SYNOPSIS\n\n    # Bio::Search::HSP::HSPI objects cannot be instantiated since this\n    # module defines a pure interface.\n\n    # Given an object that implements the Bio::Search::HSP::HSPI  interface,\n    # you can do the following things with it:\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->pvalue();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homology_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n=head1 DESCRIPTION\n\nBio::Search::HSP::HSPI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the L<Bio::Search::HSP::HSPI> interface,\nyou can do the following things with it:\n\n=head1 SEE ALSO\n\nThis interface inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Jason Stajich\n\nEmail sac-at-bioperl.org\nEmail jason-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz, Jason Stajich. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::HSPI;\n\n\nuse strict;\nuse Carp;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Root::RootI);\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : none\n\n\nsub pvalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n   my ($self, $type) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n    shift->throw_not_implemented;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    shift->throw_not_implemented();\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' \n\n\nsub gaps        {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub query_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\nsub hit_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string{\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length{\n    shift->throw_not_implemented();\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\n\nsub percent_identity{\n   my ($self) = @_;\n   return $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    shift->throw_not_implemented();\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n\treturn $self->query->strand(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n\treturn $self->hit->strand(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->strand(@_), \n\t\t$self->hit->strand(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->start(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->start(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->start(@_), \n\t\t$self->hit->start(@_) );\n    } else { \n\t$self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) { \n        return $self->query->end(@_);\n    } elsif( $val =~ /^(hi|s)/i ) {\n\treturn $self->hit->end(@_);\n    } elsif (  $val =~ /^list|array/i ) {\t\n\t# do we really need to pass on additional arguments here? HL\n\t# (formerly this was strand(shift) which is really bad coding because\n\t# it breaks if the callee allows setting to undef)\n\treturn ($self->query->end(@_), \n\t\t$self->hit->end(@_) );\n    } else {\n\t$self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\nsub seq {\n    my($self,$seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n    if( $seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n    require Bio::LocatableSeq;\n    my $id = $seqType =~ /^q/i ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L</seq>, L</seq_inds>, C<_set_match_seq>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if( $type =~ /^q/i ) { return $self->query_string(@_) }\n    elsif( $type =~ /^(s)|(hi)/i ) { return $self->hit_string(@_)}\n    elsif ( $type =~ /^(ho)|(ma)/i  ) { return $self->homology_string(@_) }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank { shift->throw_not_implemented }\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>","parameters":[{"label":"$self"},{"label":"%param"}],"label":"matches($self,%param)"}},{"line":716,"kind":12,"containerName":"length","name":"CORE"},{"line":722,"kind":12,"name":"CORE","containerName":"length"},{"containerName":"length","name":"CORE","line":724,"kind":12},{"kind":12,"line":747,"children":[{"kind":12,"line":747,"containerName":"n","name":"throw_not_implemented"}],"containerName":"main::","name":"n","definition":"sub","range":{"start":{"character":0,"line":747},"end":{"line":747,"character":9999}}},{"definition":"sub","name":"range","containerName":"main::","range":{"start":{"character":0,"line":765},"end":{"line":765,"character":9999}},"kind":12,"children":[{"containerName":"range","name":"throw_not_implemented","kind":12,"line":765}],"line":765},{"line":767,"children":[{"name":"evalue","containerName":"expect","kind":12,"line":767}],"kind":12,"range":{"start":{"character":0,"line":767},"end":{"character":9999,"line":767}},"containerName":"main::","definition":"sub","name":"expect"}]}