{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":122},{"kind":12,"line":175,"children":[{"line":176,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"%args","containerName":"new","line":176,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":181,"kind":13},{"line":181,"kind":13,"name":"$class","containerName":"new"},{"line":186,"kind":13,"localvar":"my","containerName":"new","name":"$arg","definition":"my"},{"name":"$value","containerName":"new","kind":13,"line":186},{"kind":13,"line":186,"name":"%args","containerName":"new"},{"kind":13,"line":187,"name":"$arg","containerName":"new"},{"containerName":"new","name":"$self","line":188,"kind":13},{"containerName":"new","name":"$arg","kind":13,"line":188},{"line":188,"kind":13,"name":"$value","containerName":"new"},{"kind":13,"line":190,"definition":"my","name":"$bits","containerName":"new","localvar":"my"},{"line":190,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","line":192,"kind":13},{"line":192,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"verbose","line":192,"kind":12},{"containerName":"new","name":"$self","kind":13,"line":192},{"containerName":"new","name":"$self","line":193,"kind":13},{"kind":13,"line":197,"containerName":"new","name":"$self"},{"line":197,"kind":12,"name":"throw","containerName":"new"},{"line":198,"kind":13,"name":"$self","containerName":"new"},{"line":201,"kind":13,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":203},{"name":"$self","containerName":"new","line":204,"kind":13},{"line":206,"kind":13,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":206,"kind":13},{"line":207,"kind":13,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","line":207,"kind":12},{"line":210,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","kind":13,"line":212},{"kind":13,"line":213,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($class,%args)","signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')","parameters":[{"label":"$class"},{"label":"%args"}],"label":"new($class,%args)"},"name":"new","range":{"end":{"character":9999,"line":214},"start":{"line":175,"character":0}}},{"kind":12,"line":181,"name":"SUPER","containerName":"new"},{"kind":12,"line":190,"name":"BITS"},{"line":192,"kind":12,"name":"VERBOSE"},{"name":"VERBOSE","line":192,"kind":12},{"name":"GAP_SYMBOL","kind":12,"line":193},{"line":198,"kind":12,"containerName":"length","name":"CORE"},{"name":"GAP_SYMBOL","kind":12,"line":198},{"name":"GAP_SYMBOL","kind":12,"line":201},{"kind":12,"line":203,"name":"ALGORITHM"},{"kind":12,"line":204,"name":"STRANDED"},{"kind":12,"line":206,"name":"QUERY_LENGTH"},{"name":"HIT_LENGTH","line":206,"kind":12},{"line":212,"kind":12,"name":"_finished_new"},{"name":"_logical_length","range":{"start":{"character":0,"line":216},"end":{"character":9999,"line":229}},"definition":"sub","containerName":"main::","signature":{"label":"_logical_length($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":""},"detail":"($self,$type)","kind":12,"children":[{"localvar":"my","containerName":"_logical_length","name":"$self","definition":"my","line":217,"kind":13},{"name":"$type","containerName":"_logical_length","line":217,"kind":13},{"line":218,"kind":13,"localvar":"my","definition":"my","name":"$algo","containerName":"_logical_length"},{"kind":13,"line":218,"containerName":"_logical_length","name":"$self"},{"name":"algorithm","containerName":"_logical_length","kind":12,"line":218},{"definition":"my","name":"$len","containerName":"_logical_length","localvar":"my","kind":13,"line":219},{"containerName":"_logical_length","name":"$self","kind":13,"line":219},{"name":"length","containerName":"_logical_length","line":219,"kind":12},{"containerName":"_logical_length","name":"$type","line":219,"kind":13},{"name":"$logical","definition":"my","containerName":"_logical_length","localvar":"my","kind":13,"line":220},{"kind":13,"line":220,"name":"$len","containerName":"_logical_length"},{"containerName":"_logical_length","name":"$algo","line":221,"kind":13},{"line":222,"kind":13,"containerName":"_logical_length","name":"$logical"},{"kind":13,"line":222,"name":"$len","containerName":"_logical_length"},{"kind":13,"line":222,"containerName":"_logical_length","name":"$type"},{"kind":13,"line":223,"name":"$algo","containerName":"_logical_length"},{"containerName":"_logical_length","name":"$logical","line":224,"kind":13},{"name":"$len","containerName":"_logical_length","kind":13,"line":224},{"name":"$type","containerName":"_logical_length","kind":13,"line":224},{"line":225,"kind":13,"name":"$algo","containerName":"_logical_length"},{"containerName":"_logical_length","name":"$logical","kind":13,"line":226},{"name":"$len","containerName":"_logical_length","line":226,"kind":13},{"line":228,"kind":13,"name":"$logical","containerName":"_logical_length"}],"line":216},{"name":"algorithm","range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":254}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value","label":"algorithm($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":246,"kind":13,"localvar":"my","containerName":"algorithm","name":"$self","definition":"my"},{"line":246,"kind":13,"name":"$value","containerName":"algorithm"},{"localvar":"my","containerName":"algorithm","name":"$previous","definition":"my","line":247,"kind":13},{"kind":13,"line":247,"containerName":"algorithm","name":"$self"},{"line":248,"kind":13,"containerName":"algorithm","name":"$value"},{"line":248,"kind":13,"containerName":"algorithm","name":"$previous"},{"name":"$value","containerName":"algorithm","line":249,"kind":13},{"kind":13,"line":249,"name":"$previous","containerName":"algorithm"},{"name":"$value","containerName":"algorithm","line":249,"kind":13},{"line":250,"kind":13,"containerName":"algorithm","name":"$self"},{"name":"$value","containerName":"algorithm","kind":13,"line":250},{"line":253,"kind":13,"name":"$previous","containerName":"algorithm"}],"line":245},{"name":"pvalue","range":{"end":{"character":9999,"line":274},"start":{"line":267,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"pvalue($self,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"pvalue","name":"$self","definition":"my","line":268,"kind":13},{"line":268,"kind":13,"name":"$value","containerName":"pvalue"},{"localvar":"my","containerName":"pvalue","definition":"my","name":"$previous","line":269,"kind":13},{"line":269,"kind":13,"name":"$self","containerName":"pvalue"},{"containerName":"pvalue","name":"$value","line":270,"kind":13},{"containerName":"pvalue","name":"$self","kind":13,"line":271},{"containerName":"pvalue","name":"$value","line":271,"kind":13},{"kind":13,"line":273,"name":"$previous","containerName":"pvalue"}],"line":267},{"kind":12,"line":286,"children":[{"containerName":"evalue","name":"$self","definition":"my","localvar":"my","kind":13,"line":287},{"containerName":"evalue","name":"$value","kind":13,"line":287},{"containerName":"evalue","definition":"my","name":"$previous","localvar":"my","kind":13,"line":288},{"kind":13,"line":288,"name":"$self","containerName":"evalue"},{"kind":13,"line":289,"name":"$value","containerName":"evalue"},{"line":290,"kind":13,"containerName":"evalue","name":"$self"},{"line":290,"kind":13,"containerName":"evalue","name":"$value"},{"name":"$previous","containerName":"evalue","line":292,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value","label":"evalue($self,$value)"},"name":"evalue","range":{"start":{"line":286,"character":0},"end":{"line":293,"character":9999}}},{"name":"frac_identical","range":{"end":{"character":9999,"line":333},"start":{"character":0,"line":311}},"kind":12,"children":[{"localvar":"my","containerName":"frac_identical","name":"$self","definition":"my","line":312,"kind":13},{"name":"$type","containerName":"frac_identical","kind":13,"line":312},{"kind":13,"line":312,"containerName":"frac_identical","name":"$value"},{"name":"$self","containerName":"frac_identical","kind":13,"line":314},{"kind":13,"line":315,"name":"$self","containerName":"frac_identical"},{"name":"_pre_frac","containerName":"frac_identical","kind":12,"line":315},{"kind":13,"line":318,"name":"$type","containerName":"frac_identical"},{"line":318,"kind":13,"name":"$type","containerName":"frac_identical"},{"line":318,"kind":13,"containerName":"frac_identical","name":"$type"},{"name":"$type","containerName":"frac_identical","line":319,"kind":13},{"kind":13,"line":319,"containerName":"frac_identical","name":"$type"},{"line":320,"kind":13,"name":"$type","containerName":"frac_identical"},{"line":321,"kind":13,"containerName":"frac_identical","name":"$type"},{"kind":13,"line":321,"containerName":"frac_identical","name":"$type"},{"name":"$type","containerName":"frac_identical","line":321,"kind":13},{"containerName":"frac_identical","name":"$type","kind":13,"line":322},{"localvar":"my","containerName":"frac_identical","definition":"my","name":"$previous","line":323,"kind":13},{"line":323,"kind":13,"containerName":"frac_identical","name":"$self"},{"name":"$type","containerName":"frac_identical","kind":13,"line":323},{"line":324,"kind":13,"containerName":"frac_identical","name":"$value"},{"name":"$previous","containerName":"frac_identical","kind":13,"line":324},{"kind":13,"line":325,"containerName":"frac_identical","name":"$value"},{"line":325,"kind":13,"name":"$previous","containerName":"frac_identical"},{"kind":13,"line":325,"containerName":"frac_identical","name":"$value"},{"line":326,"kind":13,"name":"$type","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$type","line":326,"kind":13},{"name":"$self","containerName":"frac_identical","kind":13,"line":327},{"kind":13,"line":327,"containerName":"frac_identical","name":"$type"},{"name":"frac_identical","containerName":"frac_identical","line":327,"kind":12},{"containerName":"frac_identical","name":"$value","kind":13,"line":327},{"line":329,"kind":13,"name":"$self","containerName":"frac_identical"},{"line":329,"kind":13,"containerName":"frac_identical","name":"$type"},{"kind":13,"line":329,"name":"$value","containerName":"frac_identical"},{"line":331,"kind":13,"name":"$previous","containerName":"frac_identical"}],"line":311,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested","label":"frac_identical($self,$type,$value)"},"detail":"($self,$type,$value)"},{"line":314,"kind":12,"name":"_did_prefrac"},{"kind":12,"children":[{"containerName":"frac_conserved","name":"$self","definition":"my","localvar":"my","kind":13,"line":354},{"containerName":"frac_conserved","name":"$type","kind":13,"line":354},{"line":354,"kind":13,"containerName":"frac_conserved","name":"$value"},{"kind":13,"line":356,"containerName":"frac_conserved","name":"$self"},{"name":"$self","containerName":"frac_conserved","line":357,"kind":13},{"line":357,"kind":12,"containerName":"frac_conserved","name":"_pre_frac"},{"containerName":"frac_conserved","name":"$type","line":360,"kind":13},{"containerName":"frac_conserved","name":"$type","kind":13,"line":360},{"line":360,"kind":13,"name":"$type","containerName":"frac_conserved"},{"name":"$type","containerName":"frac_conserved","line":361,"kind":13},{"name":"$type","containerName":"frac_conserved","kind":13,"line":361},{"line":361,"kind":13,"name":"$type","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$type","kind":13,"line":362},{"line":362,"kind":13,"containerName":"frac_conserved","name":"$type"},{"containerName":"frac_conserved","name":"$type","kind":13,"line":362},{"kind":13,"line":363,"name":"$type","containerName":"frac_conserved"},{"containerName":"frac_conserved","definition":"my","name":"$previous","localvar":"my","kind":13,"line":364},{"name":"$self","containerName":"frac_conserved","kind":13,"line":364},{"line":364,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":365,"kind":13,"containerName":"frac_conserved","name":"$value"},{"name":"$previous","containerName":"frac_conserved","kind":13,"line":365},{"containerName":"frac_conserved","name":"$value","kind":13,"line":366},{"line":366,"kind":13,"name":"$previous","containerName":"frac_conserved"},{"line":366,"kind":13,"name":"$value","containerName":"frac_conserved"},{"name":"$self","containerName":"frac_conserved","line":367,"kind":13},{"line":367,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":367,"kind":13,"containerName":"frac_conserved","name":"$value"},{"containerName":"frac_conserved","name":"$previous","kind":13,"line":369}],"line":353,"definition":"sub","containerName":"main::","signature":{"label":"frac_conserved($self,$type,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}]},"detail":"($self,$type,$value)","name":"frac_conserved","range":{"end":{"character":9999,"line":370},"start":{"character":0,"line":353}}},{"line":356,"kind":12,"name":"_did_prefrac"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}],"label":"gaps($self,$type,$value)"},"detail":"($self,$type,$value)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gaps","line":387,"kind":13},{"line":387,"kind":13,"containerName":"gaps","name":"$type"},{"line":387,"kind":13,"name":"$value","containerName":"gaps"},{"name":"$self","containerName":"gaps","kind":13,"line":389},{"containerName":"gaps","name":"$self","kind":13,"line":390},{"kind":12,"line":390,"containerName":"gaps","name":"_pre_gaps"},{"name":"$type","containerName":"gaps","kind":13,"line":393},{"line":393,"kind":13,"containerName":"gaps","name":"$type"},{"line":393,"kind":13,"containerName":"gaps","name":"$type"},{"name":"$type","containerName":"gaps","line":394,"kind":13},{"kind":13,"line":394,"containerName":"gaps","name":"$type"},{"kind":13,"line":394,"containerName":"gaps","name":"$type"},{"containerName":"gaps","name":"$type","line":395,"kind":13},{"kind":13,"line":396,"name":"$type","containerName":"gaps"},{"name":"$type","containerName":"gaps","line":396,"kind":13},{"containerName":"gaps","name":"$previous","definition":"my","localvar":"my","kind":13,"line":397},{"kind":13,"line":397,"name":"$self","containerName":"gaps"},{"containerName":"gaps","name":"$type","kind":13,"line":397},{"kind":13,"line":398,"name":"$value","containerName":"gaps"},{"containerName":"gaps","name":"$previous","kind":13,"line":398},{"line":399,"kind":13,"name":"$value","containerName":"gaps"},{"name":"$previous","containerName":"gaps","kind":13,"line":399},{"name":"$value","containerName":"gaps","kind":13,"line":399},{"name":"$self","containerName":"gaps","line":400,"kind":13},{"name":"$type","containerName":"gaps","line":400,"kind":13},{"kind":13,"line":400,"name":"$value","containerName":"gaps"},{"name":"$previous","containerName":"gaps","line":402,"kind":13}],"line":386,"name":"gaps","range":{"start":{"line":386,"character":0},"end":{"character":9999,"line":403}}},{"kind":12,"line":389,"name":"_did_pregaps"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence","label":"query_string($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":417,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"query_string"},{"kind":13,"line":417,"containerName":"query_string","name":"$value"},{"line":418,"kind":13,"localvar":"my","name":"$previous","definition":"my","containerName":"query_string"},{"containerName":"query_string","name":"$self","kind":13,"line":418},{"line":419,"kind":13,"name":"$value","containerName":"query_string"},{"name":"$previous","containerName":"query_string","kind":13,"line":419},{"kind":13,"line":420,"containerName":"query_string","name":"$value"},{"line":420,"kind":13,"name":"$previous","containerName":"query_string"},{"line":420,"kind":13,"containerName":"query_string","name":"$value"},{"line":421,"kind":13,"name":"$self","containerName":"query_string"},{"name":"$value","containerName":"query_string","line":421,"kind":13},{"containerName":"query_string","name":"$self","line":424,"kind":13},{"kind":13,"line":426,"containerName":"query_string","name":"$previous"}],"line":416,"name":"query_string","range":{"start":{"line":416,"character":0},"end":{"line":427,"character":9999}}},{"kind":12,"line":418,"name":"QUERY_SEQ"},{"line":421,"kind":12,"name":"QUERY_SEQ"},{"range":{"start":{"character":0,"line":440},"end":{"line":451,"character":9999}},"name":"hit_string","children":[{"kind":13,"line":441,"containerName":"hit_string","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"hit_string","line":441,"kind":13},{"localvar":"my","definition":"my","name":"$previous","containerName":"hit_string","line":442,"kind":13},{"kind":13,"line":442,"containerName":"hit_string","name":"$self"},{"name":"$value","containerName":"hit_string","kind":13,"line":443},{"containerName":"hit_string","name":"$previous","line":443,"kind":13},{"kind":13,"line":444,"name":"$value","containerName":"hit_string"},{"kind":13,"line":444,"containerName":"hit_string","name":"$previous"},{"line":444,"kind":13,"name":"$value","containerName":"hit_string"},{"line":445,"kind":13,"containerName":"hit_string","name":"$self"},{"kind":13,"line":445,"name":"$value","containerName":"hit_string"},{"containerName":"hit_string","name":"$self","kind":13,"line":448},{"name":"$previous","containerName":"hit_string","line":450,"kind":13}],"line":440,"kind":12,"signature":{"label":"hit_string($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"line":442,"name":"HIT_SEQ"},{"line":445,"kind":12,"name":"HIT_SEQ"},{"children":[{"line":467,"kind":13,"localvar":"my","containerName":"homology_string","name":"$self","definition":"my"},{"kind":13,"line":467,"name":"$value","containerName":"homology_string"},{"containerName":"homology_string","name":"$previous","definition":"my","localvar":"my","kind":13,"line":468},{"kind":13,"line":468,"containerName":"homology_string","name":"$self"},{"kind":13,"line":469,"name":"$value","containerName":"homology_string"},{"line":469,"kind":13,"containerName":"homology_string","name":"$previous"},{"containerName":"homology_string","name":"$value","kind":13,"line":470},{"line":470,"kind":13,"name":"$previous","containerName":"homology_string"},{"line":470,"kind":13,"containerName":"homology_string","name":"$value"},{"name":"$self","containerName":"homology_string","kind":13,"line":471},{"name":"$value","containerName":"homology_string","kind":13,"line":471},{"line":474,"kind":13,"name":"$self","containerName":"homology_string"},{"line":476,"kind":13,"containerName":"homology_string","name":"$previous"}],"line":466,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence","label":"homology_string($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":477},"start":{"character":0,"line":466}},"name":"homology_string"},{"line":468,"kind":12,"name":"HOMOLOGY_SEQ"},{"kind":12,"line":471,"name":"HOMOLOGY_SEQ"},{"kind":12,"line":496,"children":[{"kind":13,"line":498,"containerName":"length","name":"$self","definition":"my","localvar":"my"},{"line":499,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"length"},{"containerName":"length","name":"$type","kind":13,"line":501},{"name":"$type","containerName":"length","kind":13,"line":501},{"line":502,"kind":13,"name":"$type","containerName":"length"},{"line":502,"kind":13,"name":"$type","containerName":"length"},{"kind":13,"line":504,"name":"$type","containerName":"length"},{"kind":13,"line":505,"name":"$self","containerName":"length"},{"kind":12,"line":505,"name":"query","containerName":"length"},{"containerName":"length","name":"length","kind":12,"line":505},{"containerName":"length","name":"$type","line":506,"kind":13},{"containerName":"length","name":"$self","kind":13,"line":507},{"kind":12,"line":507,"containerName":"length","name":"hit"},{"line":507,"kind":12,"containerName":"length","name":"length"},{"definition":"my","name":"$v","containerName":"length","localvar":"my","kind":13,"line":509},{"kind":13,"line":510,"containerName":"length","name":"$v"},{"name":"$self","containerName":"length","kind":13,"line":511},{"line":511,"kind":13,"name":"$v","containerName":"length"},{"name":"$self","containerName":"length","line":513,"kind":13}],"containerName":"main::","name":"length","definition":"sub","range":{"end":{"line":516,"character":9999},"start":{"character":0,"line":496}}},{"name":"HSP_LENGTH","line":511,"kind":12},{"name":"HSP_LENGTH","kind":12,"line":513},{"range":{"start":{"character":0,"line":528},"end":{"character":9999,"line":528}},"containerName":"main::","name":"hsp_length","definition":"sub","line":528,"children":[{"line":528,"kind":12,"name":"length","containerName":"hsp_length"}],"kind":12},{"name":"percent_identity","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":549},"start":{"line":541,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"percent_identity","definition":"my","name":"$self","line":542,"kind":13},{"name":"$self","containerName":"percent_identity","kind":13,"line":544},{"name":"$self","containerName":"percent_identity","kind":13,"line":545},{"line":545,"kind":12,"name":"_pre_pi","containerName":"percent_identity"},{"kind":13,"line":548,"name":"$self","containerName":"percent_identity"}],"line":541},{"name":"_did_prepi","line":544,"kind":12},{"kind":12,"line":548,"name":"SUPER","containerName":"percent_identity"},{"name":"frame","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":581},"end":{"line":613,"character":9999}},"kind":12,"children":[{"kind":13,"line":582,"name":"$self","definition":"my","containerName":"frame","localvar":"my"},{"name":"$val","definition":"my","containerName":"frame","localvar":"my","kind":13,"line":583},{"containerName":"frame","name":"$val","line":584,"kind":13},{"line":586,"kind":13,"containerName":"frame","name":"$self"},{"kind":12,"line":586,"containerName":"frame","name":"warn"},{"name":"$val","containerName":"frame","kind":13,"line":589},{"containerName":"frame","name":"$val","line":591,"kind":13},{"line":593,"kind":13,"containerName":"frame","name":"$val"},{"kind":13,"line":594,"containerName":"frame","name":"$self"},{"containerName":"frame","name":"query","kind":12,"line":594},{"kind":12,"line":594,"name":"frame","containerName":"frame"},{"containerName":"frame","name":"$val","kind":13,"line":595},{"kind":13,"line":596,"containerName":"frame","name":"$self"},{"name":"hit","containerName":"frame","kind":12,"line":596},{"kind":12,"line":596,"name":"frame","containerName":"frame"},{"kind":13,"line":597,"containerName":"frame","name":"$val"},{"kind":13,"line":598,"name":"$self","containerName":"frame"},{"line":598,"kind":12,"containerName":"frame","name":"query"},{"kind":12,"line":598,"name":"frame","containerName":"frame"},{"containerName":"frame","name":"$self","line":599,"kind":13},{"line":599,"kind":12,"name":"hit","containerName":"frame"},{"containerName":"frame","name":"frame","kind":12,"line":599},{"line":600,"kind":13,"containerName":"frame","name":"$val"},{"containerName":"frame","name":"$self","kind":13,"line":603},{"line":603,"kind":12,"name":"warn","containerName":"frame"},{"line":606,"kind":13,"containerName":"frame","name":"$self"},{"line":606,"kind":12,"name":"query","containerName":"frame"},{"kind":12,"line":606,"containerName":"frame","name":"frame"},{"containerName":"frame","name":"$val","line":606,"kind":13},{"kind":13,"line":607,"name":"$self","containerName":"frame"},{"line":607,"kind":12,"containerName":"frame","name":"hit"},{"line":607,"kind":12,"containerName":"frame","name":"frame"},{"containerName":"frame","name":"$self","line":608,"kind":13},{"containerName":"frame","name":"hit","line":608,"kind":12},{"kind":12,"line":608,"containerName":"frame","name":"frame"},{"line":608,"kind":13,"name":"$val","containerName":"frame"},{"containerName":"frame","name":"$self","kind":13,"line":610},{"containerName":"frame","name":"warn","line":610,"kind":12}],"line":581},{"children":[{"line":626,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_aln"},{"kind":13,"line":629,"name":"$aln","definition":"my","containerName":"get_aln","localvar":"my"},{"name":"new","containerName":"get_aln","kind":12,"line":629},{"definition":"my","name":"$hs","containerName":"get_aln","localvar":"my","kind":13,"line":630},{"kind":13,"line":630,"containerName":"get_aln","name":"$self"},{"line":630,"kind":12,"name":"hit_string","containerName":"get_aln"},{"containerName":"get_aln","name":"$qs","definition":"my","localvar":"my","kind":13,"line":631},{"name":"$self","containerName":"get_aln","kind":13,"line":631},{"containerName":"get_aln","name":"query_string","kind":12,"line":631},{"line":633,"kind":13,"localvar":"my","containerName":"get_aln","definition":"my","name":"$seqonly"},{"name":"$qs","containerName":"get_aln","kind":13,"line":633},{"name":"$seqonly","containerName":"get_aln","line":634,"kind":13},{"localvar":"my","containerName":"get_aln","definition":"my","name":"$q_nm","line":635,"kind":13},{"containerName":"get_aln","name":"$s_nm","line":635,"kind":13},{"kind":13,"line":635,"containerName":"get_aln","name":"$self"},{"line":635,"kind":12,"name":"query","containerName":"get_aln"},{"containerName":"get_aln","name":"seq_id","kind":12,"line":635},{"containerName":"get_aln","name":"$self","line":636,"kind":13},{"name":"hit","containerName":"get_aln","kind":12,"line":636},{"kind":12,"line":636,"name":"seq_id","containerName":"get_aln"},{"kind":13,"line":648,"definition":"my","name":"$query","containerName":"get_aln","localvar":"my"},{"line":648,"kind":12,"containerName":"get_aln","name":"new"},{"containerName":"get_aln","name":"$qs","kind":13,"line":648},{"containerName":"get_aln","name":"$q_nm","kind":13,"line":649},{"line":650,"kind":13,"containerName":"get_aln","name":"$self"},{"containerName":"get_aln","name":"query","line":650,"kind":12},{"line":650,"kind":12,"name":"start","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","kind":13,"line":651},{"line":651,"kind":12,"name":"query","containerName":"get_aln"},{"containerName":"get_aln","name":"end","line":651,"kind":12},{"name":"$q_nm","containerName":"get_aln","kind":13,"line":652},{"containerName":"get_aln","name":"$self","kind":13,"line":653},{"name":"$seqonly","containerName":"get_aln","kind":13,"line":655},{"line":655,"kind":13,"name":"$hs","containerName":"get_aln"},{"containerName":"get_aln","name":"$seqonly","line":656,"kind":13},{"kind":13,"line":657,"containerName":"get_aln","name":"$hit","definition":"my","localvar":"my"},{"containerName":"get_aln","name":"new","line":657,"kind":12},{"name":"$hs","containerName":"get_aln","line":657,"kind":13},{"containerName":"get_aln","name":"$s_nm","kind":13,"line":658},{"containerName":"get_aln","name":"$self","line":659,"kind":13},{"line":659,"kind":12,"name":"hit","containerName":"get_aln"},{"containerName":"get_aln","name":"start","kind":12,"line":659},{"containerName":"get_aln","name":"$self","line":660,"kind":13},{"name":"hit","containerName":"get_aln","line":660,"kind":12},{"kind":12,"line":660,"name":"end","containerName":"get_aln"},{"line":661,"kind":13,"containerName":"get_aln","name":"$s_nm"},{"name":"$self","containerName":"get_aln","line":662,"kind":13},{"line":664,"kind":13,"name":"$aln","containerName":"get_aln"},{"kind":12,"line":664,"containerName":"get_aln","name":"add_seq"},{"name":"$query","containerName":"get_aln","kind":13,"line":664},{"line":665,"kind":13,"name":"$aln","containerName":"get_aln"},{"kind":12,"line":665,"name":"add_seq","containerName":"get_aln"},{"containerName":"get_aln","name":"$hit","kind":13,"line":665},{"line":666,"kind":13,"name":"$aln","containerName":"get_aln"}],"line":625,"kind":12,"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none","parameters":[{"label":"$self"}],"label":"get_aln($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":667,"character":9999},"start":{"character":0,"line":625}},"name":"get_aln"},{"line":629,"kind":12,"name":"Bio","containerName":"LocatableSeq::Bio::SimpleAlign"},{"name":"Bio","containerName":"SimpleAlign","line":629,"kind":12},{"line":648,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"name":"_query_mapping","kind":12,"line":653},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":657},{"kind":12,"line":662,"name":"_hit_mapping"},{"definition":"sub","containerName":"main::","signature":{"label":"num_conserved($self,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"num_conserved","localvar":"my","kind":13,"line":681},{"line":681,"kind":13,"name":"$value","containerName":"num_conserved"},{"kind":13,"line":683,"containerName":"num_conserved","name":"$self"},{"containerName":"num_conserved","name":"$self","kind":13,"line":684},{"line":684,"kind":12,"containerName":"num_conserved","name":"_pre_similar_stats"},{"containerName":"num_conserved","name":"$value","line":687,"kind":13},{"name":"$self","containerName":"num_conserved","line":688,"kind":13},{"kind":13,"line":688,"containerName":"num_conserved","name":"$value"},{"containerName":"num_conserved","name":"$self","line":690,"kind":13}],"line":680,"name":"num_conserved","range":{"start":{"character":0,"line":680},"end":{"character":9999,"line":691}}},{"name":"_did_presimilar","line":683,"kind":12},{"name":"CONSERVED","line":688,"kind":12},{"name":"CONSERVED","line":690,"kind":12},{"range":{"start":{"character":0,"line":704},"end":{"character":9999,"line":715}},"name":"num_identical","children":[{"kind":13,"line":705,"containerName":"num_identical","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":705,"name":"$value","containerName":"num_identical"},{"line":707,"kind":13,"name":"$self","containerName":"num_identical"},{"name":"$self","containerName":"num_identical","line":708,"kind":13},{"kind":12,"line":708,"containerName":"num_identical","name":"_pre_similar_stats"},{"name":"$value","containerName":"num_identical","kind":13,"line":711},{"containerName":"num_identical","name":"$self","line":712,"kind":13},{"line":712,"kind":13,"name":"$value","containerName":"num_identical"},{"containerName":"num_identical","name":"$self","line":714,"kind":13}],"line":704,"kind":12,"signature":{"label":"num_identical($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"_did_presimilar","kind":12,"line":707},{"line":712,"kind":12,"name":"IDENTICAL"},{"name":"IDENTICAL","line":714,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"rank($self,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n   my ($self,$value) = @_;\n\n   unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n   if( defined $value) {\n       $self->{IDENTICAL} = $value;\n   }\n   return $self->{IDENTICAL};\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":727,"children":[{"definition":"my","name":"$self","containerName":"rank","localvar":"my","kind":13,"line":728},{"line":728,"kind":13,"name":"$value","containerName":"rank"},{"line":729,"kind":13,"name":"$value","containerName":"rank"},{"name":"$self","containerName":"rank","kind":13,"line":730},{"containerName":"rank","name":"$value","line":730,"kind":13},{"name":"$self","containerName":"rank","line":732,"kind":13}],"name":"rank","range":{"end":{"character":9999,"line":733},"start":{"character":0,"line":727}}},{"line":730,"kind":12,"name":"RANK"},{"line":732,"kind":12,"name":"RANK"},{"name":"seq_inds","range":{"end":{"character":9999,"line":844},"start":{"character":0,"line":779}},"definition":"sub","containerName":"main::","signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n   my ($self,$value) = @_;\n\n   unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n   if( defined $value) {\n       $self->{IDENTICAL} = $value;\n   }\n   return $self->{IDENTICAL};\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    my ($self,$value) = @_;\n    if( defined $value) {\n        $self->{RANK} = $value;\n    }\n    return $self->{RANK};\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical\n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved-not-identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers\n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : class     = 'identical' - identical positions\n           :             'conserved' - conserved positions\n           :             'nomatch'   - mismatched residue or gap positions\n           :             'mismatch'  - mismatched residue positions (no gaps)\n           :             'gap'       - gap positions only\n           :             'frameshift'- frameshift positions only\n           :             'conserved-not-identical' - conserved positions w/o \n           :                            identical residues\n           :             The name can be shortened to 'id' or 'cons' unless\n           :             the name is ambiguous.  The default value is\n           :             'identical'\n           :\n           : collapse  = boolean, if true, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n           :\n Throws    : n/a.\n Comments  : For HSPs partially or completely derived from translated sequences\n           : (TBLASTN, BLASTX, TBLASTX, or similar), some positional data\n           : cannot easily be attributed to a single position (i.e. the \n           : positional data is ambiguous).  In these cases all three codon \n           : positions are reported.  Under these conditions you can check \n           : ambiguous_seq_inds() to determine whether the query, subject, \n           : or both are ambiguous.\n           :\nSee Also   : L<Bio::Search::SearchUtils::collapse_nums()|Bio::Search::SearchUtils>,\n             L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>"},"detail":"($self,$seqType,$class,$collapse)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"seq_inds","localvar":"my","kind":13,"line":780},{"kind":13,"line":780,"name":"$seqType","containerName":"seq_inds"},{"line":780,"kind":13,"containerName":"seq_inds","name":"$class"},{"name":"$collapse","containerName":"seq_inds","kind":13,"line":780},{"line":784,"kind":13,"containerName":"seq_inds","name":"$self"},{"kind":12,"line":784,"name":"_calculate_seq_positions","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":786},{"name":"$class","containerName":"seq_inds","kind":13,"line":787},{"line":788,"kind":13,"name":"$collapse","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$seqType","line":789,"kind":13},{"containerName":"seq_inds","name":"$seqType","line":789,"kind":13},{"containerName":"seq_inds","definition":"my","name":"$t","localvar":"my","kind":13,"line":790},{"line":790,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"name":"$t","containerName":"seq_inds","kind":13,"line":791},{"kind":13,"line":792,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$t","kind":13,"line":793},{"kind":13,"line":793,"name":"$t","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":794},{"kind":13,"line":796,"name":"$self","containerName":"seq_inds"},{"containerName":"seq_inds","name":"warn","line":796,"kind":12},{"kind":13,"line":797,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$t","line":800,"kind":13},{"line":800,"kind":13,"name":"$class","containerName":"seq_inds"},{"kind":13,"line":802,"name":"$t","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$class","kind":13,"line":803},{"containerName":"seq_inds","name":"$class","line":804,"kind":13},{"containerName":"seq_inds","name":"$class","line":806,"kind":13},{"line":808,"kind":13,"containerName":"seq_inds","name":"$t"},{"line":809,"kind":13,"name":"$class","containerName":"seq_inds"},{"line":810,"kind":13,"containerName":"seq_inds","name":"$t"},{"name":"$class","containerName":"seq_inds","line":811,"kind":13},{"kind":13,"line":812,"name":"$t","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$class","kind":13,"line":813},{"line":814,"kind":13,"containerName":"seq_inds","name":"$t"},{"name":"$class","containerName":"seq_inds","line":815,"kind":13},{"kind":13,"line":816,"containerName":"seq_inds","name":"$t"},{"name":"$class","containerName":"seq_inds","line":817,"kind":13},{"name":"$self","containerName":"seq_inds","kind":13,"line":819},{"kind":12,"line":819,"containerName":"seq_inds","name":"warn"},{"kind":13,"line":820,"name":"$class","containerName":"seq_inds"},{"line":824,"kind":13,"name":"$seqType","containerName":"seq_inds"},{"kind":13,"line":825,"name":"$class","containerName":"seq_inds"},{"definition":"my","name":"@ary","containerName":"seq_inds","localvar":"my","kind":13,"line":826},{"line":828,"kind":13,"name":"$class","containerName":"seq_inds"},{"line":837,"kind":13,"containerName":"seq_inds","name":"@ary"},{"definition":"my","name":"@tmp","containerName":"seq_inds","localvar":"my","kind":13,"line":837},{"name":"$g","definition":"my","containerName":"seq_inds","localvar":"my","kind":13,"line":839},{"kind":13,"line":839,"name":"$self","containerName":"seq_inds"},{"name":"@tmp","containerName":"seq_inds","kind":13,"line":840},{"containerName":"seq_inds","name":"@tmp","line":842,"kind":13},{"containerName":"seq_inds","name":"$a","kind":13,"line":843},{"kind":13,"line":843,"containerName":"seq_inds","name":"$b"},{"line":843,"kind":13,"name":"$self","containerName":"seq_inds"}],"line":779},{"line":839,"kind":12,"name":"seqinds"},{"line":843,"kind":12,"name":"seqinds"},{"containerName":null,"name":"%class","line":844,"kind":13},{"containerName":null,"name":"@ary","kind":13,"line":845},{"containerName":null,"name":"$a","kind":13,"line":845},{"line":845,"kind":13,"name":"$b","containerName":null},{"kind":13,"line":846,"containerName":null,"name":"%self"},{"name":"seqinds","kind":12,"line":846},{"name":"%self","containerName":null,"kind":13,"line":847},{"kind":12,"line":847,"name":"seqinds"},{"name":"@ary","containerName":null,"line":849,"kind":13},{"line":849,"kind":13,"name":"$a","containerName":null},{"line":849,"kind":13,"name":"$b","containerName":null},{"line":849,"kind":13,"name":"%self","containerName":null},{"name":"seqinds","kind":12,"line":849},{"kind":13,"line":851,"containerName":null,"name":"$collapse"},{"line":853,"kind":13,"containerName":null,"name":"$collapse"},{"containerName":"Search::BlastUtils","name":"Bio","kind":12,"line":853},{"containerName":"Search::SearchUtils::collapse_nums","name":"Bio","line":853,"kind":12},{"name":"@ary","containerName":null,"kind":13,"line":853},{"name":"@ary","containerName":null,"line":853,"kind":13},{"range":{"start":{"character":0,"line":874},"end":{"character":9999,"line":879}},"name":"ambiguous_seq_inds","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"ambiguous_seq_inds","line":875,"kind":13},{"containerName":"ambiguous_seq_inds","name":"$self","line":876,"kind":13},{"kind":12,"line":876,"name":"_calculate_seq_positions","containerName":"ambiguous_seq_inds"},{"name":"$self","containerName":"ambiguous_seq_inds","line":877,"kind":13},{"name":"$self","containerName":"ambiguous_seq_inds","line":877,"kind":13},{"line":878,"kind":13,"name":"$self","containerName":"ambiguous_seq_inds"}],"line":874,"kind":12},{"name":"seqinds","line":877,"kind":12},{"line":877,"kind":12,"name":"seqinds"},{"line":878,"kind":12,"name":"seqinds"},{"range":{"start":{"line":895,"character":0},"end":{"character":9999,"line":901}},"definition":"sub","name":"query","containerName":"main::","children":[{"containerName":"query","definition":"my","name":"$self","localvar":"my","kind":13,"line":896},{"kind":13,"line":897,"name":"$self","containerName":"query"},{"containerName":"query","name":"$self","kind":13,"line":898},{"line":898,"kind":12,"containerName":"query","name":"_query_seq_feature"},{"containerName":"query","name":"$self","kind":13,"line":900}],"line":895,"kind":12},{"name":"_created_qff","line":897,"kind":12},{"kind":12,"line":900,"containerName":"query","name":"SUPER"},{"kind":12,"line":903,"children":[{"line":904,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"feature1"},{"containerName":"feature1","name":"$self","kind":13,"line":905},{"kind":13,"line":905,"containerName":"feature1","name":"$self"},{"name":"$self","containerName":"feature1","kind":13,"line":906},{"kind":13,"line":906,"name":"$self","containerName":"feature1"},{"line":907,"kind":13,"containerName":"feature1","name":"$self"},{"kind":12,"line":907,"name":"new","containerName":"feature1"},{"containerName":"feature1","name":"$self","kind":13,"line":908},{"kind":13,"line":910,"name":"$self","containerName":"feature1"},{"kind":13,"line":911,"name":"$self","containerName":"feature1"},{"line":911,"kind":12,"containerName":"feature1","name":"_query_seq_feature"},{"name":"$self","containerName":"feature1","kind":13,"line":913}],"containerName":"main::","name":"feature1","definition":"sub","range":{"start":{"character":0,"line":903},"end":{"line":914,"character":9999}}},{"kind":12,"line":905,"name":"_finished_new"},{"name":"_making_qff","line":905,"kind":12},{"line":906,"kind":12,"name":"_sim1"},{"name":"_sim1","line":906,"kind":12},{"line":907,"kind":12,"name":"_sim1"},{"name":"Bio","containerName":"SeqFeature::Similarity","line":907,"kind":12},{"name":"_sim1","kind":12,"line":908},{"line":910,"kind":12,"name":"_created_qff"},{"kind":12,"line":913,"name":"SUPER","containerName":"feature1"},{"line":926,"children":[{"name":"$self","definition":"my","containerName":"hit","localvar":"my","kind":13,"line":927},{"containerName":"hit","name":"$self","kind":13,"line":928},{"line":929,"kind":13,"name":"$self","containerName":"hit"},{"containerName":"hit","name":"_subject_seq_feature","line":929,"kind":12},{"containerName":"hit","name":"$self","kind":13,"line":931}],"kind":12,"range":{"start":{"line":926,"character":0},"end":{"character":9999,"line":932}},"containerName":"main::","definition":"sub","name":"hit"},{"name":"_created_sff","line":928,"kind":12},{"line":931,"kind":12,"name":"SUPER","containerName":"hit"},{"kind":12,"line":934,"children":[{"containerName":"feature2","name":"$self","definition":"my","localvar":"my","kind":13,"line":935},{"line":936,"kind":13,"name":"$self","containerName":"feature2"},{"line":936,"kind":13,"containerName":"feature2","name":"$self"},{"kind":13,"line":937,"name":"$self","containerName":"feature2"},{"line":937,"kind":13,"containerName":"feature2","name":"$self"},{"line":938,"kind":13,"containerName":"feature2","name":"$self"},{"containerName":"feature2","name":"new","kind":12,"line":938},{"line":939,"kind":13,"containerName":"feature2","name":"$self"},{"containerName":"feature2","name":"$self","line":941,"kind":13},{"containerName":"feature2","name":"$self","line":942,"kind":13},{"name":"_subject_seq_feature","containerName":"feature2","kind":12,"line":942},{"line":944,"kind":13,"name":"$self","containerName":"feature2"}],"containerName":"main::","name":"feature2","definition":"sub","range":{"end":{"character":9999,"line":945},"start":{"character":0,"line":934}}},{"name":"_finished_new","kind":12,"line":936},{"name":"_making_sff","kind":12,"line":936},{"name":"_sim2","kind":12,"line":937},{"line":937,"kind":12,"name":"_sim2"},{"name":"_sim2","kind":12,"line":938},{"name":"Bio","containerName":"SeqFeature::Similarity","line":938,"kind":12},{"name":"_sim2","line":939,"kind":12},{"kind":12,"line":941,"name":"_created_sff"},{"line":944,"kind":12,"containerName":"feature2","name":"SUPER"},{"name":"significance","range":{"start":{"character":0,"line":961},"end":{"character":9999,"line":971}},"kind":12,"children":[{"line":962,"kind":13,"localvar":"my","containerName":"significance","name":"$self","definition":"my"},{"line":962,"kind":13,"containerName":"significance","name":"$val"},{"line":963,"kind":13,"name":"$self","containerName":"significance"},{"containerName":"significance","name":"$val","kind":13,"line":963},{"containerName":"significance","name":"$self","line":964,"kind":13},{"containerName":"significance","name":"$val","line":964,"kind":13},{"kind":13,"line":964,"containerName":"significance","name":"$val"},{"containerName":"significance","name":"$self","kind":13,"line":965},{"kind":12,"line":965,"name":"evalue","containerName":"significance"},{"kind":13,"line":965,"containerName":"significance","name":"$self"},{"containerName":"significance","name":"evalue","line":965,"kind":12},{"containerName":"significance","name":"$self","line":966,"kind":13},{"name":"pvalue","containerName":"significance","kind":12,"line":966},{"line":966,"kind":12,"containerName":"significance","name":"pvalue"},{"line":968,"kind":13,"containerName":"significance","name":"$self"},{"line":968,"kind":12,"name":"query","containerName":"significance"},{"kind":12,"line":968,"containerName":"significance","name":"significance"},{"containerName":"significance","name":"$self","line":968,"kind":13},{"kind":13,"line":970,"name":"$self","containerName":"significance"}],"line":961,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$val"}],"label":"significance($self,$val)"},"detail":"($self,$val)"},{"line":963,"kind":12,"name":"SIGNIFICANCE"},{"name":"SIGNIFICANCE","kind":12,"line":964},{"line":966,"kind":12,"name":"self"},{"line":968,"kind":12,"name":"SIGNIFICANCE"},{"name":"SIGNIFICANCE","line":970,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_calculate_seq_positions($self,@args)"},"kind":12,"line":1019,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_calculate_seq_positions","line":1020,"kind":13},{"line":1020,"kind":13,"name":"@args","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$self","kind":13,"line":1021},{"kind":13,"line":1022,"containerName":"_calculate_seq_positions","name":"$self"},{"name":"$seqString","definition":"my","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1023},{"name":"$qseq","containerName":"_calculate_seq_positions","kind":13,"line":1023},{"kind":13,"line":1023,"name":"$sseq","containerName":"_calculate_seq_positions"},{"kind":13,"line":1023,"containerName":"_calculate_seq_positions","name":"$self"},{"name":"homology_string","containerName":"_calculate_seq_positions","kind":12,"line":1023},{"line":1024,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1024,"kind":12,"containerName":"_calculate_seq_positions","name":"query_string"},{"kind":13,"line":1025,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1025,"kind":12,"containerName":"_calculate_seq_positions","name":"hit_string"},{"line":1026,"kind":13,"localvar":"my","definition":"my","name":"$mlen","containerName":"_calculate_seq_positions"},{"line":1026,"kind":13,"containerName":"_calculate_seq_positions","name":"$qlen"},{"line":1026,"kind":13,"containerName":"_calculate_seq_positions","name":"$slen"},{"kind":13,"line":1026,"name":"$seqString","containerName":"_calculate_seq_positions"},{"name":"$qseq","containerName":"_calculate_seq_positions","kind":13,"line":1026},{"name":"$sseq","containerName":"_calculate_seq_positions","kind":13,"line":1026},{"localvar":"my","containerName":"_calculate_seq_positions","name":"$qdir","definition":"my","line":1027,"kind":13},{"line":1027,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1027,"kind":12,"name":"query","containerName":"_calculate_seq_positions"},{"kind":12,"line":1027,"name":"strand","containerName":"_calculate_seq_positions"},{"definition":"my","name":"$sdir","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1028},{"line":1028,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"containerName":"_calculate_seq_positions","name":"hit","kind":12,"line":1028},{"name":"strand","containerName":"_calculate_seq_positions","line":1028,"kind":12},{"kind":13,"line":1029,"name":"$resCount_query","definition":"my","containerName":"_calculate_seq_positions","localvar":"my"},{"containerName":"_calculate_seq_positions","name":"$endpoint_query","line":1029,"kind":13},{"line":1029,"kind":13,"name":"$qdir","containerName":"_calculate_seq_positions"},{"name":"$self","containerName":"_calculate_seq_positions","line":1029,"kind":13},{"containerName":"_calculate_seq_positions","name":"query","line":1029,"kind":12},{"containerName":"_calculate_seq_positions","name":"end","line":1029,"kind":12},{"containerName":"_calculate_seq_positions","name":"$self","line":1029,"kind":13},{"line":1029,"kind":12,"containerName":"_calculate_seq_positions","name":"query"},{"kind":12,"line":1029,"containerName":"_calculate_seq_positions","name":"start"},{"line":1030,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"kind":12,"line":1030,"containerName":"_calculate_seq_positions","name":"query"},{"line":1030,"kind":12,"containerName":"_calculate_seq_positions","name":"start"},{"kind":13,"line":1030,"containerName":"_calculate_seq_positions","name":"$self"},{"containerName":"_calculate_seq_positions","name":"query","kind":12,"line":1030},{"kind":12,"line":1030,"containerName":"_calculate_seq_positions","name":"end"},{"name":"$resCount_sbjct","definition":"my","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1031},{"kind":13,"line":1031,"containerName":"_calculate_seq_positions","name":"$endpoint_sbjct"},{"line":1031,"kind":13,"name":"$sdir","containerName":"_calculate_seq_positions"},{"kind":13,"line":1031,"containerName":"_calculate_seq_positions","name":"$self"},{"kind":12,"line":1031,"containerName":"_calculate_seq_positions","name":"hit"},{"containerName":"_calculate_seq_positions","name":"end","kind":12,"line":1031},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1031},{"kind":12,"line":1031,"name":"hit","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"start","line":1031,"kind":12},{"line":1032,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"containerName":"_calculate_seq_positions","name":"hit","kind":12,"line":1032},{"line":1032,"kind":12,"name":"start","containerName":"_calculate_seq_positions"},{"line":1032,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"kind":12,"line":1032,"containerName":"_calculate_seq_positions","name":"hit"},{"containerName":"_calculate_seq_positions","name":"end","line":1032,"kind":12},{"line":1034,"kind":13,"localvar":"my","name":"$prog","definition":"my","containerName":"_calculate_seq_positions"},{"line":1034,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"name":"algorithm","containerName":"_calculate_seq_positions","line":1034,"kind":12},{"kind":13,"line":1036,"containerName":"_calculate_seq_positions","name":"$prog"},{"localvar":"my","containerName":"_calculate_seq_positions","definition":"my","name":"$start","line":1043,"kind":13},{"line":1043,"kind":13,"containerName":"_calculate_seq_positions","name":"$rest"},{"kind":13,"line":1044,"name":"$seqString","containerName":"_calculate_seq_positions"},{"kind":13,"line":1045,"containerName":"_calculate_seq_positions","name":"$start"},{"line":1045,"kind":13,"containerName":"_calculate_seq_positions","name":"$rest"},{"line":1048,"kind":13,"name":"$seqString","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$seqString","kind":13,"line":1048},{"name":"$start","containerName":"_calculate_seq_positions","kind":13,"line":1048},{"name":"$rest","containerName":"_calculate_seq_positions","line":1048,"kind":13},{"name":"$qseq","containerName":"_calculate_seq_positions","kind":13,"line":1049},{"line":1049,"kind":13,"containerName":"_calculate_seq_positions","name":"$qseq"},{"containerName":"_calculate_seq_positions","name":"$start","line":1049,"kind":13},{"line":1049,"kind":13,"name":"$rest","containerName":"_calculate_seq_positions"},{"line":1050,"kind":13,"containerName":"_calculate_seq_positions","name":"$sseq"},{"containerName":"_calculate_seq_positions","name":"$sseq","kind":13,"line":1050},{"line":1050,"kind":13,"containerName":"_calculate_seq_positions","name":"$start"},{"name":"$rest","containerName":"_calculate_seq_positions","kind":13,"line":1050},{"kind":13,"line":1071,"containerName":"_calculate_seq_positions","name":"$self"},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1072},{"kind":13,"line":1072,"name":"$self","containerName":"_calculate_seq_positions"},{"name":"$prog","containerName":"_calculate_seq_positions","kind":13,"line":1073},{"containerName":"_calculate_seq_positions","name":"$self","line":1074,"kind":13},{"containerName":"_calculate_seq_positions","name":"$self","line":1076,"kind":13},{"kind":13,"line":1077,"name":"$self","containerName":"_calculate_seq_positions"},{"kind":13,"line":1079,"name":"$self","containerName":"_calculate_seq_positions"},{"name":"$prog","containerName":"_calculate_seq_positions","kind":13,"line":1081},{"name":"$self","containerName":"_calculate_seq_positions","line":1082,"kind":13},{"kind":13,"line":1083,"containerName":"_calculate_seq_positions","name":"$self"},{"containerName":"_calculate_seq_positions","definition":"my","name":"$qfs","localvar":"my","kind":13,"line":1085},{"kind":13,"line":1085,"name":"$sfs","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","definition":"my","name":"$pos","localvar":"my","kind":13,"line":1087},{"kind":13,"line":1087,"containerName":"_calculate_seq_positions","name":"$seqString"},{"name":"@qrange","definition":"my","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1088},{"kind":13,"line":1088,"name":"$qfs","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$self","kind":13,"line":1088},{"kind":13,"line":1089,"definition":"my","name":"@srange","containerName":"_calculate_seq_positions","localvar":"my"},{"kind":13,"line":1089,"name":"$sfs","containerName":"_calculate_seq_positions"},{"line":1089,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"kind":13,"line":1091,"name":"$qfs","containerName":"_calculate_seq_positions"},{"line":1091,"kind":13,"name":"$sfs","containerName":"_calculate_seq_positions"},{"localvar":"my","containerName":"_calculate_seq_positions","definition":"my","name":"$mchar","line":1092,"kind":13},{"name":"$qchar","containerName":"_calculate_seq_positions","kind":13,"line":1092},{"name":"$schar","containerName":"_calculate_seq_positions","kind":13,"line":1092},{"line":1093,"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString"},{"containerName":"_calculate_seq_positions","name":"$pos","kind":13,"line":1094},{"name":"$qseq","containerName":"_calculate_seq_positions","kind":13,"line":1094},{"line":1094,"kind":13,"name":"$qseq","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$pos","kind":13,"line":1095},{"containerName":"_calculate_seq_positions","name":"$sseq","line":1095,"kind":13},{"name":"$sseq","containerName":"_calculate_seq_positions","line":1095,"kind":13},{"containerName":"_calculate_seq_positions","name":"$matchtype","definition":"my","localvar":"my","kind":13,"line":1097},{"line":1098,"kind":13,"localvar":"my","name":"$qgap","definition":"my","containerName":"_calculate_seq_positions"},{"name":"$sgap","containerName":"_calculate_seq_positions","kind":13,"line":1098},{"name":"$mchar","containerName":"_calculate_seq_positions","line":1099,"kind":13},{"line":1099,"kind":13,"containerName":"_calculate_seq_positions","name":"$mchar"},{"kind":13,"line":1100,"name":"$self","containerName":"_calculate_seq_positions"},{"kind":13,"line":1100,"containerName":"_calculate_seq_positions","name":"$resCount_query"},{"line":1100,"kind":13,"name":"$qdir","containerName":"_calculate_seq_positions"},{"kind":13,"line":1100,"name":"@qrange","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$self","line":1101,"kind":13},{"containerName":"_calculate_seq_positions","name":"$resCount_sbjct","line":1101,"kind":13},{"line":1101,"kind":13,"containerName":"_calculate_seq_positions","name":"$sdir"},{"line":1101,"kind":13,"name":"@srange","containerName":"_calculate_seq_positions"},{"kind":13,"line":1102,"name":"$matchtype","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$mchar","kind":13,"line":1103},{"name":"$mchar","containerName":"_calculate_seq_positions","kind":13,"line":1103},{"line":1104,"kind":13,"name":"$self","containerName":"_calculate_seq_positions"},{"kind":13,"line":1104,"name":"$resCount_query","containerName":"_calculate_seq_positions"},{"name":"$qdir","containerName":"_calculate_seq_positions","line":1104,"kind":13},{"kind":13,"line":1104,"containerName":"_calculate_seq_positions","name":"@qrange"},{"kind":13,"line":1105,"name":"$self","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$resCount_sbjct","kind":13,"line":1105},{"line":1105,"kind":13,"name":"$sdir","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"@srange","kind":13,"line":1105},{"kind":13,"line":1106,"containerName":"_calculate_seq_positions","name":"$matchtype"},{"line":1107,"kind":13,"containerName":"_calculate_seq_positions","name":"$mchar"},{"name":"$qfs","containerName":"_calculate_seq_positions","line":1108,"kind":13},{"kind":13,"line":1108,"name":"$qchar","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$qchar","kind":13,"line":1109},{"kind":13,"line":1111,"name":"$sfs","containerName":"_calculate_seq_positions"},{"name":"$schar","containerName":"_calculate_seq_positions","line":1111,"kind":13},{"line":1112,"kind":13,"name":"$schar","containerName":"_calculate_seq_positions"},{"kind":13,"line":1114,"containerName":"_calculate_seq_positions","name":"$qfs"},{"line":1131,"kind":13,"name":"$self","containerName":"_calculate_seq_positions"},{"kind":13,"line":1131,"containerName":"_calculate_seq_positions","name":"$resCount_query"},{"kind":13,"line":1131,"containerName":"_calculate_seq_positions","name":"$qdir"},{"kind":13,"line":1131,"containerName":"_calculate_seq_positions","name":"$qfs"},{"containerName":"_calculate_seq_positions","name":"$qfs","kind":13,"line":1131},{"name":"@qrange","containerName":"_calculate_seq_positions","line":1131,"kind":13},{"line":1132,"kind":13,"name":"$matchtype","containerName":"_calculate_seq_positions"},{"name":"$sgap","containerName":"_calculate_seq_positions","line":1133,"kind":13},{"line":1133,"kind":13,"containerName":"_calculate_seq_positions","name":"$qgap"},{"kind":13,"line":1135,"name":"$sfs","containerName":"_calculate_seq_positions"},{"line":1136,"kind":13,"name":"$self","containerName":"_calculate_seq_positions"},{"line":1136,"kind":13,"containerName":"_calculate_seq_positions","name":"$resCount_sbjct"},{"kind":13,"line":1136,"name":"$sdir","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$sfs","line":1136,"kind":13},{"line":1136,"kind":13,"name":"$sfs","containerName":"_calculate_seq_positions"},{"line":1136,"kind":13,"containerName":"_calculate_seq_positions","name":"@srange"},{"name":"$matchtype","containerName":"_calculate_seq_positions","kind":13,"line":1137},{"containerName":"_calculate_seq_positions","name":"$sgap","line":1138,"kind":13},{"kind":13,"line":1138,"name":"$qgap","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$qchar","kind":13,"line":1140},{"kind":13,"line":1140,"name":"$self","containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","name":"$self","kind":13,"line":1144},{"name":"$resCount_query","containerName":"_calculate_seq_positions","kind":13,"line":1144},{"name":"$qdir","containerName":"_calculate_seq_positions","line":1144,"kind":13},{"name":"@qrange","containerName":"_calculate_seq_positions","line":1144,"kind":13},{"line":1145,"kind":13,"containerName":"_calculate_seq_positions","name":"$matchtype"},{"name":"$qgap","containerName":"_calculate_seq_positions","line":1146,"kind":13},{"name":"$schar","containerName":"_calculate_seq_positions","kind":13,"line":1148},{"name":"$self","containerName":"_calculate_seq_positions","line":1148,"kind":13},{"line":1149,"kind":13,"name":"$self","containerName":"_calculate_seq_positions"},{"kind":13,"line":1149,"containerName":"_calculate_seq_positions","name":"$resCount_sbjct"},{"line":1149,"kind":13,"name":"$sdir","containerName":"_calculate_seq_positions"},{"line":1149,"kind":13,"containerName":"_calculate_seq_positions","name":"@srange"},{"kind":13,"line":1150,"name":"$matchtype","containerName":"_calculate_seq_positions"},{"line":1151,"kind":13,"name":"$sgap","containerName":"_calculate_seq_positions"},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1155},{"containerName":"_calculate_seq_positions","name":"$resCount_query","kind":13,"line":1155},{"name":"$qdir","containerName":"_calculate_seq_positions","line":1155,"kind":13},{"containerName":"_calculate_seq_positions","name":"@qrange","kind":13,"line":1155},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1156},{"containerName":"_calculate_seq_positions","name":"$resCount_sbjct","line":1156,"kind":13},{"name":"$sdir","containerName":"_calculate_seq_positions","kind":13,"line":1156},{"kind":13,"line":1156,"name":"@srange","containerName":"_calculate_seq_positions"},{"kind":13,"line":1157,"name":"$matchtype","containerName":"_calculate_seq_positions"},{"line":1160,"kind":13,"name":"$sgap","containerName":"_calculate_seq_positions"},{"line":1161,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1161,"kind":13,"containerName":"_calculate_seq_positions","name":"$resCount_sbjct"},{"line":1161,"kind":13,"containerName":"_calculate_seq_positions","name":"$sdir"},{"line":1161,"kind":13,"containerName":"_calculate_seq_positions","name":"@srange"},{"name":"$qgap","containerName":"_calculate_seq_positions","line":1163,"kind":13},{"name":"$self","containerName":"_calculate_seq_positions","line":1164,"kind":13},{"kind":13,"line":1164,"name":"$resCount_query","containerName":"_calculate_seq_positions"},{"kind":13,"line":1164,"containerName":"_calculate_seq_positions","name":"$qdir"},{"line":1164,"kind":13,"containerName":"_calculate_seq_positions","name":"@qrange"},{"kind":13,"line":1167,"name":"$self","containerName":"_calculate_seq_positions"},{"name":"warn","containerName":"_calculate_seq_positions","kind":12,"line":1167},{"kind":13,"line":1179,"containerName":"_calculate_seq_positions","name":"$resCount_query"},{"kind":13,"line":1179,"name":"$qdir","containerName":"_calculate_seq_positions"},{"kind":13,"line":1179,"containerName":"_calculate_seq_positions","name":"@qrange"},{"name":"$qfs","containerName":"_calculate_seq_positions","kind":13,"line":1179},{"line":1179,"kind":13,"name":"$qgap","containerName":"_calculate_seq_positions"},{"name":"$resCount_sbjct","containerName":"_calculate_seq_positions","line":1180,"kind":13},{"name":"$sdir","containerName":"_calculate_seq_positions","kind":13,"line":1180},{"containerName":"_calculate_seq_positions","name":"@srange","line":1180,"kind":13},{"kind":13,"line":1180,"containerName":"_calculate_seq_positions","name":"$sfs"},{"kind":13,"line":1180,"name":"$sgap","containerName":"_calculate_seq_positions"}],"name":"_calculate_seq_positions","range":{"start":{"character":0,"line":1019},"end":{"line":1183,"character":9999}}},{"name":"CORE","containerName":"length","kind":12,"line":1026},{"name":"CORE","containerName":"length","kind":12,"line":1026},{"name":"CORE","containerName":"length","kind":12,"line":1026},{"containerName":"length","name":"CORE","line":1045,"kind":12},{"kind":12,"line":1045,"name":"CORE","containerName":"length"},{"name":"seqinds","line":1071,"kind":12},{"name":"_sbjct_offset","kind":12,"line":1072},{"name":"_query_offset","kind":12,"line":1072},{"kind":12,"line":1074,"name":"_sbjct_offset"},{"name":"_query_offset","line":1076,"kind":12},{"name":"seqinds","kind":12,"line":1077},{"name":"seqinds","kind":12,"line":1079},{"line":1082,"kind":12,"name":"_query_offset"},{"name":"seqinds","line":1083,"kind":12},{"name":"CHAR_LOOP","line":1086,"kind":12},{"name":"CORE","containerName":"length","line":1087,"kind":12},{"kind":12,"line":1088,"name":"_query_offset"},{"kind":12,"line":1089,"name":"_sbjct_offset"},{"name":"CORE","containerName":"length","line":1094,"kind":12},{"name":"CORE","containerName":"length","kind":12,"line":1095},{"name":"seqinds","line":1100,"kind":12},{"kind":12,"line":1100,"name":"_conservedRes_query"},{"name":"seqinds","kind":12,"line":1101},{"name":"_conservedRes_sbjct","kind":12,"line":1101},{"name":"seqinds","line":1104,"kind":12},{"line":1104,"kind":12,"name":"_identicalRes_query"},{"name":"seqinds","line":1105,"kind":12},{"name":"_identicalRes_sbjct","line":1105,"kind":12},{"name":"seqinds","line":1131,"kind":12},{"name":"_frameshiftRes_query","line":1131,"kind":12},{"kind":12,"line":1136,"name":"seqinds"},{"line":1136,"kind":12,"name":"_frameshiftRes_sbjct"},{"kind":12,"line":1140,"name":"GAP_SYMBOL"},{"line":1144,"kind":12,"name":"seqinds"},{"kind":12,"line":1144,"name":"_gapRes_query"},{"line":1148,"kind":12,"name":"GAP_SYMBOL"},{"name":"seqinds","line":1149,"kind":12},{"name":"_gapRes_sbjct","kind":12,"line":1149},{"line":1155,"kind":12,"name":"seqinds"},{"line":1155,"kind":12,"name":"_mismatchRes_query"},{"kind":12,"line":1156,"name":"seqinds"},{"name":"_mismatchRes_sbjct","kind":12,"line":1156},{"line":1161,"kind":12,"name":"seqinds"},{"kind":12,"line":1161,"name":"_nomatchRes_sbjct"},{"name":"seqinds","kind":12,"line":1164},{"line":1164,"kind":12,"name":"_nomatchRes_query"},{"containerName":"main::","name":"n","definition":"sub","range":{"start":{"character":0,"line":1191},"end":{"character":9999,"line":1195}},"kind":12,"line":1191,"children":[{"kind":13,"line":1192,"name":"$self","definition":"my","containerName":"n","localvar":"my"},{"line":1193,"kind":13,"containerName":"n","name":"$self"},{"kind":13,"line":1194,"containerName":"n","name":"$self"},{"kind":13,"line":1194,"name":"$self","containerName":"n"}]},{"kind":12,"line":1203,"children":[{"name":"$self","definition":"my","containerName":"range","localvar":"my","kind":13,"line":1204},{"containerName":"range","name":"$seqType","kind":13,"line":1204},{"line":1206,"kind":13,"containerName":"range","name":"$seqType"},{"containerName":"range","name":"$seqType","kind":13,"line":1207},{"kind":13,"line":1207,"name":"$seqType","containerName":"range"},{"localvar":"my","containerName":"range","definition":"my","name":"$start","line":1209,"kind":13},{"containerName":"range","name":"$end","line":1209,"kind":13},{"name":"$seqType","containerName":"range","line":1210,"kind":13},{"containerName":"range","name":"$start","line":1211,"kind":13},{"containerName":"range","name":"$self","kind":13,"line":1211},{"kind":12,"line":1211,"name":"query","containerName":"range"},{"line":1211,"kind":12,"name":"start","containerName":"range"},{"name":"$end","containerName":"range","line":1212,"kind":13},{"line":1212,"kind":13,"containerName":"range","name":"$self"},{"containerName":"range","name":"query","kind":12,"line":1212},{"kind":12,"line":1212,"containerName":"range","name":"end"},{"line":1215,"kind":13,"name":"$start","containerName":"range"},{"name":"$self","containerName":"range","line":1215,"kind":13},{"line":1215,"kind":12,"containerName":"range","name":"hit"},{"kind":12,"line":1215,"containerName":"range","name":"start"},{"containerName":"range","name":"$end","kind":13,"line":1216},{"line":1216,"kind":13,"containerName":"range","name":"$self"},{"name":"hit","containerName":"range","kind":12,"line":1216},{"kind":12,"line":1216,"containerName":"range","name":"end"},{"name":"$start","containerName":"range","line":1218,"kind":13},{"kind":13,"line":1218,"containerName":"range","name":"$end"}],"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"range($self,$seqType)","documentation":"","parameters":[{"label":"$self"},{"label":"$seqType"}]},"name":"range","range":{"start":{"character":0,"line":1203},"end":{"character":9999,"line":1219}}},{"definition":"sub","name":"links","containerName":"main::","range":{"end":{"character":9999,"line":1239},"start":{"line":1234,"character":0}},"kind":12,"children":[{"containerName":"links","name":"$self","definition":"my","localvar":"my","kind":13,"line":1235},{"containerName":"links","name":"$self","kind":13,"line":1237},{"line":1238,"kind":13,"name":"$self","containerName":"links"}],"line":1234},{"line":1237,"kind":12,"name":"LINKS"},{"name":"LINKS","kind":12,"line":1238},{"range":{"start":{"character":0,"line":1253},"end":{"line":1258,"character":9999}},"containerName":"main::","definition":"sub","name":"hsp_group","line":1253,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hsp_group","line":1254,"kind":13},{"name":"$self","containerName":"hsp_group","kind":13,"line":1256},{"line":1257,"kind":13,"name":"$self","containerName":"hsp_group"}],"kind":12},{"line":1256,"kind":12,"name":"HSP_GROUP"},{"name":"HSP_GROUP","line":1257,"kind":12},{"line":1273,"children":[{"kind":13,"line":1274,"definition":"my","name":"$self","containerName":"hit_features","localvar":"my"},{"kind":13,"line":1276,"containerName":"hit_features","name":"$self"},{"containerName":"hit_features","name":"$self","kind":13,"line":1277}],"kind":12,"range":{"start":{"character":0,"line":1273},"end":{"line":1278,"character":9999}},"containerName":"main::","definition":"sub","name":"hit_features"},{"line":1276,"kind":12,"name":"HIT_FEATURES"},{"kind":12,"line":1277,"name":"HIT_FEATURES"},{"range":{"start":{"line":1330,"character":0},"end":{"line":1340,"character":9999}},"name":"cigar_string","detail":"($self,$arg)","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"","label":"cigar_string($self,$arg)"},"containerName":"main::","definition":"sub","line":1330,"children":[{"containerName":"cigar_string","name":"$self","definition":"my","localvar":"my","kind":13,"line":1331},{"containerName":"cigar_string","name":"$arg","line":1331,"kind":13},{"name":"$self","containerName":"cigar_string","line":1332,"kind":13},{"containerName":"cigar_string","name":"warn","line":1332,"kind":12},{"line":1332,"kind":13,"name":"$arg","containerName":"cigar_string"},{"line":1334,"kind":13,"containerName":"cigar_string","name":"$self"},{"localvar":"my","containerName":"cigar_string","definition":"my","name":"$cigar_string","line":1335,"kind":13},{"kind":13,"line":1335,"name":"$self","containerName":"cigar_string"},{"containerName":"cigar_string","name":"generate_cigar_string","kind":12,"line":1335},{"name":"$self","containerName":"cigar_string","kind":13,"line":1335},{"name":"query_string","containerName":"cigar_string","line":1335,"kind":12},{"kind":13,"line":1335,"name":"$self","containerName":"cigar_string"},{"name":"hit_string","containerName":"cigar_string","kind":12,"line":1335},{"line":1336,"kind":13,"containerName":"cigar_string","name":"$self"},{"kind":13,"line":1336,"containerName":"cigar_string","name":"$cigar_string"},{"kind":13,"line":1339,"name":"$self","containerName":"cigar_string"}],"kind":12},{"name":"_cigar_string","line":1334,"kind":12},{"name":"_cigar_string","line":1336,"kind":12},{"line":1339,"kind":12,"name":"_cigar_string"},{"detail":"($self,$qstr,$hstr)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$qstr"},{"label":"$hstr"}],"label":"generate_cigar_string($self,$qstr,$hstr)"},"containerName":"main::","definition":"sub","line":1352,"children":[{"kind":13,"line":1353,"name":"$self","definition":"my","containerName":"generate_cigar_string","localvar":"my"},{"line":1353,"kind":13,"name":"$qstr","containerName":"generate_cigar_string"},{"line":1353,"kind":13,"containerName":"generate_cigar_string","name":"$hstr"},{"containerName":"generate_cigar_string","definition":"my","name":"@qchars","localvar":"my","kind":13,"line":1354},{"kind":13,"line":1354,"containerName":"generate_cigar_string","name":"$qstr"},{"localvar":"my","name":"@hchars","definition":"my","containerName":"generate_cigar_string","line":1355,"kind":13},{"line":1355,"kind":13,"containerName":"generate_cigar_string","name":"$hstr"},{"line":1357,"kind":13,"name":"@qchars","containerName":"generate_cigar_string"},{"line":1357,"kind":13,"name":"@hchars","containerName":"generate_cigar_string"},{"name":"$self","containerName":"generate_cigar_string","kind":13,"line":1358},{"kind":12,"line":1358,"name":"throw","containerName":"generate_cigar_string"},{"name":"$self","containerName":"generate_cigar_string","line":1361,"kind":13},{"line":1362,"kind":13,"containerName":"generate_cigar_string","name":"$self"},{"kind":13,"line":1364,"containerName":"generate_cigar_string","definition":"my","name":"$cigar_string","localvar":"my"},{"line":1365,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"generate_cigar_string"},{"line":1365,"kind":13,"containerName":"generate_cigar_string","name":"$i"},{"containerName":"generate_cigar_string","name":"$i","line":1365,"kind":13},{"kind":13,"line":1366,"definition":"my","name":"$qchar","containerName":"generate_cigar_string","localvar":"my"},{"containerName":"generate_cigar_string","name":"$qchars","line":1366,"kind":13},{"kind":13,"line":1366,"name":"$i","containerName":"generate_cigar_string"},{"containerName":"generate_cigar_string","name":"$hchar","definition":"my","localvar":"my","kind":13,"line":1367},{"line":1367,"kind":13,"containerName":"generate_cigar_string","name":"$hchars"},{"containerName":"generate_cigar_string","name":"$i","line":1367,"kind":13},{"kind":13,"line":1368,"name":"$qchar","containerName":"generate_cigar_string"},{"kind":13,"line":1368,"name":"$self","containerName":"generate_cigar_string"},{"line":1368,"kind":13,"containerName":"generate_cigar_string","name":"$hchar"},{"containerName":"generate_cigar_string","name":"$self","kind":13,"line":1368},{"name":"$cigar_string","containerName":"generate_cigar_string","line":1369,"kind":13},{"containerName":"generate_cigar_string","name":"$self","kind":13,"line":1369},{"containerName":"generate_cigar_string","name":"_sub_cigar_string","line":1369,"kind":12},{"name":"$qchar","containerName":"generate_cigar_string","line":1370,"kind":13},{"containerName":"generate_cigar_string","name":"$self","line":1370,"kind":13},{"kind":13,"line":1371,"containerName":"generate_cigar_string","name":"$cigar_string"},{"containerName":"generate_cigar_string","name":"$self","line":1371,"kind":13},{"line":1371,"kind":12,"name":"_sub_cigar_string","containerName":"generate_cigar_string"},{"containerName":"generate_cigar_string","name":"$hchar","line":1372,"kind":13},{"line":1372,"kind":13,"name":"$self","containerName":"generate_cigar_string"},{"line":1373,"kind":13,"name":"$cigar_string","containerName":"generate_cigar_string"},{"line":1373,"kind":13,"containerName":"generate_cigar_string","name":"$self"},{"line":1373,"kind":12,"name":"_sub_cigar_string","containerName":"generate_cigar_string"},{"containerName":"generate_cigar_string","name":"$self","line":1375,"kind":13},{"kind":12,"line":1375,"name":"throw","containerName":"generate_cigar_string"},{"kind":13,"line":1378,"name":"$cigar_string","containerName":"generate_cigar_string"},{"kind":13,"line":1378,"containerName":"generate_cigar_string","name":"$self"},{"kind":12,"line":1378,"name":"_sub_cigar_string","containerName":"generate_cigar_string"},{"line":1379,"kind":13,"name":"$cigar_string","containerName":"generate_cigar_string"}],"kind":12,"range":{"start":{"character":0,"line":1352},"end":{"character":9999,"line":1380}},"name":"generate_cigar_string"},{"line":1361,"kind":12,"name":"_count_for_cigar_string"},{"line":1362,"kind":12,"name":"_state_for_cigar_string"},{"name":"qchars","line":1365,"kind":12},{"name":"GAP_SYMBOL","kind":12,"line":1368},{"kind":12,"line":1368,"name":"GAP_SYMBOL"},{"line":1370,"kind":12,"name":"GAP_SYMBOL"},{"line":1372,"kind":12,"name":"GAP_SYMBOL"},{"name":"_sub_cigar_string","range":{"start":{"line":1384,"character":0},"end":{"line":1398,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$new_state)","signature":{"label":"_sub_cigar_string($self,$new_state)","documentation":"","parameters":[{"label":"$self"},{"label":"$new_state"}]},"kind":12,"line":1384,"children":[{"localvar":"my","containerName":"_sub_cigar_string","definition":"my","name":"$self","line":1385,"kind":13},{"containerName":"_sub_cigar_string","name":"$new_state","kind":13,"line":1385},{"localvar":"my","definition":"my","name":"$sub_cigar_string","containerName":"_sub_cigar_string","line":1387,"kind":13},{"name":"$self","containerName":"_sub_cigar_string","kind":13,"line":1388},{"containerName":"_sub_cigar_string","name":"$new_state","line":1388,"kind":13},{"line":1389,"kind":13,"containerName":"_sub_cigar_string","name":"$self"},{"containerName":"_sub_cigar_string","name":"$sub_cigar_string","line":1391,"kind":13},{"line":1391,"kind":13,"name":"$self","containerName":"_sub_cigar_string"},{"containerName":"_sub_cigar_string","name":"$self","line":1392,"kind":13},{"name":"$sub_cigar_string","containerName":"_sub_cigar_string","line":1393,"kind":13},{"containerName":"_sub_cigar_string","name":"$self","line":1393,"kind":13},{"containerName":"_sub_cigar_string","name":"$self","kind":13,"line":1394},{"containerName":"_sub_cigar_string","name":"$self","line":1395,"kind":13},{"containerName":"_sub_cigar_string","name":"$new_state","line":1395,"kind":13},{"kind":13,"line":1397,"containerName":"_sub_cigar_string","name":"$sub_cigar_string"}]},{"line":1388,"kind":12,"name":"_state_for_cigar_string"},{"name":"_count_for_cigar_string","kind":12,"line":1389},{"name":"_count_for_cigar_string","kind":12,"line":1391},{"kind":12,"line":1392,"name":"_count_for_cigar_string"},{"name":"_state_for_cigar_string","line":1393,"kind":12},{"name":"_count_for_cigar_string","kind":12,"line":1394},{"kind":12,"line":1395,"name":"_state_for_cigar_string"},{"children":[{"line":1402,"kind":13,"localvar":"my","containerName":"_pre_seq_feature","definition":"my","name":"$self"},{"line":1403,"kind":13,"localvar":"my","containerName":"_pre_seq_feature","definition":"my","name":"$algo"},{"containerName":"_pre_seq_feature","name":"$self","line":1403,"kind":13},{"line":1405,"kind":13,"localvar":"my","containerName":"_pre_seq_feature","definition":"my","name":"$queryfactor"},{"line":1405,"kind":13,"containerName":"_pre_seq_feature","name":"$hitfactor"},{"name":"$hitmap","definition":"my","containerName":"_pre_seq_feature","localvar":"my","kind":13,"line":1406},{"name":"$querymap","containerName":"_pre_seq_feature","kind":13,"line":1406},{"containerName":"_pre_seq_feature","name":"$algo","line":1407,"kind":13},{"kind":13,"line":1408,"name":"$hitfactor","containerName":"_pre_seq_feature"},{"kind":13,"line":1409,"name":"$hitmap","containerName":"_pre_seq_feature"},{"line":1411,"kind":13,"name":"$algo","containerName":"_pre_seq_feature"},{"containerName":"_pre_seq_feature","name":"$algo","kind":13,"line":1411},{"containerName":"_pre_seq_feature","name":"$queryfactor","line":1412,"kind":13},{"name":"$querymap","containerName":"_pre_seq_feature","line":1413,"kind":13},{"name":"$algo","containerName":"_pre_seq_feature","kind":13,"line":1415},{"name":"$algo","containerName":"_pre_seq_feature","kind":13,"line":1415},{"line":1415,"kind":13,"containerName":"_pre_seq_feature","name":"$algo"},{"name":"$hitmap","containerName":"_pre_seq_feature","line":1417,"kind":13},{"kind":13,"line":1417,"containerName":"_pre_seq_feature","name":"$querymap"},{"kind":13,"line":1419,"name":"$hitfactor","containerName":"_pre_seq_feature"},{"name":"$queryfactor","containerName":"_pre_seq_feature","kind":13,"line":1420},{"line":1422,"kind":13,"name":"$algo","containerName":"_pre_seq_feature"},{"line":1423,"kind":13,"containerName":"_pre_seq_feature","name":"$algo"},{"containerName":"_pre_seq_feature","name":"$queryfactor","line":1424,"kind":13},{"containerName":"_pre_seq_feature","name":"$querymap","kind":13,"line":1425},{"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13,"line":1427},{"containerName":"_pre_seq_feature","definition":"my","name":"$stranded","localvar":"my","kind":13,"line":1430},{"name":"$self","containerName":"_pre_seq_feature","kind":13,"line":1430},{"line":1431,"kind":13,"containerName":"_pre_seq_feature","name":"$queryfactor"},{"kind":13,"line":1431,"name":"$stranded","containerName":"_pre_seq_feature"},{"line":1431,"kind":13,"name":"$stranded","containerName":"_pre_seq_feature"},{"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13,"line":1432},{"name":"$stranded","containerName":"_pre_seq_feature","line":1432,"kind":13},{"containerName":"_pre_seq_feature","name":"$stranded","kind":13,"line":1432},{"kind":13,"line":1432,"name":"$stranded","containerName":"_pre_seq_feature"},{"containerName":"_pre_seq_feature","name":"$self","line":1434,"kind":13},{"name":"$queryfactor","containerName":"_pre_seq_feature","kind":13,"line":1434},{"containerName":"_pre_seq_feature","name":"$self","kind":13,"line":1435},{"containerName":"_pre_seq_feature","name":"$hitfactor","line":1435,"kind":13},{"name":"$self","containerName":"_pre_seq_feature","kind":13,"line":1436},{"kind":13,"line":1436,"name":"$hitmap","containerName":"_pre_seq_feature"},{"name":"$self","containerName":"_pre_seq_feature","line":1437,"kind":13},{"name":"$querymap","containerName":"_pre_seq_feature","kind":13,"line":1437}],"line":1401,"kind":12,"range":{"end":{"character":9999,"line":1438},"start":{"character":0,"line":1401}},"name":"_pre_seq_feature","definition":"sub","containerName":"main::"},{"name":"ALGORITHM","kind":12,"line":1403},{"line":1430,"kind":12,"name":"STRANDED"},{"line":1434,"kind":12,"name":"_query_factor"},{"name":"_hit_factor","line":1435,"kind":12},{"kind":12,"line":1436,"name":"_hit_mapping"},{"name":"_query_mapping","line":1437,"kind":12},{"range":{"start":{"line":1441,"character":0},"end":{"line":1516,"character":9999}},"definition":"sub","name":"_query_seq_feature","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_query_seq_feature","line":1442,"kind":13},{"name":"$self","containerName":"_query_seq_feature","line":1443,"kind":13},{"definition":"my","name":"$qs","containerName":"_query_seq_feature","localvar":"my","kind":13,"line":1444},{"line":1444,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"kind":13,"line":1445,"definition":"my","name":"$qe","containerName":"_query_seq_feature","localvar":"my"},{"containerName":"_query_seq_feature","name":"$self","line":1445,"kind":13},{"containerName":"_query_seq_feature","name":"$self","kind":13,"line":1446},{"line":1447,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"kind":12,"line":1447,"name":"_pre_seq_feature","containerName":"_query_seq_feature"},{"line":1449,"kind":13,"localvar":"my","definition":"my","name":"$queryfactor","containerName":"_query_seq_feature"},{"kind":13,"line":1449,"containerName":"_query_seq_feature","name":"$self"},{"line":1451,"kind":13,"containerName":"_query_seq_feature","name":"$qe"},{"name":"$qs","containerName":"_query_seq_feature","line":1451,"kind":13},{"name":"$self","containerName":"_query_seq_feature","line":1451,"kind":13},{"kind":12,"line":1451,"containerName":"_query_seq_feature","name":"throw"},{"line":1453,"kind":13,"localvar":"my","definition":"my","name":"$strand","containerName":"_query_seq_feature"},{"kind":13,"line":1454,"name":"$qe","containerName":"_query_seq_feature"},{"line":1454,"kind":13,"containerName":"_query_seq_feature","name":"$qs"},{"containerName":"_query_seq_feature","name":"$queryfactor","kind":13,"line":1455},{"line":1456,"kind":13,"name":"$strand","containerName":"_query_seq_feature"},{"containerName":"_query_seq_feature","name":"$strand","kind":13,"line":1459},{"kind":13,"line":1463,"containerName":"_query_seq_feature","name":"$queryfactor"},{"containerName":"_query_seq_feature","name":"$strand","kind":13,"line":1464},{"name":"$strand","containerName":"_query_seq_feature","kind":13,"line":1467},{"line":1469,"kind":13,"name":"$qs","containerName":"_query_seq_feature"},{"line":1469,"kind":13,"name":"$qe","containerName":"_query_seq_feature"},{"containerName":"_query_seq_feature","name":"$qe","line":1469,"kind":13},{"name":"$qs","containerName":"_query_seq_feature","line":1469,"kind":13},{"line":1477,"kind":13,"localvar":"my","containerName":"_query_seq_feature","definition":"my","name":"$sim1"},{"kind":13,"line":1477,"name":"$self","containerName":"_query_seq_feature"},{"kind":12,"line":1477,"name":"new","containerName":"_query_seq_feature"},{"containerName":"_query_seq_feature","name":"$sim1","kind":13,"line":1478},{"containerName":"_query_seq_feature","name":"start","line":1478,"kind":12},{"line":1478,"kind":13,"name":"$qs","containerName":"_query_seq_feature"},{"name":"$sim1","containerName":"_query_seq_feature","kind":13,"line":1479},{"name":"end","containerName":"_query_seq_feature","line":1479,"kind":12},{"containerName":"_query_seq_feature","name":"$qe","kind":13,"line":1479},{"containerName":"_query_seq_feature","name":"$sim1","line":1480,"kind":13},{"kind":12,"line":1480,"name":"significance","containerName":"_query_seq_feature"},{"line":1480,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"containerName":"_query_seq_feature","name":"$sim1","line":1481,"kind":13},{"name":"bits","containerName":"_query_seq_feature","line":1481,"kind":12},{"containerName":"_query_seq_feature","name":"$self","line":1481,"kind":13},{"line":1482,"kind":13,"containerName":"_query_seq_feature","name":"$sim1"},{"kind":12,"line":1482,"containerName":"_query_seq_feature","name":"score"},{"name":"$self","containerName":"_query_seq_feature","kind":13,"line":1482},{"containerName":"_query_seq_feature","name":"$sim1","kind":13,"line":1483},{"kind":12,"line":1483,"name":"strand","containerName":"_query_seq_feature"},{"kind":13,"line":1483,"containerName":"_query_seq_feature","name":"$strand"},{"line":1484,"kind":13,"containerName":"_query_seq_feature","name":"$sim1"},{"name":"seq_id","containerName":"_query_seq_feature","line":1484,"kind":12},{"name":"$self","containerName":"_query_seq_feature","line":1484,"kind":13},{"containerName":"_query_seq_feature","name":"$sim1","line":1485,"kind":13},{"containerName":"_query_seq_feature","name":"seqlength","line":1485,"kind":12},{"name":"$self","containerName":"_query_seq_feature","line":1485,"kind":13},{"name":"$sim1","containerName":"_query_seq_feature","kind":13,"line":1486},{"containerName":"_query_seq_feature","name":"source_tag","kind":12,"line":1486},{"line":1486,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"kind":13,"line":1487,"containerName":"_query_seq_feature","name":"$sim1"},{"line":1487,"kind":12,"containerName":"_query_seq_feature","name":"seqdesc"},{"kind":13,"line":1487,"containerName":"_query_seq_feature","name":"$self"},{"name":"$sim1","containerName":"_query_seq_feature","line":1488,"kind":13},{"name":"add_tag_value","containerName":"_query_seq_feature","kind":12,"line":1488},{"line":1488,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"line":1488,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"kind":12,"line":1488,"containerName":"_query_seq_feature","name":"can"},{"localvar":"my","name":"$qframe","definition":"my","containerName":"_query_seq_feature","line":1491,"kind":13},{"containerName":"_query_seq_feature","name":"$self","kind":13,"line":1491},{"containerName":"_query_seq_feature","name":"$strand","line":1493,"kind":13},{"line":1493,"kind":13,"containerName":"_query_seq_feature","name":"$qframe"},{"containerName":"_query_seq_feature","name":"$queryfactor","kind":13,"line":1493},{"name":"$qframe","containerName":"_query_seq_feature","kind":13,"line":1494},{"kind":13,"line":1494,"containerName":"_query_seq_feature","name":"$qs"},{"containerName":"_query_seq_feature","name":"$strand","kind":13,"line":1494},{"kind":13,"line":1496,"name":"$strand","containerName":"_query_seq_feature"},{"line":1497,"kind":13,"name":"$qframe","containerName":"_query_seq_feature"},{"kind":13,"line":1500,"containerName":"_query_seq_feature","name":"$qframe"},{"containerName":"_query_seq_feature","definition":"my","name":"$dir","localvar":"my","kind":13,"line":1501},{"kind":13,"line":1502,"name":"$qframe","containerName":"_query_seq_feature"},{"name":"$dir","containerName":"_query_seq_feature","kind":13,"line":1502},{"name":"$strand","containerName":"_query_seq_feature","line":1502,"kind":13},{"kind":13,"line":1502,"name":"$dir","containerName":"_query_seq_feature"},{"kind":13,"line":1502,"containerName":"_query_seq_feature","name":"$strand"},{"name":"$self","containerName":"_query_seq_feature","line":1503,"kind":13},{"line":1503,"kind":12,"name":"warn","containerName":"_query_seq_feature"},{"containerName":"_query_seq_feature","name":"$qframe","kind":13,"line":1505},{"name":"$self","containerName":"_query_seq_feature","kind":13,"line":1507},{"name":"warn","containerName":"_query_seq_feature","kind":12,"line":1507},{"name":"$qframe","containerName":"_query_seq_feature","line":1508,"kind":13},{"line":1511,"kind":13,"containerName":"_query_seq_feature","name":"$sim1"},{"name":"frame","containerName":"_query_seq_feature","kind":12,"line":1511},{"containerName":"_query_seq_feature","name":"$qframe","kind":13,"line":1511},{"name":"$self","containerName":"_query_seq_feature","line":1512,"kind":13},{"name":"$sim1","containerName":"_query_seq_feature","line":1512,"kind":13},{"containerName":"_query_seq_feature","name":"$self","kind":13,"line":1514},{"line":1515,"kind":13,"containerName":"_query_seq_feature","name":"$self"}],"line":1441,"kind":12},{"line":1443,"kind":12,"name":"_making_qff"},{"line":1444,"kind":12,"name":"QUERY_START"},{"line":1445,"kind":12,"name":"QUERY_END"},{"name":"_query_factor","kind":12,"line":1446},{"kind":12,"line":1449,"name":"_query_factor"},{"name":"_sim1","line":1477,"kind":12},{"kind":12,"line":1477,"containerName":"SeqFeature::Similarity","name":"Bio"},{"kind":12,"line":1480,"name":"EVALUE"},{"kind":12,"line":1481,"name":"BITS"},{"name":"SCORE","line":1482,"kind":12},{"name":"QUERY_NAME","line":1484,"kind":12},{"name":"QUERY_LENGTH","kind":12,"line":1485},{"name":"ALGORITHM","kind":12,"line":1486},{"name":"QUERY_DESC","line":1487,"kind":12},{"line":1488,"kind":12,"name":"META"},{"kind":12,"line":1491,"name":"QUERY_FRAME"},{"containerName":"feature1","name":"SUPER","line":1512,"kind":12},{"line":1514,"kind":12,"name":"_created_qff"},{"line":1515,"kind":12,"name":"_making_qff"},{"containerName":"main::","definition":"sub","name":"_subject_seq_feature","range":{"end":{"line":1587,"character":9999},"start":{"line":1519,"character":0}},"kind":12,"line":1519,"children":[{"line":1520,"kind":13,"localvar":"my","containerName":"_subject_seq_feature","definition":"my","name":"$self"},{"line":1521,"kind":13,"name":"$self","containerName":"_subject_seq_feature"},{"kind":13,"line":1522,"definition":"my","name":"$hs","containerName":"_subject_seq_feature","localvar":"my"},{"kind":13,"line":1522,"containerName":"_subject_seq_feature","name":"$self"},{"localvar":"my","definition":"my","name":"$he","containerName":"_subject_seq_feature","line":1523,"kind":13},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1523},{"kind":13,"line":1524,"name":"$self","containerName":"_subject_seq_feature"},{"containerName":"_subject_seq_feature","name":"$self","line":1525,"kind":13},{"line":1525,"kind":12,"name":"_pre_seq_feature","containerName":"_subject_seq_feature"},{"kind":13,"line":1527,"containerName":"_subject_seq_feature","name":"$hitfactor","definition":"my","localvar":"my"},{"line":1527,"kind":13,"name":"$self","containerName":"_subject_seq_feature"},{"line":1529,"kind":13,"containerName":"_subject_seq_feature","name":"$he"},{"containerName":"_subject_seq_feature","name":"$hs","line":1529,"kind":13},{"kind":13,"line":1529,"name":"$self","containerName":"_subject_seq_feature"},{"containerName":"_subject_seq_feature","name":"throw","kind":12,"line":1529},{"line":1531,"kind":13,"localvar":"my","containerName":"_subject_seq_feature","name":"$strand","definition":"my"},{"line":1532,"kind":13,"name":"$he","containerName":"_subject_seq_feature"},{"line":1532,"kind":13,"name":"$hs","containerName":"_subject_seq_feature"},{"kind":13,"line":1533,"containerName":"_subject_seq_feature","name":"$hitfactor"},{"containerName":"_subject_seq_feature","name":"$strand","kind":13,"line":1534},{"name":"$strand","containerName":"_subject_seq_feature","kind":13,"line":1537},{"name":"$hitfactor","containerName":"_subject_seq_feature","line":1541,"kind":13},{"line":1542,"kind":13,"name":"$strand","containerName":"_subject_seq_feature"},{"line":1545,"kind":13,"containerName":"_subject_seq_feature","name":"$strand"},{"kind":13,"line":1547,"name":"$hs","containerName":"_subject_seq_feature"},{"name":"$he","containerName":"_subject_seq_feature","kind":13,"line":1547},{"name":"$he","containerName":"_subject_seq_feature","line":1547,"kind":13},{"containerName":"_subject_seq_feature","name":"$hs","line":1547,"kind":13},{"definition":"my","name":"$sim2","containerName":"_subject_seq_feature","localvar":"my","kind":13,"line":1550},{"kind":13,"line":1550,"containerName":"_subject_seq_feature","name":"$self"},{"name":"new","containerName":"_subject_seq_feature","line":1550,"kind":12},{"containerName":"_subject_seq_feature","name":"$sim2","line":1551,"kind":13},{"name":"start","containerName":"_subject_seq_feature","line":1551,"kind":12},{"kind":13,"line":1551,"name":"$hs","containerName":"_subject_seq_feature"},{"line":1552,"kind":13,"name":"$sim2","containerName":"_subject_seq_feature"},{"name":"end","containerName":"_subject_seq_feature","line":1552,"kind":12},{"kind":13,"line":1552,"containerName":"_subject_seq_feature","name":"$he"},{"containerName":"_subject_seq_feature","name":"$sim2","kind":13,"line":1553},{"line":1553,"kind":12,"containerName":"_subject_seq_feature","name":"significance"},{"kind":13,"line":1553,"name":"$self","containerName":"_subject_seq_feature"},{"kind":13,"line":1554,"containerName":"_subject_seq_feature","name":"$sim2"},{"containerName":"_subject_seq_feature","name":"bits","line":1554,"kind":12},{"line":1554,"kind":13,"containerName":"_subject_seq_feature","name":"$self"},{"kind":13,"line":1555,"name":"$sim2","containerName":"_subject_seq_feature"},{"line":1555,"kind":12,"name":"score","containerName":"_subject_seq_feature"},{"line":1555,"kind":13,"name":"$self","containerName":"_subject_seq_feature"},{"kind":13,"line":1556,"name":"$sim2","containerName":"_subject_seq_feature"},{"containerName":"_subject_seq_feature","name":"strand","line":1556,"kind":12},{"containerName":"_subject_seq_feature","name":"$strand","line":1556,"kind":13},{"containerName":"_subject_seq_feature","name":"$sim2","kind":13,"line":1557},{"containerName":"_subject_seq_feature","name":"seq_id","kind":12,"line":1557},{"kind":13,"line":1557,"name":"$self","containerName":"_subject_seq_feature"},{"name":"$sim2","containerName":"_subject_seq_feature","line":1558,"kind":13},{"containerName":"_subject_seq_feature","name":"seqlength","kind":12,"line":1558},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1558},{"line":1559,"kind":13,"containerName":"_subject_seq_feature","name":"$sim2"},{"containerName":"_subject_seq_feature","name":"source_tag","line":1559,"kind":12},{"containerName":"_subject_seq_feature","name":"$self","kind":13,"line":1559},{"line":1560,"kind":13,"containerName":"_subject_seq_feature","name":"$sim2"},{"containerName":"_subject_seq_feature","name":"seqdesc","line":1560,"kind":12},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1560},{"containerName":"_subject_seq_feature","name":"$sim2","line":1561,"kind":13},{"containerName":"_subject_seq_feature","name":"add_tag_value","line":1561,"kind":12},{"line":1561,"kind":13,"name":"$self","containerName":"_subject_seq_feature"},{"kind":13,"line":1561,"name":"$self","containerName":"_subject_seq_feature"},{"line":1561,"kind":12,"name":"can","containerName":"_subject_seq_feature"},{"containerName":"_subject_seq_feature","definition":"my","name":"$hframe","localvar":"my","kind":13,"line":1562},{"containerName":"_subject_seq_feature","name":"$self","line":1562,"kind":13},{"containerName":"_subject_seq_feature","name":"$strand","kind":13,"line":1564},{"kind":13,"line":1564,"name":"$hframe","containerName":"_subject_seq_feature"},{"kind":13,"line":1564,"name":"$hitfactor","containerName":"_subject_seq_feature"},{"name":"$hframe","containerName":"_subject_seq_feature","line":1565,"kind":13},{"kind":13,"line":1565,"containerName":"_subject_seq_feature","name":"$hs"},{"name":"$strand","containerName":"_subject_seq_feature","line":1565,"kind":13},{"line":1567,"kind":13,"containerName":"_subject_seq_feature","name":"$strand"},{"kind":13,"line":1568,"containerName":"_subject_seq_feature","name":"$hframe"},{"containerName":"_subject_seq_feature","name":"$hframe","line":1571,"kind":13},{"localvar":"my","containerName":"_subject_seq_feature","name":"$dir","definition":"my","line":1572,"kind":13},{"containerName":"_subject_seq_feature","name":"$hframe","kind":13,"line":1573},{"containerName":"_subject_seq_feature","name":"$dir","line":1573,"kind":13},{"line":1573,"kind":13,"name":"$strand","containerName":"_subject_seq_feature"},{"name":"$dir","containerName":"_subject_seq_feature","kind":13,"line":1573},{"line":1573,"kind":13,"name":"$strand","containerName":"_subject_seq_feature"},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1574},{"containerName":"_subject_seq_feature","name":"warn","line":1574,"kind":12},{"kind":13,"line":1576,"containerName":"_subject_seq_feature","name":"$hframe"},{"containerName":"_subject_seq_feature","name":"$self","kind":13,"line":1578},{"name":"warn","containerName":"_subject_seq_feature","kind":12,"line":1578},{"name":"$hframe","containerName":"_subject_seq_feature","kind":13,"line":1579},{"line":1582,"kind":13,"containerName":"_subject_seq_feature","name":"$sim2"},{"containerName":"_subject_seq_feature","name":"frame","line":1582,"kind":12},{"line":1582,"kind":13,"name":"$hframe","containerName":"_subject_seq_feature"},{"kind":13,"line":1583,"containerName":"_subject_seq_feature","name":"$self"},{"kind":13,"line":1583,"name":"$sim2","containerName":"_subject_seq_feature"},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1585},{"kind":13,"line":1586,"containerName":"_subject_seq_feature","name":"$self"}]},{"name":"_making_sff","kind":12,"line":1521},{"kind":12,"line":1522,"name":"HIT_START"},{"line":1523,"kind":12,"name":"HIT_END"},{"name":"_hit_factor","kind":12,"line":1524},{"name":"_hit_factor","line":1527,"kind":12},{"line":1550,"kind":12,"name":"_sim2"},{"name":"Bio","containerName":"SeqFeature::Similarity","line":1550,"kind":12},{"name":"EVALUE","kind":12,"line":1553},{"name":"BITS","kind":12,"line":1554},{"kind":12,"line":1555,"name":"SCORE"},{"line":1557,"kind":12,"name":"HIT_NAME"},{"name":"HIT_LENGTH","kind":12,"line":1558},{"name":"ALGORITHM","line":1559,"kind":12},{"name":"HIT_DESC","kind":12,"line":1560},{"name":"META","line":1561,"kind":12},{"name":"HIT_FRAME","line":1562,"kind":12},{"line":1583,"kind":12,"name":"SUPER","containerName":"feature2"},{"line":1585,"kind":12,"name":"_created_sff"},{"kind":12,"line":1586,"name":"_making_sff"},{"kind":12,"line":1590,"children":[{"kind":13,"line":1591,"definition":"my","name":"$self","containerName":"_pre_similar_stats","localvar":"my"},{"localvar":"my","containerName":"_pre_similar_stats","definition":"my","name":"$identical","line":1592,"kind":13},{"line":1592,"kind":13,"containerName":"_pre_similar_stats","name":"$self"},{"kind":13,"line":1593,"containerName":"_pre_similar_stats","definition":"my","name":"$conserved","localvar":"my"},{"kind":13,"line":1593,"name":"$self","containerName":"_pre_similar_stats"},{"localvar":"my","containerName":"_pre_similar_stats","definition":"my","name":"$percent_id","line":1594,"kind":13},{"kind":13,"line":1594,"containerName":"_pre_similar_stats","name":"$self"},{"containerName":"_pre_similar_stats","name":"$identical","kind":13,"line":1596},{"line":1597,"kind":13,"containerName":"_pre_similar_stats","name":"$percent_id"},{"line":1598,"kind":13,"name":"$self","containerName":"_pre_similar_stats"},{"kind":12,"line":1598,"containerName":"_pre_similar_stats","name":"warn"},{"kind":13,"line":1599,"containerName":"_pre_similar_stats","name":"$identical"},{"line":1602,"kind":13,"containerName":"_pre_similar_stats","name":"$identical"},{"containerName":"_pre_similar_stats","name":"$percent_id","kind":13,"line":1602},{"kind":13,"line":1602,"containerName":"_pre_similar_stats","name":"$self"},{"containerName":"_pre_similar_stats","name":"$conserved","line":1606,"kind":13},{"name":"$self","containerName":"_pre_similar_stats","kind":13,"line":1607},{"name":"warn","containerName":"_pre_similar_stats","line":1607,"kind":12},{"containerName":"_pre_similar_stats","name":"$self","kind":13,"line":1608},{"kind":13,"line":1609,"name":"$conserved","containerName":"_pre_similar_stats"},{"name":"$identical","containerName":"_pre_similar_stats","line":1609,"kind":13},{"containerName":"_pre_similar_stats","name":"$self","kind":13,"line":1611},{"kind":13,"line":1611,"name":"$identical","containerName":"_pre_similar_stats"},{"line":1612,"kind":13,"containerName":"_pre_similar_stats","name":"$self"},{"name":"$conserved","containerName":"_pre_similar_stats","kind":13,"line":1612},{"line":1613,"kind":13,"containerName":"_pre_similar_stats","name":"$self"}],"containerName":"main::","name":"_pre_similar_stats","definition":"sub","range":{"start":{"character":0,"line":1590},"end":{"character":9999,"line":1614}}},{"name":"IDENTICAL","kind":12,"line":1592},{"name":"CONSERVED","kind":12,"line":1593},{"name":"PERCENT_IDENTITY","kind":12,"line":1594},{"kind":12,"line":1602,"name":"HSP_LENGTH"},{"name":"ALGORITHM","kind":12,"line":1608},{"name":"IDENTICAL","kind":12,"line":1611},{"name":"CONSERVED","kind":12,"line":1612},{"kind":12,"line":1613,"name":"_did_presimilar"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_pre_frac","line":1619,"kind":13},{"localvar":"my","definition":"my","name":"$hsp_len","containerName":"_pre_frac","line":1620,"kind":13},{"name":"$self","containerName":"_pre_frac","line":1620,"kind":13},{"localvar":"my","name":"$hit_len","definition":"my","containerName":"_pre_frac","line":1621,"kind":13},{"kind":13,"line":1621,"name":"$self","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$query_len","definition":"my","localvar":"my","kind":13,"line":1622},{"line":1622,"kind":13,"name":"$self","containerName":"_pre_frac"},{"kind":13,"line":1624,"definition":"my","name":"$identical","containerName":"_pre_frac","localvar":"my"},{"name":"$self","containerName":"_pre_frac","line":1624,"kind":13},{"kind":12,"line":1624,"containerName":"_pre_frac","name":"num_identical"},{"line":1625,"kind":13,"localvar":"my","name":"$conserved","definition":"my","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$self","line":1625,"kind":13},{"kind":12,"line":1625,"name":"num_conserved","containerName":"_pre_frac"},{"name":"$self","containerName":"_pre_frac","kind":13,"line":1627},{"localvar":"my","definition":"my","name":"$logical","containerName":"_pre_frac","line":1628,"kind":13},{"containerName":"_pre_frac","name":"$hsp_len","kind":13,"line":1629},{"kind":13,"line":1630,"containerName":"_pre_frac","name":"$self"},{"containerName":"_pre_frac","name":"length","line":1630,"kind":12},{"containerName":"_pre_frac","name":"$hsp_len","line":1630,"kind":13},{"name":"$logical","containerName":"_pre_frac","line":1631,"kind":13},{"kind":13,"line":1631,"name":"$self","containerName":"_pre_frac"},{"kind":12,"line":1631,"name":"_logical_length","containerName":"_pre_frac"},{"kind":13,"line":1632,"containerName":"_pre_frac","name":"$self"},{"kind":12,"line":1632,"name":"frac_identical","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$identical","line":1632,"kind":13},{"line":1632,"kind":13,"name":"$hsp_len","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$self","kind":13,"line":1633},{"kind":12,"line":1633,"containerName":"_pre_frac","name":"frac_conserved"},{"name":"$conserved","containerName":"_pre_frac","line":1633,"kind":13},{"kind":13,"line":1633,"name":"$hsp_len","containerName":"_pre_frac"},{"name":"$hit_len","containerName":"_pre_frac","line":1635,"kind":13},{"name":"$logical","containerName":"_pre_frac","kind":13,"line":1636},{"containerName":"_pre_frac","name":"$self","kind":13,"line":1636},{"containerName":"_pre_frac","name":"_logical_length","line":1636,"kind":12},{"name":"$self","containerName":"_pre_frac","line":1637,"kind":13},{"name":"frac_identical","containerName":"_pre_frac","line":1637,"kind":12},{"name":"$identical","containerName":"_pre_frac","kind":13,"line":1637},{"kind":13,"line":1637,"containerName":"_pre_frac","name":"$logical"},{"line":1638,"kind":13,"name":"$self","containerName":"_pre_frac"},{"kind":12,"line":1638,"containerName":"_pre_frac","name":"frac_conserved"},{"name":"$conserved","containerName":"_pre_frac","kind":13,"line":1638},{"line":1638,"kind":13,"name":"$logical","containerName":"_pre_frac"},{"line":1640,"kind":13,"name":"$query_len","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$logical","kind":13,"line":1641},{"containerName":"_pre_frac","name":"$self","kind":13,"line":1641},{"name":"_logical_length","containerName":"_pre_frac","kind":12,"line":1641},{"name":"$self","containerName":"_pre_frac","kind":13,"line":1642},{"containerName":"_pre_frac","name":"frac_identical","kind":12,"line":1642},{"line":1642,"kind":13,"containerName":"_pre_frac","name":"$identical"},{"line":1642,"kind":13,"name":"$logical","containerName":"_pre_frac"},{"name":"$self","containerName":"_pre_frac","kind":13,"line":1643},{"kind":12,"line":1643,"name":"frac_conserved","containerName":"_pre_frac"},{"containerName":"_pre_frac","name":"$conserved","kind":13,"line":1643},{"line":1643,"kind":13,"name":"$logical","containerName":"_pre_frac"}],"line":1618,"definition":"sub","name":"_pre_frac","containerName":"main::","range":{"start":{"character":0,"line":1618},"end":{"character":9999,"line":1645}}},{"line":1620,"kind":12,"name":"HSP_LENGTH"},{"name":"HIT_LENGTH","line":1621,"kind":12},{"line":1622,"kind":12,"name":"QUERY_LENGTH"},{"name":"_did_prefrac","line":1627,"kind":12},{"kind":12,"line":1652,"children":[{"line":1653,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_pre_gaps"},{"name":"$query_gaps","definition":"my","containerName":"_pre_gaps","localvar":"my","kind":13,"line":1654},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1654},{"kind":13,"line":1655,"containerName":"_pre_gaps","definition":"my","name":"$query_seq","localvar":"my"},{"containerName":"_pre_gaps","name":"$self","line":1655,"kind":13},{"containerName":"_pre_gaps","definition":"my","name":"$hit_gaps","localvar":"my","kind":13,"line":1656},{"kind":13,"line":1656,"containerName":"_pre_gaps","name":"$self"},{"containerName":"_pre_gaps","definition":"my","name":"$hit_seq","localvar":"my","kind":13,"line":1657},{"containerName":"_pre_gaps","name":"$self","line":1657,"kind":13},{"name":"$gaps","definition":"my","containerName":"_pre_gaps","localvar":"my","kind":13,"line":1658},{"kind":13,"line":1658,"containerName":"_pre_gaps","name":"$self"},{"name":"$self","containerName":"_pre_gaps","line":1660,"kind":13},{"name":"$query_gaps","containerName":"_pre_gaps","kind":13,"line":1661},{"name":"$self","containerName":"_pre_gaps","line":1662,"kind":13},{"name":"gaps","containerName":"_pre_gaps","line":1662,"kind":12},{"containerName":"_pre_gaps","name":"$query_gaps","line":1662,"kind":13},{"kind":13,"line":1663,"containerName":"_pre_gaps","name":"$query_seq"},{"localvar":"my","containerName":"_pre_gaps","definition":"my","name":"$qg","line":1664,"kind":13},{"line":1664,"kind":13,"name":"$self","containerName":"_pre_gaps"},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1664},{"containerName":"_pre_gaps","name":"seq_inds","kind":12,"line":1664},{"line":1664,"kind":13,"name":"$query_seq","containerName":"_pre_gaps"},{"line":1665,"kind":13,"localvar":"my","definition":"my","name":"$offset","containerName":"_pre_gaps"},{"containerName":"_pre_gaps","name":"$self","kind":13,"line":1665},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1666},{"containerName":"_pre_gaps","name":"gaps","kind":12,"line":1666},{"name":"$qg","containerName":"_pre_gaps","kind":13,"line":1666},{"name":"$offset","containerName":"_pre_gaps","line":1666,"kind":13},{"containerName":"_pre_gaps","name":"$hit_gaps","kind":13,"line":1668},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1669},{"name":"gaps","containerName":"_pre_gaps","kind":12,"line":1669},{"kind":13,"line":1669,"name":"$hit_gaps","containerName":"_pre_gaps"},{"name":"$hit_seq","containerName":"_pre_gaps","kind":13,"line":1670},{"containerName":"_pre_gaps","definition":"my","name":"$hg","localvar":"my","kind":13,"line":1671},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1671},{"kind":13,"line":1671,"containerName":"_pre_gaps","name":"$self"},{"kind":12,"line":1671,"name":"seq_inds","containerName":"_pre_gaps"},{"name":"$hit_seq","containerName":"_pre_gaps","line":1671,"kind":13},{"kind":13,"line":1672,"containerName":"_pre_gaps","definition":"my","name":"$offset","localvar":"my"},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1672},{"line":1673,"kind":13,"name":"$self","containerName":"_pre_gaps"},{"line":1673,"kind":12,"name":"gaps","containerName":"_pre_gaps"},{"kind":13,"line":1673,"name":"$hg","containerName":"_pre_gaps"},{"name":"$offset","containerName":"_pre_gaps","line":1673,"kind":13},{"kind":13,"line":1675,"containerName":"_pre_gaps","name":"$gaps"},{"kind":13,"line":1676,"containerName":"_pre_gaps","name":"$gaps"},{"containerName":"_pre_gaps","name":"$self","line":1676,"kind":13},{"kind":12,"line":1676,"containerName":"_pre_gaps","name":"gaps"},{"containerName":"_pre_gaps","name":"$self","line":1676,"kind":13},{"name":"gaps","containerName":"_pre_gaps","kind":12,"line":1676},{"containerName":"_pre_gaps","name":"$self","line":1678,"kind":13},{"line":1678,"kind":12,"name":"gaps","containerName":"_pre_gaps"},{"kind":13,"line":1678,"containerName":"_pre_gaps","name":"$gaps"}],"containerName":"main::","name":"_pre_gaps","definition":"sub","range":{"start":{"character":0,"line":1652},"end":{"line":1679,"character":9999}}},{"line":1654,"kind":12,"name":"QUERY_GAPS"},{"name":"QUERY_SEQ","line":1655,"kind":12},{"line":1656,"kind":12,"name":"HIT_GAPS"},{"kind":12,"line":1657,"name":"HIT_SEQ"},{"line":1658,"kind":12,"name":"HSP_GAPS"},{"kind":12,"line":1660,"name":"_did_pregaps"},{"kind":12,"children":[{"kind":13,"line":1683,"definition":"my","name":"$self","containerName":"_pre_pi","localvar":"my"},{"name":"$self","containerName":"_pre_pi","line":1684,"kind":13},{"kind":13,"line":1685,"name":"$self","containerName":"_pre_pi"},{"name":"percent_identity","containerName":"_pre_pi","line":1685,"kind":12},{"kind":13,"line":1685,"containerName":"_pre_pi","name":"$self"},{"kind":13,"line":1685,"name":"$self","containerName":"_pre_pi"},{"containerName":"_pre_pi","name":"frac_identical","line":1685,"kind":12},{"name":"$self","containerName":"_pre_pi","line":1685,"kind":13}],"line":1682,"name":"_pre_pi","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1686},"start":{"character":0,"line":1682}}},{"name":"_did_prepi","kind":12,"line":1684},{"name":"PERCENT_IDENTITY","kind":12,"line":1685},{"kind":12,"line":1685,"name":"HSP_LENGTH"}]}