{"version":5,"vars":[{"kind":2,"line":87,"containerName":"","name":"base"},{"children":[{"kind":13,"line":107,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"line":107,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":108,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":108,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":108,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","kind":13,"line":110},{"containerName":"new","name":"_setup","kind":12,"line":110},{"kind":13,"line":110,"containerName":"new","name":"@args"},{"line":112,"kind":13,"localvar":"my","definition":"my","name":"$fields","containerName":"new"},{"kind":13,"line":112,"containerName":"new","name":"$self"},{"name":"_fields","containerName":"new","line":112,"kind":12},{"kind":13,"line":113,"containerName":"new","name":"$field","definition":"my","localvar":"my"},{"line":114,"kind":13,"containerName":"new","name":"$fields"},{"containerName":"new","name":"$field","line":114,"kind":13},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":117,"containerName":"new","name":"_dependencies"},{"kind":13,"line":140,"containerName":"new","name":"$self"}],"line":106,"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastPullHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::BlastPullHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::BlastPullHSP - A parser and HSP object for BlastN hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BlastN hsp output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::BlastPullHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::BlastNHSP->new();\n Function: Builds a new Bio::Search::HSP::BlastNHSP object.\n Returns : Bio::Search::HSP::BlastNHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":141,"character":9999},"start":{"line":106,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","line":108,"kind":12},{"kind":12,"line":117,"name":"score"},{"kind":12,"line":118,"name":"bits"},{"name":"evalue","line":119,"kind":12},{"name":"total_gaps","line":120,"kind":12},{"name":"query_strand","kind":12,"line":121},{"line":122,"kind":12,"name":"hit_strand"},{"line":123,"kind":12,"name":"alignment"},{"name":"query_string","line":124,"kind":12},{"line":125,"kind":12,"name":"hit_string"},{"line":126,"kind":12,"name":"homology_string"},{"name":"query_start","kind":12,"line":127},{"kind":12,"line":128,"name":"query_end"},{"name":"hit_start","kind":12,"line":129},{"line":130,"kind":12,"name":"hit_end"},{"name":"hit_identical_inds","line":131,"kind":12},{"line":132,"kind":12,"name":"hit_conserved_inds"},{"name":"hit_nomatch_inds","kind":12,"line":133},{"name":"hit_gap_inds","line":134,"kind":12},{"name":"query_identical_inds","kind":12,"line":135},{"line":136,"kind":12,"name":"query_conserved_inds"},{"line":137,"kind":12,"name":"query_nomatch_inds"},{"kind":12,"line":138,"name":"query_gap_inds"},{"definition":"sub","name":"_discover_header","containerName":"main::","range":{"end":{"character":9999,"line":176},"start":{"line":147,"character":0}},"kind":12,"children":[{"kind":13,"line":148,"definition":"my","name":"$self","containerName":"_discover_header","localvar":"my"},{"containerName":"_discover_header","name":"$self","line":149,"kind":13},{"containerName":"_discover_header","name":"_chunk_seek","line":149,"kind":12},{"localvar":"my","name":"$header","definition":"my","containerName":"_discover_header","line":150,"kind":13},{"containerName":"_discover_header","name":"$self","line":150,"kind":13},{"containerName":"_discover_header","name":"_get_chunk_by_end","kind":12,"line":150},{"containerName":"_discover_header","name":"$self","line":151,"kind":13},{"kind":13,"line":151,"containerName":"_discover_header","name":"$self"},{"kind":12,"line":151,"containerName":"_discover_header","name":"_chunk_tell"},{"containerName":"_discover_header","name":"$self","line":153,"kind":13},{"name":"_fields","containerName":"_discover_header","kind":12,"line":153},{"name":"$self","containerName":"_discover_header","kind":13,"line":153},{"name":"_fields","containerName":"_discover_header","kind":12,"line":153},{"kind":13,"line":153,"name":"$self","containerName":"_discover_header"},{"name":"_fields","containerName":"_discover_header","line":153,"kind":12},{"name":"$self","containerName":"_discover_header","kind":13,"line":154},{"line":154,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":154,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","kind":12,"line":154},{"name":"$self","containerName":"_discover_header","line":154,"kind":13},{"line":154,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":155,"containerName":"_discover_header","name":"$header"},{"kind":13,"line":157,"name":"$self","containerName":"_discover_header"},{"containerName":"_discover_header","name":"_fields","kind":12,"line":157},{"kind":13,"line":159,"containerName":"_discover_header","name":"$strand_type","definition":"my","localvar":"my"},{"line":160,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":160,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":160,"containerName":"_discover_header","name":"$strand_type"},{"kind":13,"line":160,"name":"$self","containerName":"_discover_header"},{"kind":12,"line":160,"name":"_fields","containerName":"_discover_header"},{"containerName":"_discover_header","name":"$strand_type","line":160,"kind":13},{"name":"$self","containerName":"_discover_header","line":164,"kind":13},{"name":"_fields","containerName":"_discover_header","kind":12,"line":164},{"kind":13,"line":165,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","line":165,"kind":12},{"name":"$self","containerName":"_discover_header","line":168,"kind":13},{"name":"_fields","containerName":"_discover_header","line":168,"kind":12},{"containerName":"_discover_header","name":"$self","line":169,"kind":13},{"name":"_fields","containerName":"_discover_header","line":169,"kind":12},{"kind":13,"line":169,"name":"$self","containerName":"_discover_header"},{"kind":12,"line":169,"containerName":"_discover_header","name":"_fields"},{"line":173,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":173,"kind":12,"containerName":"_discover_header","name":"_fields"},{"containerName":"_discover_header","name":"$self","line":173,"kind":13},{"line":173,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":175,"containerName":"_discover_header","name":"$self"},{"kind":12,"line":175,"name":"_fields","containerName":"_discover_header"}],"line":147},{"line":151,"kind":12,"name":"_after_header"},{"name":"bits","kind":12,"line":153},{"name":"score","line":153,"kind":12},{"line":153,"kind":12,"name":"evalue"},{"name":"total_gaps","kind":12,"line":154},{"name":"query_strand","kind":12,"line":154},{"kind":12,"line":154,"name":"hit_strand"},{"name":"query_strand","kind":12,"line":157},{"name":"query_strand","kind":12,"line":164},{"name":"hit_strand","kind":12,"line":165},{"name":"evalue","line":168,"kind":12},{"kind":12,"line":169,"name":"evalue"},{"line":169,"kind":12,"name":"evalue"},{"line":173,"kind":12,"name":"total_gaps"},{"name":"total_gaps","line":173,"kind":12},{"name":"header","line":175,"kind":12},{"name":"_discover_alignment","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":231},"start":{"line":178,"character":0}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_discover_alignment","localvar":"my","kind":13,"line":179},{"kind":13,"line":180,"containerName":"_discover_alignment","name":"$self"},{"name":"_chunk_seek","containerName":"_discover_alignment","line":180,"kind":12},{"containerName":"_discover_alignment","name":"$self","line":180,"kind":13},{"localvar":"my","containerName":"_discover_alignment","name":"$query_string","definition":"my","line":185,"kind":13},{"kind":13,"line":185,"name":"$hit_string","containerName":"_discover_alignment"},{"name":"$homology_string","containerName":"_discover_alignment","line":185,"kind":13},{"kind":13,"line":185,"name":"$q_start","containerName":"_discover_alignment"},{"line":185,"kind":13,"containerName":"_discover_alignment","name":"$h_start"},{"name":"$q_end","containerName":"_discover_alignment","line":185,"kind":13},{"containerName":"_discover_alignment","name":"$h_end","line":185,"kind":13},{"line":186,"kind":13,"localvar":"my","containerName":"_discover_alignment","definition":"my","name":"$strip"},{"name":"$self","containerName":"_discover_alignment","line":186,"kind":13},{"name":"_get_chunk_by_end","containerName":"_discover_alignment","kind":12,"line":186},{"kind":13,"line":186,"name":"$self","containerName":"_discover_alignment"},{"name":"_get_chunk_by_nol","containerName":"_discover_alignment","kind":12,"line":186},{"kind":13,"line":187,"name":"$strip","containerName":"_discover_alignment"},{"localvar":"my","name":"$q1","definition":"my","containerName":"_discover_alignment","line":188,"kind":13},{"line":189,"kind":13,"containerName":"_discover_alignment","name":"$query_string"},{"localvar":"my","definition":"my","name":"$q2","containerName":"_discover_alignment","line":190,"kind":13},{"line":191,"kind":13,"localvar":"my","containerName":"_discover_alignment","name":"$hom","definition":"my"},{"localvar":"my","name":"$h1","definition":"my","containerName":"_discover_alignment","line":192,"kind":13},{"kind":13,"line":193,"name":"$hit_string","containerName":"_discover_alignment"},{"definition":"my","name":"$h2","containerName":"_discover_alignment","localvar":"my","kind":13,"line":194},{"name":"$hom","containerName":"_discover_alignment","line":196,"kind":13},{"kind":13,"line":196,"containerName":"_discover_alignment","name":"$hom"},{"kind":13,"line":196,"name":"$hom","containerName":"_discover_alignment"},{"name":"$homology_string","containerName":"_discover_alignment","kind":13,"line":197},{"name":"$hom","containerName":"_discover_alignment","line":197,"kind":13},{"line":199,"kind":13,"localvar":"my","definition":"my","name":"$q","containerName":"_discover_alignment"},{"kind":13,"line":199,"name":"$q1","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$q2","line":199,"kind":13},{"name":"$q_start","containerName":"_discover_alignment","kind":13,"line":200},{"line":200,"kind":13,"containerName":"_discover_alignment","name":"$q"},{"name":"$q_start","containerName":"_discover_alignment","line":200,"kind":13},{"line":201,"kind":13,"containerName":"_discover_alignment","name":"$q_start"},{"kind":13,"line":201,"name":"$q","containerName":"_discover_alignment"},{"name":"$q_end","containerName":"_discover_alignment","line":203,"kind":13},{"kind":13,"line":203,"containerName":"_discover_alignment","name":"$q"},{"name":"$q_end","containerName":"_discover_alignment","line":203,"kind":13},{"containerName":"_discover_alignment","name":"$q_end","line":204,"kind":13},{"name":"$q","containerName":"_discover_alignment","kind":13,"line":204},{"kind":13,"line":207,"containerName":"_discover_alignment","definition":"my","name":"$h","localvar":"my"},{"name":"$h1","containerName":"_discover_alignment","line":207,"kind":13},{"name":"$h2","containerName":"_discover_alignment","kind":13,"line":207},{"line":208,"kind":13,"name":"$h_start","containerName":"_discover_alignment"},{"kind":13,"line":208,"containerName":"_discover_alignment","name":"$h"},{"name":"$h_start","containerName":"_discover_alignment","kind":13,"line":208},{"containerName":"_discover_alignment","name":"$h_start","kind":13,"line":209},{"containerName":"_discover_alignment","name":"$h","line":209,"kind":13},{"containerName":"_discover_alignment","name":"$h_end","kind":13,"line":211},{"kind":13,"line":211,"containerName":"_discover_alignment","name":"$h"},{"containerName":"_discover_alignment","name":"$h_end","kind":13,"line":211},{"containerName":"_discover_alignment","name":"$h_end","line":212,"kind":13},{"kind":13,"line":212,"containerName":"_discover_alignment","name":"$h"},{"kind":13,"line":217,"name":"$self","containerName":"_discover_alignment"},{"kind":12,"line":217,"name":"_fields","containerName":"_discover_alignment"},{"name":"$query_string","containerName":"_discover_alignment","kind":13,"line":217},{"line":218,"kind":13,"name":"$self","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"_fields","line":218,"kind":12},{"line":218,"kind":13,"name":"$hit_string","containerName":"_discover_alignment"},{"kind":13,"line":219,"name":"$self","containerName":"_discover_alignment"},{"line":219,"kind":12,"name":"_fields","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$homology_string","line":219,"kind":13},{"line":221,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"line":221,"kind":12,"name":"_fields","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$q_start","kind":13,"line":221},{"name":"$self","containerName":"_discover_alignment","line":222,"kind":13},{"kind":12,"line":222,"name":"_fields","containerName":"_discover_alignment"},{"containerName":"_discover_alignment","name":"$q_end","kind":13,"line":222},{"containerName":"_discover_alignment","name":"$self","kind":13,"line":223},{"kind":12,"line":223,"containerName":"_discover_alignment","name":"_fields"},{"kind":13,"line":223,"containerName":"_discover_alignment","name":"$h_start"},{"containerName":"_discover_alignment","name":"$self","kind":13,"line":224},{"kind":12,"line":224,"containerName":"_discover_alignment","name":"_fields"},{"name":"$h_end","containerName":"_discover_alignment","kind":13,"line":224},{"name":"$self","containerName":"_discover_alignment","kind":13,"line":226},{"name":"$query_string","containerName":"_discover_alignment","kind":13,"line":226},{"kind":13,"line":227,"name":"$self","containerName":"_discover_alignment"},{"line":227,"kind":13,"containerName":"_discover_alignment","name":"$hit_string"},{"name":"$self","containerName":"_discover_alignment","kind":13,"line":228},{"line":228,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"line":228,"kind":13,"containerName":"_discover_alignment","name":"$self"},{"name":"$self","containerName":"_discover_alignment","line":230,"kind":13},{"kind":12,"line":230,"name":"_fields","containerName":"_discover_alignment"}],"line":178},{"kind":12,"line":180,"name":"_after_header"},{"name":"query_string","line":217,"kind":12},{"name":"hit_string","kind":12,"line":218},{"kind":12,"line":219,"name":"homology_string"},{"line":221,"kind":12,"name":"query_start"},{"line":222,"kind":12,"name":"query_end"},{"name":"hit_start","line":223,"kind":12},{"name":"hit_end","line":224,"kind":12},{"name":"_query_gaps","kind":12,"line":226},{"kind":12,"line":227,"name":"_hit_gaps"},{"line":228,"kind":12,"name":"_total_gaps"},{"line":228,"kind":12,"name":"_query_gaps"},{"name":"_hit_gaps","line":228,"kind":12},{"name":"alignment","kind":12,"line":230},{"range":{"start":{"line":234,"character":0},"end":{"line":297,"character":9999}},"definition":"sub","name":"_discover_seq_inds","containerName":"main::","children":[{"line":235,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"$self","definition":"my"},{"containerName":"_discover_seq_inds","name":"$seqString","definition":"my","localvar":"my","kind":13,"line":236},{"name":"$qseq","containerName":"_discover_seq_inds","line":236,"kind":13},{"line":236,"kind":13,"containerName":"_discover_seq_inds","name":"$sseq"},{"containerName":"_discover_seq_inds","name":"$self","kind":13,"line":236},{"line":236,"kind":12,"name":"get_field","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$self","line":237,"kind":13},{"line":237,"kind":12,"containerName":"_discover_seq_inds","name":"get_field"},{"line":238,"kind":13,"name":"$self","containerName":"_discover_seq_inds"},{"kind":12,"line":238,"name":"get_field","containerName":"_discover_seq_inds"},{"line":243,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my","name":"%identicalList_query"},{"kind":13,"line":244,"containerName":"_discover_seq_inds","name":"%identicalList_sbjct","definition":"my","localvar":"my"},{"line":245,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"%conservedList_query","definition":"my"},{"localvar":"my","name":"%conservedList_sbjct","definition":"my","containerName":"_discover_seq_inds","line":246,"kind":13},{"line":247,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","definition":"my","name":"@gapList_query"},{"localvar":"my","containerName":"_discover_seq_inds","name":"@gapList_sbjct","definition":"my","line":248,"kind":13},{"kind":13,"line":249,"definition":"my","name":"%nomatchList_query","containerName":"_discover_seq_inds","localvar":"my"},{"line":250,"kind":13,"localvar":"my","containerName":"_discover_seq_inds","name":"%nomatchList_sbjct","definition":"my"},{"line":252,"kind":13,"localvar":"my","definition":"my","name":"$resCount_query","containerName":"_discover_seq_inds"},{"line":252,"kind":13,"containerName":"_discover_seq_inds","name":"$self"},{"containerName":"_discover_seq_inds","name":"get_field","kind":12,"line":252},{"definition":"my","name":"$resCount_sbjct","containerName":"_discover_seq_inds","localvar":"my","kind":13,"line":253},{"name":"$self","containerName":"_discover_seq_inds","line":253,"kind":13},{"containerName":"_discover_seq_inds","name":"get_field","kind":12,"line":253},{"line":255,"kind":13,"localvar":"my","name":"$mchar","definition":"my","containerName":"_discover_seq_inds"},{"kind":13,"line":255,"name":"$schar","containerName":"_discover_seq_inds"},{"line":255,"kind":13,"name":"$qchar","containerName":"_discover_seq_inds"},{"line":256,"kind":13,"name":"$mchar","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$seqString","kind":13,"line":256},{"kind":13,"line":257,"name":"$qchar","containerName":"_discover_seq_inds"},{"line":257,"kind":13,"containerName":"_discover_seq_inds","name":"$schar"},{"name":"$qseq","containerName":"_discover_seq_inds","line":257,"kind":13},{"name":"$sseq","containerName":"_discover_seq_inds","line":257,"kind":13},{"line":259,"kind":13,"name":"$mchar","containerName":"_discover_seq_inds"},{"name":"$mchar","containerName":"_discover_seq_inds","line":259,"kind":13},{"line":259,"kind":13,"name":"$mchar","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"$conservedList_query","kind":13,"line":260},{"line":260,"kind":13,"containerName":"_discover_seq_inds","name":"$resCount_query"},{"containerName":"_discover_seq_inds","name":"$conservedList_sbjct","line":261,"kind":13},{"containerName":"_discover_seq_inds","name":"$resCount_sbjct","kind":13,"line":261},{"line":263,"kind":13,"containerName":"_discover_seq_inds","name":"$mchar"},{"containerName":"_discover_seq_inds","name":"$nomatchList_query","line":264,"kind":13},{"containerName":"_discover_seq_inds","name":"$resCount_query","kind":13,"line":264},{"name":"$nomatchList_sbjct","containerName":"_discover_seq_inds","line":265,"kind":13},{"line":265,"kind":13,"containerName":"_discover_seq_inds","name":"$resCount_sbjct"},{"containerName":"_discover_seq_inds","name":"$identicalList_query","line":268,"kind":13},{"containerName":"_discover_seq_inds","name":"$resCount_query","line":268,"kind":13},{"kind":13,"line":269,"containerName":"_discover_seq_inds","name":"$identicalList_sbjct"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","kind":13,"line":269},{"line":272,"kind":13,"containerName":"_discover_seq_inds","name":"$qchar"},{"name":"@gapList_query","containerName":"_discover_seq_inds","kind":13,"line":273},{"kind":13,"line":273,"name":"$resCount_query","containerName":"_discover_seq_inds"},{"line":276,"kind":13,"name":"$resCount_query","containerName":"_discover_seq_inds"},{"kind":13,"line":278,"containerName":"_discover_seq_inds","name":"$schar"},{"containerName":"_discover_seq_inds","name":"@gapList_sbjct","kind":13,"line":279},{"kind":13,"line":279,"name":"$resCount_sbjct","containerName":"_discover_seq_inds"},{"name":"$resCount_sbjct","containerName":"_discover_seq_inds","line":282,"kind":13},{"localvar":"my","containerName":"_discover_seq_inds","definition":"my","name":"$fields","line":286,"kind":13},{"kind":13,"line":286,"name":"$self","containerName":"_discover_seq_inds"},{"line":286,"kind":12,"name":"_fields","containerName":"_discover_seq_inds"},{"line":287,"kind":13,"name":"$fields","containerName":"_discover_seq_inds"},{"kind":13,"line":287,"name":"$a","containerName":"_discover_seq_inds"},{"line":287,"kind":13,"name":"$b","containerName":"_discover_seq_inds"},{"kind":13,"line":287,"name":"%identicalList_sbjct","containerName":"_discover_seq_inds"},{"line":288,"kind":13,"containerName":"_discover_seq_inds","name":"$fields"},{"containerName":"_discover_seq_inds","name":"$a","line":288,"kind":13},{"containerName":"_discover_seq_inds","name":"$b","line":288,"kind":13},{"kind":13,"line":288,"containerName":"_discover_seq_inds","name":"%conservedList_sbjct"},{"name":"$fields","containerName":"_discover_seq_inds","kind":13,"line":289},{"kind":13,"line":289,"name":"$a","containerName":"_discover_seq_inds"},{"name":"$b","containerName":"_discover_seq_inds","line":289,"kind":13},{"name":"%nomatchList_sbjct","containerName":"_discover_seq_inds","kind":13,"line":289},{"kind":13,"line":290,"containerName":"_discover_seq_inds","name":"$fields"},{"line":290,"kind":13,"containerName":"_discover_seq_inds","name":"@gapList_sbjct"},{"line":291,"kind":13,"containerName":"_discover_seq_inds","name":"$fields"},{"line":291,"kind":13,"name":"$a","containerName":"_discover_seq_inds"},{"name":"$b","containerName":"_discover_seq_inds","line":291,"kind":13},{"line":291,"kind":13,"name":"%identicalList_query","containerName":"_discover_seq_inds"},{"line":292,"kind":13,"name":"$fields","containerName":"_discover_seq_inds"},{"name":"$a","containerName":"_discover_seq_inds","kind":13,"line":292},{"line":292,"kind":13,"containerName":"_discover_seq_inds","name":"$b"},{"name":"%conservedList_query","containerName":"_discover_seq_inds","kind":13,"line":292},{"containerName":"_discover_seq_inds","name":"$fields","kind":13,"line":293},{"kind":13,"line":293,"containerName":"_discover_seq_inds","name":"$a"},{"kind":13,"line":293,"name":"$b","containerName":"_discover_seq_inds"},{"containerName":"_discover_seq_inds","name":"%nomatchList_query","line":293,"kind":13},{"containerName":"_discover_seq_inds","name":"$fields","line":294,"kind":13},{"name":"@gapList_query","containerName":"_discover_seq_inds","line":294,"kind":13},{"containerName":"_discover_seq_inds","name":"$fields","line":296,"kind":13}],"line":234,"kind":12},{"kind":12,"line":287,"name":"hit_identical_inds"},{"name":"hit_conserved_inds","kind":12,"line":288},{"line":289,"kind":12,"name":"hit_nomatch_inds"},{"kind":12,"line":290,"name":"hit_gap_inds"},{"kind":12,"line":291,"name":"query_identical_inds"},{"name":"query_conserved_inds","kind":12,"line":292},{"line":293,"kind":12,"name":"query_nomatch_inds"},{"kind":12,"line":294,"name":"query_gap_inds"},{"line":296,"kind":12,"name":"seq_inds"},{"name":"query","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":309},"end":{"character":9999,"line":328}},"kind":12,"children":[{"line":310,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"query"},{"containerName":"query","name":"$self","kind":13,"line":311},{"name":"$self","containerName":"query","line":312,"kind":13},{"containerName":"query","name":"$self","kind":13,"line":313},{"line":313,"kind":12,"name":"primary_tag","containerName":"query"},{"containerName":"query","name":"$self","kind":13,"line":314},{"name":"get_field","containerName":"query","line":314,"kind":12},{"kind":13,"line":315,"name":"$self","containerName":"query"},{"containerName":"query","name":"get_field","kind":12,"line":315},{"containerName":"query","name":"$self","line":316,"kind":13},{"containerName":"query","name":"get_field","kind":12,"line":316},{"line":317,"kind":13,"containerName":"query","name":"$self"},{"containerName":"query","name":"get_field","line":317,"kind":12},{"kind":13,"line":318,"name":"$self","containerName":"query"},{"line":318,"kind":12,"name":"get_field","containerName":"query"},{"line":319,"kind":13,"name":"$self","containerName":"query"},{"name":"get_field","containerName":"query","line":319,"kind":12},{"name":"$self","containerName":"query","kind":13,"line":320},{"name":"get_field","containerName":"query","kind":12,"line":320},{"kind":13,"line":321,"containerName":"query","name":"$self"},{"containerName":"query","name":"get_field","kind":12,"line":321},{"line":322,"kind":13,"name":"$self","containerName":"query"},{"line":322,"kind":12,"containerName":"query","name":"get_field"},{"line":325,"kind":13,"containerName":"query","name":"$self"},{"kind":13,"line":327,"containerName":"query","name":"$self"}],"line":309},{"kind":12,"line":311,"name":"_created_query"},{"kind":12,"line":312,"name":"SUPER","containerName":"query"},{"line":313,"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio"},{"name":"_created_query","line":325,"kind":12},{"line":327,"kind":12,"name":"SUPER","containerName":"query"},{"containerName":"main::","name":"hit","definition":"sub","range":{"start":{"character":0,"line":340},"end":{"line":359,"character":9999}},"kind":12,"line":340,"children":[{"containerName":"hit","name":"$self","definition":"my","localvar":"my","kind":13,"line":341},{"containerName":"hit","name":"$self","line":342,"kind":13},{"kind":13,"line":343,"name":"$self","containerName":"hit"},{"containerName":"hit","name":"$self","kind":13,"line":344},{"name":"primary_tag","containerName":"hit","kind":12,"line":344},{"kind":13,"line":345,"name":"$self","containerName":"hit"},{"kind":12,"line":345,"containerName":"hit","name":"get_field"},{"name":"$self","containerName":"hit","kind":13,"line":346},{"containerName":"hit","name":"get_field","kind":12,"line":346},{"line":347,"kind":13,"name":"$self","containerName":"hit"},{"containerName":"hit","name":"get_field","kind":12,"line":347},{"name":"$self","containerName":"hit","kind":13,"line":348},{"kind":12,"line":348,"containerName":"hit","name":"get_field"},{"kind":13,"line":349,"name":"$self","containerName":"hit"},{"kind":12,"line":349,"name":"get_field","containerName":"hit"},{"kind":13,"line":350,"containerName":"hit","name":"$self"},{"kind":12,"line":350,"containerName":"hit","name":"get_field"},{"name":"$self","containerName":"hit","kind":13,"line":351},{"containerName":"hit","name":"get_field","line":351,"kind":12},{"kind":13,"line":352,"containerName":"hit","name":"$self"},{"containerName":"hit","name":"get_field","kind":12,"line":352},{"line":353,"kind":13,"containerName":"hit","name":"$self"},{"line":353,"kind":12,"containerName":"hit","name":"get_field"},{"containerName":"hit","name":"$self","kind":13,"line":356},{"kind":13,"line":358,"name":"$self","containerName":"hit"}]},{"line":342,"kind":12,"name":"_created_hit"},{"line":343,"kind":12,"name":"SUPER","containerName":"hit"},{"kind":12,"line":344,"containerName":"SeqFeature::Similarity","name":"Bio"},{"line":356,"kind":12,"name":"_created_hit"},{"kind":12,"line":358,"name":"SUPER","containerName":"hit"},{"name":"gaps","range":{"start":{"character":0,"line":374},"end":{"character":9999,"line":389}},"definition":"sub","containerName":"main::","signature":{"label":"gaps($self,$type)","documentation":"1;\n# $Id: BlastPullHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::BlastPullHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::BlastPullHSP - A parser and HSP object for BlastN hsps\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BlastN hsp output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::BlastPullHSP;\n\nuse strict;\nuse base qw(Bio::Search::HSP::PullHSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::BlastNHSP->new();\n Function: Builds a new Bio::Search::HSP::BlastNHSP object.\n Returns : Bio::Search::HSP::BlastNHSP\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hsp, and $start and $end define the tell() position within the\n           filehandle that the hsp data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( header alignment query_strand hit_strand )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( score => 'header',\n                              bits => 'header',\n                              evalue => 'header',\n                              total_gaps => 'header',\n                              query_strand => 'header',\n                              hit_strand => 'header',\n                              alignment => 'header',\n                              query_string => 'alignment',\n                              hit_string => 'alignment',\n                              homology_string => 'alignment',\n                              query_start => 'alignment',\n                              query_end => 'alignment',\n                              hit_start => 'alignment',\n                              hit_end => 'alignment',\n                              hit_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  hit_nomatch_inds => 'seq_inds',\n                              hit_gap_inds => 'seq_inds',\n                              query_identical_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_conserved_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_nomatch_inds => 'seq_inds',\n\t\t\t\t\t\t\t  query_gap_inds => 'seq_inds' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_header {\n    my $self = shift;\n    $self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"\\nQuery\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t($self->_fields->{bits}, $self->_fields->{score}, $self->_fields->{evalue},\n     $self->_fields->{total_gaps}, $self->_fields->{query_strand}, $self->_fields->{hit_strand})\n     = $header =~ /^\\s*(\\S+) bits \\((\\d+)\\),\\s+Expect = (\\S+)(?:\\s+.+Gaps = (\\d+))?(?:.+Strand\\s*=\\s*(\\w+)\\s*\\/\\s*(\\w+))?/sm;\n    \n    if ($self->_fields->{query_strand}) {\n        # protein blasts don't have strand\n        for my $strand_type ('query_strand', 'hit_strand') {\n            $self->_fields->{$strand_type} = $self->_fields->{$strand_type} eq 'Plus' ? 1 : -1;\n        }\n    }\n    else {\n        $self->_fields->{query_strand} = 0;\n        $self->_fields->{hit_strand} = 0;\n    }\n\t\n\tif ($self->_fields->{evalue} =~ /^e/) {\n\t\t$self->_fields->{evalue} = '1'.$self->_fields->{evalue};\n\t}\n    \n    # query_gaps isn't always given\n    $self->_fields->{total_gaps} = '[unset]' unless $self->_fields->{total_gaps};\n    \n\t$self->_fields->{header} = 1;\n}\n\nsub _discover_alignment {\n    my $self = shift;\n    $self->_chunk_seek($self->{_after_header});\n    \n    # work out various basic fields for the hsp\n    # (quicker to do this all at once instead of each method working on\n    # alignment itself)\n    my ($query_string, $hit_string, $homology_string, $q_start, $h_start, $q_end, $h_end);\n    while (my $strip = $self->_get_chunk_by_end(\"\\nQuery\") || $self->_get_chunk_by_nol(4)) {\n        $strip =~ /\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)\\s+(\\S.+)\\nSbjct:?\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/gm || last;\n        my $q1 = $1;\n        $query_string .= $2;\n        my $q2 = $3;\n        my $hom = $4;\n        my $h1 = $5;\n        $hit_string .= $6;\n        my $h2 = $7;\n        \n        $hom = ' 'x(length($6) - length($hom)).$hom;\n        $homology_string .= $hom;\n        \n        for my $q ($q1, $q2) {\n            if (! defined $q_start || $q < $q_start) {\n                $q_start = $q;\n            }\n            if (! defined $q_end || $q > $q_end) {\n                $q_end = $q;\n            }\n        }\n        for my $h ($h1, $h2) {\n            if (! defined $h_start || $h < $h_start) {\n                $h_start = $h;\n            }\n            if (! defined $h_end || $h > $h_end) {\n                $h_end = $h;\n            }\n        }\n    }\n    \n    $self->_fields->{query_string} = $query_string;\n    $self->_fields->{hit_string} = $hit_string;\n    $self->_fields->{homology_string} = $homology_string;\n    \n    $self->_fields->{query_start} = $q_start;\n    $self->_fields->{query_end} = $q_end;\n    $self->_fields->{hit_start} = $h_start;\n    $self->_fields->{hit_end} = $h_end;\n    \n    ($self->{_query_gaps}) = $query_string =~ tr/-//;\n    ($self->{_hit_gaps}) = $hit_string =~ tr/-//;\n    ($self->{_total_gaps}) = $self->{_query_gaps} + $self->{_hit_gaps};\n    \n    $self->_fields->{alignment} = 1; # stop this method being called again\n}\n\n# seq_inds related methods, all just need seq_inds field to have been gotten\nsub _discover_seq_inds {\n    my $self = shift;\n    my ($seqString, $qseq, $sseq) = ( $self->get_field('homology_string'),\n                                      $self->get_field('query_string'),\n                                      $self->get_field('hit_string') );\n    \n    # (code largely lifted from GenericHSP)\n    \n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n    my @gapList_query = ();\n    my @gapList_sbjct = ();\n    my %nomatchList_query = ();\n    my %nomatchList_sbjct = ();\n    \n    my $resCount_query = $self->get_field('query_end');\n    my $resCount_sbjct = $self->get_field('hit_end');\n    \n    my ($mchar, $schar, $qchar);\n    while ($mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        \n        if ($mchar eq '+' || $mchar eq '.' || $mchar eq ':') { \n            $conservedList_query{ $resCount_query } = 1; \n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        }\n        elsif ($mchar eq ' ') { \n            $nomatchList_query{ $resCount_query } = 1;\n            $nomatchList_sbjct{ $resCount_sbjct } = 1;\n        }\n        else { \n            $identicalList_query{ $resCount_query } = 1; \n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        \n        if ($qchar eq '-') {\n            push(@gapList_query, $resCount_query);\n        }\n        else { \t    \n            $resCount_query -= 1;\n        }\n        if ($schar eq '-') {\n            push(@gapList_sbjct, $resCount_sbjct);\n        }\n        else { \t    \n            $resCount_sbjct -= 1;\n        }\n    }\n    \n    my $fields = $self->_fields;\n    $fields->{hit_identical_inds} = [ sort { $a <=> $b } keys %identicalList_sbjct ];\n    $fields->{hit_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_sbjct ];\n    $fields->{hit_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_sbjct ];\n    $fields->{hit_gap_inds} = [ reverse @gapList_sbjct ];\n    $fields->{query_identical_inds} = [ sort { $a <=> $b } keys %identicalList_query ];\n    $fields->{query_conserved_inds} = [ sort { $a <=> $b } keys %conservedList_query ];\n    $fields->{query_nomatch_inds} = [ sort { $a <=> $b } keys %nomatchList_query ];\n    $fields->{query_gap_inds} = [ reverse @gapList_query ];\n    \n    $fields->{seq_inds} = 1;\n}\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : none\n\n\nsub query {\n    my $self = shift;\n    unless ($self->{_created_query}) {\n        $self->SUPER::query( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('query_start'),\n                   '-end'      => $self->get_field('query_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => $self->get_field('query_strand'),\n                   '-seq_id'   => $self->get_field('query_name'),\n                   '-seqlength'=> $self->get_field('query_length'),\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('query_description'),\n                   '-frame'    => 0 # not known?\n                   ) );\n\t\t$self->{_created_query} = 1;\n    }\n    return $self->SUPER::query(@_);\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : L<Bio::SeqFeature::Similarity>\n Args    : [optional] new value to set\n\n\nsub hit {\n    my $self = shift;\n    unless ($self->{_created_hit}) {\n        $self->SUPER::hit( new  Bio::SeqFeature::Similarity\n                  ('-primary'  => $self->primary_tag,\n                   '-start'    => $self->get_field('hit_start'),\n                   '-end'      => $self->get_field('hit_end'),\n                   '-expect'   => $self->get_field('evalue'),\n                   '-score'    => $self->get_field('score'),\n                   '-strand'   => $self->get_field('hit_strand'),\n                   '-seq_id'   => $self->get_field('name'),\n                   '-seqlength'=> $self->get_field('length'),\n                   '-source'   => $self->get_field('algorithm'),\n                   '-seqdesc'  => $self->get_field('description'),\n                   '-frame'    => 0 # not known?\n                   ) );\n\t\t$self->{_created_hit} = 1;\n    }\n    return $self->SUPER::hit(@_);\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query' = num conserved / length of query seq (without gaps)\n            'hit'   = num conserved / length of hit seq (without gaps)\n            'total' = num conserved / length of alignment (with gaps)\n            default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}]},"detail":"($self,$type)","kind":12,"children":[{"localvar":"my","containerName":"gaps","name":"$self","definition":"my","line":375,"kind":13},{"kind":13,"line":375,"containerName":"gaps","name":"$type"},{"kind":13,"line":377,"containerName":"gaps","name":"$type"},{"name":"$type","containerName":"gaps","kind":13,"line":377},{"name":"$type","containerName":"gaps","kind":13,"line":377},{"containerName":"gaps","name":"$type","kind":13,"line":378},{"name":"$type","containerName":"gaps","line":378,"kind":13},{"line":378,"kind":13,"containerName":"gaps","name":"$type"},{"line":378,"kind":13,"containerName":"gaps","name":"$type"},{"kind":13,"line":379,"containerName":"gaps","name":"$type"},{"containerName":"gaps","name":"$type","line":379,"kind":13},{"line":381,"kind":13,"containerName":"gaps","name":"$type"},{"line":382,"kind":13,"localvar":"my","name":"$answer","definition":"my","containerName":"gaps"},{"containerName":"gaps","name":"$self","kind":13,"line":382},{"containerName":"gaps","name":"get_field","line":382,"kind":12},{"name":"$answer","containerName":"gaps","line":383,"kind":13},{"containerName":"gaps","name":"$answer","kind":13,"line":383},{"kind":13,"line":386,"name":"$self","containerName":"gaps"},{"name":"get_field","containerName":"gaps","line":386,"kind":12},{"line":388,"kind":13,"name":"$self","containerName":"gaps"},{"name":"$type","containerName":"gaps","line":388,"kind":13}],"line":374},{"line":403,"children":[{"line":404,"kind":13,"localvar":"my","containerName":"strand","name":"$self","definition":"my"},{"containerName":"strand","definition":"my","name":"$val","localvar":"my","kind":13,"line":405},{"name":"$val","containerName":"strand","kind":13,"line":406},{"line":406,"kind":13,"name":"$val","containerName":"strand"},{"line":407,"kind":13,"name":"$val","containerName":"strand"},{"containerName":"strand","name":"$val","line":409,"kind":13},{"name":"$self","containerName":"strand","line":410,"kind":13},{"line":410,"kind":12,"name":"get_field","containerName":"strand"},{"kind":13,"line":412,"containerName":"strand","name":"$val"},{"line":413,"kind":13,"containerName":"strand","name":"$self"},{"line":413,"kind":12,"containerName":"strand","name":"get_field"},{"kind":13,"line":415,"name":"$val","containerName":"strand"},{"kind":13,"line":416,"name":"$self","containerName":"strand"},{"line":416,"kind":12,"containerName":"strand","name":"get_field"},{"name":"$self","containerName":"strand","line":416,"kind":13},{"name":"get_field","containerName":"strand","line":416,"kind":12},{"line":419,"kind":13,"containerName":"strand","name":"$self"},{"kind":12,"line":419,"containerName":"strand","name":"warn"}],"kind":12,"range":{"start":{"line":403,"character":0},"end":{"line":422,"character":9999}},"containerName":"main::","name":"strand","definition":"sub"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start","line":437,"kind":13},{"line":438,"kind":13,"localvar":"my","name":"$val","definition":"my","containerName":"start"},{"line":439,"kind":13,"containerName":"start","name":"$val"},{"line":439,"kind":13,"name":"$val","containerName":"start"},{"kind":13,"line":440,"containerName":"start","name":"$val"},{"name":"$val","containerName":"start","kind":13,"line":442},{"containerName":"start","name":"$self","line":443,"kind":13},{"line":443,"kind":12,"name":"get_field","containerName":"start"},{"name":"$val","containerName":"start","kind":13,"line":445},{"line":446,"kind":13,"name":"$self","containerName":"start"},{"kind":12,"line":446,"containerName":"start","name":"get_field"},{"containerName":"start","name":"$val","kind":13,"line":448},{"containerName":"start","name":"$self","line":449,"kind":13},{"kind":12,"line":449,"containerName":"start","name":"get_field"},{"name":"$self","containerName":"start","kind":13,"line":449},{"kind":12,"line":449,"name":"get_field","containerName":"start"},{"containerName":"start","name":"$self","line":452,"kind":13},{"containerName":"start","name":"warn","line":452,"kind":12}],"line":436,"kind":12,"range":{"start":{"line":436,"character":0},"end":{"character":9999,"line":455}},"name":"start","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":470,"kind":13,"localvar":"my","containerName":"end","definition":"my","name":"$self"},{"kind":13,"line":471,"definition":"my","name":"$val","containerName":"end","localvar":"my"},{"line":472,"kind":13,"name":"$val","containerName":"end"},{"line":472,"kind":13,"name":"$val","containerName":"end"},{"containerName":"end","name":"$val","line":473,"kind":13},{"kind":13,"line":475,"name":"$val","containerName":"end"},{"containerName":"end","name":"$self","line":476,"kind":13},{"containerName":"end","name":"get_field","kind":12,"line":476},{"name":"$val","containerName":"end","line":478,"kind":13},{"line":479,"kind":13,"name":"$self","containerName":"end"},{"containerName":"end","name":"get_field","line":479,"kind":12},{"kind":13,"line":481,"name":"$val","containerName":"end"},{"line":482,"kind":13,"name":"$self","containerName":"end"},{"name":"get_field","containerName":"end","line":482,"kind":12},{"containerName":"end","name":"$self","line":482,"kind":13},{"containerName":"end","name":"get_field","line":482,"kind":12},{"name":"$self","containerName":"end","kind":13,"line":485},{"line":485,"kind":12,"name":"warn","containerName":"end"}],"line":469,"definition":"sub","name":"end","containerName":"main::","range":{"start":{"line":469,"character":0},"end":{"line":488,"character":9999}}},{"line":500,"children":[],"kind":12,"range":{"start":{"character":0,"line":500},"end":{"character":9999,"line":500}},"containerName":"main::","name":"pvalue","definition":"sub"}]}