{"version":5,"vars":[{"line":102,"kind":2,"name":"Dumper","containerName":"strict::Data"},{"line":107,"kind":2,"name":"vars","containerName":""},{"name":"base","containerName":"","line":108,"kind":2},{"name":"Storable","line":112,"kind":12},{"kind":12,"line":112,"containerName":"main::","name":"import"},{"name":"$BINARY","containerName":null,"kind":13,"line":113},{"range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":132}},"name":"new","line":132,"children":[{"localvar":"my","definition":"my","name":"$caller","containerName":"new","line":133,"kind":13},{"name":"@args","containerName":"new","line":133,"kind":13},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":134},{"kind":13,"line":134,"name":"$caller","containerName":"new"},{"kind":13,"line":134,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":135,"kind":13},{"name":"_initialise_storable","containerName":"new","kind":12,"line":135},{"kind":13,"line":136,"name":"$self","containerName":"new"}],"kind":12,"detail":"($caller,@args)","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: Storable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Root::Storable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Will Spooner <whs@sanger.ac.uk>\n#\n# Copyright Will Spooner <whs@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Root::Storable - object serialisation methods\n\n=head1 SYNOPSIS\n\n  my $storable = Bio::Root::Storable->new();\n\n  # Store/retrieve using class retriever\n  my $token     = $storable->store();\n  my $storable2 = Bio::Root::Storable->retrieve( $token );\n\n  # Store/retrieve using object retriever\n  my $storable2 = $storable->new_retrievable();\n  $storable2->retrieve();\n\n\n=head1 DESCRIPTION\n\nGeneric module that allows objects to be safely stored/retrieved from\ndisk.  Can be inhereted by any BioPerl object. As it will not usually\nbe the first class in the inheretence list, _initialise_storable()\nshould be called during object instantiation.\n\nObject storage is recursive; If the object being stored contains other\nstorable objects, these will be stored seperately, and replaced by a\nskeleton object in the parent heirarchy. When the parent is later\nretrieved, its children remain in the skeleton state until explicitly\nretrieved by the parent. This lazy-retrieve approach has obvious\nmemory efficiency benefits for certain applications.\n\n\nBy default, objects are stored in binary format (using the Perl\nStorable module). Earlier versions of Perl5 do not include Storable as\na core module. If this is the case, ASCII object storage (using the\nPerl Data::Dumper module) is used instead.\n\nASCII storage can be enabled by default by setting the value of\n$Bio::Root::Storable::BINARY to false.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bio.perl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Will Spooner\n\nEmail whs@sanger.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\npackage Bio::Root::Storable;\n\nuse strict;\nuse Data::Dumper qw( Dumper );\n\nuse File::Spec;\nuse Bio::Root::IO;\n\nuse vars qw( $BINARY );\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n  if( eval \"require Storable\" ){\n    Storable->import( 'freeze', 'thaw' );\n    $BINARY = 1;\n  }\n}\n\n#----------------------------------------------------------------------\n\n=head2 new\n\n  Arg [1]   : -workdir  => filesystem path,\n              -template => tmpfile template,\n              -suffix   => tmpfile suffix,\n  Function  : Builds a new Bio::Root::Storable inhereting object\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : $storable = Bio::Root::Storable->new()","label":"new($caller,@args)"},"containerName":"main::","definition":"sub"},{"containerName":"new","name":"SUPER","line":134,"kind":12},{"kind":12,"line":152,"children":[{"definition":"my","name":"$self","containerName":"_initialise_storable","localvar":"my","kind":13,"line":153},{"definition":"my","name":"$workdir","containerName":"_initialise_storable","localvar":"my","kind":13,"line":154},{"containerName":"_initialise_storable","name":"$template","line":154,"kind":13},{"kind":13,"line":154,"containerName":"_initialise_storable","name":"$suffix"},{"name":"$self","containerName":"_initialise_storable","kind":13,"line":155},{"containerName":"_initialise_storable","name":"_rearrange","kind":12,"line":155},{"name":"$workdir","containerName":"_initialise_storable","line":156,"kind":13},{"kind":13,"line":156,"name":"$self","containerName":"_initialise_storable"},{"name":"workdir","containerName":"_initialise_storable","kind":12,"line":156},{"kind":13,"line":156,"name":"$workdir","containerName":"_initialise_storable"},{"kind":13,"line":157,"containerName":"_initialise_storable","name":"$template"},{"kind":13,"line":157,"name":"$self","containerName":"_initialise_storable"},{"line":157,"kind":12,"containerName":"_initialise_storable","name":"template"},{"containerName":"_initialise_storable","name":"$template","kind":13,"line":157},{"name":"$suffix","containerName":"_initialise_storable","line":158,"kind":13},{"containerName":"_initialise_storable","name":"$self","line":158,"kind":13},{"kind":12,"line":158,"containerName":"_initialise_storable","name":"suffix"},{"kind":13,"line":158,"containerName":"_initialise_storable","name":"$suffix"}],"containerName":"main::","name":"_initialise_storable","definition":"sub","range":{"end":{"character":9999,"line":160},"start":{"character":0,"line":152}}},{"containerName":"main::","definition":"sub","name":"statefile","range":{"start":{"line":179,"character":0},"end":{"line":204,"character":9999}},"kind":12,"line":179,"children":[{"localvar":"my","containerName":"statefile","definition":"my","name":"$key","line":181,"kind":13},{"localvar":"my","name":"$self","definition":"my","containerName":"statefile","line":182,"kind":13},{"kind":13,"line":184,"name":"$self","containerName":"statefile"},{"kind":13,"line":184,"name":"$key","containerName":"statefile"},{"name":"$self","containerName":"statefile","kind":13,"line":186},{"containerName":"statefile","name":"$key","line":186,"kind":13},{"containerName":"statefile","definition":"my","name":"$workdir","localvar":"my","kind":13,"line":188},{"kind":13,"line":188,"containerName":"statefile","name":"$self"},{"kind":12,"line":188,"containerName":"statefile","name":"workdir"},{"kind":13,"line":189,"containerName":"statefile","definition":"my","name":"$template","localvar":"my"},{"name":"$self","containerName":"statefile","kind":13,"line":189},{"containerName":"statefile","name":"template","line":189,"kind":12},{"containerName":"statefile","name":"$suffix","definition":"my","localvar":"my","kind":13,"line":190},{"line":190,"kind":13,"name":"$self","containerName":"statefile"},{"name":"suffix","containerName":"statefile","line":190,"kind":12},{"kind":13,"line":194,"containerName":"statefile","name":"@args","definition":"my","localvar":"my"},{"name":"$template","containerName":"statefile","line":195,"kind":13},{"line":195,"kind":13,"name":"@args","containerName":"statefile"},{"line":195,"kind":13,"name":"$template","containerName":"statefile"},{"line":196,"kind":13,"containerName":"statefile","name":"$workdir"},{"line":196,"kind":13,"containerName":"statefile","name":"@args"},{"containerName":"statefile","name":"$workdir","line":196,"kind":13},{"name":"$suffix","containerName":"statefile","line":197,"kind":13},{"line":197,"kind":13,"name":"@args","containerName":"statefile"},{"containerName":"statefile","name":"$suffix","line":197,"kind":13},{"localvar":"my","definition":"my","name":"$fh","containerName":"statefile","line":198,"kind":13},{"line":198,"kind":13,"containerName":"statefile","name":"$file"},{"containerName":"statefile","name":"new","kind":12,"line":198},{"kind":12,"line":198,"name":"tempfile","containerName":"statefile"},{"name":"@args","containerName":"statefile","line":198,"kind":13},{"name":"$self","containerName":"statefile","line":200,"kind":13},{"containerName":"statefile","name":"$key","kind":13,"line":200},{"line":200,"kind":13,"containerName":"statefile","name":"$file"},{"containerName":"statefile","name":"$self","kind":13,"line":203},{"name":"$key","containerName":"statefile","kind":13,"line":203}]},{"line":194,"kind":12,"name":"CLEANUP"},{"line":194,"kind":12,"name":"UNLINK"},{"line":198,"kind":12,"name":"Bio","containerName":"Root::IO"},{"kind":12,"children":[{"kind":13,"line":220,"name":"$key","definition":"my","containerName":"workdir","localvar":"my"},{"line":221,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"workdir"},{"kind":13,"line":223,"definition":"my","name":"$caller","containerName":"workdir","localvar":"my"},{"name":"$self","containerName":"workdir","kind":13,"line":224},{"name":"$key","containerName":"workdir","kind":13,"line":224},{"kind":13,"line":224,"containerName":"workdir","name":"$self"},{"name":"debug","containerName":"workdir","kind":12,"line":224},{"kind":13,"line":225,"name":"$self","containerName":"workdir"},{"kind":13,"line":225,"containerName":"workdir","name":"$key"},{"kind":13,"line":228,"name":"$self","containerName":"workdir"},{"containerName":"workdir","name":"$key","kind":13,"line":228},{"line":228,"kind":12,"containerName":"workdir","name":"tmpdir"},{"name":"$self","containerName":"workdir","line":229,"kind":13},{"name":"$key","containerName":"workdir","line":229,"kind":13}],"line":219,"definition":"sub","name":"workdir","containerName":"main::","range":{"start":{"line":219,"character":0},"end":{"character":9999,"line":230}}},{"name":"File","containerName":"Spec","line":228,"kind":12},{"kind":12,"line":245,"children":[{"name":"$key","definition":"my","containerName":"template","localvar":"my","kind":13,"line":246},{"line":247,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"template"},{"name":"$self","containerName":"template","kind":13,"line":248},{"containerName":"template","name":"$key","kind":13,"line":248},{"containerName":"template","name":"$self","kind":13,"line":249},{"name":"$key","containerName":"template","kind":13,"line":249},{"kind":13,"line":250,"name":"$self","containerName":"template"},{"containerName":"template","name":"$key","kind":13,"line":250}],"containerName":"main::","definition":"sub","name":"template","range":{"start":{"character":0,"line":245},"end":{"line":251,"character":9999}}},{"containerName":"main::","name":"suffix","definition":"sub","range":{"end":{"character":9999,"line":271},"start":{"character":0,"line":266}},"kind":12,"line":266,"children":[{"name":"$key","definition":"my","containerName":"suffix","localvar":"my","kind":13,"line":267},{"name":"$self","definition":"my","containerName":"suffix","localvar":"my","kind":13,"line":268},{"kind":13,"line":269,"name":"$self","containerName":"suffix"},{"kind":13,"line":269,"containerName":"suffix","name":"$key"},{"name":"$self","containerName":"suffix","kind":13,"line":270},{"kind":13,"line":270,"containerName":"suffix","name":"$key"}]},{"kind":12,"line":290,"children":[{"kind":13,"line":291,"name":"$self","definition":"my","containerName":"new_retrievable","localvar":"my"},{"line":292,"kind":13,"localvar":"my","containerName":"new_retrievable","definition":"my","name":"@args"},{"containerName":"new_retrievable","name":"$self","kind":13,"line":294},{"line":294,"kind":12,"containerName":"new_retrievable","name":"_initialise_storable"},{"kind":13,"line":294,"containerName":"new_retrievable","name":"@args"},{"line":296,"kind":13,"containerName":"new_retrievable","name":"$self"},{"containerName":"new_retrievable","name":"retrievable","kind":12,"line":296},{"line":296,"kind":13,"containerName":"new_retrievable","name":"$self"},{"name":"clone","containerName":"new_retrievable","line":296,"kind":12},{"line":297,"kind":13,"name":"$self","containerName":"new_retrievable"},{"name":"store","containerName":"new_retrievable","line":297,"kind":12},{"containerName":"new_retrievable","name":"@args","kind":13,"line":297},{"containerName":"new_retrievable","name":"$self","kind":13,"line":298},{"kind":12,"line":298,"containerName":"new_retrievable","name":"workdir"},{"name":"$self","containerName":"new_retrievable","line":299,"kind":13},{"containerName":"new_retrievable","name":"suffix","line":299,"kind":12},{"kind":13,"line":300,"containerName":"new_retrievable","name":"$self"},{"name":"template","containerName":"new_retrievable","kind":12,"line":300},{"name":"$self","containerName":"new_retrievable","line":301,"kind":13}],"containerName":"main::","name":"new_retrievable","definition":"sub","range":{"start":{"character":0,"line":290},"end":{"line":302,"character":9999}}},{"name":"_statefile","line":297,"kind":12},{"name":"_workdir","line":298,"kind":12},{"line":299,"kind":12,"name":"_suffix"},{"kind":12,"line":300,"name":"_template"},{"line":301,"kind":12,"name":"_retrievable"},{"line":318,"children":[{"localvar":"my","containerName":"retrievable","definition":"my","name":"$self","line":319,"kind":13},{"name":"$self","containerName":"retrievable","line":320,"kind":13},{"containerName":"retrievable","name":"$self","line":321,"kind":13}],"kind":12,"range":{"start":{"line":318,"character":0},"end":{"line":322,"character":9999}},"containerName":"main::","definition":"sub","name":"retrievable"},{"name":"_retrievable","kind":12,"line":320},{"name":"_retrievable","line":321,"kind":12},{"line":338,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"token","line":339,"kind":13},{"line":340,"kind":13,"containerName":"token","name":"$self"},{"kind":12,"line":340,"name":"statefile","containerName":"token"}],"kind":12,"range":{"start":{"character":0,"line":338},"end":{"character":9999,"line":341}},"containerName":"main::","name":"token","definition":"sub"},{"range":{"end":{"line":368,"character":9999},"start":{"character":0,"line":360}},"containerName":"main::","definition":"sub","name":"store","line":360,"children":[{"line":361,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"store"},{"kind":13,"line":362,"name":"$statefile","definition":"my","containerName":"store","localvar":"my"},{"containerName":"store","name":"$self","kind":13,"line":362},{"line":362,"kind":12,"containerName":"store","name":"statefile"},{"name":"$store_obj","definition":"my","containerName":"store","localvar":"my","kind":13,"line":363},{"name":"$self","containerName":"store","line":363,"kind":13},{"containerName":"store","name":"serialise","kind":12,"line":363},{"localvar":"my","containerName":"store","name":"$io","definition":"my","line":364,"kind":13},{"name":"new","containerName":"store","line":364,"kind":12},{"line":365,"kind":13,"name":"$io","containerName":"store"},{"name":"_print","containerName":"store","line":365,"kind":12},{"name":"$store_obj","containerName":"store","line":365,"kind":13},{"containerName":"store","name":"$self","kind":13,"line":366},{"containerName":"store","name":"debug","kind":12,"line":366},{"name":"$statefile","containerName":"store","kind":13,"line":367}],"kind":12},{"name":"Bio","containerName":"Root::IO","kind":12,"line":364},{"definition":"sub","name":"serialise","containerName":"main::","range":{"start":{"line":388,"character":0},"end":{"character":9999,"line":446}},"kind":12,"children":[{"line":389,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"serialise"},{"localvar":"my","containerName":"serialise","name":"$store_obj","definition":"my","line":392,"kind":13},{"name":"$self","containerName":"serialise","kind":13,"line":392},{"line":394,"kind":13,"localvar":"my","containerName":"serialise","name":"%retargs","definition":"my"},{"containerName":"serialise","name":"$self","line":394,"kind":13},{"containerName":"serialise","name":"workdir","kind":12,"line":394},{"containerName":"serialise","name":"$self","line":395,"kind":13},{"line":395,"kind":12,"containerName":"serialise","name":"suffix"},{"kind":13,"line":396,"containerName":"serialise","name":"$self"},{"kind":12,"line":396,"name":"template","containerName":"serialise"},{"containerName":"serialise","definition":"my","name":"$key","localvar":"my","kind":13,"line":400},{"name":"$self","containerName":"serialise","kind":13,"line":400},{"name":"$key","containerName":"serialise","line":401,"kind":13},{"definition":"my","name":"$value","containerName":"serialise","localvar":"my","kind":13,"line":402},{"name":"$self","containerName":"serialise","kind":13,"line":402},{"line":402,"kind":13,"containerName":"serialise","name":"$key"},{"name":"$value","containerName":"serialise","kind":13,"line":405},{"containerName":"serialise","name":"$store_obj","line":406,"kind":13},{"containerName":"serialise","name":"$key","kind":13,"line":406},{"containerName":"serialise","name":"$value","line":406,"kind":13},{"containerName":"serialise","name":"$value","kind":13,"line":410},{"kind":13,"line":410,"name":"$value","containerName":"serialise"},{"name":"isa","containerName":"serialise","kind":12,"line":410},{"kind":13,"line":412,"containerName":"serialise","name":"$store_obj"},{"line":412,"kind":13,"containerName":"serialise","name":"$key"},{"containerName":"serialise","name":"$value","kind":13,"line":412},{"kind":12,"line":412,"name":"new_retrievable","containerName":"serialise"},{"kind":13,"line":412,"containerName":"serialise","name":"%retargs"},{"name":"$value","containerName":"serialise","line":417,"kind":13},{"containerName":"serialise","definition":"my","name":"@ary","localvar":"my","kind":13,"line":418},{"localvar":"my","containerName":"serialise","definition":"my","name":"$val","line":419,"kind":13},{"line":419,"kind":13,"name":"$value","containerName":"serialise"},{"name":"$val","containerName":"serialise","kind":13,"line":420},{"name":"$val","containerName":"serialise","kind":13,"line":420},{"containerName":"serialise","name":"isa","line":420,"kind":12},{"name":"@ary","containerName":"serialise","kind":13,"line":421},{"line":421,"kind":13,"name":"$val","containerName":"serialise"},{"name":"new_retrievable","containerName":"serialise","kind":12,"line":421},{"kind":13,"line":421,"name":"%retargs","containerName":"serialise"},{"line":423,"kind":13,"containerName":"serialise","name":"@ary"},{"line":423,"kind":13,"containerName":"serialise","name":"$val"},{"name":"$store_obj","containerName":"serialise","kind":13,"line":425},{"containerName":"serialise","name":"$key","line":425,"kind":13},{"kind":13,"line":425,"name":"@ary","containerName":"serialise"},{"line":429,"kind":13,"containerName":"serialise","name":"$value"},{"kind":13,"line":430,"containerName":"serialise","name":"%hash","definition":"my","localvar":"my"},{"containerName":"serialise","name":"$k2","definition":"my","localvar":"my","kind":13,"line":431},{"containerName":"serialise","name":"$value","line":431,"kind":13},{"localvar":"my","definition":"my","name":"$val","containerName":"serialise","line":432,"kind":13},{"name":"$value","containerName":"serialise","line":432,"kind":13},{"name":"$k2","containerName":"serialise","line":432,"kind":13},{"line":433,"kind":13,"name":"$val","containerName":"serialise"},{"containerName":"serialise","name":"$val","line":433,"kind":13},{"containerName":"serialise","name":"isa","line":433,"kind":12},{"name":"$hash","containerName":"serialise","kind":13,"line":434},{"line":434,"kind":13,"containerName":"serialise","name":"$k2"},{"containerName":"serialise","name":"$val","line":434,"kind":13},{"name":"new_retrievable","containerName":"serialise","line":434,"kind":12},{"line":434,"kind":13,"name":"%retargs","containerName":"serialise"},{"containerName":"serialise","name":"$hash","kind":13,"line":436},{"line":436,"kind":13,"name":"$k2","containerName":"serialise"},{"kind":13,"line":436,"name":"$val","containerName":"serialise"},{"kind":13,"line":438,"containerName":"serialise","name":"$store_obj"},{"line":438,"kind":13,"containerName":"serialise","name":"$key"},{"containerName":"serialise","name":"%hash","kind":13,"line":438},{"containerName":"serialise","name":"$store_obj","kind":13,"line":442},{"kind":13,"line":442,"containerName":"serialise","name":"$key"},{"kind":13,"line":442,"name":"$value","containerName":"serialise"},{"kind":13,"line":444,"name":"$store_obj","containerName":"serialise"},{"name":"retrievable","containerName":"serialise","line":444,"kind":12},{"name":"$self","containerName":"serialise","kind":13,"line":445},{"line":445,"kind":12,"containerName":"serialise","name":"_freeze"},{"kind":13,"line":445,"containerName":"serialise","name":"$store_obj"}],"line":388},{"line":401,"kind":12,"name":"next"},{"signature":{"label":"retrieve($caller,$statefile)","documentation":"1;\n# $Id: Storable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Root::Storable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Will Spooner <whs@sanger.ac.uk>\n#\n# Copyright Will Spooner <whs@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Root::Storable - object serialisation methods\n\n=head1 SYNOPSIS\n\n  my $storable = Bio::Root::Storable->new();\n\n  # Store/retrieve using class retriever\n  my $token     = $storable->store();\n  my $storable2 = Bio::Root::Storable->retrieve( $token );\n\n  # Store/retrieve using object retriever\n  my $storable2 = $storable->new_retrievable();\n  $storable2->retrieve();\n\n\n=head1 DESCRIPTION\n\nGeneric module that allows objects to be safely stored/retrieved from\ndisk.  Can be inhereted by any BioPerl object. As it will not usually\nbe the first class in the inheretence list, _initialise_storable()\nshould be called during object instantiation.\n\nObject storage is recursive; If the object being stored contains other\nstorable objects, these will be stored seperately, and replaced by a\nskeleton object in the parent heirarchy. When the parent is later\nretrieved, its children remain in the skeleton state until explicitly\nretrieved by the parent. This lazy-retrieve approach has obvious\nmemory efficiency benefits for certain applications.\n\n\nBy default, objects are stored in binary format (using the Perl\nStorable module). Earlier versions of Perl5 do not include Storable as\na core module. If this is the case, ASCII object storage (using the\nPerl Data::Dumper module) is used instead.\n\nASCII storage can be enabled by default by setting the value of\n$Bio::Root::Storable::BINARY to false.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bio.perl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Will Spooner\n\nEmail whs@sanger.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\npackage Bio::Root::Storable;\n\nuse strict;\nuse Data::Dumper qw( Dumper );\n\nuse File::Spec;\nuse Bio::Root::IO;\n\nuse vars qw( $BINARY );\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n  if( eval \"require Storable\" ){\n    Storable->import( 'freeze', 'thaw' );\n    $BINARY = 1;\n  }\n}\n\n#----------------------------------------------------------------------\n\n=head2 new\n\n  Arg [1]   : -workdir  => filesystem path,\n              -template => tmpfile template,\n              -suffix   => tmpfile suffix,\n  Function  : Builds a new Bio::Root::Storable inhereting object\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : $storable = Bio::Root::Storable->new()\n\n\nsub new {\n  my ($caller, @args) = @_;\n  my $self = $caller->SUPER::new(@args);\n  $self->_initialise_storable;\n  return $self;\n}\n\n#----------------------------------------------------------------------\n\n=head2 _initialise_storable\n\n  Arg [1]   : See 'new' method\n  Function  : Initialises storable-specific attributes\n  Returntype: boolean\n  Exceptions: \n  Caller    : \n  Example   : \n\n\nsub _initialise_storable {\n  my $self = shift;\n  my( $workdir, $template, $suffix ) =\n    $self->_rearrange([qw(WORKDIR TEMPLATE SUFFIX)], @_ );\n  $workdir  && $self->workdir ( $workdir );\n  $template && $self->template( $template );\n  $suffix   && $self->suffix  ( $suffix   );\n  return 1;\n}\n\n\n\n#----------------------------------------------------------------------\n\n=head2 statefile\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the file to write state into.\n              Should not normaly use as a setter - let Root::IO\n              do this for you.\n  Returntype: string\n  Exceptions: \n  Caller    : Bio::Root::Storable->store\n  Example   : my $statefile = $obj->statefile();\n\n\nsub statefile{\n\n  my $key = '_statefile';\n  my $self  = shift;\n\n  if( @_ ){ $self->{$key} = shift }\n\n  if( ! $self->{$key} ){ # Create a new statefile\n\n    my $workdir  = $self->workdir;\n    my $template = $self->template;\n    my $suffix   = $self->suffix;\n\n    # TODO: add cleanup and unlink methods. For now, we'll keep the\n    # statefile hanging around.\n    my @args = ( CLEANUP=>0, UNLINK=>0 );\n    if( $template ){ push( @args, 'TEMPLATE' => $template )};\n    if( $workdir  ){ push( @args, 'DIR'      => $workdir  )};\n    if( $suffix   ){ push( @args, 'SUFFIX'   => $suffix   )};\n    my( $fh, $file ) = Bio::Root::IO->new->tempfile( @args );\n\n    $self->{$key} = $file;\n  }\n\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 workdir\n\n  Arg [1]   : string (optional) (TODO - convert to array for x-platform)\n  Function  : Accessor for the statefile directory. Defaults to File::Spec->tmpdir\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->workdir('/tmp/foo');\n\n\nsub workdir {\n  my $key = '_workdir';\n  my $self = shift;\n  if( @_ ){\n    my $caller = join( ', ', (caller(0))[1..2] );\n    $self->{$key} && $self->debug(\"Overwriting workdir: probably bad!\");\n    $self->{$key} = shift\n  }\n#  $self->{$key} ||= $Bio::Root::IO::TEMPDIR;\n  $self->{$key} ||= File::Spec->tmpdir();\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 template\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the statefile template. Defaults to XXXXXXXX\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->workdir('RES_XXXXXXXX');\n\n\nsub template {\n  my $key = '_template';\n  my $self = shift;\n  if( @_ ){ $self->{$key} = shift }\n  $self->{$key} ||= 'XXXXXXXX';\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 suffix\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the statefile template.\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->suffix('.state');\n\n\nsub suffix {\n  my $key = '_suffix';\n  my $self = shift;\n  if( @_ ){ $self->{$key} = shift }\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 new_retrievable\n\n  Arg [1]   : Same as for 'new'\n  Function  : Similar to store, except returns a 'skeleton' of the calling\n              object, rather than the statefile.\n              The skeleton can be repopulated by calling 'retrieve'. This\n              will be a clone of the original object.\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : my $skel = $obj->new_retrievable(); # skeleton \n              $skel->retrieve();                  # clone\n\n\nsub new_retrievable{\n   my $self = shift;\n   my @args = @_;\n\n   $self->_initialise_storable( @args );\n\n   if( $self->retrievable ){ return $self->clone } # Clone retrievable\n   return bless( { _statefile   => $self->store(@args),\n\t\t   _workdir     => $self->workdir,\n\t\t   _suffix      => $self->suffix,\n\t\t   _template    => $self->template,\n\t\t   _retrievable => 1 }, ref( $self ) );\n}\n\n#----------------------------------------------------------------------\n\n=head2 retrievable\n\n  Arg [1]   : none\n  Function  : Reports whether the object is in 'skeleton' state, and the\n              'retrieve' method can be called.\n  Returntype: boolean\n  Exceptions: \n  Caller    : \n  Example   : if( $obj->retrievable ){ $obj->retrieve }\n\n\nsub retrievable {\n   my $self = shift;\n   if( @_ ){ $self->{_retrievable} = shift }\n   return $self->{_retrievable};\n}\n\n#----------------------------------------------------------------------\n\n=head2 token\n\n  Arg [1]   : None\n  Function  : Accessor for token attribute\n  Returntype: string. Whatever retrieve needs to retrieve.\n              This base implementation returns the statefile\n  Exceptions: \n  Caller    : \n  Example   : my $token = $obj->token();\n\n\nsub token{\n  my $self = shift;\n  return $self->statefile;\n}\n\n\n#----------------------------------------------------------------------\n\n=head2 store\n\n  Arg [1]   : none\n  Function  : Saves a serialised representation of the object structure\n              to disk. Returns the name of the file that the object was\n              saved to.\n  Returntype: string\n\n  Exceptions: \n  Caller    : \n  Example   : my $token = $obj->store();\n\n\nsub store{\n  my $self = shift;\n  my $statefile = $self->statefile;\n  my $store_obj = $self->serialise;\n  my $io = Bio::Root::IO->new( \">$statefile\" );\n  $io->_print( $store_obj );\n  $self->debug( \"STORING $self to $statefile\\n\" );\n  return $statefile;\n}\n\n#----------------------------------------------------------------------\n\n=head2 serialise\n\n  Arg [1]   : none\n  Function  : Prepares the the serialised representation of the object.\n              Object attribute names starting with '__' are skipped.\n              This is useful for those that do not serialise too well\n              (e.g. filehandles).\n              Attributes are examined for other storable objects. If these\n              are found they are serialised seperately using 'new_retrievable'\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : my $serialised = $obj->serialise();\n\n\nsub serialise{\n  my $self = shift;\n\n  # Create a new object of same class that is going to be serialised\n  my $store_obj = bless( {}, ref( $self ) );\n\n  my %retargs = ( -workdir =>$self->workdir,\n\t\t  -suffix  =>$self->suffix,\n\t\t  -template=>$self->template );\n  # Assume that other storable bio objects held by this object are\n  # only 1-deep.\n\n  foreach my $key( keys( %$self ) ){\n    if( $key =~ /^__/ ){ next } # Ignore keys starting with '__'\n    my $value = $self->{$key};\n\n    # Scalar value\n    if( ! ref( $value ) ){\n      $store_obj->{$key} = $value;\n    }\n\n    # Bio::Root::Storable obj: save placeholder\n    elsif( ref($value) =~ /^Bio::/ and $value->isa('Bio::Root::Storable') ){\n      # Bio::Root::Storable\n      $store_obj->{$key} = $value->new_retrievable( %retargs );\n      next;\n    }\n\n    # Arrayref value. Look for Bio::Root::Storable objs\n    elsif( ref( $value ) eq 'ARRAY' ){\n      my @ary;\n      foreach my $val( @$value ){\n\tif( ref($val) =~ /^Bio::/ and $val->isa('Bio::Root::Storable') ){\n\t  push(  @ary, $val->new_retrievable( %retargs ) );\n\t}\n\telse{ push(  @ary, $val ) }\n      }\n      $store_obj->{$key} = \\@ary;\n    }\n\n    # Hashref value. Look for Bio::Root::Storable objs\n    elsif( ref( $value ) eq 'HASH' ){\n      my %hash;\n      foreach my $k2( keys %$value ){\n\tmy $val = $value->{$k2};\n\tif( ref($val) =~ /^Bio::/ and $val->isa('Bio::Root::Storable') ){\n\t  $hash{$k2} = $val->new_retrievable( %retargs );\n\t}\n\telse{ $hash{$k2} = $val }\n      }\n      $store_obj->{$key} = \\%hash;\n    }\n\n    # Unknown, just add to the store object regardless\n    else{ $store_obj->{$key} = $value }\n  }\n  $store_obj->retrievable(0); # Once deserialised, obj not retrievable\n  return $self->_freeze( $store_obj );\n}\n\n\n#----------------------------------------------------------------------\n\n=head2 retrieve\n\n  Arg [1]   : string; filesystem location of the state file to be retrieved\n  Function  : Retrieves a stored object from disk.\n              Note that the retrieved object will be blessed into its original\n              class, and not the\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : my $obj = Bio::Root::Storable->retrieve( $token );","parameters":[{"label":"$caller"},{"label":"$statefile"}]},"detail":"($caller,$statefile)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":465,"name":"$caller","definition":"my","containerName":"retrieve","localvar":"my"},{"line":465,"kind":13,"name":"$statefile","containerName":"retrieve"},{"localvar":"my","containerName":"retrieve","name":"$self","definition":"my","line":467,"kind":13},{"containerName":"retrieve","name":"$class","definition":"my","localvar":"my","kind":13,"line":468},{"line":468,"kind":13,"name":"$caller","containerName":"retrieve"},{"line":468,"kind":13,"containerName":"retrieve","name":"$caller"},{"kind":13,"line":471,"containerName":"retrieve","name":"$caller"},{"containerName":"retrieve","name":"$caller","kind":13,"line":472},{"name":"retrievable","containerName":"retrieve","line":472,"kind":12},{"containerName":"retrieve","name":"$self","kind":13,"line":473},{"containerName":"retrieve","name":"$caller","line":473,"kind":13},{"kind":13,"line":474,"name":"$statefile","containerName":"retrieve"},{"kind":13,"line":474,"name":"$self","containerName":"retrieve"},{"containerName":"retrieve","name":"statefile","kind":12,"line":474},{"name":"$self","containerName":"retrieve","line":476,"kind":13},{"kind":13,"line":476,"containerName":"retrieve","name":"$class"},{"name":"$statefile","containerName":"retrieve","line":479,"kind":13},{"kind":13,"line":480,"name":"$self","containerName":"retrieve"},{"kind":12,"line":480,"name":"throw","containerName":"retrieve"},{"line":482,"kind":13,"localvar":"my","name":"$io","definition":"my","containerName":"retrieve"},{"name":"new","containerName":"retrieve","line":482,"kind":12},{"containerName":"retrieve","name":"$statefile","line":482,"kind":13},{"line":484,"kind":13,"localvar":"my","containerName":"retrieve","definition":"my","name":"$state_str"},{"containerName":"retrieve","name":"$io","line":484,"kind":13},{"kind":12,"line":484,"name":"_readline","containerName":"retrieve"},{"line":487,"kind":13,"localvar":"my","containerName":"retrieve","definition":"my","name":"$stored_obj"},{"kind":13,"line":488,"name":"$success","definition":"my","containerName":"retrieve","localvar":"my"},{"name":"$i","definition":"my","containerName":"retrieve","localvar":"my","kind":13,"line":489},{"name":"$i","containerName":"retrieve","line":489,"kind":13},{"containerName":"retrieve","name":"$i","line":489,"kind":13},{"line":490,"kind":13,"name":"$stored_obj","containerName":"retrieve"},{"name":"$self","containerName":"retrieve","line":490,"kind":13},{"name":"_thaw","containerName":"retrieve","kind":12,"line":490},{"kind":13,"line":490,"name":"$state_str","containerName":"retrieve"},{"containerName":"retrieve","name":"$success","line":491,"kind":13},{"definition":"my","name":"$package","containerName":"retrieve","localvar":"my","kind":13,"line":492},{"line":494,"kind":13,"localvar":"my","containerName":"retrieve","definition":"my","name":"$postmatch"},{"name":"$postmatch","containerName":"retrieve","line":495,"kind":13},{"line":496,"kind":13,"containerName":"retrieve","name":"$package"},{"kind":13,"line":499,"containerName":"retrieve","name":"$package"},{"name":"$self","containerName":"retrieve","line":500,"kind":13},{"name":"throw","containerName":"retrieve","kind":12,"line":500},{"name":"$self","containerName":"retrieve","kind":13,"line":502},{"line":502,"kind":12,"containerName":"retrieve","name":"throw"},{"name":"$success","containerName":"retrieve","kind":13,"line":504},{"kind":13,"line":504,"name":"$self","containerName":"retrieve"},{"kind":12,"line":504,"name":"throw","containerName":"retrieve"},{"kind":13,"line":506,"containerName":"retrieve","name":"$stored_obj"},{"name":"$self","containerName":"retrieve","kind":13,"line":507},{"line":507,"kind":12,"name":"throw","containerName":"retrieve"},{"name":"$self","containerName":"retrieve","kind":13,"line":509},{"line":509,"kind":13,"containerName":"retrieve","name":"$stored_obj"},{"line":509,"kind":13,"name":"$stored_obj","containerName":"retrieve"},{"containerName":"retrieve","name":"$self","kind":13,"line":510},{"containerName":"retrieve","name":"retrievable","line":510,"kind":12},{"line":513,"kind":13,"name":"$self","containerName":"retrieve"}],"line":464,"kind":12,"range":{"end":{"line":514,"character":9999},"start":{"line":464,"character":0}},"name":"retrieve"},{"containerName":"Root::IO","name":"Bio","line":482,"kind":12},{"range":{"end":{"character":9999,"line":534},"start":{"character":0,"line":530}},"name":"clone","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"clone","definition":"my","name":"$self","line":531,"kind":13},{"localvar":"my","containerName":"clone","name":"$frozen","definition":"my","line":532,"kind":13},{"kind":13,"line":532,"containerName":"clone","name":"$self"},{"containerName":"clone","name":"_freeze","kind":12,"line":532},{"line":532,"kind":13,"containerName":"clone","name":"$self"},{"name":"$self","containerName":"clone","line":533,"kind":13},{"name":"_thaw","containerName":"clone","kind":12,"line":533},{"kind":13,"line":533,"name":"$frozen","containerName":"clone"}],"line":530,"kind":12},{"kind":12,"children":[{"kind":13,"line":552,"name":"$self","definition":"my","containerName":"remove","localvar":"my"},{"containerName":"remove","name":"$self","line":553,"kind":13},{"kind":12,"line":553,"containerName":"remove","name":"statefile"},{"name":"$self","containerName":"remove","kind":13,"line":554},{"line":554,"kind":12,"name":"statefile","containerName":"remove"}],"line":551,"name":"remove","definition":"sub","containerName":"main::","range":{"start":{"line":551,"character":0},"end":{"character":9999,"line":557}}},{"range":{"end":{"character":9999,"line":584},"start":{"character":0,"line":574}},"containerName":"main::","definition":"sub","name":"_freeze","line":574,"children":[{"localvar":"my","containerName":"_freeze","definition":"my","name":"$self","line":575,"kind":13},{"kind":13,"line":576,"containerName":"_freeze","definition":"my","name":"$data","localvar":"my"},{"kind":13,"line":577,"name":"$BINARY","containerName":"_freeze"},{"line":578,"kind":13,"name":"$data","containerName":"_freeze"},{"kind":13,"line":581,"name":"$Data","containerName":"_freeze"},{"line":582,"kind":12,"name":"Dump","containerName":"_freeze"},{"containerName":"_freeze","name":"$data","line":582,"kind":13}],"kind":12},{"kind":12,"line":578,"name":"freeze"},{"name":"Dumper","containerName":"Purity","line":581,"kind":12},{"containerName":"Dumper","name":"Data","line":582,"kind":12},{"containerName":"main::","name":"_thaw","definition":"sub","range":{"end":{"character":9999,"line":617},"start":{"character":0,"line":603}},"kind":12,"line":603,"children":[{"localvar":"my","containerName":"_thaw","name":"$self","definition":"my","line":604,"kind":13},{"line":605,"kind":13,"localvar":"my","containerName":"_thaw","definition":"my","name":"$data"},{"containerName":"_thaw","name":"$BINARY","line":606,"kind":13},{"line":606,"kind":13,"name":"$data","containerName":"_thaw"},{"line":608,"kind":13,"localvar":"my","containerName":"_thaw","definition":"my","name":"$code"},{"kind":13,"line":609,"name":"$code","containerName":"_thaw"},{"name":"$data","containerName":"_thaw","line":609,"kind":13},{"line":611,"kind":13,"name":"$self","containerName":"_thaw"},{"kind":12,"line":611,"containerName":"_thaw","name":"throw"},{"containerName":"_thaw","name":"$code","kind":13,"line":613},{"name":"$self","containerName":"_thaw","line":614,"kind":13},{"kind":12,"line":614,"name":"throw","containerName":"_thaw"}]},{"kind":12,"line":606,"name":"thaw"},{"name":"code","kind":12,"line":615}]}