{"vars":[{"name":"vars","containerName":"","kind":2,"line":207},{"name":"base","containerName":"","line":208,"kind":2},{"line":229,"children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":230},{"name":"@args","containerName":"new","line":230,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":231,"kind":13},{"name":"$class","containerName":"new","line":231,"kind":13},{"line":231,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","name":"$seq","definition":"my","containerName":"new","line":232,"kind":13},{"containerName":"new","name":"$enzymes","line":232,"kind":13},{"line":233,"kind":13,"name":"$self","containerName":"new"},{"line":233,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":237},{"kind":13,"line":239,"name":"$seq","containerName":"new"},{"line":239,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"seq","line":239,"kind":12},{"line":239,"kind":13,"containerName":"new","name":"$seq"},{"kind":13,"line":241,"name":"$enzymes","containerName":"new"},{"line":241,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"enzymes","line":241,"kind":12},{"kind":13,"line":241,"containerName":"new","name":"$enzymes"},{"line":242,"kind":13,"name":"$self","containerName":"new"},{"line":242,"kind":12,"containerName":"new","name":"new"},{"name":"$self","containerName":"new","kind":13,"line":245},{"name":"$self","containerName":"new","line":249,"kind":13},{"name":"$self","containerName":"new","line":251,"kind":13},{"kind":13,"line":252,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":253,"kind":13},{"kind":13,"line":254,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":255,"kind":13},{"line":257,"kind":13,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Analysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Restriction::Analysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Restriction::Analysis - cutting sequences with restriction\nenzymes\n\n=head1 SYNOPSIS\n\n  # analyze a DNA sequence for restriction enzymes\n  use Bio::Restriction::Analysis;\n  use Bio::PrimarySeq;\n  use Data::Dumper;\n\n  # get a DNA sequence from somewhere\n  my $seq = Bio::PrimarySeq->new\n      (-seq =>'AGCTTAATTCATTAGCTCTGACTGCAACGGGCAATATGTCTC',\n       -primary_id => 'synopsis',\n       -molecule => 'dna');\n\n  # now start an analysis.\n  # this is using the default set of enzymes\n  my $ra = Bio::Restriction::Analysis->new(-seq=>$seq);\n\n  # find unique cutters. This returns a\n  # Bio::Restriction::EnzymeCollection object\n  my $enzymes = $ra->unique_cutters;\n  print \"Unique cutters: \", join (', ', \n      map {$_->name} $enzymes->unique_cutters), \"\\n\";\n\n  # AluI is one them. Where does it cut?\n  # This is will return an array of the sequence strings\n\n  my $enz = 'AluI';\n  my @frags = $ra->fragments($enz);\n  # how big are the fragments?\n  print \"AluI fragment lengths: \", join(' & ', map {length $_} @frags), \"\\n\";\n\n  # You can also bypass fragments and call sizes directly:\n  # to see all the fragment sizes\n  print \"All sizes: \", join \" \", $ra->sizes($enz), \"\\n\";\n  # to see all the fragment sizes sorted by size like on a gel\n  print \"All sizes, sorted \", join (\" \", $ra->sizes($enz, 0, 1)), \"\\n\";\n\n  # how many times does each enzyme cut\n  my $cuts = $ra->cuts_by_enzyme('BamHI');\n  print \"BamHI cuts $cuts times\\n\";\n\n  # How many enzymes do not cut at all?\n  print \"There are \", scalar $ra->zero_cutters->each_enzyme,\n        \" enzymes that do not cut\\n\";\n\n  # what about enzymes that cut twice?\n  my $two_cutters = $ra->cutters(2);\n  print join (\" \", map {$_->name} $two_cutters->each_enzyme),\n      \" cut the sequence twice\\n\";\n\n  # what are all the enzymes that cut, and how often do they cut\n  printf \"\\n%-10s%s\\n\", 'Enzyme', 'Number of Cuts';\n  my $all_cutters = $ra->cutters;\n  map {\n      printf \"%-10s%s\\n\", $_->name, $ra->cuts_by_enzyme($_->name)\n  } $all_cutters->each_enzyme;\n\n  # Finally, we can interact the restriction enzyme object by\n  # retrieving it from the collection object see the docs for\n  # Bio::Restriction::Enzyme.pm\n  my $enzobj = $enzymes->get_enzyme($enz);\n\n\n=head1 DESCRIPTION\n\nBio::Restriction::Analysis describes the results of cutting a DNA\nsequence with restriction enzymes.\n\nTo use this module you can pass a sequence object and optionally a\nBio::Restriction::EnzymeCollection that contains the enzyme(s) to cut the\nsequences with. There is a default set of enzymes that will be loaded\nif you do not pass in a Bio::Restriction::EnzymeCollection.\n\nTo cut a sequence, set up a Restriction::Analysis object with a sequence\nlike this:\n\n  use Bio::Restriction::Analysis;\n  my $ra = Bio::Restriction::Analysis->new(-seq=>$seqobj);\n\nor\n\n  my $ra = Bio::Restriction::Analysis->new\n      (-seq=>$seqobj, -enzymes=>$enzs);\n\nThen, to get the fragments for a particular enzyme use this:\n\n  @fragments = $ra->fragments('EcoRI');\n\nNote that the naming of restriction enzymes is that the last numbers\nare usually Roman numbers (I, II, III, etc). You may want to use\nsomething like this:\n\n  # get a reference to an array of unique (single) cutters\n  $singles = $re->unique_cutters;\n  foreach my $enz ($singles->each_enzyme) {\n      @fragments = $re->fragments($enz);\n      ... do something here ...\n  }\n\nNote that if your sequence is circular, the first and last fragment\nwill be joined so that they are the appropriate length and sequence\nfor further analysis. This fragment will also be checked for cuts\nby the enzyme(s).  However, this will change the start of the\nsequence!\n\nThere are two separate algorithms used depending on whether your\nenzyme has ambiguity. The non-ambiguous algoritm is a lot faster,\nand if you are using very large sequences you should try and use\nthis algorithm. If you have a large sequence (e.g. genome) and \nwant to use ambgiuous enzymes you may want to make separate\nBio::Restriction::Enzyme objects for each of the possible\nalternatives and make sure that you do not set is_ambiguous!\n\nThis version should correctly deal with overlapping cut sites\nin both ambiguous and non-ambiguous enzymes.\n\nI have tried to write this module with speed and memory in mind\nso that it can be effectively used for large (e.g. genome sized)\nsequence. This module only stores the cut positions internally,\nand calculates everything else on an as-needed basis. Therefore\nwhen you call fragment_maps (for example), there may be another\ndelay while these are generated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu, \nSteve Chervitz, sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nMark A. Jensen, maj-at-fortinbras-dot-us\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Rob Edwards.  Some of this work is Copyright (c)\n1997-2002 Steve A. Chervitz. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 SEE ALSO\n\nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 APPENDIX\n\nMethods beginning with a leading underscore are considered private and\nare intended for internal use by this module. They are not considered\npart of the public interface and are described here for documentation\npurposes only.\n\n\npackage Bio::Restriction::Analysis;\nuse Bio::Restriction::EnzymeCollection;\nuse strict;\nuse Data::Dumper;\n\nuse vars qw ();\nuse base qw(Bio::Root::Root);\n\n=head1 new\n\n Title     : new\n Function  : Initializes the restriction enzyme object\n Returns   : The Restriction::Analysis object \n Arguments : \n\n\t     $re_anal->new(-seq=$seqobj, \n                 -enzymes=>Restriction::EnzymeCollection object)\n\t     -seq requires a Bio::PrimarySeq object\n\t     -enzymes is optional.\n              If ommitted it will use the default set of enzymes\n\nThis is the place to start. Pass in a sequence, and you will be able\nto get the fragments back out.  Several other things are available\nlike the number of zero cutters or single cutters.","label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"line":229,"character":0},"end":{"line":259,"character":9999}},"name":"new"},{"kind":12,"line":231,"name":"SUPER","containerName":"new"},{"containerName":"Restriction::EnzymeCollection","name":"Bio","kind":12,"line":242},{"line":249,"kind":12,"name":"maximum_cuts"},{"range":{"end":{"character":9999,"line":289},"start":{"line":276,"character":0}},"name":"seq","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"seq","localvar":"my","kind":13,"line":277},{"line":279,"kind":13,"localvar":"my","containerName":"seq","definition":"my","name":"$seq"},{"containerName":"seq","name":"$self","line":280,"kind":13},{"kind":12,"line":280,"name":"throw","containerName":"seq"},{"line":280,"kind":13,"name":"$seq","containerName":"seq"},{"kind":13,"line":281,"name":"$seq","containerName":"seq"},{"containerName":"seq","name":"isa","kind":12,"line":281},{"containerName":"seq","name":"$self","kind":13,"line":282},{"name":"throw","containerName":"seq","kind":12,"line":282},{"name":"$seq","containerName":"seq","line":282,"kind":13},{"containerName":"seq","name":"alphabet","line":282,"kind":12},{"containerName":"seq","name":"$seq","line":283,"kind":13},{"name":"alphabet","containerName":"seq","line":283,"kind":12},{"line":285,"kind":13,"containerName":"seq","name":"$self"},{"name":"$seq","containerName":"seq","line":285,"kind":13},{"kind":13,"line":286,"name":"$self","containerName":"seq"},{"kind":13,"line":288,"name":"$self","containerName":"seq"}],"line":276,"kind":12},{"children":[{"kind":13,"line":310,"name":"$self","definition":"my","containerName":"enzymes","localvar":"my"},{"containerName":"enzymes","name":"$self","line":312,"kind":13},{"line":312,"kind":12,"name":"new","containerName":"enzymes"},{"name":"$self","containerName":"enzymes","kind":13,"line":313},{"line":314,"kind":13,"containerName":"enzymes","name":"$self"},{"line":314,"kind":12,"containerName":"enzymes","name":"enzymes"},{"kind":13,"line":315,"name":"$self","containerName":"enzymes"},{"name":"$self","containerName":"enzymes","kind":13,"line":317}],"line":309,"kind":12,"range":{"start":{"line":309,"character":0},"end":{"line":318,"character":9999}},"name":"enzymes","definition":"sub","containerName":"main::"},{"line":312,"kind":12,"containerName":"Restriction::EnzymeCollection","name":"Bio"},{"kind":12,"line":359,"children":[{"containerName":"cut","definition":"my","name":"$self","localvar":"my","kind":13,"line":360},{"containerName":"cut","name":"$opt","line":360,"kind":13},{"line":360,"kind":13,"name":"$ec","containerName":"cut"},{"containerName":"cut","name":"$self","line":366,"kind":13},{"containerName":"cut","name":"throw","line":366,"kind":12},{"containerName":"cut","name":"$self","kind":13,"line":367},{"containerName":"cut","name":"seq","line":367,"kind":12},{"containerName":"cut","name":"$opt","line":369,"kind":13},{"containerName":"cut","name":"$self","line":370,"kind":13},{"line":370,"kind":12,"containerName":"cut","name":"throw"},{"name":"$ec","containerName":"cut","kind":13,"line":370},{"kind":13,"line":371,"name":"$self","containerName":"cut"},{"containerName":"cut","name":"_multiple_cuts","kind":12,"line":371},{"kind":13,"line":371,"containerName":"cut","name":"$ec"},{"name":"$self","containerName":"cut","kind":13,"line":374},{"kind":13,"line":375,"name":"$self","containerName":"cut"},{"name":"$self","containerName":"cut","line":376,"kind":13},{"line":377,"kind":13,"containerName":"cut","name":"$self"},{"kind":13,"line":378,"containerName":"cut","name":"$self"},{"line":379,"kind":13,"containerName":"cut","name":"$self"},{"name":"$self","containerName":"cut","kind":13,"line":380},{"line":380,"kind":12,"name":"_cuts","containerName":"cut"},{"kind":13,"line":383,"name":"$self","containerName":"cut"},{"name":"$self","containerName":"cut","line":384,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$opt,$ec)","signature":{"label":"cut($self,$opt,$ec)","documentation":"","parameters":[{"label":"$self"},{"label":"$opt"},{"label":"$ec"}]},"name":"cut","range":{"start":{"character":0,"line":359},"end":{"line":385,"character":9999}}},{"kind":12,"line":374,"name":"maximum_cuts"},{"containerName":"main::","definition":"sub","detail":"($self,$ec)","signature":{"label":"multiple_digest($self,$ec)","parameters":[{"label":"$self"},{"label":"$ec"}],"documentation":""},"kind":12,"line":403,"children":[{"kind":13,"line":404,"containerName":"multiple_digest","definition":"my","name":"$self","localvar":"my"},{"line":404,"kind":13,"name":"$ec","containerName":"multiple_digest"},{"name":"$self","containerName":"multiple_digest","kind":13,"line":405},{"line":405,"kind":12,"name":"cut","containerName":"multiple_digest"},{"name":"$ec","containerName":"multiple_digest","kind":13,"line":405}],"name":"multiple_digest","range":{"end":{"character":9999,"line":406},"start":{"line":403,"character":0}}},{"name":"positions","range":{"start":{"character":0,"line":423},"end":{"character":9999,"line":430}},"kind":12,"children":[{"containerName":"positions","name":"$self","definition":"my","localvar":"my","kind":13,"line":424},{"containerName":"positions","name":"$enz","line":424,"kind":13},{"containerName":"positions","name":"$self","kind":13,"line":425},{"line":425,"kind":12,"containerName":"positions","name":"cut"},{"name":"$self","containerName":"positions","line":425,"kind":13},{"kind":13,"line":426,"name":"$self","containerName":"positions"},{"line":426,"kind":12,"name":"throw","containerName":"positions"},{"containerName":"positions","name":"$enz","kind":13,"line":427},{"name":"$self","containerName":"positions","line":429,"kind":13},{"kind":13,"line":429,"name":"$enz","containerName":"positions"},{"line":430,"kind":13,"name":"$self","containerName":"positions"},{"containerName":"positions","name":"$enz","line":430,"kind":13}],"line":423,"definition":"sub","containerName":"main::","signature":{"label":"positions($self,$enz)","parameters":[{"label":"$self"},{"label":"$enz"}],"documentation":""},"detail":"($self,$enz)"},{"range":{"start":{"line":451,"character":0},"end":{"character":9999,"line":459}},"name":"fragments","line":451,"children":[{"kind":13,"line":452,"containerName":"fragments","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":452,"containerName":"fragments","name":"$enz"},{"containerName":"fragments","name":"$self","kind":13,"line":453},{"kind":12,"line":453,"name":"cut","containerName":"fragments"},{"line":453,"kind":13,"containerName":"fragments","name":"$self"},{"containerName":"fragments","name":"$self","kind":13,"line":454},{"name":"throw","containerName":"fragments","kind":12,"line":454},{"containerName":"fragments","name":"$enz","kind":13,"line":455},{"definition":"my","name":"@fragments","containerName":"fragments","localvar":"my","kind":13,"line":456},{"containerName":"fragments","name":"$self","line":457,"kind":13},{"containerName":"fragments","name":"fragment_maps","kind":12,"line":457},{"containerName":"fragments","name":"$enz","line":457,"kind":13},{"line":457,"kind":13,"containerName":"fragments","name":"@fragments"},{"kind":13,"line":458,"containerName":"fragments","name":"@fragments"}],"kind":12,"detail":"($self,$enz)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$enz"}],"label":"fragments($self,$enz)"},"containerName":"main::","definition":"sub"},{"line":457,"kind":12,"name":"seq"},{"detail":"($self,$enz)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$enz"}],"label":"fragment_maps($self,$enz)"},"containerName":"main::","definition":"sub","line":514,"children":[{"kind":13,"line":515,"containerName":"fragment_maps","name":"$self","definition":"my","localvar":"my"},{"line":515,"kind":13,"name":"$enz","containerName":"fragment_maps"},{"containerName":"fragment_maps","name":"$self","line":516,"kind":13},{"containerName":"fragment_maps","name":"cut","kind":12,"line":516},{"line":516,"kind":13,"containerName":"fragment_maps","name":"$self"},{"kind":13,"line":517,"containerName":"fragment_maps","name":"$self"},{"line":517,"kind":12,"containerName":"fragment_maps","name":"throw"},{"name":"$enz","containerName":"fragment_maps","kind":13,"line":518},{"kind":13,"line":525,"name":"@cut_positions","definition":"my","containerName":"fragment_maps","localvar":"my"},{"line":526,"kind":13,"containerName":"fragment_maps","name":"$enz"},{"containerName":"fragment_maps","name":"@cut_positions","line":527,"kind":13},{"kind":13,"line":527,"containerName":"fragment_maps","name":"$self"},{"containerName":"fragment_maps","name":"$enz","kind":13,"line":527}],"kind":12,"range":{"start":{"line":514,"character":0},"end":{"line":528,"character":9999}},"name":"fragment_maps"},{"kind":13,"line":528,"name":"$enz","containerName":null},{"containerName":"main::","name":"isa","kind":12,"line":528},{"name":"@cut_positions","containerName":null,"kind":13,"line":529},{"containerName":null,"name":"%self","kind":13,"line":529},{"name":"$enz","containerName":null,"line":529,"kind":13},{"line":529,"kind":12,"containerName":"main::","name":"name"},{"name":"$enz","containerName":null,"line":530,"kind":13},{"line":530,"kind":12,"name":"isa","containerName":"main::"},{"line":531,"kind":13,"name":"$self","containerName":null},{"line":531,"kind":12,"name":"cut","containerName":"main::"},{"name":"$enz","containerName":null,"kind":13,"line":531},{"containerName":null,"name":"@cut_positions","kind":13,"line":532},{"containerName":null,"name":"%self","line":532,"kind":13},{"containerName":null,"name":"@cut_positions","line":535,"kind":13},{"line":539,"kind":13,"localvar":"my","containerName":null,"name":"%map","definition":"my"},{"line":541,"kind":13,"name":"%self","containerName":null},{"containerName":"main::","name":"length","line":541,"kind":12},{"name":"%self","containerName":null,"line":542,"kind":13},{"name":"seq","containerName":"main::","kind":12,"line":543},{"kind":13,"line":544,"containerName":null,"name":"%self"},{"containerName":null,"name":"$enz","line":544,"kind":13},{"kind":13,"line":544,"containerName":null,"name":"%map"},{"name":"%self","containerName":null,"line":545,"kind":13},{"containerName":null,"name":"$enz","kind":13,"line":545},{"line":546,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"$enz","kind":13,"line":546},{"line":549,"kind":13,"containerName":null,"name":"@cut_positions"},{"name":"$a","containerName":null,"line":549,"kind":13},{"line":549,"kind":13,"containerName":null,"name":"$b"},{"containerName":null,"name":"@cut_positions","line":549,"kind":13},{"line":550,"kind":13,"localvar":"my","definition":"my","name":"@cuts","containerName":null},{"name":"@cut_positions","containerName":null,"line":550,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$i","line":551,"kind":13},{"name":"@cut_positions","containerName":null,"kind":13,"line":551},{"containerName":null,"name":"@cuts","kind":13,"line":552},{"kind":13,"line":552,"containerName":null,"name":"$i"},{"name":"$i","containerName":null,"kind":13,"line":552},{"line":552,"kind":13,"containerName":null,"name":"@cuts"},{"line":552,"kind":12,"name":"cuts"},{"kind":13,"line":555,"name":"$start","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":555,"containerName":null,"name":"$stop","definition":"my","localvar":"my"},{"kind":13,"line":555,"containerName":null,"name":"%seq","definition":"my","localvar":"my"},{"kind":13,"line":555,"definition":"my","name":"%stop","containerName":null,"localvar":"my"},{"line":556,"kind":13,"name":"$stop","containerName":null},{"containerName":null,"name":"@cuts","line":556,"kind":13},{"containerName":null,"name":"%seq","line":557,"kind":13},{"line":557,"kind":13,"containerName":null,"name":"$start"},{"line":557,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":557,"name":"subseq","containerName":"main::"},{"kind":13,"line":557,"name":"$start","containerName":null},{"line":557,"kind":13,"containerName":null,"name":"$stop"},{"name":"%stop","containerName":null,"kind":13,"line":558},{"containerName":null,"name":"$start","line":558,"kind":13},{"name":"$stop","containerName":null,"line":558,"kind":13},{"line":559,"kind":13,"containerName":null,"name":"$start"},{"containerName":null,"name":"$stop","line":559,"kind":13},{"kind":13,"line":561,"name":"$stop","containerName":null},{"line":561,"kind":13,"name":"%self","containerName":null},{"containerName":"main::","name":"length","kind":12,"line":561},{"containerName":null,"name":"$start","line":562,"kind":13},{"kind":13,"line":562,"name":"%stop","containerName":null},{"line":567,"kind":13,"containerName":null,"name":"%seq"},{"containerName":null,"name":"$start","kind":13,"line":567},{"containerName":null,"name":"%self","kind":13,"line":567},{"line":567,"kind":12,"containerName":"main::","name":"subseq"},{"line":567,"kind":13,"name":"$start","containerName":null},{"containerName":null,"name":"$stop","kind":13,"line":567},{"name":"%stop","containerName":null,"kind":13,"line":568},{"kind":13,"line":568,"name":"$start","containerName":null},{"name":"$stop","containerName":null,"kind":13,"line":568},{"name":"%self","containerName":null,"line":571,"kind":13},{"name":"is_circular","containerName":"main::","line":571,"kind":12},{"line":573,"kind":13,"containerName":null,"name":"%seq"},{"name":"$start","containerName":null,"line":573,"kind":13},{"kind":13,"line":573,"name":"%seq","containerName":null},{"line":574,"kind":13,"containerName":null,"name":"%seq"},{"line":575,"kind":13,"containerName":null,"name":"%stop"},{"line":575,"kind":13,"containerName":null,"name":"$start"},{"name":"%stop","containerName":null,"line":575,"kind":13},{"containerName":null,"name":"%stop","kind":13,"line":576},{"name":"%start","definition":"my","containerName":null,"localvar":"my","kind":13,"line":579},{"line":579,"kind":13,"name":"$a","containerName":null},{"containerName":null,"name":"$b","line":579,"kind":13},{"containerName":null,"name":"%seq","line":579,"kind":13},{"line":580,"kind":13,"localvar":"my","definition":"my","name":"%map","containerName":null},{"line":581,"kind":13,"containerName":null,"name":"$start"},{"containerName":null,"name":"%stop","kind":13,"line":582},{"kind":13,"line":582,"name":"$start","containerName":null},{"kind":13,"line":583,"containerName":null,"name":"%seq"},{"containerName":null,"name":"$start","line":583,"kind":13},{"kind":13,"line":585,"name":"%self","containerName":null},{"line":585,"kind":13,"containerName":null,"name":"$enz"},{"line":585,"kind":13,"name":"%map","containerName":null},{"name":"%self","containerName":null,"line":588,"kind":13},{"name":"$enz","containerName":null,"kind":13,"line":588},{"name":"%self","containerName":null,"line":589,"kind":13},{"line":589,"kind":13,"containerName":null,"name":"$enz"},{"detail":"($self,$enz,$kb,$sort)","signature":{"parameters":[{"label":"$self"},{"label":"$enz"},{"label":"$kb"},{"label":"$sort"}],"documentation":"","label":"sizes($self,$enz,$kb,$sort)"},"containerName":"main::","definition":"sub","line":618,"children":[{"line":619,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"sizes"},{"kind":13,"line":619,"name":"$enz","containerName":"sizes"},{"line":619,"kind":13,"containerName":"sizes","name":"$kb"},{"name":"$sort","containerName":"sizes","kind":13,"line":619},{"name":"$self","containerName":"sizes","line":620,"kind":13},{"kind":12,"line":620,"containerName":"sizes","name":"throw"},{"line":621,"kind":13,"containerName":"sizes","name":"$enz"},{"name":"$self","containerName":"sizes","kind":13,"line":622},{"name":"cut","containerName":"sizes","line":622,"kind":12},{"name":"$self","containerName":"sizes","line":622,"kind":13},{"localvar":"my","definition":"my","name":"@frag","containerName":"sizes","line":623,"kind":13},{"containerName":"sizes","definition":"my","name":"$lastsite","localvar":"my","kind":13,"line":623},{"line":624,"kind":13,"localvar":"my","name":"$site","definition":"my","containerName":"sizes"},{"line":624,"kind":13,"name":"$self","containerName":"sizes"},{"line":624,"kind":13,"containerName":"sizes","name":"$enz"}],"kind":12,"range":{"end":{"line":624,"character":9999},"start":{"character":0,"line":618}},"name":"sizes"},{"line":625,"kind":13,"name":"$kb","containerName":null},{"containerName":null,"name":"@frag","kind":13,"line":625},{"kind":13,"line":625,"name":"$site","containerName":null},{"containerName":null,"name":"$lastsite","line":625,"kind":13},{"line":626,"kind":13,"containerName":null,"name":"@frag"},{"name":"$site","containerName":null,"line":626,"kind":13},{"kind":13,"line":626,"containerName":null,"name":"$lastsite"},{"kind":13,"line":627,"containerName":null,"name":"$lastsite"},{"line":627,"kind":13,"containerName":null,"name":"$site"},{"line":629,"kind":13,"containerName":null,"name":"$kb"},{"kind":13,"line":629,"containerName":null,"name":"@frag"},{"line":629,"kind":13,"name":"%self","containerName":null},{"name":"length","containerName":"main::","kind":12,"line":629},{"containerName":null,"name":"$lastsite","kind":13,"line":629},{"containerName":null,"name":"@frag","kind":13,"line":630},{"containerName":null,"name":"%self","kind":13,"line":630},{"line":630,"kind":12,"containerName":"main::","name":"length"},{"name":"$lastsite","containerName":null,"line":630,"kind":13},{"containerName":null,"name":"%self","line":631,"kind":13},{"containerName":"main::","name":"is_circular","line":631,"kind":12},{"localvar":"my","definition":"my","name":"$first","containerName":null,"line":632,"kind":13},{"name":"@frag","containerName":null,"line":632,"kind":13},{"line":633,"kind":13,"localvar":"my","containerName":null,"name":"$last","definition":"my"},{"name":"@frag","containerName":null,"line":633,"kind":13},{"name":"@frag","containerName":null,"kind":13,"line":634},{"line":634,"kind":13,"name":"$first","containerName":null},{"kind":13,"line":634,"containerName":null,"name":"$last"},{"kind":13,"line":636,"containerName":null,"name":"$sort"},{"containerName":null,"name":"@frag","line":636,"kind":13},{"containerName":null,"name":"$b","line":636,"kind":13},{"name":"$a","containerName":null,"line":636,"kind":13},{"name":"@frag","containerName":null,"kind":13,"line":636},{"kind":13,"line":638,"name":"@frag","containerName":null},{"range":{"start":{"character":0,"line":656},"end":{"character":9999,"line":663}},"name":"cuts_by_enzyme","children":[{"line":657,"kind":13,"localvar":"my","containerName":"cuts_by_enzyme","definition":"my","name":"$self"},{"containerName":"cuts_by_enzyme","name":"$enz","kind":13,"line":657},{"containerName":"cuts_by_enzyme","name":"$self","line":659,"kind":13},{"kind":12,"line":659,"name":"throw","containerName":"cuts_by_enzyme"},{"containerName":"cuts_by_enzyme","name":"$enz","kind":13,"line":660},{"kind":13,"line":661,"containerName":"cuts_by_enzyme","name":"$self"},{"kind":12,"line":661,"name":"cut","containerName":"cuts_by_enzyme"},{"containerName":"cuts_by_enzyme","name":"$self","kind":13,"line":661},{"line":662,"kind":13,"name":"$self","containerName":"cuts_by_enzyme"},{"line":662,"kind":13,"name":"$enz","containerName":"cuts_by_enzyme"}],"line":656,"kind":12,"signature":{"label":"cuts_by_enzyme($self,$enz)","parameters":[{"label":"$self"},{"label":"$enz"}],"documentation":""},"detail":"($self,$enz)","definition":"sub","containerName":"main::"},{"signature":{"label":"cutters($self,$a,$z)","documentation":"","parameters":[{"label":"$self"},{"label":"$a"},{"label":"$z"}]},"detail":"($self,$a,$z)","definition":"sub","containerName":"main::","children":[{"containerName":"cutters","definition":"my","name":"$self","localvar":"my","kind":13,"line":693},{"line":693,"kind":13,"name":"$a","containerName":"cutters"},{"name":"$z","containerName":"cutters","kind":13,"line":693},{"name":"$self","containerName":"cutters","kind":13,"line":695},{"containerName":"cutters","name":"cut","kind":12,"line":695},{"kind":13,"line":695,"name":"$self","containerName":"cutters"},{"kind":13,"line":697,"definition":"my","name":"$start","containerName":"cutters","localvar":"my"},{"name":"$end","containerName":"cutters","kind":13,"line":697},{"containerName":"cutters","name":"$a","line":698,"kind":13},{"containerName":"cutters","name":"$self","kind":13,"line":699},{"containerName":"cutters","name":"throw","line":699,"kind":12},{"line":700,"kind":13,"name":"$a","containerName":"cutters"},{"containerName":"cutters","name":"$start","line":701,"kind":13},{"line":701,"kind":13,"containerName":"cutters","name":"$a"},{"name":"$start","containerName":"cutters","line":703,"kind":13},{"kind":13,"line":705,"name":"$start","containerName":"cutters"},{"kind":13,"line":705,"name":"$self","containerName":"cutters"},{"containerName":"cutters","name":"$start","kind":13,"line":705},{"kind":13,"line":705,"name":"$self","containerName":"cutters"},{"kind":13,"line":707,"containerName":"cutters","name":"$z"},{"kind":13,"line":708,"name":"$self","containerName":"cutters"},{"containerName":"cutters","name":"throw","kind":12,"line":708},{"kind":13,"line":709,"name":"$z","containerName":"cutters"},{"kind":13,"line":709,"containerName":"cutters","name":"$z"},{"kind":13,"line":709,"name":"$a","containerName":"cutters"},{"name":"$end","containerName":"cutters","kind":13,"line":710},{"line":710,"kind":13,"containerName":"cutters","name":"$z"},{"line":712,"kind":13,"containerName":"cutters","name":"$a"},{"line":713,"kind":13,"name":"$end","containerName":"cutters"},{"containerName":"cutters","name":"$start","line":713,"kind":13},{"kind":13,"line":715,"name":"$end","containerName":"cutters"},{"containerName":"cutters","name":"$self","line":715,"kind":13},{"name":"$end","containerName":"cutters","kind":13,"line":717},{"kind":13,"line":717,"name":"$self","containerName":"cutters"},{"line":717,"kind":13,"name":"$end","containerName":"cutters"},{"line":717,"kind":13,"name":"$self","containerName":"cutters"},{"localvar":"my","definition":"my","name":"$set","containerName":"cutters","line":718,"kind":13},{"kind":12,"line":718,"name":"new","containerName":"cutters"},{"kind":13,"line":721,"name":"$set","containerName":"cutters"},{"kind":13,"line":721,"containerName":"cutters","name":"$self"},{"kind":13,"line":723,"containerName":"cutters","name":"$i","definition":"my","localvar":"my"},{"line":723,"kind":13,"name":"$start","containerName":"cutters"},{"line":723,"kind":13,"containerName":"cutters","name":"$i"},{"containerName":"cutters","name":"$end","line":723,"kind":13},{"name":"$i","containerName":"cutters","line":723,"kind":13},{"name":"$set","containerName":"cutters","line":724,"kind":13},{"kind":12,"line":724,"containerName":"cutters","name":"enzymes"},{"containerName":"cutters","name":"$self","kind":13,"line":724},{"line":724,"kind":13,"name":"$i","containerName":"cutters"},{"kind":13,"line":725,"name":"$self","containerName":"cutters"},{"kind":13,"line":725,"name":"$i","containerName":"cutters"}],"line":692,"kind":12,"range":{"end":{"character":9999,"line":726},"start":{"line":692,"character":0}},"name":"cutters"},{"containerName":"Restriction::EnzymeCollection","name":"Bio","line":718,"kind":12},{"name":"_number_of_cuts_by_cuts","line":724,"kind":12},{"kind":12,"line":725,"name":"_number_of_cuts_by_cuts"},{"line":728,"kind":13,"name":"$set","containerName":null},{"range":{"start":{"character":0,"line":744},"end":{"line":746,"character":9999}},"containerName":"main::","name":"unique_cutters","definition":"sub","line":744,"children":[{"line":745,"kind":12,"containerName":"unique_cutters","name":"cutters"}],"kind":12},{"range":{"end":{"character":9999,"line":761},"start":{"line":759,"character":0}},"name":"zero_cutters","definition":"sub","containerName":"main::","children":[{"name":"cutters","containerName":"zero_cutters","kind":12,"line":760}],"line":759,"kind":12},{"kind":12,"line":774,"children":[],"containerName":"main::","name":"max_cuts","definition":"sub","range":{"end":{"character":9999,"line":774},"start":{"line":774,"character":0}}},{"line":774,"kind":12,"name":"maximum_cuts"},{"name":"_cuts","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":791},"end":{"line":840,"character":9999}},"kind":12,"children":[{"kind":13,"line":792,"containerName":"_cuts","name":"$self","definition":"my","localvar":"my"},{"line":794,"kind":13,"localvar":"my","containerName":"_cuts","definition":"my","name":"$target_seq"},{"line":794,"kind":13,"name":"$self","containerName":"_cuts"},{"containerName":"_cuts","name":"seq","line":794,"kind":12},{"line":798,"kind":13,"localvar":"my","definition":"my","name":"$enz","containerName":"_cuts"},{"containerName":"_cuts","name":"$self","line":798,"kind":13},{"name":"each_enzyme","containerName":"_cuts","line":798,"kind":12},{"definition":"my","name":"@all_cuts","containerName":"_cuts","localvar":"my","kind":13,"line":799},{"localvar":"my","definition":"my","name":"@others","containerName":"_cuts","line":800,"kind":13},{"containerName":"_cuts","name":"$enz","line":800,"kind":13},{"name":"others","containerName":"_cuts","line":800,"kind":12},{"containerName":"_cuts","name":"$enz","line":800,"kind":13},{"line":800,"kind":12,"name":"can","containerName":"_cuts"},{"name":"$enzyme","definition":"my","containerName":"_cuts","localvar":"my","kind":13,"line":801},{"containerName":"_cuts","name":"$enz","line":801,"kind":13},{"line":801,"kind":13,"name":"@others","containerName":"_cuts"},{"name":"$cut_positions","definition":"my","containerName":"_cuts","localvar":"my","kind":13,"line":806},{"containerName":"_cuts","name":"$self","kind":13,"line":806},{"containerName":"_cuts","name":"_make_cuts","line":806,"kind":12},{"kind":13,"line":806,"name":"$target_seq","containerName":"_cuts"},{"line":806,"kind":13,"name":"$enzyme","containerName":"_cuts"},{"kind":13,"line":808,"containerName":"_cuts","name":"@all_cuts"},{"kind":13,"line":808,"containerName":"_cuts","name":"$cut_positions"},{"name":"$self","containerName":"_cuts","kind":13,"line":814},{"kind":12,"line":814,"name":"is_circular","containerName":"_cuts"},{"kind":13,"line":815,"containerName":"_cuts","name":"$cut_positions"},{"line":815,"kind":13,"name":"$self","containerName":"_cuts"},{"name":"_circular","containerName":"_cuts","kind":12,"line":815},{"kind":13,"line":815,"name":"$target_seq","containerName":"_cuts"},{"kind":13,"line":815,"containerName":"_cuts","name":"$enzyme"},{"containerName":"_cuts","name":"@all_cuts","kind":13,"line":816},{"kind":13,"line":816,"name":"$cut_positions","containerName":"_cuts"},{"containerName":"_cuts","name":"$enzyme","line":820,"kind":13},{"name":"is_symmetric","containerName":"_cuts","kind":12,"line":820},{"name":"$cut_positions","containerName":"_cuts","kind":13,"line":824},{"name":"$self","containerName":"_cuts","line":824,"kind":13},{"containerName":"_cuts","name":"_make_cuts","line":824,"kind":12},{"line":824,"kind":13,"name":"$target_seq","containerName":"_cuts"},{"containerName":"_cuts","name":"$enzyme","line":824,"kind":13},{"containerName":"_cuts","name":"@all_cuts","line":825,"kind":13},{"name":"$cut_positions","containerName":"_cuts","line":825,"kind":13},{"containerName":"_cuts","name":"$self","line":827,"kind":13},{"line":827,"kind":12,"name":"is_circular","containerName":"_cuts"},{"line":828,"kind":13,"name":"$cut_positions","containerName":"_cuts"},{"line":828,"kind":13,"name":"$self","containerName":"_cuts"},{"line":828,"kind":12,"name":"_circular","containerName":"_cuts"},{"kind":13,"line":828,"containerName":"_cuts","name":"$target_seq"},{"containerName":"_cuts","name":"$enzyme","line":828,"kind":13},{"line":829,"kind":13,"name":"@all_cuts","containerName":"_cuts"},{"line":829,"kind":13,"name":"$cut_positions","containerName":"_cuts"},{"line":834,"kind":13,"name":"$all_cuts","containerName":"_cuts"},{"line":836,"kind":13,"name":"@all_cuts","containerName":"_cuts"},{"line":836,"kind":13,"containerName":"_cuts","name":"$a"},{"line":836,"kind":13,"name":"$b","containerName":"_cuts"},{"kind":13,"line":836,"containerName":"_cuts","name":"@all_cuts"},{"name":"$self","containerName":"_cuts","line":837,"kind":13},{"kind":13,"line":837,"name":"$enz","containerName":"_cuts"},{"containerName":"_cuts","name":"name","kind":12,"line":837},{"name":"$all_cuts","containerName":"_cuts","line":837,"kind":13},{"localvar":"my","name":"$i","definition":"my","containerName":"_cuts","line":838,"kind":13},{"line":838,"kind":13,"name":"@all_cuts","containerName":"_cuts"},{"kind":13,"line":839,"containerName":"_cuts","name":"$self"},{"containerName":"_cuts","name":"$enz","line":839,"kind":13},{"containerName":"_cuts","name":"name","line":839,"kind":12},{"kind":13,"line":839,"name":"$i","containerName":"_cuts"},{"containerName":"_cuts","name":"$i","kind":13,"line":840},{"kind":13,"line":840,"name":"$self","containerName":"_cuts"},{"line":840,"kind":13,"name":"$enz","containerName":"_cuts"},{"kind":12,"line":840,"name":"name","containerName":"_cuts"},{"line":840,"kind":13,"name":"$self","containerName":"_cuts"},{"kind":13,"line":840,"containerName":"_cuts","name":"$enz"},{"kind":12,"line":840,"containerName":"_cuts","name":"name"}],"line":791},{"kind":13,"line":844,"name":"%self","containerName":null},{"line":844,"kind":13,"containerName":null,"name":"$enz"},{"containerName":"main::","name":"name","kind":12,"line":844},{"localvar":"my","name":"$number_of_cuts","definition":"my","containerName":null,"line":855,"kind":13},{"kind":13,"line":855,"containerName":null,"name":"%self"},{"name":"$enz","containerName":null,"line":855,"kind":13},{"kind":12,"line":855,"containerName":"main::","name":"name"},{"line":857,"kind":13,"containerName":null,"name":"%self"},{"line":857,"kind":12,"name":"_number_of_cuts_by_enzyme"},{"kind":13,"line":857,"containerName":null,"name":"$enz"},{"kind":12,"line":857,"containerName":"main::","name":"name"},{"kind":13,"line":857,"name":"$number_of_cuts","containerName":null},{"kind":13,"line":858,"name":"%self","containerName":null},{"name":"_number_of_cuts_by_cuts","kind":12,"line":858},{"kind":13,"line":858,"name":"$number_of_cuts","containerName":null},{"name":"$enz","containerName":null,"kind":13,"line":858},{"name":"$number_of_cuts","containerName":null,"line":859,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":859},{"name":"maximum_cuts","line":859,"kind":12},{"kind":13,"line":860,"name":"%self","containerName":null},{"name":"maximum_cuts","line":860,"kind":12},{"kind":13,"line":860,"containerName":null,"name":"$number_of_cuts"},{"kind":12,"line":878,"children":[{"containerName":"_enzyme_sites","name":"$self","definition":"my","localvar":"my","kind":13,"line":879},{"line":879,"kind":13,"containerName":"_enzyme_sites","name":"$enz"},{"name":"$comp","containerName":"_enzyme_sites","line":879,"kind":13},{"kind":13,"line":883,"definition":"my","name":"$site","containerName":"_enzyme_sites","localvar":"my"},{"line":883,"kind":13,"containerName":"_enzyme_sites","name":"$comp"},{"line":883,"kind":13,"containerName":"_enzyme_sites","name":"$enz"},{"name":"complementary_cut","containerName":"_enzyme_sites","line":883,"kind":12},{"line":883,"kind":13,"containerName":"_enzyme_sites","name":"$enz"},{"containerName":"_enzyme_sites","name":"cut","kind":12,"line":883},{"containerName":"_enzyme_sites","name":"$site","line":885,"kind":13},{"containerName":"_enzyme_sites","name":"$site","line":885,"kind":13},{"line":889,"kind":13,"localvar":"my","definition":"my","name":"$beforeseq","containerName":"_enzyme_sites"},{"name":"$afterseq","containerName":"_enzyme_sites","kind":13,"line":889},{"line":902,"kind":13,"containerName":"_enzyme_sites","name":"$site"},{"name":"$afterseq","containerName":"_enzyme_sites","kind":13,"line":903},{"containerName":"_enzyme_sites","name":"$enz","kind":13,"line":903},{"containerName":"_enzyme_sites","name":"string","kind":12,"line":903},{"containerName":"_enzyme_sites","name":"$site","line":905,"kind":13},{"line":905,"kind":13,"containerName":"_enzyme_sites","name":"$enz"},{"name":"seq","containerName":"_enzyme_sites","kind":12,"line":905},{"line":905,"kind":12,"name":"length","containerName":"_enzyme_sites"},{"kind":13,"line":906,"name":"$beforeseq","containerName":"_enzyme_sites"},{"containerName":"_enzyme_sites","name":"$enz","line":906,"kind":13},{"containerName":"_enzyme_sites","name":"string","line":906,"kind":12},{"containerName":"_enzyme_sites","name":"$beforeseq","kind":13,"line":909},{"containerName":"_enzyme_sites","name":"$enz","line":909,"kind":13},{"line":909,"kind":12,"name":"seq","containerName":"_enzyme_sites"},{"kind":12,"line":909,"name":"subseq","containerName":"_enzyme_sites"},{"containerName":"_enzyme_sites","name":"$site","kind":13,"line":909},{"containerName":"_enzyme_sites","name":"$afterseq","kind":13,"line":910},{"name":"$enz","containerName":"_enzyme_sites","line":910,"kind":13},{"kind":12,"line":910,"name":"seq","containerName":"_enzyme_sites"},{"line":910,"kind":12,"containerName":"_enzyme_sites","name":"subseq"},{"line":910,"kind":13,"containerName":"_enzyme_sites","name":"$site"},{"name":"$enz","containerName":"_enzyme_sites","kind":13,"line":910},{"line":910,"kind":12,"containerName":"_enzyme_sites","name":"seq"},{"name":"length","containerName":"_enzyme_sites","kind":12,"line":910},{"kind":13,"line":913,"containerName":"_enzyme_sites","name":"$enz"},{"containerName":"_enzyme_sites","name":"is_ambiguous","line":913,"kind":12},{"kind":13,"line":914,"name":"$beforeseq","containerName":"_enzyme_sites"},{"kind":13,"line":914,"name":"$self","containerName":"_enzyme_sites"},{"name":"_expanded_string","containerName":"_enzyme_sites","line":914,"kind":12},{"line":914,"kind":13,"name":"$beforeseq","containerName":"_enzyme_sites"},{"containerName":"_enzyme_sites","name":"$afterseq","kind":13,"line":915},{"kind":13,"line":915,"name":"$self","containerName":"_enzyme_sites"},{"containerName":"_enzyme_sites","name":"_expanded_string","kind":12,"line":915},{"containerName":"_enzyme_sites","name":"$afterseq","line":915,"kind":13},{"line":918,"kind":13,"name":"$beforeseq","containerName":"_enzyme_sites"},{"kind":13,"line":918,"containerName":"_enzyme_sites","name":"$afterseq"}],"containerName":"main::","definition":"sub","detail":"($self,$enz,$comp)","signature":{"parameters":[{"label":"$self"},{"label":"$enz"},{"label":"$comp"}],"documentation":"","label":"_enzyme_sites($self,$enz,$comp)"},"name":"_enzyme_sites","range":{"start":{"character":0,"line":878},"end":{"character":9999,"line":919}}},{"name":"_non_pal_enz","range":{"start":{"character":0,"line":934},"end":{"line":982,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_non_pal_enz($self,$target_seq,$enz)","documentation":"","parameters":[{"label":"$self"},{"label":"$target_seq"},{"label":"$enz"}]},"detail":"($self,$target_seq,$enz)","kind":12,"children":[{"localvar":"my","containerName":"_non_pal_enz","name":"$self","definition":"my","line":935,"kind":13},{"name":"$target_seq","containerName":"_non_pal_enz","kind":13,"line":935},{"kind":13,"line":935,"name":"$enz","containerName":"_non_pal_enz"},{"name":"$site","definition":"my","containerName":"_non_pal_enz","localvar":"my","kind":13,"line":939},{"kind":13,"line":939,"containerName":"_non_pal_enz","name":"$enz"},{"containerName":"_non_pal_enz","name":"complementary_cut","line":939,"kind":12},{"localvar":"my","containerName":"_non_pal_enz","definition":"my","name":"$beforeseq","line":951,"kind":13},{"name":"$afterseq","containerName":"_non_pal_enz","line":951,"kind":13},{"kind":13,"line":954,"name":"$new_left_cut","definition":"my","containerName":"_non_pal_enz","localvar":"my"},{"line":954,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"kind":12,"line":954,"containerName":"_non_pal_enz","name":"seq"},{"containerName":"_non_pal_enz","name":"length","kind":12,"line":954},{"kind":13,"line":954,"name":"$site","containerName":"_non_pal_enz"},{"kind":13,"line":957,"name":"$new_left_cut","containerName":"_non_pal_enz"},{"line":957,"kind":13,"containerName":"_non_pal_enz","name":"$afterseq"},{"kind":13,"line":957,"name":"$enz","containerName":"_non_pal_enz"},{"line":957,"kind":12,"containerName":"_non_pal_enz","name":"seq"},{"containerName":"_non_pal_enz","name":"revcom","kind":12,"line":957},{"name":"seq","containerName":"_non_pal_enz","line":957,"kind":12},{"kind":13,"line":958,"containerName":"_non_pal_enz","name":"$new_left_cut"},{"kind":13,"line":958,"name":"$enz","containerName":"_non_pal_enz"},{"name":"seq","containerName":"_non_pal_enz","kind":12,"line":958},{"line":958,"kind":12,"containerName":"_non_pal_enz","name":"length"},{"containerName":"_non_pal_enz","name":"$beforeseq","line":958,"kind":13},{"containerName":"_non_pal_enz","name":"$enz","kind":13,"line":958},{"kind":12,"line":958,"containerName":"_non_pal_enz","name":"seq"},{"line":958,"kind":12,"containerName":"_non_pal_enz","name":"revcom"},{"containerName":"_non_pal_enz","name":"seq","kind":12,"line":958},{"kind":13,"line":961,"name":"$beforeseq","containerName":"_non_pal_enz"},{"name":"$enz","containerName":"_non_pal_enz","kind":13,"line":961},{"line":961,"kind":12,"name":"seq","containerName":"_non_pal_enz"},{"name":"revcom","containerName":"_non_pal_enz","kind":12,"line":961},{"name":"subseq","containerName":"_non_pal_enz","kind":12,"line":961},{"line":961,"kind":13,"name":"$enz","containerName":"_non_pal_enz"},{"name":"seq","containerName":"_non_pal_enz","kind":12,"line":961},{"name":"length","containerName":"_non_pal_enz","kind":12,"line":961},{"kind":13,"line":961,"name":"$site","containerName":"_non_pal_enz"},{"containerName":"_non_pal_enz","name":"$afterseq","kind":13,"line":962},{"containerName":"_non_pal_enz","name":"$enz","line":962,"kind":13},{"containerName":"_non_pal_enz","name":"seq","line":962,"kind":12},{"name":"revcom","containerName":"_non_pal_enz","kind":12,"line":962},{"kind":12,"line":962,"name":"subseq","containerName":"_non_pal_enz"},{"containerName":"_non_pal_enz","name":"$enz","kind":13,"line":962},{"containerName":"_non_pal_enz","name":"seq","line":962,"kind":12},{"line":962,"kind":12,"containerName":"_non_pal_enz","name":"length"},{"name":"$site","containerName":"_non_pal_enz","kind":13,"line":962},{"name":"$enz","containerName":"_non_pal_enz","line":962,"kind":13},{"name":"seq","containerName":"_non_pal_enz","line":962,"kind":12},{"containerName":"_non_pal_enz","name":"length","kind":12,"line":962},{"line":969,"kind":13,"localvar":"my","containerName":"_non_pal_enz","name":"$results","definition":"my"},{"containerName":"_non_pal_enz","name":"$enz","kind":13,"line":970},{"kind":12,"line":970,"name":"is_ambiguous","containerName":"_non_pal_enz"},{"line":971,"kind":13,"containerName":"_non_pal_enz","name":"$results"},{"line":971,"kind":13,"name":"$self","containerName":"_non_pal_enz"},{"name":"_ambig_cuts","containerName":"_non_pal_enz","line":971,"kind":12},{"line":971,"kind":13,"name":"$beforeseq","containerName":"_non_pal_enz"},{"containerName":"_non_pal_enz","name":"$afterseq","kind":13,"line":971},{"line":971,"kind":13,"containerName":"_non_pal_enz","name":"$target_seq"},{"line":971,"kind":13,"name":"$enz","containerName":"_non_pal_enz"},{"line":973,"kind":13,"name":"$results","containerName":"_non_pal_enz"},{"kind":13,"line":973,"containerName":"_non_pal_enz","name":"$self"},{"line":973,"kind":12,"name":"_nonambig_cuts","containerName":"_non_pal_enz"},{"line":973,"kind":13,"containerName":"_non_pal_enz","name":"$beforeseq"},{"containerName":"_non_pal_enz","name":"$afterseq","line":973,"kind":13},{"containerName":"_non_pal_enz","name":"$target_seq","kind":13,"line":973},{"line":973,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"containerName":"_non_pal_enz","name":"$more_results","definition":"my","localvar":"my","kind":13,"line":977},{"name":"$more_results","containerName":"_non_pal_enz","kind":13,"line":978},{"name":"$self","containerName":"_non_pal_enz","kind":13,"line":978},{"kind":12,"line":978,"containerName":"_non_pal_enz","name":"_circular"},{"line":978,"kind":13,"name":"$beforeseq","containerName":"_non_pal_enz"},{"line":978,"kind":13,"containerName":"_non_pal_enz","name":"$afterseq"},{"line":978,"kind":13,"name":"$enz","containerName":"_non_pal_enz"},{"containerName":"_non_pal_enz","name":"$self","line":979,"kind":13},{"line":979,"kind":12,"name":"is_circular","containerName":"_non_pal_enz"},{"line":981,"kind":13,"containerName":"_non_pal_enz","name":"$more_results"},{"name":"$results","containerName":"_non_pal_enz","kind":13,"line":981}],"line":934},{"name":"_ambig_cuts_depr","range":{"end":{"line":1072,"character":9999},"start":{"line":1000,"character":0}},"kind":12,"line":1000,"children":[{"line":1001,"kind":13,"localvar":"my","containerName":"_ambig_cuts_depr","name":"$self","definition":"my"},{"containerName":"_ambig_cuts_depr","name":"$beforeseq","line":1001,"kind":13},{"name":"$afterseq","containerName":"_ambig_cuts_depr","kind":13,"line":1001},{"containerName":"_ambig_cuts_depr","name":"$target_seq","line":1001,"kind":13},{"containerName":"_ambig_cuts_depr","name":"$enz","kind":13,"line":1001},{"name":"$target_seq","containerName":"_ambig_cuts_depr","line":1005,"kind":13},{"containerName":"_ambig_cuts_depr","name":"$target_seq","line":1005,"kind":13},{"localvar":"my","containerName":"_ambig_cuts_depr","definition":"my","name":"@cuts","line":1006,"kind":13},{"name":"$target_seq","containerName":"_ambig_cuts_depr","kind":13,"line":1006},{"line":1018,"kind":13,"localvar":"my","containerName":"_ambig_cuts_depr","name":"$i","definition":"my"},{"containerName":"_ambig_cuts_depr","name":"@re_frags","definition":"my","localvar":"my","kind":13,"line":1019},{"kind":13,"line":1021,"containerName":"_ambig_cuts_depr","name":"$i"},{"line":1022,"kind":13,"localvar":"my","definition":"my","name":"$joinedseq","containerName":"_ambig_cuts_depr"},{"containerName":"_ambig_cuts_depr","name":"$i","line":1024,"kind":13},{"name":"$joinedseq","containerName":"_ambig_cuts_depr","kind":13,"line":1025},{"line":1025,"kind":13,"name":"$cuts","containerName":"_ambig_cuts_depr"},{"name":"$i","containerName":"_ambig_cuts_depr","line":1025,"kind":13},{"line":1025,"kind":13,"containerName":"_ambig_cuts_depr","name":"$cuts"},{"line":1025,"kind":13,"name":"$i","containerName":"_ambig_cuts_depr"},{"containerName":"_ambig_cuts_depr","name":"$joinedseq","line":1027,"kind":13},{"name":"$cuts","containerName":"_ambig_cuts_depr","line":1027,"kind":13},{"line":1027,"kind":13,"name":"$i","containerName":"_ambig_cuts_depr"},{"kind":13,"line":1027,"name":"$cuts","containerName":"_ambig_cuts_depr"},{"name":"$i","containerName":"_ambig_cuts_depr","line":1027,"kind":13},{"kind":13,"line":1027,"name":"$cuts","containerName":"_ambig_cuts_depr"},{"line":1027,"kind":13,"name":"$i","containerName":"_ambig_cuts_depr"},{"line":1033,"kind":13,"name":"$joinedseq","containerName":"_ambig_cuts_depr"},{"line":1034,"kind":13,"name":"$joinedseq","containerName":"_ambig_cuts_depr"},{"line":1035,"kind":13,"name":"@re_frags","containerName":"_ambig_cuts_depr"},{"containerName":"_ambig_cuts_depr","name":"@re_frags","kind":13,"line":1037},{"containerName":"_ambig_cuts_depr","name":"$joinedseq","kind":13,"line":1037},{"containerName":"_ambig_cuts_depr","name":"$i","line":1038,"kind":13},{"line":1060,"kind":13,"localvar":"my","name":"@cut_positions","definition":"my","containerName":"_ambig_cuts_depr"},{"name":"@re_frags","containerName":"_ambig_cuts_depr","kind":13,"line":1060},{"name":"$i","definition":"my","containerName":"_ambig_cuts_depr","localvar":"my","kind":13,"line":1065},{"containerName":"_ambig_cuts_depr","name":"$i","kind":13,"line":1065},{"containerName":"_ambig_cuts_depr","name":"$i","line":1065,"kind":13},{"line":1066,"kind":13,"containerName":"_ambig_cuts_depr","name":"$cut_positions"},{"name":"$i","containerName":"_ambig_cuts_depr","line":1066,"kind":13},{"kind":13,"line":1066,"containerName":"_ambig_cuts_depr","name":"$cut_positions"},{"line":1066,"kind":13,"containerName":"_ambig_cuts_depr","name":"$i"},{"line":1071,"kind":13,"containerName":"_ambig_cuts_depr","name":"@cut_positions"}],"containerName":"main::","definition":"sub","detail":"($self,$beforeseq,$afterseq,$target_seq,$enz)","signature":{"label":"_ambig_cuts_depr($self,$beforeseq,$afterseq,$target_seq,$enz)","parameters":[{"label":"$self"},{"label":"$beforeseq"},{"label":"$afterseq"},{"label":"$target_seq"},{"label":"$enz"}],"documentation":""}},{"line":1020,"kind":12,"name":"cuts"},{"line":1021,"kind":12,"name":"cuts"},{"name":"cut_positions","line":1065,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$before,$after,$target,$enz,$comp)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$before"},{"label":"$after"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}],"label":"_ambig_cuts($self,$before,$after,$target,$enz,$comp)"},"kind":12,"line":1076,"children":[{"kind":13,"line":1077,"containerName":"_ambig_cuts","definition":"my","name":"$self","localvar":"my"},{"containerName":"_ambig_cuts","name":"$before","line":1077,"kind":13},{"containerName":"_ambig_cuts","name":"$after","line":1077,"kind":13},{"kind":13,"line":1077,"name":"$target","containerName":"_ambig_cuts"},{"kind":13,"line":1077,"name":"$enz","containerName":"_ambig_cuts"},{"name":"$comp","containerName":"_ambig_cuts","line":1077,"kind":13},{"kind":13,"line":1078,"name":"$cut_site","definition":"my","containerName":"_ambig_cuts","localvar":"my"},{"containerName":"_ambig_cuts","name":"$comp","line":1078,"kind":13},{"containerName":"_ambig_cuts","name":"$enz","line":1078,"kind":13},{"containerName":"_ambig_cuts","name":"complementary_cut","kind":12,"line":1078},{"line":1078,"kind":13,"containerName":"_ambig_cuts","name":"$enz"},{"line":1078,"kind":12,"containerName":"_ambig_cuts","name":"cut"},{"line":1079,"kind":13,"name":"$target","containerName":"_ambig_cuts"},{"localvar":"my","containerName":"_ambig_cuts","definition":"my","name":"@cuts","line":1080,"kind":13},{"kind":13,"line":1081,"definition":"my","name":"$recog","containerName":"_ambig_cuts","localvar":"my"},{"line":1081,"kind":13,"containerName":"_ambig_cuts","name":"$enz"},{"kind":12,"line":1081,"name":"recog","containerName":"_ambig_cuts"},{"localvar":"my","name":"$site_re","definition":"my","containerName":"_ambig_cuts","line":1082,"kind":13},{"name":"@cuts","containerName":"_ambig_cuts","line":1083,"kind":13},{"containerName":"_ambig_cuts","name":"$enz","kind":13,"line":1084},{"line":1084,"kind":12,"name":"recog","containerName":"_ambig_cuts"},{"name":"$cut_site","containerName":"_ambig_cuts","kind":13,"line":1084},{"name":"@cuts","containerName":"_ambig_cuts","line":1084,"kind":13},{"containerName":"_ambig_cuts","name":"@cuts","kind":13,"line":1085}],"name":"_ambig_cuts","range":{"start":{"line":1076,"character":0},"end":{"line":1086,"character":9999}}},{"kind":12,"line":1104,"children":[{"localvar":"my","containerName":"_nonambig_cuts","name":"$self","definition":"my","line":1105,"kind":13},{"containerName":"_nonambig_cuts","name":"$beforeseq","kind":13,"line":1105},{"kind":13,"line":1105,"containerName":"_nonambig_cuts","name":"$afterseq"},{"name":"$target_seq","containerName":"_nonambig_cuts","line":1105,"kind":13},{"kind":13,"line":1105,"containerName":"_nonambig_cuts","name":"$enz"},{"containerName":"_nonambig_cuts","name":"$comp","kind":13,"line":1105},{"localvar":"my","containerName":"_nonambig_cuts","definition":"my","name":"$cut_site","line":1106,"kind":13},{"line":1106,"kind":13,"containerName":"_nonambig_cuts","name":"$comp"},{"containerName":"_nonambig_cuts","name":"$enz","kind":13,"line":1106},{"containerName":"_nonambig_cuts","name":"complementary_cut","line":1106,"kind":12},{"name":"$enz","containerName":"_nonambig_cuts","kind":13,"line":1106},{"kind":12,"line":1106,"name":"cut","containerName":"_nonambig_cuts"},{"line":1107,"kind":13,"containerName":"_nonambig_cuts","name":"$beforeseq"},{"kind":13,"line":1107,"containerName":"_nonambig_cuts","name":"$beforeseq"},{"containerName":"_nonambig_cuts","name":"$afterseq","line":1108,"kind":13},{"name":"$afterseq","containerName":"_nonambig_cuts","line":1108,"kind":13},{"containerName":"_nonambig_cuts","name":"$target_seq","kind":13,"line":1109},{"kind":13,"line":1109,"containerName":"_nonambig_cuts","name":"$target_seq"},{"kind":13,"line":1111,"containerName":"_nonambig_cuts","name":"$index_posn","definition":"my","localvar":"my"},{"name":"$target_seq","containerName":"_nonambig_cuts","line":1111,"kind":13},{"line":1111,"kind":13,"containerName":"_nonambig_cuts","name":"$enz"},{"line":1111,"kind":12,"containerName":"_nonambig_cuts","name":"recog"},{"containerName":"_nonambig_cuts","name":"$index_posn","line":1112,"kind":13},{"kind":13,"line":1115,"containerName":"_nonambig_cuts","definition":"my","name":"@cuts","localvar":"my"},{"line":1116,"kind":13,"containerName":"_nonambig_cuts","name":"$index_posn"},{"name":"@cuts","containerName":"_nonambig_cuts","line":1120,"kind":13},{"containerName":"_nonambig_cuts","name":"$index_posn","line":1120,"kind":13},{"line":1120,"kind":13,"containerName":"_nonambig_cuts","name":"$cut_site"},{"containerName":"_nonambig_cuts","name":"$index_posn","line":1122,"kind":13},{"line":1122,"kind":13,"name":"$target_seq","containerName":"_nonambig_cuts"},{"containerName":"_nonambig_cuts","name":"$enz","kind":13,"line":1122},{"kind":12,"line":1122,"name":"recog","containerName":"_nonambig_cuts"},{"line":1122,"kind":13,"name":"$index_posn","containerName":"_nonambig_cuts"},{"line":1125,"kind":13,"name":"@cuts","containerName":"_nonambig_cuts"}],"containerName":"main::","definition":"sub","detail":"($self,$beforeseq,$afterseq,$target_seq,$enz,$comp)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$beforeseq"},{"label":"$afterseq"},{"label":"$target_seq"},{"label":"$enz"},{"label":"$comp"}],"label":"_nonambig_cuts($self,$beforeseq,$afterseq,$target_seq,$enz,$comp)"},"name":"_nonambig_cuts","range":{"start":{"line":1104,"character":0},"end":{"line":1126,"character":9999}}},{"containerName":"main::","definition":"sub","detail":"($self,$target,$enz,$comp)","signature":{"label":"_make_cuts($self,$target,$enz,$comp)","documentation":"","parameters":[{"label":"$self"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}]},"kind":12,"line":1141,"children":[{"containerName":"_make_cuts","definition":"my","name":"$self","localvar":"my","kind":13,"line":1144},{"kind":13,"line":1144,"name":"$target","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$enz","kind":13,"line":1144},{"containerName":"_make_cuts","name":"$comp","kind":13,"line":1144},{"containerName":"_make_cuts","name":"$target","line":1145,"kind":13},{"localvar":"my","definition":"my","name":"@cuts","containerName":"_make_cuts","line":1147,"kind":13},{"localvar":"my","definition":"my","name":"@enzs","containerName":"_make_cuts","line":1149,"kind":13},{"containerName":"_make_cuts","name":"$enz","kind":13,"line":1149},{"name":"$enz","containerName":"_make_cuts","line":1149,"kind":13},{"containerName":"_make_cuts","name":"can","kind":12,"line":1149},{"name":"$enz","containerName":"_make_cuts","line":1149,"kind":13},{"name":"others","containerName":"_make_cuts","line":1149,"kind":12},{"line":1151,"kind":13,"name":"$enz","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"@enzs","kind":13,"line":1151},{"localvar":"my","name":"$recog","definition":"my","containerName":"_make_cuts","line":1152,"kind":13},{"line":1152,"kind":13,"name":"$enz","containerName":"_make_cuts"},{"kind":12,"line":1152,"containerName":"_make_cuts","name":"recog"},{"containerName":"_make_cuts","name":"$cut_site","definition":"my","localvar":"my","kind":13,"line":1153},{"line":1153,"kind":13,"name":"$comp","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$enz","kind":13,"line":1153},{"name":"complementary_cut","containerName":"_make_cuts","kind":12,"line":1153},{"containerName":"_make_cuts","name":"$enz","line":1153,"kind":13},{"name":"cut","containerName":"_make_cuts","kind":12,"line":1153},{"localvar":"my","definition":"my","name":"@these_cuts","containerName":"_make_cuts","line":1154,"kind":13},{"name":"$recog","containerName":"_make_cuts","line":1156,"kind":13},{"kind":13,"line":1157,"containerName":"_make_cuts","name":"$site_re","definition":"my","localvar":"my"},{"line":1158,"kind":13,"name":"@these_cuts","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$enz","kind":13,"line":1159},{"kind":12,"line":1159,"name":"string","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$cut_site","kind":13,"line":1159},{"containerName":"_make_cuts","name":"@these_cuts","line":1159,"kind":13},{"name":"$enz","containerName":"_make_cuts","line":1160,"kind":13},{"containerName":"_make_cuts","name":"is_palindromic","kind":12,"line":1160},{"containerName":"_make_cuts","name":"@these_rev_cuts","definition":"my","localvar":"my","kind":13,"line":1162},{"line":1163,"kind":13,"name":"$recog","containerName":"_make_cuts"},{"line":1163,"kind":13,"containerName":"_make_cuts","name":"$enz"},{"name":"revcom_recog","containerName":"_make_cuts","line":1163,"kind":12},{"name":"$cut_site","containerName":"_make_cuts","kind":13,"line":1164},{"kind":13,"line":1164,"name":"$enz","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"string","kind":12,"line":1164},{"name":"$comp","containerName":"_make_cuts","kind":13,"line":1164},{"kind":13,"line":1164,"containerName":"_make_cuts","name":"$enz"},{"containerName":"_make_cuts","name":"cut","line":1164,"kind":12},{"kind":13,"line":1164,"name":"$enz","containerName":"_make_cuts"},{"line":1164,"kind":12,"name":"complementary_cut","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$site_re","kind":13,"line":1165},{"name":"@these_rev_cuts","containerName":"_make_cuts","line":1166,"kind":13},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1167},{"kind":12,"line":1167,"name":"string","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$cut_site","kind":13,"line":1167},{"name":"@these_rev_cuts","containerName":"_make_cuts","kind":13,"line":1167},{"line":1168,"kind":13,"name":"@these_cuts","containerName":"_make_cuts"},{"kind":13,"line":1168,"containerName":"_make_cuts","name":"@these_rev_cuts"},{"containerName":"_make_cuts","name":"$index_posn","definition":"my","localvar":"my","kind":13,"line":1172},{"line":1172,"kind":13,"containerName":"_make_cuts","name":"$recog"},{"kind":13,"line":1173,"containerName":"_make_cuts","name":"$index_posn"},{"line":1174,"kind":13,"name":"@these_cuts","containerName":"_make_cuts"},{"line":1174,"kind":13,"name":"$index_posn","containerName":"_make_cuts"},{"name":"$cut_site","containerName":"_make_cuts","line":1174,"kind":13},{"kind":13,"line":1175,"containerName":"_make_cuts","name":"$index_posn"},{"kind":13,"line":1175,"name":"$recog","containerName":"_make_cuts"},{"containerName":"_make_cuts","name":"$index_posn","line":1175,"kind":13},{"name":"$enz","containerName":"_make_cuts","line":1177,"kind":13},{"name":"is_palindromic","containerName":"_make_cuts","line":1177,"kind":12},{"line":1178,"kind":13,"containerName":"_make_cuts","name":"$recog"},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1178},{"line":1178,"kind":12,"containerName":"_make_cuts","name":"revcom_recog"},{"name":"$cut_site","containerName":"_make_cuts","line":1179,"kind":13},{"containerName":"_make_cuts","name":"$enz","kind":13,"line":1179},{"line":1179,"kind":12,"containerName":"_make_cuts","name":"string"},{"kind":13,"line":1179,"containerName":"_make_cuts","name":"$comp"},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1179},{"kind":12,"line":1179,"containerName":"_make_cuts","name":"cut"},{"kind":13,"line":1179,"containerName":"_make_cuts","name":"$enz"},{"containerName":"_make_cuts","name":"complementary_cut","line":1179,"kind":12},{"line":1180,"kind":13,"name":"$index_posn","containerName":"_make_cuts"},{"kind":13,"line":1180,"containerName":"_make_cuts","name":"$recog"},{"containerName":"_make_cuts","name":"$index_posn","line":1181,"kind":13},{"line":1182,"kind":13,"name":"@these_cuts","containerName":"_make_cuts"},{"line":1182,"kind":13,"name":"$index_posn","containerName":"_make_cuts"},{"line":1182,"kind":13,"containerName":"_make_cuts","name":"$cut_site"},{"line":1183,"kind":13,"containerName":"_make_cuts","name":"$index_posn"},{"name":"$recog","containerName":"_make_cuts","line":1183,"kind":13},{"containerName":"_make_cuts","name":"$index_posn","line":1183,"kind":13},{"kind":13,"line":1187,"containerName":"_make_cuts","name":"@cuts"},{"containerName":"_make_cuts","name":"@these_cuts","kind":13,"line":1187},{"kind":13,"line":1189,"name":"@cuts","containerName":"_make_cuts"}],"name":"_make_cuts","range":{"end":{"line":1190,"character":9999},"start":{"line":1141,"character":0}}},{"name":"warnings","line":1142,"kind":12},{"name":"ENZ","kind":12,"line":1150},{"name":"_multiple_cuts","range":{"start":{"line":1203,"character":0},"end":{"character":9999,"line":1213}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$ec"}],"label":"_multiple_cuts($self,$ec)"},"detail":"($self,$ec)","kind":12,"children":[{"localvar":"my","containerName":"_multiple_cuts","definition":"my","name":"$self","line":1204,"kind":13},{"line":1204,"kind":13,"name":"$ec","containerName":"_multiple_cuts"},{"containerName":"_multiple_cuts","name":"$self","line":1205,"kind":13},{"line":1205,"kind":12,"containerName":"_multiple_cuts","name":"cut"},{"containerName":"_multiple_cuts","name":"$self","line":1205,"kind":13},{"line":1209,"kind":13,"localvar":"my","definition":"my","name":"@cuts","containerName":"_multiple_cuts"},{"kind":13,"line":1210,"containerName":"_multiple_cuts","name":"$enz","definition":"my","localvar":"my"},{"line":1210,"kind":13,"containerName":"_multiple_cuts","name":"$ec"},{"name":"each_enzyme","containerName":"_multiple_cuts","kind":12,"line":1210},{"name":"@cuts","containerName":"_multiple_cuts","kind":13,"line":1211},{"name":"$self","containerName":"_multiple_cuts","line":1211,"kind":13},{"line":1211,"kind":13,"containerName":"_multiple_cuts","name":"$enz"},{"containerName":"_multiple_cuts","name":"name","kind":12,"line":1211},{"containerName":"_multiple_cuts","name":"$self","kind":13,"line":1212},{"line":1212,"kind":13,"name":"$enz","containerName":"_multiple_cuts"},{"kind":12,"line":1212,"containerName":"_multiple_cuts","name":"name"}],"line":1203},{"line":1214,"kind":13,"containerName":null,"name":"%self"},{"name":"$a","containerName":null,"kind":13,"line":1214},{"kind":13,"line":1214,"name":"$b","containerName":null},{"name":"@cuts","containerName":null,"kind":13,"line":1214},{"name":"$number_of_cuts","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1216},{"containerName":null,"name":"$number_of_cuts","line":1218,"kind":13},{"kind":13,"line":1218,"name":"%self","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":1219},{"name":"_number_of_cuts_by_enzyme","line":1219,"kind":12},{"line":1219,"kind":13,"containerName":null,"name":"$number_of_cuts"},{"line":1220,"kind":13,"name":"%self","containerName":null},{"line":1220,"kind":12,"name":"_number_of_cuts_by_cuts"},{"containerName":null,"name":"$number_of_cuts","line":1220,"kind":13},{"containerName":null,"name":"$number_of_cuts","line":1221,"kind":13},{"line":1221,"kind":13,"containerName":null,"name":"%self"},{"name":"maximum_cuts","kind":12,"line":1221},{"kind":13,"line":1222,"name":"%self","containerName":null},{"kind":12,"line":1222,"name":"maximum_cuts"},{"name":"$number_of_cuts","containerName":null,"kind":13,"line":1222},{"name":"_circular","range":{"end":{"character":9999,"line":1280},"start":{"line":1237,"character":0}},"kind":12,"line":1237,"children":[{"line":1238,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_circular"},{"containerName":"_circular","name":"$target","line":1238,"kind":13},{"containerName":"_circular","name":"$enz","kind":13,"line":1238},{"containerName":"_circular","name":"$comp","kind":13,"line":1238},{"containerName":"_circular","name":"$target","kind":13,"line":1239},{"containerName":"_circular","name":"$target","line":1239,"kind":13},{"line":1240,"kind":13,"localvar":"my","name":"$patch_len","definition":"my","containerName":"_circular"},{"containerName":"_circular","name":"$target","line":1240,"kind":13},{"name":"$target","containerName":"_circular","kind":13,"line":1240},{"line":1242,"kind":13,"localvar":"my","definition":"my","name":"$first","containerName":"_circular"},{"containerName":"_circular","name":"$last","kind":13,"line":1242},{"name":"$target","containerName":"_circular","line":1243,"kind":13},{"containerName":"_circular","name":"$patch_len","kind":13,"line":1243},{"line":1243,"kind":13,"containerName":"_circular","name":"$target"},{"kind":13,"line":1243,"name":"$patch_len","containerName":"_circular"},{"localvar":"my","definition":"my","name":"$patch","containerName":"_circular","line":1244,"kind":13},{"line":1244,"kind":13,"name":"$last","containerName":"_circular"},{"kind":13,"line":1244,"containerName":"_circular","name":"$first"},{"localvar":"my","name":"$cut_positions","definition":"my","containerName":"_circular","line":1248,"kind":13},{"line":1248,"kind":13,"containerName":"_circular","name":"$self"},{"kind":12,"line":1248,"name":"_make_cuts","containerName":"_circular"},{"containerName":"_circular","name":"$patch","kind":13,"line":1248},{"line":1248,"kind":13,"name":"$enz","containerName":"_circular"},{"line":1248,"kind":13,"name":"$comp","containerName":"_circular"},{"containerName":"_circular","name":"$cut_positions","line":1251,"kind":13},{"localvar":"my","containerName":"_circular","name":"@circ_cuts","definition":"my","line":1258,"kind":13},{"kind":13,"line":1259,"definition":"my","name":"$cut","containerName":"_circular","localvar":"my"},{"line":1259,"kind":13,"containerName":"_circular","name":"$cut_positions"},{"name":"$cut","containerName":"_circular","line":1260,"kind":13},{"name":"$last","containerName":"_circular","line":1260,"kind":13},{"line":1264,"kind":13,"containerName":"_circular","name":"@circ_cuts"},{"kind":13,"line":1267,"name":"$cut","containerName":"_circular"},{"line":1267,"kind":13,"containerName":"_circular","name":"$last"},{"line":1270,"kind":13,"containerName":"_circular","name":"@circ_cuts"},{"name":"$self","containerName":"_circular","line":1270,"kind":13},{"name":"length","containerName":"_circular","kind":12,"line":1270},{"name":"$last","containerName":"_circular","kind":13,"line":1270},{"name":"$cut","containerName":"_circular","kind":13,"line":1270},{"kind":13,"line":1276,"name":"@circ_cuts","containerName":"_circular"},{"name":"$cut-length","containerName":"_circular","kind":13,"line":1276},{"line":1276,"kind":13,"name":"$last","containerName":"_circular"},{"name":"@circ_cuts","containerName":"_circular","kind":13,"line":1279}],"containerName":"main::","definition":"sub","detail":"($self,$target,$enz,$comp)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}],"label":"_circular($self,$target,$enz,$comp)"}},{"range":{"end":{"line":1314,"character":9999},"start":{"line":1298,"character":0}},"name":"_expanded_string","signature":{"label":"_expanded_string($self,$str)","documentation":"","parameters":[{"label":"$self"},{"label":"$str"}]},"detail":"($self,$str)","definition":"sub","containerName":"main::","children":[{"containerName":"_expanded_string","name":"$self","definition":"my","localvar":"my","kind":13,"line":1299},{"line":1299,"kind":13,"name":"$str","containerName":"_expanded_string"},{"containerName":"_expanded_string","name":"$str","line":1301,"kind":13},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1302},{"kind":13,"line":1303,"name":"$str","containerName":"_expanded_string"},{"containerName":"_expanded_string","name":"$str","kind":13,"line":1304},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1305},{"kind":13,"line":1306,"containerName":"_expanded_string","name":"$str"},{"containerName":"_expanded_string","name":"$str","kind":13,"line":1307},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1308},{"line":1309,"kind":13,"name":"$str","containerName":"_expanded_string"},{"kind":13,"line":1310,"name":"$str","containerName":"_expanded_string"},{"containerName":"_expanded_string","name":"$str","line":1311,"kind":13},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1313}],"line":1298,"kind":12}],"version":5}