{"version":5,"vars":[{"name":"vars","containerName":"","line":94,"kind":2},{"line":96,"kind":2,"name":"base","containerName":""},{"containerName":null,"name":"%STRAND_OPTIONS","line":100,"kind":13},{"name":"_strong","range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":117}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$r1"},{"label":"$r2"}],"documentation":" utility methods\n\n returns true if strands are equal and non-zero","label":"_strong($r1,$r2)"},"detail":"($r1,$r2)","kind":12,"children":[{"line":113,"kind":13,"localvar":"my","name":"$r1","definition":"my","containerName":"_strong"},{"containerName":"_strong","name":"$r2","kind":13,"line":113},{"localvar":"my","containerName":"_strong","definition":"my","name":"$s1","line":114,"kind":13},{"line":114,"kind":13,"name":"$s2","containerName":"_strong"},{"containerName":"_strong","name":"$r1","kind":13,"line":114},{"name":"strand","containerName":"_strong","kind":12,"line":114},{"kind":13,"line":114,"name":"$r2","containerName":"_strong"},{"name":"strand","containerName":"_strong","line":114,"kind":12},{"containerName":"_strong","name":"$s1","line":116,"kind":13},{"kind":13,"line":116,"containerName":"_strong","name":"$s1"},{"kind":13,"line":116,"name":"$s2","containerName":"_strong"}],"line":112},{"containerName":"main::","definition":"sub","detail":"($r1,$r2)","signature":{"documentation":" returns true if strands are equal or either is zero","parameters":[{"label":"$r1"},{"label":"$r2"}],"label":"_weak($r1,$r2)"},"kind":12,"line":120,"children":[{"containerName":"_weak","name":"$r1","definition":"my","localvar":"my","kind":13,"line":121},{"name":"$r2","containerName":"_weak","line":121,"kind":13},{"kind":13,"line":122,"containerName":"_weak","name":"$s1","definition":"my","localvar":"my"},{"line":122,"kind":13,"containerName":"_weak","name":"$s2"},{"name":"$r1","containerName":"_weak","line":122,"kind":13},{"line":122,"kind":12,"name":"strand","containerName":"_weak"},{"kind":13,"line":122,"name":"$r2","containerName":"_weak"},{"line":122,"kind":12,"containerName":"_weak","name":"strand"},{"containerName":"_weak","name":"$s1","kind":13,"line":123},{"containerName":"_weak","name":"$s2","line":123,"kind":13},{"name":"$s1","containerName":"_weak","line":123,"kind":13},{"containerName":"_weak","name":"$s2","kind":13,"line":123}],"name":"_weak","range":{"start":{"character":0,"line":120},"end":{"line":124,"character":9999}}},{"children":[],"line":127,"kind":12,"range":{"start":{"line":127,"character":0},"end":{"line":129,"character":9999}},"name":"_ignore","definition":"sub","containerName":"main::"},{"name":"_testStrand","range":{"end":{"character":9999,"line":138},"start":{"character":0,"line":133}},"kind":12,"line":133,"children":[{"localvar":"my","containerName":"_testStrand","definition":"my","name":"$r1","line":134,"kind":13},{"kind":13,"line":134,"containerName":"_testStrand","name":"$r2"},{"kind":13,"line":134,"name":"$comp","containerName":"_testStrand"},{"kind":13,"line":135,"name":"$comp","containerName":"_testStrand"},{"line":136,"kind":13,"localvar":"my","name":"$func","definition":"my","containerName":"_testStrand"},{"name":"$STRAND_OPTIONS","containerName":"_testStrand","line":136,"kind":13},{"containerName":"_testStrand","name":"$comp","line":136,"kind":13},{"name":"$r1","containerName":"_testStrand","line":137,"kind":13},{"kind":13,"line":137,"name":"$func","containerName":"_testStrand"},{"kind":13,"line":137,"containerName":"_testStrand","name":"$r2"}],"containerName":"main::","definition":"sub","detail":"()","signature":{"documentation":" works out what test to use for the strictness and returns true/false\n e.g. $r1->_testStrand($r2, 'strong')","parameters":[],"label":"_testStrand()"}},{"name":"start","definition":"sub","containerName":"main::","range":{"end":{"line":157,"character":9999},"start":{"line":155,"character":0}},"kind":12,"children":[{"kind":12,"line":156,"containerName":"start","name":"throw_not_implemented"}],"line":155},{"definition":"sub","name":"end","containerName":"main::","range":{"start":{"line":170,"character":0},"end":{"line":172,"character":9999}},"kind":12,"children":[{"line":171,"kind":12,"name":"throw_not_implemented","containerName":"end"}],"line":170},{"kind":12,"children":[{"line":186,"kind":12,"containerName":"length","name":"throw_not_implemented"}],"line":185,"name":"length","definition":"sub","containerName":"main::","range":{"start":{"line":185,"character":0},"end":{"line":187,"character":9999}}},{"kind":12,"line":200,"children":[{"name":"throw_not_implemented","containerName":"strand","kind":12,"line":201}],"containerName":"main::","definition":"sub","name":"strand","range":{"start":{"character":0,"line":200},"end":{"line":202,"character":9999}}},{"name":"overlaps","range":{"start":{"character":0,"line":222},"end":{"line":238,"character":9999}},"kind":12,"line":222,"children":[{"definition":"my","name":"$self","containerName":"overlaps","localvar":"my","kind":13,"line":223},{"name":"$other","containerName":"overlaps","line":223,"kind":13},{"line":223,"kind":13,"name":"$so","containerName":"overlaps"},{"line":225,"kind":13,"containerName":"overlaps","name":"$self"},{"containerName":"overlaps","name":"throw","line":225,"kind":12},{"line":225,"kind":13,"name":"$self","containerName":"overlaps"},{"containerName":"overlaps","name":"start","line":225,"kind":12},{"line":226,"kind":13,"name":"$self","containerName":"overlaps"},{"containerName":"overlaps","name":"throw","kind":12,"line":226},{"line":226,"kind":13,"containerName":"overlaps","name":"$self"},{"line":226,"kind":12,"name":"end","containerName":"overlaps"},{"line":227,"kind":13,"name":"$self","containerName":"overlaps"},{"containerName":"overlaps","name":"throw","kind":12,"line":227},{"kind":13,"line":227,"name":"$other","containerName":"overlaps"},{"kind":13,"line":228,"name":"$other","containerName":"overlaps"},{"kind":12,"line":228,"name":"isa","containerName":"overlaps"},{"line":229,"kind":13,"containerName":"overlaps","name":"$other"},{"kind":12,"line":229,"name":"throw","containerName":"overlaps"},{"kind":13,"line":229,"name":"$other","containerName":"overlaps"},{"containerName":"overlaps","name":"start","kind":12,"line":229},{"kind":13,"line":230,"name":"$other","containerName":"overlaps"},{"containerName":"overlaps","name":"throw","kind":12,"line":230},{"name":"$other","containerName":"overlaps","line":230,"kind":13},{"containerName":"overlaps","name":"end","kind":12,"line":230},{"containerName":"overlaps","name":"$self","kind":13,"line":233},{"kind":12,"line":233,"name":"_testStrand","containerName":"overlaps"},{"containerName":"overlaps","name":"$other","kind":13,"line":233},{"name":"$so","containerName":"overlaps","line":233,"kind":13},{"name":"$self","containerName":"overlaps","line":235,"kind":13},{"name":"start","containerName":"overlaps","kind":12,"line":235},{"name":"$other","containerName":"overlaps","kind":13,"line":235},{"containerName":"overlaps","name":"end","line":235,"kind":12},{"kind":13,"line":236,"containerName":"overlaps","name":"$self"},{"containerName":"overlaps","name":"end","kind":12,"line":236},{"kind":13,"line":236,"containerName":"overlaps","name":"$other"},{"name":"start","containerName":"overlaps","kind":12,"line":236}],"containerName":"main::","definition":"sub","detail":"($self,$other,$so)","signature":{"parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise","label":"overlaps($self,$other,$so)"}},{"name":"contains","range":{"start":{"character":0,"line":252},"end":{"character":9999,"line":269}},"containerName":"main::","definition":"sub","detail":"($self,$other,$so)","signature":{"label":"contains($self,$other,$so)","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}]},"kind":12,"line":252,"children":[{"kind":13,"line":253,"definition":"my","name":"$self","containerName":"contains","localvar":"my"},{"kind":13,"line":253,"name":"$other","containerName":"contains"},{"line":253,"kind":13,"name":"$so","containerName":"contains"},{"containerName":"contains","name":"$self","kind":13,"line":254},{"containerName":"contains","name":"throw","kind":12,"line":254},{"containerName":"contains","name":"$self","line":254,"kind":13},{"kind":12,"line":254,"containerName":"contains","name":"start"},{"name":"$self","containerName":"contains","line":255,"kind":13},{"containerName":"contains","name":"throw","line":255,"kind":12},{"line":255,"kind":13,"name":"$self","containerName":"contains"},{"line":255,"kind":12,"containerName":"contains","name":"end"},{"kind":13,"line":257,"containerName":"contains","name":"$other"},{"line":257,"kind":13,"containerName":"contains","name":"$other"},{"containerName":"contains","name":"$other","line":258,"kind":13},{"line":258,"kind":12,"name":"throw","containerName":"contains"},{"name":"$other","containerName":"contains","line":258,"kind":13},{"containerName":"contains","name":"isa","kind":12,"line":258},{"containerName":"contains","name":"$other","line":259,"kind":13},{"line":259,"kind":12,"name":"throw","containerName":"contains"},{"name":"$other","containerName":"contains","line":259,"kind":13},{"containerName":"contains","name":"start","line":259,"kind":12},{"containerName":"contains","name":"$other","kind":13,"line":260},{"containerName":"contains","name":"throw","line":260,"kind":12},{"containerName":"contains","name":"$other","kind":13,"line":260},{"name":"end","containerName":"contains","kind":12,"line":260},{"containerName":"contains","name":"$self","kind":13,"line":262},{"containerName":"contains","name":"_testStrand","line":262,"kind":12},{"name":"$other","containerName":"contains","kind":13,"line":262},{"name":"$so","containerName":"contains","line":262,"kind":13},{"name":"$other","containerName":"contains","kind":13,"line":263},{"kind":12,"line":263,"containerName":"contains","name":"start"},{"name":"$self","containerName":"contains","line":263,"kind":13},{"name":"start","containerName":"contains","line":263,"kind":12},{"kind":13,"line":264,"name":"$other","containerName":"contains"},{"line":264,"kind":12,"containerName":"contains","name":"end"},{"containerName":"contains","name":"$self","line":264,"kind":13},{"containerName":"contains","name":"end","line":264,"kind":12},{"line":266,"kind":13,"name":"$self","containerName":"contains"},{"name":"throw","containerName":"contains","kind":12,"line":266},{"line":266,"kind":13,"name":"$other","containerName":"contains"},{"name":"$other","containerName":"contains","line":267,"kind":13},{"kind":13,"line":267,"name":"$self","containerName":"contains"},{"containerName":"contains","name":"start","kind":12,"line":267},{"name":"$other","containerName":"contains","kind":13,"line":267},{"line":267,"kind":13,"name":"$self","containerName":"contains"},{"line":267,"kind":12,"name":"end","containerName":"contains"}]},{"kind":12,"children":[{"line":283,"kind":13,"localvar":"my","containerName":"equals","name":"$self","definition":"my"},{"kind":13,"line":283,"name":"$other","containerName":"equals"},{"line":283,"kind":13,"containerName":"equals","name":"$so"},{"line":285,"kind":13,"name":"$self","containerName":"equals"},{"name":"throw","containerName":"equals","line":285,"kind":12},{"kind":13,"line":285,"name":"$self","containerName":"equals"},{"containerName":"equals","name":"start","line":285,"kind":12},{"containerName":"equals","name":"$self","line":286,"kind":13},{"kind":12,"line":286,"containerName":"equals","name":"throw"},{"kind":13,"line":286,"containerName":"equals","name":"$self"},{"name":"end","containerName":"equals","line":286,"kind":12},{"containerName":"equals","name":"$other","line":287,"kind":13},{"kind":12,"line":287,"name":"throw","containerName":"equals"},{"kind":13,"line":287,"name":"$other","containerName":"equals"},{"containerName":"equals","name":"isa","line":287,"kind":12},{"line":288,"kind":13,"name":"$other","containerName":"equals"},{"containerName":"equals","name":"throw","line":288,"kind":12},{"line":288,"kind":13,"containerName":"equals","name":"$other"},{"containerName":"equals","name":"start","kind":12,"line":288},{"line":289,"kind":13,"containerName":"equals","name":"$other"},{"containerName":"equals","name":"throw","line":289,"kind":12},{"kind":13,"line":289,"containerName":"equals","name":"$other"},{"line":289,"kind":12,"name":"end","containerName":"equals"},{"name":"$self","containerName":"equals","kind":13,"line":291},{"kind":12,"line":291,"name":"_testStrand","containerName":"equals"},{"line":291,"kind":13,"name":"$other","containerName":"equals"},{"containerName":"equals","name":"$so","kind":13,"line":291},{"name":"$self","containerName":"equals","kind":13,"line":292},{"kind":12,"line":292,"containerName":"equals","name":"start"},{"name":"$other","containerName":"equals","kind":13,"line":292},{"kind":12,"line":292,"name":"start","containerName":"equals"},{"line":293,"kind":13,"name":"$self","containerName":"equals"},{"containerName":"equals","name":"end","kind":12,"line":293},{"containerName":"equals","name":"$other","line":293,"kind":13},{"line":293,"kind":12,"containerName":"equals","name":"end"}],"line":282,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range","label":"equals($self,$other,$so)"},"detail":"($self,$other,$so)","name":"equals","range":{"start":{"character":0,"line":282},"end":{"line":294,"character":9999}}},{"kind":12,"line":319,"children":[{"localvar":"my","containerName":"intersection","name":"$self","definition":"my","line":320,"kind":13},{"line":320,"kind":13,"name":"$given","containerName":"intersection"},{"name":"$so","containerName":"intersection","line":320,"kind":13},{"name":"$self","containerName":"intersection","kind":13,"line":321},{"kind":12,"line":321,"name":"throw","containerName":"intersection"},{"name":"$given","containerName":"intersection","line":321,"kind":13},{"line":323,"kind":13,"localvar":"my","containerName":"intersection","name":"@ranges","definition":"my"},{"line":324,"kind":13,"containerName":"intersection","name":"$self"},{"kind":13,"line":325,"containerName":"intersection","name":"$self"},{"line":326,"kind":13,"name":"$self","containerName":"intersection"},{"line":326,"kind":12,"name":"warn","containerName":"intersection"},{"line":328,"kind":13,"name":"$self","containerName":"intersection"},{"name":"@ranges","containerName":"intersection","kind":13,"line":329},{"line":329,"kind":13,"containerName":"intersection","name":"$self"},{"line":331,"kind":13,"containerName":"intersection","name":"$given"},{"containerName":"intersection","name":"@ranges","kind":13,"line":331},{"name":"$given","containerName":"intersection","line":331,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$given,$so)","signature":{"parameters":[{"label":"$self"},{"label":"$given"},{"label":"$so"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')","label":"intersection($self,$given,$so)"},"name":"intersection","range":{"start":{"character":0,"line":319},"end":{"character":9999,"line":331}}},{"name":"@ranges","containerName":null,"line":331,"kind":13},{"name":"$given","containerName":null,"line":331,"kind":13},{"line":332,"kind":13,"name":"$self","containerName":null},{"line":332,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"@ranges","kind":13,"line":332},{"localvar":"my","containerName":null,"name":"$intersect","definition":"my","line":334,"kind":13},{"kind":13,"line":335,"containerName":null,"name":"@ranges"},{"kind":13,"line":336,"containerName":null,"name":"%intersect"},{"line":337,"kind":13,"name":"$intersect","containerName":null},{"containerName":null,"name":"@ranges","kind":13,"line":337},{"containerName":null,"name":"$self","kind":13,"line":338},{"containerName":"main::","name":"throw","line":338,"kind":12},{"name":"$intersect","containerName":null,"kind":13,"line":338},{"kind":13,"line":339,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","line":339,"kind":12},{"line":339,"kind":13,"containerName":null,"name":"$intersect"},{"name":"isa","containerName":"main::","line":339,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":340},{"name":"throw","containerName":"main::","kind":12,"line":340},{"kind":13,"line":340,"containerName":null,"name":"$intersect"},{"kind":12,"line":340,"name":"start","containerName":"main::"},{"line":341,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","line":341,"kind":12},{"line":341,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":"main::","name":"end","kind":12,"line":341},{"localvar":"my","definition":"my","name":"$compare","containerName":null,"line":344,"kind":13},{"name":"@ranges","containerName":null,"line":344,"kind":13},{"line":345,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":345,"name":"throw","containerName":"main::"},{"line":345,"kind":13,"containerName":null,"name":"$compare"},{"name":"$self","containerName":null,"line":346,"kind":13},{"line":346,"kind":12,"name":"throw","containerName":"main::"},{"line":346,"kind":13,"containerName":null,"name":"$compare"},{"containerName":"main::","name":"isa","line":346,"kind":12},{"kind":13,"line":347,"containerName":null,"name":"$self"},{"kind":12,"line":347,"containerName":"main::","name":"throw"},{"name":"$compare","containerName":null,"kind":13,"line":347},{"containerName":"main::","name":"start","kind":12,"line":347},{"line":348,"kind":13,"name":"$self","containerName":null},{"line":348,"kind":12,"containerName":"main::","name":"throw"},{"name":"$compare","containerName":null,"kind":13,"line":348},{"kind":12,"line":348,"containerName":"main::","name":"end"},{"line":349,"kind":13,"containerName":null,"name":"$compare"},{"containerName":"main::","name":"_testStrand","line":349,"kind":12},{"line":349,"kind":13,"containerName":null,"name":"$intersect"},{"line":349,"kind":13,"containerName":null,"name":"$so"},{"kind":13,"line":351,"containerName":null,"name":"@starts","definition":"my","localvar":"my"},{"kind":13,"line":351,"name":"$a","containerName":null},{"kind":13,"line":351,"name":"$b","containerName":null},{"line":351,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":"main::","name":"start","line":351,"kind":12},{"name":"$compare","containerName":null,"line":351,"kind":13},{"line":351,"kind":12,"containerName":"main::","name":"start"},{"kind":13,"line":352,"containerName":null,"name":"@ends","definition":"my","localvar":"my"},{"kind":13,"line":352,"containerName":null,"name":"$a"},{"name":"$b","containerName":null,"line":352,"kind":13},{"line":352,"kind":13,"name":"$intersect","containerName":null},{"line":352,"kind":12,"containerName":"main::","name":"end"},{"line":352,"kind":13,"containerName":null,"name":"$compare"},{"name":"end","containerName":"main::","kind":12,"line":352},{"localvar":"my","name":"$start","definition":"my","containerName":null,"line":354,"kind":13},{"kind":13,"line":354,"containerName":null,"name":"@starts"},{"containerName":null,"definition":"my","name":"$end","localvar":"my","kind":13,"line":355},{"kind":13,"line":355,"name":"@ends","containerName":null},{"localvar":"my","containerName":null,"name":"$intersect_strand","definition":"my","line":357,"kind":13},{"containerName":null,"name":"$intersect","kind":13,"line":358},{"containerName":"main::","name":"strand","kind":12,"line":358},{"kind":13,"line":358,"containerName":null,"name":"$compare"},{"line":358,"kind":12,"containerName":"main::","name":"strand"},{"name":"$intersect","containerName":null,"line":358,"kind":13},{"name":"strand","containerName":"main::","kind":12,"line":358},{"kind":13,"line":358,"containerName":null,"name":"$compare"},{"line":358,"kind":12,"containerName":"main::","name":"strand"},{"name":"$intersect_strand","containerName":null,"kind":13,"line":359},{"containerName":null,"name":"$compare","line":359,"kind":13},{"kind":12,"line":359,"name":"strand","containerName":"main::"},{"containerName":null,"name":"$intersect_strand","kind":13,"line":362},{"name":"$start","containerName":null,"line":365,"kind":13},{"kind":13,"line":365,"name":"%end","containerName":null},{"name":"$intersect","containerName":null,"kind":13,"line":369},{"line":369,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":369,"containerName":"main::","name":"new"},{"name":"$start","containerName":null,"line":369,"kind":13},{"name":"$end","containerName":null,"line":370,"kind":13},{"containerName":null,"name":"%intersect_strand","kind":13,"line":371},{"containerName":null,"name":"$intersect","line":376,"kind":13},{"line":376,"kind":12,"name":"start","containerName":"main::"},{"line":376,"kind":13,"containerName":null,"name":"$intersect"},{"kind":12,"line":376,"containerName":"main::","name":"end"},{"line":376,"kind":13,"containerName":null,"name":"$intersect"},{"containerName":"main::","name":"strand","line":376,"kind":12},{"kind":13,"line":379,"containerName":null,"name":"$intersect"},{"children":[{"line":398,"kind":13,"localvar":"my","containerName":"union","definition":"my","name":"$self"},{"line":399,"kind":13,"localvar":"my","containerName":"union","name":"@ranges","definition":"my"},{"name":"$self","containerName":"union","kind":13,"line":400},{"kind":13,"line":401,"name":"$self","containerName":"union"},{"kind":13,"line":402,"name":"$self","containerName":"union"},{"name":"warn","containerName":"union","line":402,"kind":12},{"name":"$self","containerName":"union","line":404,"kind":13},{"kind":13,"line":405,"name":"@ranges","containerName":"union"},{"name":"$self","containerName":"union","line":405,"kind":13},{"line":408,"kind":13,"localvar":"my","name":"@start","definition":"my","containerName":"union"},{"kind":13,"line":408,"containerName":"union","name":"$a"},{"kind":13,"line":408,"containerName":"union","name":"$b"},{"kind":12,"line":409,"name":"start","containerName":"union"},{"line":409,"kind":13,"containerName":"union","name":"@ranges"},{"line":410,"kind":13,"localvar":"my","containerName":"union","definition":"my","name":"@end"},{"name":"$a","containerName":"union","line":410,"kind":13},{"line":410,"kind":13,"containerName":"union","name":"$b"},{"kind":12,"line":411,"containerName":"union","name":"end"},{"containerName":"union","name":"@ranges","line":411,"kind":13},{"localvar":"my","name":"$start","definition":"my","containerName":"union","line":413,"kind":13},{"line":413,"kind":13,"name":"@start","containerName":"union"},{"name":"$start","containerName":"union","kind":13,"line":414},{"containerName":"union","name":"$start","line":415,"kind":13},{"name":"@start","containerName":"union","kind":13,"line":415},{"kind":13,"line":418,"containerName":"union","definition":"my","name":"$end","localvar":"my"},{"containerName":"union","name":"@end","kind":13,"line":418},{"kind":13,"line":420,"name":"$union_strand","definition":"my","containerName":"union","localvar":"my"},{"line":422,"kind":13,"containerName":"union","name":"@ranges"},{"containerName":"union","name":"$union_strand","kind":13,"line":423},{"containerName":"union","name":"$union_strand","line":424,"kind":13},{"containerName":"union","name":"strand","kind":12,"line":424},{"containerName":"union","name":"strand","line":427,"kind":12},{"containerName":"union","name":"$union_strand","kind":13,"line":427},{"name":"strand","containerName":"union","line":427,"kind":12},{"line":428,"kind":13,"containerName":"union","name":"$union_strand"},{"name":"$start","containerName":"union","line":433,"kind":13},{"line":433,"kind":13,"containerName":"union","name":"$end"},{"line":435,"kind":13,"name":"$start","containerName":"union"},{"line":435,"kind":13,"containerName":"union","name":"$end"},{"line":435,"kind":13,"containerName":"union","name":"$union_strand"},{"line":437,"kind":13,"containerName":"union","name":"$self"},{"name":"new","containerName":"union","kind":12,"line":437},{"name":"$start","containerName":"union","kind":13,"line":437},{"line":438,"kind":13,"name":"$end","containerName":"union"},{"line":440,"kind":13,"name":"$union_strand","containerName":"union"}],"line":397,"kind":12,"range":{"end":{"character":9999,"line":442},"start":{"line":397,"character":0}},"name":"union","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":493},"start":{"character":0,"line":458}},"name":"overlap_extent","children":[{"containerName":"overlap_extent","name":"$a","definition":"my","localvar":"my","kind":13,"line":459},{"containerName":"overlap_extent","name":"$b","kind":13,"line":459},{"kind":13,"line":461,"containerName":"overlap_extent","name":"$a"},{"line":461,"kind":12,"containerName":"overlap_extent","name":"throw"},{"line":461,"kind":13,"containerName":"overlap_extent","name":"$a"},{"name":"start","containerName":"overlap_extent","kind":12,"line":461},{"kind":13,"line":462,"name":"$a","containerName":"overlap_extent"},{"line":462,"kind":12,"containerName":"overlap_extent","name":"throw"},{"line":462,"kind":13,"name":"$a","containerName":"overlap_extent"},{"containerName":"overlap_extent","name":"end","line":462,"kind":12},{"name":"$b","containerName":"overlap_extent","kind":13,"line":463},{"line":463,"kind":12,"containerName":"overlap_extent","name":"throw"},{"line":463,"kind":13,"containerName":"overlap_extent","name":"$b"},{"line":463,"kind":12,"containerName":"overlap_extent","name":"isa"},{"kind":13,"line":464,"name":"$b","containerName":"overlap_extent"},{"containerName":"overlap_extent","name":"throw","line":464,"kind":12},{"name":"$b","containerName":"overlap_extent","kind":13,"line":464},{"kind":12,"line":464,"containerName":"overlap_extent","name":"start"},{"containerName":"overlap_extent","name":"$b","kind":13,"line":465},{"kind":12,"line":465,"name":"throw","containerName":"overlap_extent"},{"containerName":"overlap_extent","name":"$b","line":465,"kind":13},{"name":"end","containerName":"overlap_extent","line":465,"kind":12},{"name":"$a","containerName":"overlap_extent","line":467,"kind":13},{"containerName":"overlap_extent","name":"overlaps","kind":12,"line":467},{"line":467,"kind":13,"containerName":"overlap_extent","name":"$b"},{"name":"$a","containerName":"overlap_extent","kind":13,"line":468},{"name":"length","containerName":"overlap_extent","kind":12,"line":468},{"name":"$b","containerName":"overlap_extent","line":468,"kind":13},{"kind":12,"line":468,"name":"length","containerName":"overlap_extent"},{"kind":13,"line":471,"definition":"my","name":"$au","containerName":"overlap_extent","localvar":"my"},{"line":471,"kind":13,"name":"$bu","containerName":"overlap_extent"},{"kind":13,"line":472,"name":"$a","containerName":"overlap_extent"},{"name":"start","containerName":"overlap_extent","line":472,"kind":12},{"name":"$b","containerName":"overlap_extent","kind":13,"line":472},{"name":"start","containerName":"overlap_extent","kind":12,"line":472},{"name":"$au","containerName":"overlap_extent","line":473,"kind":13},{"kind":13,"line":473,"containerName":"overlap_extent","name":"$b"},{"kind":12,"line":473,"containerName":"overlap_extent","name":"start"},{"kind":13,"line":473,"name":"$a","containerName":"overlap_extent"},{"name":"start","containerName":"overlap_extent","line":473,"kind":12},{"kind":13,"line":475,"name":"$bu","containerName":"overlap_extent"},{"kind":13,"line":475,"containerName":"overlap_extent","name":"$a"},{"line":475,"kind":12,"name":"start","containerName":"overlap_extent"},{"kind":13,"line":475,"containerName":"overlap_extent","name":"$b"},{"line":475,"kind":12,"containerName":"overlap_extent","name":"start"},{"line":478,"kind":13,"name":"$a","containerName":"overlap_extent"},{"containerName":"overlap_extent","name":"end","line":478,"kind":12},{"line":478,"kind":13,"containerName":"overlap_extent","name":"$b"},{"line":478,"kind":12,"containerName":"overlap_extent","name":"end"},{"line":479,"kind":13,"name":"$au","containerName":"overlap_extent"},{"line":479,"kind":13,"name":"$a","containerName":"overlap_extent"},{"containerName":"overlap_extent","name":"end","kind":12,"line":479},{"line":479,"kind":13,"name":"$b","containerName":"overlap_extent"},{"name":"end","containerName":"overlap_extent","kind":12,"line":479},{"containerName":"overlap_extent","name":"$bu","kind":13,"line":481},{"line":481,"kind":13,"containerName":"overlap_extent","name":"$b"},{"kind":12,"line":481,"containerName":"overlap_extent","name":"end"},{"line":481,"kind":13,"containerName":"overlap_extent","name":"$a"},{"kind":12,"line":481,"containerName":"overlap_extent","name":"end"},{"line":484,"kind":13,"localvar":"my","name":"$intersect","definition":"my","containerName":"overlap_extent"},{"name":"$a","containerName":"overlap_extent","kind":13,"line":484},{"line":484,"kind":12,"name":"intersection","containerName":"overlap_extent"},{"line":484,"kind":13,"name":"$b","containerName":"overlap_extent"},{"line":485,"kind":13,"containerName":"overlap_extent","name":"$intersect"},{"kind":13,"line":487,"containerName":"overlap_extent","name":"$au"},{"kind":13,"line":487,"name":"$bu","containerName":"overlap_extent"},{"localvar":"my","containerName":"overlap_extent","definition":"my","name":"$ie","line":489,"kind":13},{"line":489,"kind":13,"name":"$intersect","containerName":"overlap_extent"},{"name":"end","containerName":"overlap_extent","line":489,"kind":12},{"line":490,"kind":13,"localvar":"my","containerName":"overlap_extent","definition":"my","name":"$is"},{"name":"$intersect","containerName":"overlap_extent","line":490,"kind":13},{"name":"start","containerName":"overlap_extent","kind":12,"line":490},{"line":491,"kind":13,"containerName":"overlap_extent","name":"$au"},{"containerName":"overlap_extent","name":"$ie","kind":13,"line":491},{"name":"$is","containerName":"overlap_extent","kind":13,"line":491},{"kind":13,"line":491,"containerName":"overlap_extent","name":"$bu"}],"line":458,"kind":12,"signature":{"parameters":[{"label":"$a"},{"label":"$b"}],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range","label":"overlap_extent($a,$b)"},"detail":"($a,$b)","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"disconnected_ranges","definition":"sub","range":{"start":{"character":0,"line":508},"end":{"line":575,"character":9999}},"kind":12,"line":508,"children":[{"kind":13,"line":509,"name":"$self","definition":"my","containerName":"disconnected_ranges","localvar":"my"},{"line":510,"kind":13,"name":"$self","containerName":"disconnected_ranges"},{"line":511,"kind":13,"name":"$self","containerName":"disconnected_ranges"},{"name":"$self","containerName":"disconnected_ranges","kind":13,"line":512},{"line":512,"kind":12,"name":"warn","containerName":"disconnected_ranges"},{"kind":13,"line":514,"containerName":"disconnected_ranges","name":"@inranges","definition":"my","localvar":"my"},{"kind":13,"line":515,"containerName":"disconnected_ranges","name":"$self"},{"line":516,"kind":13,"containerName":"disconnected_ranges","name":"@inranges"},{"name":"$self","containerName":"disconnected_ranges","kind":13,"line":516},{"line":519,"kind":13,"localvar":"my","name":"@outranges","definition":"my","containerName":"disconnected_ranges"},{"localvar":"my","definition":"my","name":"$inrange","containerName":"disconnected_ranges","line":525,"kind":13},{"containerName":"disconnected_ranges","name":"@inranges","line":525,"kind":13},{"localvar":"my","definition":"my","name":"$intersects","containerName":"disconnected_ranges","line":526,"kind":13},{"line":527,"kind":13,"localvar":"my","name":"@outranges_new","definition":"my","containerName":"disconnected_ranges"},{"kind":13,"line":528,"containerName":"disconnected_ranges","definition":"my","name":"@intersecting_ranges","localvar":"my"},{"name":"$i","definition":"my","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":534},{"containerName":"disconnected_ranges","name":"$i","kind":13,"line":534},{"kind":13,"line":534,"name":"@outranges","containerName":"disconnected_ranges"},{"line":534,"kind":13,"name":"$i","containerName":"disconnected_ranges"},{"localvar":"my","name":"$outrange","definition":"my","containerName":"disconnected_ranges","line":535,"kind":13},{"kind":13,"line":535,"name":"$outranges","containerName":"disconnected_ranges"},{"line":535,"kind":13,"name":"$i","containerName":"disconnected_ranges"},{"localvar":"my","containerName":"disconnected_ranges","name":"$intersection","definition":"my","line":536,"kind":13},{"line":536,"kind":13,"containerName":"disconnected_ranges","name":"$inrange"},{"name":"intersection","containerName":"disconnected_ranges","kind":12,"line":536},{"kind":13,"line":536,"name":"$outrange","containerName":"disconnected_ranges"},{"containerName":"disconnected_ranges","name":"$intersection","line":537,"kind":13},{"line":538,"kind":13,"containerName":"disconnected_ranges","name":"$intersects"},{"definition":"my","name":"$union","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":539},{"kind":13,"line":539,"containerName":"disconnected_ranges","name":"$inrange"},{"name":"union","containerName":"disconnected_ranges","line":539,"kind":12},{"line":539,"kind":13,"containerName":"disconnected_ranges","name":"$outrange"},{"line":540,"kind":13,"containerName":"disconnected_ranges","name":"@intersecting_ranges"},{"name":"$union","containerName":"disconnected_ranges","kind":13,"line":540},{"kind":13,"line":543,"name":"@outranges_new","containerName":"disconnected_ranges"},{"name":"$outrange","containerName":"disconnected_ranges","line":543,"kind":13},{"kind":13,"line":546,"containerName":"disconnected_ranges","name":"@outranges"},{"kind":13,"line":546,"name":"@outranges_new","containerName":"disconnected_ranges"},{"line":550,"kind":13,"name":"@intersecting_ranges","containerName":"disconnected_ranges"},{"kind":13,"line":551,"name":"@intersecting_ranges","containerName":"disconnected_ranges"},{"kind":13,"line":555,"containerName":"disconnected_ranges","definition":"my","name":"$merged_range","localvar":"my"},{"line":556,"kind":13,"name":"$self","containerName":"disconnected_ranges"},{"line":556,"kind":12,"containerName":"disconnected_ranges","name":"union"},{"kind":13,"line":556,"name":"@intersecting_ranges","containerName":"disconnected_ranges"},{"kind":13,"line":557,"containerName":"disconnected_ranges","name":"@outranges"},{"name":"$merged_range","containerName":"disconnected_ranges","line":557,"kind":13},{"containerName":"disconnected_ranges","name":"@outranges","line":562,"kind":13},{"name":"@intersecting_ranges","containerName":"disconnected_ranges","kind":13,"line":562},{"kind":13,"line":567,"containerName":"disconnected_ranges","name":"@outranges"},{"line":568,"kind":13,"containerName":"disconnected_ranges","name":"$self"},{"kind":12,"line":568,"containerName":"disconnected_ranges","name":"new"},{"name":"$inrange","containerName":"disconnected_ranges","kind":13,"line":568},{"containerName":"disconnected_ranges","name":"start","kind":12,"line":568},{"line":569,"kind":13,"name":"$inrange","containerName":"disconnected_ranges"},{"containerName":"disconnected_ranges","name":"end","line":569,"kind":12},{"kind":13,"line":570,"containerName":"disconnected_ranges","name":"$inrange"},{"containerName":"disconnected_ranges","name":"strand","line":570,"kind":12},{"name":"@outranges","containerName":"disconnected_ranges","kind":13,"line":574}]},{"detail":"($self,$offset_fiveprime,$offset_threeprime)","signature":{"label":"offsetStranded($self,$offset_fiveprime,$offset_threeprime)","documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range\n\n\nsub overlap_extent{\n\tmy ($a,$b) = @_;\n\n\t$a->throw(\"start is undefined\") unless defined $a->start;\n\t$a->throw(\"end is undefined\") unless defined $a->end;\n\t$b->throw(\"Not a Bio::RangeI object\") unless  $b->isa('Bio::RangeI');\n\t$b->throw(\"start is undefined\") unless defined $b->start;\n\t$b->throw(\"end is undefined\") unless defined $b->end;\n\n\tif( ! $a->overlaps($b) ) {\n\t    return ($a->length,0,$b->length);\n\t}\n\n\tmy ($au,$bu) = (0, 0);\n\tif( $a->start < $b->start ) {\n\t\t$au = $b->start - $a->start;\n\t} else {\n\t\t$bu = $a->start - $b->start;\n\t}\n\n\tif( $a->end > $b->end ) {\n\t\t$au += $a->end - $b->end;\n\t} else {\n\t\t$bu += $b->end - $a->end;\n\t}\n\n\tmy $intersect = $a->intersection($b);\n\tif( ! $intersect ) {\n\t    warn(\"no intersection\\n\");\n\t    return ($au, 0, $bu);\n\t} else {\n\t    my $ie = $intersect->end;\n\t    my $is = $intersect->start;\n\t    return ($au,$ie-$is+1,$bu);\n\t}\n}\n\n=head2 disconnected_ranges\n\n    Title   : disconnected_ranges\n    Usage   : my @disc_ranges = Bio::Range->disconnected_ranges(@ranges);\n    Function: finds the minimal set of ranges such that each input range\n              is fully contained by at least one output range, and none of\n              the output ranges overlap\n    Args    : a list of ranges\n    Returns : a list of objects of the same type as the input\n              (conforms to RangeI)\n\n\nsub disconnected_ranges {\n    my $self = shift;\n    if ($self eq \"Bio::RangeI\") {\n\t$self = \"Bio::Range\";\n\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n    }\n    my @inranges = @_;\n    if(ref $self) {\n\tunshift @inranges, $self;\n    }\n\n    my @outranges = (); # disconnected ranges\n\n    # iterate through all input ranges $inrange,\n    # adding each input range to the set of output ranges @outranges,\n    # provided $inrange does not overlap ANY range in @outranges\n    # - if it does overlap an outrange, then merge it\n    foreach my $inrange (@inranges) {\n\tmy $intersects = 0;\n\tmy @outranges_new = ();\n\tmy @intersecting_ranges = ();\n\n        # iterate through all @outranges, testing if it intersects\n        # current $inrange; if it does, merge and add to list\n        # of @intersecting_ranges, otherwise add $outrange to\n        # the new list of outranges that do NOT intersect\n\tfor (my $i=0; $i<@outranges; $i++) {\n\t    my $outrange = $outranges[$i];\n\t    my $intersection = $inrange->intersection($outrange);\n\t    if ($intersection) {\n\t\t$intersects = 1;\n\t\tmy $union = $inrange->union($outrange);\n\t\tpush(@intersecting_ranges, $union);\n\t    }\n\t    else {\n\t\tpush(@outranges_new, $outrange);\n\t    }\n\t}\n\t@outranges = @outranges_new;\n        # @outranges now contains a list of non-overlapping ranges\n        # that do not intersect the current $inrange\n\n\tif (@intersecting_ranges) {\n\t    if (@intersecting_ranges > 1) {\n\t\t# this sf intersected > 1 range, which means that\n\t\t# all the ranges it intersects should be joined\n\t\t# together in a new range\n                my $merged_range =\n                  $self->union(@intersecting_ranges);\n\t\tpush(@outranges, $merged_range);\n\n\t    }\n\t    else {\n\t\t# exactly 1 intersecting range\n\t\tpush(@outranges, @intersecting_ranges);\n\t    }\n\t}\n\telse {\n\t    # no intersections found - new range\n\t    push(@outranges,\n\t\t $self->new('-start'=>$inrange->start,\n\t\t\t    '-end'=>$inrange->end,\n\t\t\t    '-strand'=>$inrange->strand,\n\t\t\t   ));\n\t}\n    }\n    return @outranges;\n}\n\n=head2 offsetStranded\n\n    Title    : offsetStranded\n    Usage    : $rnge->ofsetStranded($fiveprime_offset, $threeprime_offset)\n    Function : destructively modifies RangeI implementing object to\n               offset its start and stop coordinates by values $fiveprime_offset and\n               $threeprime_offset (positive values being in the strand direction).\n    Args     : two integer offsets: $fiveprime_offset and $threeprime_offset\n    Returns  : $self, offset accordingly.","parameters":[{"label":"$self"},{"label":"$offset_fiveprime"},{"label":"$offset_threeprime"}]},"containerName":"main::","definition":"sub","line":589,"children":[{"containerName":"offsetStranded","name":"$self","definition":"my","localvar":"my","kind":13,"line":590},{"name":"$offset_fiveprime","containerName":"offsetStranded","kind":13,"line":590},{"kind":13,"line":590,"name":"$offset_threeprime","containerName":"offsetStranded"},{"definition":"my","name":"$offset_start","containerName":"offsetStranded","localvar":"my","kind":13,"line":591},{"kind":13,"line":591,"containerName":"offsetStranded","name":"$offset_end"},{"line":591,"kind":13,"name":"$self","containerName":"offsetStranded"},{"name":"strand","containerName":"offsetStranded","line":591,"kind":12},{"kind":13,"line":591,"name":"$offset_threeprime","containerName":"offsetStranded"},{"name":"$offset_fiveprime","containerName":"offsetStranded","kind":13,"line":591},{"kind":13,"line":591,"name":"$offset_fiveprime","containerName":"offsetStranded"},{"name":"$offset_threeprime","containerName":"offsetStranded","kind":13,"line":591},{"line":592,"kind":13,"name":"$self","containerName":"offsetStranded"},{"name":"start","containerName":"offsetStranded","line":592,"kind":12},{"containerName":"offsetStranded","name":"$self","kind":13,"line":592},{"containerName":"offsetStranded","name":"start","kind":12,"line":592},{"containerName":"offsetStranded","name":"$offset_start","line":592,"kind":13},{"kind":13,"line":593,"containerName":"offsetStranded","name":"$self"},{"containerName":"offsetStranded","name":"end","line":593,"kind":12},{"kind":13,"line":593,"name":"$self","containerName":"offsetStranded"},{"line":593,"kind":12,"name":"end","containerName":"offsetStranded"},{"containerName":"offsetStranded","name":"$offset_end","kind":13,"line":593},{"line":594,"kind":13,"name":"$self","containerName":"offsetStranded"}],"kind":12,"range":{"end":{"character":9999,"line":595},"start":{"line":589,"character":0}},"name":"offsetStranded"},{"name":"subtract","range":{"start":{"character":0,"line":611},"end":{"line":653,"character":9999}},"kind":12,"children":[{"kind":13,"line":612,"containerName":"subtract","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":612,"containerName":"subtract","name":"$range"},{"line":612,"kind":13,"name":"$so","containerName":"subtract"},{"line":613,"kind":13,"name":"$self","containerName":"subtract"},{"name":"throw","containerName":"subtract","line":613,"kind":12},{"name":"$range","containerName":"subtract","line":614,"kind":13},{"containerName":"subtract","name":"$self","kind":13,"line":615},{"kind":12,"line":615,"name":"_testStrand","containerName":"subtract"},{"name":"$range","containerName":"subtract","kind":13,"line":615},{"line":615,"kind":13,"containerName":"subtract","name":"$so"},{"name":"$self","containerName":"subtract","line":617,"kind":13},{"name":"$self","containerName":"subtract","kind":13,"line":618},{"kind":13,"line":619,"name":"$self","containerName":"subtract"},{"containerName":"subtract","name":"warn","line":619,"kind":12},{"line":622,"kind":13,"name":"$range","containerName":"subtract"},{"line":622,"kind":12,"name":"throw","containerName":"subtract"},{"line":623,"kind":13,"name":"$range","containerName":"subtract"},{"kind":12,"line":623,"containerName":"subtract","name":"isa"},{"line":625,"kind":13,"containerName":"subtract","name":"$self"},{"name":"overlaps","containerName":"subtract","line":625,"kind":12},{"name":"$range","containerName":"subtract","line":625,"kind":13},{"line":630,"kind":13,"containerName":"subtract","name":"$range"},{"line":630,"kind":12,"name":"contains","containerName":"subtract"},{"containerName":"subtract","name":"$self","kind":13,"line":630},{"containerName":"subtract","definition":"my","name":"$start","localvar":"my","kind":13,"line":634},{"name":"$end","containerName":"subtract","kind":13,"line":634},{"kind":13,"line":634,"name":"$strand","containerName":"subtract"},{"line":634,"kind":13,"name":"$self","containerName":"subtract"},{"kind":12,"line":634,"containerName":"subtract","name":"intersection"},{"kind":13,"line":634,"name":"$range","containerName":"subtract"},{"kind":13,"line":634,"containerName":"subtract","name":"$so"},{"kind":13,"line":637,"name":"@outranges","definition":"my","containerName":"subtract","localvar":"my"},{"line":638,"kind":13,"name":"$self","containerName":"subtract"},{"kind":12,"line":638,"name":"start","containerName":"subtract"},{"line":638,"kind":13,"containerName":"subtract","name":"$start"},{"containerName":"subtract","name":"@outranges","line":639,"kind":13},{"line":640,"kind":13,"name":"$self","containerName":"subtract"},{"name":"new","containerName":"subtract","kind":12,"line":640},{"name":"$self","containerName":"subtract","kind":13,"line":640},{"name":"start","containerName":"subtract","kind":12,"line":640},{"name":"$start","containerName":"subtract","line":641,"kind":13},{"containerName":"subtract","name":"$self","kind":13,"line":642},{"name":"strand","containerName":"subtract","kind":12,"line":642},{"name":"$self","containerName":"subtract","line":645,"kind":13},{"name":"end","containerName":"subtract","line":645,"kind":12},{"containerName":"subtract","name":"$end","kind":13,"line":645},{"line":646,"kind":13,"name":"@outranges","containerName":"subtract"},{"kind":13,"line":647,"name":"$self","containerName":"subtract"},{"line":647,"kind":12,"containerName":"subtract","name":"new"},{"line":647,"kind":13,"name":"$end","containerName":"subtract"},{"name":"$self","containerName":"subtract","line":648,"kind":13},{"name":"end","containerName":"subtract","kind":12,"line":648},{"kind":13,"line":649,"name":"$self","containerName":"subtract"},{"containerName":"subtract","name":"strand","kind":12,"line":649},{"containerName":"subtract","name":"@outranges","kind":13,"line":652}],"line":611,"definition":"sub","containerName":"main::","signature":{"parameters":[],"documentation":"1;\n# $Id: RangeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::RangeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::RangeI - Range interface\n\n=head1 SYNOPSIS\n\n  #Do not run this module directly\n\n=head1 DESCRIPTION\n\nThis provides a standard BioPerl range interface that should be\nimplemented by any object that wants to be treated as a range. This\nserves purely as an abstract base class for implementers and can not\nbe instantiated.\n\nRanges are modeled as having (start, end, length, strand). They use\nBio-coordinates - all points E<gt>= start and E<lt>= end are within the\nrange. End is always greater-than or equal-to start, and length is\ngreater than or equal to 1. The behaviour of a range is undefined if\nranges with negative numbers or zero are used.\n\nSo, in summary:\n\n  length = end - start + 1\n  end >= start\n  strand = (-1 | 0 | +1)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJuha Muilu (muilu@ebi.ac.uk)\nSendu Bala (bix@sendu.me.uk)\nMalcolm Cook (mec@stowers-institute.org)\nStephen Montgomery (sm8 at sanger.ac.uk)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::RangeI;\n\nuse strict;\nuse Carp;\nuse integer;\nuse vars qw(%STRAND_OPTIONS);\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n# STRAND_OPTIONS contains the legal values for the strand-testing options\n    %STRAND_OPTIONS = map { $_, '_' . $_ }\n    (\n     'strong', # ranges must have the same strand\n     'weak',   # ranges must have the same strand or no strand\n     'ignore', # ignore strand information\n     );\n}\n\n# utility methods\n#\n\n# returns true if strands are equal and non-zero\nsub _strong {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n\n    return 1 if $s1 != 0 && $s1 == $s2;\n}\n\n# returns true if strands are equal or either is zero\nsub _weak {\n    my ($r1, $r2) = @_;\n    my ($s1, $s2) = ($r1->strand(), $r2->strand());\n    return 1 if $s1 == 0 || $s2 == 0 || $s1 == $s2;\n}\n\n# returns true for any strandedness\nsub _ignore {\n    return 1;\n}\n\n# works out what test to use for the strictness and returns true/false\n# e.g. $r1->_testStrand($r2, 'strong')\nsub _testStrand() {\n    my ($r1, $r2, $comp) = @_;\n    return 1 unless $comp;\n    my $func = $STRAND_OPTIONS{$comp};\n    return $r1->$func($r2);\n}\n\n=head1 Abstract methods\n\nThese methods must be implemented in all subclasses.\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $range->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionally allows the start to be set\n            using $range->start($start)\n\n\nsub start {\n    shift->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $range->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionally allows the end to be set\n            using $range->end($end)\n\n\nsub end {\n    shift->throw_not_implemented();\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $range->length();\n  Function: get/set the length of this range\n  Returns : the length of this range\n  Args    : optionally allows the length to be set\n             using $range->length($length)\n\n\nsub length {\n    shift->throw_not_implemented();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $range->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionally allows the strand to be set\n            using $range->strand($strand)\n\n\nsub strand {\n    shift->throw_not_implemented();\n}\n\n=head1 Boolean Methods\n\nThese methods return true or false. They throw an error if start and\nend are not defined.\n\n  $range->overlaps($otherRange) && print \"Ranges overlap\\n\";\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if($r1->overlaps($r2)) { do stuff }\n  Function: tests if $r2 overlaps $r1\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the ranges overlap, false otherwise\n\n\nsub overlaps {\n\tmy ($self, $other, $so) = @_;\n\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\t$self->throw(\"not a Bio::RangeI object\") unless defined $other &&\n\t  $other->isa('Bio::RangeI');\n\t$other->throw(\"start is undefined\") unless defined $other->start;\n\t$other->throw(\"end is undefined\") unless defined $other->end;\n\n\treturn\n\t  ($self->_testStrand($other, $so)\n\t\tand not (\n\t\t\t\t\t($self->start() > $other->end() or\n\t\t\t\t\t $self->end() < $other->start()   )\n\t\t\t\t  ));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if($r1->contains($r2) { do stuff }\n  Function: tests whether $r1 totally contains $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n\t             alternatively, integer scalar to test\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if the argument is totally contained within this range\n\n\nsub contains {\n\tmy ($self, $other, $so) = @_;\n\t$self->throw(\"start is undefined\") unless defined $self->start;\n\t$self->throw(\"end is undefined\") unless defined $self->end;\n\n\tif(defined $other && ref $other) { # a range object?\n      $other->throw(\"Not a Bio::RangeI object: $other\") unless  $other->isa('Bio::RangeI');\n      $other->throw(\"start is undefined\") unless defined $other->start;\n      $other->throw(\"end is undefined\") unless defined $other->end;\n\n      return ($self->_testStrand($other, $so)      and\n\t\t\t\t  $other->start() >= $self->start() and\n\t\t\t\t  $other->end() <= $self->end());\n  } else { # a scalar?\n\t  $self->throw(\"'$other' is not an integer.\\n\") unless $other =~ /^[-+]?\\d+$/;\n\t  return ($other >= $self->start() and $other <= $self->end());\n  }\n}\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if($r1->equals($r2))\n  Function: test whether $r1 has the same start, end, length as $r2\n  Args    : arg #1 = a range to compare this one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n  Returns : true if they are describing the same range\n\n\nsub equals {\n    my ($self, $other, $so) = @_;\n\n    $self->throw(\"start is undefined\") unless defined $self->start;\n    $self->throw(\"end is undefined\") unless defined $self->end;\n    $other->throw(\"Not a Bio::RangeI object\") unless  $other->isa('Bio::RangeI');\n    $other->throw(\"start is undefined\") unless defined $other->start;\n    $other->throw(\"end is undefined\") unless defined $other->end;\n\n    return ($self->_testStrand($other, $so)   and\n\t    $self->start() == $other->start() and\n\t    $self->end()   == $other->end()       );\n}\n\n=head1 Geometrical methods\n\nThese methods do things to the geometry of ranges, and return\nBio::RangeI compliant objects or triplets (start, stop, strand) from\nwhich new ranges could be built.\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $r1->intersection($r2); OR\n           ($start, $stop, $strand) = Bio::Range->intersection(\\@ranges); OR\n           my $containing_range = $r1->intersection($r2); OR\n           my $containing_range = Bio::Range->intersection(\\@ranges);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, or\n           the range that they do overlap (in the form of an object\n            like the calling one, OR a three element array)\n Args    : arg #1 = [REQUIRED] a range to compare this one to,\n                    or an array ref of ranges\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n\n\nsub intersection {\n\tmy ($self, $given, $so) = @_;\n\t$self->throw(\"missing arg: you need to pass in another feature\") unless $given;\n\n    my @ranges;\n    if ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@ranges, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@ranges, @{$given}) : push(@ranges, $given);\n    $self->throw(\"Need at least 2 ranges\") unless @ranges >= 2;\n\n    my $intersect;\n    while (@ranges > 0) {\n        unless ($intersect) {\n            $intersect = shift(@ranges);\n            $self->throw(\"Not an object: $intersect\") unless ref($intersect);\n            $self->throw(\"Not a Bio::RangeI object: $intersect\") unless $intersect->isa('Bio::RangeI');\n            $self->throw(\"start is undefined\") unless defined $intersect->start;\n            $self->throw(\"end is undefined\") unless defined $intersect->end;\n        }\n\n        my $compare = shift(@ranges);\n        $self->throw(\"Not an object: $compare\") unless ref($compare);\n        $self->throw(\"Not a Bio::RangeI object: $compare\") unless $compare->isa('Bio::RangeI');\n        $self->throw(\"start is undefined\") unless defined $compare->start;\n        $self->throw(\"end is undefined\") unless defined $compare->end;\n        return unless $compare->_testStrand($intersect, $so);\n\n        my @starts = sort {$a <=> $b} ($intersect->start(), $compare->start());\n        my @ends   = sort {$a <=> $b} ($intersect->end(), $compare->end());\n\n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n\n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n\n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n\n    if (wantarray()) {\n        return ($intersect->start, $intersect->end, $intersect->strand);\n    }\n    else {\n        return $intersect;\n    }\n}\n\n=head2 union\n\n   Title   : union\n    Usage   : ($start, $stop, $strand) = $r1->union($r2);\n            : ($start, $stop, $strand) = Bio::Range->union(@ranges);\n              my $newrange = Bio::Range->union(@ranges);\n    Function: finds the minimal Range that contains all of the Ranges\n    Args    : a Range or list of Range objects\n    Returns : the range containing all of the range\n              (in the form of an object like the calling one, OR\n              a three element array)\n\n\nsub union {\n\tmy $self = shift;\n\tmy @ranges = @_;\n\tif ($self eq \"Bio::RangeI\") {\n\t\t$self = \"Bio::Range\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif(ref $self) {\n\t\tunshift @ranges, $self;\n\t}\n\n\tmy @start = sort {$a<=>$b}\n\t  map( { $_->start() } @ranges);\n\tmy @end   = sort {$a<=>$b}\n\t  map( { $_->end()   } @ranges);\n\n\tmy $start = shift @start;\n\twhile( !defined $start ) {\n\t\t$start = shift @start;\n\t}\n\n\tmy $end = pop @end;\n\n\tmy $union_strand;  # Strand for the union range object.\n\n\tforeach(@ranges) {\n\t\tif(! defined $union_strand) {\n\t\t\t$union_strand = $_->strand;\n\t\t\tnext;\n\t\t} else {\n\t\t\tif(not defined $_->strand or $union_strand ne $_->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t}\n\treturn unless $start or $end;\n\tif( wantarray() ) {\n\t\treturn ( $start,$end,$union_strand);\n\t} else {\n\t\treturn $self->new('-start' => $start,\n\t\t\t\t\t\t\t\t'-end' => $end,\n\t\t\t\t\t\t\t\t'-strand' => $union_strand\n\t\t\t\t\t\t\t  );\n\t}\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           ranges\n Example :\n Returns : array of values containing the length unique to the calling\n           range, the length common to both, and the length unique to\n           the argument range\n Args    : a range\n\n\nsub overlap_extent{\n\tmy ($a,$b) = @_;\n\n\t$a->throw(\"start is undefined\") unless defined $a->start;\n\t$a->throw(\"end is undefined\") unless defined $a->end;\n\t$b->throw(\"Not a Bio::RangeI object\") unless  $b->isa('Bio::RangeI');\n\t$b->throw(\"start is undefined\") unless defined $b->start;\n\t$b->throw(\"end is undefined\") unless defined $b->end;\n\n\tif( ! $a->overlaps($b) ) {\n\t    return ($a->length,0,$b->length);\n\t}\n\n\tmy ($au,$bu) = (0, 0);\n\tif( $a->start < $b->start ) {\n\t\t$au = $b->start - $a->start;\n\t} else {\n\t\t$bu = $a->start - $b->start;\n\t}\n\n\tif( $a->end > $b->end ) {\n\t\t$au += $a->end - $b->end;\n\t} else {\n\t\t$bu += $b->end - $a->end;\n\t}\n\n\tmy $intersect = $a->intersection($b);\n\tif( ! $intersect ) {\n\t    warn(\"no intersection\\n\");\n\t    return ($au, 0, $bu);\n\t} else {\n\t    my $ie = $intersect->end;\n\t    my $is = $intersect->start;\n\t    return ($au,$ie-$is+1,$bu);\n\t}\n}\n\n=head2 disconnected_ranges\n\n    Title   : disconnected_ranges\n    Usage   : my @disc_ranges = Bio::Range->disconnected_ranges(@ranges);\n    Function: finds the minimal set of ranges such that each input range\n              is fully contained by at least one output range, and none of\n              the output ranges overlap\n    Args    : a list of ranges\n    Returns : a list of objects of the same type as the input\n              (conforms to RangeI)\n\n\nsub disconnected_ranges {\n    my $self = shift;\n    if ($self eq \"Bio::RangeI\") {\n\t$self = \"Bio::Range\";\n\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n    }\n    my @inranges = @_;\n    if(ref $self) {\n\tunshift @inranges, $self;\n    }\n\n    my @outranges = (); # disconnected ranges\n\n    # iterate through all input ranges $inrange,\n    # adding each input range to the set of output ranges @outranges,\n    # provided $inrange does not overlap ANY range in @outranges\n    # - if it does overlap an outrange, then merge it\n    foreach my $inrange (@inranges) {\n\tmy $intersects = 0;\n\tmy @outranges_new = ();\n\tmy @intersecting_ranges = ();\n\n        # iterate through all @outranges, testing if it intersects\n        # current $inrange; if it does, merge and add to list\n        # of @intersecting_ranges, otherwise add $outrange to\n        # the new list of outranges that do NOT intersect\n\tfor (my $i=0; $i<@outranges; $i++) {\n\t    my $outrange = $outranges[$i];\n\t    my $intersection = $inrange->intersection($outrange);\n\t    if ($intersection) {\n\t\t$intersects = 1;\n\t\tmy $union = $inrange->union($outrange);\n\t\tpush(@intersecting_ranges, $union);\n\t    }\n\t    else {\n\t\tpush(@outranges_new, $outrange);\n\t    }\n\t}\n\t@outranges = @outranges_new;\n        # @outranges now contains a list of non-overlapping ranges\n        # that do not intersect the current $inrange\n\n\tif (@intersecting_ranges) {\n\t    if (@intersecting_ranges > 1) {\n\t\t# this sf intersected > 1 range, which means that\n\t\t# all the ranges it intersects should be joined\n\t\t# together in a new range\n                my $merged_range =\n                  $self->union(@intersecting_ranges);\n\t\tpush(@outranges, $merged_range);\n\n\t    }\n\t    else {\n\t\t# exactly 1 intersecting range\n\t\tpush(@outranges, @intersecting_ranges);\n\t    }\n\t}\n\telse {\n\t    # no intersections found - new range\n\t    push(@outranges,\n\t\t $self->new('-start'=>$inrange->start,\n\t\t\t    '-end'=>$inrange->end,\n\t\t\t    '-strand'=>$inrange->strand,\n\t\t\t   ));\n\t}\n    }\n    return @outranges;\n}\n\n=head2 offsetStranded\n\n    Title    : offsetStranded\n    Usage    : $rnge->ofsetStranded($fiveprime_offset, $threeprime_offset)\n    Function : destructively modifies RangeI implementing object to\n               offset its start and stop coordinates by values $fiveprime_offset and\n               $threeprime_offset (positive values being in the strand direction).\n    Args     : two integer offsets: $fiveprime_offset and $threeprime_offset\n    Returns  : $self, offset accordingly.\n\n\nsub offsetStranded {\n  my ($self, $offset_fiveprime, $offset_threeprime) = @_;\n  my ($offset_start, $offset_end) = $self->strand() eq -1 ? (- $offset_threeprime, - $offset_fiveprime) : ($offset_fiveprime, $offset_threeprime);\n  $self->start($self->start + $offset_start);\n  $self->end($self->end + $offset_end);\n  return $self;\n};\n\n=head2 subtract\n\n  Title   : subtract\n  Usage   : my @subtracted = $r1->subtract($r2)\n  Function: Subtract range r2 from range r1\n  Args    : arg #1 = a range to subtract from this one (mandatory)\n            arg #2 = strand option ('strong', 'weak', 'ignore') (optional)\n  Returns : undef if they do not overlap or r2 contains this RangeI,\n            or an arrayref of Range objects (this is an array since some\n            instances where the subtract range is enclosed within this range\n            will result in the creation of two new disjoint ranges)","label":"subtract()"},"detail":"()"}]}