{"vars":[{"name":"vars","containerName":"","line":134,"kind":2},{"line":139,"kind":2,"containerName":"","name":"base"},{"kind":13,"line":146,"name":"$FORCE_TEMP_FILE","containerName":null},{"range":{"end":{"line":170,"character":9999},"start":{"line":161,"character":0}},"definition":"sub","name":"_fields","containerName":"main::","children":[{"kind":13,"line":162,"definition":"my","name":"$self","containerName":"_fields","localvar":"my"},{"line":164,"kind":13,"containerName":"_fields","name":"$self"},{"name":"$self","containerName":"_fields","line":166,"kind":13},{"line":167,"kind":13,"containerName":"_fields","name":"$self"},{"line":169,"kind":13,"name":"$self","containerName":"_fields"}],"line":161,"kind":12},{"name":"_fields","kind":12,"line":164},{"name":"_fields","line":166,"kind":12},{"line":167,"kind":12,"name":"_fields"},{"kind":12,"line":169,"name":"_fields"},{"detail":"($self,$desired)","signature":{"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)","parameters":[{"label":"$self"},{"label":"$desired"}],"label":"has_field($self,$desired)"},"containerName":"main::","definition":"sub","line":182,"children":[{"kind":13,"line":183,"name":"$self","definition":"my","containerName":"has_field","localvar":"my"},{"name":"$desired","containerName":"has_field","kind":13,"line":183},{"name":"$desired","containerName":"has_field","line":184,"kind":13},{"name":"$self","containerName":"has_field","kind":13,"line":185},{"name":"_fields","containerName":"has_field","kind":12,"line":185},{"containerName":"has_field","name":"$desired","line":185,"kind":13}],"kind":12,"range":{"end":{"line":186,"character":9999},"start":{"character":0,"line":182}},"name":"has_field"},{"children":[{"kind":13,"line":202,"containerName":"get_field","definition":"my","name":"$self","localvar":"my"},{"line":203,"kind":13,"localvar":"my","name":"$desired","definition":"my","containerName":"get_field"},{"name":"$self","containerName":"get_field","kind":13,"line":203},{"kind":12,"line":203,"containerName":"get_field","name":"_fields"}],"line":201,"kind":12,"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":203}},"name":"get_field","definition":"sub","containerName":"main::"},{"containerName":null,"name":"$self","line":204,"kind":13},{"name":"_fields","containerName":"main::","line":204,"kind":12},{"line":204,"kind":13,"name":"%desired","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":205},{"name":"_fields","containerName":"main::","line":205,"kind":12},{"containerName":null,"name":"%desired","line":205,"kind":13},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"$method","containerName":null},{"containerName":null,"name":"$desired","line":206,"kind":13},{"line":208,"kind":13,"localvar":"my","definition":"my","name":"$dependency","containerName":null},{"kind":13,"line":208,"name":"$self","containerName":null},{"containerName":"main::","name":"_dependencies","line":208,"kind":12},{"kind":13,"line":208,"name":"$desired","containerName":null},{"containerName":null,"name":"$dependency","kind":13,"line":209},{"line":209,"kind":13,"containerName":null,"name":"$self"},{"name":"_fields","containerName":"main::","kind":12,"line":209},{"containerName":null,"name":"%dependency","line":209,"kind":13},{"kind":13,"line":210,"containerName":null,"name":"$self"},{"containerName":"main::","name":"get_field","kind":12,"line":210},{"containerName":null,"name":"$dependency","line":210,"kind":13},{"containerName":null,"name":"$self","line":214,"kind":13},{"containerName":null,"name":"$method","kind":13,"line":214},{"name":"$self","containerName":null,"kind":13,"line":214},{"name":"_fields","containerName":"main::","kind":12,"line":214},{"name":"$desired","containerName":null,"kind":13,"line":214},{"containerName":null,"name":"$self","line":216,"kind":13},{"kind":12,"line":216,"containerName":"main::","name":"_fields"},{"line":216,"kind":13,"containerName":null,"name":"$desired"},{"line":220,"kind":13,"localvar":"my","definition":"my","name":"$parent","containerName":null},{"line":220,"kind":13,"name":"$self","containerName":null},{"name":"parent","containerName":"main::","kind":12,"line":220},{"containerName":null,"name":"$parent","line":221,"kind":13},{"line":221,"kind":12,"containerName":"main::","name":"get_field"},{"name":"$desired","containerName":null,"line":221,"kind":13},{"containerName":null,"name":"$desired","line":224,"kind":13},{"kind":13,"line":225,"containerName":null,"name":"$self"},{"line":225,"kind":12,"name":"warn","containerName":"main::"},{"range":{"start":{"character":0,"line":240},"end":{"line":244,"character":9999}},"name":"parent","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"parent","name":"$self","definition":"my","line":241,"kind":13},{"name":"$self","containerName":"parent","line":242,"kind":13},{"line":243,"kind":13,"containerName":"parent","name":"$self"}],"line":240,"kind":12},{"name":"parent","line":242,"kind":12},{"kind":12,"line":243,"name":"parent"},{"range":{"end":{"line":369,"character":9999},"start":{"character":0,"line":281}},"definition":"sub","name":"chunk","containerName":"main::","children":[{"kind":13,"line":282,"containerName":"chunk","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":285,"name":"$thing","definition":"my","containerName":"chunk","localvar":"my"},{"name":"$self","containerName":"chunk","line":285,"kind":13},{"kind":12,"line":285,"containerName":"chunk","name":"throw"},{"line":286,"kind":13,"name":"$thing","containerName":"chunk"},{"line":287,"kind":13,"name":"$self","containerName":"chunk"},{"name":"new","containerName":"chunk","kind":12,"line":287},{"name":"$thing","containerName":"chunk","kind":13,"line":287},{"name":"$thing","containerName":"chunk","kind":13,"line":289},{"name":"$thing","containerName":"chunk","kind":13,"line":290},{"line":290,"kind":13,"name":"$thing","containerName":"chunk"},{"line":291,"kind":13,"containerName":"chunk","name":"$self"},{"kind":12,"line":291,"name":"new","containerName":"chunk"},{"kind":13,"line":291,"containerName":"chunk","name":"$thing"},{"kind":13,"line":294,"name":"$FORCE_TEMP_FILE","containerName":"chunk"},{"name":"$fake_fh","definition":"my","containerName":"chunk","localvar":"my","kind":13,"line":296},{"containerName":"chunk","name":"$thing","kind":13,"line":296},{"containerName":"chunk","name":"$self","line":297,"kind":13},{"kind":12,"line":297,"name":"new","containerName":"chunk"},{"kind":13,"line":297,"name":"$fake_fh","containerName":"chunk"},{"definition":"my","name":"$handle","containerName":"chunk","localvar":"my","kind":13,"line":300},{"name":"$self","containerName":"chunk","line":300,"kind":13},{"containerName":"chunk","name":"tempfile","line":300,"kind":12},{"name":"$handle","containerName":"chunk","line":301,"kind":13},{"name":"$thing","containerName":"chunk","kind":13,"line":301},{"line":302,"kind":13,"name":"$self","containerName":"chunk"},{"kind":12,"line":302,"containerName":"chunk","name":"new"},{"containerName":"chunk","name":"$handle","line":302,"kind":13},{"containerName":"chunk","name":"$thing","line":306,"kind":13},{"name":"isa","containerName":"chunk","kind":12,"line":306},{"line":307,"kind":13,"name":"$self","containerName":"chunk"},{"kind":13,"line":307,"name":"$thing","containerName":"chunk"},{"line":310,"kind":13,"name":"$self","containerName":"chunk"},{"name":"throw","containerName":"chunk","kind":12,"line":310},{"localvar":"my","containerName":"chunk","definition":"my","name":"$piped_behaviour","line":313,"kind":13},{"containerName":"chunk","name":"$start","line":313,"kind":13},{"line":313,"kind":13,"name":"$end","containerName":"chunk"},{"name":"$piped_behaviour","containerName":"chunk","line":315,"kind":13},{"name":"$start","containerName":"chunk","kind":13,"line":315},{"kind":13,"line":315,"name":"$end","containerName":"chunk"},{"kind":13,"line":316,"containerName":"chunk","name":"$self"},{"line":316,"kind":12,"containerName":"chunk","name":"_rearrange"},{"name":"$piped_behaviour","containerName":"chunk","kind":13,"line":318},{"containerName":"chunk","name":"$FORCE_TEMP_FILE","line":319,"kind":13},{"line":319,"kind":13,"name":"$piped_behaviour","containerName":"chunk"},{"line":320,"kind":13,"containerName":"chunk","name":"$start"},{"line":321,"kind":13,"name":"$self","containerName":"chunk"},{"line":321,"kind":12,"containerName":"chunk","name":"_chunk_true_start"},{"line":321,"kind":13,"name":"$start","containerName":"chunk"},{"containerName":"chunk","name":"$self","line":322,"kind":13},{"kind":12,"line":322,"name":"_chunk_true_end","containerName":"chunk"},{"name":"$end","containerName":"chunk","kind":13,"line":322},{"localvar":"my","definition":"my","name":"$fh","containerName":"chunk","line":325,"kind":13},{"line":325,"kind":13,"name":"$self","containerName":"chunk"},{"kind":12,"line":325,"name":"_fh","containerName":"chunk"},{"name":"$fh","containerName":"chunk","kind":13,"line":326},{"localvar":"my","containerName":"chunk","name":"$first_line","definition":"my","line":327,"kind":13},{"line":327,"kind":13,"containerName":"chunk","name":"$fh"},{"line":328,"kind":13,"name":"$fh","containerName":"chunk"},{"localvar":"my","containerName":"chunk","definition":"my","name":"$seekable","line":329,"kind":13},{"line":329,"kind":13,"name":"$fh","containerName":"chunk"},{"name":"$seekable","containerName":"chunk","kind":13,"line":330},{"line":331,"kind":13,"name":"$piped_behaviour","containerName":"chunk"},{"containerName":"chunk","definition":"my","name":"$string","localvar":"my","kind":13,"line":332},{"containerName":"chunk","name":"$first_line","line":332,"kind":13},{"containerName":"chunk","name":"$fh","line":333,"kind":13},{"containerName":"chunk","name":"$string","line":334,"kind":13},{"line":336,"kind":13,"containerName":"chunk","name":"$self"},{"kind":12,"line":336,"containerName":"chunk","name":"chunk"},{"line":336,"kind":13,"name":"$string","containerName":"chunk"},{"name":"$piped_behaviour","containerName":"chunk","line":338,"kind":13},{"kind":13,"line":339,"containerName":"chunk","definition":"my","name":"$handle","localvar":"my"},{"kind":13,"line":339,"name":"$self","containerName":"chunk"},{"name":"tempfile","containerName":"chunk","line":339,"kind":12},{"kind":13,"line":340,"name":"$handle","containerName":"chunk"},{"line":340,"kind":13,"containerName":"chunk","name":"$first_line"},{"kind":13,"line":341,"name":"$fh","containerName":"chunk"},{"kind":13,"line":342,"name":"$handle","containerName":"chunk"},{"kind":13,"line":344,"name":"$handle","containerName":"chunk"},{"kind":13,"line":345,"name":"$self","containerName":"chunk"},{"name":"chunk","containerName":"chunk","line":345,"kind":12},{"name":"$handle","containerName":"chunk","kind":13,"line":345},{"name":"$piped_behaviour","containerName":"chunk","kind":13,"line":347},{"kind":13,"line":348,"containerName":"chunk","name":"$self"},{"line":348,"kind":12,"containerName":"chunk","name":"_pushback"},{"line":348,"kind":13,"name":"$first_line","containerName":"chunk"},{"containerName":"chunk","name":"$self","kind":13,"line":349},{"kind":12,"line":349,"name":"_sequential","containerName":"chunk"},{"line":352,"kind":13,"name":"$self","containerName":"chunk"},{"containerName":"chunk","name":"throw","line":352,"kind":12},{"containerName":"chunk","name":"$first_line","kind":13,"line":357},{"name":"$self","containerName":"chunk","kind":13,"line":358},{"kind":12,"line":358,"containerName":"chunk","name":"_line_ending"},{"name":"$first_line","containerName":"chunk","kind":13,"line":360},{"name":"$self","containerName":"chunk","line":361,"kind":13},{"containerName":"chunk","name":"_line_ending","kind":12,"line":361},{"containerName":"chunk","name":"$self","line":364,"kind":13},{"name":"_line_ending","containerName":"chunk","kind":12,"line":364},{"line":368,"kind":13,"name":"$self","containerName":"chunk"}],"line":281,"kind":12},{"name":"_chunk","line":287,"kind":12},{"containerName":"Root::IO","name":"Bio","line":287,"kind":12},{"kind":12,"line":291,"name":"_chunk"},{"kind":12,"line":291,"containerName":"Root::IO","name":"Bio"},{"line":297,"kind":12,"name":"_chunk"},{"kind":12,"line":297,"name":"Bio","containerName":"Root::IO"},{"line":300,"kind":12,"name":"_chunk"},{"line":302,"kind":12,"name":"_chunk"},{"containerName":"Root::IO","name":"Bio","kind":12,"line":302},{"kind":12,"line":307,"name":"_chunk"},{"kind":12,"line":325,"name":"_chunk"},{"name":"_chunk","line":339,"kind":12},{"kind":12,"line":348,"name":"_chunk"},{"line":368,"kind":12,"name":"_chunk"},{"name":"_sequential","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":389},"start":{"line":383,"character":0}},"kind":12,"children":[{"kind":13,"line":384,"name":"$self","definition":"my","containerName":"_sequential","localvar":"my"},{"name":"$self","containerName":"_sequential","kind":13,"line":386},{"kind":13,"line":388,"containerName":"_sequential","name":"$self"}],"line":383},{"name":"_sequential","kind":12,"line":386},{"name":"_sequential","line":388,"kind":12},{"range":{"end":{"character":9999,"line":414},"start":{"character":0,"line":405}},"name":"_dependencies","signature":{"parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.","label":"_dependencies($self,$thing)"},"detail":"($self,$thing)","definition":"sub","containerName":"main::","children":[{"line":406,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_dependencies"},{"containerName":"_dependencies","name":"$thing","kind":13,"line":406},{"line":407,"kind":13,"containerName":"_dependencies","name":"$thing"},{"name":"$thing","containerName":"_dependencies","kind":13,"line":408},{"kind":13,"line":409,"name":"$self","containerName":"_dependencies"},{"name":"$thing","containerName":"_dependencies","line":409,"kind":13},{"kind":13,"line":412,"name":"$self","containerName":"_dependencies"},{"kind":13,"line":412,"containerName":"_dependencies","name":"$thing"}],"line":405,"kind":12},{"kind":12,"line":409,"name":"_dependencies"},{"name":"_dependencies","line":412,"kind":12},{"line":427,"children":[{"containerName":"_chunk_true_start","name":"$self","definition":"my","localvar":"my","kind":13,"line":428},{"kind":13,"line":430,"containerName":"_chunk_true_start","name":"$self"},{"line":432,"kind":13,"containerName":"_chunk_true_start","name":"$self"}],"kind":12,"range":{"end":{"line":433,"character":9999},"start":{"character":0,"line":427}},"containerName":"main::","definition":"sub","name":"_chunk_true_start"},{"name":"_chunk_start","line":430,"kind":12},{"kind":12,"line":432,"name":"_chunk_start"},{"containerName":"main::","definition":"sub","name":"_chunk_true_end","range":{"end":{"line":452,"character":9999},"start":{"character":0,"line":446}},"kind":12,"line":446,"children":[{"containerName":"_chunk_true_end","name":"$self","definition":"my","localvar":"my","kind":13,"line":447},{"kind":13,"line":449,"name":"$self","containerName":"_chunk_true_end"},{"line":451,"kind":13,"containerName":"_chunk_true_end","name":"$self"}]},{"line":449,"kind":12,"name":"_chunk_end"},{"name":"_chunk_end","line":451,"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_line_ending","line":466,"kind":13},{"name":"$self","containerName":"_line_ending","kind":13,"line":468},{"name":"$self","containerName":"_line_ending","line":470,"kind":13}],"line":465,"kind":12,"range":{"end":{"character":9999,"line":471},"start":{"line":465,"character":0}},"name":"_line_ending","definition":"sub","containerName":"main::"},{"name":"_chunk_line_ending","line":468,"kind":12},{"name":"_chunk_line_ending","kind":12,"line":470},{"containerName":"main::","definition":"sub","detail":"($self,$pos)","signature":{"label":"_chunk_seek($self,$pos)","documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int","parameters":[{"label":"$self"},{"label":"$pos"}]},"kind":12,"line":487,"children":[{"kind":13,"line":488,"containerName":"_chunk_seek","name":"$self","definition":"my","localvar":"my"},{"name":"$pos","containerName":"_chunk_seek","line":488,"kind":13},{"name":"$self","containerName":"_chunk_seek","line":489,"kind":13},{"name":"_sequential","containerName":"_chunk_seek","kind":12,"line":489},{"line":491,"kind":13,"localvar":"my","containerName":"_chunk_seek","definition":"my","name":"$fh"},{"name":"$self","containerName":"_chunk_seek","kind":13,"line":491},{"line":491,"kind":12,"name":"chunk","containerName":"_chunk_seek"},{"containerName":"_chunk_seek","name":"_fh","kind":12,"line":491},{"name":"$fh","containerName":"_chunk_seek","line":494,"kind":13},{"name":"$self","containerName":"_chunk_seek","kind":13,"line":494},{"kind":12,"line":494,"containerName":"_chunk_seek","name":"_chunk_true_start"},{"line":497,"kind":13,"containerName":"_chunk_seek","name":"$fh"},{"containerName":"_chunk_seek","name":"$pos","kind":13,"line":497}],"name":"_chunk_seek","range":{"end":{"line":498,"character":9999},"start":{"character":0,"line":487}}},{"containerName":"main::","definition":"sub","name":"_chunk_tell","range":{"start":{"line":514,"character":0},"end":{"line":520,"character":9999}},"kind":12,"line":514,"children":[{"kind":13,"line":515,"containerName":"_chunk_tell","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":516,"containerName":"_chunk_tell","name":"$self"},{"kind":12,"line":516,"name":"_sequential","containerName":"_chunk_tell"},{"kind":13,"line":518,"definition":"my","name":"$fh","containerName":"_chunk_tell","localvar":"my"},{"containerName":"_chunk_tell","name":"$self","line":518,"kind":13},{"kind":12,"line":518,"containerName":"_chunk_tell","name":"chunk"},{"containerName":"_chunk_tell","name":"_fh","line":518,"kind":12},{"name":"$fh","containerName":"_chunk_tell","kind":13,"line":519},{"containerName":"_chunk_tell","name":"$self","line":519,"kind":13},{"line":519,"kind":12,"containerName":"_chunk_tell","name":"_chunk_true_start"}]},{"name":"_get_chunk_by_nol","range":{"end":{"line":552,"character":9999},"start":{"line":533,"character":0}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_get_chunk_by_nol","line":534,"kind":13},{"kind":13,"line":534,"containerName":"_get_chunk_by_nol","name":"$nol"},{"name":"$nol","containerName":"_get_chunk_by_nol","line":535,"kind":13},{"name":"$self","containerName":"_get_chunk_by_nol","kind":13,"line":535},{"name":"throw","containerName":"_get_chunk_by_nol","kind":12,"line":535},{"line":539,"kind":13,"localvar":"my","containerName":"_get_chunk_by_nol","definition":"my","name":"$line"},{"name":"$count","containerName":"_get_chunk_by_nol","line":539,"kind":13},{"name":"$self","containerName":"_get_chunk_by_nol","kind":13,"line":540},{"kind":12,"line":540,"containerName":"_get_chunk_by_nol","name":"chunk"},{"name":"_readline","containerName":"_get_chunk_by_nol","line":540,"kind":12},{"kind":13,"line":541,"name":"$line","containerName":"_get_chunk_by_nol"},{"kind":13,"line":542,"name":"$count","containerName":"_get_chunk_by_nol"},{"kind":13,"line":543,"containerName":"_get_chunk_by_nol","name":"$count"},{"containerName":"_get_chunk_by_nol","name":"$nol","line":543,"kind":13},{"line":546,"kind":13,"localvar":"my","name":"$current","definition":"my","containerName":"_get_chunk_by_nol"},{"containerName":"_get_chunk_by_nol","name":"$self","line":546,"kind":13},{"containerName":"_get_chunk_by_nol","name":"_chunk_tell","kind":12,"line":546},{"localvar":"my","containerName":"_get_chunk_by_nol","name":"$end","definition":"my","line":547,"kind":13},{"line":547,"kind":13,"name":"$current","containerName":"_get_chunk_by_nol"},{"containerName":"_get_chunk_by_nol","name":"$self","line":547,"kind":13},{"kind":12,"line":547,"containerName":"_get_chunk_by_nol","name":"_chunk_true_start"},{"containerName":"_get_chunk_by_nol","name":"$current","line":548,"kind":13},{"kind":13,"line":548,"name":"$self","containerName":"_get_chunk_by_nol"},{"name":"_chunk_true_end","containerName":"_get_chunk_by_nol","kind":12,"line":548},{"kind":13,"line":548,"name":"$end","containerName":"_get_chunk_by_nol"},{"kind":13,"line":548,"containerName":"_get_chunk_by_nol","name":"$self"},{"containerName":"_get_chunk_by_nol","name":"_chunk_true_end","line":548,"kind":12},{"line":549,"kind":13,"containerName":"_get_chunk_by_nol","name":"$line"}],"line":533,"definition":"sub","containerName":"main::","signature":{"label":"_get_chunk_by_nol($self,$nol)","parameters":[{"label":"$self"},{"label":"$nol"}],"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)"},"detail":"($self,$nol)"},{"line":566,"children":[{"line":567,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_chunk_by_end"},{"line":567,"kind":13,"containerName":"_get_chunk_by_end","name":"$chunk_ending"},{"line":569,"kind":13,"localvar":"my","containerName":"_get_chunk_by_end","definition":"my","name":"$start"},{"line":569,"kind":13,"containerName":"_get_chunk_by_end","name":"$self"},{"name":"_chunk_tell","containerName":"_get_chunk_by_end","line":569,"kind":12},{"line":571,"kind":13,"localvar":"my","definition":"my","name":"$line_ending","containerName":"_get_chunk_by_end"},{"line":571,"kind":13,"containerName":"_get_chunk_by_end","name":"$self"},{"containerName":"_get_chunk_by_end","name":"_line_ending","line":571,"kind":12},{"name":"$chunk_ending","containerName":"_get_chunk_by_end","line":572,"kind":13},{"name":"$chunk_ending","containerName":"_get_chunk_by_end","kind":13,"line":573},{"localvar":"my","containerName":"_get_chunk_by_end","definition":"my","name":"$line","line":574,"kind":13},{"kind":13,"line":574,"name":"$self","containerName":"_get_chunk_by_end"},{"line":574,"kind":12,"name":"chunk","containerName":"_get_chunk_by_end"},{"containerName":"_get_chunk_by_end","name":"_readline","kind":12,"line":574},{"kind":13,"line":576,"containerName":"_get_chunk_by_end","name":"$current","definition":"my","localvar":"my"},{"containerName":"_get_chunk_by_end","name":"$self","line":576,"kind":13},{"name":"_chunk_tell","containerName":"_get_chunk_by_end","line":576,"kind":12},{"name":"$end","definition":"my","containerName":"_get_chunk_by_end","localvar":"my","kind":13,"line":577},{"name":"$current","containerName":"_get_chunk_by_end","kind":13,"line":577},{"name":"$self","containerName":"_get_chunk_by_end","line":577,"kind":13},{"name":"_chunk_true_start","containerName":"_get_chunk_by_end","kind":12,"line":577},{"line":578,"kind":13,"name":"$current","containerName":"_get_chunk_by_end"},{"name":"$self","containerName":"_get_chunk_by_end","kind":13,"line":578},{"kind":12,"line":578,"containerName":"_get_chunk_by_end","name":"_chunk_true_end"},{"name":"$end","containerName":"_get_chunk_by_end","line":578,"kind":13},{"line":578,"kind":13,"containerName":"_get_chunk_by_end","name":"$self"},{"line":578,"kind":12,"containerName":"_get_chunk_by_end","name":"_chunk_true_end"},{"name":"$line","containerName":"_get_chunk_by_end","kind":13,"line":579},{"containerName":"_get_chunk_by_end","name":"$self","line":582,"kind":13},{"name":"_chunk_seek","containerName":"_get_chunk_by_end","kind":12,"line":582},{"line":582,"kind":13,"containerName":"_get_chunk_by_end","name":"$start"}],"kind":12,"detail":"($self,$chunk_ending)","signature":{"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)\n\n\nsub _get_chunk_by_nol {\n    my ($self, $nol) = @_;\n    $nol > 0 || $self->throw(\"Can't request a chunk of fewer than 1 lines\");\n    \n    # hope that $/ is \\n\n    \n    my ($line, $count);\n    while (defined($_ = $self->chunk->_readline)) {\n        $line .= $_;\n        $count++;\n        last if $count == $nol;\n    }\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    return;\n}\n\n=head2 _get_chunk_by_end\n\n Title   : _get_chunk_by_end\n Usage   : my $string = $obj->_get_chunk_by_end;\n Function: Get a chunk of chunk() from the current position onward till the end\n           of the line, as defined by the supplied argument.\n Returns : string\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)","parameters":[{"label":"$self"},{"label":"$chunk_ending"}],"label":"_get_chunk_by_end($self,$chunk_ending)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":584},"start":{"line":566,"character":0}},"name":"_get_chunk_by_end"},{"range":{"start":{"line":602,"character":0},"end":{"line":621,"character":9999}},"name":"_find_chunk_by_end","detail":"($self,$chunk_ending)","signature":{"parameters":[{"label":"$self"},{"label":"$chunk_ending"}],"documentation":"1;\n# $Id: PullParserI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PullParserI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PullParserI - A base module for fast 'pull' parsing\n\n=head1 SYNOPSIS\n\n    # do not use this class, it is intended for parser module\n    # writers only\n\n=head1 DESCRIPTION\n\nIf you are writing a module to parse some new format, you may wish to use\na 'pull' approach whereby you only do work (reading file data, parsing it,\nturning the parsed data in an object) when absolutely necessary.\n\nPullParserI provides a system for doing exactly that. As a PullParser you\nneed a chunk. A chunk is just a Bio::Root::IO that contains all the raw data\nyou would want to parse. You can use the chunk() method to create a chunk from\na filename, existing filehandle or even a string. If you make a chunk from a\nlarge file, but actually only want your chunk to be some portion of the whole\nfile, supply start and end amounts in bytes to chunk() at the same time.\nThe methods _chunk_seek() and _chunk_tell() provide seeks and tells that are\nrelative to the start and end of your chunk, not the whole file.\n\nThe other thing you will need to decide when making a chunk is how to handle\npiped input. A PullParser typically needs seekable data to parse, so if your\ndata is piped in and unseekable, you must decide between creating a temp file\nor reading the input into memory, which will be done before the chunk becomes\nusable and you can begin any parsing. Alternatively you can choose to force\na sequential read, in which case you can make use of _dependencies() to define\nthe linear order of methods that would result in the file being read\nsequentially. The return value of _sequential() is also useful here, if you\nwould need to cache some data or otherwise behave differently during a\nsequential read.\n\nThe main method in the system is get_field(). This method relies on the\nexistance of a private hash reference accessible to it with the method\n_fields(). That hash ref should have as keys all the sorts of data you will want\nto parse (eg. 'score'), and prior to parsing the values would be undefined. A\nuser of your module can then call either $module-E<gt>get_field('score') or\n$module-E<gt>score and get_field will either return the answer from\n$self-E<gt>_fields-E<gt>{score} if it is defined, or call a method _discover_score()\nfirst if not. So for the system to work you need to define a _discover_*()\nmethod for every field in the fields hash, and ensure that the method stores an\nanswer in the fields hash.\n\nHow you implement your _discover_* methods is up to you, though you should never\ncall a _discover_* method directly yourself; always use get_field(), since\nget_field() will deal with calling dependant methods for you if a forced\nsequenctial read is in progress due to piped input. You will almost certainly\nwant to make use of the various chunk-related methods of this class (that are\ndenoted private by the leading '_'; this means you can use them as the author of\na parser class, but users of your parser should not). \n\nPrimary amongst them is _*_chunk_by_end() to which you provide text that\nrepresents the end of your desired chunk and it does a readline with your\nargument as $/. The chunk knows about its line-endings, so if you want your\nend definition to include a new line, just always use \"\\n\" and PullParserI will\ndo any necessary conversion for you.\n\nIf your input data is hierarchical (eg. report-E<gt>many results-E<gt>many hits-E<gt>many\nhsps), and you want an object at the leaf of the hierarchy to have access to\ninformation that is shared amongst all of them (is parsed in the root), you\ndon't have to copy the data to each leaf object; simply by defining parent(),\nwhen you call get_field() and the requested field isn't in your leaf's fields\nhash, the leaf's parent will be asked for the field instead, and so on till\nroot.\n\nSee Bio::SearchIO::hmmer_pull for an example of implementing a parser using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nInspired by a posting by Aaron J. Mackey\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PullParserI;\n\nuse vars qw($AUTOLOAD $FORCE_TEMP_FILE);\nuse strict;\n\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::RootI);\n\nBEGIN {\n    # chunk() needs perl 5.8 feature for modes other than temp_file, so will\n    # workaround by forcing temp_file mode in <5.8. Could also rewrite using\n    # IO::String, but don't want to.\n    if ($] < 5.008) {\n        $FORCE_TEMP_FILE = 1;\n    }\n}\n\n=head2 _fields\n\n Title   : _fields\n Usage   : $obj->_fields( { field1 => undef } );\n           my $fields_ref = $obj->_fields;\n Function: Get/set the hash reference containing all the fields for this parser\n Returns : hash ref\n Args    : none to get, OR hash ref to set\n\n\nsub _fields {\n    my $self = shift;\n    if (@_) {\n        $self->{_fields} = shift;\n    }\n    unless (defined $self->{_fields}) {\n        $self->{_fields} = { };\n    }\n    return $self->{_fields};\n}\n\n=head2 has_field\n\n Title   : has_field\n Usage   : if ($obj->has_field('field_name') {...}\n Function: Ask if a particular object has a given field (doesn't ask ancestors)\n Returns : boolean\n Args    : string (the field name to test)\n\n\nsub has_field {\n    my ($self, $desired) = @_;\n    $desired || return;\n    return exists $self->_fields->{$desired};\n}\n\n=head2 get_field\n\n Title   : get_field\n Usage   : my $field_value = $obj->get_field('field_name');\n Function: Get the value of a given field. If this $obj doesn't have the field,\n           it's parent() will be asked, and so on until there are no more\n           parents.\n Returns : scalar, warns if a value for the field couldn't be found and returns\n           undef.\n Args    : string (the field to get)\n\n\nsub get_field {\n    my $self = shift;\n    my $desired = shift || return keys %{$self->_fields};\n    if (exists $self->_fields->{$desired}) {\n        unless (defined $self->_fields->{$desired}) {\n            my $method = '_discover_'.$desired;\n            \n            my $dependency = $self->_dependencies($desired);\n            if ($dependency && ! defined $self->_fields->{$dependency}) {\n                $self->get_field($dependency);\n            }\n            \n            # it might exist now\n            $self->$method unless defined $self->_fields->{$desired};\n        }\n        return $self->_fields->{$desired};\n    }\n    \n    # is it a field of our parent? (checks all ancestors)\n    if (my $parent = $self->parent) {\n        return $parent->get_field($desired);\n    }\n    \n    $desired =~ s/_discover_//;\n    $self->warn(\"This report does not hold information about '$desired'\");\n    return;\n}\n\n=head2 parent\n\n Title   : parent\n Usage   : $obj->parent($parent_obj);\n           my $parent_obj = $obj->parent;\n Function: Get/set the parent object of this one.\n Returns : Bio::PullParserI\n Args    : none to get, OR Bio::PullParserI to set\n\n\nsub parent {\n    my $self = shift;\n    if (@_) { $self->{parent} = shift }\n    return $self->{parent} || return;\n}\n\n=head2 chunk\n\n Title   : chunk\n Usage   : $obj->chunk($filename);\n           my $chunk = $obj->chunk;\n Function: Get/set the chunk of this parser.\n Returns : Bio:Root::IO\n Args    : none to get, OR\n           First argument of a GLOB reference, filename string, string data to\n           treat as the chunk, or Bio::Root::IO.\n           Optionally, also provide:\n           -start => int : the byte position within the thing described by the\n                           first arguement to consider as the start of this\n                           chunk (default 0)\n           -end   => int : the byte position to consider as the end (default\n                           true end)\n           -piped_behaviour => 'memory'|'temp_file'|'sequential_read'\n\n           The last option comes into effect when the first argument is\n           something that cannot be seeked (eg. piped input filehandle).\n            'memory'          means read all the piped input into a string\n                              first, then set the chunk to that string.\n            'temp_file'       means read all the piped input and output it to\n                              a temp file, then set the chunk to that temp file.\n            'sequential_read' means that the piped input should be read\n                              sequentially and your parsing code must cope with\n                              not being able to seek.\n           'memory' is the fastest but uses the most memory. 'temp_file' and\n           'sequential_read' can be slow, with 'temp_file' being the most memory\n           efficient but requiring disc space. The default is 'sequential_read'.\n           Note that in versions of perl earlier than 5.8 only temp_file works\n           and will be used regardless of what value is supplied here.\n\n\nsub chunk {\n    my $self = shift;\n    \n    if (@_) {\n        my $thing = shift || $self->throw(\"Trying to set chunk() to an undefined value\");\n        if (ref($thing) eq 'GLOB') {\n            $self->{_chunk} = Bio::Root::IO->new(-fh => $thing);\n        }\n        elsif (ref(\\$thing) eq 'SCALAR') {\n            if ($thing !~ /\\n/ && -e $thing) {\n                $self->{_chunk} = Bio::Root::IO->new(-file => $thing);\n            }\n            else {\n                unless ($FORCE_TEMP_FILE) {\n                    # treat a string as a filehandle\n                    open(my $fake_fh, \"+<\", \\$thing); # requires perl 5.8\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $fake_fh);\n                }\n                else {\n                    my ($handle) = $self->{_chunk}->tempfile();\n                    print $handle $thing;\n                    $self->{_chunk} = Bio::Root::IO->new(-fh => $handle);\n                }\n            }\n        }\n        elsif ($thing->isa('Bio::Root::IO')) {\n            $self->{_chunk} = $thing;\n        }\n        else {\n            $self->throw(\"Unknown input into chunk()\");\n        }\n        \n        my ($piped_behaviour, $start, $end);\n        if (@_) {\n            ($piped_behaviour, $start, $end) =\n                $self->_rearrange([qw(PIPED_BEHAVIOUR START END)], @_);\n        }\n        $piped_behaviour ||= 'sequential_read';\n        $FORCE_TEMP_FILE && ($piped_behaviour = 'temp_file');\n        $start ||= 0;\n        $self->_chunk_true_start($start);\n        $self->_chunk_true_end($end);\n        \n        # determine if the chunk is seekable\n        my $fh = $self->{_chunk}->_fh;\n        seek($fh, 0, 0);\n        my $first_line = <$fh>;\n        seek($fh, 0, 0);\n        my $seekable = tell($fh) == 0;\n        unless ($seekable) {\n            if ($piped_behaviour eq 'memory') {\n                my $string = $first_line;\n                while (<$fh>) {\n                    $string .= $_;\n                }\n                $self->chunk($string);\n            }\n            elsif ($piped_behaviour eq 'temp_file') {\n                my ($handle) = $self->{_chunk}->tempfile();\n                print $handle $first_line;\n                while (<$fh>) {\n                    print $handle $_;\n                }\n                seek($handle, 0, 0);\n                $self->chunk($handle);\n            }\n            elsif ($piped_behaviour eq 'sequential_read') {\n                $self->{_chunk}->_pushback($first_line);\n                $self->_sequential(1);\n            }\n            else {\n                $self->throw(\"Unknown piped behaviour type '$piped_behaviour'\");\n            }\n        }\n        \n        # determine our line ending\n        if ($first_line =~ /\\r\\n/) {\n            $self->_line_ending(\"\\r\\n\");\n        }\n        elsif ($first_line =~ /\\r/) {\n            $self->_line_ending(\"\\r\");\n        }\n        else {\n            $self->_line_ending(\"\\n\");\n        }\n    }\n    \n    return $self->{_chunk} || return;\n}\n\n=head2 _sequential\n\n Title   : _sequential\n Usage   : if ($obj->_sequential) {...}\n Function: Ask if we have to do operations such that the input is read\n           sequentially.\n Returns : boolean\n Args    : none to get, OR boolean to set (typically, you should never set this\n           yourself)\n\n\nsub _sequential {\n    my $self = shift;\n    if (@_) {\n        $self->{_sequential} = shift;\n    }\n    return $self->{_sequential} || 0;\n}\n\n=head2 _dependencies\n\n Title   : _dependencies\n Usage   : $obj->_dependencies( { field1 => field2 } );\n           my $dependancy = $obj->_dependencies('field_name');\n Function: Set the fields that are dependent on each other, or get the field\n           than another is dependent upon.\n Returns : string (a field name)\n Args    : string (a field name) to get, OR hash ref to initially set, with\n           field names as keys and values, key field being dependent upon value\n           field.\n\n\nsub _dependencies {\n    my ($self, $thing) = @_;\n    $thing || return;\n    if (ref($thing) eq 'HASH') {\n        $self->{_dependencies} = $thing;\n    }\n    else {\n        return $self->{_dependencies}->{$thing};\n    }\n}\n\n=head2 _chunk_true_start\n\n Title   : _chunk_true_start\n Usage   : my $true_start = $obj->_chunk_true_start;\n Function: Get/set the true start position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_start {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_start} = shift;\n    }\n    return $self->{_chunk_start} || 0;\n}\n\n=head2 _chunk_true_end\n\n Title   : _chunk_true_end\n Usage   : my $true_end = $obj->_chunk_true_end;\n Function: Get/set for the true end position of the chunk within the filehandle\n           it is part of.\n Returns : int\n Args    : none to get, OR int to set (typically, you won't set this yourself)\n\n\nsub _chunk_true_end {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_end} = shift;\n    }\n    return $self->{_chunk_end};\n}\n\n=head2 _line_ending\n\n Title   : _line_ending\n Usage   : my $line_ending = $obj->_line_ending;\n Function: Get/set for the line ending for the chunk.\n Returns : string\n Args    : none to get, OR string to set (typically, you won't set this\n           yourself)\n\n\nsub _line_ending {\n    my $self = shift;\n    if (@_) {\n        $self->{_chunk_line_ending} = shift;\n    }\n    return $self->{_chunk_line_ending};\n}\n\n=head2 _chunk_seek\n\n Title   : _chunk_seek\n Usage   : $obj->_chunk_seek($pos);\n Function: seek() the chunk to the provided position in bytes, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : n/a\n Args    : int\n\n\nsub _chunk_seek {\n    my ($self, $pos) = @_;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    \n    # seek to the defined start\n    seek($fh, $self->_chunk_true_start, 0);\n    \n    # now seek to desired position relative to defined start\n    seek($fh, $pos, 1);\n}\n\n=head2 _chunk_tell\n\n Title   : _chunk_seek\n Usage   : my $pos = $obj->_chunk_tell;\n Function: Get the current tell() position within the chunk, relative to the\n           defined start of the chunk within its filehandle.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : int\n Args    : none\n\n\nsub _chunk_tell {\n    my $self = shift;\n    return if $self->_sequential;\n    \n    my $fh = $self->chunk->_fh;\n    return tell($fh) - $self->_chunk_true_start;\n}\n\n=head2 _get_chunk_by_nol\n\n Title   : _chunk_seek\n Usage   : my $string = $obj->_get_chunk_by_nol;\n Function: Get a chunk of chunk() from the current position onward for the given\n           number of lines.\n Returns : string\n Args    : int (number of lines you want)\n\n\nsub _get_chunk_by_nol {\n    my ($self, $nol) = @_;\n    $nol > 0 || $self->throw(\"Can't request a chunk of fewer than 1 lines\");\n    \n    # hope that $/ is \\n\n    \n    my ($line, $count);\n    while (defined($_ = $self->chunk->_readline)) {\n        $line .= $_;\n        $count++;\n        last if $count == $nol;\n    }\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    return;\n}\n\n=head2 _get_chunk_by_end\n\n Title   : _get_chunk_by_end\n Usage   : my $string = $obj->_get_chunk_by_end;\n Function: Get a chunk of chunk() from the current position onward till the end\n           of the line, as defined by the supplied argument.\n Returns : string\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)\n\n\nsub _get_chunk_by_end {\n    my ($self, $chunk_ending) = @_;\n    \n    my $start = $self->_chunk_tell;\n    \n    my $line_ending = $self->_line_ending;\n    $chunk_ending =~ s/\\n/$line_ending/g;\n    local $/ = $chunk_ending || '';\n    my $line = $self->chunk->_readline;\n    \n    my $current = $self->_chunk_tell;\n    my $end = ($current || 0) + $self->_chunk_true_start;\n    if (! $current || ($self->_chunk_true_end ? $end <= $self->_chunk_true_end : 1)) {\n        return $line;\n    }\n    \n    $self->_chunk_seek($start);\n    return;\n}\n\n=head2 _find_chunk_by_end\n\n Title   : _find_chunk_by_end\n Usage   : my $string = $obj->_find_chunk_by_end;\n Function: Get the start and end of what would be a chunk of chunk() from the\n           current position onward till the end of the line, as defined by the\n           supplied argument.\n\n           In _sequential() mode, this function does nothing.\n\n Returns : _chunk_tell values for start and end in 2 element list\n Args    : string (line ending - if you want the line ending to include a new\n           line, always use \\n)","label":"_find_chunk_by_end($self,$chunk_ending)"},"containerName":"main::","definition":"sub","line":602,"children":[{"line":603,"kind":13,"localvar":"my","containerName":"_find_chunk_by_end","name":"$self","definition":"my"},{"name":"$chunk_ending","containerName":"_find_chunk_by_end","line":603,"kind":13},{"line":604,"kind":13,"name":"$self","containerName":"_find_chunk_by_end"},{"kind":12,"line":604,"containerName":"_find_chunk_by_end","name":"_sequential"},{"line":606,"kind":13,"localvar":"my","containerName":"_find_chunk_by_end","definition":"my","name":"$line_ending"},{"kind":13,"line":606,"containerName":"_find_chunk_by_end","name":"$self"},{"line":606,"kind":12,"containerName":"_find_chunk_by_end","name":"_line_ending"},{"containerName":"_find_chunk_by_end","name":"$chunk_ending","kind":13,"line":607},{"containerName":"_find_chunk_by_end","name":"$chunk_ending","line":608,"kind":13},{"kind":13,"line":610,"containerName":"_find_chunk_by_end","definition":"my","name":"$start","localvar":"my"},{"containerName":"_find_chunk_by_end","name":"$self","kind":13,"line":610},{"kind":12,"line":610,"containerName":"_find_chunk_by_end","name":"_chunk_tell"},{"line":611,"kind":13,"containerName":"_find_chunk_by_end","name":"$self"},{"kind":12,"line":611,"containerName":"_find_chunk_by_end","name":"chunk"},{"name":"_readline","containerName":"_find_chunk_by_end","kind":12,"line":611},{"localvar":"my","containerName":"_find_chunk_by_end","name":"$end","definition":"my","line":612,"kind":13},{"kind":13,"line":612,"name":"$self","containerName":"_find_chunk_by_end"},{"kind":12,"line":612,"containerName":"_find_chunk_by_end","name":"_chunk_tell"},{"localvar":"my","name":"$comp_end","definition":"my","containerName":"_find_chunk_by_end","line":614,"kind":13},{"name":"$end","containerName":"_find_chunk_by_end","kind":13,"line":614},{"kind":13,"line":614,"name":"$self","containerName":"_find_chunk_by_end"},{"kind":12,"line":614,"name":"_chunk_true_start","containerName":"_find_chunk_by_end"},{"kind":13,"line":615,"name":"$self","containerName":"_find_chunk_by_end"},{"line":615,"kind":12,"containerName":"_find_chunk_by_end","name":"_chunk_true_end"},{"kind":13,"line":615,"containerName":"_find_chunk_by_end","name":"$comp_end"},{"containerName":"_find_chunk_by_end","name":"$self","line":615,"kind":13},{"line":615,"kind":12,"containerName":"_find_chunk_by_end","name":"_chunk_true_end"},{"kind":13,"line":616,"containerName":"_find_chunk_by_end","name":"$start"},{"name":"$end","containerName":"_find_chunk_by_end","line":616,"kind":13},{"name":"$self","containerName":"_find_chunk_by_end","kind":13,"line":619},{"kind":12,"line":619,"containerName":"_find_chunk_by_end","name":"_chunk_seek"},{"line":619,"kind":13,"containerName":"_find_chunk_by_end","name":"$start"}],"kind":12},{"containerName":"main::","definition":"sub","name":"AUTOLOAD","range":{"end":{"line":643,"character":9999},"start":{"line":634,"character":0}},"kind":12,"line":634,"children":[{"line":635,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"AUTOLOAD"},{"line":636,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"line":638,"kind":13,"localvar":"my","containerName":"AUTOLOAD","definition":"my","name":"$name"},{"kind":13,"line":638,"containerName":"AUTOLOAD","name":"$AUTOLOAD"},{"containerName":"AUTOLOAD","name":"$name","line":639,"kind":13},{"line":642,"kind":13,"name":"$self","containerName":"AUTOLOAD"},{"name":"get_field","containerName":"AUTOLOAD","kind":12,"line":642},{"kind":13,"line":642,"containerName":"AUTOLOAD","name":"$name"}]}],"version":5}