{"vars":[{"kind":2,"line":91,"name":"base","containerName":""},{"line":105,"children":[{"containerName":"name","name":"throw_not_implemented","line":106,"kind":12}],"kind":12,"range":{"start":{"line":105,"character":0},"end":{"character":9999,"line":107}},"containerName":"main::","definition":"sub","name":"name"},{"line":121,"children":[{"containerName":"description","name":"throw_not_implemented","line":122,"kind":12}],"kind":12,"range":{"start":{"line":121,"character":0},"end":{"character":9999,"line":123}},"containerName":"main::","name":"description","definition":"sub"},{"range":{"end":{"character":9999,"line":139},"start":{"line":136,"character":0}},"name":"type","children":[{"kind":13,"line":137,"containerName":"type","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":138,"name":"$self","containerName":"type"},{"kind":12,"line":138,"containerName":"type","name":"throw_not_implemented"}],"line":136,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::MarkerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::MarkerI - A Population Genetic conceptual marker\n\n=head1 SYNOPSIS\n\n# Get a Bio::PopGen::MarkerI somehow - like using a Bio::PopGen::Marker\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n\n=head1 DESCRIPTION\n\nThis is the basic interface for Markers which one can associate\nalleles with for calculating Theta and Pi.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::MarkerI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI Bio::AnnotatableI);\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : \n\n\n\nsub name{\n   $_[0]->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    $_[0]->throw_not_implemented();\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string","label":"type($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":156},"start":{"line":153,"character":0}},"name":"unique_id","children":[{"kind":13,"line":154,"definition":"my","name":"$self","containerName":"unique_id","localvar":"my"},{"line":155,"kind":13,"name":"$self","containerName":"unique_id"},{"kind":12,"line":155,"name":"throw_not_implemented","containerName":"unique_id"}],"line":153,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::MarkerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::MarkerI - A Population Genetic conceptual marker\n\n=head1 SYNOPSIS\n\n# Get a Bio::PopGen::MarkerI somehow - like using a Bio::PopGen::Marker\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n\n=head1 DESCRIPTION\n\nThis is the basic interface for Markers which one can associate\nalleles with for calculating Theta and Pi.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::MarkerI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI Bio::AnnotatableI);\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : \n\n\n\nsub name{\n   $_[0]->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    $_[0]->throw_not_implemented();\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string","label":"unique_id($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"detail":"($self,@args)","signature":{"label":"annotation($self,@args)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::MarkerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::MarkerI - A Population Genetic conceptual marker\n\n=head1 SYNOPSIS\n\n# Get a Bio::PopGen::MarkerI somehow - like using a Bio::PopGen::Marker\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n\n=head1 DESCRIPTION\n\nThis is the basic interface for Markers which one can associate\nalleles with for calculating Theta and Pi.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::MarkerI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI Bio::AnnotatableI);\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : \n\n\n\nsub name{\n   $_[0]->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    $_[0]->throw_not_implemented();\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($seq_obj)\n Function: retrieve the attached annotation object\n Returns : Bio::AnnotationCollectionI or none;\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information. This method comes through extension from\nL<Bio::AnnotatableI>.","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":174,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"annotation","line":175,"kind":13},{"containerName":"annotation","name":"@args","line":175,"kind":13},{"name":"$self","containerName":"annotation","kind":13,"line":176},{"name":"throw_not_implemented","containerName":"annotation","line":176,"kind":12}],"kind":12,"range":{"end":{"line":177,"character":9999},"start":{"character":0,"line":174}},"name":"annotation"},{"name":"get_Alleles","range":{"start":{"character":0,"line":191},"end":{"character":9999,"line":194}},"kind":12,"children":[{"containerName":"get_Alleles","name":"$self","definition":"my","localvar":"my","kind":13,"line":192},{"line":193,"kind":13,"name":"$self","containerName":"get_Alleles"},{"line":193,"kind":12,"name":"throw_not_implemented","containerName":"get_Alleles"}],"line":191,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::MarkerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::MarkerI - A Population Genetic conceptual marker\n\n=head1 SYNOPSIS\n\n# Get a Bio::PopGen::MarkerI somehow - like using a Bio::PopGen::Marker\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n\n=head1 DESCRIPTION\n\nThis is the basic interface for Markers which one can associate\nalleles with for calculating Theta and Pi.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::MarkerI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI Bio::AnnotatableI);\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : \n\n\n\nsub name{\n   $_[0]->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    $_[0]->throw_not_implemented();\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($seq_obj)\n Function: retrieve the attached annotation object\n Returns : Bio::AnnotationCollectionI or none;\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information. This method comes through extension from\nL<Bio::AnnotatableI>.\n\n\n\n\nsub annotation{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $marker->get_Alleles();\n Function: Get the available marker alleles if they are known and stored\n Returns : Array of strings\n Args    : none","label":"get_Alleles($self)"},"detail":"($self)"},{"name":"get_Allele_Frequencies","range":{"end":{"character":9999,"line":214},"start":{"line":211,"character":0}},"kind":12,"children":[{"line":212,"kind":13,"localvar":"my","containerName":"get_Allele_Frequencies","name":"$self","definition":"my"},{"containerName":"get_Allele_Frequencies","name":"$self","kind":13,"line":213},{"name":"throw_not_implemented","containerName":"get_Allele_Frequencies","kind":12,"line":213}],"line":211,"definition":"sub","containerName":"main::","signature":{"label":"get_Allele_Frequencies($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::MarkerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::MarkerI - A Population Genetic conceptual marker\n\n=head1 SYNOPSIS\n\n# Get a Bio::PopGen::MarkerI somehow - like using a Bio::PopGen::Marker\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n\n=head1 DESCRIPTION\n\nThis is the basic interface for Markers which one can associate\nalleles with for calculating Theta and Pi.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::MarkerI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI Bio::AnnotatableI);\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : \n\n\n\nsub name{\n   $_[0]->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    $_[0]->throw_not_implemented();\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($seq_obj)\n Function: retrieve the attached annotation object\n Returns : Bio::AnnotationCollectionI or none;\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information. This method comes through extension from\nL<Bio::AnnotatableI>.\n\n\n\n\nsub annotation{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $marker->get_Alleles();\n Function: Get the available marker alleles if they are known and stored\n Returns : Array of strings\n Args    : none\n\n\n\nsub get_Alleles{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array (hash) where keys are the names of the alleles\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)"}],"version":5}