{"version":5,"vars":[{"kind":2,"line":101,"containerName":"","name":"vars"},{"line":104,"kind":2,"name":"strict","containerName":""},{"line":104,"kind":13,"name":"$FieldDelim","containerName":null},{"name":"$AlleleDelim","containerName":null,"kind":13,"line":104},{"containerName":null,"name":"$NoHeader","line":104,"kind":13},{"containerName":"","name":"base","line":113,"kind":2},{"name":"_initialize","range":{"start":{"line":129,"character":0},"end":{"character":9999,"line":143}},"kind":12,"children":[{"kind":13,"line":130,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"line":130,"kind":13,"name":"@args","containerName":"_initialize"},{"localvar":"my","containerName":"_initialize","definition":"my","name":"$fieldsep","line":131,"kind":13},{"containerName":"_initialize","name":"$all_sep","kind":13,"line":131},{"name":"$noheader","containerName":"_initialize","line":132,"kind":13},{"kind":13,"line":132,"name":"$self","containerName":"_initialize"},{"kind":12,"line":132,"name":"_rearrange","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","line":134,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":137},{"kind":12,"line":137,"containerName":"_initialize","name":"flag"},{"kind":13,"line":137,"name":"$noheader","containerName":"_initialize"},{"name":"$noheader","containerName":"_initialize","line":137,"kind":13},{"containerName":"_initialize","name":"$NoHeader","line":137,"kind":13},{"containerName":"_initialize","name":"$self","line":138,"kind":13},{"kind":12,"line":138,"name":"flag","containerName":"_initialize"},{"kind":13,"line":138,"containerName":"_initialize","name":"$fieldsep"},{"kind":13,"line":138,"name":"$fieldsep","containerName":"_initialize"},{"name":"$FieldDelim","containerName":"_initialize","kind":13,"line":138},{"kind":13,"line":139,"name":"$self","containerName":"_initialize"},{"name":"flag","containerName":"_initialize","kind":12,"line":139},{"containerName":"_initialize","name":"$all_sep","line":139,"kind":13},{"name":"$all_sep","containerName":"_initialize","kind":13,"line":139},{"containerName":"_initialize","name":"$AlleleDelim","kind":13,"line":139},{"name":"$self","containerName":"_initialize","line":141,"kind":13}],"line":129,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,","label":"_initialize($self,@args)"},"detail":"($self,@args)"},{"line":158,"children":[{"name":"$self","definition":"my","containerName":"flag","localvar":"my","kind":13,"line":159},{"localvar":"my","definition":"my","name":"$fieldname","containerName":"flag","line":160,"kind":13},{"line":161,"kind":13,"containerName":"flag","name":"$fieldname"},{"containerName":"flag","name":"$self","kind":13,"line":163},{"kind":13,"line":163,"name":"$fieldname","containerName":"flag"},{"kind":13,"line":164,"containerName":"flag","name":"$self"},{"containerName":"flag","name":"$fieldname","kind":13,"line":164}],"kind":12,"range":{"start":{"line":158,"character":0},"end":{"character":9999,"line":165}},"containerName":"main::","name":"flag","definition":"sub"},{"line":179,"children":[{"containerName":"next_individual","name":"$self","definition":"my","localvar":"my","kind":13,"line":180},{"name":"$self","containerName":"next_individual","line":181,"kind":13},{"containerName":"next_individual","name":"_readline","kind":12,"line":181},{"containerName":"next_individual","name":"$self","line":186,"kind":13},{"kind":12,"line":186,"containerName":"next_individual","name":"flag"},{"line":187,"kind":13,"containerName":"next_individual","name":"$self"},{"kind":13,"line":191,"definition":"my","name":"$samp","containerName":"next_individual","localvar":"my"},{"kind":13,"line":191,"containerName":"next_individual","name":"@marker_results"},{"name":"$self","containerName":"next_individual","kind":13,"line":193},{"line":193,"kind":12,"containerName":"next_individual","name":"flag"},{"containerName":"next_individual","name":"$self","line":193,"kind":13},{"containerName":"next_individual","name":"flag","kind":12,"line":193},{"name":"$samp","containerName":"next_individual","line":195,"kind":13},{"line":195,"kind":13,"containerName":"next_individual","name":"@marker_results"},{"name":"$self","containerName":"next_individual","kind":13,"line":195},{"line":195,"kind":12,"name":"flag","containerName":"next_individual"},{"definition":"my","name":"$fielddelim","containerName":"next_individual","localvar":"my","kind":13,"line":199},{"containerName":"next_individual","name":"$self","kind":13,"line":199},{"kind":12,"line":199,"containerName":"next_individual","name":"flag"},{"line":200,"kind":13,"localvar":"my","containerName":"next_individual","name":"$alleledelim","definition":"my"},{"name":"$self","containerName":"next_individual","kind":13,"line":200},{"line":200,"kind":12,"name":"flag","containerName":"next_individual"},{"line":202,"kind":13,"containerName":"next_individual","name":"$samp"},{"name":"@marker_results","containerName":"next_individual","line":205,"kind":13},{"localvar":"my","containerName":"next_individual","definition":"my","name":"$i","line":211,"kind":13},{"containerName":"next_individual","definition":"my","name":"$m","localvar":"my","kind":13,"line":212},{"line":212,"kind":13,"name":"@marker_results","containerName":"next_individual"},{"containerName":"next_individual","name":"$m","line":213,"kind":13},{"containerName":"next_individual","name":"$m","kind":13,"line":214},{"localvar":"my","name":"$markername","definition":"my","containerName":"next_individual","line":215,"kind":13},{"containerName":"next_individual","name":"$self","line":216,"kind":13},{"containerName":"next_individual","name":"$markername","kind":13,"line":217},{"kind":13,"line":217,"name":"$self","containerName":"next_individual"},{"kind":13,"line":217,"name":"$i","containerName":"next_individual"},{"name":"$markername","containerName":"next_individual","line":219,"kind":13},{"kind":13,"line":221,"name":"$self","containerName":"next_individual"},{"line":221,"kind":12,"name":"debug","containerName":"next_individual"},{"line":223,"kind":13,"localvar":"my","containerName":"next_individual","definition":"my","name":"@alleles"},{"line":223,"kind":13,"containerName":"next_individual","name":"$self"},{"containerName":"next_individual","name":"flag","kind":12,"line":223},{"name":"$m","containerName":"next_individual","kind":13,"line":223},{"containerName":"next_individual","name":"$m","kind":13,"line":225},{"name":"new","containerName":"next_individual","kind":12,"line":225},{"kind":13,"line":225,"name":"@alleles","containerName":"next_individual"},{"name":"$markername","containerName":"next_individual","kind":13,"line":226},{"containerName":"next_individual","name":"$samp","line":227,"kind":13},{"kind":13,"line":228,"name":"$i","containerName":"next_individual"},{"name":"new","containerName":"next_individual","line":230,"kind":12},{"containerName":"next_individual","name":"$samp","line":230,"kind":13},{"containerName":"next_individual","name":"@marker_results","line":231,"kind":13},{"containerName":"next_individual","name":"$self","kind":13,"line":234},{"name":"$self","containerName":"next_individual","kind":13,"line":234},{"line":234,"kind":12,"containerName":"next_individual","name":"flag"},{"name":"$self","containerName":"next_individual","kind":13,"line":235},{"name":"next_individual","containerName":"next_individual","kind":12,"line":235}],"kind":12,"detail":"($self)","signature":{"label":"next_individual($self)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":238,"character":9999},"start":{"line":179,"character":0}},"name":"next_individual"},{"line":225,"kind":12,"name":"Bio","containerName":"PopGen::Genotype"},{"name":"Bio","containerName":"PopGen::Individual","line":230,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_population($self)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n Plan is to just return the whole dataset as a single population by\n default I think - people would then have each population in a separate\n file.","parameters":[{"label":"$self"}]},"kind":12,"line":256,"children":[{"containerName":"next_population","definition":"my","name":"$self","localvar":"my","kind":13,"line":257},{"line":258,"kind":13,"localvar":"my","containerName":"next_population","name":"@inds","definition":"my"},{"line":259,"kind":13,"localvar":"my","containerName":"next_population","name":"$ind","definition":"my"},{"name":"$self","containerName":"next_population","kind":13,"line":259},{"line":259,"kind":12,"name":"next_individual","containerName":"next_population"},{"name":"@inds","containerName":"next_population","kind":13,"line":260},{"containerName":"next_population","name":"$ind","line":260,"kind":13},{"kind":12,"line":262,"containerName":"next_population","name":"new"},{"kind":13,"line":262,"containerName":"next_population","name":"@inds"}],"name":"next_population","range":{"start":{"line":256,"character":0},"end":{"line":263,"character":9999}}},{"line":262,"kind":12,"containerName":"PopGen::Population","name":"Bio"},{"line":278,"children":[{"line":279,"kind":13,"localvar":"my","containerName":"write_individual","name":"$self","definition":"my"},{"line":279,"kind":13,"containerName":"write_individual","name":"@inds"},{"localvar":"my","definition":"my","name":"$fielddelim","containerName":"write_individual","line":280,"kind":13},{"kind":13,"line":280,"containerName":"write_individual","name":"$self"},{"name":"flag","containerName":"write_individual","line":280,"kind":12},{"definition":"my","name":"$alleledelim","containerName":"write_individual","localvar":"my","kind":13,"line":281},{"containerName":"write_individual","name":"$self","line":281,"kind":13},{"kind":12,"line":281,"name":"flag","containerName":"write_individual"},{"kind":13,"line":283,"containerName":"write_individual","definition":"my","name":"$ind","localvar":"my"},{"line":283,"kind":13,"name":"@inds","containerName":"write_individual"},{"containerName":"write_individual","name":"$ind","line":284,"kind":13},{"line":284,"kind":13,"name":"$ind","containerName":"write_individual"},{"name":"isa","containerName":"write_individual","kind":12,"line":284},{"kind":13,"line":285,"containerName":"write_individual","name":"$self"},{"kind":12,"line":285,"containerName":"write_individual","name":"warn"},{"kind":13,"line":290,"definition":"my","name":"@marker_names","containerName":"write_individual","localvar":"my"},{"line":290,"kind":13,"name":"$ind","containerName":"write_individual"},{"name":"get_marker_names","containerName":"write_individual","line":290,"kind":12},{"kind":13,"line":291,"name":"$self","containerName":"write_individual"},{"name":"flag","containerName":"write_individual","line":291,"kind":12},{"line":292,"kind":13,"containerName":"write_individual","name":"$self"},{"containerName":"write_individual","name":"flag","line":292,"kind":12},{"line":293,"kind":13,"name":"$self","containerName":"write_individual"},{"name":"_print","containerName":"write_individual","line":293,"kind":12},{"kind":13,"line":293,"name":"$fielddelim","containerName":"write_individual"},{"name":"@marker_names","containerName":"write_individual","kind":13,"line":293},{"containerName":"write_individual","name":"$self","kind":13,"line":294},{"containerName":"write_individual","name":"flag","kind":12,"line":294},{"name":"$self","containerName":"write_individual","line":296,"kind":13},{"line":296,"kind":12,"name":"_print","containerName":"write_individual"},{"name":"$fielddelim","containerName":"write_individual","kind":13,"line":296},{"containerName":"write_individual","name":"$ind","line":296,"kind":13},{"name":"unique_id","containerName":"write_individual","kind":12,"line":296},{"containerName":"write_individual","name":"$alleledelim","kind":13,"line":302},{"containerName":"write_individual","name":"get_Alleles","line":302,"kind":12},{"name":"$ind","containerName":"write_individual","kind":13,"line":308},{"containerName":"write_individual","name":"get_Genotypes","line":308,"kind":12},{"name":"@marker_names","containerName":"write_individual","kind":13,"line":309}],"kind":12,"detail":"($self,@inds)","signature":{"label":"write_individual($self,@inds)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)","parameters":[{"label":"$self"},{"label":"@inds"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":278},"end":{"line":311,"character":9999}},"name":"write_individual"},{"containerName":"main::","definition":"sub","detail":"($self,@pops)","signature":{"documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self,@inds) = @_;\n    my $fielddelim  = $self->flag('field_delimiter');\n    my $alleledelim= $self->flag('allele_delimiter');\n    \n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object ($ind)\");\n\t    next;\n\t}\n\t# we'll go ahead and sort these until\n\t# we have a better way to insure a consistent order\n\tmy @marker_names = sort $ind->get_marker_names;\n\tif( ! $self->flag('no_header') && \n\t    ! $self->flag('header_written') ) {\n\t    $self->_print(join($fielddelim, ('SAMPLE', @marker_names)), \"\\n\");\n\t    $self->flag('header_written',1);\n\t}\n\t$self->_print( join($fielddelim, $ind->unique_id, \n\t\t\t    # we're chaining map here, pay attention and read\n\t\t\t    # starting with the last map\n\t\t\t    \n\t\t\t    # we'll turn genotypes into allele pairs\n\t\t\t    # which will be separated by the allele delimiter\n\t\t\t    map { join($alleledelim,$_->get_Alleles) } \n\t\t\t    # marker names will be sorted so we don't\n\t\t\t    # have to worry about this between individuals\n\t\t\t    # unless the individual set you pass in has \n\t\t\t    # a mixed set of markers...\n\t\t\t    # this will turn marker names into Genotypes\n\t\t\t    map {$ind->get_Genotypes(-marker => $_)} \n\t\t\t    @marker_names), \"\\n\")\n    }    \n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"},{"label":"@pops"}],"label":"write_population($self,@pops)"},"kind":12,"line":324,"children":[{"line":325,"kind":13,"localvar":"my","containerName":"write_population","name":"$self","definition":"my"},{"line":325,"kind":13,"name":"@pops","containerName":"write_population"},{"name":"$fielddelim","definition":"my","containerName":"write_population","localvar":"my","kind":13,"line":326},{"line":326,"kind":13,"containerName":"write_population","name":"$self"},{"line":326,"kind":12,"name":"flag","containerName":"write_population"},{"line":328,"kind":13,"localvar":"my","name":"$alleledelim","definition":"my","containerName":"write_population"},{"name":"$pop","definition":"my","containerName":"write_population","localvar":"my","kind":13,"line":329},{"line":329,"kind":13,"containerName":"write_population","name":"@pops"},{"line":330,"kind":13,"name":"$pop","containerName":"write_population"},{"name":"$pop","containerName":"write_population","kind":13,"line":330},{"kind":12,"line":330,"containerName":"write_population","name":"isa"},{"line":331,"kind":13,"name":"$self","containerName":"write_population"},{"name":"warn","containerName":"write_population","kind":12,"line":331},{"name":"@marker_names","definition":"my","containerName":"write_population","localvar":"my","kind":13,"line":336},{"kind":13,"line":336,"name":"$pop","containerName":"write_population"},{"line":336,"kind":12,"containerName":"write_population","name":"get_marker_names"},{"containerName":"write_population","name":"$self","line":337,"kind":13},{"name":"flag","containerName":"write_population","kind":12,"line":337},{"line":338,"kind":13,"name":"$self","containerName":"write_population"},{"containerName":"write_population","name":"flag","kind":12,"line":338},{"containerName":"write_population","name":"$self","line":339,"kind":13},{"name":"_print","containerName":"write_population","line":339,"kind":12},{"kind":13,"line":339,"name":"$fielddelim","containerName":"write_population"},{"containerName":"write_population","name":"@marker_names","kind":13,"line":339},{"containerName":"write_population","name":"$self","kind":13,"line":341},{"name":"flag","containerName":"write_population","line":341,"kind":12},{"localvar":"my","definition":"my","name":"$ind","containerName":"write_population","line":343,"kind":13},{"kind":13,"line":343,"containerName":"write_population","name":"$pop"},{"containerName":"write_population","name":"get_Individuals","kind":12,"line":343},{"containerName":"write_population","name":"$self","kind":13,"line":344},{"containerName":"write_population","name":"_print","line":344,"kind":12},{"line":344,"kind":13,"name":"$fielddelim","containerName":"write_population"},{"containerName":"write_population","name":"$ind","kind":13,"line":344},{"containerName":"write_population","name":"unique_id","line":344,"kind":12},{"name":"$alleledelim","containerName":"write_population","kind":13,"line":351},{"kind":12,"line":351,"containerName":"write_population","name":"get_Alleles"},{"line":357,"kind":13,"containerName":"write_population","name":"$ind"},{"line":357,"kind":12,"containerName":"write_population","name":"get_Genotypes"},{"containerName":"write_population","name":"@marker_names","kind":13,"line":358}],"name":"write_population","range":{"start":{"line":324,"character":0},"end":{"line":361,"character":9999}}}]}