{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":62},{"detail":"($pkg,$cont)","signature":{"parameters":[{"label":"$pkg"},{"label":"$cont"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.","label":"new($pkg,$cont)"},"containerName":"main::","definition":"sub","line":79,"children":[{"line":80,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$pkg"},{"containerName":"new","name":"$cont","kind":13,"line":80},{"line":81,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"line":81,"kind":13,"containerName":"new","name":"$pkg"},{"definition":"my","name":"@arr","containerName":"new","localvar":"my","kind":13,"line":82},{"containerName":"new","name":"$cont","kind":13,"line":83},{"containerName":"new","definition":"my","name":"$i","localvar":"my","kind":13,"line":85},{"name":"$i","containerName":"new","kind":13,"line":85},{"name":"$cont","containerName":"new","kind":13,"line":85},{"containerName":"new","name":"$i","line":85,"kind":13},{"containerName":"new","name":"$arr","kind":13,"line":86},{"kind":13,"line":86,"name":"$i","containerName":"new"},{"name":"$self","containerName":"new","line":88,"kind":13},{"containerName":"new","name":"@arr","line":88,"kind":13},{"name":"@arr","containerName":"new","line":91,"kind":13},{"line":91,"kind":13,"name":"$cont","containerName":"new"}],"kind":12,"range":{"start":{"character":0,"line":79},"end":{"character":9999,"line":92}},"name":"new"},{"kind":12,"line":81,"containerName":"new","name":"SUPER"},{"kind":12,"line":88,"name":"arr"},{"name":"%self","containerName":null,"kind":13,"line":93},{"kind":12,"line":93,"name":"dim"},{"kind":13,"line":93,"name":"@arr","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":94},{"name":"arr","kind":12,"line":94},{"line":94,"kind":13,"name":"@arr","containerName":null},{"line":95,"kind":13,"name":"$self","containerName":null},{"line":95,"kind":13,"name":"$pkg","containerName":null},{"line":96,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":99,"children":[],"containerName":"main::","definition":"sub","name":"dim","range":{"end":{"line":101,"character":9999},"start":{"character":0,"line":99}}},{"kind":12,"line":100,"name":"dim"},{"kind":2,"line":104,"name":"overload","containerName":""},{"line":104,"kind":12,"name":"add"},{"line":105,"kind":12,"name":"substract"},{"name":"scalarproduct","line":106,"kind":12},{"name":"comparelex","line":107,"kind":12},{"name":"comparelex","kind":12,"line":108},{"name":"display","line":109,"kind":12},{"name":"as_array","kind":12,"line":110},{"kind":12,"line":112,"children":[],"containerName":"main::","name":"as_array","definition":"sub","range":{"end":{"line":114,"character":9999},"start":{"character":0,"line":112}}},{"line":113,"kind":12,"name":"arr"},{"range":{"start":{"line":128,"character":0},"end":{"character":9999,"line":130}},"name":"display","line":128,"children":[{"containerName":"display","definition":"my","name":"$self","localvar":"my","kind":13,"line":129},{"line":130,"kind":13,"localvar":"my","containerName":"display","name":"@arr","definition":"my"},{"containerName":"display","name":"$self","line":130,"kind":13}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.","label":"display($self)"},"containerName":"main::","definition":"sub"},{"line":130,"kind":12,"name":"arr"},{"containerName":"main::","definition":"sub","detail":"($v1,$v2)","signature":{"label":"add($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.","parameters":[{"label":"$v1"},{"label":"$v2"}]},"kind":12,"line":146,"children":[{"containerName":"add","name":"$v1","definition":"my","localvar":"my","kind":13,"line":147},{"name":"$v2","containerName":"add","kind":13,"line":147},{"kind":13,"line":149,"containerName":"add","name":"$v1"},{"kind":12,"line":149,"containerName":"add","name":"throw"},{"line":149,"kind":13,"name":"$v1","containerName":"add"},{"containerName":"add","name":"$v2","line":149,"kind":13},{"line":150,"kind":13,"localvar":"my","containerName":"add","definition":"my","name":"$dim"},{"line":150,"kind":13,"containerName":"add","name":"$v1"},{"line":151,"kind":13,"localvar":"my","containerName":"add","definition":"my","name":"@sum"},{"localvar":"my","name":"$i","definition":"my","containerName":"add","line":152,"kind":13},{"kind":13,"line":152,"containerName":"add","name":"$i"},{"line":152,"kind":13,"containerName":"add","name":"$dim"},{"name":"$i","containerName":"add","line":152,"kind":13},{"name":"$sum","containerName":"add","line":153,"kind":13},{"line":153,"kind":13,"containerName":"add","name":"$i"},{"name":"$v1","containerName":"add","kind":13,"line":153},{"containerName":"add","name":"$i","line":153,"kind":13},{"line":153,"kind":13,"name":"$v2","containerName":"add"},{"containerName":"add","name":"$i","line":153,"kind":13},{"localvar":"my","containerName":"add","name":"$result","definition":"my","line":155,"kind":13},{"kind":12,"line":155,"name":"new","containerName":"add"},{"kind":13,"line":155,"name":"@sum","containerName":"add"},{"kind":13,"line":156,"containerName":"add","name":"$result"}],"name":"add","range":{"end":{"character":9999,"line":157},"start":{"line":146,"character":0}}},{"kind":12,"line":149,"name":"dim"},{"line":149,"kind":12,"name":"dim"},{"name":"dim","line":150,"kind":12},{"kind":12,"line":155,"name":"Bio","containerName":"PhyloNetwork::muVector"},{"range":{"start":{"line":171,"character":0},"end":{"character":9999,"line":182}},"name":"substract","line":171,"children":[{"kind":13,"line":172,"containerName":"substract","definition":"my","name":"$v1","localvar":"my"},{"containerName":"substract","name":"$v2","line":172,"kind":13},{"containerName":"substract","name":"$v1","line":174,"kind":13},{"line":174,"kind":12,"name":"throw","containerName":"substract"},{"containerName":"substract","name":"$v1","line":174,"kind":13},{"name":"$v2","containerName":"substract","kind":13,"line":174},{"containerName":"substract","name":"$dim","definition":"my","localvar":"my","kind":13,"line":175},{"line":175,"kind":13,"name":"$v1","containerName":"substract"},{"line":176,"kind":13,"localvar":"my","containerName":"substract","definition":"my","name":"@sum"},{"localvar":"my","containerName":"substract","definition":"my","name":"$i","line":177,"kind":13},{"line":177,"kind":13,"containerName":"substract","name":"$i"},{"containerName":"substract","name":"$dim","line":177,"kind":13},{"name":"$i","containerName":"substract","kind":13,"line":177},{"name":"$sum","containerName":"substract","kind":13,"line":178},{"name":"$i","containerName":"substract","kind":13,"line":178},{"name":"$v1","containerName":"substract","line":178,"kind":13},{"kind":13,"line":178,"name":"$i","containerName":"substract"},{"kind":13,"line":178,"containerName":"substract","name":"$v2"},{"containerName":"substract","name":"$i","kind":13,"line":178},{"kind":13,"line":180,"definition":"my","name":"$result","containerName":"substract","localvar":"my"},{"containerName":"substract","name":"new","line":180,"kind":12},{"name":"@sum","containerName":"substract","kind":13,"line":180},{"line":181,"kind":13,"containerName":"substract","name":"$result"}],"kind":12,"detail":"($v1,$v2)","signature":{"label":"substract($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.","parameters":[{"label":"$v1"},{"label":"$v2"}]},"containerName":"main::","definition":"sub"},{"name":"dim","kind":12,"line":174},{"name":"dim","line":174,"kind":12},{"line":175,"kind":12,"name":"dim"},{"name":"arr","line":178,"kind":12},{"line":178,"kind":12,"name":"arr"},{"containerName":"PhyloNetwork::muVector","name":"Bio","kind":12,"line":180},{"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":207}},"name":"scalarproduct","children":[{"line":197,"kind":13,"localvar":"my","name":"$v1","definition":"my","containerName":"scalarproduct"},{"name":"$num","containerName":"scalarproduct","kind":13,"line":197},{"name":"$swapped","containerName":"scalarproduct","line":197,"kind":13},{"kind":13,"line":199,"containerName":"scalarproduct","definition":"my","name":"$dim","localvar":"my"},{"name":"$v1","containerName":"scalarproduct","kind":13,"line":199},{"definition":"my","name":"@sum","containerName":"scalarproduct","localvar":"my","kind":13,"line":200},{"localvar":"my","containerName":"scalarproduct","name":"$i","definition":"my","line":201,"kind":13},{"name":"$i","containerName":"scalarproduct","kind":13,"line":201},{"kind":13,"line":201,"name":"$dim","containerName":"scalarproduct"},{"kind":13,"line":201,"name":"$i","containerName":"scalarproduct"},{"line":202,"kind":13,"containerName":"scalarproduct","name":"$sum"},{"containerName":"scalarproduct","name":"$i","line":202,"kind":13},{"containerName":"scalarproduct","name":"$num","line":202,"kind":13},{"name":"$v1","containerName":"scalarproduct","line":202,"kind":13},{"kind":13,"line":202,"containerName":"scalarproduct","name":"$i"},{"localvar":"my","definition":"my","name":"$result","containerName":"scalarproduct","line":204,"kind":13},{"name":"new","containerName":"scalarproduct","kind":12,"line":204},{"kind":13,"line":204,"containerName":"scalarproduct","name":"@sum"},{"line":205,"kind":13,"name":"$result","containerName":"scalarproduct"},{"name":"$result","containerName":"scalarproduct","kind":13,"line":206}],"line":196,"kind":12,"signature":{"label":"scalarproduct($v1,$num,$swapped)","parameters":[{"label":"$v1"},{"label":"$num"},{"label":"$swapped"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator."},"detail":"($v1,$num,$swapped)","definition":"sub","containerName":"main::"},{"name":"dim","kind":12,"line":199},{"kind":12,"line":202,"name":"arr"},{"kind":12,"line":204,"name":"Bio","containerName":"PhyloNetwork::muVector"},{"kind":12,"children":[{"line":222,"kind":13,"localvar":"my","name":"$v1","definition":"my","containerName":"comparelex"},{"line":222,"kind":13,"name":"$v2","containerName":"comparelex"},{"containerName":"comparelex","name":"$v1","line":224,"kind":13},{"containerName":"comparelex","name":"throw","kind":12,"line":224},{"containerName":"comparelex","name":"$v1","line":224,"kind":13},{"line":224,"kind":13,"name":"$v2","containerName":"comparelex"},{"localvar":"my","containerName":"comparelex","name":"$dim","definition":"my","line":225,"kind":13},{"kind":13,"line":225,"containerName":"comparelex","name":"$v1"},{"kind":13,"line":226,"name":"$i","definition":"my","containerName":"comparelex","localvar":"my"},{"containerName":"comparelex","name":"$i","line":226,"kind":13},{"containerName":"comparelex","name":"$dim","line":226,"kind":13},{"name":"$i","containerName":"comparelex","kind":13,"line":226},{"kind":13,"line":227,"name":"$v1","containerName":"comparelex"},{"kind":13,"line":227,"name":"$i","containerName":"comparelex"},{"containerName":"comparelex","name":"$v2","kind":13,"line":227},{"name":"$i","containerName":"comparelex","line":227,"kind":13},{"name":"$v1","containerName":"comparelex","line":228,"kind":13},{"name":"$i","containerName":"comparelex","line":228,"kind":13},{"containerName":"comparelex","name":"$v2","line":228,"kind":13},{"containerName":"comparelex","name":"$i","kind":13,"line":228}],"line":221,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.","parameters":[{"label":"$v1"},{"label":"$v2"}],"label":"comparelex($v1,$v2)"},"detail":"($v1,$v2)","name":"comparelex","range":{"start":{"character":0,"line":221},"end":{"character":9999,"line":231}}},{"name":"dim","line":224,"kind":12},{"name":"dim","line":224,"kind":12},{"name":"dim","kind":12,"line":225},{"kind":12,"line":227,"name":"arr"},{"name":"arr","kind":12,"line":227},{"line":228,"kind":12,"name":"arr"},{"name":"arr","kind":12,"line":228},{"detail":"($v1,$v2)","signature":{"label":"geq_poset($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector","parameters":[{"label":"$v1"},{"label":"$v2"}]},"containerName":"main::","definition":"sub","line":243,"children":[{"kind":13,"line":244,"containerName":"geq_poset","definition":"my","name":"$v1","localvar":"my"},{"line":244,"kind":13,"name":"$v2","containerName":"geq_poset"},{"name":"$v1","containerName":"geq_poset","kind":13,"line":246},{"line":246,"kind":12,"containerName":"geq_poset","name":"throw"},{"containerName":"geq_poset","name":"$v1","line":246,"kind":13},{"line":246,"kind":13,"containerName":"geq_poset","name":"$v2"},{"containerName":"geq_poset","name":"$dim","definition":"my","localvar":"my","kind":13,"line":247},{"kind":13,"line":247,"name":"$v1","containerName":"geq_poset"},{"definition":"my","name":"$i","containerName":"geq_poset","localvar":"my","kind":13,"line":248},{"kind":13,"line":248,"containerName":"geq_poset","name":"$i"},{"kind":13,"line":248,"containerName":"geq_poset","name":"$dim"},{"line":248,"kind":13,"name":"$i","containerName":"geq_poset"},{"name":"$v1","containerName":"geq_poset","line":249,"kind":13},{"kind":13,"line":249,"containerName":"geq_poset","name":"$i"},{"name":"$v2","containerName":"geq_poset","kind":13,"line":249},{"line":249,"kind":13,"name":"$i","containerName":"geq_poset"}],"kind":12,"range":{"start":{"character":0,"line":243},"end":{"character":9999,"line":252}},"name":"geq_poset"},{"name":"dim","line":246,"kind":12},{"kind":12,"line":246,"name":"dim"},{"line":247,"kind":12,"name":"dim"},{"signature":{"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none","parameters":[{"label":"$v1"}],"label":"is_positive($v1)"},"detail":"($v1)","definition":"sub","containerName":"main::","children":[{"line":265,"kind":13,"localvar":"my","containerName":"is_positive","name":"$v1","definition":"my"},{"kind":13,"line":267,"containerName":"is_positive","name":"$dim","definition":"my","localvar":"my"},{"kind":13,"line":267,"containerName":"is_positive","name":"$v1"},{"localvar":"my","name":"$i","definition":"my","containerName":"is_positive","line":268,"kind":13},{"containerName":"is_positive","name":"$i","kind":13,"line":268},{"kind":13,"line":268,"containerName":"is_positive","name":"$dim"},{"name":"$i","containerName":"is_positive","line":268,"kind":13},{"kind":13,"line":269,"name":"$v1","containerName":"is_positive"},{"containerName":"is_positive","name":"$i","line":269,"kind":13}],"line":264,"kind":12,"range":{"end":{"character":9999,"line":272},"start":{"line":264,"character":0}},"name":"is_positive"},{"line":267,"kind":12,"name":"dim"},{"kind":12,"children":[{"containerName":"hamming","name":"$v1","definition":"my","localvar":"my","kind":13,"line":285},{"kind":13,"line":285,"containerName":"hamming","name":"$v2"},{"containerName":"hamming","name":"$v1","kind":13,"line":287},{"kind":12,"line":287,"containerName":"hamming","name":"throw"},{"kind":13,"line":287,"name":"$v1","containerName":"hamming"},{"name":"$v2","containerName":"hamming","kind":13,"line":287},{"localvar":"my","containerName":"hamming","name":"$dim","definition":"my","line":288,"kind":13},{"name":"$v1","containerName":"hamming","kind":13,"line":288},{"line":289,"kind":13,"localvar":"my","name":"$w","definition":"my","containerName":"hamming"},{"kind":13,"line":290,"containerName":"hamming","definition":"my","name":"$i","localvar":"my"},{"containerName":"hamming","name":"$i","kind":13,"line":290},{"name":"$dim","containerName":"hamming","kind":13,"line":290},{"containerName":"hamming","name":"$i","kind":13,"line":290},{"line":291,"kind":13,"name":"$w","containerName":"hamming"},{"containerName":"hamming","name":"$v1","kind":13,"line":291},{"name":"$i","containerName":"hamming","line":291,"kind":13},{"kind":13,"line":291,"name":"$v2","containerName":"hamming"},{"name":"$i","containerName":"hamming","kind":13,"line":291},{"kind":13,"line":293,"name":"$w","containerName":"hamming"}],"line":284,"definition":"sub","containerName":"main::","signature":{"label":"hamming($v1,$v2)","parameters":[{"label":"$v1"},{"label":"$v2"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none\n\n\nsub is_positive {\n  my ($v1)=@_;\n\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= 0;\n  }\n  return 1;\n}\n\n=head2 hamming\n\n Title   : hamming\n Usage   : $mu1->hamming($mu2)\n Function: returns the Hamming distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector"},"detail":"($v1,$v2)","name":"hamming","range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":294}}},{"name":"dim","line":287,"kind":12},{"kind":12,"line":287,"name":"dim"},{"name":"dim","line":288,"kind":12},{"containerName":"main::","definition":"sub","detail":"($v1,$v2)","signature":{"parameters":[{"label":"$v1"},{"label":"$v2"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none\n\n\nsub is_positive {\n  my ($v1)=@_;\n\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= 0;\n  }\n  return 1;\n}\n\n=head2 hamming\n\n Title   : hamming\n Usage   : $mu1->hamming($mu2)\n Function: returns the Hamming distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub hamming {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my $w=0;\n  for (my $i=0; $i<$dim; $i++) {\n    $w++ unless $v1->[$i] == $v2->[$i];\n  }\n  return $w;\n}\n\n=head2 manhattan\n\n Title   : manhattan\n Usage   : $mu1->manhattan($mu2)\n Function: returns the Manhattan distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector","label":"manhattan($v1,$v2)"},"kind":12,"line":306,"children":[{"containerName":"manhattan","name":"$v1","definition":"my","localvar":"my","kind":13,"line":307},{"kind":13,"line":307,"name":"$v2","containerName":"manhattan"},{"kind":13,"line":309,"containerName":"manhattan","name":"$v1"},{"name":"throw","containerName":"manhattan","kind":12,"line":309},{"kind":13,"line":309,"name":"$v1","containerName":"manhattan"},{"kind":13,"line":309,"containerName":"manhattan","name":"$v2"},{"containerName":"manhattan","definition":"my","name":"$dim","localvar":"my","kind":13,"line":310},{"line":310,"kind":13,"name":"$v1","containerName":"manhattan"},{"kind":13,"line":311,"name":"$w","definition":"my","containerName":"manhattan","localvar":"my"},{"kind":13,"line":312,"containerName":"manhattan","name":"$i","definition":"my","localvar":"my"},{"name":"$i","containerName":"manhattan","kind":13,"line":312},{"kind":13,"line":312,"containerName":"manhattan","name":"$dim"},{"name":"$i","containerName":"manhattan","line":312,"kind":13},{"kind":13,"line":313,"name":"$w","containerName":"manhattan"},{"name":"$v1","containerName":"manhattan","kind":13,"line":313},{"name":"$i","containerName":"manhattan","kind":13,"line":313},{"name":"$v2","containerName":"manhattan","kind":13,"line":313},{"name":"$i","containerName":"manhattan","line":313,"kind":13},{"containerName":"manhattan","name":"$w","line":315,"kind":13}],"name":"manhattan","range":{"end":{"character":9999,"line":316},"start":{"line":306,"character":0}}},{"kind":12,"line":309,"name":"dim"},{"line":309,"kind":12,"name":"dim"},{"name":"dim","kind":12,"line":310}]}