{"vars":[{"kind":2,"line":63,"name":"base","containerName":""},{"range":{"start":{"line":87,"character":0},"end":{"character":9999,"line":124}},"name":"new","detail":"($pkg,@args)","signature":{"documentation":"1;\n# $Id: TreeFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactory - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".","parameters":[{"label":"$pkg"},{"label":"@args"}],"label":"new($pkg,@args)"},"containerName":"main::","definition":"sub","line":87,"children":[{"definition":"my","name":"$pkg","containerName":"new","localvar":"my","kind":13,"line":88},{"containerName":"new","name":"@args","kind":13,"line":88},{"line":90,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$pkg","kind":13,"line":90},{"containerName":"new","name":"@args","line":90,"kind":13},{"kind":13,"line":92,"containerName":"new","name":"$leavesR","definition":"my","localvar":"my"},{"kind":13,"line":92,"containerName":"new","name":"$numleaves"},{"name":"$numhybrids","containerName":"new","line":92,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":93},{"containerName":"new","name":"_rearrange","line":93,"kind":12},{"line":95,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"@leaves","definition":"my","localvar":"my","kind":13,"line":97},{"name":"$leavesR","containerName":"new","kind":13,"line":98},{"line":98,"kind":13,"containerName":"new","name":"$numleaves"},{"containerName":"new","name":"@leaves","kind":13,"line":99},{"name":"$numleaves","containerName":"new","line":99,"kind":13},{"name":"$leavesR","containerName":"new","line":100,"kind":13},{"kind":13,"line":100,"name":"@leaves","containerName":"new"},{"kind":13,"line":102,"containerName":"new","name":"$leavesR"},{"kind":13,"line":103,"name":"$self","containerName":"new"},{"kind":12,"line":103,"containerName":"new","name":"throw"},{"kind":13,"line":105,"containerName":"new","name":"@leaves"},{"containerName":"new","name":"$leavesR","line":105,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":106},{"line":106,"kind":13,"containerName":"new","name":"$leavesR"},{"containerName":"new","name":"$numleaves","kind":13,"line":108},{"kind":13,"line":108,"containerName":"new","name":"@leaves"},{"line":109,"kind":13,"name":"$self","containerName":"new"},{"name":"$numleaves","containerName":"new","line":109,"kind":13},{"line":110,"kind":13,"containerName":"new","name":"$numleaves"},{"containerName":"new","definition":"my","name":"@leavesparent","localvar":"my","kind":13,"line":111},{"kind":13,"line":111,"containerName":"new","name":"@leaves"},{"localvar":"my","name":"$newleaf","definition":"my","containerName":"new","line":112,"kind":13},{"line":112,"kind":13,"containerName":"new","name":"@leavesparent"},{"containerName":"new","name":"$self","kind":13,"line":113},{"name":"$newleaf","containerName":"new","kind":13,"line":113},{"kind":13,"line":114,"name":"$self","containerName":"new"},{"kind":13,"line":115,"name":"$pkg","containerName":"new"},{"name":"@leavesparent","containerName":"new","kind":13,"line":115},{"localvar":"my","name":"$oldnet","definition":"my","containerName":"new","line":116,"kind":13},{"kind":13,"line":116,"name":"$self","containerName":"new"},{"kind":12,"line":116,"containerName":"new","name":"next_network"},{"line":117,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$oldnet","line":117,"kind":13},{"kind":13,"line":118,"containerName":"new","name":"@candidates","definition":"my","localvar":"my"},{"name":"$oldnet","containerName":"new","line":118,"kind":13},{"line":118,"kind":12,"name":"nodes","containerName":"new"},{"containerName":"new","name":"$self","line":119,"kind":13},{"name":"@candidates","containerName":"new","line":119,"kind":13},{"kind":13,"line":121,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","line":123,"kind":13},{"containerName":"new","name":"$pkg","kind":13,"line":123}],"kind":12},{"kind":2,"line":88,"containerName":"Bio","name":"PhyloNetwork"},{"kind":12,"line":90,"name":"SUPER","containerName":"new"},{"name":"leaves","kind":12,"line":106},{"name":"numleaves","line":109,"kind":12},{"name":"newleaf","line":113,"kind":12},{"name":"parent","kind":12,"line":114},{"name":"parent","line":116,"kind":12},{"line":117,"kind":12,"name":"oldnet"},{"name":"candidates","line":119,"kind":12},{"line":121,"kind":12,"name":"index"},{"name":"next_network","range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":136}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_network($self)","documentation":"1;\n# $Id: TreeFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactory - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n  }\n  $self->{index}=0;\n\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":136,"children":[{"kind":13,"line":137,"containerName":"next_network","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":139,"containerName":"next_network","name":"$n","definition":"my","localvar":"my"},{"line":139,"kind":13,"containerName":"next_network","name":"$self"},{"kind":13,"line":140,"containerName":"next_network","name":"$self"},{"containerName":"next_network","name":"$self","line":141,"kind":13},{"containerName":"next_network","name":"$graph","definition":"my","localvar":"my","kind":13,"line":142},{"containerName":"next_network","name":"new","line":142,"kind":12},{"name":"$graph","containerName":"next_network","line":143,"kind":13},{"line":143,"kind":12,"name":"add_edges","containerName":"next_network"},{"containerName":"next_network","name":"$self","kind":13,"line":143},{"line":143,"kind":13,"name":"$self","containerName":"next_network"},{"localvar":"my","containerName":"next_network","definition":"my","name":"$net","line":144,"kind":13},{"line":144,"kind":12,"name":"new","containerName":"next_network"},{"name":"$graph","containerName":"next_network","line":144,"kind":13},{"kind":13,"line":145,"name":"$self","containerName":"next_network"},{"name":"$net","containerName":"next_network","line":146,"kind":13},{"containerName":"next_network","name":"$self","line":153,"kind":13},{"name":"$self","containerName":"next_network","kind":13,"line":153},{"name":"$oldnet","definition":"my","containerName":"next_network","localvar":"my","kind":13,"line":154},{"name":"$self","containerName":"next_network","line":154,"kind":13},{"kind":12,"line":154,"name":"next_network","containerName":"next_network"},{"line":155,"kind":13,"containerName":"next_network","name":"$oldnet"},{"kind":13,"line":158,"name":"$self","containerName":"next_network"},{"line":158,"kind":13,"name":"$oldnet","containerName":"next_network"},{"localvar":"my","containerName":"next_network","name":"@candidates","definition":"my","line":159,"kind":13},{"name":"$oldnet","containerName":"next_network","kind":13,"line":159},{"line":159,"kind":12,"containerName":"next_network","name":"nodes"},{"kind":13,"line":160,"name":"$self","containerName":"next_network"},{"line":160,"kind":13,"name":"@candidates","containerName":"next_network"},{"kind":13,"line":161,"containerName":"next_network","name":"$self"},{"line":163,"kind":13,"localvar":"my","containerName":"next_network","name":"$graph","definition":"my"},{"line":163,"kind":13,"containerName":"next_network","name":"$self"},{"name":"copy","containerName":"next_network","line":163,"kind":12},{"kind":13,"line":164,"containerName":"next_network","definition":"my","name":"$u","localvar":"my"},{"kind":13,"line":164,"name":"$self","containerName":"next_network"},{"containerName":"next_network","name":"$self","line":164,"kind":13},{"name":"$w","definition":"my","containerName":"next_network","localvar":"my","kind":13,"line":165},{"kind":13,"line":165,"name":"$graph","containerName":"next_network"},{"kind":12,"line":165,"name":"predecessors","containerName":"next_network"},{"name":"$u","containerName":"next_network","line":165,"kind":13},{"line":166,"kind":13,"name":"$graph","containerName":"next_network"},{"containerName":"next_network","name":"delete_edge","kind":12,"line":166},{"line":166,"kind":13,"name":"$w","containerName":"next_network"},{"containerName":"next_network","name":"$u","line":166,"kind":13},{"line":167,"kind":13,"containerName":"next_network","name":"$graph"},{"name":"add_edge","containerName":"next_network","line":167,"kind":12},{"line":167,"kind":13,"containerName":"next_network","name":"$w"},{"containerName":"next_network","name":"$graph","line":169,"kind":13},{"kind":12,"line":169,"containerName":"next_network","name":"add_edge"},{"name":"$u","containerName":"next_network","kind":13,"line":169},{"line":170,"kind":13,"name":"$graph","containerName":"next_network"},{"kind":12,"line":170,"name":"add_edge","containerName":"next_network"},{"containerName":"next_network","name":"$self","line":170,"kind":13},{"kind":13,"line":171,"containerName":"next_network","definition":"my","name":"$net","localvar":"my"},{"line":171,"kind":12,"name":"new","containerName":"next_network"},{"containerName":"next_network","name":"$graph","kind":13,"line":171},{"kind":13,"line":172,"containerName":"next_network","name":"$self"},{"line":173,"kind":13,"containerName":"next_network","name":"$net"}]},{"kind":12,"line":139,"name":"numleaves"},{"name":"numleaves","kind":12,"line":140},{"line":141,"kind":12,"name":"index"},{"name":"Graph","containerName":"Directed","kind":12,"line":142},{"name":"leaves","line":143,"kind":12},{"kind":12,"line":143,"name":"leaves"},{"name":"Bio","containerName":"PhyloNetwork","kind":12,"line":144},{"line":145,"kind":12,"name":"index"},{"name":"index","kind":12,"line":153},{"line":153,"kind":12,"name":"candidates"},{"name":"parent","kind":12,"line":154},{"name":"oldnet","line":158,"kind":12},{"name":"candidates","kind":12,"line":160},{"line":161,"kind":12,"name":"index"},{"name":"oldnet","line":163,"kind":12},{"name":"graph","line":163,"kind":12},{"name":"candidates","line":164,"kind":12},{"line":164,"kind":12,"name":"index"},{"name":"newleaf","kind":12,"line":170},{"kind":12,"line":171,"containerName":"PhyloNetwork","name":"Bio"},{"name":"index","line":172,"kind":12}],"version":5}