{"vars":[{"containerName":"","name":"base","line":65,"kind":2},{"range":{"end":{"character":9999,"line":139},"start":{"character":0,"line":100}},"name":"new","signature":{"documentation":"1;\n# $Id: FactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::FactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::FactoryX - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::FactoryX;\n\nuse strict;\nuse warnings;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactoryX;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.","parameters":[{"label":"$pkg"},{"label":"@args"}],"label":"new($pkg,@args)"},"detail":"($pkg,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":101,"containerName":"new","name":"$pkg","definition":"my","localvar":"my"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":102,"kind":13},{"kind":13,"line":102,"name":"$pkg","containerName":"new"},{"name":"@args","containerName":"new","line":102,"kind":13},{"definition":"my","name":"$leavesR","containerName":"new","localvar":"my","kind":13,"line":104},{"kind":13,"line":104,"name":"$numleaves","containerName":"new"},{"line":104,"kind":13,"name":"$numhybrids","containerName":"new"},{"kind":13,"line":105,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":105,"kind":12},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":108,"name":"@leaves","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$leavesR","kind":13,"line":109},{"name":"$numleaves","containerName":"new","line":109,"kind":13},{"name":"@leaves","containerName":"new","line":110,"kind":13},{"line":110,"kind":13,"containerName":"new","name":"$numleaves"},{"kind":13,"line":111,"containerName":"new","name":"$leavesR"},{"kind":13,"line":111,"containerName":"new","name":"@leaves"},{"kind":13,"line":113,"containerName":"new","name":"$leavesR"},{"name":"$self","containerName":"new","kind":13,"line":114},{"name":"throw","containerName":"new","kind":12,"line":114},{"name":"@leaves","containerName":"new","kind":13,"line":116},{"containerName":"new","name":"$leavesR","kind":13,"line":116},{"kind":13,"line":117,"name":"$self","containerName":"new"},{"kind":13,"line":117,"name":"$leavesR","containerName":"new"},{"kind":13,"line":118,"name":"$numleaves","containerName":"new"},{"line":118,"kind":13,"name":"@leaves","containerName":"new"},{"containerName":"new","name":"$self","line":119,"kind":13},{"containerName":"new","name":"$numleaves","line":119,"kind":13},{"kind":13,"line":121,"name":"$numhybrids","containerName":"new"},{"containerName":"new","name":"$numhybrids","line":122,"kind":13},{"name":"$numleaves","containerName":"new","kind":13,"line":122},{"kind":13,"line":124,"containerName":"new","name":"$self"},{"containerName":"new","name":"$numhybrids","line":124,"kind":13},{"line":125,"kind":13,"containerName":"new","name":"$numhybrids"},{"kind":12,"line":126,"containerName":"new","name":"new"},{"containerName":"new","name":"@leaves","kind":13,"line":126},{"line":128,"kind":13,"localvar":"my","name":"$parent","definition":"my","containerName":"new"},{"containerName":"new","name":"$numhybrids","line":129,"kind":13},{"kind":13,"line":130,"containerName":"new","name":"$parent"},{"line":130,"kind":13,"name":"$pkg","containerName":"new"},{"containerName":"new","name":"@leaves","kind":13,"line":130},{"containerName":"new","name":"$numhybrids","line":131,"kind":13},{"line":133,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"@subfactories"},{"name":"$parent","containerName":"new","line":133,"kind":13},{"name":"@subfactories","containerName":"new","line":134,"kind":13},{"kind":13,"line":134,"containerName":"new","name":"$parent"},{"kind":13,"line":137,"containerName":"new","name":"$self"},{"name":"@subfactories","containerName":"new","line":137,"kind":13}],"line":100,"kind":12},{"kind":2,"line":101,"containerName":"Bio::PhyloNetwork::Bio::PhyloNetwork","name":"TreeFactoryX"},{"name":"SUPER","containerName":"new","line":102,"kind":12},{"name":"leaves","kind":12,"line":117},{"kind":12,"line":119,"name":"numleaves"},{"name":"numhybrids","kind":12,"line":124},{"line":126,"kind":12,"containerName":"PhyloNetwork::TreeFactoryX","name":"Bio"},{"name":"subfactories","kind":12,"line":133},{"kind":12,"line":137,"name":"subfactories"},{"kind":13,"line":141,"containerName":null,"name":"$parent"},{"kind":12,"line":141,"name":"Bio","containerName":"PhyloNetwork::TreeFactoryX"},{"kind":12,"line":141,"containerName":"main::","name":"new"},{"line":141,"kind":13,"name":"@leaves","containerName":null},{"kind":13,"line":142,"name":"%self","containerName":null},{"name":"subfactories","line":142,"kind":12},{"containerName":null,"name":"$parent","kind":13,"line":142},{"line":144,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":144,"name":"parent"},{"kind":13,"line":144,"containerName":null,"name":"$parent"},{"line":145,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":145,"name":"update","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":146},{"line":146,"kind":12,"name":"found"},{"containerName":null,"name":"%self","line":147,"kind":13},{"line":147,"kind":12,"name":"thrown"},{"kind":13,"line":148,"containerName":null,"name":"%self"},{"kind":12,"line":148,"name":"hybnow"},{"line":149,"kind":13,"containerName":null,"name":"$self"},{"containerName":null,"name":"$pkg","line":149,"kind":13},{"range":{"start":{"character":0,"line":152},"end":{"line":167,"character":9999}},"name":"update","line":152,"children":[{"line":153,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"update"},{"name":"$self","containerName":"update","line":155,"kind":13},{"line":156,"kind":13,"localvar":"my","containerName":"update","name":"@candidates","definition":"my"},{"name":"$self","containerName":"update","kind":13,"line":156},{"line":156,"kind":12,"name":"edges","containerName":"update"},{"containerName":"update","name":"$self","line":157,"kind":13},{"kind":13,"line":157,"containerName":"update","name":"@candidates"},{"name":"$self","containerName":"update","line":158,"kind":13},{"line":158,"kind":13,"name":"@candidates","containerName":"update"},{"name":"$self","containerName":"update","line":159,"kind":13},{"containerName":"update","name":"$self","line":160,"kind":13},{"kind":13,"line":162,"name":"$self","containerName":"update"},{"line":163,"kind":13,"name":"$self","containerName":"update"},{"name":"$self","containerName":"update","line":164,"kind":13},{"kind":13,"line":165,"name":"$self","containerName":"update"}],"kind":12,"detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"update($self)"},"containerName":"main::","definition":"sub"},{"line":155,"kind":12,"name":"oldnet"},{"name":"oldnet","line":156,"kind":12},{"name":"candidates","kind":12,"line":157},{"line":158,"kind":12,"name":"numcandidates"},{"name":"index1","line":159,"kind":12},{"name":"index2","line":160,"kind":12},{"line":162,"kind":12,"name":"candidates"},{"kind":12,"line":163,"name":"numcandidates"},{"name":"index1","line":164,"kind":12},{"kind":12,"line":165,"name":"index2"},{"name":"next_network_repeated","range":{"start":{"line":169,"character":0},"end":{"line":172,"character":9999}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_network_repeated","line":170,"kind":13},{"line":172,"kind":13,"name":"$self","containerName":"next_network_repeated"},{"containerName":"next_network_repeated","name":"$self","kind":13,"line":172}],"line":169,"definition":"sub","containerName":"main::","signature":{"label":"next_network_repeated($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)"},{"kind":12,"line":172,"name":"thrown"},{"name":"found","line":172,"kind":12},{"line":173,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":173,"name":"thrown"},{"name":"%self","containerName":null,"kind":13,"line":173},{"name":"thrown","line":173,"kind":12},{"kind":13,"line":174,"containerName":null,"name":"%self"},{"kind":12,"line":174,"name":"found"},{"line":174,"kind":13,"containerName":null,"name":"%self"},{"name":"thrown","kind":12,"line":174},{"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"next_network_new($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":178,"kind":13,"localvar":"my","containerName":"next_network_new","definition":"my","name":"$self"},{"name":"$self","containerName":"next_network_new","kind":13,"line":181},{"line":181,"kind":13,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":182,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":183,"name":"$self","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$self","kind":13,"line":186},{"name":"$self","containerName":"next_network_new","kind":13,"line":186},{"name":"$oldnet","definition":"my","containerName":"next_network_new","localvar":"my","kind":13,"line":187},{"name":"$self","containerName":"next_network_new","kind":13,"line":187},{"kind":12,"line":187,"containerName":"next_network_new","name":"next_network_repeated"},{"line":188,"kind":13,"name":"$oldnet","containerName":"next_network_new"},{"kind":13,"line":192,"containerName":"next_network_new","name":"$self"},{"containerName":"next_network_new","name":"$oldnet","kind":13,"line":192},{"kind":13,"line":193,"name":"$self","containerName":"next_network_new"},{"kind":12,"line":193,"name":"update","containerName":"next_network_new"},{"kind":13,"line":195,"containerName":"next_network_new","name":"$u1","definition":"my","localvar":"my"},{"name":"$self","containerName":"next_network_new","kind":13,"line":195},{"kind":13,"line":195,"name":"$self","containerName":"next_network_new"},{"localvar":"my","containerName":"next_network_new","name":"$v1","definition":"my","line":196,"kind":13},{"line":196,"kind":13,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":196,"containerName":"next_network_new","name":"$self"},{"localvar":"my","containerName":"next_network_new","name":"$u2","definition":"my","line":197,"kind":13},{"line":197,"kind":13,"name":"$self","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$self","line":197,"kind":13},{"localvar":"my","definition":"my","name":"$v2","containerName":"next_network_new","line":198,"kind":13},{"containerName":"next_network_new","name":"$self","kind":13,"line":198},{"kind":13,"line":198,"name":"$self","containerName":"next_network_new"},{"line":199,"kind":13,"localvar":"my","name":"$lbl","definition":"my","containerName":"next_network_new"},{"line":199,"kind":13,"name":"$self","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$self","line":200,"kind":13},{"line":200,"kind":12,"containerName":"next_network_new","name":"is_attackable"},{"containerName":"next_network_new","name":"$u1","line":200,"kind":13},{"containerName":"next_network_new","name":"$v1","kind":13,"line":200},{"containerName":"next_network_new","name":"$u2","line":200,"kind":13},{"containerName":"next_network_new","name":"$v2","line":200,"kind":13},{"line":201,"kind":13,"localvar":"my","name":"$net","definition":"my","containerName":"next_network_new"},{"name":"new","containerName":"next_network_new","line":201,"kind":12},{"line":201,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":201,"kind":12,"containerName":"next_network_new","name":"graph"},{"line":202,"kind":13,"containerName":"next_network_new","name":"$net"},{"name":"do_attack","containerName":"next_network_new","line":202,"kind":12},{"line":202,"kind":13,"name":"$u1","containerName":"next_network_new"},{"name":"$v1","containerName":"next_network_new","kind":13,"line":202},{"name":"$u2","containerName":"next_network_new","kind":13,"line":202},{"name":"$v2","containerName":"next_network_new","kind":13,"line":202},{"kind":13,"line":202,"name":"$lbl","containerName":"next_network_new"},{"line":203,"kind":13,"containerName":"next_network_new","name":"$self"},{"localvar":"my","containerName":"next_network_new","definition":"my","name":"@found","line":204,"kind":13},{"name":"$self","containerName":"next_network_new","line":204,"kind":13},{"localvar":"my","definition":"my","name":"$netant","containerName":"next_network_new","line":205,"kind":13},{"containerName":"next_network_new","name":"@found","line":205,"kind":13},{"kind":13,"line":206,"name":"$net","containerName":"next_network_new"},{"line":206,"kind":12,"name":"is_mu_isomorphic","containerName":"next_network_new"},{"name":"$netant","containerName":"next_network_new","kind":13,"line":206},{"containerName":"next_network_new","name":"@found","line":210,"kind":13},{"containerName":"next_network_new","name":"$net","line":210,"kind":13},{"line":211,"kind":13,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":211,"name":"@found","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$net","kind":13,"line":212}],"line":177,"kind":12,"range":{"end":{"character":9999,"line":213},"start":{"character":0,"line":177}},"name":"next_network_new"},{"name":"START","line":179,"kind":12},{"name":"index1","kind":12,"line":181},{"name":"numcandidates","line":181,"kind":12},{"name":"index2","line":182,"kind":12},{"line":183,"kind":12,"name":"index1"},{"line":186,"kind":12,"name":"index2"},{"line":186,"kind":12,"name":"numcandidates"},{"kind":12,"line":187,"name":"parent"},{"kind":12,"line":192,"name":"oldnet"},{"kind":12,"line":195,"name":"candidates"},{"name":"index1","kind":12,"line":195},{"line":196,"kind":12,"name":"candidates"},{"name":"index1","kind":12,"line":196},{"kind":12,"line":197,"name":"candidates"},{"name":"index2","kind":12,"line":197},{"kind":12,"line":198,"name":"candidates"},{"kind":12,"line":198,"name":"index2"},{"line":199,"kind":12,"name":"numhybrids"},{"kind":12,"line":200,"name":"oldnet"},{"kind":12,"line":201,"containerName":"PhyloNetwork","name":"Bio"},{"line":201,"kind":12,"name":"oldnet"},{"name":"index1","line":203,"kind":12},{"line":204,"kind":12,"name":"found"},{"kind":12,"line":207,"name":"START"},{"name":"found","line":211,"kind":12},{"name":"%self","containerName":null,"line":215,"kind":13},{"kind":12,"line":215,"name":"index1"},{"line":216,"kind":12,"name":"START"},{"range":{"start":{"line":230,"character":0},"end":{"line":254,"character":9999}},"name":"next_network","line":230,"children":[{"containerName":"next_network","name":"$self","definition":"my","localvar":"my","kind":13,"line":231},{"kind":13,"line":232,"containerName":"next_network","name":"$hybnow","definition":"my","localvar":"my"},{"name":"$hybnow","containerName":"next_network","line":234,"kind":13},{"kind":13,"line":234,"name":"$self","containerName":"next_network"},{"line":240,"kind":13,"localvar":"my","containerName":"next_network","name":"$net","definition":"my"},{"name":"$hybnow","containerName":"next_network","line":241,"kind":13},{"line":241,"kind":13,"containerName":"next_network","name":"$self"},{"containerName":"next_network","name":"$net","kind":13,"line":242},{"kind":13,"line":242,"containerName":"next_network","name":"$self"},{"name":"$hybnow","containerName":"next_network","kind":13,"line":242},{"line":242,"kind":12,"containerName":"next_network","name":"next_network_new"},{"containerName":"next_network","name":"$net","kind":13,"line":244},{"containerName":"next_network","name":"$self","kind":13,"line":244},{"containerName":"next_network","name":"next_network_new","kind":12,"line":244},{"containerName":"next_network","name":"$net","kind":13,"line":246},{"name":"$hybnow","containerName":"next_network","line":247,"kind":13},{"kind":13,"line":247,"name":"$self","containerName":"next_network"},{"kind":13,"line":248,"containerName":"next_network","name":"$self"},{"name":"$self","containerName":"next_network","line":248,"kind":13},{"name":"$net","containerName":"next_network","kind":13,"line":253}],"kind":12,"detail":"($self)","signature":{"label":"next_network($self)","documentation":"1;\n# $Id: FactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::FactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::FactoryX - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::FactoryX;\n\nuse strict;\nuse warnings;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactoryX;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n\n  if (! defined $numhybrids) {\n    $numhybrids=$numleaves-1;\n  }\n  $self->{numhybrids}=$numhybrids;\n  if ($numhybrids ==0) {\n    return Bio::PhyloNetwork::TreeFactoryX->new(-leaves=>\\@leaves);\n  }\n  my $parent;\n  if ($numhybrids > 1) {\n    $parent=new($pkg,'-leaves'=>\\@leaves,\n\t\t'-numhybrids'=>($numhybrids-1)\n\t       );\n    my @subfactories=@{$parent->{subfactories}};\n    push @subfactories,$parent;\n#    print \"$numhybrids : \".(scalar @subfactories);\n#    print \"\\n\";\n    $self->{subfactories}=\\@subfactories;\n#    print \"$numhybrids: \".(scalar @subfactories).\"\\n\";\n  }\n  else {\n    $parent=Bio::PhyloNetwork::TreeFactoryX->new(-leaves=>\\@leaves);\n    $self->{subfactories}=[$parent];\n  }\n  $self->{parent}=$parent;\n  $self->update();\n  $self->{found}=[];\n  $self->{thrown}=0;\n  $self->{hybnow}=0;\n  bless($self,$pkg);\n}\n\nsub update {\n  my ($self)=@_;\n\n  if (defined $self->{oldnet}) {\n    my @candidates=$self->{oldnet}->edges();\n    $self->{candidates}=\\@candidates;\n    $self->{numcandidates}=(scalar @candidates);\n    $self->{index1}=0;\n    $self->{index2}=0;\n  } else {\n    $self->{candidates}=[];\n    $self->{numcandidates}=0;\n    $self->{index1}=0;\n    $self->{index2}=0;\n  }\n}\n\nsub next_network_repeated {\n  my ($self)=@_;\n\n  return 0 if ($self->{thrown} >= (scalar @{$self->{found}}));\n  $self->{thrown}=$self->{thrown}+1;\n  return $self->{found}->[$self->{thrown}-1];\n}\n\nsub next_network_new {\n  my ($self)=@_;\n START:\n#  print $self->{index1}.\",\".$self->{index2}.\":\".$self->{numcandidates}.\"\\n\";\n  if ($self->{index1} >= $self->{numcandidates}) {\n    $self->{index2}++;\n    $self->{index1}=0;\n  }\n#  print $self->{index1}.\",\".$self->{index2}.\":\".$self->{numcandidates}.\"\\n\";\n  if ($self->{index2} >= $self->{numcandidates}) {\n    my $oldnet=$self->{parent}->next_network_repeated();\n    if (! $oldnet) {\n#      print \"notoldnet\\n\";\n      return 0;\n    }\n    $self->{oldnet}=$oldnet;\n    $self->update();\n  }\n  my $u1=$self->{candidates}->[$self->{index1}]->[0];\n  my $v1=$self->{candidates}->[$self->{index1}]->[1];\n  my $u2=$self->{candidates}->[$self->{index2}]->[0];\n  my $v2=$self->{candidates}->[$self->{index2}]->[1];\n  my $lbl=$self->{numhybrids};\n  if ($self->{oldnet}->is_attackable($u1,$v1,$u2,$v2)) {\n    my $net=Bio::PhyloNetwork->new(-graph=>$self->{oldnet}->graph);\n    $net->do_attack($u1,$v1,$u2,$v2,$lbl);\n    $self->{index1}++;\n    my @found=@{$self->{found}};\n    foreach my $netant (@found) {\n      if ($net->is_mu_isomorphic($netant) ) {\n\tgoto START;\n      }\n    }\n    push @found,$net;\n    $self->{found}=\\@found;\n    return $net;\n  }\n  else {\n    $self->{index1}++;\n    goto START;\n  }\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a network\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"line":233,"kind":12,"name":"WTF"},{"name":"hybnow","kind":12,"line":234},{"line":241,"kind":12,"name":"numhybrids"},{"name":"subfactories","kind":12,"line":242},{"line":247,"kind":12,"name":"numhybrids"},{"name":"hybnow","line":248,"kind":12},{"kind":12,"line":248,"name":"hybnow"},{"line":249,"kind":12,"name":"WTF"}],"version":5}