{"vars":[{"line":127,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"character":9999,"line":148},"start":{"character":0,"line":143}},"name":"name","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).","label":"name($self)"},"containerName":"main::","definition":"sub","line":143,"children":[{"line":144,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"name"},{"containerName":"name","name":"$self","kind":13,"line":146},{"kind":12,"line":146,"containerName":"name","name":"throw_not_implemented"}],"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"description($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"kind":13,"line":166,"name":"$self","definition":"my","containerName":"description","localvar":"my"},{"kind":13,"line":168,"containerName":"description","name":"$self"},{"kind":12,"line":168,"containerName":"description","name":"throw_not_implemented"}],"line":165,"name":"description","range":{"start":{"line":165,"character":0},"end":{"line":170,"character":9999}}},{"kind":12,"line":187,"children":[{"line":188,"kind":13,"localvar":"my","containerName":"species","name":"$self","definition":"my"},{"containerName":"species","name":"$self","line":190,"kind":13},{"name":"throw_not_implemented","containerName":"species","line":190,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"species($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional)."},"name":"species","range":{"start":{"line":187,"character":0},"end":{"line":192,"character":9999}}},{"kind":12,"line":209,"children":[{"line":210,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"comment"},{"line":212,"kind":13,"containerName":"comment","name":"$self"},{"name":"throw_not_implemented","containerName":"comment","kind":12,"line":212}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"comment($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).","parameters":[{"label":"$self"}]},"name":"comment","range":{"end":{"character":9999,"line":214},"start":{"line":209,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"each_gene_symbol($self)"},"kind":12,"line":230,"children":[{"line":231,"kind":13,"localvar":"my","containerName":"each_gene_symbol","name":"$self","definition":"my"},{"name":"$self","containerName":"each_gene_symbol","line":233,"kind":13},{"line":233,"kind":12,"name":"throw_not_implemented","containerName":"each_gene_symbol"}],"name":"each_gene_symbol","range":{"start":{"line":230,"character":0},"end":{"character":9999,"line":235}}},{"kind":12,"children":[{"kind":13,"line":252,"containerName":"add_gene_symbols","name":"$self","definition":"my","localvar":"my"},{"containerName":"add_gene_symbols","name":"$self","line":254,"kind":13},{"containerName":"add_gene_symbols","name":"throw_not_implemented","kind":12,"line":254}],"line":251,"definition":"sub","containerName":"main::","signature":{"label":"add_gene_symbols($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s)."},"detail":"($self)","name":"add_gene_symbols","range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":251}}},{"name":"remove_gene_symbols","range":{"start":{"line":269,"character":0},"end":{"character":9999,"line":274}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_gene_symbols($self)"},"kind":12,"line":269,"children":[{"localvar":"my","containerName":"remove_gene_symbols","definition":"my","name":"$self","line":270,"kind":13},{"containerName":"remove_gene_symbols","name":"$self","line":272,"kind":13},{"line":272,"kind":12,"name":"throw_not_implemented","containerName":"remove_gene_symbols"}]},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Variant($self)"},"kind":12,"line":294,"children":[{"line":295,"kind":13,"localvar":"my","containerName":"each_Variant","definition":"my","name":"$self"},{"kind":13,"line":297,"name":"$self","containerName":"each_Variant"},{"name":"throw_not_implemented","containerName":"each_Variant","kind":12,"line":297}],"name":"each_Variant","range":{"start":{"line":294,"character":0},"end":{"line":299,"character":9999}}},{"name":"add_Variants","range":{"end":{"character":9999,"line":319},"start":{"line":314,"character":0}},"kind":12,"children":[{"containerName":"add_Variants","definition":"my","name":"$self","localvar":"my","kind":13,"line":315},{"kind":13,"line":317,"name":"$self","containerName":"add_Variants"},{"line":317,"kind":12,"containerName":"add_Variants","name":"throw_not_implemented"}],"line":314,"definition":"sub","containerName":"main::","signature":{"label":"add_Variants($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).","parameters":[{"label":"$self"}]},"detail":"($self)"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_Variants($self)"},"kind":12,"line":333,"children":[{"kind":13,"line":334,"definition":"my","name":"$self","containerName":"remove_Variants","localvar":"my"},{"name":"$self","containerName":"remove_Variants","line":336,"kind":13},{"containerName":"remove_Variants","name":"throw_not_implemented","line":336,"kind":12}],"name":"remove_Variants","range":{"end":{"line":338,"character":9999},"start":{"character":0,"line":333}}},{"kind":12,"children":[{"containerName":"each_Reference","name":"$self","definition":"my","localvar":"my","kind":13,"line":355},{"line":357,"kind":13,"containerName":"each_Reference","name":"$self"},{"kind":12,"line":357,"containerName":"each_Reference","name":"throw_not_implemented"}],"line":354,"definition":"sub","containerName":"main::","signature":{"label":"each_Reference($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","name":"each_Reference","range":{"end":{"character":9999,"line":359},"start":{"character":0,"line":354}}},{"name":"add_References","range":{"end":{"line":380,"character":9999},"start":{"character":0,"line":375}},"kind":12,"children":[{"line":376,"kind":13,"localvar":"my","containerName":"add_References","name":"$self","definition":"my"},{"kind":13,"line":378,"containerName":"add_References","name":"$self"},{"containerName":"add_References","name":"throw_not_implemented","line":378,"kind":12}],"line":375,"definition":"sub","containerName":"main::","signature":{"label":"add_References($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s)."},"detail":"($self)"},{"children":[{"definition":"my","name":"$self","containerName":"remove_References","localvar":"my","kind":13,"line":395},{"line":397,"kind":13,"containerName":"remove_References","name":"$self"},{"line":397,"kind":12,"containerName":"remove_References","name":"throw_not_implemented"}],"line":394,"kind":12,"signature":{"label":"remove_References($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":394},"end":{"line":399,"character":9999}},"name":"remove_References"},{"name":"each_CytoPosition","range":{"end":{"character":9999,"line":420},"start":{"character":0,"line":415}},"definition":"sub","containerName":"main::","signature":{"label":"each_CytoPosition($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":416,"definition":"my","name":"$self","containerName":"each_CytoPosition","localvar":"my"},{"line":418,"kind":13,"name":"$self","containerName":"each_CytoPosition"},{"containerName":"each_CytoPosition","name":"throw_not_implemented","line":418,"kind":12}],"line":415},{"name":"add_CytoPositions","range":{"start":{"character":0,"line":436},"end":{"line":441,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"add_CytoPositions($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).","parameters":[{"label":"$self"}]},"kind":12,"line":436,"children":[{"kind":13,"line":437,"containerName":"add_CytoPositions","definition":"my","name":"$self","localvar":"my"},{"line":439,"kind":13,"name":"$self","containerName":"add_CytoPositions"},{"containerName":"add_CytoPositions","name":"throw_not_implemented","line":439,"kind":12}]},{"name":"remove_CytoPositions","range":{"end":{"character":9999,"line":460},"start":{"character":0,"line":455}},"definition":"sub","containerName":"main::","signature":{"label":"remove_CytoPositions($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :"},"detail":"($self)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"remove_CytoPositions","line":456,"kind":13},{"line":458,"kind":13,"name":"$self","containerName":"remove_CytoPositions"},{"line":458,"kind":12,"containerName":"remove_CytoPositions","name":"throw_not_implemented"}],"line":455},{"children":[{"localvar":"my","containerName":"each_Correlate","definition":"my","name":"$self","line":480,"kind":13},{"name":"$self","containerName":"each_Correlate","line":482,"kind":13},{"kind":12,"line":482,"containerName":"each_Correlate","name":"throw_not_implemented"}],"line":479,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","label":"each_Correlate($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":479,"character":0},"end":{"character":9999,"line":484}},"name":"each_Correlate"},{"range":{"end":{"character":9999,"line":507},"start":{"character":0,"line":502}},"name":"add_Correlates","children":[{"localvar":"my","containerName":"add_Correlates","definition":"my","name":"$self","line":503,"kind":13},{"line":505,"kind":13,"containerName":"add_Correlates","name":"$self"},{"containerName":"add_Correlates","name":"throw_not_implemented","kind":12,"line":505}],"line":502,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).","label":"add_Correlates($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"remove_Correlates","range":{"start":{"character":0,"line":521},"end":{"line":526,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"remove_Correlates($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :"},"kind":12,"line":521,"children":[{"line":522,"kind":13,"localvar":"my","containerName":"remove_Correlates","definition":"my","name":"$self"},{"containerName":"remove_Correlates","name":"$self","line":524,"kind":13},{"name":"throw_not_implemented","containerName":"remove_Correlates","kind":12,"line":524}]},{"range":{"start":{"character":0,"line":544},"end":{"character":9999,"line":549}},"name":"each_Measure","line":544,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"each_Measure","line":545,"kind":13},{"kind":13,"line":547,"name":"$self","containerName":"each_Measure"},{"kind":12,"line":547,"containerName":"each_Measure","name":"throw_not_implemented"}],"kind":12,"detail":"($self)","signature":{"label":"each_Measure($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"range":{"start":{"character":0,"line":565},"end":{"character":9999,"line":570}},"name":"add_Measures","line":565,"children":[{"kind":13,"line":566,"containerName":"add_Measures","name":"$self","definition":"my","localvar":"my"},{"containerName":"add_Measures","name":"$self","kind":13,"line":568},{"kind":12,"line":568,"containerName":"add_Measures","name":"throw_not_implemented"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).","label":"add_Measures($self)"},"containerName":"main::","definition":"sub"},{"line":584,"children":[{"localvar":"my","containerName":"remove_Measures","definition":"my","name":"$self","line":585,"kind":13},{"name":"$self","containerName":"remove_Measures","line":587,"kind":13},{"containerName":"remove_Measures","name":"throw_not_implemented","kind":12,"line":587}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","label":"remove_Measures($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":584},"end":{"character":9999,"line":589}},"name":"remove_Measures"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","label":"each_keyword($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":606,"name":"$self","definition":"my","containerName":"each_keyword","localvar":"my"},{"name":"$self","containerName":"each_keyword","kind":13,"line":608},{"kind":12,"line":608,"containerName":"each_keyword","name":"throw_not_implemented"}],"line":605,"kind":12,"range":{"end":{"character":9999,"line":610},"start":{"character":0,"line":605}},"name":"each_keyword"},{"kind":12,"line":626,"children":[{"line":627,"kind":13,"localvar":"my","containerName":"add_keywords","definition":"my","name":"$self"},{"kind":13,"line":629,"name":"$self","containerName":"add_keywords"},{"kind":12,"line":629,"name":"throw_not_implemented","containerName":"add_keywords"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"add_keywords($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"}]},"name":"add_keywords","range":{"start":{"character":0,"line":626},"end":{"character":9999,"line":631}}},{"name":"remove_keywords","range":{"end":{"character":9999,"line":650},"start":{"character":0,"line":645}},"kind":12,"line":645,"children":[{"line":646,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"remove_keywords"},{"kind":13,"line":648,"name":"$self","containerName":"remove_keywords"},{"containerName":"remove_keywords","name":"throw_not_implemented","line":648,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"remove_keywords($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}]}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_DBLink($self)"},"kind":12,"line":666,"children":[{"localvar":"my","containerName":"each_DBLink","definition":"my","name":"$self","line":667,"kind":13},{"containerName":"each_DBLink","name":"$self","line":669,"kind":13},{"name":"throw_not_implemented","containerName":"each_DBLink","line":669,"kind":12}],"name":"each_DBLink","range":{"end":{"line":671,"character":9999},"start":{"character":0,"line":666}}},{"range":{"end":{"line":692,"character":9999},"start":{"character":0,"line":687}},"name":"add_DBLinks","signature":{"label":"add_DBLinks($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":688,"kind":13,"localvar":"my","containerName":"add_DBLinks","name":"$self","definition":"my"},{"line":690,"kind":13,"name":"$self","containerName":"add_DBLinks"},{"kind":12,"line":690,"containerName":"add_DBLinks","name":"throw_not_implemented"}],"line":687,"kind":12},{"kind":12,"children":[{"line":707,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"remove_DBLinks"},{"kind":13,"line":709,"containerName":"remove_DBLinks","name":"$self"},{"containerName":"remove_DBLinks","name":"throw_not_implemented","kind":12,"line":709}],"line":706,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_DBLinks($self)"},"detail":"($self)","name":"remove_DBLinks","range":{"start":{"line":706,"character":0},"end":{"line":711,"character":9999}}},{"range":{"start":{"character":0,"line":730},"end":{"character":9999,"line":735}},"name":"each_Genotype","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :","label":"each_Genotype($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":731,"name":"$self","definition":"my","containerName":"each_Genotype","localvar":"my"},{"containerName":"each_Genotype","name":"$self","line":733,"kind":13},{"line":733,"kind":12,"containerName":"each_Genotype","name":"throw_not_implemented"}],"line":730,"kind":12},{"range":{"start":{"line":751,"character":0},"end":{"line":756,"character":9999}},"name":"add_Genotypes","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".","parameters":[{"label":"$self"}],"label":"add_Genotypes($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":752,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_Genotypes"},{"containerName":"add_Genotypes","name":"$self","line":754,"kind":13},{"name":"throw_not_implemented","containerName":"add_Genotypes","kind":12,"line":754}],"line":751,"kind":12},{"signature":{"label":"remove_Genotypes($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":771,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"remove_Genotypes"},{"containerName":"remove_Genotypes","name":"$self","kind":13,"line":773},{"line":773,"kind":12,"name":"throw_not_implemented","containerName":"remove_Genotypes"}],"line":770,"kind":12,"range":{"end":{"line":775,"character":9999},"start":{"character":0,"line":770}},"name":"remove_Genotypes"}],"version":5}