{"vars":[{"name":"base","containerName":"","line":101,"kind":2},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":122,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"containerName":"new","name":"@args","line":122,"kind":13},{"line":124,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":124},{"line":124,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":126,"name":"$desc","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":126,"containerName":"new","name":"$created"},{"kind":13,"line":126,"containerName":"new","name":"$contributors"},{"line":126,"kind":13,"name":"$edited","containerName":"new"},{"kind":13,"line":127,"containerName":"new","name":"$self"},{"line":127,"kind":12,"name":"_rearrange","containerName":"new"},{"line":130,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","line":132,"kind":13},{"name":"init","containerName":"new","line":132,"kind":12},{"containerName":"new","name":"$desc","kind":13,"line":134},{"line":134,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"description","line":134,"kind":12},{"name":"$desc","containerName":"new","line":134,"kind":13},{"kind":13,"line":135,"name":"$created","containerName":"new"},{"name":"$self","containerName":"new","line":135,"kind":13},{"name":"created","containerName":"new","line":135,"kind":12},{"kind":13,"line":135,"name":"$created","containerName":"new"},{"line":136,"kind":13,"containerName":"new","name":"$contributors"},{"kind":13,"line":136,"name":"$self","containerName":"new"},{"kind":12,"line":136,"containerName":"new","name":"contributors"},{"kind":13,"line":136,"name":"$contributors","containerName":"new"},{"line":137,"kind":13,"containerName":"new","name":"$edited"},{"kind":13,"line":137,"name":"$self","containerName":"new"},{"name":"edited","containerName":"new","line":137,"kind":12},{"kind":13,"line":137,"containerName":"new","name":"$edited"},{"name":"$self","containerName":"new","line":139,"kind":13}],"line":120,"kind":12,"range":{"end":{"line":141,"character":9999},"start":{"character":0,"line":120}},"name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":124},{"name":"init","range":{"start":{"character":0,"line":156},"end":{"line":166,"character":9999}},"kind":12,"line":156,"children":[{"line":158,"kind":13,"localvar":"my","containerName":"init","definition":"my","name":"$self"},{"line":160,"kind":13,"containerName":"init","name":"$self"},{"kind":12,"line":160,"name":"description","containerName":"init"},{"name":"$self","containerName":"init","kind":13,"line":161},{"line":161,"kind":12,"containerName":"init","name":"created"},{"kind":13,"line":162,"containerName":"init","name":"$self"},{"line":162,"kind":12,"name":"contributors","containerName":"init"},{"name":"$self","containerName":"init","line":163,"kind":13},{"name":"edited","containerName":"init","kind":12,"line":163}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :"}},{"children":[{"localvar":"my","containerName":"description","name":"$self","definition":"my","line":184,"kind":13},{"containerName":"description","name":"$value","line":184,"kind":13},{"kind":13,"line":186,"name":"$value","containerName":"description"},{"name":"$self","containerName":"description","line":187,"kind":13},{"name":"$value","containerName":"description","line":187,"kind":13},{"containerName":"description","name":"$self","line":190,"kind":13}],"line":183,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n   \n    $self->description( \"\" );\n    $self->created( \"\" );\n    $self->contributors( \"\" );\n    $self->edited( \"\" );\n    \n  \n} # init\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $mm->description( \"The central form of ...\" );\n           or\n           print $mm->description();\n Function: Set/get for the description field of the Mini MIM database.\n Returns : The description.\n Args    : The description (optional).","label":"description($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"line":183,"character":0},"end":{"character":9999,"line":192}},"name":"description"},{"children":[{"definition":"my","name":"$self","containerName":"created","localvar":"my","kind":13,"line":210},{"kind":13,"line":210,"name":"$value","containerName":"created"},{"name":"$value","containerName":"created","line":212,"kind":13},{"name":"$self","containerName":"created","line":213,"kind":13},{"kind":13,"line":213,"name":"$value","containerName":"created"},{"containerName":"created","name":"$self","kind":13,"line":216}],"line":209,"kind":12,"signature":{"label":"created($self,$value)","documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n   \n    $self->description( \"\" );\n    $self->created( \"\" );\n    $self->contributors( \"\" );\n    $self->edited( \"\" );\n    \n  \n} # init\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $mm->description( \"The central form of ...\" );\n           or\n           print $mm->description();\n Function: Set/get for the description field of the Mini MIM database.\n Returns : The description.\n Args    : The description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 created\n\n Title   : created\n Usage   : $mm->created( \"Victor A. McKusick: 6/4/1986\" );\n           or\n           print $mm->created();\n Function: Set/get for the created field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":218,"character":9999},"start":{"character":0,"line":209}},"name":"created"},{"name":"contributors","range":{"end":{"line":244,"character":9999},"start":{"character":0,"line":235}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n   \n    $self->description( \"\" );\n    $self->created( \"\" );\n    $self->contributors( \"\" );\n    $self->edited( \"\" );\n    \n  \n} # init\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $mm->description( \"The central form of ...\" );\n           or\n           print $mm->description();\n Function: Set/get for the description field of the Mini MIM database.\n Returns : The description.\n Args    : The description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 created\n\n Title   : created\n Usage   : $mm->created( \"Victor A. McKusick: 6/4/1986\" );\n           or\n           print $mm->created();\n Function: Set/get for the created field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub created {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_created\" } = $value;\n    }\n\n    return $self->{ \"_created\" };\n\n} # created\n\n\n\n\n=head2 contributors\n\n Title   : contributors\n Usage   : $mm->contributors( \"Kelly A. Przylepa - revised: 03/18/2002\" );\n           or\n           print $mm->contributors();\n Function: Set/get for the contributors field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).","label":"contributors($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"contributors","line":236,"kind":13},{"line":236,"kind":13,"name":"$value","containerName":"contributors"},{"line":238,"kind":13,"name":"$value","containerName":"contributors"},{"line":239,"kind":13,"containerName":"contributors","name":"$self"},{"kind":13,"line":239,"name":"$value","containerName":"contributors"},{"kind":13,"line":242,"name":"$self","containerName":"contributors"}],"line":235},{"line":261,"children":[{"kind":13,"line":262,"name":"$self","definition":"my","containerName":"edited","localvar":"my"},{"line":262,"kind":13,"containerName":"edited","name":"$value"},{"line":264,"kind":13,"name":"$value","containerName":"edited"},{"line":265,"kind":13,"containerName":"edited","name":"$self"},{"kind":13,"line":265,"name":"$value","containerName":"edited"},{"kind":13,"line":268,"containerName":"edited","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n   \n    $self->description( \"\" );\n    $self->created( \"\" );\n    $self->contributors( \"\" );\n    $self->edited( \"\" );\n    \n  \n} # init\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $mm->description( \"The central form of ...\" );\n           or\n           print $mm->description();\n Function: Set/get for the description field of the Mini MIM database.\n Returns : The description.\n Args    : The description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 created\n\n Title   : created\n Usage   : $mm->created( \"Victor A. McKusick: 6/4/1986\" );\n           or\n           print $mm->created();\n Function: Set/get for the created field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub created {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_created\" } = $value;\n    }\n\n    return $self->{ \"_created\" };\n\n} # created\n\n\n\n\n=head2 contributors\n\n Title   : contributors\n Usage   : $mm->contributors( \"Kelly A. Przylepa - revised: 03/18/2002\" );\n           or\n           print $mm->contributors();\n Function: Set/get for the contributors field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub contributors {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_contributors\" } = $value;\n    }\n\n    return $self->{ \"_contributors\" };\n\n} # contributors\n\n\n\n\n=head2 edited\n\n Title   : edited\n Usage   : $mm->edited( \"alopez: 06/03/1997\" );\n           or\n           print $mm->edited();\n Function: Set/get for the edited field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).","label":"edited($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"line":261,"character":0},"end":{"line":270,"character":9999}},"name":"edited"},{"range":{"end":{"character":9999,"line":301},"start":{"character":0,"line":285}},"name":"to_string","children":[{"line":286,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string"},{"localvar":"my","name":"$s","definition":"my","containerName":"to_string","line":288,"kind":13},{"kind":13,"line":290,"containerName":"to_string","name":"$s"},{"kind":13,"line":291,"name":"$s","containerName":"to_string"},{"line":291,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":291,"containerName":"to_string","name":"description"},{"name":"$s","containerName":"to_string","kind":13,"line":292},{"containerName":"to_string","name":"$s","line":293,"kind":13},{"kind":13,"line":293,"containerName":"to_string","name":"$self"},{"line":293,"kind":12,"containerName":"to_string","name":"created"},{"containerName":"to_string","name":"$s","line":294,"kind":13},{"line":295,"kind":13,"containerName":"to_string","name":"$s"},{"line":295,"kind":13,"name":"$self","containerName":"to_string"},{"line":295,"kind":12,"containerName":"to_string","name":"contributors"},{"line":296,"kind":13,"name":"$s","containerName":"to_string"},{"line":297,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":297},{"name":"edited","containerName":"to_string","line":297,"kind":12},{"kind":13,"line":299,"containerName":"to_string","name":"$s"}],"line":285,"kind":12,"signature":{"label":"to_string($self)","documentation":"1;\n# $Id: MiniMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::MiniMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::MiniMIMentry - Representation of a Mini MIM entry\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::MiniMIMentry;\n\n  $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                 -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                 -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                 -edited       => \"alopez: 06/03/1997\" );\n\n\n=head1 DESCRIPTION\n\nThis class representats of Mini MIM entries.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::OMIM::MiniMIMentry;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $mm = Bio::Phenotype::OMIM::MiniMIMentry->new( -description  => \"The central form of ...\",\n                                                          -created      => \"Victor A. McKusick: 6/4/1986\",\n                                                          -contributors => \"Kelly A. Przylepa - revised: 03/18/2002\",\n                                                          -edited       => \"alopez: 06/03/1997\" );\n\n Function: Creates a new MiniMIMentry object.\n Returns : A new MiniMIMentry object.\n Args    : -description  => a description\n           -created      => name(s) and date(s) (free form)\n           -contributors => name(s) and date(s) (free form)\n           -edited       => name(s) and date(s) (free form)\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $desc, $created, $contributors, $edited )\n    = $self->_rearrange( [ qw( DESCRIPTION\n                               CREATED\n                               CONTRIBUTORS\n                               EDITED ) ], @args );\n\n    $self->init(); \n\n    $desc         && $self->description( $desc );\n    $created      && $self->created( $created );\n    $contributors && $self->contributors( $contributors );\n    $edited       && $self->edited( $edited );\n\n    return $self;\n\n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $mm->init();   \n Function: Initializes this MiniMIMentry to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n   \n    $self->description( \"\" );\n    $self->created( \"\" );\n    $self->contributors( \"\" );\n    $self->edited( \"\" );\n    \n  \n} # init\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $mm->description( \"The central form of ...\" );\n           or\n           print $mm->description();\n Function: Set/get for the description field of the Mini MIM database.\n Returns : The description.\n Args    : The description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 created\n\n Title   : created\n Usage   : $mm->created( \"Victor A. McKusick: 6/4/1986\" );\n           or\n           print $mm->created();\n Function: Set/get for the created field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub created {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_created\" } = $value;\n    }\n\n    return $self->{ \"_created\" };\n\n} # created\n\n\n\n\n=head2 contributors\n\n Title   : contributors\n Usage   : $mm->contributors( \"Kelly A. Przylepa - revised: 03/18/2002\" );\n           or\n           print $mm->contributors();\n Function: Set/get for the contributors field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub contributors {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_contributors\" } = $value;\n    }\n\n    return $self->{ \"_contributors\" };\n\n} # contributors\n\n\n\n\n=head2 edited\n\n Title   : edited\n Usage   : $mm->edited( \"alopez: 06/03/1997\" );\n           or\n           print $mm->edited();\n Function: Set/get for the edited field of the Mini MIM database.\n Returns : Name(s) and date(s) [scalar - free form].\n Args    : Name(s) and date(s) [scalar - free form] (optional).\n\n\nsub edited {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_edited\" } = $value;\n    }\n\n    return $self->{ \"_edited\" };\n\n} # edited\n\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $mm->to_string();\n Function: To string method for MiniMIMentry objects.\n Returns : A string representations of this MiniMIMentry.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"}],"version":5}