{"vars":[{"name":"base","containerName":"","line":98,"kind":2},{"range":{"start":{"line":100,"character":0},"end":{"line":121,"character":9999}},"name":"new","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":102,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":102},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":103},{"name":"$class","containerName":"new","kind":13,"line":103},{"name":"@args","containerName":"new","line":103,"kind":13},{"kind":13,"line":105,"definition":"my","name":"$id","containerName":"new","localvar":"my"},{"kind":13,"line":105,"containerName":"new","name":"$name"},{"containerName":"new","name":"$description","line":105,"kind":13},{"name":"$comment","containerName":"new","kind":13,"line":105},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","line":106,"kind":12},{"kind":13,"line":112,"name":"@args","containerName":"new"},{"kind":13,"line":114,"containerName":"new","name":"$self"},{"kind":13,"line":116,"name":"$id","containerName":"new"},{"line":116,"kind":13,"name":"$self","containerName":"new"},{"line":116,"kind":12,"containerName":"new","name":"id"},{"name":"$id","containerName":"new","kind":13,"line":116},{"kind":13,"line":117,"containerName":"new","name":"$name"},{"name":"$self","containerName":"new","line":117,"kind":13},{"line":117,"kind":12,"name":"name","containerName":"new"},{"line":117,"kind":13,"containerName":"new","name":"$name"},{"containerName":"new","name":"$description","line":118,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":118},{"kind":12,"line":118,"name":"description","containerName":"new"},{"kind":13,"line":118,"name":"$description","containerName":"new"},{"line":120,"kind":13,"containerName":"new","name":"$self"}],"line":100,"kind":12},{"line":103,"kind":12,"containerName":"new","name":"SUPER"},{"definition":"sub","containerName":"main::","signature":{"label":"id($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional)."},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"id","localvar":"my","kind":13,"line":137},{"name":"$value","containerName":"id","kind":13,"line":137},{"kind":13,"line":138,"containerName":"id","name":"$self"},{"containerName":"id","name":"$value","kind":13,"line":138},{"kind":13,"line":138,"name":"$value","containerName":"id"},{"kind":13,"line":139,"containerName":"id","name":"$self"}],"line":136,"name":"id","range":{"start":{"character":0,"line":136},"end":{"line":140,"character":9999}}},{"kind":12,"line":154,"children":[{"line":155,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"name"},{"kind":13,"line":155,"name":"$value","containerName":"name"},{"kind":13,"line":156,"containerName":"name","name":"$self"},{"containerName":"name","name":"$value","line":156,"kind":13},{"containerName":"name","name":"$value","kind":13,"line":156},{"kind":13,"line":157,"containerName":"name","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"name($self,$value)"},"name":"name","range":{"start":{"line":154,"character":0},"end":{"line":158,"character":9999}}},{"kind":12,"children":[{"kind":13,"line":173,"containerName":"description","name":"$self","definition":"my","localvar":"my"},{"containerName":"description","name":"$value","kind":13,"line":173},{"line":174,"kind":13,"containerName":"description","name":"$self"},{"name":"$value","containerName":"description","kind":13,"line":174},{"containerName":"description","name":"$value","kind":13,"line":174},{"name":"$self","containerName":"description","kind":13,"line":175}],"line":172,"definition":"sub","containerName":"main::","signature":{"label":"description($self,$value)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","name":"description","range":{"start":{"character":0,"line":172},"end":{"character":9999,"line":176}}},{"name":"add_synonym","range":{"start":{"line":192,"character":0},"end":{"line":194,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@values)","signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_synonym($self,@values)"},"kind":12,"line":192,"children":[{"localvar":"my","containerName":"add_synonym","name":"$self","definition":"my","line":193,"kind":13},{"kind":13,"line":193,"name":"@values","containerName":"add_synonym"},{"containerName":"add_synonym","name":"$self","kind":13,"line":194}]},{"kind":13,"line":194,"containerName":null,"name":"@values"},{"kind":12,"children":[{"line":209,"kind":13,"localvar":"my","containerName":"each_synonym","definition":"my","name":"$self"},{"kind":13,"line":210,"name":"$self","containerName":"each_synonym"}],"line":208,"name":"each_synonym","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":208},"end":{"character":9999,"line":210}}},{"range":{"end":{"line":225,"character":9999},"start":{"character":0,"line":222}},"name":"purge_synonyms","line":222,"children":[{"containerName":"purge_synonyms","name":"$self","definition":"my","localvar":"my","kind":13,"line":223},{"kind":13,"line":224,"name":"$self","containerName":"purge_synonyms"}],"kind":12,"detail":"($self)","signature":{"label":"purge_synonyms($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :\n\n\nsub purge_synonyms {\n    my ( $self ) = @_;\n    $self->{ \"_synonyms\" } = [];\n}\n\n\n=head2 Twig management\n\nEach MeSH term belongs to a complex tree like hierachy of terms where\neach term can appear multiple times. The immediately surrounding nodes\nof the tree are modelled in twigs.\n\nSee: L<Bio::Phenotype::MeSH::Twig>.\n\n\n=head2 add_twig\n\n Title   : add_twig\n Usage   : $obj->add_twig( @twigs );\n           or\n           $obj->add_twig( $twig );\n Function: Pushes one or more twig term names [scalars, most likely Strings]\n           into the list of twigs.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_twig($self,@values)"},"detail":"($self,@values)","kind":12,"children":[{"containerName":"add_twig","definition":"my","name":"$self","localvar":"my","kind":13,"line":252},{"name":"@values","containerName":"add_twig","kind":13,"line":252},{"line":253,"kind":13,"localvar":"my","definition":"my","name":"$twig","containerName":"add_twig"},{"kind":13,"line":253,"name":"@values","containerName":"add_twig"},{"kind":13,"line":254,"containerName":"add_twig","name":"$self"},{"containerName":"add_twig","name":"warn","kind":12,"line":254},{"line":255,"kind":13,"containerName":"add_twig","name":"$twig"},{"line":255,"kind":12,"containerName":"add_twig","name":"isa"},{"name":"$twig","containerName":"add_twig","kind":13,"line":256},{"line":256,"kind":12,"name":"term","containerName":"add_twig"},{"kind":13,"line":256,"containerName":"add_twig","name":"$self"},{"name":"$self","containerName":"add_twig","line":257,"kind":13},{"kind":13,"line":257,"name":"$twig","containerName":"add_twig"}],"line":251,"name":"add_twig","range":{"end":{"character":9999,"line":258},"start":{"line":251,"character":0}}},{"kind":12,"children":[{"localvar":"my","containerName":"each_twig","definition":"my","name":"$self","line":274,"kind":13},{"kind":13,"line":275,"name":"$self","containerName":"each_twig"}],"line":273,"definition":"sub","name":"each_twig","containerName":"main::","range":{"start":{"line":273,"character":0},"end":{"character":9999,"line":275}}},{"kind":12,"line":287,"children":[{"line":288,"kind":13,"localvar":"my","containerName":"purge_twigs","name":"$self","definition":"my"},{"line":289,"kind":13,"containerName":"purge_twigs","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"purge_twigs($self)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :\n\n\nsub purge_synonyms {\n    my ( $self ) = @_;\n    $self->{ \"_synonyms\" } = [];\n}\n\n\n=head2 Twig management\n\nEach MeSH term belongs to a complex tree like hierachy of terms where\neach term can appear multiple times. The immediately surrounding nodes\nof the tree are modelled in twigs.\n\nSee: L<Bio::Phenotype::MeSH::Twig>.\n\n\n=head2 add_twig\n\n Title   : add_twig\n Usage   : $obj->add_twig( @twigs );\n           or\n           $obj->add_twig( $twig );\n Function: Pushes one or more twig term names [scalars, most likely Strings]\n           into the list of twigs.\n Returns : \n Args    : scalar(s).\n\n\nsub add_twig {\n    my ( $self, @values ) = @_;\n    foreach my $twig (@values) {\n        $self->warn (\"Not a MeSH twig [$twig]\")\n            unless $twig->isa('Bio::Phenotype::MeSH::Twig');\n        $twig->term($self);\n        push( @{ $self->{ \"_twigs\" } }, $twig );\n    }\n    1;\n}\n\n=head2 each_twig\n\n Title   : each_twig()\n Usage   : @gs = $obj->each_twig();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_twig {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_twigs\" } };\n}\n\n=head2 purge_twigs\n\n Usage   : $obj->purge_twig();\n Function: Deletes  the list of twigs associated with this term.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}]},"name":"purge_twigs","range":{"end":{"character":9999,"line":290},"start":{"line":287,"character":0}}},{"kind":12,"children":[{"kind":13,"line":304,"definition":"my","name":"$self","containerName":"each_parent","localvar":"my"},{"kind":12,"line":305,"containerName":"each_parent","name":"parent"},{"name":"$self","containerName":"each_parent","line":305,"kind":13}],"line":303,"definition":"sub","name":"each_parent","containerName":"main::","range":{"start":{"line":303,"character":0},"end":{"line":305,"character":9999}}}],"version":5}