{"vars":[{"line":122,"kind":14,"containerName":"main::","definition":1,"name":"TRUE"},{"containerName":"Bio::Root::IO::Bio::Ontology::OBOEngine::Bio::Ontology::Ontology::Bio::Ontology::OntologyStore::Bio::Ontology::TermFactory::Bio::Annotation::DBLink","name":"strict","line":122,"kind":12},{"kind":14,"line":123,"definition":1,"name":"FALSE","containerName":"main::"},{"name":"base","containerName":"","kind":2,"line":126},{"signature":{"documentation":"1;\n# $Id: dagflat.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO::dagflat\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp, hlapp at gmx.net\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::dagflat - a base class parser for GO flat-file type formats\n\n=head1 SYNOPSIS\n\n  use Bio::OntologyIO;\n\n  # do not use directly -- use via Bio::OntologyIO\n  # e.g., the GO parser is a simple extension of this class\n  my $parser = Bio::OntologyIO->new\n        ( -format       => \"go\",\n     -defs_file    => \"/home/czmasek/GO/GO.defs\",\n          -files        => [\"/home/czmasek/GO/component.ontology\",\n                            \"/home/czmasek/GO/function.ontology\",\n                            \"/home/czmasek/GO/process.ontology\"] );\n\n  my $go_ontology = $parser->next_ontology();\n\n  my $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  my $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n  my $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage  Bio::OntologyIO::dagflat;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Ontology::OBOEngine;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Ontology::TermFactory;\nuse Bio::Annotation::DBLink;\n\nuse constant TRUE         => 1;\nuse constant FALSE        => 0;\n\n\nuse base qw(Bio::OntologyIO);\n\n\n=head2 new\n\n Title   : new\n Usage   : $parser = Bio::OntologyIO->new(\n                             -format => \"go\",\n                             -defs_file => \"/path/to/GO.defs\",\n                             -files => [\"/path/to/component.ontology\",\n                                        \"/path/to/function.ontology\",\n                                        \"/path/to/process.ontology\"] );\n Function: Creates a new dagflat parser.\n Returns : A new dagflat parser object, implementing Bio::OntologyIO.\n Args    : -defs_file  => the name of the file holding the term\n                          definitions\n           -files      => a single ontology flat file holding the\n                          term relationships, or an array ref holding\n                          the file names (for GO, there will usually be\n                          3 files: component.ontology, function.ontology,\n                          process.ontology)\n           -file       => if there is only a single flat file, it may\n                          also be specified via the -file parameter\n           -ontology_name => the name of the ontology; if not specified the\n                          parser will auto-discover it by using the term\n                          that starts with a $, and converting underscores\n                          to spaces\n           -engine     => the Bio::Ontology::OntologyEngineI object\n                          to be reused (will be created otherwise); note\n                          that every Bio::Ontology::OntologyI will\n                          qualify as well since that one inherits from the\n                          former.\n\nSee L<Bio::OntologyIO>.\n\n in reality, we let OntologyIO::new do the instantiation, and override\n _initialize for all initialization work","parameters":[{"label":"$self"},{"label":"%arg"}],"label":"_initialize($self,%arg)"},"detail":"($self,%arg)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_initialize","line":166,"kind":13},{"containerName":"_initialize","name":"%arg","kind":13,"line":166},{"line":168,"kind":13,"localvar":"my","name":"$defs_file_name","definition":"my","containerName":"_initialize"},{"name":"$files","containerName":"_initialize","line":168,"kind":13},{"name":"$defs_url","containerName":"_initialize","line":168,"kind":13},{"kind":13,"line":168,"containerName":"_initialize","name":"$url"},{"line":168,"kind":13,"name":"$name","containerName":"_initialize"},{"kind":13,"line":168,"containerName":"_initialize","name":"$eng"},{"line":169,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":169,"containerName":"_initialize","name":"_rearrange"},{"kind":13,"line":176,"name":"%arg","containerName":"_initialize"},{"name":"$arg","containerName":"_initialize","line":178,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":180},{"containerName":"_initialize","name":"%arg","kind":13,"line":180},{"name":"$self","containerName":"_initialize","line":182,"kind":13},{"name":"_done","containerName":"_initialize","kind":12,"line":182},{"name":"$self","containerName":"_initialize","line":183,"kind":13},{"containerName":"_initialize","name":"_not_first_record","kind":12,"line":183},{"line":184,"kind":13,"name":"$self","containerName":"_initialize"},{"line":184,"kind":12,"name":"_term","containerName":"_initialize"},{"kind":13,"line":185,"containerName":"_initialize","name":"$self"},{"line":188,"kind":13,"containerName":"_initialize","name":"$eng"},{"containerName":"_initialize","name":"new","kind":12,"line":188},{"line":188,"kind":13,"containerName":"_initialize","name":"$eng"},{"containerName":"_initialize","name":"$eng","kind":13,"line":189},{"line":189,"kind":12,"name":"isa","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":190,"kind":13},{"containerName":"_initialize","name":"ontology_name","line":190,"kind":12},{"name":"$eng","containerName":"_initialize","line":190,"kind":13},{"name":"name","containerName":"_initialize","line":190,"kind":12},{"line":191,"kind":13,"containerName":"_initialize","name":"$eng"},{"containerName":"_initialize","name":"$eng","kind":13,"line":191},{"kind":12,"line":191,"name":"engine","containerName":"_initialize"},{"line":191,"kind":13,"name":"$eng","containerName":"_initialize"},{"name":"can","containerName":"_initialize","kind":12,"line":191},{"name":"$self","containerName":"_initialize","kind":13,"line":193},{"kind":12,"line":193,"containerName":"_initialize","name":"_ont_engine"},{"line":193,"kind":13,"containerName":"_initialize","name":"$eng"},{"name":"$defs_file_name","containerName":"_initialize","line":196,"kind":13},{"name":"$defs_url","containerName":"_initialize","line":196,"kind":13},{"kind":13,"line":197,"name":"$self","containerName":"_initialize"},{"kind":12,"line":197,"name":"throw","containerName":"_initialize"},{"kind":13,"line":199,"name":"$defs_file_name","containerName":"_initialize"},{"kind":13,"line":199,"name":"$self","containerName":"_initialize"},{"line":199,"kind":12,"name":"defs_file","containerName":"_initialize"},{"name":"$defs_file_name","containerName":"_initialize","kind":13,"line":199},{"line":200,"kind":13,"name":"$defs_url","containerName":"_initialize"},{"line":200,"kind":13,"containerName":"_initialize","name":"$self"},{"line":200,"kind":12,"name":"defs_url","containerName":"_initialize"},{"name":"$defs_url","containerName":"_initialize","kind":13,"line":200},{"containerName":"_initialize","name":"$files","line":203,"kind":13},{"containerName":"_initialize","name":"$url","kind":13,"line":203},{"containerName":"_initialize","name":"$files","line":204,"kind":13},{"line":205,"kind":13,"containerName":"_initialize","name":"$self"},{"line":205,"kind":13,"name":"$files","containerName":"_initialize"},{"line":205,"kind":13,"name":"$files","containerName":"_initialize"},{"line":205,"kind":13,"containerName":"_initialize","name":"$files"},{"name":"$files","containerName":"_initialize","kind":13,"line":205},{"line":206,"kind":13,"containerName":"_initialize","name":"$url"},{"name":"$self","containerName":"_initialize","line":207,"kind":13},{"line":207,"kind":12,"name":"url","containerName":"_initialize"},{"containerName":"_initialize","name":"$url","kind":13,"line":207},{"containerName":"_initialize","name":"$self","line":211,"kind":13},{"line":211,"kind":12,"name":"ontology_name","containerName":"_initialize"},{"name":"$name","containerName":"_initialize","kind":13,"line":211},{"line":211,"kind":13,"containerName":"_initialize","name":"$name"}],"line":165,"kind":12,"range":{"start":{"character":0,"line":165},"end":{"line":213,"character":9999}},"name":"_initialize"},{"line":180,"kind":12,"containerName":"_initialize","name":"SUPER"},{"name":"FALSE","line":182,"kind":12},{"name":"FALSE","kind":12,"line":183},{"kind":12,"line":188,"containerName":"Ontology::OBOEngine","name":"Bio"},{"line":205,"kind":12,"name":"_flat_files"},{"containerName":"main::","definition":"sub","name":"ontology_name","range":{"end":{"character":9999,"line":232},"start":{"line":227,"character":0}},"kind":12,"line":227,"children":[{"kind":13,"line":228,"containerName":"ontology_name","definition":"my","name":"$self","localvar":"my"},{"containerName":"ontology_name","name":"$self","line":230,"kind":13},{"kind":13,"line":231,"name":"$self","containerName":"ontology_name"}]},{"kind":12,"line":251,"children":[{"line":252,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"parse"},{"containerName":"parse","name":"$self","line":256,"kind":13},{"kind":12,"line":256,"name":"term_factory","containerName":"parse"},{"kind":12,"line":256,"name":"new","containerName":"parse"},{"containerName":"parse","name":"$self","line":258,"kind":13},{"line":258,"kind":12,"containerName":"parse","name":"term_factory"},{"definition":"my","name":"$ont","containerName":"parse","localvar":"my","kind":13,"line":261},{"line":261,"kind":12,"containerName":"parse","name":"new"},{"line":261,"kind":13,"name":"$self","containerName":"parse"},{"containerName":"parse","name":"ontology_name","line":261,"kind":12},{"containerName":"parse","name":"$self","kind":13,"line":262},{"name":"_ont_engine","containerName":"parse","kind":12,"line":262},{"kind":13,"line":265,"containerName":"parse","name":"$term","definition":"my","localvar":"my"},{"line":265,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"_next_term","kind":12,"line":265},{"line":266,"kind":13,"name":"$self","containerName":"parse"},{"containerName":"parse","name":"_add_term","line":266,"kind":12},{"name":"$term","containerName":"parse","line":266,"kind":13},{"name":"$ont","containerName":"parse","kind":13,"line":266},{"containerName":"parse","name":"$self","kind":13,"line":270},{"name":"_part_of_relationship","containerName":"parse","line":270,"kind":12},{"kind":13,"line":270,"name":"$self","containerName":"parse"},{"kind":12,"line":270,"name":"_is_a_relationship","containerName":"parse"},{"name":"$self","containerName":"parse","kind":13,"line":270},{"name":"_related_to_relationship","containerName":"parse","line":270,"kind":12},{"containerName":"parse","name":"ontology","line":271,"kind":12},{"name":"$ont","containerName":"parse","line":271,"kind":13},{"containerName":"parse","name":"$self","line":275,"kind":13},{"line":275,"kind":12,"containerName":"parse","name":"_fh"},{"containerName":"parse","name":"$self","line":276,"kind":13},{"containerName":"parse","name":"url","kind":12,"line":276},{"containerName":"parse","name":"$self","line":277,"kind":13},{"line":277,"kind":12,"name":"url","containerName":"parse"},{"kind":13,"line":279,"containerName":"parse","name":"$url","definition":"my","localvar":"my"},{"name":"$self","containerName":"parse","kind":13,"line":279},{"containerName":"parse","name":"url","line":279,"kind":12},{"kind":13,"line":283,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"_initialize_io","line":283,"kind":12},{"containerName":"parse","name":"$url","kind":13,"line":283},{"line":284,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"_parse_flat_file","kind":12,"line":284},{"name":"$ont","containerName":"parse","kind":13,"line":284},{"kind":13,"line":286,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"close","kind":12,"line":286},{"name":"$self","containerName":"parse","kind":13,"line":288},{"line":288,"kind":12,"name":"_initialize_io","containerName":"parse"},{"kind":13,"line":288,"name":"$self","containerName":"parse"},{"kind":12,"line":288,"containerName":"parse","name":"url"},{"containerName":"parse","name":"$self","kind":13,"line":290},{"line":290,"kind":12,"containerName":"parse","name":"_flat_files"},{"containerName":"parse","name":"$self","kind":13,"line":291},{"line":291,"kind":12,"containerName":"parse","name":"_initialize_io"},{"containerName":"parse","name":"$self","line":291,"kind":13},{"kind":12,"line":291,"name":"_flat_files","containerName":"parse"}],"containerName":"main::","definition":"sub","name":"parse","range":{"end":{"line":292,"character":9999},"start":{"character":0,"line":251}}},{"name":"Bio","containerName":"Ontology::TermFactory","line":256,"kind":12},{"kind":12,"line":261,"name":"Bio","containerName":"Ontology::Ontology"},{"kind":13,"line":295,"containerName":null,"name":"$self"},{"kind":12,"line":295,"name":"_fh","containerName":"main::"},{"containerName":null,"name":"$self","line":296,"kind":13},{"kind":12,"line":296,"name":"_parse_flat_file","containerName":"main::"},{"containerName":null,"name":"$ont","line":296,"kind":13},{"kind":13,"line":298,"name":"$self","containerName":null},{"containerName":"main::","name":"_flat_files","line":298,"kind":12},{"name":"$self","containerName":null,"line":299,"kind":13},{"kind":12,"line":299,"name":"close","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":300},{"containerName":"main::","name":"_initialize_io","line":300,"kind":12},{"kind":13,"line":300,"containerName":null,"name":"$self"},{"line":300,"kind":12,"name":"_flat_files","containerName":"main::"},{"line":305,"kind":13,"name":"$self","containerName":null},{"name":"_add_ontology","containerName":"main::","line":305,"kind":12},{"kind":13,"line":305,"containerName":null,"name":"$ont"},{"kind":13,"line":308,"containerName":null,"name":"$self"},{"kind":12,"line":308,"containerName":"main::","name":"_ont_engine"},{"definition":"sub","name":"next_ontology","containerName":"main::","range":{"start":{"line":325,"character":0},"end":{"line":338,"character":9999}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_ontology","line":326,"kind":13},{"line":329,"kind":13,"containerName":"next_ontology","name":"$self"},{"name":"parse","containerName":"next_ontology","line":329,"kind":12},{"line":329,"kind":13,"containerName":"next_ontology","name":"$self"},{"name":"$self","containerName":"next_ontology","line":331,"kind":13},{"kind":13,"line":332,"definition":"my","name":"$ont","containerName":"next_ontology","localvar":"my"},{"name":"$self","containerName":"next_ontology","line":332,"kind":13},{"containerName":"next_ontology","name":"$ont","line":333,"kind":13},{"definition":"my","name":"$store","containerName":"next_ontology","localvar":"my","kind":13,"line":334},{"name":"new","containerName":"next_ontology","line":334,"kind":12},{"name":"$store","containerName":"next_ontology","kind":13,"line":335},{"line":335,"kind":12,"name":"register_ontology","containerName":"next_ontology"},{"name":"$ont","containerName":"next_ontology","kind":13,"line":335},{"line":336,"kind":13,"name":"$ont","containerName":"next_ontology"}],"line":325},{"containerName":"Ontology::OntologyStore","name":"Bio","line":334,"kind":12},{"range":{"end":{"line":364,"character":9999},"start":{"character":0,"line":352}},"containerName":"main::","definition":"sub","name":"defs_file","line":352,"children":[{"kind":13,"line":353,"definition":"my","name":"$self","containerName":"defs_file","localvar":"my"},{"definition":"my","name":"$f","containerName":"defs_file","localvar":"my","kind":13,"line":356},{"name":"$self","containerName":"defs_file","kind":13,"line":357},{"kind":13,"line":357,"name":"$f","containerName":"defs_file"},{"kind":13,"line":358,"containerName":"defs_file","name":"$self"},{"kind":12,"line":358,"containerName":"defs_file","name":"_defs_io"},{"containerName":"defs_file","name":"close","kind":12,"line":358},{"containerName":"defs_file","name":"$self","kind":13,"line":358},{"kind":12,"line":358,"name":"_defs_io","containerName":"defs_file"},{"kind":13,"line":359,"containerName":"defs_file","name":"$f"},{"kind":13,"line":360,"name":"$self","containerName":"defs_file"},{"containerName":"defs_file","name":"_defs_io","kind":12,"line":360},{"name":"new","containerName":"defs_file","line":360,"kind":12},{"name":"$f","containerName":"defs_file","line":360,"kind":13},{"name":"$self","containerName":"defs_file","line":363,"kind":13}],"kind":12},{"name":"Bio","containerName":"Root::IO","kind":12,"line":360},{"range":{"end":{"character":9999,"line":376},"start":{"line":366,"character":0}},"containerName":"main::","definition":"sub","name":"defs_url","line":366,"children":[{"kind":13,"line":367,"name":"$self","definition":"my","containerName":"defs_url","localvar":"my"},{"localvar":"my","containerName":"defs_url","name":"$val","definition":"my","line":368,"kind":13},{"kind":13,"line":369,"containerName":"defs_url","name":"$val"},{"kind":13,"line":370,"containerName":"defs_url","name":"$self"},{"containerName":"defs_url","name":"$val","kind":13,"line":370},{"line":372,"kind":13,"containerName":"defs_url","name":"$self"},{"line":372,"kind":12,"containerName":"defs_url","name":"_defs_io"},{"containerName":"defs_url","name":"close","kind":12,"line":372},{"kind":13,"line":372,"containerName":"defs_url","name":"$self"},{"containerName":"defs_url","name":"_defs_io","line":372,"kind":12},{"containerName":"defs_url","name":"$self","kind":13,"line":373},{"line":373,"kind":12,"name":"_defs_io","containerName":"defs_url"},{"kind":12,"line":373,"containerName":"defs_url","name":"new"},{"kind":13,"line":373,"name":"$val","containerName":"defs_url"},{"containerName":"defs_url","name":"$self","line":375,"kind":13}],"kind":12},{"containerName":"Root::IO","name":"Bio","line":373,"kind":12},{"range":{"end":{"character":9999,"line":385},"start":{"line":378,"character":0}},"name":"url","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"url","definition":"my","name":"$self","line":379,"kind":13},{"kind":13,"line":380,"name":"$val","definition":"my","containerName":"url","localvar":"my"},{"name":"$val","containerName":"url","kind":13,"line":381},{"kind":13,"line":382,"containerName":"url","name":"$self"},{"line":382,"kind":13,"name":"$val","containerName":"url"},{"name":"$self","containerName":"url","line":384,"kind":13}],"line":378,"kind":12},{"range":{"start":{"character":0,"line":406},"end":{"line":413,"character":9999}},"containerName":"main::","name":"close","definition":"sub","line":406,"children":[{"line":407,"kind":13,"localvar":"my","containerName":"close","definition":"my","name":"$self"},{"line":410,"kind":13,"containerName":"close","name":"$self"},{"containerName":"close","name":"$self","line":412,"kind":13},{"name":"_defs_io","containerName":"close","line":412,"kind":12},{"name":"close","containerName":"close","kind":12,"line":412},{"name":"$self","containerName":"close","kind":13,"line":412},{"line":412,"kind":12,"name":"_defs_io","containerName":"close"}],"kind":12},{"name":"SUPER","containerName":"close","line":410,"kind":12},{"name":"_flat_files","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":431},"end":{"line":436,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"_flat_files","name":"$self","definition":"my","line":432,"kind":13},{"line":434,"kind":13,"name":"$self","containerName":"_flat_files"},{"kind":13,"line":434,"containerName":"_flat_files","name":"$self"},{"kind":13,"line":435,"name":"$self","containerName":"_flat_files"}],"line":431},{"line":434,"kind":12,"name":"_flat_files"},{"name":"_flat_files","line":434,"kind":12},{"name":"_flat_files","line":435,"kind":12},{"line":454,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_defs_io","line":455,"kind":13},{"containerName":"_defs_io","name":"$self","kind":13,"line":457},{"name":"$self","containerName":"_defs_io","line":458,"kind":13}],"kind":12,"range":{"start":{"line":454,"character":0},"end":{"character":9999,"line":459}},"containerName":"main::","definition":"sub","name":"_defs_io"},{"kind":12,"line":461,"children":[{"line":462,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_add_ontology"},{"name":"$self","containerName":"_add_ontology","kind":13,"line":463},{"line":463,"kind":13,"containerName":"_add_ontology","name":"$self"},{"localvar":"my","definition":"my","name":"$ont","containerName":"_add_ontology","line":464,"kind":13},{"kind":13,"line":465,"containerName":"_add_ontology","name":"$self"},{"kind":12,"line":465,"containerName":"_add_ontology","name":"throw"},{"containerName":"_add_ontology","name":"$ont","kind":13,"line":465},{"line":466,"kind":13,"name":"$ont","containerName":"_add_ontology"},{"name":"$ont","containerName":"_add_ontology","line":466,"kind":13},{"kind":12,"line":466,"containerName":"_add_ontology","name":"isa"},{"line":469,"kind":13,"containerName":"_add_ontology","name":"$ont"},{"line":469,"kind":12,"containerName":"_add_ontology","name":"name"},{"name":"$self","containerName":"_add_ontology","line":469,"kind":13},{"line":469,"kind":12,"name":"ontology_name","containerName":"_add_ontology"},{"kind":13,"line":469,"containerName":"_add_ontology","name":"$ont"},{"line":469,"kind":12,"containerName":"_add_ontology","name":"name"},{"name":"$self","containerName":"_add_ontology","line":470,"kind":13},{"containerName":"_add_ontology","name":"$ont","line":470,"kind":13}],"containerName":"main::","definition":"sub","name":"_add_ontology","range":{"start":{"line":461,"character":0},"end":{"line":471,"character":9999}}},{"name":"_add_term","range":{"end":{"character":9999,"line":479},"start":{"character":0,"line":475}},"kind":12,"line":475,"children":[{"line":476,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_add_term"},{"containerName":"_add_term","name":"$term","kind":13,"line":476},{"line":476,"kind":13,"containerName":"_add_term","name":"$ont"},{"name":"$term","containerName":"_add_term","line":477,"kind":13},{"kind":12,"line":477,"containerName":"_add_term","name":"ontology"},{"name":"$ont","containerName":"_add_term","line":477,"kind":13},{"name":"$ont","containerName":"_add_term","kind":13,"line":477},{"kind":13,"line":477,"name":"$term","containerName":"_add_term"},{"containerName":"_add_term","name":"ontology","line":477,"kind":12},{"containerName":"_add_term","name":"$self","kind":13,"line":478},{"containerName":"_add_term","name":"_ont_engine","kind":12,"line":478},{"line":478,"kind":12,"name":"add_term","containerName":"_add_term"},{"containerName":"_add_term","name":"$term","kind":13,"line":478}],"containerName":"main::","definition":"sub","detail":"($self,$term,$ont)","signature":{"label":"_add_term($self,$term,$ont)","documentation":" This simply delegates. See SimpleGOEngine.","parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ont"}]}},{"kind":12,"children":[{"containerName":"_part_of_relationship","definition":"my","name":"$self","localvar":"my","kind":13,"line":485},{"line":487,"kind":13,"name":"$self","containerName":"_part_of_relationship"},{"kind":12,"line":487,"containerName":"_part_of_relationship","name":"_ont_engine"},{"kind":12,"line":487,"containerName":"_part_of_relationship","name":"part_of_relationship"}],"line":484,"name":"_part_of_relationship","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":484},"end":{"character":9999,"line":488}}},{"children":[{"kind":13,"line":494,"definition":"my","name":"$self","containerName":"_is_a_relationship","localvar":"my"},{"line":496,"kind":13,"containerName":"_is_a_relationship","name":"$self"},{"kind":12,"line":496,"containerName":"_is_a_relationship","name":"_ont_engine"},{"containerName":"_is_a_relationship","name":"is_a_relationship","line":496,"kind":12}],"line":493,"kind":12,"range":{"start":{"line":493,"character":0},"end":{"line":497,"character":9999}},"definition":"sub","name":"_is_a_relationship","containerName":"main::"},{"containerName":"main::","name":"_related_to_relationship","definition":"sub","range":{"end":{"line":504,"character":9999},"start":{"character":0,"line":500}},"kind":12,"line":500,"children":[{"line":501,"kind":13,"localvar":"my","containerName":"_related_to_relationship","name":"$self","definition":"my"},{"line":503,"kind":13,"containerName":"_related_to_relationship","name":"$self"},{"containerName":"_related_to_relationship","name":"_ont_engine","line":503,"kind":12},{"name":"related_to_relationship","containerName":"_related_to_relationship","line":503,"kind":12}]},{"range":{"end":{"line":517,"character":9999},"start":{"character":0,"line":509}},"name":"_add_relationship","children":[{"kind":13,"line":510,"definition":"my","name":"$self","containerName":"_add_relationship","localvar":"my"},{"kind":13,"line":510,"name":"$parent","containerName":"_add_relationship"},{"name":"$child","containerName":"_add_relationship","kind":13,"line":510},{"containerName":"_add_relationship","name":"$type","line":510,"kind":13},{"line":510,"kind":13,"name":"$ont","containerName":"_add_relationship"},{"kind":13,"line":514,"name":"$self","containerName":"_add_relationship"},{"kind":12,"line":514,"containerName":"_add_relationship","name":"_ont_engine"},{"line":514,"kind":12,"name":"add_relationship","containerName":"_add_relationship"},{"kind":13,"line":514,"name":"$child","containerName":"_add_relationship"},{"containerName":"_add_relationship","name":"$type","kind":13,"line":514},{"kind":13,"line":514,"containerName":"_add_relationship","name":"$parent"},{"kind":13,"line":514,"name":"$ont","containerName":"_add_relationship"}],"line":509,"kind":12,"signature":{"documentation":" This simply delegates. See SimpleGOEngine","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"},{"label":"$type"},{"label":"$ont"}],"label":"_add_relationship($self,$parent,$child,$type,$ont)"},"detail":"($self,$parent,$child,$type,$ont)","definition":"sub","containerName":"main::"},{"name":"_has_term","definition":"sub","containerName":"main::","range":{"start":{"line":521,"character":0},"end":{"line":525,"character":9999}},"kind":12,"children":[{"kind":13,"line":522,"containerName":"_has_term","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_has_term","kind":13,"line":524},{"containerName":"_has_term","name":"_ont_engine","line":524,"kind":12},{"line":524,"kind":12,"containerName":"_has_term","name":"has_term"}],"line":521},{"name":"_parse_flat_file","definition":"sub","containerName":"main::","range":{"end":{"line":673,"character":9999},"start":{"line":530,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_parse_flat_file","line":531,"kind":13},{"definition":"my","name":"$ont","containerName":"_parse_flat_file","localvar":"my","kind":13,"line":532},{"localvar":"my","name":"@stack","definition":"my","containerName":"_parse_flat_file","line":534,"kind":13},{"kind":13,"line":535,"definition":"my","name":"$prev_spaces","containerName":"_parse_flat_file","localvar":"my"},{"containerName":"_parse_flat_file","definition":"my","name":"$prev_term","localvar":"my","kind":13,"line":536},{"containerName":"_parse_flat_file","definition":"my","name":"$line","localvar":"my","kind":13,"line":538},{"line":538,"kind":13,"containerName":"_parse_flat_file","name":"$self"},{"name":"_readline","containerName":"_parse_flat_file","kind":12,"line":538},{"kind":13,"line":540,"name":"$line","containerName":"_parse_flat_file"},{"localvar":"my","name":"@termspecs","definition":"my","containerName":"_parse_flat_file","line":545,"kind":13},{"containerName":"_parse_flat_file","name":"$line","line":545,"kind":13},{"containerName":"_parse_flat_file","name":"@termspecs","line":547,"kind":13},{"name":"$termspecs","containerName":"_parse_flat_file","line":547,"kind":13},{"kind":13,"line":550,"containerName":"_parse_flat_file","name":"$current_term","definition":"my","localvar":"my"},{"kind":13,"line":550,"name":"$self","containerName":"_parse_flat_file"},{"name":"_get_first_termid","containerName":"_parse_flat_file","line":550,"kind":12},{"name":"$termspecs","containerName":"_parse_flat_file","kind":13,"line":550},{"line":551,"kind":13,"localvar":"my","containerName":"_parse_flat_file","definition":"my","name":"@syns"},{"name":"$self","containerName":"_parse_flat_file","line":551,"kind":13},{"name":"_get_synonyms","containerName":"_parse_flat_file","line":551,"kind":12},{"line":551,"kind":13,"name":"$termspecs","containerName":"_parse_flat_file"},{"localvar":"my","containerName":"_parse_flat_file","name":"@sec_go_ids","definition":"my","line":552,"kind":13},{"name":"$self","containerName":"_parse_flat_file","line":552,"kind":13},{"line":552,"kind":12,"name":"_get_secondary_termids","containerName":"_parse_flat_file"},{"line":552,"kind":13,"name":"$termspecs","containerName":"_parse_flat_file"},{"kind":13,"line":553,"name":"@cross","definition":"my","containerName":"_parse_flat_file","localvar":"my"},{"name":"$self","containerName":"_parse_flat_file","kind":13,"line":553},{"containerName":"_parse_flat_file","name":"_get_db_cross_refs","kind":12,"line":553},{"line":553,"kind":13,"containerName":"_parse_flat_file","name":"$termspecs"},{"localvar":"my","name":"@cross_refs","definition":"my","containerName":"_parse_flat_file","line":554,"kind":13},{"localvar":"my","containerName":"_parse_flat_file","definition":"my","name":"$cross_ref","line":555,"kind":13},{"containerName":"_parse_flat_file","name":"@cross","kind":13,"line":555},{"line":556,"kind":13,"containerName":"_parse_flat_file","name":"$cross_ref"},{"kind":13,"line":556,"containerName":"_parse_flat_file","name":"$current_term"},{"line":557,"kind":13,"containerName":"_parse_flat_file","name":"@cross_refs"},{"containerName":"_parse_flat_file","name":"$cross_ref","kind":13,"line":557},{"kind":13,"line":561,"name":"@termspecs","containerName":"_parse_flat_file"},{"line":562,"kind":13,"localvar":"my","containerName":"_parse_flat_file","definition":"my","name":"@isa_parents"},{"name":"@partof_parents","definition":"my","containerName":"_parse_flat_file","localvar":"my","kind":13,"line":563},{"containerName":"_parse_flat_file","definition":"my","name":"$parent","localvar":"my","kind":13,"line":564},{"line":564,"kind":13,"containerName":"_parse_flat_file","name":"@termspecs"},{"name":"$parent","containerName":"_parse_flat_file","kind":13,"line":565},{"name":"@isa_parents","containerName":"_parse_flat_file","kind":13,"line":566},{"line":566,"kind":13,"name":"$self","containerName":"_parse_flat_file"},{"kind":12,"line":566,"name":"_get_first_termid","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$parent","line":566,"kind":13},{"containerName":"_parse_flat_file","name":"$parent","kind":13,"line":567},{"name":"@partof_parents","containerName":"_parse_flat_file","line":568,"kind":13},{"containerName":"_parse_flat_file","name":"$self","line":568,"kind":13},{"kind":12,"line":568,"containerName":"_parse_flat_file","name":"_get_first_termid"},{"kind":13,"line":568,"containerName":"_parse_flat_file","name":"$parent"},{"name":"$self","containerName":"_parse_flat_file","kind":13,"line":570},{"kind":12,"line":570,"containerName":"_parse_flat_file","name":"warn"},{"line":570,"kind":13,"containerName":"_parse_flat_file","name":"$parent"},{"containerName":"_parse_flat_file","name":"$self","line":574,"kind":13},{"line":574,"kind":12,"containerName":"_parse_flat_file","name":"_has_term"},{"name":"$current_term","containerName":"_parse_flat_file","line":574,"kind":13},{"containerName":"_parse_flat_file","definition":"my","name":"$term","localvar":"my","kind":13,"line":575},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":575},{"kind":12,"line":575,"name":"_create_ont_entry","containerName":"_parse_flat_file"},{"line":575,"kind":13,"name":"$self","containerName":"_parse_flat_file"},{"name":"_get_name","containerName":"_parse_flat_file","line":575,"kind":12},{"containerName":"_parse_flat_file","name":"$line","line":575,"kind":13},{"name":"$current_term","containerName":"_parse_flat_file","kind":13,"line":576},{"containerName":"_parse_flat_file","name":"$current_term","line":577,"kind":13},{"kind":13,"line":578,"containerName":"_parse_flat_file","name":"$self"},{"kind":12,"line":578,"name":"_add_term","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$term","line":578,"kind":13},{"kind":13,"line":578,"containerName":"_parse_flat_file","name":"$ont"},{"kind":13,"line":581,"containerName":"_parse_flat_file","definition":"my","name":"$current_term_object","localvar":"my"},{"kind":13,"line":581,"containerName":"_parse_flat_file","name":"$self"},{"kind":12,"line":581,"name":"_ont_engine","containerName":"_parse_flat_file"},{"line":581,"kind":12,"containerName":"_parse_flat_file","name":"get_terms"},{"line":581,"kind":13,"name":"$current_term","containerName":"_parse_flat_file"},{"localvar":"my","definition":"my","name":"$anno","containerName":"_parse_flat_file","line":582,"kind":13},{"kind":13,"line":582,"name":"$self","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"_to_annotation","line":582,"kind":12},{"containerName":"_parse_flat_file","name":"@cross_refs","kind":13,"line":582},{"kind":13,"line":583,"containerName":"_parse_flat_file","name":"$current_term_object"},{"name":"add_dbxref","containerName":"_parse_flat_file","kind":12,"line":583},{"containerName":"_parse_flat_file","name":"$anno","kind":13,"line":583},{"kind":13,"line":584,"containerName":"_parse_flat_file","name":"$current_term_object"},{"kind":12,"line":584,"name":"add_secondary_id","containerName":"_parse_flat_file"},{"line":584,"kind":13,"name":"@sec_go_ids","containerName":"_parse_flat_file"},{"kind":13,"line":585,"name":"$current_term_object","containerName":"_parse_flat_file"},{"kind":12,"line":585,"name":"add_synonym","containerName":"_parse_flat_file"},{"name":"@syns","containerName":"_parse_flat_file","kind":13,"line":585},{"line":586,"kind":13,"containerName":"_parse_flat_file","name":"$line"},{"name":"$current_term_object","containerName":"_parse_flat_file","kind":13,"line":587},{"containerName":"_parse_flat_file","name":"ontology","line":587,"kind":12},{"containerName":"_parse_flat_file","name":"$ont","line":587,"kind":13},{"containerName":"_parse_flat_file","name":"$parent","definition":"my","localvar":"my","kind":13,"line":589},{"containerName":"_parse_flat_file","name":"@isa_parents","kind":13,"line":589},{"containerName":"_parse_flat_file","name":"$self","line":590,"kind":13},{"name":"_has_term","containerName":"_parse_flat_file","line":590,"kind":12},{"kind":13,"line":590,"name":"$parent","containerName":"_parse_flat_file"},{"localvar":"my","name":"$term","definition":"my","containerName":"_parse_flat_file","line":591,"kind":13},{"kind":13,"line":591,"containerName":"_parse_flat_file","name":"$self"},{"name":"_create_ont_entry","containerName":"_parse_flat_file","line":591,"kind":12},{"containerName":"_parse_flat_file","name":"$self","line":591,"kind":13},{"name":"_get_name","containerName":"_parse_flat_file","kind":12,"line":591},{"name":"$line","containerName":"_parse_flat_file","kind":13,"line":591},{"kind":13,"line":592,"containerName":"_parse_flat_file","name":"$parent"},{"name":"$parent","containerName":"_parse_flat_file","line":593,"kind":13},{"name":"$self","containerName":"_parse_flat_file","line":594,"kind":13},{"name":"_add_term","containerName":"_parse_flat_file","line":594,"kind":12},{"kind":13,"line":594,"name":"$term","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$ont","kind":13,"line":594},{"line":597,"kind":13,"containerName":"_parse_flat_file","name":"$self"},{"kind":12,"line":597,"containerName":"_parse_flat_file","name":"_add_relationship"},{"kind":13,"line":597,"name":"$parent","containerName":"_parse_flat_file"},{"line":598,"kind":13,"name":"$current_term","containerName":"_parse_flat_file"},{"name":"$self","containerName":"_parse_flat_file","line":599,"kind":13},{"kind":12,"line":599,"name":"_is_a_relationship","containerName":"_parse_flat_file"},{"kind":13,"line":600,"containerName":"_parse_flat_file","name":"$ont"},{"containerName":"_parse_flat_file","definition":"my","name":"$parent","localvar":"my","kind":13,"line":603},{"name":"@partof_parents","containerName":"_parse_flat_file","line":603,"kind":13},{"containerName":"_parse_flat_file","name":"$self","line":604,"kind":13},{"line":604,"kind":12,"containerName":"_parse_flat_file","name":"_has_term"},{"line":604,"kind":13,"containerName":"_parse_flat_file","name":"$parent"},{"containerName":"_parse_flat_file","name":"$term","definition":"my","localvar":"my","kind":13,"line":605},{"name":"$self","containerName":"_parse_flat_file","line":605,"kind":13},{"name":"_create_ont_entry","containerName":"_parse_flat_file","kind":12,"line":605},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":605},{"containerName":"_parse_flat_file","name":"_get_name","line":605,"kind":12},{"kind":13,"line":605,"name":"$line","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$parent","kind":13,"line":606},{"kind":13,"line":607,"name":"$parent","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","line":608,"kind":13},{"containerName":"_parse_flat_file","name":"_add_term","kind":12,"line":608},{"line":608,"kind":13,"name":"$term","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$ont","kind":13,"line":608},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":611},{"kind":12,"line":611,"name":"_add_relationship","containerName":"_parse_flat_file"},{"kind":13,"line":611,"name":"$parent","containerName":"_parse_flat_file"},{"kind":13,"line":612,"name":"$current_term","containerName":"_parse_flat_file"},{"name":"$self","containerName":"_parse_flat_file","kind":13,"line":613},{"containerName":"_parse_flat_file","name":"_part_of_relationship","line":613,"kind":12},{"line":614,"kind":13,"name":"$ont","containerName":"_parse_flat_file"},{"kind":13,"line":617,"containerName":"_parse_flat_file","name":"$current_spaces","definition":"my","localvar":"my"},{"kind":13,"line":617,"name":"$self","containerName":"_parse_flat_file"},{"kind":12,"line":617,"name":"_count_spaces","containerName":"_parse_flat_file"},{"line":617,"kind":13,"name":"$line","containerName":"_parse_flat_file"},{"line":619,"kind":13,"name":"$current_spaces","containerName":"_parse_flat_file"},{"name":"$prev_spaces","containerName":"_parse_flat_file","line":619,"kind":13},{"name":"$current_spaces","containerName":"_parse_flat_file","line":621,"kind":13},{"line":621,"kind":13,"containerName":"_parse_flat_file","name":"$prev_spaces"},{"containerName":"_parse_flat_file","name":"@stack","line":622,"kind":13},{"kind":13,"line":622,"name":"$prev_term","containerName":"_parse_flat_file"},{"kind":13,"line":623,"name":"$current_spaces","containerName":"_parse_flat_file"},{"kind":13,"line":623,"name":"$prev_spaces","containerName":"_parse_flat_file"},{"name":"$n","definition":"my","containerName":"_parse_flat_file","localvar":"my","kind":13,"line":624},{"name":"$prev_spaces","containerName":"_parse_flat_file","line":624,"kind":13},{"line":624,"kind":13,"name":"$current_spaces","containerName":"_parse_flat_file"},{"line":625,"kind":13,"localvar":"my","containerName":"_parse_flat_file","name":"$i","definition":"my"},{"line":625,"kind":13,"containerName":"_parse_flat_file","name":"$i"},{"containerName":"_parse_flat_file","name":"$n","line":625,"kind":13},{"containerName":"_parse_flat_file","name":"$i","line":625,"kind":13},{"name":"@stack","containerName":"_parse_flat_file","kind":13,"line":626},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":629},{"line":629,"kind":12,"name":"throw","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":629},{"line":629,"kind":12,"containerName":"_parse_flat_file","name":"file"},{"kind":13,"line":633,"containerName":"_parse_flat_file","name":"$parent","definition":"my","localvar":"my"},{"line":633,"kind":13,"name":"$stack","containerName":"_parse_flat_file"},{"line":633,"kind":13,"name":"@stack","containerName":"_parse_flat_file"},{"kind":13,"line":637,"containerName":"_parse_flat_file","name":"$line"},{"name":"$line","containerName":"_parse_flat_file","line":639,"kind":13},{"line":640,"kind":13,"containerName":"_parse_flat_file","name":"$self"},{"containerName":"_parse_flat_file","name":"throw","kind":12,"line":640},{"kind":13,"line":640,"containerName":"_parse_flat_file","name":"$self"},{"containerName":"_parse_flat_file","name":"file","line":640,"kind":12},{"localvar":"my","name":"$relstring","definition":"my","containerName":"_parse_flat_file","line":643,"kind":13},{"line":643,"kind":13,"name":"$line","containerName":"_parse_flat_file"},{"kind":13,"line":645,"definition":"my","name":"$reltype","containerName":"_parse_flat_file","localvar":"my"},{"containerName":"_parse_flat_file","name":"$relstring","kind":13,"line":647},{"containerName":"_parse_flat_file","name":"$reltype","line":648,"kind":13},{"kind":13,"line":648,"containerName":"_parse_flat_file","name":"$self"},{"line":648,"kind":12,"containerName":"_parse_flat_file","name":"_part_of_relationship"},{"line":649,"kind":13,"name":"$relstring","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$reltype","line":650,"kind":13},{"line":650,"kind":13,"containerName":"_parse_flat_file","name":"$self"},{"name":"_is_a_relationship","containerName":"_parse_flat_file","line":650,"kind":12},{"line":651,"kind":13,"name":"$relstring","containerName":"_parse_flat_file"},{"line":652,"kind":13,"name":"$reltype","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":652},{"containerName":"_parse_flat_file","name":"_related_to_relationship","kind":12,"line":652},{"line":654,"kind":13,"name":"$relstring","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","line":655,"kind":13},{"kind":12,"line":655,"name":"_ont_engine","containerName":"_parse_flat_file"},{"kind":12,"line":655,"name":"get_relationship_type","containerName":"_parse_flat_file"},{"kind":13,"line":655,"containerName":"_parse_flat_file","name":"$relstring"},{"name":"$reltype","containerName":"_parse_flat_file","line":656,"kind":13},{"containerName":"_parse_flat_file","name":"$self","line":656,"kind":13},{"line":656,"kind":12,"containerName":"_parse_flat_file","name":"_ont_engine"},{"containerName":"_parse_flat_file","name":"get_relationship_type","line":656,"kind":12},{"kind":13,"line":656,"name":"$relstring","containerName":"_parse_flat_file"},{"name":"$self","containerName":"_parse_flat_file","line":658,"kind":13},{"kind":12,"line":658,"name":"_ont_engine","containerName":"_parse_flat_file"},{"name":"add_relationship_type","containerName":"_parse_flat_file","line":658,"kind":12},{"name":"$relstring","containerName":"_parse_flat_file","kind":13,"line":658},{"kind":13,"line":658,"name":"$ont","containerName":"_parse_flat_file"},{"line":659,"kind":13,"name":"$reltype","containerName":"_parse_flat_file"},{"name":"$self","containerName":"_parse_flat_file","line":659,"kind":13},{"line":659,"kind":12,"containerName":"_parse_flat_file","name":"_ont_engine"},{"containerName":"_parse_flat_file","name":"get_relationship_type","kind":12,"line":659},{"containerName":"_parse_flat_file","name":"$relstring","kind":13,"line":659},{"containerName":"_parse_flat_file","name":"$self","line":666,"kind":13},{"name":"_add_relationship","containerName":"_parse_flat_file","kind":12,"line":666},{"kind":13,"line":666,"containerName":"_parse_flat_file","name":"$parent"},{"name":"$current_term","containerName":"_parse_flat_file","kind":13,"line":666},{"line":666,"kind":13,"name":"$reltype","containerName":"_parse_flat_file"},{"line":666,"kind":13,"containerName":"_parse_flat_file","name":"$ont"},{"containerName":"_parse_flat_file","name":"$prev_spaces","line":669,"kind":13},{"name":"$current_spaces","containerName":"_parse_flat_file","kind":13,"line":669},{"containerName":"_parse_flat_file","name":"$prev_term","line":670,"kind":13},{"containerName":"_parse_flat_file","name":"$current_term","kind":13,"line":670},{"kind":13,"line":672,"name":"$ont","containerName":"_parse_flat_file"}],"line":530},{"definition":"sub","containerName":"main::","signature":{"label":"_get_first_termid($self,$line)","documentation":" Parses the 1st term id number out of line.","parameters":[{"label":"$self"},{"label":"$line"}]},"detail":"($self,$line)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_get_first_termid","localvar":"my","kind":13,"line":679},{"containerName":"_get_first_termid","name":"$line","kind":13,"line":679},{"line":680,"kind":13,"name":"$line","containerName":"_get_first_termid"},{"line":685,"kind":13,"containerName":"_get_first_termid","name":"$self"},{"containerName":"_get_first_termid","name":"throw","line":685,"kind":12}],"line":678,"name":"_get_first_termid","range":{"start":{"character":0,"line":678},"end":{"character":9999,"line":688}}},{"range":{"end":{"line":715,"character":9999},"start":{"line":693,"character":0}},"name":"_get_name","detail":"($self,$line,$termid)","signature":{"documentation":" Parses the name out of line.","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$termid"}],"label":"_get_name($self,$line,$termid)"},"containerName":"main::","definition":"sub","line":693,"children":[{"line":694,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_name"},{"line":694,"kind":13,"name":"$line","containerName":"_get_name"},{"line":694,"kind":13,"name":"$termid","containerName":"_get_name"},{"kind":13,"line":696,"containerName":"_get_name","name":"$line"},{"line":697,"kind":13,"localvar":"my","containerName":"_get_name","definition":"my","name":"$name"},{"containerName":"_get_name","name":"$name","line":699,"kind":13},{"line":700,"kind":13,"containerName":"_get_name","name":"$name"},{"line":701,"kind":13,"name":"$name","containerName":"_get_name"},{"containerName":"_get_name","name":"$name","kind":13,"line":704},{"line":705,"kind":13,"name":"$name","containerName":"_get_name"},{"kind":13,"line":705,"containerName":"_get_name","name":"$name"},{"name":"$self","containerName":"_get_name","line":707,"kind":13},{"name":"ontology_name","containerName":"_get_name","line":707,"kind":12},{"name":"$name","containerName":"_get_name","line":707,"kind":13},{"name":"$self","containerName":"_get_name","kind":13,"line":708},{"containerName":"_get_name","name":"ontology_name","kind":12,"line":708},{"containerName":"_get_name","name":"$name","line":710,"kind":13}],"kind":12},{"line":719,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_get_synonyms","line":720,"kind":13},{"name":"$line","containerName":"_get_synonyms","line":720,"kind":13},{"localvar":"my","containerName":"_get_synonyms","definition":"my","name":"@synonyms","line":722,"kind":13},{"kind":13,"line":724,"containerName":"_get_synonyms","name":"$line"},{"localvar":"my","name":"$syn","definition":"my","containerName":"_get_synonyms","line":725,"kind":13},{"containerName":"_get_synonyms","name":"$syn","line":726,"kind":13},{"kind":13,"line":727,"containerName":"_get_synonyms","name":"$syn"},{"line":728,"kind":13,"containerName":"_get_synonyms","name":"@synonyms"},{"name":"$syn","containerName":"_get_synonyms","kind":13,"line":728},{"containerName":"_get_synonyms","name":"@synonyms","line":730,"kind":13}],"kind":12,"detail":"($self,$line)","signature":{"documentation":" Parses the synonyms out of line.","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_get_synonyms($self,$line)"},"containerName":"main::","definition":"sub","range":{"end":{"line":732,"character":9999},"start":{"line":719,"character":0}},"name":"_get_synonyms"},{"kind":12,"children":[{"kind":13,"line":738,"definition":"my","name":"$self","containerName":"_get_db_cross_refs","localvar":"my"},{"line":738,"kind":13,"containerName":"_get_db_cross_refs","name":"$line"},{"definition":"my","name":"@refs","containerName":"_get_db_cross_refs","localvar":"my","kind":13,"line":740},{"name":"$line","containerName":"_get_db_cross_refs","kind":13,"line":742},{"containerName":"_get_db_cross_refs","name":"$ref","definition":"my","localvar":"my","kind":13,"line":743},{"kind":13,"line":744,"containerName":"_get_db_cross_refs","name":"$ref"},{"kind":13,"line":744,"containerName":"_get_db_cross_refs","name":"$ref"},{"kind":13,"line":747,"name":"$ref","containerName":"_get_db_cross_refs"},{"name":"$ref","containerName":"_get_db_cross_refs","kind":13,"line":748},{"name":"$ref","containerName":"_get_db_cross_refs","kind":13,"line":750},{"containerName":"_get_db_cross_refs","name":"$self","kind":13,"line":750},{"containerName":"_get_db_cross_refs","name":"unescape","kind":12,"line":750},{"kind":13,"line":750,"containerName":"_get_db_cross_refs","name":"$ref"},{"line":752,"kind":13,"containerName":"_get_db_cross_refs","name":"@refs"},{"name":"$ref","containerName":"_get_db_cross_refs","line":752,"kind":13},{"line":752,"kind":13,"name":"$ref","containerName":"_get_db_cross_refs"},{"containerName":"_get_db_cross_refs","name":"@refs","kind":13,"line":754}],"line":737,"definition":"sub","containerName":"main::","signature":{"label":"_get_db_cross_refs($self,$line)","documentation":" Parses the db cross refs out of line.","parameters":[{"label":"$self"},{"label":"$line"}]},"detail":"($self,$line)","name":"_get_db_cross_refs","range":{"end":{"character":9999,"line":756},"start":{"character":0,"line":737}}},{"signature":{"parameters":[{"label":"$self"},{"label":"$line"}],"documentation":" Parses the secondary go ids out of a line","label":"_get_secondary_termids($self,$line)"},"detail":"($self,$line)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":761,"containerName":"_get_secondary_termids","name":"$self","definition":"my","localvar":"my"},{"name":"$line","containerName":"_get_secondary_termids","line":761,"kind":13},{"name":"@secs","definition":"my","containerName":"_get_secondary_termids","localvar":"my","kind":13,"line":762},{"line":765,"kind":13,"name":"$line","containerName":"_get_secondary_termids"},{"kind":13,"line":766,"definition":"my","name":"$sec","containerName":"_get_secondary_termids","localvar":"my"},{"containerName":"_get_secondary_termids","name":"@secs","kind":13,"line":767},{"line":767,"kind":13,"name":"$sec","containerName":"_get_secondary_termids"},{"name":"@secs","containerName":"_get_secondary_termids","line":769,"kind":13}],"line":760,"kind":12,"range":{"start":{"character":0,"line":760},"end":{"line":771,"character":9999}},"name":"_get_secondary_termids"},{"range":{"end":{"character":9999,"line":784},"start":{"line":775,"character":0}},"name":"_count_spaces","children":[{"kind":13,"line":776,"definition":"my","name":"$self","containerName":"_count_spaces","localvar":"my"},{"line":776,"kind":13,"name":"$line","containerName":"_count_spaces"},{"containerName":"_count_spaces","name":"$line","line":778,"kind":13}],"line":775,"kind":12,"signature":{"documentation":" Counts the spaces at the beginning of a line in the relationships files","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_count_spaces($self,$line)"},"detail":"($self,$line)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":788,"character":0},"end":{"line":831,"character":9999}},"name":"_next_term","signature":{"label":"_next_term($self)","parameters":[{"label":"$self"}],"documentation":" \"next\" method for parsing the defintions file"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":789,"containerName":"_next_term","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":791,"name":"$self","containerName":"_next_term"},{"containerName":"_next_term","name":"_done","line":791,"kind":12},{"kind":13,"line":791,"containerName":"_next_term","name":"$self"},{"kind":12,"line":791,"name":"_defs_io","containerName":"_next_term"},{"definition":"my","name":"$line","containerName":"_next_term","localvar":"my","kind":13,"line":795},{"line":796,"kind":13,"localvar":"my","containerName":"_next_term","name":"$termid","definition":"my"},{"line":797,"kind":13,"localvar":"my","name":"$next_term","definition":"my","containerName":"_next_term"},{"containerName":"_next_term","name":"$self","kind":13,"line":797},{"name":"_term","containerName":"_next_term","line":797,"kind":12},{"line":798,"kind":13,"localvar":"my","containerName":"_next_term","definition":"my","name":"$def"},{"name":"$comment","definition":"my","containerName":"_next_term","localvar":"my","kind":13,"line":799},{"containerName":"_next_term","definition":"my","name":"@def_refs","localvar":"my","kind":13,"line":800},{"line":801,"kind":13,"localvar":"my","containerName":"_next_term","definition":"my","name":"$isobsolete"},{"kind":13,"line":803,"containerName":"_next_term","name":"$line"},{"line":803,"kind":13,"containerName":"_next_term","name":"$self"},{"containerName":"_next_term","name":"_defs_io","kind":12,"line":803},{"line":803,"kind":12,"containerName":"_next_term","name":"_readline"},{"name":"$line","containerName":"_next_term","line":804,"kind":13},{"containerName":"_next_term","name":"$line","line":805,"kind":13},{"name":"$line","containerName":"_next_term","kind":13,"line":808},{"line":809,"kind":13,"containerName":"_next_term","name":"$self"},{"containerName":"_next_term","name":"_term","line":809,"kind":12},{"line":810,"kind":13,"name":"$self","containerName":"_next_term"},{"name":"_not_first_record","containerName":"_next_term","line":810,"kind":12},{"kind":13,"line":811,"name":"$next_term","containerName":"_next_term"},{"name":"$self","containerName":"_next_term","line":812,"kind":13},{"name":"_not_first_record","containerName":"_next_term","line":812,"kind":12},{"kind":13,"line":814,"name":"$line","containerName":"_next_term"},{"line":815,"kind":13,"name":"$termid","containerName":"_next_term"},{"name":"$line","containerName":"_next_term","kind":13,"line":817},{"containerName":"_next_term","name":"$def","line":818,"kind":13},{"containerName":"_next_term","name":"$self","line":818,"kind":13},{"line":818,"kind":12,"containerName":"_next_term","name":"unescape"},{"name":"$isobsolete","containerName":"_next_term","kind":13,"line":819},{"containerName":"_next_term","name":"$def","line":819,"kind":13},{"line":821,"kind":13,"containerName":"_next_term","name":"$line"},{"containerName":"_next_term","name":"@def_refs","line":822,"kind":13},{"line":822,"kind":13,"containerName":"_next_term","name":"$self"},{"kind":12,"line":822,"name":"unescape","containerName":"_next_term"},{"name":"$line","containerName":"_next_term","line":824,"kind":13},{"name":"$comment","containerName":"_next_term","kind":13,"line":825},{"containerName":"_next_term","name":"$self","kind":13,"line":825},{"containerName":"_next_term","name":"unescape","line":825,"kind":12},{"containerName":"_next_term","name":"$self","line":828,"kind":13},{"name":"_done","containerName":"_next_term","kind":12,"line":828},{"name":"$line","containerName":"_next_term","kind":13,"line":828},{"name":"$self","containerName":"_next_term","line":829,"kind":13},{"name":"_create_ont_entry","containerName":"_next_term","kind":12,"line":829},{"line":829,"kind":13,"name":"$next_term","containerName":"_next_term"},{"name":"$termid","containerName":"_next_term","line":829,"kind":13},{"name":"$def","containerName":"_next_term","kind":13,"line":829},{"kind":13,"line":830,"name":"$comment","containerName":"_next_term"},{"kind":13,"line":830,"containerName":"_next_term","name":"@def_refs"},{"containerName":"_next_term","name":"$isobsolete","kind":13,"line":830}],"line":788,"kind":12},{"kind":12,"line":791,"name":"TRUE"},{"name":"TRUE","line":812,"kind":12},{"kind":12,"line":828,"name":"TRUE"},{"name":"_ont_engine","range":{"start":{"line":836,"character":0},"end":{"line":844,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds the GO engine to be parsed into","label":"_ont_engine($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"_ont_engine","localvar":"my","kind":13,"line":837},{"containerName":"_ont_engine","name":"$value","line":837,"kind":13},{"name":"$value","containerName":"_ont_engine","line":839,"kind":13},{"kind":13,"line":840,"name":"$self","containerName":"_ont_engine"},{"line":840,"kind":13,"containerName":"_ont_engine","name":"$value"},{"kind":13,"line":843,"containerName":"_ont_engine","name":"$self"}],"line":836},{"definition":"sub","containerName":"main::","signature":{"label":"_create_ont_entry($self,$name,$termid,$def,$cmt,$dbxrefs,$obsolete)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$termid"},{"label":"$def"},{"label":"$cmt"},{"label":"$dbxrefs"},{"label":"$obsolete"}],"documentation":" Used to create ontology terms.\n Arguments: name, id"},"detail":"($self,$name,$termid,$def,$cmt,$dbxrefs,$obsolete)","kind":12,"children":[{"localvar":"my","containerName":"_create_ont_entry","name":"$self","definition":"my","line":850,"kind":13},{"name":"$name","containerName":"_create_ont_entry","kind":13,"line":850},{"kind":13,"line":850,"containerName":"_create_ont_entry","name":"$termid"},{"kind":13,"line":850,"name":"$def","containerName":"_create_ont_entry"},{"kind":13,"line":850,"containerName":"_create_ont_entry","name":"$cmt"},{"containerName":"_create_ont_entry","name":"$dbxrefs","line":850,"kind":13},{"kind":13,"line":850,"containerName":"_create_ont_entry","name":"$obsolete"},{"kind":13,"line":852,"name":"$obsolete","containerName":"_create_ont_entry"},{"containerName":"_create_ont_entry","name":"$name","line":852,"kind":13},{"kind":13,"line":853,"name":"$obsolete","containerName":"_create_ont_entry"},{"localvar":"my","containerName":"_create_ont_entry","definition":"my","name":"$anno","line":855,"kind":13},{"kind":13,"line":855,"containerName":"_create_ont_entry","name":"$self"},{"line":855,"kind":12,"containerName":"_create_ont_entry","name":"_to_annotation"},{"kind":13,"line":855,"containerName":"_create_ont_entry","name":"$dbxrefs"},{"kind":13,"line":856,"definition":"my","name":"$term","containerName":"_create_ont_entry","localvar":"my"},{"containerName":"_create_ont_entry","name":"$self","kind":13,"line":856},{"name":"term_factory","containerName":"_create_ont_entry","kind":12,"line":856},{"line":856,"kind":12,"name":"create_object","containerName":"_create_ont_entry"},{"name":"$name","containerName":"_create_ont_entry","line":856,"kind":13},{"line":857,"kind":13,"containerName":"_create_ont_entry","name":"$termid"},{"containerName":"_create_ont_entry","name":"$def","kind":13,"line":858},{"name":"$cmt","containerName":"_create_ont_entry","kind":13,"line":859},{"line":860,"kind":13,"name":"$anno","containerName":"_create_ont_entry"},{"line":861,"kind":13,"name":"$obsolete","containerName":"_create_ont_entry"},{"kind":13,"line":863,"name":"$term","containerName":"_create_ont_entry"}],"line":849,"name":"_create_ont_entry","range":{"end":{"line":864,"character":9999},"start":{"line":849,"character":0}}},{"name":"_not_first_record","range":{"start":{"line":869,"character":0},"end":{"character":9999,"line":877}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds whether first record or not","label":"_not_first_record($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"_not_first_record","localvar":"my","kind":13,"line":870},{"line":870,"kind":13,"containerName":"_not_first_record","name":"$value"},{"line":872,"kind":13,"name":"$value","containerName":"_not_first_record"},{"kind":13,"line":873,"containerName":"_not_first_record","name":"$self"},{"line":873,"kind":13,"containerName":"_not_first_record","name":"$value"},{"line":876,"kind":13,"name":"$self","containerName":"_not_first_record"}],"line":869},{"name":"_done","range":{"start":{"line":882,"character":0},"end":{"line":890,"character":9999}},"kind":12,"children":[{"kind":13,"line":883,"containerName":"_done","definition":"my","name":"$self","localvar":"my"},{"line":883,"kind":13,"name":"$value","containerName":"_done"},{"name":"$value","containerName":"_done","kind":13,"line":885},{"line":886,"kind":13,"containerName":"_done","name":"$self"},{"containerName":"_done","name":"$value","line":886,"kind":13},{"containerName":"_done","name":"$self","kind":13,"line":889}],"line":882,"definition":"sub","containerName":"main::","signature":{"documentation":" Holds whether done or not","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_done($self,$value)"},"detail":"($self,$value)"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds a term.","label":"_term($self,$value)"},"kind":12,"line":894,"children":[{"line":895,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_term"},{"line":895,"kind":13,"name":"$value","containerName":"_term"},{"line":897,"kind":13,"containerName":"_term","name":"$value"},{"containerName":"_term","name":"$self","line":898,"kind":13},{"name":"$value","containerName":"_term","kind":13,"line":898},{"containerName":"_term","name":"$self","line":901,"kind":13}],"name":"_term","range":{"start":{"line":894,"character":0},"end":{"character":9999,"line":902}}},{"name":"_to_annotation","range":{"end":{"line":909,"character":9999},"start":{"character":0,"line":905}},"definition":"sub","containerName":"main::","signature":{"label":"_to_annotation($self,$links)","documentation":" convert simple strings to Bio::Annotation::DBLinks","parameters":[{"label":"$self"},{"label":"$links"}]},"detail":"($self,$links)","kind":12,"children":[{"kind":13,"line":906,"name":"$self","definition":"my","containerName":"_to_annotation","localvar":"my"},{"kind":13,"line":906,"name":"$links","containerName":"_to_annotation"},{"kind":13,"line":907,"containerName":"_to_annotation","name":"$links"},{"line":908,"kind":13,"localvar":"my","containerName":"_to_annotation","definition":"my","name":"@dbxrefs"},{"line":909,"kind":13,"localvar":"my","definition":"my","name":"$string","containerName":"_to_annotation"},{"containerName":"_to_annotation","name":"$links","kind":13,"line":909}],"line":905},{"line":910,"kind":13,"localvar":"my","definition":"my","name":"$db","containerName":null},{"containerName":null,"name":"$id","kind":13,"line":910},{"line":910,"kind":13,"containerName":null,"name":"$string"},{"kind":13,"line":911,"containerName":null,"name":"@dbxrefs"},{"name":"Bio","containerName":"Annotation::DBLink","kind":12,"line":911},{"containerName":"main::","name":"new","kind":12,"line":911},{"kind":13,"line":911,"name":"$db","containerName":null},{"kind":13,"line":911,"containerName":null,"name":"$id"},{"kind":13,"line":913,"containerName":null,"name":"@dbxrefs"}],"version":5}