{"version":5,"vars":[{"line":94,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"line":159,"character":9999},"start":{"character":0,"line":120}},"name":"_initialize","definition":"sub","containerName":"main::","children":[{"kind":13,"line":121,"containerName":"_initialize","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":123},{"localvar":"my","containerName":"_initialize","definition":"my","name":"$eng","line":125,"kind":13},{"kind":13,"line":125,"containerName":"_initialize","name":"$eng_type"},{"containerName":"_initialize","name":"$name","line":125,"kind":13},{"kind":13,"line":126,"containerName":"_initialize","name":"$self"},{"kind":12,"line":126,"name":"_rearrange","containerName":"_initialize"},{"kind":13,"line":131,"definition":"my","name":"$ip_h","containerName":"_initialize","localvar":"my"},{"name":"new","containerName":"_initialize","line":131,"kind":12},{"name":"$name","containerName":"_initialize","line":132,"kind":13},{"containerName":"_initialize","name":"$eng","line":134,"kind":13},{"containerName":"_initialize","name":"$eng_type","line":135,"kind":13},{"kind":13,"line":135,"containerName":"_initialize","name":"$eng_type"},{"kind":13,"line":136,"containerName":"_initialize","name":"$eng_type"},{"line":137,"kind":13,"name":"$eng","containerName":"_initialize"},{"line":137,"kind":12,"containerName":"_initialize","name":"new"},{"kind":13,"line":139,"name":"$self","containerName":"_initialize"},{"kind":12,"line":139,"containerName":"_initialize","name":"throw"},{"name":"$eng","containerName":"_initialize","line":143,"kind":13},{"name":"isa","containerName":"_initialize","line":143,"kind":12},{"name":"$ip_h","containerName":"_initialize","line":144,"kind":13},{"name":"ontology","containerName":"_initialize","line":144,"kind":12},{"name":"$eng","containerName":"_initialize","kind":13,"line":144},{"containerName":"_initialize","name":"$eng","kind":13,"line":145},{"containerName":"_initialize","name":"$eng","kind":13,"line":145},{"containerName":"_initialize","name":"engine","kind":12,"line":145},{"containerName":"_initialize","name":"$eng","line":145,"kind":13},{"line":145,"kind":12,"containerName":"_initialize","name":"can"},{"name":"$self","containerName":"_initialize","kind":13,"line":147},{"name":"$eng","containerName":"_initialize","kind":13,"line":147},{"name":"$ip_h","containerName":"_initialize","line":148,"kind":13},{"kind":12,"line":148,"containerName":"_initialize","name":"ontology_engine"},{"name":"$eng","containerName":"_initialize","line":148,"kind":13},{"kind":13,"line":150,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"new","kind":12,"line":150},{"kind":13,"line":150,"containerName":"_initialize","name":"$ip_h"},{"kind":13,"line":151,"name":"$self","containerName":"_initialize"},{"kind":13,"line":151,"containerName":"_initialize","name":"$ip_h"},{"containerName":"_initialize","name":"$self","kind":13,"line":154},{"kind":12,"line":154,"name":"term_factory","containerName":"_initialize"},{"line":154,"kind":12,"name":"new","containerName":"_initialize"},{"kind":13,"line":156,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"term_factory","line":156,"kind":12},{"containerName":"_initialize","name":"$ip_h","line":157,"kind":13},{"containerName":"_initialize","name":"term_factory","kind":12,"line":157},{"line":157,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":157,"containerName":"_initialize","name":"term_factory"}],"line":120,"kind":12},{"line":123,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":131,"kind":12,"name":"Bio","containerName":"OntologyIO::Handlers::InterProHandler"},{"containerName":"Ontology::SimpleOntologyEngine","name":"Bio","line":137,"kind":12},{"name":"_ontology_engine","line":147,"kind":12},{"kind":12,"line":150,"name":"_parser"},{"line":150,"kind":12,"containerName":"Parser::PerlSAX","name":"XML"},{"kind":12,"line":150,"name":"Handler"},{"line":151,"kind":12,"name":"_interpro_handler"},{"line":154,"kind":12,"containerName":"Ontology::TermFactory","name":"Bio"},{"range":{"end":{"character":9999,"line":189},"start":{"line":172,"character":0}},"name":"parse","definition":"sub","containerName":"main::","children":[{"line":173,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"parse"},{"kind":13,"line":175,"containerName":"parse","name":"$ret","definition":"my","localvar":"my"},{"containerName":"parse","name":"$self","line":176,"kind":13},{"kind":12,"line":176,"name":"file","containerName":"parse"},{"line":177,"kind":13,"name":"$ret","containerName":"parse"},{"line":177,"kind":13,"containerName":"parse","name":"$self"},{"containerName":"parse","name":"parse","line":177,"kind":12},{"line":178,"kind":13,"containerName":"parse","name":"$self"},{"name":"file","containerName":"parse","kind":12,"line":178},{"name":"$self","containerName":"parse","kind":13,"line":179},{"line":179,"kind":12,"name":"_fh","containerName":"parse"},{"containerName":"parse","name":"$ret","kind":13,"line":180},{"name":"$self","containerName":"parse","kind":13,"line":180},{"containerName":"parse","name":"parse","kind":12,"line":180},{"name":"$self","containerName":"parse","kind":13,"line":181},{"containerName":"parse","name":"_fh","kind":12,"line":181},{"kind":13,"line":183,"containerName":"parse","name":"$ret"},{"containerName":"parse","name":"$self","kind":13,"line":184},{"name":"throw","containerName":"parse","kind":12,"line":184},{"kind":13,"line":187,"containerName":"parse","name":"$self"},{"line":187,"kind":12,"name":"_is_parsed","containerName":"parse"},{"containerName":"parse","name":"$ret","line":188,"kind":13}],"line":172,"kind":12},{"name":"_parser","line":177,"kind":12},{"name":"Source","kind":12,"line":177},{"kind":12,"line":178,"name":"SystemId"},{"line":180,"kind":12,"name":"_parser"},{"name":"Source","kind":12,"line":180},{"kind":12,"line":181,"name":"ByteStream"},{"containerName":"main::","name":"next_ontology","definition":"sub","range":{"start":{"line":210,"character":0},"end":{"line":221,"character":9999}},"kind":12,"line":210,"children":[{"containerName":"next_ontology","definition":"my","name":"$self","localvar":"my","kind":13,"line":211},{"name":"$self","containerName":"next_ontology","kind":13,"line":213},{"kind":12,"line":213,"name":"parse","containerName":"next_ontology"},{"line":213,"kind":13,"name":"$self","containerName":"next_ontology"},{"name":"_is_parsed","containerName":"next_ontology","line":213,"kind":12},{"name":"$self","containerName":"next_ontology","kind":13,"line":215},{"line":216,"kind":13,"localvar":"my","name":"$ont","definition":"my","containerName":"next_ontology"},{"line":216,"kind":13,"containerName":"next_ontology","name":"$self"},{"name":"ontology","containerName":"next_ontology","line":216,"kind":12},{"containerName":"next_ontology","name":"$self","line":217,"kind":13},{"name":"$ont","containerName":"next_ontology","line":218,"kind":13}]},{"line":216,"kind":12,"name":"_interpro_handler"},{"kind":12,"line":217,"name":"_ontology_engine"},{"range":{"start":{"character":0,"line":234},"end":{"line":239,"character":9999}},"containerName":"main::","definition":"sub","name":"_is_parsed","line":234,"children":[{"kind":13,"line":235,"name":"$self","definition":"my","containerName":"_is_parsed","localvar":"my"},{"containerName":"_is_parsed","name":"$self","kind":13,"line":237},{"containerName":"_is_parsed","name":"$self","kind":13,"line":238}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"secondary_accessions_map($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: InterProParser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProParser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::InterProParser - Parser for InterPro xml files.\n\n=head1 SYNOPSIS\n\n    # don't use this module directly - use Bio::OntologyIO with instead\n    my $ipp = Bio::OntologyIO->new( -format  => 'interpro',\n                                    -file    => 't/data/interpro.xml',\n                                    -ontology_engine => 'simple' );\n\n=head1 DESCRIPTION\n\n  Use InterProParser to parse InterPro files in xml format. Typical\n  use is the interpro.xml file published by EBI. The xml records\n  should follow the format described in interpro.dtd, although the dtd\n  file is not needed, and the XML file will not be validated against it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::InterProParser;\nuse strict;\n#use Carp;\nuse XML::Parser::PerlSAX;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Ontology::TermFactory;\nuse Bio::OntologyIO::Handlers::InterProHandler;\n\nuse base qw(Bio::OntologyIO);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Initializes objects needed for parsing.\n Example : $ipp = Bio::OntologyIO::InterProParser->new( \n                                  -file => 't/data/interpro.xml',\n\t\t\t\t  -ontology_engine => 'simple' )\n\n Returns : Object of class Bio::OntologyIO::InterProParser.\n Args    :\n\n  -file            - file name\n  -ontology_engine - type of ontology engine. Should satisfy the\n                     OntologyEngine interface requirements. Currently\n                     the only option is 'simple'. In the future\n                     Graph.pm based engine will be added to the\n                     choices.\n\n\n\n# in reality we let OntologyIO handle the first pass initialization\n# and instead override _initialize().\nsub _initialize{\n    my $self = shift;\n\n    $self->SUPER::_initialize(@_);\n\n    my ($eng,$eng_type,$name) =\n\t$self->_rearrange([qw(ENGINE\n\t\t\t      ONTOLOGY_ENGINE\n\t\t\t      ONTOLOGY_NAME)\n\t\t\t   ], @_);\n\n    my $ip_h = Bio::OntologyIO::Handlers::InterProHandler->new(\n\t\t\t                             -ontology_name => $name);\n\n    if(! $eng) {\n\t$eng_type = 'simple' unless $eng_type;\n\tif(lc($eng_type) eq 'simple') {\n\t    $eng = Bio::Ontology::SimpleOntologyEngine->new();\n\t} else {\n\t    $self->throw(\"ontology engine type '$eng_type' \".\n\t\t\t \"not implemented yet\");\n\t}\n    }\n    if($eng->isa(\"Bio::Ontology::OntologyI\")) {\n\t$ip_h->ontology($eng);\n\t$eng = $eng->engine() if $eng->can('engine');\n    }\n    $self->{_ontology_engine} = $eng;\n    $ip_h->ontology_engine($eng);\n\n    $self->{_parser} = XML::Parser::PerlSAX->new( Handler => $ip_h );\n    $self->{_interpro_handler} = $ip_h;\n\n    # default term object factory\n    $self->term_factory(Bio::Ontology::TermFactory->new(\n\t\t\t\t   -type => \"Bio::Ontology::InterProTerm\"))\n\tunless $self->term_factory();\n    $ip_h->term_factory($self->term_factory());\n\n}\n\n=head2 parse\n\n Title   : parse\n Usage   :\n Function: Performs the actual parsing.\n Example : $ipp->parse();\n Returns : \n Args    :\n\n\nsub parse{\n   my $self = shift;\n\n   my $ret;\n   if ($self->file()) {\n         $ret = $self->{_parser}->parse( Source => {\n\t                SystemId => $self->file() } );\n   } elsif ($self->_fh()) {\n        $ret = $self->{_parser}->parse( Source => {\n                ByteStream => $self->_fh() } );\n   } else {\n        $ret = undef;\n        $self->throw(\"Only filenames and filehandles are understood here.\\n\");\n   }\n\n   $self->_is_parsed(1);\n   return $ret;\n}\n\n=head2 next_ontology\n\n Title   : next_ontology\n Usage   : $ipp->next_ontology()\n Function: Parses the input file and returns the next InterPro ontology\n           available.\n\n           Usually there will be only one ontology returned from an\n           InterPro XML input.\n\n Example : $ipp->next_ontology();\n Returns : Returns the ontology as a Bio::Ontology::OntologyEngineI\n           compliant object.\n Args    : \n\nSee L<Bio::Ontology::OntologyEngineI>.\n\n\nsub next_ontology{\n  my $self = shift;\n\n  $self->parse() unless $self->_is_parsed();\n  # there is only one ontology in an InterPro source file\n  if(exists($self->{'_ontology_engine'})) {\n      my $ont = $self->{_interpro_handler}->ontology();\n      delete $self->{_ontology_engine};\n      return $ont;\n  }\n  return;\n}\n\n=head2 _is_parsed\n\n Title   : _is_parsed\n Usage   : $obj->_is_parsed($newval)\n Function: \n Example : \n Returns : value of _is_parsed (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub _is_parsed{\n    my $self = shift;\n\n    return $self->{'_is_parsed'} = shift if @_;\n    return $self->{'_is_parsed'};\n}\n\n=head2 secondary_accessions_map\n\n Title   : secondary_accessions_map\n Usage   : $obj->secondary_accessions_map()\n Function: This method is merely for convenience, and one should\n           normally use the InterProTerm secondary_ids method to\n           access the secondary accessions.\n Example : $map = $interpro_parser->secondary_accessions_map;\n Returns : Reference to a hash that maps InterPro identifier to an\n           array reference of secondary accessions following the \n           InterPro xml schema.\n Args    : Empty hash reference"},"kind":12,"line":256,"children":[{"localvar":"my","containerName":"secondary_accessions_map","name":"$self","definition":"my","line":257,"kind":13},{"kind":13,"line":259,"name":"$self","containerName":"secondary_accessions_map"}],"name":"secondary_accessions_map","range":{"start":{"character":0,"line":256},"end":{"character":9999,"line":260}}},{"name":"_interpro_handler","kind":12,"line":259},{"name":"secondary_accessions_map","line":259,"kind":12}]}