{"version":5,"vars":[{"name":"base","containerName":"","line":135,"kind":2},{"name":"new","range":{"start":{"line":149,"character":0},"end":{"character":9999,"line":161}},"containerName":"main::","definition":"sub","detail":"($class)","signature":{"parameters":[{"label":"$class"}],"documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none","label":"new($class)"},"kind":12,"line":149,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":150},{"name":"$class","containerName":"new","line":151,"kind":13},{"line":151,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"$class","kind":13,"line":151},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":153,"kind":13},{"name":"$Graph","containerName":"new","line":154,"kind":13},{"kind":13,"line":154,"name":"$Graph","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":155},{"name":"$self","containerName":"new","kind":13,"line":157},{"line":158,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":159},{"name":"$self","containerName":"new","kind":13,"line":160}]},{"kind":12,"line":154,"containerName":"","name":"VERSION"},{"line":154,"kind":12,"containerName":"","name":"VERSION"},{"name":"_graph","line":157,"kind":12},{"name":"Graph","containerName":"Directed","kind":12,"line":158},{"name":"_vertex_attributes","kind":12,"line":158},{"name":"_edge_attributes","kind":12,"line":159},{"range":{"start":{"character":0,"line":165},"end":{"line":168,"character":9999}},"containerName":"main::","definition":"sub","name":"add_vertex","line":165,"children":[{"localvar":"my","containerName":"add_vertex","definition":"my","name":"$self","line":166,"kind":13},{"containerName":"add_vertex","name":"$self","line":167,"kind":13},{"containerName":"add_vertex","name":"_graph","kind":12,"line":167},{"kind":12,"line":167,"containerName":"add_vertex","name":"add_vertex"}],"kind":12},{"definition":"sub","name":"has_vertex","containerName":"main::","range":{"start":{"line":169,"character":0},"end":{"line":172,"character":9999}},"kind":12,"children":[{"containerName":"has_vertex","definition":"my","name":"$self","localvar":"my","kind":13,"line":170},{"name":"$self","containerName":"has_vertex","line":171,"kind":13},{"containerName":"has_vertex","name":"_graph","line":171,"kind":12},{"kind":12,"line":171,"containerName":"has_vertex","name":"has_vertex"}],"line":169},{"kind":12,"line":173,"children":[{"localvar":"my","containerName":"add_edge","name":"$self","definition":"my","line":174,"kind":13},{"name":"$self","containerName":"add_edge","kind":13,"line":175},{"name":"_graph","containerName":"add_edge","line":175,"kind":12},{"containerName":"add_edge","name":"add_edge","kind":12,"line":175}],"containerName":"main::","definition":"sub","name":"add_edge","range":{"end":{"line":176,"character":9999},"start":{"line":173,"character":0}}},{"containerName":"main::","name":"has_edge","definition":"sub","range":{"end":{"character":9999,"line":180},"start":{"line":177,"character":0}},"kind":12,"line":177,"children":[{"localvar":"my","containerName":"has_edge","name":"$self","definition":"my","line":178,"kind":13},{"kind":13,"line":179,"containerName":"has_edge","name":"$self"},{"containerName":"has_edge","name":"_graph","kind":12,"line":179},{"kind":12,"line":179,"containerName":"has_edge","name":"has_edge"}]},{"range":{"start":{"line":181,"character":0},"end":{"line":184,"character":9999}},"containerName":"main::","definition":"sub","name":"vertices","line":181,"children":[{"kind":13,"line":182,"containerName":"vertices","definition":"my","name":"$self","localvar":"my"},{"containerName":"vertices","name":"$self","line":183,"kind":13},{"kind":12,"line":183,"name":"_graph","containerName":"vertices"},{"kind":12,"line":183,"containerName":"vertices","name":"vertices"}],"kind":12},{"definition":"sub","name":"edges","containerName":"main::","range":{"start":{"line":185,"character":0},"end":{"character":9999,"line":188}},"kind":12,"children":[{"kind":13,"line":186,"containerName":"edges","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"edges","kind":13,"line":187},{"line":187,"kind":12,"containerName":"edges","name":"_graph"},{"kind":12,"line":187,"containerName":"edges","name":"edges"}],"line":185},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"edges_at","line":190,"kind":13},{"kind":13,"line":191,"containerName":"edges_at","name":"$self"},{"kind":12,"line":191,"containerName":"edges_at","name":"_graph"},{"name":"edges_at","containerName":"edges_at","kind":12,"line":191}],"line":189,"name":"edges_at","definition":"sub","containerName":"main::","range":{"end":{"line":192,"character":9999},"start":{"line":189,"character":0}}},{"containerName":"main::","name":"predecessors","definition":"sub","range":{"end":{"character":9999,"line":196},"start":{"character":0,"line":193}},"kind":12,"line":193,"children":[{"kind":13,"line":194,"containerName":"predecessors","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":195,"name":"$self","containerName":"predecessors"},{"name":"_graph","containerName":"predecessors","line":195,"kind":12},{"containerName":"predecessors","name":"predecessors","line":195,"kind":12}]},{"name":"successors","definition":"sub","containerName":"main::","range":{"end":{"line":200,"character":9999},"start":{"character":0,"line":197}},"kind":12,"children":[{"line":198,"kind":13,"localvar":"my","containerName":"successors","name":"$self","definition":"my"},{"containerName":"successors","name":"$self","kind":13,"line":199},{"line":199,"kind":12,"name":"_graph","containerName":"successors"},{"kind":12,"line":199,"name":"successors","containerName":"successors"}],"line":197},{"children":[{"kind":13,"line":202,"containerName":"source_vertices","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":203,"name":"$self","containerName":"source_vertices"},{"name":"_graph","containerName":"source_vertices","line":203,"kind":12},{"line":203,"kind":12,"containerName":"source_vertices","name":"source_vertices"}],"line":201,"kind":12,"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":204}},"definition":"sub","name":"source_vertices","containerName":"main::"},{"range":{"end":{"line":208,"character":9999},"start":{"character":0,"line":205}},"name":"sink_vertices","definition":"sub","containerName":"main::","children":[{"line":206,"kind":13,"localvar":"my","containerName":"sink_vertices","name":"$self","definition":"my"},{"containerName":"sink_vertices","name":"$self","line":207,"kind":13},{"containerName":"sink_vertices","name":"_graph","kind":12,"line":207},{"line":207,"kind":12,"containerName":"sink_vertices","name":"sink_vertices"}],"line":205,"kind":12},{"name":"set_vertex_attribute","range":{"start":{"line":211,"character":0},"end":{"line":214,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"set_vertex_attribute","localvar":"my","kind":13,"line":212},{"containerName":"set_vertex_attribute","name":"$v","kind":13,"line":212},{"line":212,"kind":13,"containerName":"set_vertex_attribute","name":"$attribute"},{"name":"$value","containerName":"set_vertex_attribute","kind":13,"line":212},{"containerName":"set_vertex_attribute","name":"$self","line":213,"kind":13},{"kind":12,"line":213,"containerName":"set_vertex_attribute","name":"_vertex2attributes"},{"name":"$v","containerName":"set_vertex_attribute","kind":13,"line":213},{"containerName":"set_vertex_attribute","name":"$attribute","line":213,"kind":13},{"containerName":"set_vertex_attribute","name":"$value","kind":13,"line":213}],"line":211,"definition":"sub","containerName":"main::","signature":{"documentation":" The following methods workaround a performance problem in Graph v0.5x\n when attributes are attached to the graph","parameters":[{"label":"$self"},{"label":"$v"},{"label":"$attribute"},{"label":"$value"}],"label":"set_vertex_attribute($self,$v,$attribute,$value)"},"detail":"($self,$v,$attribute,$value)"},{"kind":12,"line":215,"children":[{"name":"$self","definition":"my","containerName":"get_vertex_attribute","localvar":"my","kind":13,"line":216},{"kind":13,"line":216,"name":"$v","containerName":"get_vertex_attribute"},{"containerName":"get_vertex_attribute","name":"$attribute","kind":13,"line":216},{"name":"$self","containerName":"get_vertex_attribute","line":217,"kind":13},{"containerName":"get_vertex_attribute","name":"_vertex2attributes","line":217,"kind":12},{"name":"$v","containerName":"get_vertex_attribute","kind":13,"line":217},{"kind":13,"line":217,"containerName":"get_vertex_attribute","name":"$attribute"}],"containerName":"main::","definition":"sub","detail":"($self,$v,$attribute)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$v"},{"label":"$attribute"}],"label":"get_vertex_attribute($self,$v,$attribute)"},"name":"get_vertex_attribute","range":{"start":{"line":215,"character":0},"end":{"character":9999,"line":218}}},{"range":{"end":{"character":9999,"line":222},"start":{"character":0,"line":219}},"name":"set_edge_attribute","line":219,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"set_edge_attribute","line":220,"kind":13},{"line":220,"kind":13,"containerName":"set_edge_attribute","name":"$u"},{"containerName":"set_edge_attribute","name":"$v","kind":13,"line":220},{"line":220,"kind":13,"name":"$attribute","containerName":"set_edge_attribute"},{"name":"$value","containerName":"set_edge_attribute","line":220,"kind":13},{"line":221,"kind":13,"name":"$self","containerName":"set_edge_attribute"},{"kind":12,"line":221,"name":"_edge2attributes","containerName":"set_edge_attribute"},{"containerName":"set_edge_attribute","name":"$u","line":221,"kind":13},{"line":221,"kind":13,"name":"$v","containerName":"set_edge_attribute"},{"line":221,"kind":13,"containerName":"set_edge_attribute","name":"$attribute"},{"line":221,"kind":13,"containerName":"set_edge_attribute","name":"$value"}],"kind":12,"detail":"($self,$u,$v,$attribute,$value)","signature":{"label":"set_edge_attribute($self,$u,$v,$attribute,$value)","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"},{"label":"$attribute"},{"label":"$value"}],"documentation":""},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":226},"start":{"character":0,"line":223}},"name":"get_edge_attribute","children":[{"localvar":"my","containerName":"get_edge_attribute","definition":"my","name":"$self","line":224,"kind":13},{"line":224,"kind":13,"containerName":"get_edge_attribute","name":"$u"},{"name":"$v","containerName":"get_edge_attribute","line":224,"kind":13},{"kind":13,"line":224,"name":"$attribute","containerName":"get_edge_attribute"},{"line":225,"kind":13,"containerName":"get_edge_attribute","name":"$self"},{"kind":12,"line":225,"name":"_edge2attributes","containerName":"get_edge_attribute"},{"kind":13,"line":225,"containerName":"get_edge_attribute","name":"$u"},{"containerName":"get_edge_attribute","name":"$v","kind":13,"line":225},{"name":"$attribute","containerName":"get_edge_attribute","line":225,"kind":13}],"line":223,"kind":12,"signature":{"label":"get_edge_attribute($self,$u,$v,$attribute)","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"},{"label":"$attribute"}],"documentation":""},"detail":"($self,$u,$v,$attribute)","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":238},"start":{"line":238,"character":0}},"containerName":"main::","definition":"sub","name":"_graph","line":238,"children":[],"kind":12},{"kind":12,"line":238,"name":"_graph"},{"name":"_vertex_attributes","definition":"sub","containerName":"main::","range":{"end":{"line":250,"character":9999},"start":{"line":250,"character":0}},"kind":12,"children":[],"line":250},{"name":"_vertex_attributes","line":250,"kind":12},{"children":[],"line":262,"kind":12,"range":{"end":{"line":262,"character":9999},"start":{"character":0,"line":262}},"definition":"sub","name":"_edge_attributes","containerName":"main::"},{"line":262,"kind":12,"name":"_edge_attributes"},{"range":{"end":{"line":278,"character":9999},"start":{"line":275,"character":0}},"name":"_vertex2attributes","children":[{"name":"$self","definition":"my","containerName":"_vertex2attributes","localvar":"my","kind":13,"line":276},{"containerName":"_vertex2attributes","name":"$vertex","kind":13,"line":276},{"containerName":"_vertex2attributes","name":"$self","line":277,"kind":13},{"name":"_vertex_attributes","containerName":"_vertex2attributes","line":277,"kind":12},{"line":277,"kind":13,"name":"$vertex","containerName":"_vertex2attributes"},{"kind":13,"line":277,"containerName":"_vertex2attributes","name":"$self"},{"containerName":"_vertex2attributes","name":"_vertex_attributes","line":277,"kind":12},{"line":277,"kind":13,"containerName":"_vertex2attributes","name":"$vertex"}],"line":275,"kind":12,"signature":{"label":"_vertex2attributes($self,$vertex)","documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none\n\n\nsub new {\n  my( $class ) = @_;\n  $class = ref $class || $class;\n\n  my $self=\n    ( defined $Graph::VERSION && $Graph::VERSION >= 0.5 ) ?\n      bless ( {}, $class ) :\n\tbless ( {}, 'Bio::Ontology::SimpleGOEngine::GraphAdaptor02' );\n  $self->{_graph}=new Graph::Directed;\n  $self->{_vertex_attributes}={};\n  $self->{_edge_attributes}={};\n  return $self;\n}\n\n# Here are the main methods\n\nsub add_vertex {\n  my $self=shift;\n  $self->_graph->add_vertex(@_);\n}\nsub has_vertex {\n  my $self=shift;\n  $self->_graph->has_vertex(@_);\n}\nsub add_edge {\n  my $self=shift;\n  $self->_graph->add_edge(@_);\n}\nsub has_edge {\n  my $self=shift;\n  $self->_graph->has_edge(@_);\n}\nsub vertices {\n  my $self=shift;\n  $self->_graph->vertices(@_);\n}\nsub edges {\n  my $self=shift;\n  $self->_graph->edges(@_);\n}\nsub edges_at {\n  my $self=shift;\n  $self->_graph->edges_at(@_);\n}\nsub predecessors {\n  my $self=shift;\n  $self->_graph->predecessors(@_);\n} \nsub successors {\n  my $self=shift;\n  $self->_graph->successors(@_);\n}\nsub source_vertices {\n  my $self=shift;\n  $self->_graph->source_vertices();\n}\nsub sink_vertices {\n  my $self=shift;\n  $self->_graph->sink_vertices();\n}\n# The following methods workaround a performance problem in Graph v0.5x \n# when attributes are attached to the graph\nsub set_vertex_attribute {\n  my($self,$v,$attribute,$value)=@_;\n  $self->_vertex2attributes($v)->{$attribute}=$value;\n}\nsub get_vertex_attribute {\n  my($self,$v,$attribute)=@_;\n  $self->_vertex2attributes($v)->{$attribute};\n}\nsub set_edge_attribute {\n  my($self,$u,$v,$attribute,$value)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute}=$value;\n}\nsub get_edge_attribute {\n  my($self,$u,$v,$attribute)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute};\n}\n\n=head2 _graph\n\n Title   : _graph\n Usage   : $self->_graph();\n Function: Internal method to access 'real' graph\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _graph {$_[0]->{_graph}; }\n\n=head2 _vertex_attributes\n\n Title   : _vertex_attributes\n Usage   : $self->vertex_attributes();\n Function: Internal method to access HASH used to store vertex attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _vertex_attributes {$_[0]->{_vertex_attributes}; }\n\n=head2 _edge_attributes\n\n Title   : _edge_attributes\n Usage   : $self->edge_attributes();\n Function: Internal method to access HASH used to store edge attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _edge_attributes {$_[0]->{_edge_attributes}; }\n\n=head2 _vertex2attributes\n\n Title   : _vertex2attributes\n Usage   : $value=$graph->_vertex2attributes($v_->{ATTRIBUTE};\n           $graph->_vertex2attributes($v)->{ATTRIBUTE}=$value;\n Function: Internal method to access attributes for a specific vertex\n Returns : HASH\n Args    : none","parameters":[{"label":"$self"},{"label":"$vertex"}]},"detail":"($self,$vertex)","definition":"sub","containerName":"main::"},{"name":"_edge2attributes","range":{"start":{"character":0,"line":291},"end":{"line":294,"character":9999}},"kind":12,"children":[{"line":292,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_edge2attributes"},{"kind":13,"line":292,"name":"$u","containerName":"_edge2attributes"},{"kind":13,"line":292,"containerName":"_edge2attributes","name":"$v"},{"name":"$self","containerName":"_edge2attributes","kind":13,"line":293},{"line":293,"kind":12,"name":"_edge_attributes","containerName":"_edge2attributes"},{"line":293,"kind":13,"name":"$u","containerName":"_edge2attributes"},{"kind":13,"line":293,"name":"$v","containerName":"_edge2attributes"},{"kind":13,"line":293,"containerName":"_edge2attributes","name":"$self"},{"name":"_edge_attributes","containerName":"_edge2attributes","line":293,"kind":12},{"containerName":"_edge2attributes","name":"$u","line":293,"kind":13},{"kind":13,"line":293,"containerName":"_edge2attributes","name":"$v"}],"line":291,"definition":"sub","containerName":"main::","signature":{"label":"_edge2attributes($self,$u,$v)","documentation":"1;\n# $Id: GraphAdaptor.pm 10525 2006-09-26 22:03:22Z sendu $\n#\n# BioPerl Graph adaptor for Bio::Ontology::SimpleGOEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Nat Goodman <natg at shore.net>\n#\n# (c) Nathan Goodman natg@shore.net 2005\n# (c) ISB, Institute for Systems Biology 2005\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleGOEngine::GraphAdaptor - Graph adaptor for\nBio::Ontology::SimpleGOEngine\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n  my $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\n=head1 DESCRIPTION\n\nThis is a think adaptor to simplify use of the old and new versions of\nthe standard CPAN Graph module (old is versions 0.2x; new is 0.5x and\nbeyond) within Bio::Ontology::SimpleGOEngine.\n\nThis module implements only those Graph methods used by\nSimpleGOEngine.  It is far from a complete compatibility layer!  It\nalso implements workarounds for cerain performance problems in the\ncurrent versions of Graph v0.5x.\n\nThis class provides a 'new' method that determines which version of\nGraph is available.  The object returned by 'new' is blessed into this\nclass if the new version of Graph is available, else into the subclass\n\n  Bio::Ontology::SimpleGOEngine::GraphAdaptor02\n\nThis class provides implementations for the required graph methods\nusing the new version of Graph.  In most cases, these are simple\npass-throughs.  Methods that differ in v0.2x are implemented in the\nsubclass.\n\nThe methods implemented here or in the subclasses are listed below.\nIn all cases, we implemented the Graph v0.5x interface.  Consult the\nGraph v0.5x man page for details.\n\n  add_vertex\n  has_vertex\n  add_edge\n  has_edge\n  vertices\n  edges\n  edges_at\n  predecessors\n  successors\n  set_vertex_attribute\n  get_vertex_attribute\n  set_edge_attribute\n  get_edge_attribute\n  source_vertices\n  sink_vertices\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nNat Goodman\n\nEmail: natg at shore.net\n\nAddress:\n\n  Institute for Systems Biology\n  1441 N 34th St\n  Seattle, WA 98103-8904\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse Graph::Directed;\n\nuse strict;\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor02;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $graph = Bio::Ontology::SimpleGOEngine::GraphAdaptor->new()\n Function: Creates a new graph\n Returns : Bio::Ontology::SimpleGOEngine::GraphAdaptor02 or \n           Bio::Ontology::SimpleGOEngine::GraphAdaptor05 object, \n           depending on which Graph version is available\n Args    : none\n\n\nsub new {\n  my( $class ) = @_;\n  $class = ref $class || $class;\n\n  my $self=\n    ( defined $Graph::VERSION && $Graph::VERSION >= 0.5 ) ?\n      bless ( {}, $class ) :\n\tbless ( {}, 'Bio::Ontology::SimpleGOEngine::GraphAdaptor02' );\n  $self->{_graph}=new Graph::Directed;\n  $self->{_vertex_attributes}={};\n  $self->{_edge_attributes}={};\n  return $self;\n}\n\n# Here are the main methods\n\nsub add_vertex {\n  my $self=shift;\n  $self->_graph->add_vertex(@_);\n}\nsub has_vertex {\n  my $self=shift;\n  $self->_graph->has_vertex(@_);\n}\nsub add_edge {\n  my $self=shift;\n  $self->_graph->add_edge(@_);\n}\nsub has_edge {\n  my $self=shift;\n  $self->_graph->has_edge(@_);\n}\nsub vertices {\n  my $self=shift;\n  $self->_graph->vertices(@_);\n}\nsub edges {\n  my $self=shift;\n  $self->_graph->edges(@_);\n}\nsub edges_at {\n  my $self=shift;\n  $self->_graph->edges_at(@_);\n}\nsub predecessors {\n  my $self=shift;\n  $self->_graph->predecessors(@_);\n} \nsub successors {\n  my $self=shift;\n  $self->_graph->successors(@_);\n}\nsub source_vertices {\n  my $self=shift;\n  $self->_graph->source_vertices();\n}\nsub sink_vertices {\n  my $self=shift;\n  $self->_graph->sink_vertices();\n}\n# The following methods workaround a performance problem in Graph v0.5x \n# when attributes are attached to the graph\nsub set_vertex_attribute {\n  my($self,$v,$attribute,$value)=@_;\n  $self->_vertex2attributes($v)->{$attribute}=$value;\n}\nsub get_vertex_attribute {\n  my($self,$v,$attribute)=@_;\n  $self->_vertex2attributes($v)->{$attribute};\n}\nsub set_edge_attribute {\n  my($self,$u,$v,$attribute,$value)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute}=$value;\n}\nsub get_edge_attribute {\n  my($self,$u,$v,$attribute)=@_;\n  $self->_edge2attributes($u,$v)->{$attribute};\n}\n\n=head2 _graph\n\n Title   : _graph\n Usage   : $self->_graph();\n Function: Internal method to access 'real' graph\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _graph {$_[0]->{_graph}; }\n\n=head2 _vertex_attributes\n\n Title   : _vertex_attributes\n Usage   : $self->vertex_attributes();\n Function: Internal method to access HASH used to store vertex attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _vertex_attributes {$_[0]->{_vertex_attributes}; }\n\n=head2 _edge_attributes\n\n Title   : _edge_attributes\n Usage   : $self->edge_attributes();\n Function: Internal method to access HASH used to store edge attributes\n Returns : Graph::Directed object \n Args    : none\n\n\nsub _edge_attributes {$_[0]->{_edge_attributes}; }\n\n=head2 _vertex2attributes\n\n Title   : _vertex2attributes\n Usage   : $value=$graph->_vertex2attributes($v_->{ATTRIBUTE};\n           $graph->_vertex2attributes($v)->{ATTRIBUTE}=$value;\n Function: Internal method to access attributes for a specific vertex\n Returns : HASH\n Args    : none\n\n\nsub _vertex2attributes {\n  my($self,$vertex)=@_;\n  $self->_vertex_attributes->{$vertex} or $self->_vertex_attributes->{$vertex}={};\n}\n\n=head2 _edge2attributes\n\n Title   : _edge2attributes\n Usage   : $value=$graph->_edge2attributes($u,$v)->{ATTRIBUTE};\n           $graph->_edge2attributes($u,$v)->{ATTRIBUTE}=$value;\n Function: Internal method to access HASH used to store edge attributes\n Returns : HASH\n Args    : none","parameters":[{"label":"$self"},{"label":"$u"},{"label":"$v"}]},"detail":"($self,$u,$v)"}]}