{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":118},{"kind":12,"children":[{"kind":13,"line":141,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"kind":13,"line":141,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":143,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":143},{"name":"@args","containerName":"new","line":143,"kind":13},{"kind":13,"line":145,"name":"$identifier","definition":"my","containerName":"new","localvar":"my"},{"name":"$subject_term","containerName":"new","line":146,"kind":13},{"containerName":"new","name":"$child","kind":13,"line":147},{"containerName":"new","name":"$object_term","kind":13,"line":148},{"name":"$parent","containerName":"new","kind":13,"line":149},{"name":"$predicate_term","containerName":"new","line":150,"kind":13},{"containerName":"new","name":"$reltype","kind":13,"line":151},{"name":"$ont","containerName":"new","kind":13,"line":152},{"line":153,"kind":13,"name":"$self","containerName":"new"},{"line":153,"kind":12,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","line":161,"kind":13},{"line":163,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":163,"containerName":"new","name":"init"},{"kind":13,"line":165,"name":"$self","containerName":"new"},{"line":165,"kind":12,"containerName":"new","name":"identifier"},{"name":"$identifier","containerName":"new","kind":13,"line":165},{"name":"$subject_term","containerName":"new","kind":13,"line":166},{"name":"$child","containerName":"new","line":166,"kind":13},{"kind":13,"line":166,"containerName":"new","name":"$subject_term"},{"kind":13,"line":167,"name":"$object_term","containerName":"new"},{"containerName":"new","name":"$parent","line":167,"kind":13},{"containerName":"new","name":"$object_term","kind":13,"line":167},{"name":"$predicate_term","containerName":"new","line":168,"kind":13},{"kind":13,"line":168,"containerName":"new","name":"$reltype"},{"line":168,"kind":13,"containerName":"new","name":"$predicate_term"},{"kind":13,"line":169,"name":"$self","containerName":"new"},{"name":"subject_term","containerName":"new","line":169,"kind":12},{"name":"$subject_term","containerName":"new","line":169,"kind":13},{"name":"$subject_term","containerName":"new","line":169,"kind":13},{"line":170,"kind":13,"name":"$self","containerName":"new"},{"line":170,"kind":12,"name":"object_term","containerName":"new"},{"kind":13,"line":170,"name":"$object_term","containerName":"new"},{"name":"$object_term","containerName":"new","kind":13,"line":170},{"kind":13,"line":171,"name":"$self","containerName":"new"},{"containerName":"new","name":"predicate_term","line":171,"kind":12},{"name":"$predicate_term","containerName":"new","kind":13,"line":171},{"containerName":"new","name":"$predicate_term","kind":13,"line":171},{"kind":13,"line":172,"name":"$self","containerName":"new"},{"line":172,"kind":12,"containerName":"new","name":"ontology"},{"name":"$ont","containerName":"new","kind":13,"line":172},{"containerName":"new","name":"$ont","line":172,"kind":13},{"line":174,"kind":13,"containerName":"new","name":"$self"}],"line":139,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","name":"new","range":{"start":{"character":0,"line":139},"end":{"character":9999,"line":176}}},{"kind":12,"line":143,"name":"SUPER","containerName":"new"},{"name":"init","range":{"end":{"character":9999,"line":199},"start":{"line":190,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :"},"kind":12,"line":190,"children":[{"kind":13,"line":191,"containerName":"init","definition":"my","name":"$self","localvar":"my"},{"line":193,"kind":13,"name":"$self","containerName":"init"},{"kind":13,"line":194,"name":"$self","containerName":"init"},{"name":"$self","containerName":"init","kind":13,"line":195},{"name":"$self","containerName":"init","line":196,"kind":13},{"line":197,"kind":13,"name":"$self","containerName":"init"},{"containerName":"init","name":"ontology","line":197,"kind":12}]},{"kind":12,"children":[{"line":216,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"identifier"},{"name":"$value","containerName":"identifier","line":216,"kind":13},{"kind":13,"line":218,"name":"$value","containerName":"identifier"},{"name":"$self","containerName":"identifier","kind":13,"line":219},{"line":219,"kind":13,"containerName":"identifier","name":"$value"},{"line":222,"kind":13,"name":"$self","containerName":"identifier"}],"line":215,"definition":"sub","containerName":"main::","signature":{"label":"identifier($self,$value)","documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","name":"identifier","range":{"start":{"character":0,"line":215},"end":{"line":223,"character":9999}}},{"line":245,"children":[{"definition":"my","name":"$self","containerName":"subject_term","localvar":"my","kind":13,"line":246},{"kind":13,"line":246,"name":"$term","containerName":"subject_term"},{"kind":13,"line":248,"containerName":"subject_term","name":"$term"},{"name":"$self","containerName":"subject_term","kind":13,"line":249},{"kind":12,"line":249,"name":"_check_class","containerName":"subject_term"},{"containerName":"subject_term","name":"$term","line":249,"kind":13},{"name":"$self","containerName":"subject_term","line":250,"kind":13},{"kind":13,"line":250,"containerName":"subject_term","name":"$term"},{"name":"$self","containerName":"subject_term","line":253,"kind":13}],"kind":12,"detail":"($self,$term)","signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).","label":"subject_term($self,$term)"},"containerName":"main::","definition":"sub","range":{"start":{"line":245,"character":0},"end":{"line":255,"character":9999}},"name":"subject_term"},{"range":{"start":{"line":276,"character":0},"end":{"line":285,"character":9999}},"name":"object_term","detail":"($self,$term)","signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional).","label":"object_term($self,$term)"},"containerName":"main::","definition":"sub","line":276,"children":[{"line":277,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"object_term"},{"kind":13,"line":277,"name":"$term","containerName":"object_term"},{"line":279,"kind":13,"containerName":"object_term","name":"$term"},{"name":"$self","containerName":"object_term","line":280,"kind":13},{"containerName":"object_term","name":"_check_class","line":280,"kind":12},{"line":280,"kind":13,"containerName":"object_term","name":"$term"},{"name":"$self","containerName":"object_term","line":281,"kind":13},{"name":"$term","containerName":"object_term","line":281,"kind":13},{"kind":13,"line":284,"name":"$self","containerName":"object_term"}],"kind":12},{"name":"predicate_term","range":{"start":{"line":307,"character":0},"end":{"line":316,"character":9999}},"kind":12,"line":307,"children":[{"definition":"my","name":"$self","containerName":"predicate_term","localvar":"my","kind":13,"line":308},{"kind":13,"line":308,"containerName":"predicate_term","name":"$term"},{"line":310,"kind":13,"containerName":"predicate_term","name":"$term"},{"kind":13,"line":311,"containerName":"predicate_term","name":"$self"},{"kind":12,"line":311,"containerName":"predicate_term","name":"_check_class"},{"name":"$term","containerName":"predicate_term","line":311,"kind":13},{"containerName":"predicate_term","name":"$self","line":312,"kind":13},{"name":"$term","containerName":"predicate_term","kind":13,"line":312},{"containerName":"predicate_term","name":"$self","kind":13,"line":315}],"containerName":"main::","definition":"sub","detail":"($self,$term)","signature":{"label":"predicate_term($self,$term)","parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional).\n\n\nsub object_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_object_term\" } = $term;\n    }\n\n    return $self->{ \"_object_term\" };\n}\n\n\n\n=head2 predicate_term\n\n Title   : predicate_term\n Usage   : $rel->predicate_term( $type );\n           or\n           $type = $rel->predicate_term();\n Function: Set/get for the predicate (relationship type) of this\n           relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The predicate term [Bio::Ontology::TermI].\n Args    : The predicate term [Bio::Ontology::TermI] (optional)."}},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"ontology","line":334,"kind":13},{"kind":13,"line":335,"containerName":"ontology","name":"$ont","definition":"my","localvar":"my"},{"containerName":"ontology","name":"$ont","kind":13,"line":338},{"containerName":"ontology","name":"$ont","line":339,"kind":13},{"containerName":"ontology","name":"$ont","kind":13,"line":340},{"containerName":"ontology","name":"new","line":340,"kind":12},{"kind":13,"line":340,"containerName":"ontology","name":"$ont"},{"line":340,"kind":13,"name":"$ont","containerName":"ontology"},{"line":341,"kind":13,"containerName":"ontology","name":"$ont"},{"line":341,"kind":12,"containerName":"ontology","name":"isa"},{"line":342,"kind":13,"containerName":"ontology","name":"$self"},{"kind":12,"line":342,"name":"throw","containerName":"ontology"},{"containerName":"ontology","name":"$ont","kind":13,"line":342},{"line":346,"kind":13,"containerName":"ontology","name":"$self"},{"containerName":"ontology","name":"$ont","line":346,"kind":13},{"containerName":"ontology","name":"$self","kind":13,"line":348}],"line":333,"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"character":0,"line":333}},"name":"ontology","definition":"sub","containerName":"main::"},{"kind":12,"line":340,"containerName":"Ontology::Ontology","name":"Bio"},{"range":{"start":{"line":361,"character":0},"end":{"character":9999,"line":379}},"name":"to_string","signature":{"label":"to_string($self)","documentation":"1;\n# $Id: Relationship.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Relationship\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Relationship - a relationship for an ontology\n\n=head1 SYNOPSIS\n\n  $rel = Bio::Ontology::Relationship->new( -identifier     => \"16847\",\n                                           -subject_term   => $subj,\n                                           -object_term    => $obj,\n                                           -predicate_term => $pred );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::RelationshipI. \n\nThe terminology we use here is the one commonly used for ontologies,\nnamely the triple of (subject, predicate, object), which in addition\nis scoped in a namespace (ontology). It is called triple because it is\na tuple of three ontology terms.\n\nThere are other terminologies in use for expressing relationships. For\nthose who it helps to better understand the concept, the triple of\n(child, relationship type, parent) would be equivalent to the\nterminology chosen here, disregarding the question whether the notion\nof parent and child is sensible in the context of the relationship\ntype or not. Especially in the case of ontologies with a wide variety\nof predicates the parent/child terminology and similar ones can\nquickly become ambiguous (e.g., A synthesises B), meaningless (e.g., A\nbinds B), or even conflicting (e.g., A is-parent-of B), and are\ntherefore strongly discouraged.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 CONTRIBUTORS\n\n Hilmar Lapp, email: hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Relationship;\nuse strict;\nuse Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::Ontology::RelationshipI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Relationship->new(-identifier   => \"16847\",\n                                                   -subject_term => $subject,\n                                                   -object_term  => $object,\n                                                   -predicate_term => $type );\n Function: Creates a new Bio::Ontology::Relationship.\n Returns : A new Bio::Ontology::Relationship object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $identifier,\n         $subject_term,\n\t\t\t$child,        # for backwards compatibility\n         $object_term,\n\t\t\t$parent,       # for backwards compatibility\n         $predicate_term,\n\t\t\t$reltype,      # for backwards compatibility\n\t\t\t$ont)\n\t= $self->_rearrange( [qw( IDENTIFIER\n\t\t\t\t  SUBJECT_TERM\n\t\t\t\t  CHILD_TERM\n\t\t\t\t  OBJECT_TERM\n\t\t\t\t  PARENT_TERM\n\t\t\t\t  PREDICATE_TERM\n\t\t\t\t  RELATIONSHIP_TYPE\n\t\t\t\t  ONTOLOGY)\n\t\t\t      ], @args );\n   \n    $self->init(); \n    \n    $self->identifier( $identifier );\n    $subject_term = $child unless $subject_term;\n    $object_term = $parent unless $object_term;\n    $predicate_term = $reltype unless $predicate_term;\n    $self->subject_term( $subject_term) if $subject_term;\n    $self->object_term( $object_term) if $object_term;\n    $self->predicate_term( $predicate_term ) if $predicate_term;\n    $self->ontology($ont) if $ont;\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Relationship to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n    \n    $self->{ \"_identifier\" }     = undef;\n    $self->{ \"_subject_term\" }   = undef;\n    $self->{ \"_object_term\" }    = undef;\n    $self->{ \"_predicate_term\" } = undef;\n    $self->ontology(undef);\n   \n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $rel->identifier( \"100050\" );\n           or\n           print $rel->identifier();\n Function: Set/get for the identifier of this Relationship.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_identifier\" } = $value;\n    }\n\n    return $self->{ \"_identifier\" };\n} # identifier\n\n\n\n\n=head2 subject_term\n\n Title   : subject_term\n Usage   : $rel->subject_term( $subject );\n           or\n           $subject = $rel->subject_term();\n Function: Set/get for the subject term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The subject term [Bio::Ontology::TermI].\n Args    : The subject term [Bio::Ontology::TermI] (optional).\n\n\nsub subject_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_subject_term\" } = $term;\n    }\n\n    return $self->{ \"_subject_term\" };\n    \n} # subject_term\n\n\n\n=head2 object_term\n\n Title   : object_term\n Usage   : $rel->object_term( $object );\n           or\n           $object = $rel->object_term();\n Function: Set/get for the object term of this Relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The object term [Bio::Ontology::TermI].\n Args    : The object term [Bio::Ontology::TermI] (optional).\n\n\nsub object_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_object_term\" } = $term;\n    }\n\n    return $self->{ \"_object_term\" };\n}\n\n\n\n=head2 predicate_term\n\n Title   : predicate_term\n Usage   : $rel->predicate_term( $type );\n           or\n           $type = $rel->predicate_term();\n Function: Set/get for the predicate (relationship type) of this\n           relationship.\n\n           The common convention for ontologies is to express\n           relationships between terms as triples (subject, predicate,\n           object).\n\n Returns : The predicate term [Bio::Ontology::TermI].\n Args    : The predicate term [Bio::Ontology::TermI] (optional).\n\n\nsub predicate_term {\n    my ( $self, $term ) = @_;\n  \n    if ( defined $term ) {\n        $self->_check_class( $term, \"Bio::Ontology::TermI\" );\n        $self->{ \"_predicate_term\" } = $term;\n    }\n\n    return $self->{ \"_predicate_term\" };\n}\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $obj->ontology()\n Function: Get/set the ontology that defined this relationship.\n Example : \n Returns : an object implementing L<Bio::Ontology::OntologyI>\n Args    : on set, undef or an object implementing \n           Bio::Ontology::OntologyI (optional)\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology{\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n\t$ont = shift;\n\tif($ont) {\n\t    $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n\t    if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n\t\t$self->throw(ref($ont).\" does not implement \".\n\t\t\t     \"Bio::Ontology::OntologyI. Bummer.\");\n\t    }\n\t} \n\treturn $self->{\"_ontology\"} = $ont;\n    } \n    return $self->{\"_ontology\"};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $rel->to_string();\n Function: to_string method for Relationship.\n Returns : A string representation of this Relationship.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":362,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string"},{"localvar":"my","containerName":"to_string","name":"$s","definition":"my","line":366,"kind":13},{"line":368,"kind":13,"containerName":"to_string","name":"$s"},{"line":369,"kind":13,"containerName":"to_string","name":"$s"},{"line":369,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":369,"containerName":"to_string","name":"identifier"},{"name":"$s","containerName":"to_string","kind":13,"line":370},{"line":371,"kind":13,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$self","kind":13,"line":371},{"kind":12,"line":371,"containerName":"to_string","name":"subject_term"},{"kind":12,"line":371,"containerName":"to_string","name":"identifier"},{"containerName":"to_string","name":"$s","line":372,"kind":13},{"containerName":"to_string","name":"$s","kind":13,"line":373},{"kind":13,"line":373,"name":"$self","containerName":"to_string"},{"kind":12,"line":373,"containerName":"to_string","name":"object_term"},{"name":"identifier","containerName":"to_string","line":373,"kind":12},{"containerName":"to_string","name":"$s","line":374,"kind":13},{"containerName":"to_string","name":"$s","kind":13,"line":375},{"line":375,"kind":13,"containerName":"to_string","name":"$self"},{"line":375,"kind":12,"name":"predicate_term","containerName":"to_string"},{"line":375,"kind":12,"containerName":"to_string","name":"identifier"},{"name":"$s","containerName":"to_string","line":377,"kind":13}],"line":361,"kind":12},{"name":"_check_class","range":{"start":{"character":0,"line":383},"end":{"character":9999,"line":396}},"kind":12,"children":[{"line":384,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_check_class"},{"containerName":"_check_class","name":"$value","kind":13,"line":384},{"containerName":"_check_class","name":"$expected_class","kind":13,"line":384},{"containerName":"_check_class","name":"$value","kind":13,"line":386},{"line":387,"kind":13,"containerName":"_check_class","name":"$self"},{"kind":12,"line":387,"containerName":"_check_class","name":"throw"},{"containerName":"_check_class","name":"$value","line":389,"kind":13},{"containerName":"_check_class","name":"$self","line":390,"kind":13},{"kind":12,"line":390,"containerName":"_check_class","name":"throw"},{"kind":13,"line":392,"containerName":"_check_class","name":"$value"},{"name":"isa","containerName":"_check_class","line":392,"kind":12},{"kind":13,"line":392,"name":"$expected_class","containerName":"_check_class"},{"line":393,"kind":13,"containerName":"_check_class","name":"$self"},{"name":"throw","containerName":"_check_class","kind":12,"line":393},{"line":393,"kind":13,"name":"$value","containerName":"_check_class"}],"line":383,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"label":"_check_class($self,$value,$expected_class)"},"detail":"($self,$value,$expected_class)"}]}