{"version":5,"vars":[{"kind":2,"line":115,"name":"base","containerName":""},{"kind":13,"line":119,"definition":"my","name":"%ont_store_by_name","containerName":null,"localvar":"my"},{"kind":13,"line":120,"definition":"my","name":"%ont_store_by_id","containerName":null,"localvar":"my"},{"line":121,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%ont_aliases"},{"localvar":"my","name":"$instance","definition":"my","containerName":null,"line":125,"kind":13},{"kind":12,"children":[{"kind":12,"line":146,"containerName":"new","name":"get_instance"}],"line":145,"name":"new","definition":"sub","containerName":"main::","range":{"start":{"line":145,"character":0},"end":{"character":9999,"line":147}}},{"range":{"end":{"line":179,"character":9999},"start":{"line":172,"character":0}},"name":"get_instance","children":[{"localvar":"my","containerName":"get_instance","name":"$self","definition":"my","line":173,"kind":13},{"name":"@args","containerName":"get_instance","kind":13,"line":173},{"containerName":"get_instance","name":"$instance","line":175,"kind":13},{"containerName":"get_instance","name":"$instance","kind":13,"line":176},{"line":176,"kind":13,"containerName":"get_instance","name":"$self"},{"kind":13,"line":176,"containerName":"get_instance","name":"@args"},{"containerName":"get_instance","name":"$instance","kind":13,"line":178}],"line":172,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.","label":"get_instance($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"kind":12,"line":176,"name":"SUPER","containerName":"new"},{"name":"get_ontology","range":{"start":{"character":0,"line":211},"end":{"line":254,"character":9999}},"kind":12,"children":[{"kind":13,"line":212,"definition":"my","name":"$self","containerName":"get_ontology","localvar":"my"},{"containerName":"get_ontology","name":"@args","kind":13,"line":212},{"kind":13,"line":213,"definition":"my","name":"$ont","containerName":"get_ontology","localvar":"my"},{"kind":13,"line":215,"name":"$name","definition":"my","containerName":"get_ontology","localvar":"my"},{"name":"$id","containerName":"get_ontology","kind":13,"line":215},{"containerName":"get_ontology","name":"$self","line":215,"kind":13},{"line":215,"kind":12,"containerName":"get_ontology","name":"_rearrange"},{"containerName":"get_ontology","name":"@args","line":215,"kind":13},{"containerName":"get_ontology","name":"$id","kind":13,"line":216},{"name":"$ont","containerName":"get_ontology","line":217,"kind":13},{"containerName":"get_ontology","name":"$ont_store_by_id","line":217,"kind":13},{"containerName":"get_ontology","name":"$id","kind":13,"line":217},{"containerName":"get_ontology","name":"$ont","line":218,"kind":13},{"containerName":"get_ontology","name":"$name","kind":13,"line":221},{"line":222,"kind":13,"localvar":"my","containerName":"get_ontology","name":"$o","definition":"my"},{"containerName":"get_ontology","name":"$ont_store_by_name","line":222,"kind":13},{"containerName":"get_ontology","name":"$name","kind":13,"line":222},{"containerName":"get_ontology","name":"$o","line":224,"kind":13},{"localvar":"my","definition":"my","name":"$doc_registry","containerName":"get_ontology","line":225,"kind":13},{"line":225,"kind":12,"name":"get_instance","containerName":"get_ontology"},{"line":226,"kind":13,"localvar":"my","containerName":"get_ontology","definition":"my","name":"$url"},{"line":226,"kind":13,"containerName":"get_ontology","name":"$def"},{"containerName":"get_ontology","name":"$fmt","line":226,"kind":13},{"containerName":"get_ontology","name":"$doc_registry","line":226,"kind":13},{"containerName":"get_ontology","name":"documents","line":226,"kind":12},{"kind":13,"line":226,"containerName":"get_ontology","name":"$name"},{"kind":13,"line":228,"containerName":"get_ontology","name":"$url"},{"kind":13,"line":229,"definition":"my","name":"$io","containerName":"get_ontology","localvar":"my"},{"containerName":"get_ontology","name":"new","line":229,"kind":12},{"kind":13,"line":229,"containerName":"get_ontology","name":"$url"},{"containerName":"get_ontology","name":"$def","line":230,"kind":13},{"name":"$fmt","containerName":"get_ontology","kind":13,"line":231},{"name":"$o","containerName":"get_ontology","line":234,"kind":13},{"line":234,"kind":13,"containerName":"get_ontology","name":"$io"},{"containerName":"get_ontology","name":"next_ontology","line":234,"kind":12},{"kind":13,"line":235,"containerName":"get_ontology","name":"$ont_store_by_name"},{"containerName":"get_ontology","name":"$name","line":235,"kind":13},{"name":"$o","containerName":"get_ontology","kind":13,"line":235},{"containerName":"get_ontology","name":"$url","line":236,"kind":13},{"kind":13,"line":237,"containerName":"get_ontology","name":"$io","definition":"my","localvar":"my"},{"containerName":"get_ontology","name":"new","line":237,"kind":12},{"kind":13,"line":237,"name":"$url","containerName":"get_ontology"},{"kind":13,"line":238,"name":"$def","containerName":"get_ontology"},{"name":"$fmt","containerName":"get_ontology","kind":13,"line":239},{"name":"$o","containerName":"get_ontology","line":241,"kind":13},{"containerName":"get_ontology","name":"$io","line":241,"kind":13},{"kind":12,"line":241,"name":"next_ontology","containerName":"get_ontology"},{"containerName":"get_ontology","name":"$ont_store_by_name","line":242,"kind":13},{"line":242,"kind":13,"containerName":"get_ontology","name":"$name"},{"containerName":"get_ontology","name":"$o","line":242,"kind":13},{"line":246,"kind":13,"name":"$ont","containerName":"get_ontology"},{"line":246,"kind":13,"containerName":"get_ontology","name":"$ont"},{"kind":12,"line":246,"containerName":"get_ontology","name":"identifier"},{"kind":13,"line":246,"name":"$o","containerName":"get_ontology"},{"containerName":"get_ontology","name":"identifier","line":246,"kind":12},{"containerName":"get_ontology","name":"$ont","line":247,"kind":13},{"name":"$o","containerName":"get_ontology","line":247,"kind":13},{"containerName":"get_ontology","name":"$ont","line":249,"kind":13},{"kind":13,"line":253,"containerName":"get_ontology","name":"$ont"}],"line":211,"definition":"sub","containerName":"main::","signature":{"label":"get_ontology($self,@args)","documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)"},{"kind":12,"line":225,"containerName":"Ontology::DocumentRegistry","name":"Bio"},{"containerName":"OntologyIO","name":"Bio","kind":12,"line":229},{"containerName":"OntologyIO","name":"Bio","kind":12,"line":237},{"kind":12,"line":271,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"register_ontology","line":272,"kind":13},{"line":272,"kind":13,"containerName":"register_ontology","name":"@args"},{"localvar":"my","containerName":"register_ontology","definition":"my","name":"$ret","line":273,"kind":13},{"localvar":"my","containerName":"register_ontology","name":"$ont","definition":"my","line":274,"kind":13},{"line":274,"kind":13,"name":"@args","containerName":"register_ontology"},{"kind":13,"line":275,"containerName":"register_ontology","name":"$ont"},{"name":"$ont","containerName":"register_ontology","kind":13,"line":275},{"containerName":"register_ontology","name":"isa","line":275,"kind":12},{"line":276,"kind":13,"containerName":"register_ontology","name":"$ont_store_by_name"},{"kind":13,"line":276,"name":"$ont","containerName":"register_ontology"},{"kind":12,"line":276,"containerName":"register_ontology","name":"name"},{"name":"$ont","containerName":"register_ontology","kind":13,"line":276},{"name":"$ont","containerName":"register_ontology","line":276,"kind":13},{"line":276,"kind":12,"containerName":"register_ontology","name":"name"},{"kind":13,"line":280,"containerName":"register_ontology","name":"$ont"},{"line":280,"kind":13,"name":"$ont","containerName":"register_ontology"},{"kind":12,"line":280,"containerName":"register_ontology","name":"isa"},{"containerName":"register_ontology","name":"$self","kind":13,"line":281},{"name":"throw","containerName":"register_ontology","kind":12,"line":281},{"containerName":"register_ontology","name":"$ont","kind":13,"line":281},{"kind":13,"line":281,"containerName":"register_ontology","name":"$ont"},{"line":281,"kind":13,"name":"$ont","containerName":"register_ontology"},{"line":284,"kind":13,"name":"$self","containerName":"register_ontology"},{"name":"get_ontology","containerName":"register_ontology","line":284,"kind":12},{"line":284,"kind":13,"name":"$ont","containerName":"register_ontology"},{"kind":12,"line":284,"containerName":"register_ontology","name":"name"},{"kind":13,"line":285,"containerName":"register_ontology","name":"$self"},{"line":285,"kind":12,"containerName":"register_ontology","name":"warn"},{"line":285,"kind":13,"name":"$ont","containerName":"register_ontology"},{"kind":12,"line":285,"containerName":"register_ontology","name":"name"},{"kind":13,"line":287,"containerName":"register_ontology","name":"$ret"},{"kind":13,"line":290,"containerName":"register_ontology","name":"$self"},{"line":290,"kind":12,"containerName":"register_ontology","name":"get_ontology"},{"line":290,"kind":13,"containerName":"register_ontology","name":"$ont"},{"name":"identifier","containerName":"register_ontology","kind":12,"line":290},{"kind":13,"line":291,"name":"$self","containerName":"register_ontology"},{"name":"warn","containerName":"register_ontology","line":291,"kind":12},{"name":"$ont","containerName":"register_ontology","kind":13,"line":291},{"line":291,"kind":12,"containerName":"register_ontology","name":"identifier"},{"name":"$ret","containerName":"register_ontology","kind":13,"line":293},{"kind":13,"line":296,"containerName":"register_ontology","name":"$ont_store_by_name"},{"line":296,"kind":13,"name":"$ont","containerName":"register_ontology"},{"name":"name","containerName":"register_ontology","line":296,"kind":12},{"line":296,"kind":13,"containerName":"register_ontology","name":"$ont"},{"line":297,"kind":13,"name":"$ont_store_by_id","containerName":"register_ontology"},{"line":297,"kind":13,"containerName":"register_ontology","name":"$ont"},{"kind":12,"line":297,"containerName":"register_ontology","name":"identifier"},{"line":297,"kind":13,"containerName":"register_ontology","name":"$ont"},{"line":299,"kind":13,"containerName":"register_ontology","name":"$ret"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"register_ontology($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub get_ontology{\n  my ($self,@args) = @_;\n  my $ont;\n\n  my ($name,$id) = $self->_rearrange([qw(NAME ID)], @args);\n  if($id) {\n    $ont = $ont_store_by_id{$id};\n    return unless $ont; # no AND can be satisfied in this case\n  }\n\n  if($name) {\n    my $o = $ont_store_by_name{$name};\n\n    if(!$o){\n      my $doc_registry = Bio::Ontology::DocumentRegistry->get_instance();\n      my($url,$def,$fmt) = $doc_registry->documents($name);\n\n      if(ref($url) eq 'ARRAY'){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n\n        $o = $io->next_ontology();\n        $ont_store_by_name{$name} = $o;\n      } elsif($url){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n        $o = $io->next_ontology;\n        $ont_store_by_name{$name} = $o;\n      }\n    }\n\n    if((! $ont) || ($ont->identifier() eq $o->identifier())) {\n      $ont = $o;\n    } else {\n      $ont = undef;\n    }\n  }\n  \n  return $ont;\n}\n\n=head2 register_ontology\n\n Title   : register_ontology\n Usage   :\n Function: Registers the given Ontology object for later retrieval\n           by name and identifier.\n\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI object(s) to register\n\nSee L<Bio::Ontology::OntologyI>."},"name":"register_ontology","range":{"end":{"character":9999,"line":300},"start":{"line":271,"character":0}}},{"name":"remove_ontology","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":328},"start":{"character":0,"line":316}},"kind":12,"children":[{"kind":13,"line":317,"definition":"my","name":"$self","containerName":"remove_ontology","localvar":"my"},{"definition":"my","name":"$ret","containerName":"remove_ontology","localvar":"my","kind":13,"line":318},{"name":"$ont","definition":"my","containerName":"remove_ontology","localvar":"my","kind":13,"line":320},{"line":321,"kind":13,"containerName":"remove_ontology","name":"$self"},{"line":321,"kind":12,"containerName":"remove_ontology","name":"throw"},{"name":"$ont","containerName":"remove_ontology","line":321,"kind":13},{"name":"$ont","containerName":"remove_ontology","line":322,"kind":13},{"containerName":"remove_ontology","name":"$ont","kind":13,"line":322},{"line":322,"kind":13,"name":"$ont","containerName":"remove_ontology"},{"name":"isa","containerName":"remove_ontology","line":322,"kind":12},{"name":"$ont_store_by_id","containerName":"remove_ontology","line":324,"kind":13},{"kind":13,"line":324,"containerName":"remove_ontology","name":"$ont"},{"name":"identifier","containerName":"remove_ontology","kind":12,"line":324},{"containerName":"remove_ontology","name":"$ont_store_by_name","kind":13,"line":325},{"line":325,"kind":13,"name":"$ont","containerName":"remove_ontology"},{"kind":12,"line":325,"name":"name","containerName":"remove_ontology"},{"containerName":"remove_ontology","name":"$ont","kind":13,"line":325},{"containerName":"remove_ontology","name":"name","kind":12,"line":325}],"line":316},{"name":"guess_ontology","range":{"start":{"line":344,"character":0},"end":{"line":356,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"guess_ontology","line":345,"kind":13},{"name":"$id","containerName":"guess_ontology","kind":13,"line":345},{"name":"$prefix","definition":"my","containerName":"guess_ontology","localvar":"my","kind":13,"line":347},{"name":"$id","containerName":"guess_ontology","line":347,"kind":13},{"kind":13,"line":349,"containerName":"guess_ontology","definition":"my","name":"%prefix","localvar":"my"},{"line":355,"kind":13,"containerName":"guess_ontology","name":"$prefix"},{"name":"$prefix","containerName":"guess_ontology","line":355,"kind":13}],"line":344,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub get_ontology{\n  my ($self,@args) = @_;\n  my $ont;\n\n  my ($name,$id) = $self->_rearrange([qw(NAME ID)], @args);\n  if($id) {\n    $ont = $ont_store_by_id{$id};\n    return unless $ont; # no AND can be satisfied in this case\n  }\n\n  if($name) {\n    my $o = $ont_store_by_name{$name};\n\n    if(!$o){\n      my $doc_registry = Bio::Ontology::DocumentRegistry->get_instance();\n      my($url,$def,$fmt) = $doc_registry->documents($name);\n\n      if(ref($url) eq 'ARRAY'){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n\n        $o = $io->next_ontology();\n        $ont_store_by_name{$name} = $o;\n      } elsif($url){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n        $o = $io->next_ontology;\n        $ont_store_by_name{$name} = $o;\n      }\n    }\n\n    if((! $ont) || ($ont->identifier() eq $o->identifier())) {\n      $ont = $o;\n    } else {\n      $ont = undef;\n    }\n  }\n  \n  return $ont;\n}\n\n=head2 register_ontology\n\n Title   : register_ontology\n Usage   :\n Function: Registers the given Ontology object for later retrieval\n           by name and identifier.\n\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI object(s) to register\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub register_ontology {\n  my ($self,@args) = @_;\n  my $ret = 1;\n  foreach my $ont (@args) {\n    if(ref($ont) && $ont->isa('Bio::Ontology::OntologyI')){\n      $ont_store_by_name{$ont->name()} = $ont if $ont->name;\n      next;\n    }\n\n\tif(! (ref($ont) && $ont->isa(\"Bio::Ontology::OntologyI\"))) {\n      $self->throw((ref($ont) ? ref($ont) : $ont).\" does not implement \".\n                   \"Bio::Ontology::OntologyI or is not an object\");\n\t}\n\tif($self->get_ontology(-name => $ont->name())) {\n      $self->warn(\"ontology with name \\\"\".$ont->name().\n                  \"\\\" already exists in the store, ignoring new one\");\n      $ret = 0;\n      next;\n\t}\n\tif($self->get_ontology(-id => $ont->identifier())) {\n      $self->warn(\"ontology with id \\\"\".$ont->identifier().\n                  \"\\\" already exists in the store, ignoring new one\");\n      $ret = 0;\n      next;\n\t}\n\t$ont_store_by_name{$ont->name()} = $ont;\n\t$ont_store_by_id{$ont->identifier()} = $ont;\n  }\n  return $ret;\n}\n\n=head2 remove_ontology\n\n Title   : remove_ontology\n Usage   :\n Function: Remove the specified ontology from the store.\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI implementing object(s)\n           to be removed from the store\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub remove_ontology{\n    my $self = shift;\n    my $ret = 1;\n\n    foreach my $ont (@_) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\")\n\t    unless $ont && ref($ont) && $ont->isa(\"Bio::Ontology::OntologyI\");\n\t# remove it from both the id hash and the name hash\n\tdelete $ont_store_by_id{$ont->identifier()};\n\tdelete $ont_store_by_name{$ont->name()} if $ont->name();\n    }\n    return 1;\n}\n\n=head2 guess_ontology()\n\n Usage   : my $ontology = \n           Bio::Ontology::OntologyStore->guess_ontology('GO:0000001');\n Function: tries to guess which ontology a term identifier comes from, \n           loads it as necessary,\n           and returns it as a Bio::Ontology::Ontology object.\n Example :\n Returns : a Bio::Ontology::Ontology object, or warns and returns undef\n Args    : an ontology term identifier in XXXX:DDDDDDD format.  \n           Guessing is based on the XXXX string before the colon.","label":"guess_ontology($self,$id)"},"detail":"($self,$id)"},{"kind":12,"line":350,"name":"SO"},{"name":"SOFA","kind":12,"line":351},{"line":352,"kind":12,"name":"GO"}]}