{"vars":[{"containerName":"main::","name":"INTERPRO_ID_DEFAULT","definition":1,"kind":14,"line":95},{"containerName":"Bio::Annotation::Reference","name":"strict","line":95,"kind":12},{"containerName":"","name":"base","line":97,"kind":2},{"name":"new","range":{"start":{"character":0,"line":120},"end":{"line":135,"character":9999}},"kind":12,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":121},{"name":"@args","containerName":"new","kind":13,"line":121},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":122},{"line":122,"kind":13,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":122},{"kind":13,"line":124,"containerName":"new","name":"$interpro_id","definition":"my","localvar":"my"},{"name":"$short_name","containerName":"new","line":125,"kind":13},{"kind":13,"line":126,"containerName":"new","name":"$self"},{"line":126,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":129},{"kind":13,"line":131,"name":"$interpro_id","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":131},{"kind":12,"line":131,"containerName":"new","name":"interpro_id"},{"line":131,"kind":13,"name":"$interpro_id","containerName":"new"},{"containerName":"new","name":"$short_name","kind":13,"line":132},{"line":132,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"short_name","kind":12,"line":132},{"kind":13,"line":132,"name":"$short_name","containerName":"new"},{"kind":13,"line":134,"name":"$self","containerName":"new"}],"line":120,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)"},{"containerName":"new","name":"SUPER","kind":12,"line":122},{"range":{"end":{"line":159,"character":9999},"start":{"character":0,"line":149}},"containerName":"main::","definition":"sub","name":"init","line":149,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"init","line":150,"kind":13},{"containerName":"init","name":"$self","kind":13,"line":153},{"name":"$self","containerName":"init","line":156,"kind":13},{"containerName":"init","name":"interpro_id","line":156,"kind":12},{"kind":13,"line":157,"containerName":"init","name":"$self"},{"name":"short_name","containerName":"init","line":157,"kind":12}],"kind":12},{"name":"SUPER","containerName":"init","line":153,"kind":12},{"line":156,"kind":12,"name":"INTERPRO_ID_DEFAULT"},{"line":173,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_check_interpro_id","line":174,"kind":13},{"line":174,"kind":13,"name":"$value","containerName":"_check_interpro_id"},{"line":176,"kind":13,"name":"$self","containerName":"_check_interpro_id"},{"line":176,"kind":12,"containerName":"_check_interpro_id","name":"throw"},{"name":"$value","containerName":"_check_interpro_id","kind":13,"line":176},{"line":177,"kind":13,"containerName":"_check_interpro_id","name":"$value"},{"line":178,"kind":13,"name":"$value","containerName":"_check_interpro_id"},{"line":180,"kind":13,"containerName":"_check_interpro_id","name":"$value"}],"kind":12,"detail":"($self,$value)","signature":{"label":"_check_interpro_id($self,$value)","documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":181,"character":9999},"start":{"character":0,"line":173}},"name":"_check_interpro_id"},{"name":"INTERPRO_ID_DEFAULT","kind":12,"line":178},{"range":{"start":{"line":195,"character":0},"end":{"line":204,"character":9999}},"name":"interpro_id","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)","label":"interpro_id($self,$value)"},"containerName":"main::","definition":"sub","line":195,"children":[{"localvar":"my","containerName":"interpro_id","definition":"my","name":"$self","line":196,"kind":13},{"kind":13,"line":196,"name":"$value","containerName":"interpro_id"},{"kind":13,"line":198,"containerName":"interpro_id","name":"$value"},{"line":199,"kind":13,"name":"$value","containerName":"interpro_id"},{"line":199,"kind":13,"name":"$self","containerName":"interpro_id"},{"kind":12,"line":199,"name":"_check_interpro_id","containerName":"interpro_id"},{"line":199,"kind":13,"name":"$value","containerName":"interpro_id"},{"kind":13,"line":200,"containerName":"interpro_id","name":"$self"},{"containerName":"interpro_id","name":"identifier","kind":12,"line":200},{"kind":13,"line":200,"name":"$value","containerName":"interpro_id"},{"kind":13,"line":203,"name":"$self","containerName":"interpro_id"},{"kind":12,"line":203,"name":"identifier","containerName":"interpro_id"}],"kind":12},{"detail":"($self,$value)","signature":{"label":"short_name($self,$value)","documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":218,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"short_name","line":219,"kind":13},{"kind":13,"line":219,"containerName":"short_name","name":"$value"},{"name":"$value","containerName":"short_name","line":221,"kind":13},{"line":222,"kind":13,"name":"$self","containerName":"short_name"},{"kind":13,"line":222,"containerName":"short_name","name":"$value"},{"line":222,"kind":13,"name":"$value","containerName":"short_name"},{"kind":13,"line":225,"containerName":"short_name","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":226},"start":{"character":0,"line":218}},"name":"short_name"},{"range":{"end":{"character":9999,"line":248},"start":{"line":240,"character":0}},"name":"protein_count","children":[{"containerName":"protein_count","name":"$self","definition":"my","localvar":"my","kind":13,"line":241},{"line":241,"kind":13,"name":"$value","containerName":"protein_count"},{"kind":13,"line":243,"name":"$value","containerName":"protein_count"},{"containerName":"protein_count","name":"$self","kind":13,"line":244},{"line":244,"kind":13,"name":"$value","containerName":"protein_count"},{"kind":13,"line":244,"name":"$value","containerName":"protein_count"},{"containerName":"protein_count","name":"$self","kind":13,"line":247}],"line":240,"kind":12,"signature":{"label":"protein_count($self,$value)","documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"range":{"end":{"line":265,"character":9999},"start":{"character":0,"line":262}},"containerName":"main::","definition":"sub","name":"get_references","line":262,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_references","line":263,"kind":13},{"kind":13,"line":265,"name":"$self","containerName":"get_references"}],"kind":12},{"containerName":null,"name":"%self","line":265,"kind":13},{"kind":12,"line":281,"children":[{"definition":"my","name":"$self","containerName":"add_reference","localvar":"my","kind":13,"line":282},{"kind":13,"line":284,"containerName":"add_reference","name":"$self"},{"containerName":"add_reference","name":"$self","kind":13,"line":284},{"name":"$self","containerName":"add_reference","kind":13,"line":285}],"containerName":"main::","definition":"sub","name":"add_reference","range":{"end":{"character":9999,"line":285},"start":{"line":281,"character":0}}},{"kind":12,"children":[{"line":302,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"remove_references"},{"kind":13,"line":304,"containerName":"remove_references","definition":"my","name":"@arr","localvar":"my"},{"containerName":"remove_references","name":"$self","line":304,"kind":13},{"kind":12,"line":304,"name":"get_references","containerName":"remove_references"},{"line":305,"kind":13,"name":"$self","containerName":"remove_references"},{"name":"@arr","containerName":"remove_references","kind":13,"line":306}],"line":301,"name":"remove_references","definition":"sub","containerName":"main::","range":{"start":{"line":301,"character":0},"end":{"character":9999,"line":307}}},{"range":{"end":{"line":324,"character":9999},"start":{"character":0,"line":321}},"definition":"sub","name":"get_members","containerName":"main::","children":[{"kind":13,"line":322,"containerName":"get_members","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":324,"containerName":"get_members","name":"$self"}],"line":321,"kind":12},{"line":324,"kind":13,"name":"%self","containerName":null},{"line":340,"children":[{"line":341,"kind":13,"localvar":"my","containerName":"add_member","name":"$self","definition":"my"},{"name":"$self","containerName":"add_member","kind":13,"line":343},{"kind":13,"line":343,"name":"$self","containerName":"add_member"},{"kind":13,"line":344,"containerName":"add_member","name":"$self"}],"kind":12,"range":{"start":{"line":340,"character":0},"end":{"character":9999,"line":344}},"containerName":"main::","definition":"sub","name":"add_member"},{"containerName":"main::","definition":"sub","name":"remove_members","range":{"start":{"character":0,"line":360},"end":{"character":9999,"line":366}},"kind":12,"line":360,"children":[{"line":361,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"remove_members"},{"localvar":"my","definition":"my","name":"@arr","containerName":"remove_members","line":363,"kind":13},{"containerName":"remove_members","name":"$self","kind":13,"line":363},{"line":363,"kind":12,"name":"get_members","containerName":"remove_members"},{"name":"$self","containerName":"remove_members","line":364,"kind":13},{"name":"@arr","containerName":"remove_members","kind":13,"line":365}]},{"range":{"start":{"line":383,"character":0},"end":{"line":386,"character":9999}},"containerName":"main::","definition":"sub","name":"get_examples","line":383,"children":[{"line":384,"kind":13,"localvar":"my","containerName":"get_examples","definition":"my","name":"$self"},{"line":386,"kind":13,"containerName":"get_examples","name":"$self"}],"kind":12},{"kind":13,"line":386,"containerName":null,"name":"%self"},{"kind":12,"children":[{"localvar":"my","containerName":"add_example","definition":"my","name":"$self","line":406,"kind":13},{"kind":13,"line":408,"name":"$self","containerName":"add_example"},{"line":408,"kind":13,"containerName":"add_example","name":"$self"},{"kind":13,"line":409,"containerName":"add_example","name":"$self"}],"line":405,"name":"add_example","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":409},"start":{"line":405,"character":0}}},{"kind":12,"line":428,"children":[{"localvar":"my","containerName":"remove_examples","name":"$self","definition":"my","line":429,"kind":13},{"line":431,"kind":13,"localvar":"my","containerName":"remove_examples","definition":"my","name":"@arr"},{"name":"$self","containerName":"remove_examples","line":431,"kind":13},{"kind":12,"line":431,"containerName":"remove_examples","name":"get_examples"},{"name":"$self","containerName":"remove_examples","line":432,"kind":13},{"line":433,"kind":13,"containerName":"remove_examples","name":"@arr"}],"containerName":"main::","name":"remove_examples","definition":"sub","range":{"end":{"character":9999,"line":434},"start":{"character":0,"line":428}}},{"range":{"start":{"character":0,"line":451},"end":{"character":9999,"line":454}},"containerName":"main::","name":"get_external_documents","definition":"sub","line":451,"children":[{"line":452,"kind":13,"localvar":"my","containerName":"get_external_documents","name":"$self","definition":"my"},{"line":454,"kind":13,"containerName":"get_external_documents","name":"$self"}],"kind":12},{"containerName":null,"name":"%self","kind":13,"line":454},{"range":{"end":{"line":477,"character":9999},"start":{"line":473,"character":0}},"containerName":"main::","definition":"sub","name":"add_external_document","line":473,"children":[{"kind":13,"line":474,"definition":"my","name":"$self","containerName":"add_external_document","localvar":"my"},{"containerName":"add_external_document","name":"$self","kind":13,"line":476},{"name":"$self","containerName":"add_external_document","kind":13,"line":476},{"name":"$self","containerName":"add_external_document","kind":13,"line":477}],"kind":12},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"remove_external_documents","localvar":"my","kind":13,"line":497},{"definition":"my","name":"@arr","containerName":"remove_external_documents","localvar":"my","kind":13,"line":499},{"containerName":"remove_external_documents","name":"$self","kind":13,"line":499},{"kind":12,"line":499,"name":"get_external_documents","containerName":"remove_external_documents"},{"line":500,"kind":13,"name":"$self","containerName":"remove_external_documents"},{"line":501,"kind":13,"containerName":"remove_external_documents","name":"@arr"}],"line":496,"name":"remove_external_documents","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":502},"start":{"character":0,"line":496}}},{"name":"class_list","range":{"end":{"line":524,"character":9999},"start":{"line":516,"character":0}},"kind":12,"line":516,"children":[{"line":517,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"class_list"},{"kind":13,"line":517,"name":"$value","containerName":"class_list"},{"containerName":"class_list","name":"$value","line":519,"kind":13},{"line":520,"kind":13,"containerName":"class_list","name":"$self"},{"containerName":"class_list","name":"$value","line":520,"kind":13},{"containerName":"class_list","name":"$self","line":523,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub protein_count{\n  my ($self,$value) = @_;\n\n  if( defined $value) {\n    $self->{'protein_count'} = $value ? $value : undef;\n  }\n\n  return $self->{'protein_count'};\n}\n\n=head2 get_references\n\n Title   : get_references\n Usage   :\n Function: Get the references for this InterPro term.\n Example :\n Returns : An array of L<Bio::Annotation::Reference> objects\n Args    :\n\n\n\nsub get_references{\n    my $self = shift;\n\n    return @{$self->{\"_references\"}} if exists($self->{\"_references\"});\n    return ();\n}\n\n=head2 add_reference\n\n Title   : add_reference\n Usage   :\n Function: Add one or more references to this InterPro term.\n Example :\n Returns : \n Args    : One or more L<Bio::Annotation::Reference> objects.\n\n\n\nsub add_reference{\n    my $self = shift;\n\n    $self->{\"_references\"} = [] unless exists($self->{\"_references\"});\n    push(@{$self->{\"_references\"}}, @_);\n}\n\n=head2 remove_references\n\n Title   : remove_references\n Usage   :\n Function: Remove all references for this InterPro term.\n Example :\n Returns : The list of previous references as an array of\n           L<Bio::Annotation::Reference> objects.\n Args    :\n\n\n\nsub remove_references{\n    my $self = shift;\n\n    my @arr = $self->get_references();\n    $self->{\"_references\"} = [];\n    return @arr;\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : @arr = get_members()\n Function: Get the list of member(s) for this object.\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_members{\n    my $self = shift;\n\n    return @{$self->{'_members'}} if exists($self->{'_members'});\n    return ();\n}\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Add one or more member(s) to this object.\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_member{\n    my $self = shift;\n\n    $self->{'_members'} = [] unless exists($self->{'_members'});\n    push(@{$self->{'_members'}}, @_);\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove all members for this class.\n Example :\n Returns : The list of previous members as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @arr = $self->get_members();\n    $self->{'_members'} = [];\n    return @arr;\n}\n\n=head2 get_examples\n\n Title   : get_examples\n Usage   : @arr = get_examples()\n Function: Get the list of example(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_examples{\n    my $self = shift;\n\n    return @{$self->{'_examples'}} if exists($self->{'_examples'});\n    return ();\n}\n\n=head2 add_example\n\n Title   : add_example\n Usage   :\n Function: Add one or more example(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_example{\n    my $self = shift;\n\n    $self->{'_examples'} = [] unless exists($self->{'_examples'});\n    push(@{$self->{'_examples'}}, @_);\n}\n\n=head2 remove_examples\n\n Title   : remove_examples\n Usage   :\n Function: Remove all examples for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous examples as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_examples{\n    my $self = shift;\n\n    my @arr = $self->get_examples();\n    $self->{'_examples'} = [];\n    return @arr;\n}\n\n=head2 get_external_documents\n\n Title   : get_external_documents\n Usage   : @arr = get_external_documents()\n Function: Get the list of external_document(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_external_documents{\n    my $self = shift;\n\n    return @{$self->{'_external_documents'}} if exists($self->{'_external_documents'});\n    return ();\n}\n\n=head2 add_external_document\n\n Title   : add_external_document\n Usage   :\n Function: Add one or more external_document(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_external_document{\n    my $self = shift;\n\n    $self->{'_external_documents'} = [] unless exists($self->{'_external_documents'});\n    push(@{$self->{'_external_documents'}}, @_);\n}\n\n=head2 remove_external_documents\n\n Title   : remove_external_documents\n Usage   :\n Function: Remove all external_documents for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous external_documents as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_external_documents{\n    my $self = shift;\n\n    my @arr = $self->get_external_documents();\n    $self->{'_external_documents'} = [];\n    return @arr;\n}\n\n=head2 class_list\n\n Title   : class_list\n Usage   : $obj->class_list($newval)\n Function: Set/get for class list element of the InterPro xml schema\n Example : \n Returns : reference to an array of Bio::Annotation::DBLink objects\n Args    : reference to an array of Bio::Annotation::DBLink objects","label":"class_list($self,$value)"}},{"range":{"end":{"character":9999,"line":601},"start":{"character":0,"line":536}},"name":"to_string","detail":"($self)","signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: InterProTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::InterProTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::InterProTerm - Implementation of InterProI term interface\n\n=head1 SYNOPSIS\n\n  my $term = Bio::Ontology::InterProTerm->new( \n        -interpro_id => \"IPR000001\",\n\t\t  -name => \"Kringle\",\n\t\t  -definition => \"Kringles are autonomous structural domains ...\",\n\t\t  -ontology => \"Domain\"\n\t\t\t\t\t     );\n  print $term->interpro_id(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->ontology->name(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a simple extension of L<Bio::Ontology::Term> for InterPro terms.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::InterProTerm;\nuse strict;\n\nuse Bio::Annotation::Reference;\n\nuse constant INTERPRO_ID_DEFAULT => \"IPR000000\";\n\nuse base qw(Bio::Ontology::Term);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::InterProTerm->new( -interpro_id => \"IPR000002\",\n\t\t\t\t\t\t     -name => \"Cdc20/Fizzy\",\n\t\t\t\t\t\t     -definition => \"The Cdc20/Fizzy region is almost always ...\",\n\t\t\t\t\t\t     -ontology => \"Domain\"\n\t\t\t\t\t\t   );\n\n Function: Creates a new Bio::Ontology::InterProTerm.\n Example :\n Returns : A new Bio::Ontology::InterProTerm object.\n Args    :\n  -interpro_id => the InterPro ID of the term. Has the form IPRdddddd, where dddddd is a zero-padded six digit number\n  -name => the name of this InterPro term [scalar]\n  -definition => the definition/abstract of this InterPro term [scalar]\n  -ontology => ontology of InterPro terms [Bio::Ontology::OntologyI]\n  -comment => a comment [scalar]\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ( $interpro_id,\n       $short_name)\n      = $self->_rearrange( [qw( INTERPRO_ID\n\t\t\t\tSHORT_NAME\n\t\t\t\t)\n\t\t\t    ], @args );\n\n  $interpro_id && $self->interpro_id( $interpro_id );\n  $short_name && $self->short_name( $short_name );\n\n  return $self;\n}\n\n=head2 init\n\n Title   : init\n Usage   : $term->init();\n Function: Initializes this InterProTerm to all \"\" and empty lists.\n Example :\n Returns : \n Args    :\n\n\n\nsub init{\n    my $self = shift;\n\n    # first call the inherited version to properly chain up the hierarchy\n    $self->SUPER::init(@_);\n\n    # then only initialize what we implement ourselves here\n    $self->interpro_id( INTERPRO_ID_DEFAULT );\n    $self->short_name(\"\");\n\n}\n\n=head2 _check_interpro_id\n\n Title   : _check_interpro_id\n Usage   :\n Function: Performs simple check in order to validate that its argument has the form IPRdddddd, where dddddd is a zero-padded six digit number.\n Example :\n Returns : Returns its argument if valid, otherwise throws exception.\n Args    : String\n\n\n\nsub _check_interpro_id{\n  my ($self, $value) = @_;\n\n  $self->throw( \"InterPro ID \".$value.\" is incorrect\\n\" )\n    unless ( $value =~ /^IPR\\d{6}$/ ||\n\t     $value eq INTERPRO_ID_DEFAULT );\n\n  return $value;\n}\n\n=head2 interpro_id\n\n Title   : interpro_id\n Usage   : $obj->interpro_id($newval)\n Function: Set/get for the interpro_id of this InterProTerm\n Example : \n Returns : value of interpro_id (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub interpro_id{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $value = $self->_check_interpro_id($value);\n    return $self->identifier($value);\n  }\n\n  return $self->identifier();\n}\n\n=head2 short_name\n\n Title   : short_name\n Usage   : $obj->short_name($newval)\n Function: Set/get for the short name of this InterProTerm.\n Example : \n Returns : value of short_name (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub short_name{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'short_name'} = $value ? $value : undef;\n  }\n\n  return $self->{'short_name'};\n}\n\n=head2 protein_count\n\n Title   : protein_count\n Usage   : $obj->protein_count($newval)\n Function: Set/get for the protein count of this InterProTerm.\n Example : \n Returns : value of protein_count (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub protein_count{\n  my ($self,$value) = @_;\n\n  if( defined $value) {\n    $self->{'protein_count'} = $value ? $value : undef;\n  }\n\n  return $self->{'protein_count'};\n}\n\n=head2 get_references\n\n Title   : get_references\n Usage   :\n Function: Get the references for this InterPro term.\n Example :\n Returns : An array of L<Bio::Annotation::Reference> objects\n Args    :\n\n\n\nsub get_references{\n    my $self = shift;\n\n    return @{$self->{\"_references\"}} if exists($self->{\"_references\"});\n    return ();\n}\n\n=head2 add_reference\n\n Title   : add_reference\n Usage   :\n Function: Add one or more references to this InterPro term.\n Example :\n Returns : \n Args    : One or more L<Bio::Annotation::Reference> objects.\n\n\n\nsub add_reference{\n    my $self = shift;\n\n    $self->{\"_references\"} = [] unless exists($self->{\"_references\"});\n    push(@{$self->{\"_references\"}}, @_);\n}\n\n=head2 remove_references\n\n Title   : remove_references\n Usage   :\n Function: Remove all references for this InterPro term.\n Example :\n Returns : The list of previous references as an array of\n           L<Bio::Annotation::Reference> objects.\n Args    :\n\n\n\nsub remove_references{\n    my $self = shift;\n\n    my @arr = $self->get_references();\n    $self->{\"_references\"} = [];\n    return @arr;\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : @arr = get_members()\n Function: Get the list of member(s) for this object.\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_members{\n    my $self = shift;\n\n    return @{$self->{'_members'}} if exists($self->{'_members'});\n    return ();\n}\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Add one or more member(s) to this object.\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_member{\n    my $self = shift;\n\n    $self->{'_members'} = [] unless exists($self->{'_members'});\n    push(@{$self->{'_members'}}, @_);\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove all members for this class.\n Example :\n Returns : The list of previous members as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @arr = $self->get_members();\n    $self->{'_members'} = [];\n    return @arr;\n}\n\n=head2 get_examples\n\n Title   : get_examples\n Usage   : @arr = get_examples()\n Function: Get the list of example(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_examples{\n    my $self = shift;\n\n    return @{$self->{'_examples'}} if exists($self->{'_examples'});\n    return ();\n}\n\n=head2 add_example\n\n Title   : add_example\n Usage   :\n Function: Add one or more example(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_example{\n    my $self = shift;\n\n    $self->{'_examples'} = [] unless exists($self->{'_examples'});\n    push(@{$self->{'_examples'}}, @_);\n}\n\n=head2 remove_examples\n\n Title   : remove_examples\n Usage   :\n Function: Remove all examples for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous examples as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_examples{\n    my $self = shift;\n\n    my @arr = $self->get_examples();\n    $self->{'_examples'} = [];\n    return @arr;\n}\n\n=head2 get_external_documents\n\n Title   : get_external_documents\n Usage   : @arr = get_external_documents()\n Function: Get the list of external_document(s) for this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : An array of Bio::Annotation::DBLink objects\n Args    :\n\n\n\nsub get_external_documents{\n    my $self = shift;\n\n    return @{$self->{'_external_documents'}} if exists($self->{'_external_documents'});\n    return ();\n}\n\n=head2 add_external_document\n\n Title   : add_external_document\n Usage   :\n Function: Add one or more external_document(s) to this object.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : \n Args    : One or more Bio::Annotation::DBLink objects.\n\n\n\nsub add_external_document{\n    my $self = shift;\n\n    $self->{'_external_documents'} = [] unless exists($self->{'_external_documents'});\n    push(@{$self->{'_external_documents'}}, @_);\n}\n\n=head2 remove_external_documents\n\n Title   : remove_external_documents\n Usage   :\n Function: Remove all external_documents for this class.\n\n           This is an element of the InterPro xml schema.\n\n Example :\n Returns : The list of previous external_documents as an array of\n           Bio::Annotation::DBLink objects.\n Args    :\n\n\n\nsub remove_external_documents{\n    my $self = shift;\n\n    my @arr = $self->get_external_documents();\n    $self->{'_external_documents'} = [];\n    return @arr;\n}\n\n=head2 class_list\n\n Title   : class_list\n Usage   : $obj->class_list($newval)\n Function: Set/get for class list element of the InterPro xml schema\n Example : \n Returns : reference to an array of Bio::Annotation::DBLink objects\n Args    : reference to an array of Bio::Annotation::DBLink objects\n\n\n\nsub class_list{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'class_list'} = $value;\n  }\n\n  return $self->{'class_list'};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $term->to_string();\n Function: to_string method for InterPro terms.\n Returns : A string representation of this InterPro term.\n Args    :"},"containerName":"main::","definition":"sub","line":536,"children":[{"kind":13,"line":537,"containerName":"to_string","name":"$self","definition":"my","localvar":"my"},{"line":538,"kind":13,"localvar":"my","containerName":"to_string","name":"$s","definition":"my"},{"containerName":"to_string","name":"$s","line":540,"kind":13},{"kind":13,"line":541,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$self","line":541,"kind":13},{"name":"interpro_id","containerName":"to_string","kind":12,"line":541},{"containerName":"to_string","name":"$self","line":542,"kind":13},{"name":"name","containerName":"to_string","kind":12,"line":542},{"line":543,"kind":13,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":544},{"line":544,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"name","line":544,"kind":12},{"line":545,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":546},{"containerName":"to_string","name":"$self","line":546,"kind":13},{"name":"definition","containerName":"to_string","kind":12,"line":546},{"containerName":"to_string","name":"$s","kind":13,"line":547},{"containerName":"to_string","name":"$self","line":548,"kind":13},{"name":"ontology","containerName":"to_string","kind":12,"line":548},{"name":"$s","containerName":"to_string","line":549,"kind":13},{"containerName":"to_string","name":"$self","line":549,"kind":13},{"kind":12,"line":549,"containerName":"to_string","name":"ontology"},{"name":"name","containerName":"to_string","line":549,"kind":12},{"kind":13,"line":551,"name":"$s","containerName":"to_string"},{"kind":13,"line":553,"containerName":"to_string","name":"$s"},{"line":554,"kind":13,"containerName":"to_string","name":"$s"},{"line":554,"kind":13,"containerName":"to_string","name":"$self"},{"line":554,"kind":12,"name":"version","containerName":"to_string"},{"containerName":"to_string","name":"$s","line":555,"kind":13},{"name":"$s","containerName":"to_string","kind":13,"line":556},{"line":556,"kind":13,"name":"$self","containerName":"to_string"},{"line":556,"kind":12,"name":"is_obsolete","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":557},{"kind":13,"line":558,"containerName":"to_string","name":"$s"},{"kind":13,"line":558,"containerName":"to_string","name":"$self"},{"name":"comment","containerName":"to_string","line":558,"kind":12},{"line":559,"kind":13,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"get_references","kind":12,"line":559},{"line":560,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"line":561,"definition":"my","name":"$ref","containerName":"to_string","localvar":"my"},{"name":"$self","containerName":"to_string","line":561,"kind":13},{"name":"get_references","containerName":"to_string","kind":12,"line":561},{"containerName":"to_string","name":"$s","line":562,"kind":13},{"containerName":"to_string","name":"$ref","line":562,"kind":13},{"containerName":"to_string","name":"authors","kind":12,"line":562},{"line":562,"kind":13,"name":"$ref","containerName":"to_string"},{"name":"title","containerName":"to_string","line":562,"kind":12},{"containerName":"to_string","name":"$ref","line":562,"kind":13},{"kind":12,"line":562,"containerName":"to_string","name":"location"},{"kind":13,"line":564,"name":"$s","containerName":"to_string"},{"kind":13,"line":566,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"get_members","line":566,"kind":12},{"kind":13,"line":567,"name":"$s","containerName":"to_string"},{"kind":13,"line":568,"containerName":"to_string","definition":"my","name":"$ref","localvar":"my"},{"containerName":"to_string","name":"$self","kind":13,"line":568},{"line":568,"kind":12,"name":"get_members","containerName":"to_string"},{"containerName":"to_string","name":"$s","line":569,"kind":13},{"name":"$ref","containerName":"to_string","line":569,"kind":13},{"kind":12,"line":569,"containerName":"to_string","name":"database"},{"containerName":"to_string","name":"$ref","line":569,"kind":13},{"containerName":"to_string","name":"primary_id","line":569,"kind":12},{"line":571,"kind":13,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$self","line":573,"kind":13},{"containerName":"to_string","name":"get_external_documents","line":573,"kind":12},{"containerName":"to_string","name":"$s","line":574,"kind":13},{"line":575,"kind":13,"localvar":"my","definition":"my","name":"$ref","containerName":"to_string"},{"kind":13,"line":575,"name":"$self","containerName":"to_string"},{"kind":12,"line":575,"containerName":"to_string","name":"get_external_documents"},{"name":"$s","containerName":"to_string","line":576,"kind":13},{"line":576,"kind":13,"name":"$ref","containerName":"to_string"},{"kind":12,"line":576,"containerName":"to_string","name":"database"},{"containerName":"to_string","name":"$ref","kind":13,"line":576},{"kind":12,"line":576,"containerName":"to_string","name":"primary_id"},{"kind":13,"line":578,"containerName":"to_string","name":"$s"},{"line":580,"kind":13,"name":"$self","containerName":"to_string"},{"line":580,"kind":12,"containerName":"to_string","name":"get_examples"},{"containerName":"to_string","name":"$s","line":581,"kind":13},{"line":582,"kind":13,"localvar":"my","definition":"my","name":"$ref","containerName":"to_string"},{"containerName":"to_string","name":"$self","line":582,"kind":13},{"line":582,"kind":12,"containerName":"to_string","name":"get_examples"},{"containerName":"to_string","name":"$s","line":583,"kind":13},{"kind":13,"line":583,"name":"$ref","containerName":"to_string"},{"line":583,"kind":12,"containerName":"to_string","name":"database"},{"line":583,"kind":13,"containerName":"to_string","name":"$ref"},{"containerName":"to_string","name":"primary_id","kind":12,"line":583},{"line":583,"kind":13,"name":"$ref","containerName":"to_string"},{"kind":12,"line":583,"containerName":"to_string","name":"comment"},{"containerName":"to_string","name":"$s","line":585,"kind":13},{"kind":13,"line":587,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"class_list","kind":12,"line":587},{"name":"$s","containerName":"to_string","line":588,"kind":13},{"kind":13,"line":589,"containerName":"to_string","definition":"my","name":"$ref","localvar":"my"},{"containerName":"to_string","name":"$self","kind":13,"line":589},{"name":"class_list","containerName":"to_string","line":589,"kind":12},{"line":590,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$ref","containerName":"to_string","kind":13,"line":590},{"name":"primary_id","containerName":"to_string","kind":12,"line":590},{"kind":13,"line":592,"containerName":"to_string","name":"$s"},{"line":594,"kind":13,"containerName":"to_string","name":"$self"},{"name":"get_secondary_ids","containerName":"to_string","kind":12,"line":594},{"kind":13,"line":595,"name":"$s","containerName":"to_string"},{"containerName":"to_string","definition":"my","name":"$ref","localvar":"my","kind":13,"line":596},{"containerName":"to_string","name":"$self","kind":13,"line":596},{"containerName":"to_string","name":"get_secondary_ids","line":596,"kind":12},{"kind":13,"line":597,"containerName":"to_string","name":"$s"},{"kind":13,"line":597,"name":"$ref","containerName":"to_string"},{"name":"$s","containerName":"to_string","line":599,"kind":13}],"kind":12},{"name":"$s","containerName":null,"kind":13,"line":603},{"line":605,"kind":13,"containerName":null,"name":"$s"},{"line":627,"children":[{"kind":13,"line":628,"containerName":"secondary_ids","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":629,"name":"@ids","definition":"my","containerName":"secondary_ids","localvar":"my"},{"kind":13,"line":631,"containerName":"secondary_ids","name":"$self"},{"name":"warn","containerName":"secondary_ids","kind":12,"line":631},{"localvar":"my","definition":"my","name":"$sids","containerName":"secondary_ids","line":636,"kind":13},{"kind":13,"line":637,"name":"$sids","containerName":"secondary_ids"},{"containerName":"secondary_ids","name":"$self","kind":13,"line":638},{"name":"add_secondary_id","containerName":"secondary_ids","line":638,"kind":12},{"name":"$sids","containerName":"secondary_ids","kind":13,"line":638},{"containerName":"secondary_ids","name":"@ids","kind":13,"line":639},{"name":"$sids","containerName":"secondary_ids","line":639,"kind":13},{"containerName":"secondary_ids","name":"$self","line":642,"kind":13},{"kind":12,"line":642,"containerName":"secondary_ids","name":"remove_secondary_ids"},{"containerName":"secondary_ids","name":"@ids","line":646,"kind":13},{"kind":13,"line":646,"name":"$self","containerName":"secondary_ids"},{"line":646,"kind":12,"name":"get_secondary_ids","containerName":"secondary_ids"},{"kind":13,"line":648,"name":"@ids","containerName":"secondary_ids"}],"kind":12,"range":{"start":{"line":627,"character":0},"end":{"character":9999,"line":649}},"containerName":"main::","name":"secondary_ids","definition":"sub"}],"version":5}