{"vars":[{"name":"base","containerName":"","line":109,"kind":2},{"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":122,"kind":13},{"containerName":"new","name":"@args","line":122,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":123,"kind":13},{"name":"$class","containerName":"new","line":123,"kind":13},{"kind":13,"line":123,"name":"@args","containerName":"new"},{"line":124,"kind":13,"localvar":"my","definition":"my","name":"$matrix","containerName":"new"},{"line":124,"kind":13,"containerName":"new","name":"$values"},{"name":"$names","containerName":"new","line":124,"kind":13},{"line":125,"kind":13,"containerName":"new","name":"$program"},{"line":125,"kind":13,"name":"$matname","containerName":"new"},{"name":"$matid","containerName":"new","line":126,"kind":13},{"kind":13,"line":126,"name":"$self","containerName":"new"},{"line":126,"kind":12,"containerName":"new","name":"_rearrange"},{"line":132,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$matrix","kind":13,"line":134},{"kind":13,"line":134,"name":"$values","containerName":"new"},{"name":"$names","containerName":"new","line":134,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":135},{"line":135,"kind":12,"name":"throw","containerName":"new"},{"name":"$program","containerName":"new","line":137,"kind":13},{"line":137,"kind":13,"containerName":"new","name":"$self"},{"line":137,"kind":12,"name":"matrix_name","containerName":"new"},{"name":"$program","containerName":"new","line":137,"kind":13},{"containerName":"new","name":"$program","kind":13,"line":137},{"kind":13,"line":139,"name":"$self","containerName":"new"},{"containerName":"new","name":"_matrix","kind":12,"line":139},{"name":"$matrix","containerName":"new","line":139,"kind":13},{"line":139,"kind":13,"containerName":"new","name":"$matrix"},{"line":140,"kind":13,"name":"$self","containerName":"new"},{"name":"_values","containerName":"new","line":140,"kind":12},{"containerName":"new","name":"$values","line":140,"kind":13},{"name":"$values","containerName":"new","kind":13,"line":140},{"line":141,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"names","kind":12,"line":141},{"name":"$names","containerName":"new","line":141,"kind":13},{"kind":13,"line":141,"name":"$names","containerName":"new"},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"line":143,"kind":12,"containerName":"new","name":"matrix_name"},{"line":143,"kind":13,"name":"$matname","containerName":"new"},{"containerName":"new","name":"$matname","kind":13,"line":143},{"name":"$self","containerName":"new","kind":13,"line":144},{"containerName":"new","name":"matrix_id","line":144,"kind":12},{"name":"$matid","containerName":"new","kind":13,"line":144},{"kind":13,"line":144,"containerName":"new","name":"$matid"},{"containerName":"new","name":"$self","kind":13,"line":146}],"line":121,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":121},"end":{"line":147,"character":9999}},"name":"new"},{"kind":12,"line":123,"name":"SUPER","containerName":"new"},{"name":"get_entry","range":{"end":{"line":162,"character":9999},"start":{"character":0,"line":159}},"kind":12,"children":[{"kind":13,"line":160,"containerName":"get_entry","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":160,"name":"$row","containerName":"get_entry"},{"kind":13,"line":160,"name":"$column","containerName":"get_entry"},{"kind":13,"line":161,"containerName":"get_entry","name":"$row"},{"name":"$column","containerName":"get_entry","kind":13,"line":161},{"kind":13,"line":161,"name":"$self","containerName":"get_entry"},{"kind":12,"line":161,"name":"throw","containerName":"get_entry"},{"line":162,"kind":13,"localvar":"my","definition":"my","name":"%matrix","containerName":"get_entry"},{"line":162,"kind":13,"containerName":"get_entry","name":"$self"},{"kind":12,"line":162,"name":"_matrix","containerName":"get_entry"}],"line":159,"definition":"sub","containerName":"main::","signature":{"label":"get_entry($self,$row,$column)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$column"}]},"detail":"($self,$row,$column)"},{"kind":13,"line":163,"containerName":null,"name":"@values","definition":"my","localvar":"my"},{"containerName":null,"name":"$self","kind":13,"line":163},{"kind":12,"line":163,"name":"_values","containerName":"main::"},{"line":164,"kind":13,"name":"%matrix","containerName":null},{"line":164,"kind":13,"containerName":null,"name":"%row"},{"containerName":null,"name":"%column","kind":13,"line":164},{"localvar":"my","definition":"my","name":"$i","containerName":null,"line":165,"kind":13},{"kind":13,"line":165,"name":"$j","containerName":null},{"containerName":null,"name":"%matrix","kind":13,"line":165},{"line":165,"kind":13,"name":"%row","containerName":null},{"name":"$column","containerName":null,"kind":13,"line":165},{"containerName":null,"name":"@values","kind":13,"line":166},{"name":"@i","containerName":null,"kind":13,"line":166},{"containerName":null,"name":"$j","line":166,"kind":13},{"name":"get_row","range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":186}},"kind":12,"line":182,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_row","line":183,"kind":13},{"name":"$row","containerName":"get_row","line":183,"kind":13},{"containerName":"get_row","name":"$row","kind":13,"line":184},{"line":184,"kind":13,"name":"$self","containerName":"get_row"},{"kind":12,"line":184,"name":"throw","containerName":"get_row"},{"localvar":"my","definition":"my","name":"%matrix","containerName":"get_row","line":186,"kind":13},{"containerName":"get_row","name":"$self","kind":13,"line":186},{"kind":12,"line":186,"containerName":"get_row","name":"_matrix"}],"containerName":"main::","definition":"sub","detail":"($self,$row)","signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1","parameters":[{"label":"$self"},{"label":"$row"}],"label":"get_row($self,$row)"}},{"localvar":"my","name":"@values","definition":"my","containerName":null,"line":187,"kind":13},{"line":187,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":187,"containerName":"main::","name":"_values"},{"localvar":"my","name":"@names","definition":"my","containerName":null,"line":188,"kind":13},{"kind":13,"line":188,"containerName":null,"name":"$self"},{"name":"names","containerName":"main::","line":188,"kind":12},{"kind":13,"line":189,"containerName":null,"name":"%matrix"},{"line":189,"kind":13,"name":"$row","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$val","line":190,"kind":13},{"line":190,"kind":13,"containerName":null,"name":"%matrix"},{"kind":13,"line":190,"name":"$row","containerName":null},{"name":"$row_pointer","definition":"my","containerName":null,"localvar":"my","kind":13,"line":191},{"name":"@val","containerName":null,"line":191,"kind":13},{"line":192,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$index"},{"kind":13,"line":192,"containerName":null,"name":"@names"},{"kind":13,"line":193,"containerName":null,"name":"@values"},{"line":193,"kind":13,"containerName":null,"name":"@row_pointer"},{"kind":13,"line":193,"containerName":null,"name":"$index"},{"range":{"start":{"line":206,"character":0},"end":{"character":9999,"line":210}},"name":"get_column","signature":{"label":"get_column($self,$column)","parameters":[{"label":"$self"},{"label":"$column"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1"},"detail":"($self,$column)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":207,"definition":"my","name":"$self","containerName":"get_column","localvar":"my"},{"name":"$column","containerName":"get_column","line":207,"kind":13},{"line":208,"kind":13,"containerName":"get_column","name":"$column"},{"name":"$self","containerName":"get_column","line":208,"kind":13},{"kind":12,"line":208,"containerName":"get_column","name":"throw"},{"localvar":"my","name":"%matrix","definition":"my","containerName":"get_column","line":210,"kind":13},{"kind":13,"line":210,"containerName":"get_column","name":"$self"},{"kind":12,"line":210,"name":"_matrix","containerName":"get_column"}],"line":206,"kind":12},{"line":211,"kind":13,"localvar":"my","definition":"my","name":"@values","containerName":null},{"containerName":null,"name":"$self","line":211,"kind":13},{"containerName":"main::","name":"_values","line":211,"kind":12},{"localvar":"my","name":"@names","definition":"my","containerName":null,"line":212,"kind":13},{"kind":13,"line":212,"name":"$self","containerName":null},{"name":"names","containerName":"main::","kind":12,"line":212},{"name":"%matrix","containerName":null,"kind":13,"line":213},{"kind":13,"line":213,"containerName":null,"name":"$column"},{"definition":"my","name":"$val","containerName":null,"localvar":"my","kind":13,"line":214},{"line":214,"kind":13,"containerName":null,"name":"%matrix"},{"containerName":null,"name":"$column","line":214,"kind":13},{"definition":"my","name":"$row_pointer","containerName":null,"localvar":"my","kind":13,"line":215},{"name":"@val","containerName":null,"kind":13,"line":215},{"localvar":"my","definition":"my","name":"@ret","containerName":null,"line":216,"kind":13},{"localvar":"my","name":"$i","definition":"my","containerName":null,"line":217,"kind":13},{"line":217,"kind":13,"name":"$i","containerName":null},{"containerName":null,"name":"@names","kind":13,"line":217},{"line":217,"kind":13,"containerName":null,"name":"%i"},{"name":"@ret","containerName":null,"line":218,"kind":13},{"line":218,"kind":13,"name":"@values","containerName":null},{"name":"@i","containerName":null,"line":218,"kind":13},{"line":218,"kind":13,"containerName":null,"name":"$row_pointer"},{"name":"@ret","containerName":null,"kind":13,"line":220},{"range":{"start":{"character":0,"line":233},"end":{"line":235,"character":9999}},"name":"get_diagonal","line":233,"children":[{"kind":13,"line":234,"containerName":"get_diagonal","definition":"my","name":"$self","localvar":"my"},{"name":"%matrix","definition":"my","containerName":"get_diagonal","localvar":"my","kind":13,"line":235},{"kind":13,"line":235,"name":"$self","containerName":"get_diagonal"},{"kind":12,"line":235,"containerName":"get_diagonal","name":"_matrix"}],"kind":12,"detail":"($self)","signature":{"label":"get_diagonal($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1"},"containerName":"main::","definition":"sub"},{"kind":13,"line":236,"containerName":null,"name":"@values","definition":"my","localvar":"my"},{"line":236,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":236,"containerName":"main::","name":"_values"},{"kind":13,"line":237,"definition":"my","name":"@return","containerName":null,"localvar":"my"},{"localvar":"my","name":"$name","definition":"my","containerName":null,"line":238,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":238},{"containerName":"main::","name":"names","kind":12,"line":238},{"line":239,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$i"},{"name":"$j","containerName":null,"kind":13,"line":239},{"line":239,"kind":13,"name":"%matrix","containerName":null},{"name":"%name","containerName":null,"kind":13,"line":239},{"kind":13,"line":239,"containerName":null,"name":"$name"},{"containerName":null,"name":"@return","kind":13,"line":240},{"containerName":null,"name":"@values","kind":13,"line":240},{"name":"@i","containerName":null,"line":240,"kind":13},{"containerName":null,"name":"$j","line":240,"kind":13},{"kind":13,"line":242,"containerName":null,"name":"@return"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  ","parameters":[{"label":"$self"}],"label":"print_matrix($self)"},"kind":12,"line":255,"children":[{"kind":13,"line":256,"name":"$self","definition":"my","containerName":"print_matrix","localvar":"my"},{"line":257,"kind":13,"localvar":"my","name":"@names","definition":"my","containerName":"print_matrix"},{"containerName":"print_matrix","name":"$self","kind":13,"line":257},{"name":"names","containerName":"print_matrix","line":257,"kind":12}],"name":"print_matrix","range":{"end":{"character":9999,"line":257},"start":{"line":255,"character":0}}},{"localvar":"my","definition":"my","name":"@values","containerName":null,"line":258,"kind":13},{"kind":13,"line":258,"name":"$self","containerName":null},{"containerName":"main::","name":"_values","line":258,"kind":12},{"kind":13,"line":259,"name":"%matrix","definition":"my","containerName":null,"localvar":"my"},{"name":"$self","containerName":null,"kind":13,"line":259},{"line":259,"kind":12,"name":"_matrix","containerName":"main::"},{"definition":"my","name":"$str","containerName":null,"localvar":"my","kind":13,"line":260},{"kind":13,"line":261,"containerName":null,"name":"$str"},{"containerName":null,"name":"@names","line":261,"kind":13},{"kind":13,"line":262,"name":"$name","definition":"my","containerName":null,"localvar":"my"},{"line":262,"kind":13,"containerName":null,"name":"@names"},{"line":263,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$newname"},{"name":"$name","containerName":null,"line":263,"kind":13},{"kind":13,"line":263,"name":"$name","containerName":null},{"name":"%name","containerName":null,"kind":13,"line":264},{"line":264,"kind":13,"containerName":null,"name":"$newname"},{"kind":13,"line":265,"name":"$str","containerName":null},{"containerName":null,"name":"$newname","line":265,"kind":13},{"kind":13,"line":266,"containerName":null,"definition":"my","name":"$count","localvar":"my"},{"kind":13,"line":267,"definition":"my","name":"$n","containerName":null,"localvar":"my"},{"kind":13,"line":267,"name":"@names","containerName":null},{"line":268,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":null},{"kind":13,"line":268,"containerName":null,"name":"$j"},{"line":268,"kind":13,"containerName":null,"name":"%matrix"},{"line":268,"kind":13,"name":"%name","containerName":null},{"containerName":null,"name":"$n","line":268,"kind":13},{"kind":13,"line":269,"containerName":null,"name":"$count"},{"name":"names","line":269,"kind":12},{"kind":13,"line":270,"name":"$str","containerName":null},{"name":"@values","containerName":null,"kind":13,"line":270},{"kind":13,"line":270,"containerName":null,"name":"@i"},{"kind":13,"line":270,"containerName":null,"name":"%j"},{"containerName":null,"name":"@values","line":273,"kind":13},{"name":"@i","containerName":null,"kind":13,"line":273},{"line":273,"kind":13,"name":"%j","containerName":null},{"kind":13,"line":274,"containerName":null,"name":"$self"},{"kind":12,"line":274,"name":"debug","containerName":"main::"},{"containerName":null,"name":"$str","line":276,"kind":13},{"containerName":null,"name":"@values","kind":13,"line":276},{"line":276,"kind":13,"name":"@i","containerName":null},{"line":276,"kind":13,"containerName":null,"name":"$j"},{"containerName":null,"name":"$count","kind":13,"line":279},{"line":281,"kind":13,"containerName":null,"name":"$str"},{"containerName":null,"name":"$str","kind":13,"line":283},{"definition":"sub","containerName":"main::","signature":{"label":"_matrix($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference"},"detail":"($self,$val)","kind":12,"children":[{"kind":13,"line":298,"name":"$self","definition":"my","containerName":"_matrix","localvar":"my"},{"name":"$val","containerName":"_matrix","line":298,"kind":13},{"name":"$val","containerName":"_matrix","line":299,"kind":13},{"name":"$self","containerName":"_matrix","line":300,"kind":13},{"containerName":"_matrix","name":"$val","line":300,"kind":13},{"kind":13,"line":302,"containerName":"_matrix","name":"$self"}],"line":297,"name":"_matrix","range":{"start":{"character":0,"line":297},"end":{"line":303,"character":9999}}},{"range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":322}},"name":"names","children":[{"line":317,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"names"},{"line":317,"kind":13,"name":"$val","containerName":"names"},{"kind":13,"line":318,"containerName":"names","name":"$val"},{"kind":13,"line":319,"containerName":"names","name":"$self"},{"line":319,"kind":13,"containerName":"names","name":"$val"},{"kind":13,"line":321,"containerName":"names","name":"$self"}],"line":316,"kind":12,"signature":{"label":"names($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference"},"detail":"($self,$val)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":335,"character":0},"end":{"character":9999,"line":338}},"containerName":"main::","name":"program","definition":"sub","line":335,"children":[{"kind":13,"line":336,"definition":"my","name":"$self","containerName":"program","localvar":"my"},{"containerName":"program","name":"$self","kind":13,"line":337},{"line":337,"kind":12,"containerName":"program","name":"matrix_name"}],"kind":12},{"signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_values($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":352,"containerName":"_values","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":352,"name":"$val","containerName":"_values"},{"name":"$val","containerName":"_values","kind":13,"line":353},{"line":354,"kind":13,"name":"$self","containerName":"_values"},{"kind":13,"line":354,"containerName":"_values","name":"$val"},{"line":356,"kind":13,"name":"$self","containerName":"_values"}],"line":351,"kind":12,"range":{"end":{"character":9999,"line":357},"start":{"character":0,"line":351}},"name":"_values"},{"name":"matrix_id","definition":"sub","containerName":"main::","range":{"start":{"line":374,"character":0},"end":{"character":9999,"line":380}},"kind":12,"children":[{"line":375,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"matrix_id"},{"kind":13,"line":376,"name":"$self","containerName":"matrix_id"},{"containerName":"matrix_id","name":"$self","kind":13,"line":377}],"line":374},{"children":[{"line":394,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"matrix_name"},{"kind":13,"line":395,"containerName":"matrix_name","name":"$self"},{"line":396,"kind":13,"containerName":"matrix_name","name":"$self"}],"line":393,"kind":12,"range":{"end":{"character":9999,"line":397},"start":{"line":393,"character":0}},"definition":"sub","name":"matrix_name","containerName":"main::"},{"detail":"($self,$num)","signature":{"label":"column_header($self,$num)","parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer"},"containerName":"main::","definition":"sub","line":410,"children":[{"containerName":"column_header","definition":"my","name":"$self","localvar":"my","kind":13,"line":411},{"kind":13,"line":411,"name":"$num","containerName":"column_header"},{"line":412,"kind":13,"localvar":"my","containerName":"column_header","name":"@coln","definition":"my"},{"name":"$self","containerName":"column_header","kind":13,"line":412},{"line":412,"kind":12,"containerName":"column_header","name":"column_names"},{"containerName":"column_header","name":"$coln","line":413,"kind":13},{"name":"$num","containerName":"column_header","kind":13,"line":413}],"kind":12,"range":{"end":{"character":9999,"line":414},"start":{"character":0,"line":410}},"name":"column_header"},{"line":428,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"row_header","line":429,"kind":13},{"kind":13,"line":429,"containerName":"row_header","name":"$num"},{"kind":13,"line":430,"name":"@rown","definition":"my","containerName":"row_header","localvar":"my"},{"name":"$self","containerName":"row_header","line":430,"kind":13},{"name":"row_names","containerName":"row_header","line":430,"kind":12},{"line":431,"kind":13,"containerName":"row_header","name":"$rown"},{"name":"$num","containerName":"row_header","kind":13,"line":431}],"kind":12,"detail":"($self,$num)","signature":{"label":"row_header($self,$num)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":432},"start":{"line":428,"character":0}},"name":"row_header"},{"kind":12,"line":444,"children":[{"name":"$self","definition":"my","containerName":"column_num_for_name","localvar":"my","kind":13,"line":445},{"line":445,"kind":13,"containerName":"column_num_for_name","name":"$name"},{"localvar":"my","definition":"my","name":"$ct","containerName":"column_num_for_name","line":446,"kind":13},{"line":447,"kind":13,"localvar":"my","name":"$n","definition":"my","containerName":"column_num_for_name"},{"line":447,"kind":13,"containerName":"column_num_for_name","name":"$self"},{"kind":12,"line":447,"name":"column_names","containerName":"column_num_for_name"},{"line":448,"kind":13,"containerName":"column_num_for_name","name":"$ct"},{"name":"$n","containerName":"column_num_for_name","line":448,"kind":13},{"line":448,"kind":13,"name":"$name","containerName":"column_num_for_name"},{"name":"$ct","containerName":"column_num_for_name","line":449,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n    my ($self,$num) = @_;\n    my @rown = $self->row_names;\n   return $rown[$num];\n}\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string","label":"column_num_for_name($self,$name)"},"name":"column_num_for_name","range":{"end":{"line":452,"character":9999},"start":{"line":444,"character":0}}},{"line":465,"children":[{"kind":13,"line":466,"containerName":"row_num_for_name","definition":"my","name":"$self","localvar":"my"},{"line":466,"kind":13,"name":"$name","containerName":"row_num_for_name"},{"localvar":"my","definition":"my","name":"$ct","containerName":"row_num_for_name","line":467,"kind":13},{"kind":13,"line":468,"definition":"my","name":"$n","containerName":"row_num_for_name","localvar":"my"},{"name":"$self","containerName":"row_num_for_name","line":468,"kind":13},{"line":468,"kind":12,"name":"row_names","containerName":"row_num_for_name"},{"line":469,"kind":13,"containerName":"row_num_for_name","name":"$ct"},{"containerName":"row_num_for_name","name":"$n","line":469,"kind":13},{"line":469,"kind":13,"name":"$name","containerName":"row_num_for_name"},{"name":"$ct","containerName":"row_num_for_name","line":470,"kind":13}],"kind":12,"detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n    my ($self,$num) = @_;\n    my @rown = $self->row_names;\n   return $rown[$num];\n}\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   my $ct = 0;\n   foreach my $n ( $self->column_names ) {\n       return $ct if $n eq $name;\n       $ct++;\n   }\n   return;\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string","label":"row_num_for_name($self,$name)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":472},"start":{"character":0,"line":465}},"name":"row_num_for_name"},{"range":{"start":{"character":0,"line":485},"end":{"line":485,"character":9999}},"containerName":"main::","definition":"sub","name":"num_rows","line":485,"children":[{"name":"names","containerName":"num_rows","line":485,"kind":12}],"kind":12},{"kind":12,"line":485,"name":"shift"},{"line":498,"children":[{"containerName":"num_columns","name":"names","line":499,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":499},"start":{"line":498,"character":0}},"containerName":"main::","name":"num_columns","definition":"sub"},{"line":499,"kind":12,"name":"shift"},{"line":513,"children":[{"line":513,"kind":12,"name":"names","containerName":"row_names"}],"kind":12,"range":{"end":{"character":9999,"line":513},"start":{"line":513,"character":0}},"containerName":"main::","definition":"sub","name":"row_names"},{"line":513,"kind":12,"name":"shift"},{"kind":12,"line":526,"children":[{"kind":12,"line":526,"name":"names","containerName":"column_names"}],"containerName":"main::","definition":"sub","name":"column_names","range":{"start":{"line":526,"character":0},"end":{"character":9999,"line":526}}},{"line":526,"kind":12,"name":"shift"}],"version":5}