{"vars":[{"line":60,"kind":2,"name":"vars","containerName":""},{"kind":2,"line":63,"containerName":"","name":"base"},{"containerName":null,"name":"@Bio","line":65,"kind":13},{"kind":12,"line":65,"containerName":"PSM::IO::meme::HEADER","name":"Matrix"},{"range":{"end":{"line":101,"character":9999},"start":{"line":81,"character":0}},"name":"new","children":[{"line":82,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":82},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":83,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":83},{"kind":13,"line":83,"name":"@args","containerName":"new"},{"kind":13,"line":84,"name":"$file","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$self","kind":13,"line":84},{"containerName":"new","name":"_rearrange","kind":12,"line":84},{"name":"@args","containerName":"new","line":84,"kind":13},{"definition":"my","name":"$query","containerName":"new","localvar":"my","kind":13,"line":85},{"containerName":"new","name":"$tr1","line":85,"kind":13},{"line":85,"kind":13,"name":"$file","containerName":"new"},{"line":86,"kind":13,"name":"$self","containerName":"new"},{"name":"$file","containerName":"new","kind":13,"line":86},{"kind":13,"line":87,"containerName":"new","name":"$self"},{"kind":13,"line":87,"name":"$query","containerName":"new"},{"containerName":"new","name":"$self","line":88,"kind":13},{"name":"$self","containerName":"new","line":89,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":90},{"line":90,"kind":12,"name":"_initialize_io","containerName":"new"},{"line":90,"kind":13,"containerName":"new","name":"@args"},{"line":92,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"new"},{"line":93,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$line"},{"kind":13,"line":93,"name":"$self","containerName":"new"},{"line":93,"kind":12,"name":"_readline","containerName":"new"},{"line":94,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","kind":12,"line":94},{"containerName":"new","name":"$line","kind":13,"line":94},{"name":"$line","containerName":"new","kind":13,"line":95},{"name":"$line","containerName":"new","kind":13,"line":96},{"name":"$self","containerName":"new","kind":13,"line":97},{"containerName":"new","name":"$self","kind":13,"line":97},{"kind":13,"line":100,"name":"$self","containerName":"new"},{"line":100,"kind":13,"name":"$line","containerName":"new"},{"containerName":"new","name":"$line","kind":13,"line":100},{"line":100,"kind":13,"containerName":"new","name":"$line"}],"line":81,"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::meme - PSM meme parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use PSM parsers\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::meme;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse Bio::Matrix::PSM::Psm;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n@Bio::Matrix::PSM::IO::meme::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if the MEME header cannot be found.\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);"},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"kind":12,"line":83,"name":"SUPER","containerName":"new"},{"line":86,"kind":12,"name":"file"},{"kind":12,"line":87,"name":"query"},{"line":88,"kind":12,"name":"end"},{"name":"_strand","line":89,"kind":12},{"name":"_parse_coordinates","line":97,"kind":12},{"name":"unstructured","line":100,"kind":12},{"name":"$self","containerName":null,"line":102,"kind":13},{"containerName":"main::","name":"_initialize","kind":12,"line":102},{"line":103,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"children":[{"kind":13,"line":119,"name":"$self","definition":"my","containerName":"_parse_coordinates","localvar":"my"},{"kind":13,"line":120,"containerName":"_parse_coordinates","name":"$self"},{"kind":12,"line":120,"containerName":"_parse_coordinates","name":"_readline"},{"kind":13,"line":121,"containerName":"_parse_coordinates","name":"$self"},{"name":"_readline","containerName":"_parse_coordinates","kind":12,"line":121},{"containerName":"_parse_coordinates","definition":"my","name":"$line","localvar":"my","kind":13,"line":122},{"line":122,"kind":13,"containerName":"_parse_coordinates","name":"$self"},{"kind":12,"line":122,"name":"_readline","containerName":"_parse_coordinates"},{"containerName":"_parse_coordinates","name":"$line","kind":13,"line":123},{"line":124,"kind":13,"name":"$line","containerName":"_parse_coordinates"},{"line":125,"kind":13,"containerName":"_parse_coordinates","name":"$line"},{"kind":13,"line":126,"definition":"my","name":"$id1","containerName":"_parse_coordinates","localvar":"my"},{"kind":13,"line":126,"name":"$w1","containerName":"_parse_coordinates"},{"name":"$l1","containerName":"_parse_coordinates","line":126,"kind":13},{"containerName":"_parse_coordinates","name":"$id2","line":126,"kind":13},{"containerName":"_parse_coordinates","name":"$w2","line":126,"kind":13},{"containerName":"_parse_coordinates","name":"$l2","line":126,"kind":13},{"name":"$line","containerName":"_parse_coordinates","line":126,"kind":13},{"name":"$self","containerName":"_parse_coordinates","line":127,"kind":13},{"kind":13,"line":127,"containerName":"_parse_coordinates","name":"$id1"},{"containerName":"_parse_coordinates","name":"$self","line":128,"kind":13},{"line":128,"kind":13,"name":"$id1","containerName":"_parse_coordinates"},{"line":128,"kind":13,"containerName":"_parse_coordinates","name":"$w1"},{"name":"$self","containerName":"_parse_coordinates","line":129,"kind":13},{"kind":13,"line":129,"containerName":"_parse_coordinates","name":"$id1"},{"containerName":"_parse_coordinates","name":"$l1","kind":13,"line":129},{"name":"$id2","containerName":"_parse_coordinates","line":130,"kind":13},{"name":"$self","containerName":"_parse_coordinates","kind":13,"line":131},{"line":131,"kind":13,"name":"$id2","containerName":"_parse_coordinates"},{"containerName":"_parse_coordinates","name":"$self","line":132,"kind":13},{"name":"$id2","containerName":"_parse_coordinates","kind":13,"line":132},{"containerName":"_parse_coordinates","name":"$w2","line":132,"kind":13},{"line":133,"kind":13,"containerName":"_parse_coordinates","name":"$self"},{"line":133,"kind":13,"name":"$id2","containerName":"_parse_coordinates"},{"containerName":"_parse_coordinates","name":"$l2","kind":13,"line":133}],"line":118,"name":"_parse_coordinates","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":118},"end":{"line":134,"character":9999}}},{"name":"hid","kind":12,"line":127},{"line":128,"kind":12,"name":"weight"},{"line":129,"kind":12,"name":"length"},{"kind":12,"line":131,"name":"hid"},{"kind":12,"line":132,"name":"weight"},{"name":"length","kind":12,"line":133},{"name":"$line","containerName":null,"kind":13,"line":135},{"kind":13,"line":135,"name":"$self","containerName":null},{"containerName":"main::","name":"_readline","line":135,"kind":12},{"line":137,"kind":13,"containerName":null,"name":"$self"},{"range":{"end":{"character":9999,"line":167},"start":{"line":165,"character":0}},"containerName":"main::","definition":"sub","name":"header","line":165,"children":[{"kind":13,"line":166,"containerName":"header","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"@instances","containerName":"header","line":167,"kind":13},{"line":167,"kind":13,"name":"$self","containerName":"header"}],"kind":12},{"name":"_inst_name","line":167,"kind":12},{"kind":13,"line":168,"containerName":null,"name":"@weights","definition":"my","localvar":"my"},{"line":168,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":168,"name":"_inst_weight"},{"line":169,"kind":13,"localvar":"my","name":"@lengths","definition":"my","containerName":null},{"name":"%self","containerName":null,"line":169,"kind":13},{"line":169,"kind":12,"name":"_inst_coord"},{"name":"instances","line":170,"kind":12},{"containerName":null,"name":"@instances","line":170,"kind":13},{"kind":12,"line":170,"name":"weights"},{"kind":13,"line":170,"containerName":null,"name":"@weights"},{"name":"lengths","kind":12,"line":170},{"name":"@lengths","containerName":null,"kind":13,"line":170},{"kind":12,"line":186,"children":[{"line":188,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_psm"},{"containerName":"next_psm","name":"$self","line":189,"kind":13},{"line":190,"kind":13,"localvar":"my","containerName":"next_psm","definition":"my","name":"$endm"},{"line":190,"kind":13,"containerName":"next_psm","name":"$line"},{"name":"$instances","containerName":"next_psm","line":190,"kind":13},{"name":"$tr","containerName":"next_psm","line":190,"kind":13},{"kind":13,"line":190,"containerName":"next_psm","name":"$width"},{"containerName":"next_psm","name":"$motif_id","kind":13,"line":190},{"kind":13,"line":190,"name":"$sites","containerName":"next_psm"},{"name":"$e_val","containerName":"next_psm","kind":13,"line":190},{"line":190,"kind":13,"containerName":"next_psm","name":"$id"},{"containerName":"next_psm","name":"$ic","line":190,"kind":13},{"line":190,"kind":13,"containerName":"next_psm","name":"$lA"},{"line":190,"kind":13,"containerName":"next_psm","name":"$lC"},{"containerName":"next_psm","name":"$lG","kind":13,"line":190},{"kind":13,"line":190,"name":"$lT","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","line":191,"kind":13},{"kind":13,"line":191,"containerName":"next_psm","name":"$self"},{"line":191,"kind":12,"name":"_readline","containerName":"next_psm"},{"name":"$self","containerName":"next_psm","line":193,"kind":13},{"containerName":"next_psm","name":"$line","line":193,"kind":13},{"name":"$line","containerName":"next_psm","kind":13,"line":193},{"containerName":"next_psm","name":"$line","kind":13,"line":194},{"line":195,"kind":13,"containerName":"next_psm","name":"$instances"},{"kind":13,"line":195,"containerName":"next_psm","name":"$self"},{"kind":12,"line":195,"containerName":"next_psm","name":"_parseInstance"},{"line":198,"kind":13,"containerName":"next_psm","name":"$line"},{"name":"$line","containerName":"next_psm","kind":13,"line":198},{"line":199,"kind":13,"containerName":"next_psm","name":"$line"},{"containerName":"next_psm","name":"$line","kind":13,"line":200},{"containerName":"next_psm","name":"$line","line":201,"kind":13},{"containerName":"next_psm","name":"$tr","line":203,"kind":13},{"containerName":"next_psm","name":"$motif_id","line":203,"kind":13},{"name":"$tr","containerName":"next_psm","line":203,"kind":13},{"kind":13,"line":203,"name":"$width","containerName":"next_psm"},{"name":"$tr","containerName":"next_psm","line":203,"kind":13},{"kind":13,"line":203,"name":"$sites","containerName":"next_psm"},{"containerName":"next_psm","name":"$tr","line":204,"kind":13},{"name":"$tr","containerName":"next_psm","kind":13,"line":204},{"name":"$tr","containerName":"next_psm","line":204,"kind":13},{"containerName":"next_psm","name":"$e_val","kind":13,"line":204},{"containerName":"next_psm","name":"$line","kind":13,"line":204},{"name":"$self","containerName":"next_psm","kind":13,"line":205},{"name":"$self","containerName":"next_psm","line":205,"kind":13},{"line":205,"kind":13,"containerName":"next_psm","name":"$motif_id"},{"containerName":"next_psm","name":"$line","line":207,"kind":13},{"containerName":"next_psm","name":"$line","kind":13,"line":208},{"kind":13,"line":208,"containerName":"next_psm","name":"$self"},{"name":"_readline","containerName":"next_psm","kind":12,"line":208},{"name":"$line","containerName":"next_psm","line":209,"kind":13},{"name":"$line","containerName":"next_psm","line":210,"kind":13},{"kind":13,"line":211,"name":"$ic","containerName":"next_psm"},{"line":211,"kind":13,"name":"$line","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","line":214,"kind":13},{"line":215,"kind":13,"containerName":"next_psm","name":"$lA"},{"name":"$lC","containerName":"next_psm","kind":13,"line":215},{"containerName":"next_psm","name":"$lG","kind":13,"line":215},{"kind":13,"line":215,"name":"$lT","containerName":"next_psm"},{"containerName":"next_psm","name":"$self","line":215,"kind":13},{"line":217,"kind":13,"containerName":"next_psm","name":"$line"},{"name":"%matrix_dat","definition":"my","containerName":"next_psm","localvar":"my","kind":13,"line":218},{"line":218,"kind":13,"containerName":"next_psm","name":"$self"},{"kind":12,"line":218,"containerName":"next_psm","name":"_parseMatrix"},{"line":218,"kind":13,"name":"$motif_id","containerName":"next_psm"},{"localvar":"my","name":"$psm","definition":"my","containerName":"next_psm","line":219,"kind":13},{"kind":12,"line":219,"containerName":"next_psm","name":"new"},{"kind":13,"line":219,"name":"%matrix_dat","containerName":"next_psm"},{"containerName":"next_psm","name":"$instances","line":220,"kind":13},{"kind":13,"line":221,"name":"$e_val","containerName":"next_psm"},{"kind":13,"line":222,"containerName":"next_psm","name":"$ic"},{"line":223,"kind":13,"name":"$width","containerName":"next_psm"},{"kind":13,"line":224,"containerName":"next_psm","name":"$sites"},{"kind":13,"line":225,"containerName":"next_psm","name":"$lA"},{"line":226,"kind":13,"name":"$lC","containerName":"next_psm"},{"kind":13,"line":227,"containerName":"next_psm","name":"$lG"},{"line":228,"kind":13,"name":"$lT","containerName":"next_psm"},{"kind":13,"line":230,"containerName":"next_psm","name":"$psm"},{"containerName":"next_psm","name":"$line","line":232,"kind":13},{"containerName":"next_psm","name":"$self","kind":13,"line":233},{"name":"$endm","containerName":"next_psm","kind":13,"line":236},{"containerName":"next_psm","name":"$line","kind":13,"line":236},{"line":238,"kind":13,"containerName":"next_psm","name":"$endm"},{"name":"$self","containerName":"next_psm","line":239,"kind":13},{"containerName":"next_psm","name":"$self","kind":13,"line":243},{"kind":12,"line":243,"containerName":"next_psm","name":"throw"}],"containerName":"main::","name":"next_psm","definition":"sub","range":{"start":{"line":186,"character":0},"end":{"line":244,"character":9999}}},{"kind":12,"line":189,"name":"end"},{"line":193,"kind":12,"name":"_strand"},{"kind":12,"line":205,"name":"id"},{"name":"query","line":205,"kind":12},{"name":"_parse_logs","kind":12,"line":215},{"containerName":"Matrix::PSM::Psm","name":"Bio","line":219,"kind":12},{"kind":12,"line":233,"name":"end"},{"kind":12,"line":239,"name":"end"},{"detail":"($self,$id)","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::meme - PSM meme parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use PSM parsers\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::meme;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse Bio::Matrix::PSM::Psm;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n@Bio::Matrix::PSM::IO::meme::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if the MEME header cannot be found.\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    my ($query,$tr1)=split(/\\./,$file,2);\n    $self->{file} = $file;\n    $self->{query}= $query;\n    $self->{end}  = 0;\n    $self->{_strand}=0; #This we'll need to see if revcom option is used\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    #Skip header\n    my $line;\n    while (my $line=$self->_readline) {\n\t$self->throw('Cannot parse HTML, please use text output\\n') if ($line=~/<HEAD>/); #Should start parsing HTML output, not a bug deal\n\tchomp($line);\n\tif ($line=~\"^ALPHABET\") {\n\t    $self=_parse_coordinates($self);\n\t    last;\n\t}\n\tpush @{$self->{unstructured}},$line unless (($line=~/\\*{10,}/) || ($line eq ''));\n    }\n    $self->_initialize;\n    return $self;\n}\n\n=head2 _parse_coordinates\n\n Title   : _parse_coordinates\n Usage   :\n Function:\n Throws  :\n Example : Internal stuff\n Returns :\n Args    :\n\n\nsub _parse_coordinates {\n    my $self=shift;\n    $self->_readline;\n    $self->_readline;\n    my $line=$self->_readline;\n    while ($line !~ /^\\*{10,}/ ) {\n\tchomp $line;\n\t$line =~ s/\\s+/,/g;\n\tmy ($id1,$w1,$l1,$id2,$w2,$l2)=split(/,/,$line);\n\tpush @{$self->{hid}},$id1;\n\t$self->{weight}->{$id1}=$w1;\n\t$self->{length}->{$id1}=$l1;\n\tif ($id2) {\n\t    push @{$self->{hid}},$id2;\n\t    $self->{weight}->{$id2}=$w2;\n\t    $self->{length}->{$id2}=$l2;\n\t}\n\t$line=$self->_readline;\n    }\n    return $self;\n}\n\n=head2 header\n\n Title   : header\n Usage   :  my %header=$psmIO->header;\n Function:  Returns the header for the MEME file\n Throws  :\n Example : Fetching all the sequences included in the MEME analysis, \n           being parsed\n           my %header=$psmIO->header;\n            foreach my $seqid (@{$header{instances}}) {\n               my $seq=$db->get_Seq_by_acc($id);\n               #Do something with the sequence\n            }\n            where $db might be Bio::DB:GenBank object, see\n Returns : Hash with three keys: instances, weights and lengths, which\n           should be self-explenatory. Each value is an array\n           reference. Each array element corresponds to the same\n           element in the other two arrays. So $header{instances}->[$i]\n           will refer to the same sequence in the motif file as\n           $header{weights}->[$i] and $header{lengths}->[$i]\n Args    :  none\n Notes   :  OBSOLETE!\n\n\nsub header {\n    my $self=shift;\n    my @instances=@{$self->{_inst_name}};\n    my @weights=@{$self->{_inst_weight}};\n    my @lengths=@{$self->{_inst_coord}};\n    return (instances=>\\@instances,weights=>\\@weights,lengths=>\\@lengths);\n}\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Throws if the format is inconsistent with the rules for MEME 3.0.4:\n            no SUMMARY Section present or some keywords are missing/altered.\n Example :\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\nsub next_psm {\n    #Parses the next prediction and returns a psm objects\n    my $self=shift;\n    return if ($self->{end});\n    my ($endm,$line,$instances,$tr,$width,$motif_id,$sites,$e_val,$id,$ic,$lA,$lC,$lG,$lT);\n    while (defined( $line = $self->_readline) ) {\n#Check if revcom is enabled, not very original check....\n  $self->{_strand}=1 if (($line=~/^Sequence name/) && ($line=~/Strand/));\n\tif ($line=~ m/\\sSite\\s/) {\n\t    $instances= $self->_parseInstance;\n\t}\n\t#Here starts the next motif\n\tif ( ($line=~/width/) && ($line=~/sites/)) {\n\t    chomp($line);\n\t    $line=~s/[\\t\\s=]+/,/g;\n\t    $line=~s/\\t/,/g;\n\t    #Parsing the general information for this prediction\n\t    ($tr,$motif_id,$tr,$width,$tr,$sites,\n\t     $tr,$tr,$tr,$e_val)=split(/,/,$line);\n\t    $self->{id}=$self->{query} . $motif_id;\n\t}\n\tif ($line =~ /content/i) {\n\t    $line=$self->_readline;\n\t    chomp($line);\n\t    $line=~s/[\\)\\(]//g;\n\t    ($ic)=split(/\\s/,$line);\n\t}\n        #Last info-prob matrix data\n\tif ($line=~/position-specific\\s+scoring matrix/) {\n\t\t($lA,$lC,$lG,$lT)=_parse_logs($self);\n\t}\n\tif ($line=~/^letter-probability\\smatrix/) {\n\t    my %matrix_dat=$self->_parseMatrix($motif_id);\n\t    my $psm= Bio::Matrix::PSM::Psm->new(%matrix_dat, \n\t\t\t\t\t       -instances=>$instances, \n\t\t\t\t\t       -e_val=>$e_val,\n\t\t\t\t\t       -IC=>$ic, \n\t\t\t\t\t       -width=>$width, \n\t\t\t\t\t       -sites=>$sites,\n\t\t\t\t\t\t   -lA=>$lA,\n\t\t\t\t\t\t   -lC=>$lC,\n\t\t\t\t\t\t   -lG=>$lG,\n\t\t\t\t\t\t   -lT=>$lT,\n\t\t\t\t\t\t   );\n\t    return $psm;\n\t}\n\tif ($line=~\"SUMMARY OF MOTIFS\") {\n\t    $self->{end}=1;\n\t    return;\n\t}\n\t$endm=1 if ($line=~/^Time\\s/); \n    }\n\tif ($endm) { #End of file found, end of current motif too, but not all predictions were made as requested (No summary)\n\t    $self->{end}=1;\n            warn \"This MEME analysis was terminated prematurely, you may have less motifs than you requested\\n\";\n\t    return;\n\t}\n    $self->throw(\"Wrong format\\n\"); # Multiple keywords not found, probably wrong format\n}\n\n=head2 _parseMatrix\n\n Title   : _parseMatrix\n Usage   :\n Function: Parses the next site matrix information in the meme file\n Throws  :\n Example :  Internal stuff\n Returns :  hash as for constructing a SiteMatrix object (see SiteMatrixI)\n Args    :  string","label":"_parseMatrix($self,$id)"},"containerName":"main::","definition":"sub","line":258,"children":[{"kind":13,"line":259,"definition":"my","name":"$self","containerName":"_parseMatrix","localvar":"my"},{"containerName":"_parseMatrix","name":"$id","kind":13,"line":259},{"localvar":"my","containerName":"_parseMatrix","definition":"my","name":"@pA","line":260,"kind":13},{"name":"@pC","containerName":"_parseMatrix","line":260,"kind":13},{"line":260,"kind":13,"name":"@pG","containerName":"_parseMatrix"},{"containerName":"_parseMatrix","name":"@pT","kind":13,"line":260},{"kind":13,"line":261,"containerName":"_parseMatrix","definition":"my","name":"$i","localvar":"my"},{"localvar":"my","containerName":"_parseMatrix","definition":"my","name":"$line","line":262,"kind":13},{"name":"$self","containerName":"_parseMatrix","kind":13,"line":262},{"line":262,"kind":12,"name":"_readline","containerName":"_parseMatrix"},{"line":265,"kind":13,"containerName":"_parseMatrix","name":"$line"},{"kind":13,"line":266,"containerName":"_parseMatrix","name":"$line"},{"kind":13,"line":267,"containerName":"_parseMatrix","name":"$line"},{"name":"$line","containerName":"_parseMatrix","kind":13,"line":268},{"line":269,"kind":13,"containerName":"_parseMatrix","name":"$pA"},{"kind":13,"line":269,"name":"$i","containerName":"_parseMatrix"},{"line":269,"kind":13,"name":"$pC","containerName":"_parseMatrix"},{"name":"$i","containerName":"_parseMatrix","line":269,"kind":13},{"line":269,"kind":13,"containerName":"_parseMatrix","name":"$pG"},{"containerName":"_parseMatrix","name":"$i","kind":13,"line":269},{"name":"$pT","containerName":"_parseMatrix","kind":13,"line":269},{"name":"$i","containerName":"_parseMatrix","kind":13,"line":269},{"name":"$line","containerName":"_parseMatrix","kind":13,"line":269},{"containerName":"_parseMatrix","name":"$i","kind":13,"line":270},{"containerName":"_parseMatrix","name":"$line","kind":13,"line":271},{"containerName":"_parseMatrix","name":"$self","kind":13,"line":271},{"line":271,"kind":12,"containerName":"_parseMatrix","name":"_readline"},{"containerName":"_parseMatrix","name":"$line","line":272,"kind":13},{"kind":13,"line":273,"containerName":"_parseMatrix","name":"@pA"},{"kind":13,"line":273,"containerName":"_parseMatrix","name":"@pC"},{"containerName":"_parseMatrix","name":"@pG","line":273,"kind":13},{"name":"@pT","containerName":"_parseMatrix","kind":13,"line":273},{"name":"$id","containerName":"_parseMatrix","line":273,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":258},"end":{"line":274,"character":9999}},"name":"_parseMatrix"},{"containerName":"main::","definition":"sub","name":"_parse_logs","range":{"start":{"character":0,"line":288},"end":{"character":9999,"line":306}},"kind":12,"line":288,"children":[{"line":289,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_logs"},{"kind":13,"line":290,"name":"@lA","definition":"my","containerName":"_parse_logs","localvar":"my"},{"name":"@lC","containerName":"_parse_logs","line":290,"kind":13},{"name":"@lG","containerName":"_parse_logs","kind":13,"line":290},{"line":290,"kind":13,"containerName":"_parse_logs","name":"@lT"},{"containerName":"_parse_logs","name":"$i","definition":"my","localvar":"my","kind":13,"line":291},{"containerName":"_parse_logs","name":"$self","kind":13,"line":292},{"name":"_readline","containerName":"_parse_logs","line":292,"kind":12},{"containerName":"_parse_logs","name":"$self","kind":13,"line":292},{"line":292,"kind":12,"name":"_readline","containerName":"_parse_logs"},{"localvar":"my","containerName":"_parse_logs","definition":"my","name":"$line","line":293,"kind":13},{"containerName":"_parse_logs","name":"$self","line":293,"kind":13},{"containerName":"_parse_logs","name":"_readline","line":293,"kind":12},{"line":296,"kind":13,"containerName":"_parse_logs","name":"$line"},{"containerName":"_parse_logs","name":"$line","kind":13,"line":297},{"containerName":"_parse_logs","name":"$line","kind":13,"line":298},{"kind":13,"line":299,"containerName":"_parse_logs","name":"$line"},{"containerName":"_parse_logs","name":"$lA","kind":13,"line":300},{"kind":13,"line":300,"containerName":"_parse_logs","name":"$i"},{"name":"$lC","containerName":"_parse_logs","kind":13,"line":300},{"line":300,"kind":13,"name":"$i","containerName":"_parse_logs"},{"line":300,"kind":13,"name":"$lG","containerName":"_parse_logs"},{"containerName":"_parse_logs","name":"$i","kind":13,"line":300},{"kind":13,"line":300,"name":"$lT","containerName":"_parse_logs"},{"kind":13,"line":300,"containerName":"_parse_logs","name":"$i"},{"kind":13,"line":300,"containerName":"_parse_logs","name":"$line"},{"name":"$i","containerName":"_parse_logs","kind":13,"line":301},{"kind":13,"line":302,"containerName":"_parse_logs","name":"$line"},{"containerName":"_parse_logs","name":"$self","kind":13,"line":302},{"name":"_readline","containerName":"_parse_logs","kind":12,"line":302},{"name":"$line","containerName":"_parse_logs","line":303,"kind":13},{"name":"@lA","containerName":"_parse_logs","line":305,"kind":13},{"line":305,"kind":13,"name":"@lC","containerName":"_parse_logs"},{"name":"@lG","containerName":"_parse_logs","kind":13,"line":305},{"containerName":"_parse_logs","name":"@lT","line":305,"kind":13}]},{"name":"_parseInstance","definition":"sub","containerName":"main::","range":{"start":{"line":320,"character":0},"end":{"line":355,"character":9999}},"kind":12,"children":[{"line":321,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parseInstance"},{"localvar":"my","name":"$i","definition":"my","containerName":"_parseInstance","line":322,"kind":13},{"containerName":"_parseInstance","name":"$self","line":323,"kind":13},{"containerName":"_parseInstance","name":"_readline","line":323,"kind":12},{"definition":"my","name":"$line","containerName":"_parseInstance","localvar":"my","kind":13,"line":324},{"kind":13,"line":324,"name":"@instance","containerName":"_parseInstance"},{"line":325,"kind":13,"name":"$line","containerName":"_parseInstance"},{"kind":13,"line":325,"name":"$self","containerName":"_parseInstance"},{"line":325,"kind":12,"name":"_readline","containerName":"_parseInstance"},{"kind":13,"line":326,"containerName":"_parseInstance","name":"$line"},{"line":327,"kind":13,"containerName":"_parseInstance","name":"$line"},{"localvar":"my","name":"@comp","definition":"my","containerName":"_parseInstance","line":328,"kind":13},{"name":"$line","containerName":"_parseInstance","kind":13,"line":328},{"localvar":"my","definition":"my","name":"$id","containerName":"_parseInstance","line":329,"kind":13},{"kind":13,"line":329,"containerName":"_parseInstance","name":"$start"},{"containerName":"_parseInstance","name":"$score","kind":13,"line":329},{"containerName":"_parseInstance","name":"$strand","line":329,"kind":13},{"containerName":"_parseInstance","name":"$s1","kind":13,"line":329},{"containerName":"_parseInstance","name":"$s2","line":329,"kind":13},{"containerName":"_parseInstance","name":"$s3","line":329,"kind":13},{"kind":13,"line":330,"name":"$self","containerName":"_parseInstance"},{"kind":13,"line":331,"containerName":"_parseInstance","name":"$id"},{"containerName":"_parseInstance","name":"$strand","line":331,"kind":13},{"kind":13,"line":331,"containerName":"_parseInstance","name":"$start"},{"containerName":"_parseInstance","name":"$score","kind":13,"line":331},{"containerName":"_parseInstance","name":"$s1","line":331,"kind":13},{"kind":13,"line":331,"name":"$s2","containerName":"_parseInstance"},{"name":"$s3","containerName":"_parseInstance","kind":13,"line":331},{"containerName":"_parseInstance","name":"@comp","kind":13,"line":331},{"containerName":"_parseInstance","name":"$id","line":333,"kind":13},{"containerName":"_parseInstance","name":"$start","line":333,"kind":13},{"line":333,"kind":13,"containerName":"_parseInstance","name":"$score"},{"name":"$s1","containerName":"_parseInstance","line":333,"kind":13},{"containerName":"_parseInstance","name":"$s2","line":333,"kind":13},{"containerName":"_parseInstance","name":"$s3","kind":13,"line":333},{"containerName":"_parseInstance","name":"@comp","kind":13,"line":333},{"containerName":"_parseInstance","name":"$strand","kind":13,"line":334},{"name":"$seq","definition":"my","containerName":"_parseInstance","localvar":"my","kind":13,"line":336},{"name":"$s1","containerName":"_parseInstance","kind":13,"line":336},{"name":"$s2","containerName":"_parseInstance","kind":13,"line":336},{"line":336,"kind":13,"containerName":"_parseInstance","name":"$s3"},{"name":"$seq","containerName":"_parseInstance","kind":13,"line":337},{"line":338,"kind":13,"localvar":"my","definition":"my","name":"$col","containerName":"_parseInstance"},{"line":339,"kind":13,"containerName":"_parseInstance","name":"$self"},{"line":339,"kind":12,"name":"throw","containerName":"_parseInstance"},{"line":341,"kind":13,"localvar":"my","name":"$sid","definition":"my","containerName":"_parseInstance"},{"name":"$self","containerName":"_parseInstance","line":341,"kind":13},{"name":"$id","containerName":"_parseInstance","kind":13,"line":341},{"containerName":"_parseInstance","name":"$instance","kind":13,"line":342},{"name":"$i","containerName":"_parseInstance","kind":13,"line":342},{"line":343,"kind":12,"containerName":"_parseInstance","name":"new"},{"name":"$self","containerName":"_parseInstance","kind":13,"line":343},{"name":"$start","containerName":"_parseInstance","line":344,"kind":13},{"line":345,"kind":13,"containerName":"_parseInstance","name":"$score"},{"kind":13,"line":346,"containerName":"_parseInstance","name":"$seq"},{"kind":13,"line":347,"name":"$strand","containerName":"_parseInstance"},{"name":"$id","containerName":"_parseInstance","kind":13,"line":348},{"kind":13,"line":349,"containerName":"_parseInstance","name":"$sid"},{"line":351,"kind":13,"containerName":"_parseInstance","name":"$i"},{"containerName":"_parseInstance","name":"$self","line":353,"kind":13},{"line":353,"kind":13,"name":"@instance","containerName":"_parseInstance"},{"kind":13,"line":354,"containerName":"_parseInstance","name":"@instance"}],"line":320},{"name":"_strand","line":330,"kind":12},{"name":"comp","kind":12,"line":338},{"name":"id","line":341,"kind":12},{"containerName":"Matrix::PSM::InstanceSite","name":"Bio","line":342,"kind":12},{"name":"id","line":343,"kind":12},{"name":"instances","line":353,"kind":12}],"version":5}