{"version":5,"vars":[{"line":79,"kind":2,"name":"vars","containerName":""},{"containerName":"","name":"base","kind":2,"line":82},{"range":{"end":{"line":110,"character":9999},"start":{"character":0,"line":100}},"name":"new","line":100,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":101,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":101},{"kind":13,"line":102,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":102,"containerName":"new","name":"$class"},{"kind":13,"line":102,"containerName":"new","name":"@args"},{"name":"$file","definition":"my","containerName":"new","localvar":"my","kind":13,"line":103},{"line":103,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":103,"name":"_rearrange","containerName":"new"},{"kind":13,"line":103,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$query","definition":"my","line":104,"kind":13},{"containerName":"new","name":"$tr1","kind":13,"line":104},{"line":104,"kind":13,"name":"$file","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":105},{"containerName":"new","name":"$file","kind":13,"line":105},{"name":"$self","containerName":"new","kind":13,"line":106},{"kind":13,"line":107,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":107},{"containerName":"new","name":"_rearrange","kind":12,"line":107},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"line":108,"kind":13,"name":"$self","containerName":"new"},{"line":108,"kind":12,"containerName":"new","name":"_initialize_io"},{"line":108,"kind":13,"name":"@args","containerName":"new"},{"line":108,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":108,"name":"warn","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":109}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: masta.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::masta - motif fasta format parser\n\n=head1 SYNOPSIS \n\nMASTA is a position frequency matrix format similar to\nfasta. It contains one ID row just like fasta and then the actual\ndata, which is tab delimited:\n\n  0.1\t0.62\t.017\t0.11\n  0.22\t0.13\t0.54\t0.11\n\nOr A,C,G and T could be horizontally positioned (positioning is\nautomatically detected).  Please note masta will parse only DNA at the\nmoment.\n\nIt will also convert a set of aligned sequences:\nACATGCAT\nACAGGGAT\nACAGGCAT\nACCGGCAT\n\nto a PFM (SiteMatrix object). When writing if you supply SEQ it will\nwrite 10 random instances, which represent correctly the frequency and\ncan be used as an input for weblogo creation purposes.\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use masta parser\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::masta;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::IO Bio::Root::Root);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=> 'masta',\n\t\t\t\t\t\t -file  => $file, \n                                                 -mtype => 'PWM');\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);"},"containerName":"main::","definition":"sub"},{"line":102,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"line":105,"name":"file"},{"line":106,"kind":12,"name":"_end"},{"line":107,"kind":12,"name":"mtype"},{"range":{"end":{"character":9999,"line":151},"start":{"line":124,"character":0}},"name":"write_psm","line":124,"children":[{"line":125,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_psm"},{"line":125,"kind":13,"name":"$matrix","containerName":"write_psm"},{"containerName":"write_psm","name":"$type","kind":13,"line":125},{"line":126,"kind":13,"containerName":"write_psm","name":"$self"},{"containerName":"write_psm","name":"$type","line":126,"kind":13},{"name":"$type","containerName":"write_psm","kind":13,"line":126},{"containerName":"write_psm","definition":"my","name":"$idline","localvar":"my","kind":13,"line":127},{"containerName":"write_psm","name":"$matrix","line":127,"kind":13},{"line":127,"kind":12,"name":"id","containerName":"write_psm"},{"kind":13,"line":128,"containerName":"write_psm","name":"$self"},{"kind":12,"line":128,"name":"_print","containerName":"write_psm"},{"kind":13,"line":128,"name":"$idline","containerName":"write_psm"},{"line":129,"kind":13,"name":"$self","containerName":"write_psm"},{"name":"%h","definition":"my","containerName":"write_psm","localvar":"my","kind":13,"line":130},{"line":130,"kind":13,"name":"$matrix","containerName":"write_psm"},{"line":130,"kind":12,"containerName":"write_psm","name":"next_pos"},{"localvar":"my","definition":"my","name":"$row","containerName":"write_psm","line":131,"kind":13},{"line":131,"kind":13,"name":"$self","containerName":"write_psm"},{"kind":13,"line":131,"name":"$h","containerName":"write_psm"},{"line":131,"kind":13,"name":"$h","containerName":"write_psm"},{"containerName":"write_psm","name":"$h","kind":13,"line":131},{"name":"$h","containerName":"write_psm","kind":13,"line":131},{"line":131,"kind":13,"name":"$h","containerName":"write_psm"},{"kind":13,"line":131,"containerName":"write_psm","name":"$h"},{"line":131,"kind":13,"name":"$h","containerName":"write_psm"},{"line":131,"kind":13,"name":"$h","containerName":"write_psm"},{"kind":13,"line":132,"containerName":"write_psm","name":"$self"},{"line":132,"kind":12,"containerName":"write_psm","name":"_print"},{"name":"$row","containerName":"write_psm","line":132,"kind":13},{"line":135,"kind":13,"localvar":"my","containerName":"write_psm","definition":"my","name":"@seq"},{"kind":13,"line":136,"definition":"my","name":"%h","containerName":"write_psm","localvar":"my"},{"name":"$matrix","containerName":"write_psm","kind":13,"line":136},{"line":136,"kind":12,"name":"next_pos","containerName":"write_psm"},{"line":137,"kind":13,"localvar":"my","name":"$a","definition":"my","containerName":"write_psm"},{"kind":13,"line":137,"containerName":"write_psm","name":"$c"},{"containerName":"write_psm","name":"$g","kind":13,"line":137},{"line":137,"kind":13,"name":"$t","containerName":"write_psm"},{"line":137,"kind":13,"containerName":"write_psm","name":"%h"},{"name":"$self","containerName":"write_psm","kind":13,"line":138},{"containerName":"write_psm","name":"throw","line":138,"kind":12},{"name":"$a","containerName":"write_psm","kind":13,"line":138},{"name":"$c","containerName":"write_psm","line":138,"kind":13},{"containerName":"write_psm","name":"$g","line":138,"kind":13},{"kind":13,"line":138,"name":"$t","containerName":"write_psm"},{"localvar":"my","containerName":"write_psm","name":"$i","definition":"my","line":139,"kind":13},{"kind":13,"line":139,"containerName":"write_psm","name":"$a"},{"containerName":"write_psm","name":"$seq","kind":13,"line":139},{"kind":13,"line":139,"name":"$i","containerName":"write_psm"},{"line":140,"kind":13,"localvar":"my","containerName":"write_psm","definition":"my","name":"$m"},{"line":140,"kind":13,"containerName":"write_psm","name":"$a"},{"line":140,"kind":13,"containerName":"write_psm","name":"$c"},{"localvar":"my","containerName":"write_psm","name":"$i","definition":"my","line":141,"kind":13},{"line":141,"kind":13,"containerName":"write_psm","name":"$a"},{"containerName":"write_psm","name":"$m","kind":13,"line":141},{"containerName":"write_psm","name":"$seq","line":141,"kind":13},{"name":"$i","containerName":"write_psm","kind":13,"line":141},{"kind":13,"line":142,"name":"$n","definition":"my","containerName":"write_psm","localvar":"my"},{"containerName":"write_psm","name":"$a","kind":13,"line":142},{"containerName":"write_psm","name":"$c","line":142,"kind":13},{"line":142,"kind":13,"containerName":"write_psm","name":"$g"},{"localvar":"my","containerName":"write_psm","definition":"my","name":"$i","line":143,"kind":13},{"line":143,"kind":13,"name":"$m","containerName":"write_psm"},{"containerName":"write_psm","name":"$n","kind":13,"line":143},{"kind":13,"line":143,"containerName":"write_psm","name":"$seq"},{"line":143,"kind":13,"name":"$i","containerName":"write_psm"},{"kind":13,"line":144,"containerName":"write_psm","definition":"my","name":"$i","localvar":"my"},{"containerName":"write_psm","name":"$n","kind":13,"line":144},{"containerName":"write_psm","name":"$seq","line":144,"kind":13},{"line":144,"kind":13,"containerName":"write_psm","name":"$i"},{"kind":13,"line":146,"containerName":"write_psm","name":"$s","definition":"my","localvar":"my"},{"line":146,"kind":13,"containerName":"write_psm","name":"@seq"},{"containerName":"write_psm","name":"$s","kind":13,"line":147},{"name":"$self","containerName":"write_psm","kind":13,"line":148},{"containerName":"write_psm","name":"_print","line":148,"kind":12},{"containerName":"write_psm","name":"$s","line":148,"kind":13}],"kind":12,"detail":"($self,$matrix,$type)","signature":{"label":"write_psm($self,$matrix,$type)","parameters":[{"label":"$self"},{"label":"$matrix"},{"label":"$type"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: masta.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::masta - motif fasta format parser\n\n=head1 SYNOPSIS \n\nMASTA is a position frequency matrix format similar to\nfasta. It contains one ID row just like fasta and then the actual\ndata, which is tab delimited:\n\n  0.1\t0.62\t.017\t0.11\n  0.22\t0.13\t0.54\t0.11\n\nOr A,C,G and T could be horizontally positioned (positioning is\nautomatically detected).  Please note masta will parse only DNA at the\nmoment.\n\nIt will also convert a set of aligned sequences:\nACATGCAT\nACAGGGAT\nACAGGCAT\nACCGGCAT\n\nto a PFM (SiteMatrix object). When writing if you supply SEQ it will\nwrite 10 random instances, which represent correctly the frequency and\ncan be used as an input for weblogo creation purposes.\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use masta parser\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::masta;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::IO Bio::Root::Root);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=> 'masta',\n\t\t\t\t\t\t -file  => $file, \n                                                 -mtype => 'PWM');\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    my ($query,$tr1)=split(/\\./,$file,2);\n    $self->{file}  = $file;\n    $self->{_end}  = 0;\n    $self->{mtype} = uc($self->_rearrange(['MTYPE'], @args) || \"PFM\");\n    $self->_initialize_io(@args) || $self->warn(\"Did you intend to use STDIN?\"); #Read only for now\n    return $self;\n}\n\n=head2 write_psm\n\n Title   : write_psm\n Usage   : \n Function: writes a pfm/pwm/raw sequence in a simple masta format\n Throws  :\n Example : \n Args    : SiteMatrix object, type (optional string: PWM, SEQ or PFM)\n Returns : "},"containerName":"main::","definition":"sub"},{"name":"mtype","line":126,"kind":12},{"name":"mtype","line":129,"kind":12},{"name":"mtype","line":131,"kind":12},{"kind":12,"line":131,"name":"lA"},{"kind":12,"line":131,"name":"lC"},{"kind":12,"line":131,"name":"lG"},{"name":"lT","kind":12,"line":131},{"line":131,"kind":12,"name":"pA"},{"line":131,"kind":12,"name":"pC"},{"name":"pG","line":131,"kind":12},{"kind":12,"line":131,"name":"pT"},{"name":"_freq_to_count","kind":12,"line":137},{"range":{"start":{"character":0,"line":161},"end":{"line":163,"character":9999}},"definition":"sub","name":"next_matrix","containerName":"main::","children":[{"containerName":"next_matrix","name":"next_psm","line":162,"kind":12}],"line":161,"kind":12},{"containerName":"main::","definition":"sub","name":"next_psm","range":{"start":{"character":0,"line":179},"end":{"line":226,"character":9999}},"kind":12,"line":179,"children":[{"line":180,"kind":13,"localvar":"my","containerName":"next_psm","name":"$self","definition":"my"},{"name":"$self","containerName":"next_psm","line":181,"kind":13},{"localvar":"my","definition":"my","name":"$line","containerName":"next_psm","line":182,"kind":13},{"kind":13,"line":182,"containerName":"next_psm","name":"$self"},{"name":"_readline","containerName":"next_psm","line":182,"kind":12},{"containerName":"next_psm","name":"$self","line":183,"kind":13},{"name":"throw","containerName":"next_psm","line":183,"kind":12},{"name":"$line","containerName":"next_psm","kind":13,"line":183},{"definition":"my","name":"$id","containerName":"next_psm","localvar":"my","kind":13,"line":184},{"line":184,"kind":13,"name":"$desc","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","line":184,"kind":13},{"kind":13,"line":185,"name":"$id","containerName":"next_psm"},{"line":186,"kind":13,"localvar":"my","containerName":"next_psm","name":"$mtype","definition":"my"},{"kind":13,"line":186,"containerName":"next_psm","name":"$format"},{"name":"@mdata","containerName":"next_psm","line":186,"kind":13},{"line":186,"kind":13,"name":"$len","containerName":"next_psm"},{"containerName":"next_psm","name":"$self","line":187,"kind":13},{"kind":13,"line":188,"name":"$line","containerName":"next_psm"},{"kind":13,"line":188,"name":"$self","containerName":"next_psm"},{"line":188,"kind":12,"containerName":"next_psm","name":"_readline"},{"kind":13,"line":189,"name":"$line","containerName":"next_psm"},{"line":190,"kind":13,"name":"$line","containerName":"next_psm"},{"kind":13,"line":191,"containerName":"next_psm","name":"$line"},{"line":192,"kind":13,"containerName":"next_psm","name":"$self"},{"containerName":"next_psm","name":"_pushback","line":192,"kind":12},{"containerName":"next_psm","name":"$line","kind":13,"line":192},{"kind":13,"line":196,"containerName":"next_psm","name":"$line"},{"name":"$self","containerName":"next_psm","line":198,"kind":13},{"kind":12,"line":198,"name":"throw","containerName":"next_psm"},{"kind":13,"line":199,"name":"$self","containerName":"next_psm"},{"line":199,"kind":13,"containerName":"next_psm","name":"$mtype"},{"containerName":"next_psm","name":"$self","line":200,"kind":13},{"name":"throw","containerName":"next_psm","kind":12,"line":200},{"line":201,"kind":13,"containerName":"next_psm","name":"$len"},{"containerName":"next_psm","name":"$len","kind":13,"line":201},{"line":201,"kind":13,"name":"$line","containerName":"next_psm"},{"containerName":"next_psm","name":"$len","line":202,"kind":13},{"line":202,"kind":13,"containerName":"next_psm","name":"$line"},{"kind":13,"line":202,"containerName":"next_psm","name":"$len"},{"kind":13,"line":203,"name":"@mdata","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","kind":13,"line":203},{"line":204,"kind":13,"name":"$self","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","line":207,"kind":13},{"kind":13,"line":208,"containerName":"next_psm","name":"$line"},{"name":"$line","containerName":"next_psm","kind":13,"line":209},{"line":210,"kind":13,"localvar":"my","definition":"my","name":"@data","containerName":"next_psm"},{"containerName":"next_psm","name":"$line","kind":13,"line":210},{"name":"$self","containerName":"next_psm","line":212,"kind":13},{"kind":12,"line":212,"containerName":"next_psm","name":"throw"},{"name":"$mtype","containerName":"next_psm","line":212,"kind":13},{"containerName":"next_psm","name":"$self","line":212,"kind":13},{"containerName":"next_psm","name":"$self","line":213,"kind":13},{"name":"$mtype","containerName":"next_psm","kind":13,"line":214},{"line":217,"kind":13,"containerName":"next_psm","name":"$self"},{"kind":12,"line":217,"containerName":"next_psm","name":"throw"},{"containerName":"next_psm","name":"$mtype","line":217,"kind":13},{"line":217,"kind":13,"name":"$self","containerName":"next_psm"},{"kind":13,"line":218,"name":"$self","containerName":"next_psm"},{"line":219,"kind":13,"containerName":"next_psm","name":"$mtype"},{"kind":13,"line":221,"name":"@mdata","containerName":"next_psm"},{"line":221,"kind":13,"name":"@data","containerName":"next_psm"},{"kind":13,"line":224,"containerName":"next_psm","name":"$self"},{"name":"$line","containerName":"next_psm","kind":13,"line":224},{"line":224,"kind":13,"name":"$line","containerName":"next_psm"},{"kind":13,"line":225,"containerName":"next_psm","name":"@mdata"},{"containerName":"next_psm","name":"$self","line":225,"kind":13},{"line":225,"kind":13,"containerName":"next_psm","name":"$id"},{"line":225,"kind":13,"name":"$desc","containerName":"next_psm"}]},{"name":"_end","line":181,"kind":12},{"name":"_mtype","kind":12,"line":187},{"name":"_mtype","line":199,"kind":12},{"name":"_mtype","kind":12,"line":204},{"name":"data","kind":12,"line":211},{"line":212,"kind":12,"name":"_mtype"},{"name":"_mtype","line":213,"kind":12},{"kind":12,"line":217,"name":"_mtype"},{"kind":12,"line":218,"name":"_mtype"},{"name":"_end","kind":12,"line":224},{"name":"_make_matrix","kind":12,"line":225},{"name":"_mtype","kind":12,"line":225},{"name":"_make_matrix","range":{"end":{"line":248,"character":9999},"start":{"character":0,"line":228}},"kind":12,"line":228,"children":[{"localvar":"my","name":"$mdata","definition":"my","containerName":"_make_matrix","line":229,"kind":13},{"line":229,"kind":13,"containerName":"_make_matrix","name":"$type"},{"name":"$id","containerName":"_make_matrix","line":229,"kind":13},{"line":229,"kind":13,"name":"$desc","containerName":"_make_matrix"},{"name":"$type","containerName":"_make_matrix","line":230,"kind":13},{"name":"@rearr","definition":"my","containerName":"_make_matrix","localvar":"my","kind":13,"line":231},{"containerName":"_make_matrix","name":"$mdata","line":231,"kind":13},{"containerName":"_make_matrix","name":"$mdata","line":232,"kind":13},{"containerName":"_make_matrix","name":"@rearr","line":232,"kind":13},{"line":237,"kind":13,"localvar":"my","name":"$mformat","definition":"my","containerName":"_make_matrix"},{"definition":"my","name":"$a","containerName":"_make_matrix","localvar":"my","kind":13,"line":238},{"kind":13,"line":238,"name":"$c","containerName":"_make_matrix"},{"line":238,"kind":13,"containerName":"_make_matrix","name":"$g"},{"line":238,"kind":13,"containerName":"_make_matrix","name":"$t"},{"containerName":"_make_matrix","name":"$type","line":239,"kind":13},{"kind":13,"line":240,"containerName":"_make_matrix","name":"$a"},{"line":240,"kind":13,"containerName":"_make_matrix","name":"$c"},{"kind":13,"line":240,"containerName":"_make_matrix","name":"$g"},{"name":"$t","containerName":"_make_matrix","line":240,"kind":13},{"containerName":"_make_matrix","name":"$mdata","line":240,"kind":13},{"line":242,"kind":13,"containerName":"_make_matrix","name":"$a"},{"name":"$c","containerName":"_make_matrix","kind":13,"line":242},{"kind":13,"line":242,"name":"$g","containerName":"_make_matrix"},{"kind":13,"line":242,"containerName":"_make_matrix","name":"$t"},{"containerName":"_make_matrix","name":"$mdata","line":242,"kind":13},{"kind":13,"line":243,"definition":"my","name":"$k","containerName":"_make_matrix","localvar":"my"},{"line":243,"kind":13,"name":"$a","containerName":"_make_matrix"},{"containerName":"_make_matrix","name":"$c","kind":13,"line":243},{"containerName":"_make_matrix","name":"$g","line":243,"kind":13},{"containerName":"_make_matrix","name":"$t","kind":13,"line":243},{"kind":13,"line":244,"containerName":"_make_matrix","name":"$l","definition":"my","localvar":"my"},{"line":244,"kind":13,"containerName":"_make_matrix","name":"$a"},{"containerName":"_make_matrix","name":"$c","kind":13,"line":244},{"containerName":"_make_matrix","name":"$g","kind":13,"line":244},{"containerName":"_make_matrix","name":"$t","line":244,"kind":13},{"kind":13,"line":245,"name":"$a","containerName":"_make_matrix"},{"name":"$c","containerName":"_make_matrix","kind":13,"line":245},{"line":245,"kind":13,"name":"$g","containerName":"_make_matrix"},{"line":245,"kind":13,"name":"$t","containerName":"_make_matrix"},{"containerName":"_make_matrix","name":"$mformat","kind":13,"line":246},{"kind":13,"line":246,"containerName":"_make_matrix","name":"$k"},{"line":246,"kind":13,"name":"$l","containerName":"_make_matrix"},{"name":"$mformat","containerName":"_make_matrix","kind":13,"line":247},{"kind":13,"line":247,"containerName":"_make_matrix","name":"$l"}],"containerName":"main::","definition":"sub","detail":"($mdata,$type,$id,$desc)","signature":{"documentation":"","parameters":[{"label":"$mdata"},{"label":"$type"},{"label":"$id"},{"label":"$desc"}],"label":"_make_matrix($mdata,$type,$id,$desc)"}},{"kind":12,"line":231,"name":"_rearrange_matrix"},{"name":"_count_positions","line":240,"kind":12},{"line":249,"kind":13,"localvar":"my","definition":"my","name":"@fa","containerName":null},{"line":249,"kind":13,"containerName":null,"name":"@fc"},{"containerName":null,"name":"@fg","kind":13,"line":249},{"name":"@ft","containerName":null,"kind":13,"line":249},{"line":249,"kind":13,"containerName":null,"name":"%mparam"},{"kind":13,"line":251,"containerName":null,"name":"%mformat"},{"localvar":"my","name":"$i","definition":"my","containerName":null,"line":252,"kind":13},{"containerName":null,"name":"%a","line":252,"kind":13},{"name":"$ca","definition":"my","containerName":null,"localvar":"my","kind":13,"line":253},{"name":"@a","containerName":null,"line":253,"kind":13},{"name":"$i","containerName":null,"kind":13,"line":253},{"localvar":"my","definition":"my","name":"$cc","containerName":null,"line":254,"kind":13},{"line":254,"kind":13,"containerName":null,"name":"@c"},{"line":254,"kind":13,"containerName":null,"name":"$i"},{"line":255,"kind":13,"localvar":"my","name":"$cg","definition":"my","containerName":null},{"name":"@g","containerName":null,"line":255,"kind":13},{"name":"$i","containerName":null,"line":255,"kind":13},{"localvar":"my","definition":"my","name":"$ct","containerName":null,"line":256,"kind":13},{"containerName":null,"name":"@t","line":256,"kind":13},{"line":256,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":257,"containerName":null,"definition":"my","name":"$all","localvar":"my"},{"name":"$ca","containerName":null,"line":257,"kind":13},{"name":"$cc","containerName":null,"kind":13,"line":257},{"containerName":null,"name":"$cg","kind":13,"line":257},{"line":257,"kind":13,"name":"$ct","containerName":null},{"containerName":null,"name":"@fa","line":258,"kind":13},{"name":"$ca","containerName":null,"kind":13,"line":258},{"line":258,"kind":13,"containerName":null,"name":"$all"},{"kind":13,"line":259,"containerName":null,"name":"@fc"},{"name":"$cc","containerName":null,"line":259,"kind":13},{"kind":13,"line":259,"name":"$all","containerName":null},{"name":"@fg","containerName":null,"line":260,"kind":13},{"line":260,"kind":13,"name":"$cg","containerName":null},{"containerName":null,"name":"$all","kind":13,"line":260},{"kind":13,"line":261,"containerName":null,"name":"@ft"},{"containerName":null,"name":"$ct","line":261,"kind":13},{"name":"$all","containerName":null,"kind":13,"line":261},{"line":264,"kind":13,"name":"$desc","containerName":null},{"kind":13,"line":265,"name":"%mformat","containerName":null},{"containerName":null,"name":"$desc","kind":13,"line":266},{"containerName":null,"name":"%mparam","line":267,"kind":13},{"kind":13,"line":267,"containerName":null,"name":"@fa"},{"containerName":null,"name":"@fc","kind":13,"line":267},{"line":267,"kind":13,"containerName":null,"name":"@fg"},{"containerName":null,"name":"@ft","kind":13,"line":267},{"kind":13,"line":267,"containerName":null,"name":"$id"},{"name":"$desc","containerName":null,"line":267,"kind":13},{"containerName":null,"name":"$a","line":268,"kind":13},{"name":"$c","containerName":null,"kind":13,"line":268},{"name":"$g","containerName":null,"kind":13,"line":268},{"containerName":null,"name":"%t","kind":13,"line":268},{"containerName":null,"name":"%mparam","line":271,"kind":13},{"containerName":null,"name":"$a","kind":13,"line":271},{"kind":13,"line":271,"name":"$c","containerName":null},{"kind":13,"line":271,"name":"$g","containerName":null},{"containerName":null,"name":"$t","line":271,"kind":13},{"containerName":null,"name":"$id","line":271,"kind":13},{"kind":13,"line":271,"name":"$desc","containerName":null},{"kind":12,"line":273,"containerName":"Matrix::PSM::SiteMatrix","name":"Bio"},{"name":"%mparam","containerName":null,"kind":13,"line":273},{"kind":12,"line":276,"children":[{"line":277,"kind":13,"localvar":"my","name":"$mdata","definition":"my","containerName":"_rearrange_matrix"},{"localvar":"my","name":"@a","definition":"my","containerName":"_rearrange_matrix","line":278,"kind":13},{"containerName":"_rearrange_matrix","name":"@c","line":278,"kind":13},{"kind":13,"line":278,"containerName":"_rearrange_matrix","name":"@g"},{"line":278,"kind":13,"containerName":"_rearrange_matrix","name":"@t"},{"localvar":"my","containerName":"_rearrange_matrix","definition":"my","name":"$entry","line":279,"kind":13},{"name":"$mdata","containerName":"_rearrange_matrix","kind":13,"line":279}],"containerName":"main::","name":"_rearrange_matrix","definition":"sub","range":{"start":{"line":276,"character":0},"end":{"line":279,"character":9999}}},{"containerName":null,"definition":"my","name":"$a","localvar":"my","kind":13,"line":280},{"line":280,"kind":13,"name":"$c","containerName":null},{"name":"$g","containerName":null,"kind":13,"line":280},{"name":"$t","containerName":null,"line":280,"kind":13},{"line":280,"kind":13,"containerName":null,"name":"$entry"},{"containerName":null,"name":"@a","line":281,"kind":13},{"name":"$a","containerName":null,"kind":13,"line":281},{"containerName":null,"name":"@c","kind":13,"line":282},{"line":282,"kind":13,"name":"$c","containerName":null},{"line":283,"kind":13,"name":"@g","containerName":null},{"name":"$g","containerName":null,"line":283,"kind":13},{"line":284,"kind":13,"containerName":null,"name":"@t"},{"containerName":null,"name":"$t","line":284,"kind":13},{"name":"@a","containerName":null,"kind":13,"line":286},{"line":286,"kind":13,"containerName":null,"name":"@c"},{"name":"@g","containerName":null,"kind":13,"line":286},{"name":"@t","containerName":null,"kind":13,"line":286},{"range":{"end":{"line":299,"character":9999},"start":{"line":290,"character":0}},"containerName":"main::","name":"_count_positions","definition":"sub","line":290,"children":[{"localvar":"my","definition":"my","name":"$seq","containerName":"_count_positions","line":291,"kind":13},{"localvar":"my","definition":"my","name":"%pos","containerName":"_count_positions","line":292,"kind":13},{"kind":13,"line":293,"name":"$l","definition":"my","containerName":"_count_positions","localvar":"my"},{"name":"$seq","containerName":"_count_positions","line":293,"kind":13},{"localvar":"my","containerName":"_count_positions","name":"$i","definition":"my","line":294,"kind":13},{"kind":13,"line":294,"name":"$i","containerName":"_count_positions"},{"line":294,"kind":13,"containerName":"_count_positions","name":"$l"},{"name":"$i","containerName":"_count_positions","line":294,"kind":13},{"name":"$pos","containerName":"_count_positions","line":296,"kind":13},{"name":"$i","containerName":"_count_positions","kind":13,"line":296},{"line":299,"kind":13,"localvar":"my","name":"$sequence","definition":"my","containerName":"_count_positions"},{"kind":13,"line":299,"containerName":"_count_positions","name":"$seq"}],"kind":12},{"kind":13,"line":300,"containerName":null,"name":"@let","definition":"my","localvar":"my"},{"line":300,"kind":13,"containerName":null,"name":"$sequence"},{"kind":13,"line":301,"name":"$i","definition":"my","containerName":null,"localvar":"my"},{"name":"let","kind":12,"line":301},{"name":"%pos","containerName":null,"line":302,"kind":13},{"name":"@let","containerName":null,"line":302,"kind":13},{"kind":13,"line":302,"name":"@i","containerName":null},{"containerName":null,"name":"$i","line":302,"kind":13},{"line":305,"kind":13,"name":"%pos","containerName":null},{"line":305,"kind":13,"name":"%pos","containerName":null},{"line":305,"kind":13,"containerName":null,"name":"%pos"},{"containerName":null,"name":"%pos","line":305,"kind":13},{"line":309,"children":[{"localvar":"my","name":"$h","definition":"my","containerName":"_freq_to_count","line":310,"kind":13},{"line":311,"kind":13,"localvar":"my","containerName":"_freq_to_count","definition":"my","name":"$a"},{"containerName":"_freq_to_count","name":"$h","line":311,"kind":13},{"kind":13,"line":312,"containerName":"_freq_to_count","definition":"my","name":"$c","localvar":"my"},{"name":"$h","containerName":"_freq_to_count","kind":13,"line":312},{"line":313,"kind":13,"localvar":"my","containerName":"_freq_to_count","name":"$g","definition":"my"},{"name":"$h","containerName":"_freq_to_count","kind":13,"line":313},{"kind":13,"line":314,"definition":"my","name":"$t","containerName":"_freq_to_count","localvar":"my"},{"containerName":"_freq_to_count","name":"$h","line":314,"kind":13},{"line":315,"kind":13,"containerName":"_freq_to_count","name":"$a"},{"containerName":"_freq_to_count","name":"$c","line":315,"kind":13},{"line":315,"kind":13,"containerName":"_freq_to_count","name":"$g"},{"name":"$t","containerName":"_freq_to_count","kind":13,"line":315}],"kind":12,"range":{"end":{"line":316,"character":9999},"start":{"line":309,"character":0}},"containerName":"main::","definition":"sub","name":"_freq_to_count"},{"line":311,"kind":12,"name":"pA"},{"kind":12,"line":312,"name":"pC"},{"line":313,"kind":12,"name":"pG"},{"name":"pT","kind":12,"line":314}]}